/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.validate.position;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.ext.BosPositionValidateReq;
import kd.hr.hbp.common.ext.BosPositionValidateResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;

public class BosPositionBillValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(BosPositionBillValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length == 0) {
            LOGGER.info("dataEntities is empty");
            return;
        }
        Arrays.stream(dataEntities).forEach(dataEntity -> dataEntity.getDataEntity().set("id", (Object)0L));
        if (IBosPositionService.getInstance().isDisableSyncPlatformPosition()) {
            return;
        }
        DynamicObject[] positionBills = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList()).toArray(new DynamicObject[0]);
        List positionVidList = Arrays.stream(positionBills).map(positionBill -> positionBill.getLong("hisnewversion")).filter(vid -> vid != 0L).collect(Collectors.toList());
        int size = positionVidList.size();
        HashMap<Long, Long> vidAndBoIdMap = new HashMap<Long, Long>(size);
        HashMap updateHisCurPositionMap = new HashMap(size);
        if (CollectionUtils.isNotEmpty(positionVidList)) {
            LOGGER.info("positionVidList:{}", positionVidList);
            PositionQueryRepository positionQueryRepository = PositionQueryRepository.getInstance();
            Map hisPositionMap = positionQueryRepository.queryVersionIdAndPositionMap(positionVidList);
            vidAndBoIdMap.putAll(hisPositionMap.values().stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("boid"), (v1, v2) -> v1)));
            ArrayList curPositionIds = new ArrayList(vidAndBoIdMap.values());
            HashMap<Long, DynamicObject> curPositionMap = new HashMap<Long, DynamicObject>(curPositionIds.size());
            DynamicObject[] curPositions = positionQueryRepository.queryCurEffectingPosition(curPositionIds, String.join((CharSequence)",", "adminorg.id", "boid", "bsed"));
            if (curPositions.length > 0) {
                curPositionMap.putAll(Arrays.stream(curPositions).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v1)));
                Arrays.stream(positionBills).forEach(positionBill -> {
                    Long positionId;
                    DynamicObject curPosition;
                    long positionVid = positionBill.getLong("hisnewversion");
                    if (vidAndBoIdMap.containsKey(positionVid) && !HRObjectUtils.isEmpty((Object)(curPosition = (DynamicObject)curPositionMap.get(positionId = (Long)vidAndBoIdMap.get(positionVid)))) && HRDateTimeUtils.dayBefore((Date)positionBill.getDate("bsed"), (Date)curPosition.getDate("bsed"))) {
                        updateHisCurPositionMap.put(positionId, curPosition);
                    }
                });
            }
        }
        List reqs = Arrays.stream(positionBills).map(positionBill -> {
            BosPositionValidateReq req = new BosPositionValidateReq();
            long positionVid = positionBill.getLong("hisnewversion");
            ILocaleString positionName = positionBill.getLocaleString("name");
            String positionNumber = positionBill.getString("number");
            long positionOrgId = positionBill.getLong("adminorg.id");
            req.setPosition(positionBill);
            if (vidAndBoIdMap.containsKey(positionVid)) {
                long positionId = (Long)vidAndBoIdMap.get(positionVid);
                req.setPositionId(positionId);
                if (updateHisCurPositionMap.containsKey(positionId)) {
                    DynamicObject curPosition = (DynamicObject)updateHisCurPositionMap.get(positionId);
                    req.setPosition(curPosition);
                    positionName = curPosition.getLocaleString("name");
                    positionNumber = curPosition.getString("number");
                    positionOrgId = curPosition.getLong("adminorg.id");
                }
            }
            req.setPositionOrgId(positionOrgId);
            req.setPositionNumber(positionNumber);
            req.setPositionName(positionName);
            return req;
        }).collect(Collectors.toList());
        List results = IBosPositionService.getInstance().bosPositionValidate(reqs);
        if (results.size() == 0) {
            LOGGER.error("results is empty");
            return;
        }
        for (int i = 0; i < dataEntities.length; ++i) {
            BosPositionValidateResult result = (BosPositionValidateResult)results.get(i);
            ExtendedDataEntity dataEntity2 = dataEntities[i];
            if (!result.getResult()) {
                this.addFatalErrorMessage(dataEntity2, result.getMessage());
                continue;
            }
            DynamicObject positionBill2 = dataEntity2.getDataEntity();
            long positionVid = positionBill2.getLong("hisnewversion");
            long bosPositionId = result.getBosPositionId();
            if (positionVid != 0L || bosPositionId == 0L) continue;
            positionBill2.set("id", (Object)bosPositionId);
        }
    }
}

