/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.validate.position;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.homs.business.service.position.IPositionValidateService;
import kd.hr.homs.business.service.position.PositionValidateServiceImpl;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.domain.repository.position.PositionTplFieldRepository;
import kd.hrmp.hbpm.business.service.position.IPositionTplApplicationScopeService;
import kd.hrmp.hbpm.business.service.position.PositionTplApplicationScopeServiceImpl;
import kd.hrmp.hbpm.business.utils.SystemParamHelper;
import kd.hrmp.hbpm.common.constants.JobLevelGradeTextEnum;
import kd.hrmp.hbpm.opplugin.web.validate.basedata.PositionValidatorServiceHelper;

public class PositioImportWithTplValidator
extends HRDataBaseValidator {
    private PositionValidatorServiceHelper positionValidatorServiceHelper = new PositionValidatorServiceHelper();
    private IPositionValidateService positionValidateService = new PositionValidateServiceImpl();
    private IPositionTplApplicationScopeService tplService = new PositionTplApplicationScopeServiceImpl();

    public void validate() {
        boolean importNew = HRStringUtils.equals((String)((String)this.getOption().getVariables().get("importtype")), (String)"new");
        List<ExtendedDataEntity> dataList = this.getValidateData();
        if (dataList.size() == 0) {
            return;
        }
        List tplIds = dataList.stream().filter(data -> data.getDataEntity().getDynamicObject("positiontpl") != null).map(data -> data.getDataEntity().getLong("positiontpl.id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tplIds) && !importNew) {
            return;
        }
        List orgIdList = dataList.stream().map(data -> data.getDataEntity().getLong("adminorg.org.id")).collect(Collectors.toList());
        Map batchParameter = SystemParamHelper.getBatchParameter(orgIdList);
        DynamicObject[] field = PositionTplFieldRepository.getInstance().queryAll();
        HRBaseServiceHelper tplBaseServiceHelper = new HRBaseServiceHelper("hbpm_positiontpl");
        DynamicObject[] tpls = tplBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", tplIds)});
        Map<Long, DynamicObject> tplMap = Arrays.stream(tpls).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>();
        Map<String, List<String>> numberToFieldsMap = this.getNumberToFieldsMap();
        Map<String, String> fieldToNameMap = this.getFieldToNameMap();
        for (ExtendedDataEntity data2 : dataList) {
            DynamicObject pos = data2.getDataEntity();
            Long tplId = pos.getLong("positiontpl.id");
            DynamicObject tpl = tplMap.get(tplId);
            DynamicObject adminorg = pos.getDynamicObject("adminorg");
            long orgId = adminorg.getLong("org.id");
            Map parameter = batchParameter.getOrDefault(String.valueOf(orgId), Maps.newHashMap());
            boolean openpositiontpl = (Boolean)parameter.get("openpositiontpl");
            if (!openpositiontpl && tpl != null && importNew) {
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5bf9\u5e94\u884c\u653f\u7ec4\u7ec7\u4e0b\u7684\u5c97\u4f4d\u65e0\u9700\u901a\u8fc7\u6a21\u677f\u521b\u5efa\uff0c\u8bf7\u6e05\u7a7a\u5c97\u4f4d\u6a21\u677f\u6570\u636e\u3002", (String)"PositioImportWithTplValidator_0", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(data2, msg);
                continue;
            }
            if (!openpositiontpl) continue;
            boolean mustUseTpl = this.positionValidateService.openDialogOrPositionBill(Long.valueOf(adminorg.getLong("id"))).test(parameter);
            if (mustUseTpl && tpl == null && importNew) {
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5bf9\u5e94\u884c\u653f\u7ec4\u7ec7\u4e0b\u7684\u5c97\u4f4d\u9700\u901a\u8fc7\u6a21\u677f\u521b\u5efa\uff0c\u8bf7\u586b\u5199\u5c97\u4f4d\u6a21\u677f\u3002", (String)"PositioImportWithTplValidator_1", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(data2, msg);
                continue;
            }
            String radiogroupfield = (String)parameter.get("radiogroupfield");
            if (!mustUseTpl && "2".equals(radiogroupfield) && tpl != null && importNew) {
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5bf9\u5e94\u884c\u653f\u7ec4\u7ec7\u4e0b\u7684\u5c97\u4f4d\u65e0\u9700\u901a\u8fc7\u6a21\u677f\u521b\u5efa\uff0c\u8bf7\u6e05\u7a7a\u5c97\u4f4d\u6a21\u677f\u6570\u636e\u3002", (String)"PositioImportWithTplValidator_2", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(data2, msg);
                continue;
            }
            if (tpl == null) continue;
            boolean isInScope = this.tplService.contansApplicationScope(Long.valueOf(tpl.getLong("id")), Long.valueOf(adminorg.getLong("id")), adminorg.getString("structlongnumber"));
            if (!isInScope && importNew) {
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5bf9\u5e94\u884c\u653f\u7ec4\u7ec7\u4e0d\u5728\u586b\u5199\u7684\u5c97\u4f4d\u6a21\u677f\u9002\u7528\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u884c\u653f\u7ec4\u7ec7\u4e0e\u5c97\u4f4d\u6a21\u677f\u7684\u503c\u662f\u5426\u6b63\u786e\u3002", (String)"PositioImportWithTplValidator_3", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(data2, msg);
                continue;
            }
            DynamicObjectCollection fieldrange = tpl.getDynamicObjectCollection("fieldrange");
            List notFillNumberList = fieldrange.stream().map(temp -> temp.getString("fbasedataid.number")).collect(Collectors.toList());
            List<String> numberList = Arrays.stream(field).map(temp -> temp.getString("number")).collect(Collectors.toList());
            numberList.removeAll(notFillNumberList);
            if (numberList.contains("jobgraderange")) {
                numberList.add(JobLevelGradeTextEnum.GRADE.getLowSign());
                numberList.add(JobLevelGradeTextEnum.GRADE.getHighSign());
            }
            if (numberList.contains("joblevelrange")) {
                numberList.add(JobLevelGradeTextEnum.LEVEL.getLowSign());
                numberList.add(JobLevelGradeTextEnum.LEVEL.getHighSign());
            }
            if (importNew) {
                for (String number : numberList) {
                    if (tpl.containsProperty(number) && pos.containsProperty(number)) {
                        pos.set(number, tpl.get(number));
                    }
                    if (HRStringUtils.equals((String)number, (String)JobLevelGradeTextEnum.GRADE.getLowSign())) {
                        DynamicObject lowGrade = tpl.getDynamicObject(number);
                        if (!(numberList.contains("jobscm") && tpl.getDynamicObject("jobscm") != null || lowGrade == null)) {
                            pos.set("jobgradescm", (Object)lowGrade.getDynamicObject("jobgradescm"));
                        }
                    }
                    if (!HRStringUtils.equals((String)number, (String)JobLevelGradeTextEnum.LEVEL.getLowSign())) continue;
                    DynamicObject lowLevel = tpl.getDynamicObject(number);
                    if (numberList.contains("jobscm") && tpl.getDynamicObject("jobscm") != null || lowLevel == null) continue;
                    pos.set("joblevelscm", (Object)lowLevel.getDynamicObject("joblevelscm"));
                }
                this.resetLevelGradeText(pos, numberList);
                dataEntities.add(pos);
                continue;
            }
            String posNumber = pos.getString("number");
            List updateFields = numberToFieldsMap.getOrDefault(posNumber, new ArrayList());
            for (String number : numberList) {
                if (!updateFields.contains(number)) continue;
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e0d\u5728\u5c97\u4f4d\u6a21\u677f\u7684\u53ef\u4fee\u6539\u5b57\u6bb5\u8303\u56f4\uff0c\u4e0d\u53ef\u53d8\u66f4\uff0c\u8bf7\u6e05\u7a7a\u3002", (String)"PositioImportWithTplValidator_4", (String)"hrmp-hbpm-opplugin", (Object[])new Object[0]), fieldToNameMap.get(number));
                this.addFatalErrorMessage(data2, msg);
            }
        }
        if (importNew) {
            new PositionServiceApplicationImpl().setMustInputFieldDefaultValue(dataEntities.toArray(new DynamicObject[0]));
        }
    }

    private void resetLevelGradeText(DynamicObject pos, List<String> tplFillFieldNumberList) {
        ArrayList<String> needRepalceEmptySign = new ArrayList<String>();
        if (tplFillFieldNumberList.contains(JobLevelGradeTextEnum.GRADE.getLowSign())) {
            pos.set(JobLevelGradeTextEnum.GRADE.getLowTextSign(), (Object)"");
            needRepalceEmptySign.add(JobLevelGradeTextEnum.GRADE.getLowTextNullSign());
        }
        if (tplFillFieldNumberList.contains(JobLevelGradeTextEnum.GRADE.getHighSign())) {
            pos.set(JobLevelGradeTextEnum.GRADE.getHighTextSign(), (Object)"");
            needRepalceEmptySign.add(JobLevelGradeTextEnum.GRADE.getHighTextNullSign());
        }
        if (tplFillFieldNumberList.contains(JobLevelGradeTextEnum.LEVEL.getLowSign())) {
            pos.set(JobLevelGradeTextEnum.LEVEL.getLowTextSign(), (Object)"");
            needRepalceEmptySign.add(JobLevelGradeTextEnum.LEVEL.getLowTextNullSign());
        }
        if (tplFillFieldNumberList.contains(JobLevelGradeTextEnum.LEVEL.getHighSign())) {
            pos.set(JobLevelGradeTextEnum.LEVEL.getHighTextSign(), (Object)"");
            needRepalceEmptySign.add(JobLevelGradeTextEnum.LEVEL.getHighTextNullSign());
        }
        for (String nullSign : needRepalceEmptySign) {
            String levelGradeText = pos.getString("levelgradetext");
            pos.set("levelgradetext", (Object)levelGradeText.replace(nullSign, ""));
        }
    }

    private List<ExtendedDataEntity> getValidateData() {
        ExtendedDataEntity[] dataArr = this.getDataEntities();
        ArrayList<ExtendedDataEntity> dataList = new ArrayList<ExtendedDataEntity>(Arrays.asList(dataArr));
        String importtype = (String)this.getOption().getVariables().get("importtype");
        for (ExtendedDataEntity data : dataList) {
            DynamicObject position = data.getDataEntity();
            this.validateOrgNotNull(position, data);
            if (!HRStringUtils.equals((String)"new", (String)importtype)) continue;
            this.validateAdminorgNotNull(position, data);
        }
        List<ExtendedDataEntity> falseDataentity = this.getFalseExtendedDataEntity();
        if (!CollectionUtils.isEmpty(falseDataentity)) {
            dataList.removeAll(falseDataentity);
        }
        return dataList;
    }

    private void validateOrgNotNull(DynamicObject position, ExtendedDataEntity data) {
        DynamicObject adminOrg = position.getDynamicObject("adminorg");
        if (HRObjectUtils.isEmpty((Object)adminOrg)) {
            return;
        }
        String msg = this.positionValidatorServiceHelper.validateOrgNotNull(adminOrg.getDynamicObject("org"));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateAdminorgNotNull(DynamicObject position, ExtendedDataEntity data) {
        DynamicObject adminOrg = position.getDynamicObject("adminorg");
        String msg = this.positionValidatorServiceHelper.validateAdminorgNotNull(adminOrg);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private List<ExtendedDataEntity> getFalseExtendedDataEntity() {
        ValidateResultCollection resultCollection = this.getValidateContext().getValidateResults();
        if (resultCollection == null) {
            return new ArrayList<ExtendedDataEntity>();
        }
        HashSet falseSet = this.getValidateContext().getValidateResults().getErrorDataIndexs();
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)falseSet)) {
            ArrayList<ExtendedDataEntity> falseList = new ArrayList<ExtendedDataEntity>(falseSet.size());
            falseSet.forEach(id -> falseList.add(extendedDataEntities[id]));
            return falseList;
        }
        return new ArrayList<ExtendedDataEntity>();
    }

    private Map<String, List<String>> getNumberToFieldsMap() {
        Map numberToFieldsMap = (Map)HRAppCache.get((String)"hbpm").get("IMPORT_UPD_NUMBER_FIELDS" + RequestContext.get().getTraceId(), Map.class);
        HRAppCache.get((String)"hbpm").remove("IMPORT_UPD_NUMBER_FIELDS");
        if (numberToFieldsMap == null) {
            return new HashMap<String, List<String>>();
        }
        return numberToFieldsMap;
    }

    private Map<String, String> getFieldToNameMap() {
        Map fieldToNameMap = (Map)HRAppCache.get((String)"hbpm").get("IMPORT_UPD_FIELDS_NAME" + RequestContext.get().getTraceId(), Map.class);
        HRAppCache.get((String)"hbpm").remove("IMPORT_UPD_FIELDS_NAME");
        if (fieldToNameMap == null) {
            return new HashMap<String, String>();
        }
        return fieldToNameMap;
    }
}

