/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.validate.position;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.opplugin.web.validate.position.PositionBillValidator;
import kd.hrmp.hbpm.business.domain.repository.position.PositionBillQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class PositionBillChangeValidator
extends PositionBillValidator {
    @Override
    protected void validatePostProcessor(ExtendedDataEntity[] dataEntities) {
        List positionIds = Arrays.stream(dataEntities).map(data -> data.getDataEntity().getLong("hisnewversion")).collect(Collectors.toList());
        Object[] positions = PositionQueryRepository.getInstance().queryPositionsById(positionIds);
        if (ArrayUtils.isEmpty((Object[])positions)) {
            return;
        }
        Map<Long, Long> idToBoIdMap = Arrays.stream(positions).collect(Collectors.toMap(pos -> pos.getLong("id"), pos -> pos.getLong("boid")));
        DynamicObject[] boFirstBsedArr = PositionQueryRepository.getInstance().queryPositionsPropsByIds("id,firstbsed,bsed,parent", new HashSet<Long>(idToBoIdMap.values()));
        Map<Long, DynamicObject> boToBsedMap = Arrays.stream(boFirstBsedArr).collect(Collectors.toMap(pos -> pos.getLong("id"), pos -> pos));
        List positionNumbers = Arrays.stream(dataEntities).map(data -> data.getDataEntity().getString("number")).collect(Collectors.toList());
        Map numberAndPositionMap = PositionBillQueryRepository.getInstance().queryPositionByNumbers(positionNumbers);
        String changeType = this.getOption().getVariableValue("changetype", "propertychange");
        for (ExtendedDataEntity data2 : dataEntities) {
            DynamicObject positionBill = data2.getDataEntity();
            this.validateNumberUnique(positionBill, numberAndPositionMap, idToBoIdMap, data2);
            this.validateBsed(positionBill, idToBoIdMap, data2, boToBsedMap);
            if (!HRStringUtils.equals((String)changeType, (String)"reportchange")) continue;
            this.validateBSedLessAssignDate(positionBill, data2);
        }
    }

    private void validateBSedLessAssignDate(DynamicObject positionBill, ExtendedDataEntity data) {
        String msg = this.positionBillValidatorServiceHelper.validateBSedLessAssignDate(positionBill.getDate("bsed"), PositionUtils.getCurrentDate());
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateBsed(DynamicObject positionBill, Map<Long, Long> idToBoIdMap, ExtendedDataEntity data, Map<Long, DynamicObject> boToFirstBsedMap) {
        String msg;
        DynamicObject bo = boToFirstBsedMap.get(idToBoIdMap.get(positionBill.getLong("hisnewversion")));
        if (bo == null) {
            return;
        }
        Date bsedFromDB = bo.getDate("bsed");
        if (positionBill.getDate("bsed").before(bsedFromDB) && StringUtils.isNotEmpty((CharSequence)(msg = this.positionBillValidatorServiceHelper.validateParentIsModifier(positionBill.getLong("parent.id"), bo.getLong("parent.id"), bsedFromDB)))) {
            this.addFatalErrorMessage(data, msg);
        }
        Date firstBsed = bo.getDate("firstbsed");
        String msg2 = this.positionBillValidatorServiceHelper.validateFirstBsed(positionBill.getDate("bsed"), firstBsed);
        if (StringUtils.isNotEmpty((CharSequence)msg2)) {
            this.addFatalErrorMessage(data, msg2);
        }
    }

    private void validateNumberUnique(DynamicObject positionBill, Map<String, Set<Long>> numberAndPositionBillMap, Map<Long, Long> idToBoIdMap, ExtendedDataEntity data) {
        if (CollectionUtils.isEmpty(numberAndPositionBillMap)) {
            return;
        }
        if (positionBill.getLong("hisnewversion") == 0L) {
            return;
        }
        Long boId = idToBoIdMap.get(positionBill.getLong("hisnewversion"));
        String msg = this.positionBillValidatorServiceHelper.validateNumberUnique(boId, positionBill.getString("number"), numberAndPositionBillMap.get(positionBill.getString("number")));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }
}

