/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.validate.position;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.homs.opplugin.web.validate.position.PositionBillValidator;
import kd.hrmp.hbpm.business.domain.repository.position.PositionBillQueryRepository;

public class PositionBillSaveValidator
extends PositionBillValidator {
    @Override
    protected void validatePostProcessor(ExtendedDataEntity[] dataEntities) {
        List positionNumbers = Arrays.stream(dataEntities).map(data -> data.getDataEntity().getString("number")).collect(Collectors.toList());
        Map numberAndPositionMap = PositionBillQueryRepository.getInstance().queryPositionByNumbers(positionNumbers);
        for (ExtendedDataEntity data2 : dataEntities) {
            DynamicObject positionBill = data2.getDataEntity();
            this.validateNumberUnique(positionBill, numberAndPositionMap, data2);
        }
    }

    private void validateNumberUnique(DynamicObject positionBill, Map<String, Set<Long>> numberAndPositionBillMap, ExtendedDataEntity data) {
        if (CollectionUtils.isEmpty(numberAndPositionBillMap) || CollectionUtils.isEmpty((Collection)numberAndPositionBillMap.get(positionBill.getString("number")))) {
            return;
        }
        String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionBillSaveValidator_1", (String)"odc-homs-opplugin", (Object[])new Object[0]), positionBill.getString("number"));
        this.addFatalErrorMessage(data, msg);
    }
}

