/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.validate.position;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.homs.opplugin.web.validate.position.PositionBillValidatorServiceHelper;
import kd.hrmp.hbpm.business.utils.PositionPermissionUtil;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class PositionBillValidator
extends AbstractValidator {
    public ExtendedDataEntity[] dataEntities;
    public PositionBillValidatorServiceHelper positionBillValidatorServiceHelper;

    public void validate() {
        this.positionBillValidatorServiceHelper = new PositionBillValidatorServiceHelper();
        this.dataEntities = this.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])this.dataEntities)) {
            return;
        }
        HasPermOrgResult posHasPermOrg = PositionPermissionUtil.getPosHasPermOrg();
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject positionBill = data.getDataEntity();
            this.validateParentPositionEnable(positionBill, data);
            this.validateBSedAndEstablishmentDate(positionBill, data);
            this.validateEstablishLessParentFirstBsed(positionBill, data);
            this.validateBSedAndAdminOrgEstablishmentDate(positionBill, data);
            this.validateOrgNotNull(positionBill, data);
            this.validateOrgHasPerm(positionBill, data, posHasPermOrg);
            this.validateEntryEntity(positionBill, data);
            this.validateAdminorgIsvirtual(positionBill, data);
            this.validateOther(positionBill, data);
        }
        this.validatePostProcessor(this.dataEntities);
    }

    protected void validateOther(DynamicObject positionBill, ExtendedDataEntity data) {
    }

    protected void validatePostProcessor(ExtendedDataEntity[] dataEntities) {
    }

    private void validateParentPositionEnable(DynamicObject positionBill, ExtendedDataEntity data) {
        DynamicObject parentPosition = positionBill.getDynamicObject("parent");
        String msg = this.positionBillValidatorServiceHelper.validateParentPositionEnable(parentPosition, positionBill.getString("name"));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateBSedAndEstablishmentDate(DynamicObject positionBill, ExtendedDataEntity data) {
        String msg = this.positionBillValidatorServiceHelper.validateBSedAndEstablishmentDate(positionBill.getDate("bsed"), positionBill.getDate("establishmentdate"));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateEstablishLessParentFirstBsed(DynamicObject positionBill, ExtendedDataEntity data) {
        String message = this.positionBillValidatorServiceHelper.validateEstablishLessParentFirstBsed(positionBill.getDate("bsed"), positionBill.getDynamicObject("parent"));
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.addFatalErrorMessage(data, message);
        }
    }

    private void validateBSedAndAdminOrgEstablishmentDate(DynamicObject positionBill, ExtendedDataEntity data) {
        String msg;
        if (positionBill.getDate("bsed").before(PositionUtils.getCurrentDate()) && StringUtils.isNotEmpty((CharSequence)(msg = this.positionBillValidatorServiceHelper.validateBSedAndAdminOrgEstablishmentDate(positionBill.getDate("bsed"), positionBill.getDynamicObject("adminorg"))))) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateOrgNotNull(DynamicObject positionBill, ExtendedDataEntity data) {
        String msg = this.positionBillValidatorServiceHelper.validateOrgNotNull(positionBill.getDynamicObject("org"));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateOrgHasPerm(DynamicObject positionBill, ExtendedDataEntity data, HasPermOrgResult posHasPermOrg) {
        String msg = this.positionBillValidatorServiceHelper.validateOrgHasPerm(positionBill.getDynamicObject("org"), posHasPermOrg);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateEntryEntity(DynamicObject positionBill, ExtendedDataEntity data) {
        DynamicObjectCollection entryEntity = positionBill.getDynamicObjectCollection("entryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            ArrayList reportTypeIds = Lists.newArrayListWithExpectedSize((int)8);
            for (DynamicObject entity : entryEntity) {
                String targetWorkRoleUniqueMessage;
                String targetWorkRoleEnableMessage;
                String targetWorkRoleMessage;
                DynamicObject reportType = entity.getDynamicObject("reporttype");
                DynamicObject targetWorkRole = entity.getDynamicObject("targetworkrole");
                String reportTypeMessage = this.positionBillValidatorServiceHelper.validateMustForReportType(reportType);
                if (StringUtils.isNotEmpty((CharSequence)reportTypeMessage)) {
                    this.addFatalErrorMessage(data, reportTypeMessage);
                }
                if (StringUtils.isNotEmpty((CharSequence)(targetWorkRoleMessage = this.positionBillValidatorServiceHelper.validateMustForTargetWorkRole(targetWorkRole)))) {
                    this.addFatalErrorMessage(data, targetWorkRoleMessage);
                }
                if (StringUtils.isNotEmpty((CharSequence)(targetWorkRoleEnableMessage = this.positionBillValidatorServiceHelper.validateTargetWorkRoleEnable(targetWorkRole, reportType)))) {
                    this.addFatalErrorMessage(data, targetWorkRoleEnableMessage);
                }
                if (!StringUtils.isNotEmpty((CharSequence)(targetWorkRoleUniqueMessage = this.positionBillValidatorServiceHelper.validateReportTypeUnique(reportTypeIds, reportType)))) continue;
                this.addFatalErrorMessage(data, targetWorkRoleUniqueMessage);
            }
        }
    }

    private void validateAdminorgIsvirtual(DynamicObject positionBill, ExtendedDataEntity data) {
        DynamicObject adminOrg = positionBill.getDynamicObject("adminorg");
        String msg = this.positionBillValidatorServiceHelper.validateAdminorgIsvirtual(adminOrg);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }
}

