/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.validate.position;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.opplugin.web.validate.position.PositionBillValidator;
import kd.hrmp.hbpm.business.domain.repository.position.PositionBillQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class PositionFutureModifyValidator
extends PositionBillValidator {
    @Override
    protected void validatePostProcessor(ExtendedDataEntity[] dataEntities) {
        List positionIds = Arrays.stream(dataEntities).map(data -> data.getDataEntity().getLong("hisnewversion")).collect(Collectors.toList());
        Object[] positions = PositionQueryRepository.getInstance().queryPositionsById(positionIds);
        if (ArrayUtils.isEmpty((Object[])positions)) {
            return;
        }
        Map positionMap = PositionUtils.listToMap(Arrays.asList(positions), (String)"id");
        List positionNumbers = Arrays.stream(dataEntities).map(data -> data.getDataEntity().getString("number")).collect(Collectors.toList());
        Map numberAndPositionMap = PositionBillQueryRepository.getInstance().queryPositionByNumbers(positionNumbers);
        for (ExtendedDataEntity data2 : dataEntities) {
            DynamicObject positionBill = data2.getDataEntity();
            this.validateNumberUnique(positionBill, numberAndPositionMap, positionMap, data2);
        }
    }

    @Override
    protected void validateOther(DynamicObject positionBill, ExtendedDataEntity data) {
        super.validateOther(positionBill, data);
        this.validateFutureModify(positionBill, data);
    }

    private void validateNumberUnique(DynamicObject positionBill, Map<String, Set<Long>> numberAndPositionBillMap, Map<Long, DynamicObject> positionMap, ExtendedDataEntity data) {
        if (CollectionUtils.isEmpty(numberAndPositionBillMap)) {
            return;
        }
        if (positionBill.getLong("hisnewversion") == 0L) {
            return;
        }
        DynamicObject position = positionMap.get(positionBill.getLong("hisnewversion"));
        String msg = this.positionBillValidatorServiceHelper.validateNumberUnique(position.getLong("boid"), positionBill.getString("number"), numberAndPositionBillMap.get(positionBill.getString("number")));
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
    }

    private void validateFutureModify(DynamicObject positionBill, ExtendedDataEntity data) {
        Long positionHisId = positionBill.getLong("hisnewversion");
        DynamicObject his = PositionQueryRepository.getInstance().queryDataById(positionHisId);
        DynamicObject effectingVersion = PositionQueryRepository.getInstance().queryDataById(Long.valueOf(his.getLong("boid")));
        String msg = this.positionBillValidatorServiceHelper.validateDataStatusFuture(his);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.addFatalErrorMessage(data, msg);
        }
        Date bsed = positionBill.getDate("bsed");
        if (HRStringUtils.equals((String)effectingVersion.getString("datastatus"), (String)"1")) {
            Date firstBsed;
            Date effectingVersionBsed = effectingVersion.getDate("bsed");
            msg = this.positionBillValidatorServiceHelper.validateBsedLessEffectingVersionBsed(bsed, effectingVersionBsed);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.addFatalErrorMessage(data, msg);
            }
            if (StringUtils.isNotEmpty((CharSequence)(msg = this.positionBillValidatorServiceHelper.validateFirstBsed(bsed, firstBsed = effectingVersion.getDate("firstbsed"))))) {
                this.addFatalErrorMessage(data, msg);
            }
        }
    }
}

