/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.domain.repository;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.HAOSBaseRepository;

public class OrgOperateTaskRepository
extends HAOSBaseRepository {
    private OrgOperateTaskRepository() {
        super("homs_orgoperatetask");
    }

    public static OrgOperateTaskRepository getInstance() {
        return Instance.INSTANCE;
    }

    public DynamicObject getOrgOperateTaskById(Long taskId) {
        return this.serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)taskId));
    }

    public DynamicObject getOrgOperateTaskByOrgId(Long orgId) {
        QFilter orgIdQF = new QFilter("adminorgid", "=", (Object)orgId);
        QFilter statusQf = new QFilter("savestatus", "in", (Object)new String[]{"1", "4"});
        return this.serviceHelper.loadDynamicObject(new QFilter[]{orgIdQF, statusQf});
    }

    public DynamicObject[] getOrgOperateTaskByParent(String structLongNumber) {
        String[] structNumberArr = structLongNumber.split("!");
        ArrayList<String> structLongNumberList = new ArrayList<String>(structNumberArr.length);
        structLongNumberList.add(structNumberArr[0]);
        for (int i = 1; i < structNumberArr.length - 1; ++i) {
            structLongNumberList.add((String)structLongNumberList.get(i - 1) + "!" + structNumberArr[i]);
        }
        QFilter orgIdQF = new QFilter("structlongnumber", "in", structLongNumberList);
        QFilter statusQf = new QFilter("savestatus", "in", (Object)new String[]{"1", "4"});
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{orgIdQF, statusQf});
    }

    public DynamicObject[] getChildrenOrgTaskByStructLongNumber(String structLongNumber) {
        QFilter orgIdQF = new QFilter("structlongnumber", "like", (Object)(structLongNumber + "%"));
        QFilter statusQf = new QFilter("savestatus", "in", (Object)new String[]{"1", "4"});
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{orgIdQF, statusQf});
    }

    public DynamicObject[] getAllOrgTaskByIng() {
        QFilter statusQf = new QFilter("savestatus", "in", (Object)new String[]{"1", "4"});
        return this.serviceHelper.query("id,adminorgid,structlongnumber", new QFilter[]{statusQf});
    }

    public Object[] update(DynamicObject[] dynamicObjects) {
        return this.serviceHelper.update(dynamicObjects);
    }

    private static class Instance {
        private static OrgOperateTaskRepository INSTANCE = new OrgOperateTaskRepository();

        private Instance() {
        }
    }
}

