/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.application.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.homs.business.service.application.IAdminOrgReviseLogApplication;
import kd.hr.homs.business.service.domain.helper.AdminOrgReviseLogHelper;
import kd.hr.homs.business.service.domain.repository.AdminOrgReviseLogRepository;

public class AdminOrgReviseLogApplicationImpl
implements IAdminOrgReviseLogApplication {
    private AdminOrgReviseLogRepository adminOrgReviseLogRepository = AdminOrgReviseLogRepository.getInstance();

    @Override
    public Map<Long, String> getLogContent(DynamicObjectCollection pageData) {
        Set<Long> reviseDataIdSet = pageData.stream().map(data -> data.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] reviseLogInfoArr = this.adminOrgReviseLogRepository.loadLogInfoById(reviseDataIdSet);
        HashMap orgReviseDetailMap = Maps.newHashMapWithExpectedSize((int)reviseLogInfoArr.length);
        HashMap orgReviseOrgMap = Maps.newHashMapWithExpectedSize((int)reviseLogInfoArr.length);
        for (DynamicObject reviseLogInfo : reviseLogInfoArr) {
            DynamicObjectCollection reviseDetailList2 = reviseLogInfo.getDynamicObjectCollection("entryentity");
            reviseDetailList2.forEach(reviseDetail -> orgReviseDetailMap.put(reviseDetail.getLong("id"), reviseDetail));
            DynamicObjectCollection reviseOrgList = reviseLogInfo.getDynamicObjectCollection("orgentryentity");
            orgReviseOrgMap.put(reviseLogInfo.getLong("id"), reviseOrgList);
        }
        HashMap orgReviseDetailEntityNameMap = new HashMap(reviseLogInfoArr.length);
        orgReviseDetailMap.values().stream().collect(Collectors.groupingBy(entry -> entry.getString("reviseentityname"), Collectors.toList())).forEach((entityName, reviseDetailList) -> {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
            ArrayList<String> reviseFieldNameList = new ArrayList<String>(reviseDetailList.size());
            reviseFieldNameList.add("bsed");
            reviseFieldNameList.add("bsled");
            ArrayList reviseBeforeAfter = new ArrayList(reviseDetailList.size());
            reviseDetailList.forEach(entry -> {
                reviseFieldNameList.add(entry.getString("revisefieldname"));
                reviseBeforeAfter.add(entry.getLong("revisebefore"));
                DynamicObjectCollection reviseAfterDynList = entry.getDynamicObjectCollection("reviseafter");
                reviseBeforeAfter.add(CollectionUtils.isEmpty((Collection)reviseAfterDynList) ? 0L : ((DynamicObject)reviseAfterDynList.get(0)).getLong("fbasedataid_id"));
            });
            QFilter filter = new QFilter("id", "in", reviseBeforeAfter);
            Map<Long, DynamicObject> reviseEntityMap = Arrays.stream(helper.query(String.join((CharSequence)",", reviseFieldNameList), filter.toArray())).collect(Collectors.toMap(entity -> entity.getLong("id"), entity -> entity));
            orgReviseDetailEntityNameMap.put(entityName, reviseEntityMap);
        });
        HashMap<Long, String> contentMap = new HashMap<Long, String>(pageData.size());
        Map<String, Map<String, IDataEntityProperty>> entityDisplayNameMap = AdminOrgReviseLogHelper.getPropertyNameFromEntity(orgReviseDetailEntityNameMap.keySet());
        for (DynamicObject data2 : pageData) {
            DynamicObjectCollection reviseAfterDynList;
            long reviseDetailId = data2.getLong("entryentity.id");
            DynamicObject detail = (DynamicObject)orgReviseDetailMap.get(reviseDetailId);
            String entityName2 = detail.getString("reviseentityname");
            String reviseFieldName = detail.getString("revisefieldname");
            Map reviseEntityMap = (Map)orgReviseDetailEntityNameMap.get(entityName2);
            Map<String, IDataEntityProperty> displayNameMap = entityDisplayNameMap.get(entityName2);
            IDataEntityProperty prop = displayNameMap.get(reviseFieldName);
            if (prop == null) continue;
            DynamicObjectCollection reviseOrgInfoList = (DynamicObjectCollection)orgReviseOrgMap.get(data2.getLong("id"));
            Date beforeEffDt = null;
            Date beforeEndDt = null;
            String beforeEffDtStr = "";
            String beforeEndDtStr = "";
            if (!CollectionUtils.isEmpty((Collection)reviseOrgInfoList)) {
                DynamicObject reviseOrgBefore = ((DynamicObject)reviseOrgInfoList.get(0)).getDynamicObject("beforeorg");
                String dateRangeMsg = "";
                if (reviseOrgBefore != null) {
                    beforeEffDt = reviseOrgBefore.getDate("bsed");
                    beforeEndDt = reviseOrgBefore.getDate("bsled");
                    beforeEffDtStr = HRInteDateTimeUtil.formatDate((String)reviseOrgBefore.getDataEntityType().getName(), (String)"bsed", (Date)beforeEffDt);
                    beforeEndDtStr = HRInteDateTimeUtil.formatDate((String)reviseOrgBefore.getDataEntityType().getName(), (String)"bsled", (Date)beforeEndDt);
                }
            }
            DynamicObject reviseAfter = (DynamicObject)reviseEntityMap.get(CollectionUtils.isEmpty((Collection)(reviseAfterDynList = detail.getDynamicObjectCollection("reviseafter"))) ? 0L : ((DynamicObject)reviseAfterDynList.get(0)).getLong("fbasedataid_id"));
            String propName = prop.getDisplayName().getLocaleValue();
            String propVal = null;
            if (reviseAfter != null) {
                propVal = AdminOrgReviseLogHelper.getFieldValueByProperty(reviseAfter, prop);
            }
            String msg = ResManager.loadKDString((String)"\u201c%1$s\u201d~\u201c%2$s\u201d\u7684\u5386\u53f2\u8bb0\u5f55\u7684\u201c%3$s\u201d\u4fee\u8ba2\u4e3a\u201c%4$s\u201d\u3002", (String)"AdminOrgReviseLogApplicationImpl_0", (String)"odc-homs-business", (Object[])new Object[0]);
            msg = String.format(msg, beforeEffDtStr, beforeEndDtStr, propName, propVal);
            contentMap.put(reviseDetailId, msg);
        }
        return contentMap;
    }

    @Override
    public void writeLog() {
    }

    @Override
    public void openLogList(IFormView view, Set<Long> orgIdSet) {
        ListShowParameter toShowParameter = new ListShowParameter();
        toShowParameter.setBillFormId("");
        toShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (!CollectionUtils.isEmpty(orgIdSet)) {
            toShowParameter.getCustomParams().put("adminOrgIds", orgIdSet.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        view.showForm((FormShowParameter)toShowParameter);
    }
}

