/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.homs.business.service.batcheffect.MethodHelper;
import kd.hr.homs.business.service.batcheffect.QueryHelper;
import kd.hr.homs.business.service.batcheffect.bo.AdminOrgData;
import kd.hr.homs.business.service.batcheffect.bo.AdminOrgDataEntryBO;
import kd.hr.homs.business.service.batcheffect.bo.BillData;
import kd.hr.homs.business.service.batcheffect.cascade.model.CascadeBo;
import kd.hr.homs.business.service.batcheffect.cascade.model.CascadeModel;
import kd.hr.homs.business.service.batcheffect.cascade.model.CascadeResult;
import kd.hr.homs.business.service.batcheffect.cascade.model.MasterCascadeModel;
import kd.hr.homs.business.service.batcheffect.cascade.model.SortCodeCascadeModel;
import kd.hr.homs.business.service.batcheffect.cascade.model.StructCascadeModel;
import kd.hr.homs.business.service.batcheffect.cascade.tree.DateRangeNode;

public class AdminOrgDataCreator {
    private BillData billData;
    private Map<Long, List<DateRangeNode<CascadeBo>>> boVsNodeList;
    private List<CascadeResult> cascadeResultList;
    private List<DynamicObject> virtualVersionDyList;
    private List<AdminOrgData> cascadeOrgDataList = new ArrayList<AdminOrgData>();
    private AdminOrgDataEntryBO entryOrgDataListBO = new AdminOrgDataEntryBO();
    private LocalDate localDate2999 = MethodHelper.getLocalDate2999();

    public void create() {
        this.doCreate();
        this.afterCreate();
    }

    private void doCreate() {
        HashSet<Long> orgIdSet = new HashSet<Long>();
        HashSet<Long> structIdSet = new HashSet<Long>();
        HashSet<Long> sortCodeIdSet = new HashSet<Long>();
        this.cascadeResultList.forEach(cascadeResult -> cascadeResult.getChangedCascadeModelList().forEach(cascadeModel -> {
            long vid = cascadeModel.getVid();
            if (cascadeModel instanceof MasterCascadeModel) {
                orgIdSet.add(vid);
            } else if (cascadeModel instanceof StructCascadeModel) {
                structIdSet.add(vid);
            } else if (cascadeModel instanceof SortCodeCascadeModel) {
                sortCodeIdSet.add(vid);
            }
        }));
        DynamicObject[] masterDys = QueryHelper.loadById(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), orgIdSet);
        DynamicObject[] structDys = QueryHelper.loadById(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), structIdSet);
        DynamicObject[] sortCodeDys = QueryHelper.loadById(AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), sortCodeIdSet);
        Map<Long, DynamicObject> idVsDy = Stream.of(Arrays.asList(masterDys), Arrays.asList(structDys), Arrays.asList(sortCodeDys), this.virtualVersionDyList).flatMap(Collection::stream).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        this.create4NoParentAdd(idVsDy);
        this.create4Effecting(idVsDy);
        this.create4Cascade(idVsDy);
    }

    private void afterCreate() {
        Set virtualHisAdOrgBoSet = this.virtualVersionDyList.stream().map(dy -> {
            if (AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey().equals(dy.getDynamicObjectType().getName())) {
                return dy.getLong("boid");
            }
            return dy.getLong("adminorg.id");
        }).collect(Collectors.toSet());
        DynamicObject[] masterDysWithInitFields = QueryHelper.queryInitFieldsByVid(Stream.of(this.billData.getParentBoSet(), this.billData.getInfoBoSet(), this.billData.getDisableBoSet(), virtualHisAdOrgBoSet).flatMap(Collection::stream).collect(Collectors.toSet()));
        Map<Long, DynamicObject> boVsDyWithInitFields = Arrays.stream(masterDysWithInitFields).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        Stream.of(this.entryOrgDataListBO.disableAdminOrgDataList, this.entryOrgDataListBO.parentChangeAdminOrgDataList, this.entryOrgDataListBO.infoChangeAdminOrgDataList).flatMap(Collection::stream).forEach(adminOrgData -> {
            long orgBoId = adminOrgData.getOrgBoId();
            DynamicObject from = (DynamicObject)boVsDyWithInitFields.get(orgBoId);
            MethodHelper.copyInitFields(from, adminOrgData.orgDy);
            MethodHelper.copyInitFields(from, adminOrgData.structDy);
            MethodHelper.copyInitFields(from, adminOrgData.sortCodeDy);
        });
        this.cascadeOrgDataList.stream().filter(adminOrgData -> virtualHisAdOrgBoSet.contains(adminOrgData.getOrgBoId())).forEach(adminOrgData -> {
            long orgBoId = adminOrgData.getOrgBoId();
            DynamicObject from = (DynamicObject)boVsDyWithInitFields.get(orgBoId);
            Optional.ofNullable(adminOrgData.orgDy).ifPresent(dy -> MethodHelper.copyInitFields(from, dy));
            Optional.ofNullable(adminOrgData.structDy).ifPresent(dy -> MethodHelper.copyInitFields(from, dy));
            Optional.ofNullable(adminOrgData.sortCodeDy).ifPresent(dy -> MethodHelper.copyInitFields(from, dy));
        });
    }

    private void create4Cascade(Map<Long, DynamicObject> idVsDy) {
        Set<Long> allBoSet = this.billData.getAllBoSet();
        this.cascadeResultList.stream().map(cascadeResult -> this.getNeedCascadeBo(allBoSet, (CascadeResult)cascadeResult)).flatMap(Collection::stream).map(cascadeModel -> this.getAdminOrgData(idVsDy, (CascadeModel)cascadeModel)).forEach(this.cascadeOrgDataList::add);
    }

    private List<CascadeModel> getNeedCascadeBo(Set<Long> allBoSet, CascadeResult cascadeResult) {
        if (allBoSet.contains(cascadeResult.getId())) {
            return cascadeResult.getChangedCascadeModelList().stream().filter(cascadeModel -> !cascadeModel.getEffectRange().contains(this.localDate2999)).collect(Collectors.toList());
        }
        return cascadeResult.getChangedCascadeModelList();
    }

    private AdminOrgData getAdminOrgData(Map<Long, DynamicObject> idVsDy, CascadeModel cascadeModel) {
        if (cascadeModel instanceof MasterCascadeModel) {
            DynamicObject masterDy = MethodHelper.copy(idVsDy.get(cascadeModel.getVid()));
            cascadeModel.dynamicObjectSetter(masterDy);
            return new AdminOrgData(masterDy, null, null);
        }
        if (cascadeModel instanceof StructCascadeModel) {
            DynamicObject structDy = MethodHelper.copy(idVsDy.get(cascadeModel.getVid()));
            cascadeModel.dynamicObjectSetter(structDy);
            return new AdminOrgData(null, structDy, null);
        }
        if (cascadeModel instanceof SortCodeCascadeModel) {
            DynamicObject sortCodeDy = MethodHelper.copy(idVsDy.get(cascadeModel.getVid()));
            cascadeModel.dynamicObjectSetter(sortCodeDy);
            return new AdminOrgData(null, null, sortCodeDy);
        }
        return null;
    }

    private void create4Effecting(Map<Long, DynamicObject> idVsDy) {
        Set<Long> allBoSet = this.billData.getAllBoSet();
        Map boVsCascadeResult = this.cascadeResultList.stream().filter(cascadeResult -> allBoSet.contains(cascadeResult.getId())).filter(cascadeResult -> cascadeResult.getEffectRange().contains(this.localDate2999)).collect(Collectors.toMap(CascadeResult::getId, Function.identity()));
        Stream.of(this.billData.getAllEntry()).flatMap(Collection::stream).map(this::findEffectingCascadeBo).filter(Objects::nonNull).map(effectingCascadeBo -> this.createAdminOrgData4Effecting(idVsDy, (CascadeBo)effectingCascadeBo)).peek(adminOrgData -> this.overlapByEffectingCascadeData((CascadeResult)boVsCascadeResult.get(adminOrgData.getOrgBoId()), (AdminOrgData)adminOrgData)).peek(adminOrgData -> adminOrgData.orgDy.set("id", (Object)adminOrgData.getOrgBoId())).forEach(this::add4Entry);
    }

    private void add4Entry(AdminOrgData adminOrgData) {
        if (this.billData.getInfoBoSet().contains(adminOrgData.getOrgBoId())) {
            this.entryOrgDataListBO.infoChangeAdminOrgDataList.add(adminOrgData);
        } else if (this.billData.getParentBoSet().contains(adminOrgData.getOrgBoId())) {
            this.entryOrgDataListBO.parentChangeAdminOrgDataList.add(adminOrgData);
        } else if (this.billData.getDisableBoSet().contains(adminOrgData.getOrgBoId())) {
            this.entryOrgDataListBO.disableAdminOrgDataList.add(adminOrgData);
            MethodHelper.setDisable(adminOrgData.orgDy);
        } else if (this.billData.getAddBoSet().contains(adminOrgData.getOrgBoId())) {
            this.entryOrgDataListBO.addAdminOrgDataList.add(adminOrgData);
        } else {
            throw new RuntimeException("unsupported type");
        }
    }

    private void overlapByEffectingCascadeData(CascadeResult cascadeResult, AdminOrgData adminOrgData) {
        cascadeResult.getChangedCascadeModelList().stream().filter(cascadeModel -> cascadeModel.getEffectRange().contains(this.localDate2999)).forEach(cascadeModel -> {
            DynamicObject newEffectingDy;
            if (cascadeModel instanceof MasterCascadeModel) {
                newEffectingDy = adminOrgData.orgDy;
            } else if (cascadeModel instanceof StructCascadeModel) {
                newEffectingDy = adminOrgData.structDy;
            } else if (cascadeModel instanceof SortCodeCascadeModel) {
                newEffectingDy = adminOrgData.sortCodeDy;
            } else {
                throw new RuntimeException("unsupported type");
            }
            Date bsed = newEffectingDy.getDate("bsed");
            Date bsled = newEffectingDy.getDate("bsled");
            cascadeModel.dynamicObjectSetter(newEffectingDy);
            newEffectingDy.set("bsed", (Object)bsed);
            newEffectingDy.set("bsled", (Object)bsled);
        });
    }

    private AdminOrgData createAdminOrgData4Effecting(Map<Long, DynamicObject> idVsDy, CascadeBo effectingCascadeBo) {
        CascadeModel newEffectingMasterModel = this.findEffectingDynamicObject(effectingCascadeBo.getMasterList());
        DynamicObject newEffectingMaster = MethodHelper.copy(idVsDy.get(newEffectingMasterModel.getVid()));
        newEffectingMasterModel.dynamicObjectSetter(newEffectingMaster);
        CascadeModel newEffectingStructModel = this.findEffectingDynamicObject(effectingCascadeBo.getStructList());
        DynamicObject newEffectingStruct = MethodHelper.copy(idVsDy.get(newEffectingStructModel.getVid()));
        newEffectingStructModel.dynamicObjectSetter(newEffectingStruct);
        CascadeModel newEffectingSortCodeModel = this.findEffectingDynamicObject(effectingCascadeBo.getSortCodeList());
        DynamicObject newEffectingSortCode = MethodHelper.copy(idVsDy.get(newEffectingSortCodeModel.getVid()));
        newEffectingSortCodeModel.dynamicObjectSetter(newEffectingSortCode);
        return new AdminOrgData(newEffectingMaster, newEffectingStruct, newEffectingSortCode);
    }

    private CascadeBo findEffectingCascadeBo(DynamicObject entryOrg) {
        List<DateRangeNode<CascadeBo>> dateRangeNodes = this.boVsNodeList.get(entryOrg.getLong("adminorg.boid"));
        return dateRangeNodes.stream().map(DateRangeNode::getVal).filter(cascadeBo -> cascadeBo.getEffectRange().contains(this.localDate2999)).findAny().orElse(null);
    }

    private void create4NoParentAdd(Map<Long, DynamicObject> idVsDy) {
        if (this.billData.getChangeRootData() != null) {
            return;
        }
        this.billData.getAddEntry().stream().map(this::findNoParentCascadeBo).filter(Objects::nonNull).forEach(noParentCascadeBo -> this.addNoParentAdminOrgData(idVsDy, (CascadeBo)noParentCascadeBo));
    }

    private void addNoParentAdminOrgData(Map<Long, DynamicObject> idVsDy, CascadeBo noParentCascadeBo) {
        CascadeModel newEffectingMasterModel = noParentCascadeBo.getMasterList().get(0);
        DynamicObject newEffectingMaster = MethodHelper.copy(idVsDy.get(newEffectingMasterModel.getVid()));
        newEffectingMasterModel.dynamicObjectSetter(newEffectingMaster);
        CascadeModel newEffectingStructModel = noParentCascadeBo.getStructList().get(0);
        DynamicObject newEffectingStruct = MethodHelper.copy(idVsDy.get(newEffectingStructModel.getVid()));
        newEffectingStructModel.dynamicObjectSetter(newEffectingStruct);
        CascadeModel newEffectingSortCodeModel = noParentCascadeBo.getSortCodeList().get(0);
        DynamicObject newEffectingSortCode = MethodHelper.copy(idVsDy.get(newEffectingSortCodeModel.getVid()));
        newEffectingSortCodeModel.dynamicObjectSetter(newEffectingSortCode);
        AdminOrgData adminOrgData = new AdminOrgData(newEffectingMaster, newEffectingStruct, newEffectingSortCode);
        this.cascadeOrgDataList.add(adminOrgData);
    }

    private CascadeBo findNoParentCascadeBo(DynamicObject entryOrg) {
        LocalDate estLocalDate = MethodHelper.toLocalDate(entryOrg.getDate("establishmentdate"));
        List<DateRangeNode<CascadeBo>> dateRangeNodes = this.boVsNodeList.get(entryOrg.getLong("adminorg.boid"));
        Optional<CascadeBo> any = dateRangeNodes.stream().filter(node -> node.getDateRange().contains(estLocalDate)).filter(node -> ((CascadeBo)node.getVal()).getPid() == 0L).map(DateRangeNode::getVal).findAny();
        return any.orElse(null);
    }

    private CascadeModel findEffectingDynamicObject(List<? extends CascadeModel> dyList) {
        Optional<CascadeModel> any = dyList.stream().filter(cascadeModel -> cascadeModel.getEffectRange().contains(this.localDate2999)).findAny();
        if (any.isPresent()) {
            return any.get();
        }
        throw new RuntimeException("no effecting model");
    }

    public void setBillData(BillData billData) {
        this.billData = billData;
    }

    public void setBoVsNodeList(Map<Long, List<DateRangeNode<CascadeBo>>> boVsNodeList) {
        this.boVsNodeList = boVsNodeList;
    }

    public void setCascadeResultList(List<CascadeResult> cascadeResultList) {
        this.cascadeResultList = cascadeResultList;
    }

    public void setVirtualVersionDyList(List<DynamicObject> virtualVersionDyList) {
        this.virtualVersionDyList = virtualVersionDyList;
    }

    public List<AdminOrgData> getCascadeOrgDataList() {
        return this.cascadeOrgDataList;
    }

    public AdminOrgDataEntryBO getEntryOrgDataListBO() {
        return this.entryOrgDataListBO;
    }
}

