/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.business.domain.service.impl.proteamgroup.ProjectTeamServiceImpl;
import kd.hr.haos.business.domain.service.projectgroup.IProjectTeamService;
import kd.hr.haos.common.model.prj.ProjectTeamOrgChangeModel;
import kd.hr.homs.business.service.batcheffect.BatchEffectService;
import kd.hr.homs.business.service.batcheffect.util.TimeLogger;
import kd.hr.homs.business.service.orgfast.async.AsyncEffectingContext;
import kd.hr.homs.business.service.orgfast.async.AsyncEffectingMultiCaster;
import kd.hr.homs.business.service.orgfast.async.event.AsyncEffectingEvent;

public class BatchEffectController {
    private BatchEffectService batchEffectService;
    private AsyncEffectingMultiCaster asyncEffectingMultiCaster;
    private AsyncEffectingContext context;
    private IProjectTeamService projectTeamService = ProjectTeamServiceImpl.getInstance();
    private TimeLogger timeLogger = TimeLogger.create();

    private BatchEffectController(DynamicObject bill, DynamicObject[] entryOrg) {
        this.timeLogger.start();
        this.timeLogger.check("before create batchEffectService");
        this.batchEffectService = BatchEffectService.createBatchEffectService(bill, entryOrg);
        this.timeLogger.check("after create batchEffectService");
    }

    private BatchEffectController(DynamicObject bill, DynamicObject[] entryOrg, String openApiFlag) {
        this.timeLogger.start();
        this.timeLogger.check("before create batchEffectService");
        this.batchEffectService = BatchEffectService.createBatchEffectService(bill, entryOrg, openApiFlag);
        this.timeLogger.check("after create batchEffectService");
    }

    private BatchEffectController(DynamicObject bill, DynamicObject[] entryOrg, String openApiFlag, AsyncEffectingMultiCaster asyncEffectingMultiCaster, AsyncEffectingContext context) {
        this.asyncEffectingMultiCaster = asyncEffectingMultiCaster;
        this.context = context;
        this.timeLogger.start();
        this.timeLogger.check("before create batchEffectService");
        asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingHandleCascadeEvent(context.resetToStartFirstStep()));
        this.batchEffectService = BatchEffectService.createBatchEffectService(bill, entryOrg, openApiFlag);
        asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingHandleCascadeEvent(context.resetToEndFirstStep()));
        this.timeLogger.check("after create batchEffectService");
    }

    public static BatchEffectController createBatchEffectController(DynamicObject bill, DynamicObject[] entryOrg) {
        return new BatchEffectController(bill, entryOrg);
    }

    public static BatchEffectController createBatchEffectController(DynamicObject bill, DynamicObject[] entryOrg, String openApiFlag) {
        return new BatchEffectController(bill, entryOrg, openApiFlag);
    }

    public static BatchEffectController createBatchEffectController(DynamicObject bill) {
        return new BatchEffectController(bill, null);
    }

    public static BatchEffectController createBatchEffectWithMultiCasterController(DynamicObject bill, DynamicObject[] entryOrg, String openApiFlag, AsyncEffectingMultiCaster asyncEffectingMultiCaster, AsyncEffectingContext context) {
        return new BatchEffectController(bill, entryOrg, openApiFlag, asyncEffectingMultiCaster, context);
    }

    public void saveAdminOrg() {
        this.timeLogger.check("before saveAdminOrg");
        this.batchEffectService.saveAdminOrg();
        this.timeLogger.check("after saveAdminOrg");
    }

    public void saveAdminOrgAndBillEntry() {
        this.timeLogger.check("before saveAdminOrg");
        this.batchEffectService.saveAdminOrg();
        this.timeLogger.check("after saveAdminOrg");
        this.timeLogger.check("before saveOtherStruct");
        this.batchEffectService.saveOtherStruct();
        this.timeLogger.check("after saveOtherStruct");
        this.timeLogger.check("before saveBillEntry");
        this.batchEffectService.saveBillEntry();
        this.timeLogger.check("after saveBillEntry");
    }

    public void saveAdminOrgAndBillEntryWithMultiCaster() {
        this.timeLogger.check("before saveAdminOrg");
        this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingSaveAdminEvent(this.context.resetToStartSecondStep()));
        this.batchEffectService.saveAdminOrgWithMultiCaster();
        this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingSaveAdminEvent(this.context.resetToEndSecondStep()));
        this.timeLogger.check("after saveAdminOrg");
        this.timeLogger.check("before saveBillEntry");
        this.batchEffectService.saveBillEntry();
        this.timeLogger.check("after saveBillEntry");
    }

    public void synProjectTeam(List<ProjectTeamOrgChangeModel> projectTeamOrgChangeModelList) {
        this.timeLogger.check("before synProjectTeam");
        this.projectTeamService.changeByAdminOrgChangeOrg(projectTeamOrgChangeModelList);
        this.timeLogger.check("after synProjectTeam");
    }

    public void effectBill() {
        this.timeLogger.check("before saveAdminOrg");
        this.batchEffectService.saveAdminOrg();
        this.timeLogger.check("after saveAdminOrg");
        this.timeLogger.check("before saveOtherStruct");
        this.batchEffectService.saveOtherStruct();
        this.timeLogger.check("after saveOtherStruct");
        this.timeLogger.check("before saveBill");
        this.batchEffectService.saveBillEntry();
        this.batchEffectService.auditBill();
        this.timeLogger.check("after saveBill");
    }

    public long getEventId() {
        return this.batchEffectService.getEventId();
    }

    public List<DynamicObject> getCompanyChangeOrgList() {
        return this.batchEffectService.getCompanyChangeOrgList();
    }

    public void afterEffectBill() {
        BatchEffectService.BATCH_EFFECT_THREAD_POOL.execute(() -> {
            this.timeLogger.check("before synOrgUnit");
            this.batchEffectService.synOrgUnit();
            this.timeLogger.check("after synOrgUnit");
        });
        BatchEffectService.BATCH_EFFECT_THREAD_POOL.execute(() -> {
            this.timeLogger.check("before synStrategy");
            this.batchEffectService.synStrategy();
            this.timeLogger.check("after synStrategy");
        });
        this.timeLogger.end();
    }

    public void afterEffectAddDisableBill() {
        BatchEffectService.BATCH_EFFECT_THREAD_POOL.execute(() -> {
            this.timeLogger.check("before synAddDisableOrgUnit");
            this.batchEffectService.synAddDisableOrgUnit();
            this.timeLogger.check("after synAddDisableOrgUnit");
        });
        BatchEffectService.BATCH_EFFECT_THREAD_POOL.execute(() -> {
            this.timeLogger.check("before synAddDisableStrategy");
            this.batchEffectService.synAddDisableStrategy();
            this.timeLogger.check("after synAddDisableStrategy");
        });
        this.timeLogger.end();
    }

    public void afterEffectChangeDisableBill() {
        BatchEffectService.BATCH_EFFECT_THREAD_POOL.execute(() -> {
            this.timeLogger.check("before synChangeDisableOrgUnit");
            this.batchEffectService.synChangeDisableOrgUnit();
            this.timeLogger.check("after synChangeDisableOrgUnit");
        });
        BatchEffectService.BATCH_EFFECT_THREAD_POOL.execute(() -> {
            this.timeLogger.check("before synAddDisableStrategy");
            this.batchEffectService.synChangeDisableStrategy();
            this.timeLogger.check("after synAddDisableStrategy");
        });
        this.timeLogger.end();
    }

    public void afterEffectChangeEnableBill() {
        BatchEffectService.BATCH_EFFECT_THREAD_POOL.execute(() -> {
            this.timeLogger.check("before synChangeEnableOrgUnit");
            this.batchEffectService.synChangeEnableOrgUnit();
            this.timeLogger.check("after synChangeEnableOrgUnit");
        });
        BatchEffectService.BATCH_EFFECT_THREAD_POOL.execute(() -> {
            this.timeLogger.check("before synAddDisableStrategy");
            this.batchEffectService.synChangeEnableStrategy();
            this.timeLogger.check("after synAddDisableStrategy");
        });
        this.timeLogger.end();
    }
}

