/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgUnitSyncService;
import kd.hr.haos.business.service.orgteam.OrgTeamBatchSynService;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.business.service.otherstruct.OtherStructService;
import kd.hr.haos.business.service.otherstruct.model.OtherStructEntity;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;
import kd.hr.haos.business.service.performanceopt.impl.AdminOrgPerformanceOptimization0804DataHelper;
import kd.hr.haos.business.service.performanceopt.impl.OrgTeamPerformanceOptimization0804DataHelper;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.business.util.LogUtil;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.model.ChangeRootData;
import kd.hr.haos.common.model.orgteam.BatchSynModel;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.batcheffect.AdminOrgDataCreator;
import kd.hr.homs.business.service.batcheffect.MethodHelper;
import kd.hr.homs.business.service.batcheffect.MultiVersionProcessor;
import kd.hr.homs.business.service.batcheffect.OrgHisParamCreator;
import kd.hr.homs.business.service.batcheffect.QueryHelper;
import kd.hr.homs.business.service.batcheffect.bo.AdminOrgData;
import kd.hr.homs.business.service.batcheffect.bo.EffectBillBo;
import kd.hr.homs.business.service.batcheffect.bo.StructEntryData;
import kd.hr.homs.business.service.batcheffect.bo.VersionHolder;
import kd.hr.homs.business.service.batcheffect.bo.VersionRecorder;
import kd.hr.homs.business.service.batcheffect.cascade.tree.MultiVersionTree;
import kd.hr.homs.business.service.batcheffect.fieldchange.FieldChangeRecorder;
import kd.hr.homs.business.service.batcheffect.util.IdCreator;
import kd.hr.homs.business.service.batcheffect.util.TimeLogger;
import kd.hr.homs.business.service.ext.function.DefaultBatchEffectServiceExtend;
import kd.hr.homs.business.service.ext.function.IBatchEffectServiceExtend;
import kd.hr.homs.business.service.helper.OrgBatchValidateHelper;
import kd.hr.homs.business.service.helper.OrgStrategyHelper;
import kd.hr.homs.business.service.orgfast.async.ext.DefaultAfterEffectAdminOrgService;
import kd.hr.homs.common.model.batcheffect.BatchEffectBeforeArgs;
import kd.sdk.odc.homs.service.IAfterEffectAdminOrgService;

public class BatchEffectService {
    static final ThreadPool BATCH_EFFECT_THREAD_POOL = ThreadPools.newCachedThreadPool((String)"BatchEffectThreadPool");
    private static final int PARALLEL_THRESHOLD_SIZE = Integer.parseInt(System.getProperty("orm.opt.in.threshold", "2000"));
    private Future<List<DynamicObject>> futureCompanyChangeOrgList;
    private EffectBillBo effectBillBo;
    private OrgHisParamCreator orgHisParamCreator;
    private FieldChangeRecorder<Long> adminOrgTypeChgRecorder = new FieldChangeRecorder();
    private VersionRecorder versionRecorder = new VersionRecorder();
    private long eventId = ORM.create().genLongId(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
    private Set<Long> enableEntryOrgIdSet;
    private Map<String, DynamicObject> cascadeOrgMap;
    private List<DynamicObject> companyChangeOrgList;
    private List<DynamicObject> hisMasterDyList;
    private Map<Long, String> orgIdToBillEnableMap = new HashMap<Long, String>();
    private List<DynamicObject> adminOrgList2OtListExtend;
    private TimeLogger timeLogger = TimeLogger.create();
    private static final Log LOGGER = LogFactory.getLog(BatchEffectService.class);

    private BatchEffectService(DynamicObject bill, DynamicObject[] entryOrg, String openApiFlag) {
        this(bill, entryOrg, openApiFlag, null);
    }

    private BatchEffectService(DynamicObject bill, DynamicObject[] entryOrg, String openApiFlag, ChangeRootData changeRootData) {
        TimeLogger createServiceTimeLogger = TimeLogger.create();
        createServiceTimeLogger.start();
        this.effectBillBo = EffectBillBo.createEffectBillBo(bill, entryOrg);
        this.effectBillBo.billData.setChangeRootData(changeRootData);
        createServiceTimeLogger.check("createEffectBillBo");
        this.setOrgIdToBillEnableMap(bill);
        this.logAddEstablishmentDate(this.effectBillBo.billData.getAddEntry());
        MultiVersionProcessor multiVersionProcessor = new MultiVersionProcessor();
        multiVersionProcessor.setBillData(this.effectBillBo.billData);
        multiVersionProcessor.init();
        this.recordChangeFields(multiVersionProcessor.getHisMasterDyList());
        multiVersionProcessor.execute();
        createServiceTimeLogger.check("MultiVersionProcessor execute");
        MultiVersionTree multiVersionTree = MultiVersionTree.buildTree(multiVersionProcessor.getHisMasterDyList(), multiVersionProcessor.getHisStructDyList(), multiVersionProcessor.getHisSortCodeDyList());
        this.hisMasterDyList = multiVersionProcessor.getHisMasterDyList();
        multiVersionTree.traverse();
        createServiceTimeLogger.check("MultiVersionTree execute");
        AdminOrgDataCreator adminOrgDataCreator = new AdminOrgDataCreator();
        adminOrgDataCreator.setBillData(this.effectBillBo.billData);
        adminOrgDataCreator.setBoVsNodeList(multiVersionTree.getBoVsNodeList());
        adminOrgDataCreator.setCascadeResultList(multiVersionTree.getChangedCascadeResult());
        adminOrgDataCreator.setVirtualVersionDyList(multiVersionProcessor.getVirtualVersionDyList());
        adminOrgDataCreator.create();
        List<AdminOrgData> cascadeOrgDataList = adminOrgDataCreator.getCascadeOrgDataList();
        this.initCascadeOrgEntry(bill, cascadeOrgDataList);
        Set<Long> addBoSet = this.effectBillBo.billData.getAddBoSet();
        Map<Boolean, List<AdminOrgData>> isAddVsOrgDataList = cascadeOrgDataList.stream().collect(Collectors.groupingBy(adminOrgData -> addBoSet.contains(adminOrgData.getOrgBoId())));
        createServiceTimeLogger.check("AdminOrgDataCreator execute");
        this.orgHisParamCreator = new OrgHisParamCreator();
        this.orgHisParamCreator.setOpenApiFlag(openApiFlag);
        this.orgHisParamCreator.setAdminOrgTypeChangedRecorder(this.adminOrgTypeChgRecorder);
        this.orgHisParamCreator.setBillData(this.effectBillBo.billData);
        this.enableEntryOrgIdSet = this.getEnableEntryOrgIdSet();
        this.orgHisParamCreator.setEnableEntryOrgIdSet(this.enableEntryOrgIdSet);
        this.orgHisParamCreator.setCascadeOrgDataList(isAddVsOrgDataList.getOrDefault(Boolean.FALSE, Collections.emptyList()));
        this.orgHisParamCreator.setAddCascadeOrgDataList(isAddVsOrgDataList.getOrDefault(Boolean.TRUE, Collections.emptyList()));
        this.orgHisParamCreator.setEntryOrgDataListBO(adminOrgDataCreator.getEntryOrgDataListBO());
        this.orgHisParamCreator.execute();
        createServiceTimeLogger.check("OrgHisParamCreator execute");
        this.effectBillBo.adminOrgDataEntryBO = adminOrgDataCreator.getEntryOrgDataListBO();
    }

    private void initCascadeOrgEntry(DynamicObject bill, List<AdminOrgData> cascadeOrgDataList) {
        if (CollectionUtils.isEmpty(cascadeOrgDataList)) {
            return;
        }
        this.cascadeOrgMap = Maps.newHashMapWithExpectedSize((int)cascadeOrgDataList.size());
        for (AdminOrgData data : cascadeOrgDataList) {
            DynamicObject org = data.orgDy;
            if (org == null) continue;
            DynamicObject dataEntity = OrgBatchValidateHelper.BATCHORGENTITY_HELPER.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)bill, (DynamicObject)dataEntity);
            dataEntity.set("billid", (Object)bill.getLong("id"));
            dataEntity.set("adminorgboid", (Object)org.getString("boid"));
            dataEntity.set("number", (Object)org.getString("number"));
            dataEntity.set("name", (Object)org.getString("name"));
            dataEntity.set("parentorg", (Object)org.getString("parentorg.id"));
            dataEntity.set("adminorgtype", (Object)org.getString("adminorgtype.id"));
            dataEntity.set("bsed", (Object)bill.getDate("effdt"));
            dataEntity.set("beforebaseinfoid", (Object)org.getString("id"));
            this.cascadeOrgMap.put(org.getString("boid"), dataEntity);
        }
    }

    private List<DynamicObject> handleCompanyChangeData(List<VersionChangeRespData> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return Lists.newArrayList();
        }
        ArrayList companyChangeDataList = Lists.newArrayListWithExpectedSize((int)dataList.size());
        for (VersionChangeRespData his : dataList) {
            DynamicObject[] dyns;
            if (!HRStringUtils.equals((String)his.getEntityNumber(), (String)"haos_adminorgdetail")) continue;
            for (DynamicObject org : dyns = his.getNewDynamicObjects()) {
                DynamicObject entryOrg;
                if (HRStringUtils.equals((String)org.getString("companychangetype"), (String)AdminOrgConstants.CompanyChangeType.NO_CHANGE.code()) || !org.getBoolean("iscurrentversion")) continue;
                String boId = org.getString("boid");
                if (this.cascadeOrgMap != null && this.cascadeOrgMap.size() > 0 && (entryOrg = this.cascadeOrgMap.get(boId)) != null) {
                    entryOrg.set("aftercompanyid", (Object)org.getString("belongcompany.id"));
                    entryOrg.set("afterbaseinfoid", (Object)org.getString("id"));
                    entryOrg.set("adminorg", (Object)org);
                    entryOrg.set("companychangetype", (Object)org.getString("companychangetype"));
                    if (entryOrg.getDynamicObject("belongcompany") == null) {
                        entryOrg.set("belongcompany", (Object)org.getDynamicObject("belongcompany"));
                    }
                    companyChangeDataList.add(entryOrg);
                    continue;
                }
                if (!HRStringUtils.equals((String)org.getString("companychangetype"), (String)AdminOrgConstants.CompanyChangeType.SELF_CHANGE.code())) continue;
                DynamicObject dataEntity = OrgBatchValidateHelper.BATCHORGENTITY_HELPER.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)org, (DynamicObject)dataEntity);
                dataEntity.set("billid", (Object)org.getLong("id"));
                dataEntity.set("adminorgboid", (Object)org.getString("boid"));
                dataEntity.set("number", (Object)org.getString("number"));
                dataEntity.set("name", (Object)org.getString("name"));
                dataEntity.set("parentorg", (Object)org.getString("parentorg.id"));
                dataEntity.set("adminorgtype", (Object)org.getString("adminorgtype.id"));
                dataEntity.set("bsed", (Object)org.getDate("bsed"));
                dataEntity.set("beforebaseinfoid", (Object)org.getString("id"));
                dataEntity.set("aftercompanyid", (Object)org.getString("belongcompany.id"));
                dataEntity.set("afterbaseinfoid", (Object)org.getString("id"));
                dataEntity.set("adminorg", (Object)org);
                dataEntity.set("companychangetype", (Object)org.getString("companychangetype"));
                companyChangeDataList.add(dataEntity);
            }
        }
        return companyChangeDataList;
    }

    private void recordChangeFields(List<DynamicObject> hisMasterDyList) {
        Set changeBoSet = Stream.of(this.effectBillBo.billData.getParentBoSet(), this.effectBillBo.billData.getInfoBoSet()).flatMap(Collection::stream).collect(Collectors.toSet());
        Map<Long, Long> boVsOrgTypeStdId = hisMasterDyList.stream().filter(dy -> changeBoSet.contains(dy.getLong("boid"))).filter(dy -> EnumHisDataVersionStatus.EFFECTING.getStatus().equals(dy.getString("datastatus"))).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getLong("adminorgtype.adminorgtypestd.id")));
        Stream.of(this.effectBillBo.billData.getParentEntry(), this.effectBillBo.billData.getInfoEntry()).flatMap(Collection::stream).forEach(entryOrg -> {
            long boId = entryOrg.getLong("adminorg.boid");
            this.adminOrgTypeChgRecorder.setNewValue(boId, entryOrg.getLong("adminorgtype.adminorgtypestd.id"));
            this.adminOrgTypeChgRecorder.setOldValue(boId, (Long)boVsOrgTypeStdId.get(boId));
        });
    }

    private void logAddEstablishmentDate(List<DynamicObject> dynamicObjectList) {
        String message = dynamicObjectList.stream().map(dy -> "[entry bsed:" + dy.getDate("bsed") + ", establishment date: " + dy.getDate("establishmentdate") + "]").collect(Collectors.joining("], ", "check_effect_daylight_saving_time {", "}"));
        LOGGER.info(message);
        LOGGER.info(ZoneId.systemDefault().toString());
    }

    public static BatchEffectService createBatchEffectService(DynamicObject bill) {
        return new BatchEffectService(bill, null, null);
    }

    public static BatchEffectService createRootChangeServices(DynamicObject bill, DynamicObject[] entryOrg, ChangeRootData changeRootData) {
        return new BatchEffectService(bill, entryOrg, null, changeRootData);
    }

    public static BatchEffectService createBatchEffectService(DynamicObject bill, DynamicObject[] entryOrg) {
        return new BatchEffectService(bill, entryOrg, null);
    }

    public static BatchEffectService createBatchEffectService(DynamicObject bill, DynamicObject[] entryOrg, String openApiFlag) {
        return new BatchEffectService(bill, entryOrg, openApiFlag);
    }

    public void saveAdminOrg() {
        this.timeLogger.start();
        List<HisVersionParamBo> effectingVersionList = this.orgHisParamCreator.createEffectingVersionList();
        List<HisVersionParamBo> invalidVersionList = this.orgHisParamCreator.createInvalidVersionList();
        OtHisVersion otHisVersion = this.removeOtVersion(effectingVersionList, invalidVersionList);
        this.timeLogger.check("before SaveAdminOrgExtend orgteam");
        this.SaveAdminOrgExtend(effectingVersionList, invalidVersionList);
        this.timeLogger.check("before SaveAdminOrgExtend orgteam");
        this.logHisVersion(effectingVersionList, invalidVersionList);
        if (effectingVersionList.size() + invalidVersionList.size() >= PARALLEL_THRESHOLD_SIZE) {
            LOGGER.info("Effective admin org is parallel processing");
            this.futureCompanyChangeOrgList = BATCH_EFFECT_THREAD_POOL.submit(() -> this.handleBatchHisVersionChange(effectingVersionList, invalidVersionList));
        } else {
            this.handleBatchHisVersionChange(effectingVersionList, invalidVersionList);
        }
        this.timeLogger.check("before AfterAdminEffectExtend");
        this.AfterAdminEffectExtend(effectingVersionList, invalidVersionList);
        this.timeLogger.check("before AfterAdminEffectExtend");
        this.timeLogger.check("before effect orgteam");
        this.effectOrgTeam(otHisVersion, this.orgHisParamCreator.getFirstVersionMap());
        this.timeLogger.check("after effect orgteam");
        this.timeLogger.check("before effectOrgTeamExtend");
        this.effectOrgTeamExtend(this.adminOrgList2OtListExtend);
        this.timeLogger.check("before effectOrgTeamExtend");
        this.timeLogger.check("before performanceOpt0804Process");
        this.performanceOpt0804Process(effectingVersionList);
        this.timeLogger.check("after performanceOpt0804Process");
    }

    public void saveAdminOrgWithMultiCaster() {
        this.timeLogger.start();
        List<HisVersionParamBo> effectingVersionList = this.orgHisParamCreator.createEffectingVersionList();
        List<HisVersionParamBo> invalidVersionList = this.orgHisParamCreator.createInvalidVersionList();
        OtHisVersion otHisVersion = this.removeOtVersion(effectingVersionList, invalidVersionList);
        this.timeLogger.check("before SaveAdminOrgExtend orgteam");
        this.SaveAdminOrgExtend(effectingVersionList, invalidVersionList);
        this.timeLogger.check("before SaveAdminOrgExtend orgteam");
        this.logHisVersion(effectingVersionList, invalidVersionList);
        this.handleBatchHisVersionChange(effectingVersionList, invalidVersionList);
        this.timeLogger.check("before effect orgteam");
        this.effectOrgTeam(otHisVersion, this.orgHisParamCreator.getFirstVersionMap());
        this.timeLogger.check("after effect orgteam");
        this.timeLogger.check("before effectOrgTeamExtend");
        this.effectOrgTeamExtend(this.adminOrgList2OtListExtend);
        this.timeLogger.check("before effectOrgTeamExtend");
        this.timeLogger.check("before performanceOpt0804Process");
        this.performanceOpt0804Process(effectingVersionList);
        this.timeLogger.check("after performanceOpt0804Process");
        this.timeLogger.check("before AfterAdminEffectExtend");
        this.AfterAdminEffectExtend(effectingVersionList, invalidVersionList);
        this.timeLogger.check("before AfterAdminEffectExtend");
    }

    private void AfterAdminEffectExtend(List<HisVersionParamBo> effectingVersionList, List<HisVersionParamBo> invalidVersionList) {
        PluginProxy iAfterEffectAdminOrgServicePluginProxy = PluginProxy.create((Object)new DefaultAfterEffectAdminOrgService(), IAfterEffectAdminOrgService.class, (String)"kd.hr.homs.business.service.orgfast.async.ext.aftereffect");
        boolean hasExtendPlugins = iAfterEffectAdminOrgServicePluginProxy.getPlugins().size() != 0;
        ArrayList<DynamicObject> adminOrgList = new ArrayList<DynamicObject>();
        if (hasExtendPlugins) {
            iAfterEffectAdminOrgServicePluginProxy.callReplace(plugin -> {
                LOGGER.info(String.format("proxy plugin: %s", plugin.getClass()));
                long startTime = System.currentTimeMillis();
                LOGGER.info("before callReplace IAfterEffectAdminOrgService::afterEffectAdminOrg");
                plugin.afterEffectAdminOrg(this.effectBillBo.billData.getBill(), this.effectBillBo.billData.getAllEntry(), adminOrgList);
                long endTime = System.currentTimeMillis();
                LOGGER.info("after callReplace IAfterEffectAdminOrgService::afterEffectAdminOrg cost : [{}]", (Object)(endTime - startTime));
                return null;
            });
        }
        LOGGER.info("adminOrgList size : {}", (Object)adminOrgList.size());
        if (!adminOrgList.isEmpty()) {
            this.saveExtendAdminAndOt(adminOrgList);
        }
    }

    public void saveOtherStruct() {
        Function<StructEntryData, OtherStructVO> synValueBiConsumer = this.getStructEntryDataToOtherStructVOFunction();
        Map<Long, List<StructEntryData>> structProjectVsStructEntryDataList = Stream.of(this.effectBillBo.billData.getStructAddEntry(), this.effectBillBo.billData.getStructChgEntry(), this.effectBillBo.billData.getStructDeleteEntry()).flatMap(Collection::stream).collect(Collectors.groupingBy(StructEntryData::getStructProjectId));
        if (structProjectVsStructEntryDataList.size() == 0) {
            return;
        }
        DynamicObject[] structProjects = StructProjectRepository.getInstance().queryByPks("id, isincludevirtualorg", structProjectVsStructEntryDataList.keySet());
        Map<Long, Boolean> idVsStructProject = Arrays.stream(structProjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getBoolean("isincludevirtualorg")));
        structProjectVsStructEntryDataList.forEach((structProjectId, structEntryDataList) -> {
            LOGGER.info(String.format("saveOtherStruct with structproject: %s", structProjectId));
            boolean isIncludeVirtualOrg = idVsStructProject.getOrDefault(structProjectId, Boolean.FALSE);
            List otherStructVOList = structEntryDataList.stream().map(synValueBiConsumer).collect(Collectors.toList());
            if (otherStructVOList.size() != 0) {
                OtherStructEntity otherStructEntity = new OtherStructEntity(otherStructVOList);
                otherStructEntity.setStructProjectId(structProjectId);
                otherStructEntity.setEnable("1");
                otherStructEntity.setEffectDate(this.effectBillBo.billData.getEffectDate());
                otherStructEntity.setIncludeVirtual(isIncludeVirtualOrg);
                otherStructEntity.setDeleteFlag(Boolean.FALSE);
                new OtherStructService(otherStructEntity).saveOtherStruct();
            }
        });
    }

    private Function<StructEntryData, OtherStructVO> getStructEntryDataToOtherStructVOFunction() {
        return structEntryData -> {
            OtherStructVO otherStructVO = new OtherStructVO();
            otherStructVO.setChangeTypeId(Long.valueOf(structEntryData.getChangeType()));
            otherStructVO.setOrgId(Long.valueOf(structEntryData.getOrgBo()));
            otherStructVO.setParentId(Long.valueOf(structEntryData.getStructProjectParentId()));
            return otherStructVO;
        };
    }

    private void saveExtendAdminAndOt(List<DynamicObject> adminOrgList) {
        HRBaseServiceHelper adminServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        ArrayList<DynamicObject> adminEffectingList = new ArrayList<DynamicObject>(adminOrgList.size());
        IdCreator idCreator = new IdCreator();
        HashMap boidToId = Maps.newHashMapWithExpectedSize((int)adminOrgList.size());
        for (DynamicObject dy : adminOrgList) {
            DynamicObject dynamicObject = adminServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)dynamicObject);
            dynamicObject.set("id", (Object)idCreator.getId());
            adminEffectingList.add(dynamicObject);
            boidToId.put(dynamicObject.getLong("boid"), dynamicObject.getLong("id"));
        }
        HisVersionParamBo adminEffectingHisBo = AdminOrgHisServiceHelper.getHisVersionParam((DynamicObject[])adminEffectingList.toArray(new DynamicObject[0]), (String)"haos_adminorgdetail", (boolean)false);
        ArrayList<HisVersionParamBo> hisBoList = new ArrayList<HisVersionParamBo>();
        hisBoList.add(adminEffectingHisBo);
        this.batchVersionChangeRespDataHisResponse(hisBoList);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(adminOrgList.size());
        List boid = adminOrgList.stream().map(adm -> adm.getLong("boid")).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgteam");
        DynamicObject[] otArray = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", boid)});
        Map<Long, DynamicObject> boidToAdminDy = adminOrgList.stream().collect(Collectors.toMap(adm -> adm.getLong("boid"), adm -> adm));
        for (DynamicObject ot : otArray) {
            DynamicObject adminOrgTeam = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)ot, (DynamicObject)adminOrgTeam);
            HRDynamicObjectUtils.copy((DynamicObject)boidToAdminDy.get(ot.getLong("boid")), (DynamicObject)adminOrgTeam);
            adminOrgTeam.set("id", boidToId.get(ot.getLong("boid")));
            adminOrgTeam.set("number", (Object)(OrgTeamSynService.getNumberByPrefixId((Long)1010L) + "_" + adminOrgTeam.getString("number")));
            result.add(adminOrgTeam);
        }
        BatchSynModel batchSynModel = new BatchSynModel();
        batchSynModel.setNewList(Collections.emptyList());
        batchSynModel.setStrucrProjectId(1010L);
        batchSynModel.setSaveList(result);
        OrgTeamBatchSynService orgTeamBatchSynService = new OrgTeamBatchSynService();
        orgTeamBatchSynService.setBatchSynModel(batchSynModel);
        orgTeamBatchSynService.syn();
        this.performanceOpt0804Process(hisBoList);
    }

    private void effectOrgTeamExtend(List<DynamicObject> adminOrgList) {
        if (!CollectionUtils.isEmpty(adminOrgList)) {
            String numberPrefix = OrgTeamSynService.getOrgTeamNumberPrefix((Long)1010L);
            List saveList = adminOrgList.stream().map(adminOrg -> {
                DynamicObject newOt = OTQueryRepository.getInstance().genEmptyDy();
                OrgTeamSynService.getInstance().synOrgTeamBizFields(newOt, adminOrg, numberPrefix);
                MethodHelper.setCreateTime(newOt);
                MethodHelper.setInitFields(newOt);
                newOt.set("firstbsed", adminOrg.get("bsed"));
                newOt.set("creator", (Object)this.effectBillBo.billData.getCreator());
                newOt.set("id", (Object)adminOrg.getLong("id"));
                newOt.set("boid", (Object)adminOrg.getLong("boid"));
                return newOt;
            }).collect(Collectors.toList());
            OrgTeamBatchSynService orgTeamBatchSynService = new OrgTeamBatchSynService();
            BatchSynModel batchSynModel = new BatchSynModel();
            batchSynModel.setStrucrProjectId(1010L);
            batchSynModel.setEventId(this.getEventId());
            batchSynModel.setSaveList(saveList);
            batchSynModel.setNewList(Collections.emptyList());
            orgTeamBatchSynService.setBatchSynModel(batchSynModel);
            orgTeamBatchSynService.syn();
        }
    }

    private void performanceOpt0804Process(List<HisVersionParamBo> effectingVersionList) {
        Set<Long> updateStructAdminOrgIdSet = this.filterStructAdminOrgId(effectingVersionList);
        Set<Long> updateSortCodeAdminOrgIdSet = this.filterSortCodeAdminOrgId(effectingVersionList);
        AdminOrgPerformanceOptimization0804DataHelper adminOrgPerformanceOptimization0804DataHelper = new AdminOrgPerformanceOptimization0804DataHelper();
        adminOrgPerformanceOptimization0804DataHelper.setUpdateStructAdminOrgIdSet(updateStructAdminOrgIdSet);
        adminOrgPerformanceOptimization0804DataHelper.setUpdateSortCodeAdminOrgIdSet(updateSortCodeAdminOrgIdSet);
        adminOrgPerformanceOptimization0804DataHelper.update();
        OrgTeamPerformanceOptimization0804DataHelper orgTeamPerformanceOptimization0804DataHelper = new OrgTeamPerformanceOptimization0804DataHelper();
        orgTeamPerformanceOptimization0804DataHelper.setUpdateStructAdminOrgIdSet(updateStructAdminOrgIdSet);
        orgTeamPerformanceOptimization0804DataHelper.setUpdateSortCodeAdminOrgIdSet(updateSortCodeAdminOrgIdSet);
        orgTeamPerformanceOptimization0804DataHelper.update();
    }

    private Set<Long> filterSortCodeAdminOrgId(List<HisVersionParamBo> effectingVersionList) {
        return this.getAdminOrgIdSet(effectingVersionList, AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey());
    }

    private Set<Long> filterStructAdminOrgId(List<HisVersionParamBo> effectingVersionList) {
        return this.getAdminOrgIdSet(effectingVersionList, AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
    }

    private Set<Long> getAdminOrgIdSet(List<HisVersionParamBo> effectingVersionList, String entityNumber) {
        Optional<HisVersionParamBo> matchedHisVersionParamBoOpt = effectingVersionList.stream().filter(hisVersionParamBo -> entityNumber.equals(hisVersionParamBo.getEntityNumber())).findAny();
        return matchedHisVersionParamBoOpt.map(hisVersionParamBo -> Arrays.stream(hisVersionParamBo.getHisDyns()).map(struct -> struct.getLong("adminorg.id")).collect(Collectors.toSet())).orElse(null);
    }

    private void SaveAdminOrgExtend(List<HisVersionParamBo> effectingVersionList, List<HisVersionParamBo> invalidVersionList) {
        boolean hasExtendPlugins;
        PluginProxy iBatchEffectServiceExtendPluginProxy = PluginProxy.create((Object)new DefaultBatchEffectServiceExtend(), IBatchEffectServiceExtend.class, (String)"kd.hr.homs.business.service.batcheffect.BatchEffectService.saveAdminOrg.beforeSave");
        boolean bl = hasExtendPlugins = iBatchEffectServiceExtendPluginProxy.getPlugins().size() != 0;
        if (hasExtendPlugins) {
            Map<Long, Long> boVsFirstId = this.getBoVsFirstId(effectingVersionList);
            List<DynamicObject> adminOrgList = this.getAdminOrgList(effectingVersionList, invalidVersionList);
            this.beforeSaveAdminOrgExtend(adminOrgList, (PluginProxy<IBatchEffectServiceExtend>)iBatchEffectServiceExtendPluginProxy);
            this.dispatchAdminOrgList(adminOrgList, boVsFirstId, effectingVersionList, invalidVersionList);
        }
    }

    private Predicate<HisVersionParamBo> matchAdminOrgHisVersionParamBo() {
        return hisVersionParamBo -> AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey().equals(hisVersionParamBo.getEntityNumber());
    }

    private Map<Long, Long> getBoVsFirstId(List<HisVersionParamBo> effectingVersionList) {
        Optional<HisVersionParamBo> effectingAdminOrgHisVersionParamBoOpt = effectingVersionList.stream().filter(this.matchAdminOrgHisVersionParamBo()).findAny();
        if (effectingAdminOrgHisVersionParamBoOpt.isPresent()) {
            DynamicObject[] hisDyns = effectingAdminOrgHisVersionParamBoOpt.get().getHisDyns();
            long[] firstVersionIds = effectingAdminOrgHisVersionParamBoOpt.get().getFirstVersionIds();
            boolean hasFirstVersionIds = firstVersionIds != null;
            Map<Long, Long> boVsFirstId = new HashMap<Long, Long>();
            if (hasFirstVersionIds) {
                boVsFirstId = IntStream.range(0, firstVersionIds.length).boxed().collect(Collectors.toMap(i -> hisDyns[i].getLong("boid"), i -> firstVersionIds[i]));
            }
            return boVsFirstId;
        }
        return new HashMap<Long, Long>();
    }

    private List<DynamicObject> getAdminOrgList(List<HisVersionParamBo> effectingVersionList, List<HisVersionParamBo> invalidVersionList) {
        return Stream.of(effectingVersionList, invalidVersionList).flatMap(Collection::stream).filter(this.matchAdminOrgHisVersionParamBo()).map(HisVersionParamBo::getHisDyns).map(Arrays::stream).flatMap(xva$0 -> Streams.concat((Stream[])new Stream[]{xva$0})).collect(Collectors.toList());
    }

    private void beforeSaveAdminOrgExtend(List<DynamicObject> adminOrgList, PluginProxy<IBatchEffectServiceExtend> iBatchEffectServiceExtendPluginProxy) {
        BatchEffectBeforeArgs batchEffectBeforeArgs = new BatchEffectBeforeArgs();
        batchEffectBeforeArgs.setBill(this.effectBillBo.billData.getBill());
        batchEffectBeforeArgs.setEntryEntity(this.effectBillBo.billData.getAllEntry());
        batchEffectBeforeArgs.setAdminOrgList(adminOrgList);
        iBatchEffectServiceExtendPluginProxy.callReplace(plugin -> {
            LOGGER.info(String.format("proxy plugin: %s", plugin.getClass()));
            LOGGER.info("before callReplace beforeSaveAdminOrgExtend");
            plugin.beforeSaveAdminOrg(batchEffectBeforeArgs);
            LOGGER.info("after callReplace beforeSaveAdminOrgExtend");
            return null;
        });
        this.adminOrgList2OtListExtend = batchEffectBeforeArgs.getAdminOrgList2OtList();
    }

    private void dispatchAdminOrgList(List<DynamicObject> adminOrgList, Map<Long, Long> boVsFirstId, List<HisVersionParamBo> effectingVersionList, List<HisVersionParamBo> invalidVersionList) {
        if (!CollectionUtils.isEmpty(adminOrgList)) {
            Date date2999 = HisEffDateCommonService.getInstance().getDate2999(null);
            Map<Boolean, List<DynamicObject>> isEffectingVsDy = adminOrgList.stream().collect(Collectors.groupingBy(dy -> date2999.equals(dy.getDate("bsled"))));
            List<DynamicObject> effectingDys = isEffectingVsDy.get(Boolean.TRUE);
            List<DynamicObject> invalidDys = isEffectingVsDy.get(Boolean.FALSE);
            long[] firstIds = effectingDys.stream().map(dy -> dy.getLong("boid")).map(bo -> boVsFirstId.getOrDefault(bo, 0L)).mapToLong(firstId -> firstId).toArray();
            Optional<HisVersionParamBo> effectingHisParamBoOpt = effectingVersionList.stream().filter(this.matchAdminOrgHisVersionParamBo()).findAny();
            effectingHisParamBoOpt.ifPresent(effectingHisParamBo -> effectingHisParamBo.setFirstVersionIds(firstIds));
            effectingHisParamBoOpt.ifPresent(effectingHisParamBo -> effectingHisParamBo.setHisDyns(effectingDys.toArray(new DynamicObject[0])));
            Optional<HisVersionParamBo> invalidHisParamBoOpt = invalidVersionList.stream().filter(this.matchAdminOrgHisVersionParamBo()).findAny();
            invalidHisParamBoOpt.ifPresent(invalidHisParamBo -> invalidHisParamBo.setHisDyns(invalidDys.toArray(new DynamicObject[0])));
        }
    }

    private List<DynamicObject> handleBatchHisVersionChange(List<HisVersionParamBo> effectingVersionList, List<HisVersionParamBo> invalidVersionList) {
        this.timeLogger.check("before effecting version batchHisVersionChange");
        HisResponse<BatchVersionChangeRespData> batchVersionChangeRespDataHisResponse = this.batchVersionChangeRespDataHisResponse(effectingVersionList);
        this.timeLogger.check("after effecting version batchHisVersionChange");
        this.timeLogger.check("before invalid version batchHisVersionChange");
        this.batchVersionChangeRespDataHisResponse(invalidVersionList);
        this.timeLogger.check("after invalid version batchHisVersionChange");
        ArrayList<DynamicObject> companyChangeDataList = new ArrayList(16);
        if (batchVersionChangeRespDataHisResponse.getData() != null) {
            companyChangeDataList = this.handleCompanyChangeData(((BatchVersionChangeRespData)batchVersionChangeRespDataHisResponse.getData()).getVersionChangeRespDataList());
        }
        this.recordVersion(batchVersionChangeRespDataHisResponse);
        if (effectingVersionList.size() + invalidVersionList.size() < PARALLEL_THRESHOLD_SIZE) {
            LOGGER.info("Handle company change data is parallel processing");
            this.companyChangeOrgList = companyChangeDataList;
        }
        return companyChangeDataList;
    }

    private void logHisVersion(List<HisVersionParamBo> effectingVersionList, List<HisVersionParamBo> invalidVersionList) {
        LogUtil logUtil = new LogUtil(LOGGER);
        logUtil.infoHisVersion(effectingVersionList);
        logUtil.infoHisVersion(invalidVersionList);
    }

    private OtHisVersion removeOtVersion(List<HisVersionParamBo> effectingVersionList, List<HisVersionParamBo> invalidVersionList) {
        OtHisVersion otHisVersion = new OtHisVersion();
        Function<List, List> removeAndGetLOtList = versionList -> {
            for (int i = 0; i < versionList.size(); ++i) {
                HisVersionParamBo hisVersionParamBo = (HisVersionParamBo)versionList.get(i);
                if (!"haos_adminorgteam".equals(hisVersionParamBo.getEntityNumber())) continue;
                versionList.remove(i);
                return Arrays.asList(hisVersionParamBo.getHisDyns());
            }
            return Collections.emptyList();
        };
        otHisVersion.otList.addAll(removeAndGetLOtList.apply(effectingVersionList));
        otHisVersion.otList.addAll(removeAndGetLOtList.apply(invalidVersionList));
        Function<List, List> removeAndGetLOtStructList = versionList -> {
            for (int i = 0; i < versionList.size(); ++i) {
                HisVersionParamBo hisVersionParamBo = (HisVersionParamBo)versionList.get(i);
                if (!"haos_adminorgstructure".equals(hisVersionParamBo.getEntityNumber())) continue;
                versionList.remove(i);
                return Arrays.asList(hisVersionParamBo.getHisDyns());
            }
            return Collections.emptyList();
        };
        otHisVersion.otStructList.addAll(removeAndGetLOtStructList.apply(effectingVersionList));
        otHisVersion.otStructList.addAll(removeAndGetLOtStructList.apply(invalidVersionList));
        return otHisVersion;
    }

    private void effectOrgTeam(OtHisVersion otHisVersion, Map<Long, Long> firstVersionMap) {
        Date date2999 = MethodHelper.getDate2999();
        Set<Long> addBoSet = this.effectBillBo.billData.getAddBoSet();
        Set<Long> parentBoSet = this.effectBillBo.billData.getParentBoSet();
        Set<Long> disableBoSet = this.effectBillBo.billData.getDisableBoSet();
        Set<Long> infoBoSet = this.effectBillBo.billData.getInfoBoSet();
        List[] sceneVsDyList = new List[4];
        for (int i = 0; i < sceneVsDyList.length; ++i) {
            sceneVsDyList[i] = new ArrayList();
        }
        for (DynamicObject adOrg : this.hisMasterDyList) {
            DynamicObject ot = this.createOt(adOrg, EntityMetadataCache.getSubDataEntityType((String)"haos_orgteamquery", Arrays.asList("id", "boid", "parentid", "bsed", "bsled", "structnumber", "enable", "billenable")));
            long otBo = ot.getLong("boid");
            ot.set("billenable", (Object)this.orgIdToBillEnableMap.get(otBo));
            if (addBoSet.contains(ot.getLong("id")) || addBoSet.contains(otBo)) {
                sceneVsDyList[0].add(ot);
                continue;
            }
            if (!date2999.equals(ot.getDate("bsled"))) continue;
            if (parentBoSet.contains(otBo)) {
                sceneVsDyList[2].add(ot);
                continue;
            }
            if (this.enableEntryOrgIdSet.contains(otBo)) {
                ot.set("enable", (Object)"1");
                sceneVsDyList[3].add(ot);
                continue;
            }
            if (disableBoSet.contains(otBo)) {
                ot.set("enable", (Object)"0");
                sceneVsDyList[3].add(ot);
                continue;
            }
            if (!infoBoSet.contains(otBo)) continue;
            sceneVsDyList[1].add(ot);
        }
        OrgTeamBatchSynService orgTeamBatchSynService = new OrgTeamBatchSynService();
        BatchSynModel batchSynModel = new BatchSynModel();
        batchSynModel.setStrucrProjectId(1010L);
        batchSynModel.setEventId(this.getEventId());
        batchSynModel.setSaveList(otHisVersion.otList);
        batchSynModel.setFirstVersionMap(firstVersionMap);
        batchSynModel.setChangeRootData(this.effectBillBo.billData.getChangeRootData());
        Map<Long, Long> newAdOrgBoVsStructBo = otHisVersion.otStructList.stream().filter(otStruct -> addBoSet.contains(MethodHelper.smartGetId(otStruct, "orgteam"))).filter(otStruct -> date2999.equals(otStruct.getDate("bsled"))).collect(Collectors.toMap(otStruct -> MethodHelper.smartGetId(otStruct, "orgteam"), otStruct -> otStruct.getLong("id")));
        batchSynModel.setNewOtBoVsStructBo(newAdOrgBoVsStructBo);
        batchSynModel.setNewList(sceneVsDyList[0]);
        batchSynModel.setStatusChgList(sceneVsDyList[3]);
        batchSynModel.setChgInfoList(sceneVsDyList[1]);
        batchSynModel.setChgParentList(sceneVsDyList[2]);
        batchSynModel.setStrucrProjectId(1010L);
        orgTeamBatchSynService.setBatchSynModel(batchSynModel);
        if (batchSynModel.getNewList().size() + batchSynModel.getStatusChgList().size() + batchSynModel.getChgInfoList().size() + batchSynModel.getChgParentList().size() >= PARALLEL_THRESHOLD_SIZE) {
            LOGGER.info("Effective org team is parallel processing");
            BATCH_EFFECT_THREAD_POOL.execute(() -> ((OrgTeamBatchSynService)orgTeamBatchSynService).syn());
        } else {
            orgTeamBatchSynService.syn();
        }
    }

    private DynamicObject createOt(DynamicObject adOrg, DynamicObjectType otDt) {
        DynamicObject ot = new DynamicObject(otDt);
        ot.set("id", adOrg.get("id"));
        ot.set("boid", adOrg.get("boid"));
        ot.set("parentid", adOrg.get("parentorg.id"));
        ot.set("structnumber", adOrg.get("structnumber"));
        LocalDateRangeUtils.synEffectRange((DynamicObject)adOrg, (DynamicObject)ot);
        return ot;
    }

    private HisResponse<BatchVersionChangeRespData> batchVersionChangeRespDataHisResponse(List<HisVersionParamBo> hisBoList) {
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        hisVersionParamListBo.setEventId(Long.valueOf(this.eventId));
        hisVersionParamListBo.setListHisVersionParamBo(hisBoList);
        return HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    private void recordVersion(HisResponse<BatchVersionChangeRespData> batchVersionChangeRespData) {
        Set<Long> entryOrgIdSet = this.effectBillBo.billData.getAllBoSet();
        List<String> checkEntityNumberList = Arrays.asList("haos_adminorggroup", "haos_adminorgdetail", "haos_adminorgstruct", "haos_adminorgcompany", "haos_adminorgdepartment");
        Optional.ofNullable(batchVersionChangeRespData.getData()).ifPresent(data -> data.getVersionChangeRespDataList().stream().filter(versionChangeRespData -> checkEntityNumberList.contains(versionChangeRespData.getEntityNumber())).forEach(versionChangeRespData -> {
            DynamicObject[] hisDyns = versionChangeRespData.getNewDynamicObjects();
            String entityNumber = versionChangeRespData.getEntityNumber();
            Function<DynamicObject, Long> orgIdGetter = this.getOrgIdGetter(entityNumber);
            if (hisDyns != null && hisDyns.length > 0) {
                Arrays.stream(hisDyns).filter(hisDy -> entryOrgIdSet.contains(orgIdGetter.apply((DynamicObject)hisDy))).filter(dy -> dy.getLong("id") != dy.getLong("boid")).forEach(hisDyn -> {
                    switch (entityNumber) {
                        case "haos_adminorgdetail": {
                            this.versionRecorder.setMasterData((Long)orgIdGetter.apply((DynamicObject)hisDyn), hisDyn.getLong("id"));
                            break;
                        }
                        case "haos_adminorgstruct": {
                            this.versionRecorder.setStruct((Long)orgIdGetter.apply((DynamicObject)hisDyn), hisDyn.getLong("id"));
                            break;
                        }
                        case "haos_adminorgcompany": {
                            this.versionRecorder.setCompany((Long)orgIdGetter.apply((DynamicObject)hisDyn), hisDyn.getLong("id"));
                            break;
                        }
                        case "haos_adminorggroup": {
                            this.versionRecorder.setGroup((Long)orgIdGetter.apply((DynamicObject)hisDyn), hisDyn.getLong("id"));
                            break;
                        }
                        case "haos_adminorgdepartment": {
                            this.versionRecorder.setDepartment((Long)orgIdGetter.apply((DynamicObject)hisDyn), hisDyn.getLong("id"));
                        }
                    }
                });
            }
        }));
    }

    private Function<DynamicObject, Long> getOrgIdGetter(String entityNumber) {
        switch (entityNumber) {
            case "haos_adminorgcompany": 
            case "haos_adminorggroup": 
            case "haos_adminorgdepartment": 
            case "haos_adminorgstruct": {
                return dynamicObject -> dynamicObject.getLong("adminorg.id");
            }
            case "haos_adminorgdetail": {
                return dynamicObject -> dynamicObject.getLong("boid");
            }
        }
        throw new RuntimeException("un support type");
    }

    public void synOrgUnitByHR() {
        DynamicObject[] dyArray = (DynamicObject[])this.effectBillBo.getBillEntryEffectingHisData().stream().map(adminOrgData -> adminOrgData.orgDy).toArray(DynamicObject[]::new);
        AdminOrgUnitSyncService.getInstance().syncOrgChgUnit(dyArray);
    }

    public void synOrgUnit() {
        Set addAndDisableOrgIdSet = Stream.of(this.effectBillBo.billData.getAddEntry(), this.effectBillBo.billData.getDisableEntry()).flatMap(Collection::stream).map(dynamicObject -> dynamicObject.getLong("adminorg.boid")).collect(Collectors.toSet());
        Map<Boolean, List<DynamicObject>> isAddOrDisableVsDyList = this.effectBillBo.getBillEntryEffectingHisData().stream().map(adminOrgData -> adminOrgData.orgDy).collect(Collectors.groupingBy(orgDy -> addAndDisableOrgIdSet.contains(orgDy.getLong("boid"))));
        AdminOrgUnitSyncService.getInstance().syncOrgUnit(isAddOrDisableVsDyList.getOrDefault(Boolean.TRUE, Collections.emptyList()).toArray(new DynamicObject[0]));
        List updateUnitOrg = isAddOrDisableVsDyList.getOrDefault(Boolean.FALSE, Collections.emptyList());
        AdminOrgUnitSyncService.getInstance().syncOrgChgUnit((DynamicObject[])updateUnitOrg.stream().filter(org -> !this.enableEntryOrgIdSet.contains(org.getLong("boid"))).toArray(DynamicObject[]::new));
        AdminOrgUnitSyncService.getInstance().syncEnableBaseOrg((DynamicObject[])updateUnitOrg.stream().filter(org -> this.enableEntryOrgIdSet.contains(org.getLong("boid"))).toArray(DynamicObject[]::new));
    }

    public void synAddDisableOrgUnit() {
        Set addAndDisableOrgIdSet = Stream.of(this.effectBillBo.billData.getAddEntry()).flatMap(Collection::stream).map(dynamicObject -> dynamicObject.getLong("adminorg.boid")).collect(Collectors.toSet());
        Map<Boolean, List<DynamicObject>> isAddOrDisableVsDyList = this.effectBillBo.getBillEntryEffectingHisData().stream().map(adminOrgData -> adminOrgData.orgDy).collect(Collectors.groupingBy(orgDy -> addAndDisableOrgIdSet.contains(orgDy.getLong("boid"))));
        AdminOrgUnitSyncService.getInstance().syncOrgAddDisableUnit(isAddOrDisableVsDyList.getOrDefault(Boolean.TRUE, Collections.emptyList()).toArray(new DynamicObject[0]));
    }

    public void synChangeDisableOrgUnit() {
        Set changeOrgIdSet = Stream.of(this.effectBillBo.billData.getParentEntry(), this.effectBillBo.billData.getInfoEntry()).flatMap(Collection::stream).map(dynamicObject -> dynamicObject.getLong("adminorg.boid")).collect(Collectors.toSet());
        Map<Boolean, List<DynamicObject>> updateVsDyList = this.effectBillBo.getBillEntryEffectingHisData().stream().map(adminOrgData -> adminOrgData.orgDy).collect(Collectors.groupingBy(orgDy -> changeOrgIdSet.contains(orgDy.getLong("boid"))));
        List<DynamicObject> updateUnitOrg = updateVsDyList.getOrDefault(Boolean.TRUE, Collections.emptyList());
        AdminOrgUnitSyncService.getInstance().syncOrgChangeDisableUnit(updateUnitOrg.toArray(new DynamicObject[0]));
    }

    public void synChangeEnableOrgUnit() {
        Set changeOrgIdSet = Stream.of(this.effectBillBo.billData.getParentEntry(), this.effectBillBo.billData.getInfoEntry()).flatMap(Collection::stream).map(dynamicObject -> dynamicObject.getLong("adminorg.boid")).collect(Collectors.toSet());
        Map<Boolean, List<DynamicObject>> updateVsDyList = this.effectBillBo.getBillEntryEffectingHisData().stream().map(adminOrgData -> adminOrgData.orgDy).collect(Collectors.groupingBy(orgDy -> changeOrgIdSet.contains(orgDy.getLong("boid"))));
        List<DynamicObject> updateUnitOrg = updateVsDyList.getOrDefault(Boolean.TRUE, Collections.emptyList());
        AdminOrgUnitSyncService.getInstance().syncOrgChangeEnableUnit(updateUnitOrg.toArray(new DynamicObject[0]));
    }

    private Set<Long> getEnableEntryOrgIdSet() {
        return this.effectBillBo.billData.getInfoEntry().stream().filter(dynamicObject -> dynamicObject.getLong("changescene.id") == 1070L).map(dynamicObject -> dynamicObject.getLong("adminorg.boid")).collect(Collectors.toSet());
    }

    public void setEntryAfterValue() {
        this.effectBillBo.billData.getAllEntry().forEach(entryDy -> {
            long orgId = entryDy.getLong("adminorg.boid");
            VersionHolder version = this.versionRecorder.getVersion(orgId);
            entryDy.set("afterbaseinfoid", (Object)version.masterData);
            entryDy.set("afterstructid", (Object)version.struct);
            entryDy.set("aftergroupid", (Object)version.group);
            entryDy.set("aftercompanyid", (Object)version.company);
            entryDy.set("afterdepartmentid", (Object)version.department);
        });
        this.effectBillBo.billData.getMergeSplitEntry().forEach(entryDy -> {
            long orgId = entryDy.getLong("adminorg.boid");
            VersionHolder version = this.versionRecorder.getVersion(orgId);
            entryDy.set("afterbaseinfoid", (Object)version.masterData);
            entryDy.set("afterstructid", (Object)version.struct);
            entryDy.set("aftergroupid", (Object)version.group);
            entryDy.set("aftercompanyid", (Object)version.company);
            entryDy.set("afterdepartmentid", (Object)version.department);
        });
    }

    public void saveBillEntry() {
        this.setEntryAfterValue();
        this.changeAddOrgVId();
        QueryHelper.updateBillEntryData(this.effectBillBo.billData.getAllEntry().toArray(new DynamicObject[0]));
        QueryHelper.updateBillEntryData(this.effectBillBo.billData.getMergeSplitEntry().toArray(new DynamicObject[0]));
    }

    private void changeAddOrgVId() {
        Set addEntryBoIdSet = this.effectBillBo.billData.getAddEntry().stream().map(dy -> dy.getLong("adminorg.boid")).collect(Collectors.toSet());
        this.effectBillBo.billData.getAddEntry().forEach(entryDy -> {
            long boId = entryDy.getLong("adminorg.boid");
            entryDy.set("adminorgboid", (Object)boId);
            long orgHisId = this.versionRecorder.getVersion((long)boId).masterData;
            entryDy.set("adminorg_id", (Object)orgHisId);
            entryDy.getDynamicObject("adminorg").set("id", (Object)orgHisId);
        });
        Stream.of(this.effectBillBo.billData.getAddEntry(), this.effectBillBo.billData.getParentEntry()).flatMap(Collection::stream).filter(entryDy -> addEntryBoIdSet.contains(entryDy.getLong("parentorg.boid"))).forEach(entryDy -> {
            long parentHisId = this.versionRecorder.getVersion((long)entryDy.getLong((String)"parentorg.boid")).masterData;
            entryDy.set("parentorg_id", (Object)parentHisId);
            entryDy.getDynamicObject("parentorg").set("id", (Object)parentHisId);
        });
        Stream.of(this.effectBillBo.billData.getMergeEntry()).flatMap(Collection::stream).filter(entryDy -> addEntryBoIdSet.contains(entryDy.getLong("aftermergeorgid"))).forEach(entryDy -> {
            long aftermergeorgid = this.versionRecorder.getVersion((long)entryDy.getLong((String)"aftermergeorgid")).masterData;
            entryDy.set("aftermergeorgid", (Object)aftermergeorgid);
        });
        Stream.of(this.effectBillBo.billData.getSplitEntry()).flatMap(Collection::stream).filter(entryDy -> addEntryBoIdSet.contains(entryDy.getLong("aftersplitorgid"))).forEach(entryDy -> {
            long aftermergeorgid = this.versionRecorder.getVersion((long)entryDy.getLong((String)"aftersplitorgid")).masterData;
            entryDy.set("aftersplitorgid", (Object)aftermergeorgid);
        });
        Stream.of(this.effectBillBo.billData.getMergeEntry()).flatMap(Collection::stream).filter(entryDy -> addEntryBoIdSet.contains(entryDy.getLong("adminorg.boid"))).forEach(entryDy -> {
            long boId = entryDy.getLong("adminorg.boid");
            entryDy.set("adminorgboid", (Object)boId);
            long orgHisId = this.versionRecorder.getVersion((long)boId).masterData;
            entryDy.set("adminorg_id", (Object)orgHisId);
            entryDy.getDynamicObject("adminorg").set("id", (Object)orgHisId);
        });
        Stream.of(this.effectBillBo.billData.getSplitEntry()).flatMap(Collection::stream).filter(entryDy -> addEntryBoIdSet.contains(entryDy.getLong("adminorg.boid"))).forEach(entryDy -> {
            long boId = entryDy.getLong("adminorg.boid");
            entryDy.set("adminorgboid", (Object)boId);
            long orgHisId = this.versionRecorder.getVersion((long)boId).masterData;
            entryDy.set("adminorg_id", (Object)orgHisId);
            entryDy.getDynamicObject("adminorg").set("id", (Object)orgHisId);
        });
        Stream.of(this.effectBillBo.billData.getStructAddEntry(), this.effectBillBo.billData.getStructChgEntry()).flatMap(Collection::stream).forEach(structEntryData -> {
            long structProjectParentId = structEntryData.getStructProjectParentId();
            if (addEntryBoIdSet.contains(structProjectParentId)) {
                DynamicObject structEntry = structEntryData.getStructEntry();
                long orgHisId = this.versionRecorder.getVersion((long)structProjectParentId).masterData;
                structEntry.set("struct_parent_org_id", (Object)orgHisId);
                structEntry.getDynamicObject("struct_parent_org").set("id", (Object)orgHisId);
            }
        });
    }

    public void synStrategy() {
        Set<Long> enableOrgIdSet = this.getEnableEntryOrgIdSet();
        OrgStrategyHelper.addStrategy4BatchModify(this.effectBillBo.billData.getAddEntry());
        List changeList = Stream.of(this.effectBillBo.billData.getParentEntry(), this.effectBillBo.billData.getInfoEntry()).flatMap(Collection::stream).filter(org -> !enableOrgIdSet.contains(org.getLong("adminorg.boid"))).collect(Collectors.toList());
        Optional.of(changeList).filter(list -> list.size() != 0).ifPresent(OrgStrategyHelper::changeStrategy4BatchModify);
        OrgStrategyHelper.disableStrategy4BatchModify(this.effectBillBo.billData.getDisableEntry());
        List<DynamicObject> enableList = this.effectBillBo.billData.getInfoEntry().stream().filter(org -> enableOrgIdSet.contains(org.getLong("adminorg.boid"))).collect(Collectors.toList());
        OrgStrategyHelper.enableStrategy4BatchModify(enableList);
    }

    public void synAddDisableStrategy() {
        OrgStrategyHelper.addStrategy4BatchModify(this.effectBillBo.billData.getAddEntry());
        OrgStrategyHelper.disableStrategy4BatchModify(this.effectBillBo.billData.getAddEntry());
    }

    public void synChangeDisableStrategy() {
        List<DynamicObject> changeList = Stream.of(this.effectBillBo.billData.getParentEntry(), this.effectBillBo.billData.getInfoEntry()).flatMap(Collection::stream).collect(Collectors.toList());
        Optional.of(changeList).filter(list -> list.size() != 0).ifPresent(OrgStrategyHelper::changeStrategy4BatchModify);
        OrgStrategyHelper.disableStrategy4BatchModify(changeList);
    }

    public void synChangeEnableStrategy() {
        List<DynamicObject> changeList = Stream.of(this.effectBillBo.billData.getParentEntry(), this.effectBillBo.billData.getInfoEntry()).flatMap(Collection::stream).collect(Collectors.toList());
        OrgStrategyHelper.enableStrategy4BatchModify(changeList);
        Optional.of(changeList).filter(list -> list.size() != 0).ifPresent(OrgStrategyHelper::changeStrategy4BatchModify);
    }

    public void auditBill() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        DynamicObject dynamicObject = serviceHelper.queryOne("billstatus,auditstatus", new QFilter("id", "=", (Object)this.effectBillBo.billData.getBillId()).toArray());
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("auditstatus", (Object)"C");
        serviceHelper.updateOne(dynamicObject);
    }

    public long getEventId() {
        return this.eventId;
    }

    public List<DynamicObject> getCompanyChangeOrgList() {
        if (this.companyChangeOrgList != null) {
            return this.companyChangeOrgList;
        }
        try {
            return this.futureCompanyChangeOrgList.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("future get company change org error :" + e);
            List<HisVersionParamBo> effectingVersionList = this.orgHisParamCreator.createEffectingVersionList();
            HisResponse<BatchVersionChangeRespData> batchVersionChangeRespDataHisResponse = this.batchVersionChangeRespDataHisResponse(effectingVersionList);
            return this.handleCompanyChangeData(((BatchVersionChangeRespData)batchVersionChangeRespDataHisResponse.getData()).getVersionChangeRespDataList());
        }
    }

    private void setOrgIdToBillEnableMap(DynamicObject bill) {
        if (!bill.getDynamicObjectType().getProperties().containsKey((Object)"billenable")) {
            return;
        }
        String billEnable = bill.getString("billenable");
        if (billEnable == null) {
            return;
        }
        if (bill.getDataEntityType().toString().equals("homs_orgfastchgadd")) {
            this.orgIdToBillEnableMap.put(bill.getLong("orgid"), billEnable);
        } else {
            this.orgIdToBillEnableMap.put(bill.getLong("adminorg.boid"), billEnable);
        }
    }

    static class OtHisVersion {
        List<DynamicObject> otList = new ArrayList<DynamicObject>();
        List<DynamicObject> otStructList = new ArrayList<DynamicObject>();

        OtHisVersion() {
        }
    }
}

