/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.haos.common.model.prj.ProjectTeamOrgChangeModel;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class MethodHelper {
    private static final DynamicObject ADMINISTRATOR = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");

    public static Map<Long, DynamicObject> toLongVsDyMap(List<DynamicObject> dynamicObjectList, String key) {
        return MethodHelper.toMap(dynamicObjectList, dy -> dy.getLong(key));
    }

    public static <T> Map<T, DynamicObject> toMap(List<DynamicObject> dynamicObjectList, Function<DynamicObject, T> mapper) {
        return dynamicObjectList.stream().collect(Collectors.toMap(mapper, (? super T dy) -> dy));
    }

    public static void setEffectingRange(DynamicObject dynamicObject, Date effectDate) {
        dynamicObject.set("bsed", (Object)effectDate);
        dynamicObject.set("bsled", (Object)MethodHelper.getDate2999());
    }

    public static void setEnabled(DynamicObject dynamicObject) {
        dynamicObject.set("enable", (Object)"1");
    }

    public static void setCreateTime(DynamicObject dynamicObject) {
        dynamicObject.set("createtime", (Object)new Date());
    }

    public static void setDisable(DynamicObject dynamicObject) {
        dynamicObject.set("enable", (Object)"0");
    }

    public static void setCreatorAdministrator(DynamicObject dynamicObject) {
        dynamicObject.set("creator", (Object)ADMINISTRATOR);
    }

    public static void setInitFields(DynamicObject dynamicObject) {
        if (dynamicObject.get("initdatasource") == null) {
            dynamicObject.set("initdatasource", (Object)"0");
        }
        dynamicObject.set("initbatch", (Object)0L);
        dynamicObject.set("initstatus", (Object)"2");
    }

    public static void copyInitFields(DynamicObject from, DynamicObject to) {
        to.set("initdatasource", from.get("initdatasource"));
        to.set("initbatch", from.get("initbatch"));
        to.set("initstatus", from.get("initstatus"));
    }

    public static LocalDateRange getEffectDateRangeFromHisDy(DynamicObject hisDy) {
        return LocalDateRange.ofClosed((Date)hisDy.getDate("bsed"), (Date)hisDy.getDate("bsled"));
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(ZonedDateTime.of(localDate, LocalTime.MIN, ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate toLocalDate(Date date) {
        return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
    }

    public static Date getDate2999() {
        return HisEffDateCommonService.getInstance().getDate2999(null);
    }

    public static LocalDate getLocalDate2999() {
        return ZonedDateTime.ofInstant(MethodHelper.getDate2999().toInstant(), ZoneId.systemDefault()).toLocalDate();
    }

    public static DynamicObject copy(DynamicObject from) {
        DynamicObject toDy = new DynamicObject(from.getDynamicObjectType());
        HRDynamicObjectUtils.copy((DynamicObject)from, (DynamicObject)toDy);
        return toDy;
    }

    public static long smartGetId(DynamicObject dynamicObject, String key) {
        Object obj = dynamicObject.get(key);
        return MethodHelper.smartGetId(obj);
    }

    public static long smartGetId(Object obj) {
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        if (obj instanceof String) {
            return Long.parseLong((String)obj);
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return 0L;
    }

    public static <T> Function<T, List<T>> listMapper() {
        return obj -> {
            ArrayList<Object> objects = new ArrayList<Object>();
            objects.add(obj);
            return objects;
        };
    }

    public static <T> BinaryOperator<List<T>> listAddAllMerger() {
        return (list, list2) -> {
            list.addAll(list2);
            return list;
        };
    }

    public static <T> BinaryOperator<T> overlapMerger() {
        return (obj, obj2) -> obj;
    }

    public static List<ProjectTeamOrgChangeModel> convert2ChgPjtOrgModel(Map<Long, List<Long>> sceneMap, List<DynamicObject> entryEntityList) {
        Set<Long> billEntryIdSet = MethodHelper.filterSceneSub(sceneMap, ChangeTransactionConstants.SCENE_SUB_ORG);
        return entryEntityList.stream().filter(entryEntity -> billEntryIdSet.contains(entryEntity.getLong("id"))).map(entryEntity -> {
            ProjectTeamOrgChangeModel projectTeamOrgChangeModel = new ProjectTeamOrgChangeModel();
            projectTeamOrgChangeModel.setAdminOrgBo(entryEntity.getLong("adminorg.boid"));
            projectTeamOrgChangeModel.setEffectDate(entryEntity.getDate("bsed"));
            projectTeamOrgChangeModel.setBuId(entryEntity.getLong("org.id"));
            projectTeamOrgChangeModel.setEffectRange(LocalDateRangeUtils.getEffectRange((DynamicObject)entryEntity));
            return projectTeamOrgChangeModel;
        }).collect(Collectors.toList());
    }

    private static Set<Long> filterSceneSub(Map<Long, List<Long>> sceneSubMap, long subSceneId) {
        return sceneSubMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(subSceneId)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    static {
        ADMINISTRATOR.set("id", (Object)1);
    }
}

