/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.batcheffect.MethodHelper;
import kd.hr.homs.business.service.batcheffect.QueryHelper;
import kd.hr.homs.business.service.batcheffect.bo.AdminOrgData;
import kd.hr.homs.business.service.batcheffect.bo.BillData;
import kd.hr.homs.business.service.batcheffect.constant.EffectBillConstant;
import kd.hr.homs.business.service.batcheffect.util.IdCreator;

public class MultiVersionProcessor {
    private BillData billData;
    private List<DynamicObject> hisMasterDyList;
    private List<DynamicObject> hisStructDyList;
    private List<DynamicObject> hisSortCodeDyList;
    private Map<Long, String> orgBoVsStructNumber;
    private List<DynamicObject> virtualVersionDyList = new ArrayList<DynamicObject>();
    private Map<Long, DynamicObject> billBoId2DynMapFromDBMap;
    private DynamicObject adminStructProjectDy;

    public void init() {
        DynamicObject[] dynamicObjects = QueryHelper.loadById("haos_adminorgdetail", this.billData.getAllBoSet());
        this.billBoId2DynMapFromDBMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn, (v1, v2) -> v1));
        this.queryHisData();
        this.filterVersion(dy -> dy.getBoolean("iscurrentversion") && EnumHisDataVersionStatus.TEMP.getStatus().equals(dy.get("datastatus")) || !dy.getBoolean("iscurrentversion"));
        this.initStructNumberMap();
    }

    public void execute() {
        this.createAddVersion();
        this.splitAddVersion();
        this.overlapHisData();
    }

    private void initStructNumberMap() {
        this.orgBoVsStructNumber = this.hisMasterDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getString("structnumber"), MethodHelper.overlapMerger()));
    }

    private void createAddVersion() {
        Map boVsMasterDys = this.hisMasterDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), MethodHelper.listMapper(), MethodHelper.listAddAllMerger()));
        Map boVsStructDys = this.hisStructDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), MethodHelper.listMapper(), MethodHelper.listAddAllMerger()));
        Map boVsSortCodeDys = this.hisSortCodeDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), MethodHelper.listMapper(), MethodHelper.listAddAllMerger()));
        IdCreator idCreator = new IdCreator();
        this.billData.getAddEntry().forEach(entryOrg -> {
            AdminOrgData newAdminOrgData = this.createNewAdminOrgData((DynamicObject)entryOrg);
            this.setStructNumber(newAdminOrgData);
            long masterVid = idCreator.getId();
            DynamicObject effectingHisMaster = (DynamicObject)((List)boVsMasterDys.get(entryOrg.getLong("adminorg.boid"))).get(0);
            effectingHisMaster.set("id", (Object)masterVid);
            newAdminOrgData.orgDy.set("id", (Object)masterVid);
            this.virtualVersionDyList.add(newAdminOrgData.orgDy);
            long structVid = idCreator.getId();
            DynamicObject hisStructDy = (DynamicObject)((List)boVsStructDys.get(entryOrg.getLong("adminorg.boid"))).get(0);
            hisStructDy.set("id", (Object)structVid);
            newAdminOrgData.structDy.set("boid", (Object)hisStructDy.getLong("boid"));
            newAdminOrgData.structDy.set("id", (Object)structVid);
            this.virtualVersionDyList.add(newAdminOrgData.structDy);
            long sortCodeVid = idCreator.getId();
            DynamicObject hisSortCodeDy = (DynamicObject)((List)boVsSortCodeDys.get(entryOrg.getLong("adminorg.boid"))).get(0);
            hisSortCodeDy.set("id", (Object)sortCodeVid);
            newAdminOrgData.sortCodeDy.set("boid", (Object)hisSortCodeDy.getLong("boid"));
            newAdminOrgData.sortCodeDy.set("id", (Object)sortCodeVid);
            this.virtualVersionDyList.add(newAdminOrgData.sortCodeDy);
        });
    }

    private void queryHisData() {
        List<Pair<Long, Date>> parentBoOfAddVsEstDt = this.getParentBoOfAddVsEstDtBeforeBillEffDt();
        OrgDataQueryResult orgDataQueryResult = this.getOrgDataQueryResultByBillEffDt();
        if (!CollectionUtils.isEmpty(parentBoOfAddVsEstDt)) {
            this.addEarliestVersion4ParentOfAdd(orgDataQueryResult);
        }
        this.hisMasterDyList = orgDataQueryResult.masterDys;
        this.hisStructDyList = orgDataQueryResult.structDys;
        this.hisSortCodeDyList = orgDataQueryResult.sortCodeDys;
    }

    private void addEarliestVersion4ParentOfAdd(OrgDataQueryResult orgDataQueryResult) {
        List<Pair<Long, Date>> parentBoOfAddVsEstDt = this.getParentBoOfAddVsEstDtBeforeBillEffDt();
        Optional<Date> min = parentBoOfAddVsEstDt.stream().map(Pair::getValue).min(Date::compareTo);
        List<Long> boList = parentBoOfAddVsEstDt.stream().map(Pair::getKey).collect(Collectors.toList());
        Date earliestBsed = min.get();
        DynamicObject[] masterDys = QueryHelper.queryHisMasterDataByOrgBoId(boList, earliestBsed);
        DynamicObject[] structDys = QueryHelper.queryHisStructByOrgBoId(boList, earliestBsed);
        DynamicObject[] sortCodeDys = QueryHelper.queryHisSortCodeByOrgBoId(boList, earliestBsed);
        Set vidSet = Stream.of(orgDataQueryResult.masterDys, orgDataQueryResult.structDys, orgDataQueryResult.sortCodeDys).flatMap(Collection::stream).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        Predicate<DynamicObject> isNotExistFilter = dy -> !vidSet.contains(dy.getLong("id"));
        Consumer<DynamicObject> setAccumulator = dy -> vidSet.add(dy.getLong("id"));
        Arrays.stream(masterDys).filter(isNotExistFilter).peek(setAccumulator).forEach(orgDataQueryResult.masterDys::add);
        Arrays.stream(structDys).filter(isNotExistFilter).peek(setAccumulator).forEach(orgDataQueryResult.structDys::add);
        Arrays.stream(sortCodeDys).filter(isNotExistFilter).peek(setAccumulator).forEach(orgDataQueryResult.sortCodeDys::add);
    }

    private OrgDataQueryResult getOrgDataQueryResultByBillEffDt() {
        ThisBillEntryOrgBo thisBillEntryOrgBo = new ThisBillEntryOrgBo();
        this.billData.getAllEntry().forEach(dy -> {
            thisBillEntryOrgBo.parentBoIdSet.add(dy.getLong("parentorg.boid"));
            thisBillEntryOrgBo.oldParentBoIdSet.add(dy.getLong("oriparentorg.boid"));
            thisBillEntryOrgBo.boIdSet.add(dy.getLong("adminorg.boid"));
        });
        Date effDt = this.getEffDt4Query();
        DynamicObject[] cascadeStructDys = QueryHelper.queryHisStruct4InitCascade(new ArrayList<Long>(thisBillEntryOrgBo.getAllBoIdSet()), effDt);
        HashSet<Long> curBillOrgBoIdSet = new HashSet<Long>(thisBillEntryOrgBo.boIdSet);
        Set needQuerySubOrgBoSet = Stream.of(this.billData.getParentBoSet(), this.billData.getOrgTypeChangedBoSet(), this.billData.getIndexChangedBoSet()).flatMap(Collection::stream).collect(Collectors.toSet());
        Map isEntryOrgVsStructLongNumberList = Arrays.stream(cascadeStructDys).collect(Collectors.groupingBy(structDy -> needQuerySubOrgBoSet.contains(structDy.getLong("adminorg.id")), Collectors.mapping(dy -> dy.getString("structlongnumber"), Collectors.toSet())));
        Set<String> equalsStructLongNumberList = isEntryOrgVsStructLongNumberList.getOrDefault(false, Collections.emptySet());
        Set<String> likeStructLongNumberList = isEntryOrgVsStructLongNumberList.getOrDefault(true, Collections.emptySet());
        DynamicObject[] structDys = QueryHelper.queryHisStructByStructLongNumber(equalsStructLongNumberList, likeStructLongNumberList, effDt);
        List structDyList = Arrays.stream(structDys).filter(structDy -> !EnumHisDataVersionStatus.TEMP.getStatus().equals(structDy.getString("datastatus")) || curBillOrgBoIdSet.contains(structDy.getLong("adminorg.id"))).collect(Collectors.toList());
        List<Long> orgBoIdList = structDyList.stream().map(structDy -> structDy.getLong("adminorg.id")).collect(Collectors.toList());
        DynamicObject[] masterDataDys = QueryHelper.queryHisMasterDataByOrgBoId(orgBoIdList, effDt);
        DynamicObject[] sortCodeDys = QueryHelper.queryHisSortCodeByOrgBoId(orgBoIdList, effDt);
        OrgDataQueryResult orgDataQueryResult = new OrgDataQueryResult();
        orgDataQueryResult.masterDys = Arrays.stream(masterDataDys).collect(Collectors.toList());
        orgDataQueryResult.structDys = Arrays.stream(structDys).collect(Collectors.toList());
        orgDataQueryResult.sortCodeDys = Arrays.stream(sortCodeDys).collect(Collectors.toList());
        return orgDataQueryResult;
    }

    private Date getEffDt4Query() {
        Date effectDate;
        switch (this.billData.getBillType()) {
            case "2": 
            case "3": 
            case "1": {
                effectDate = this.billData.getEffectDate();
                break;
            }
            case "4": {
                effectDate = Stream.of(this.billData.getAddEntry(), this.billData.getInfoEntry(), this.billData.getParentEntry()).flatMap(Collection::stream).map(dy -> dy.getDate("bsed")).reduce((date, date2) -> {
                    if (date.before((Date)date2)) {
                        return date;
                    }
                    return date2;
                }).orElseThrow(() -> new RuntimeException("no element in parent entry or info entry"));
                break;
            }
            default: {
                throw new RuntimeException("no support bill type");
            }
        }
        return effectDate;
    }

    private void filterVersion(Predicate<DynamicObject> versionFilter) {
        this.hisMasterDyList = this.hisMasterDyList.stream().filter(versionFilter).collect(Collectors.toList());
        this.hisSortCodeDyList = this.hisSortCodeDyList.stream().filter(versionFilter).collect(Collectors.toList());
        this.hisStructDyList = this.hisStructDyList.stream().filter(versionFilter).collect(Collectors.toList());
    }

    private void overlapHisData() {
        DynamicObjectType sortCodeDyType;
        DynamicObjectType structDyType;
        DynamicObjectType masterDyType;
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        List<DynamicObject> entryOrgList = Stream.of(this.billData.getInfoEntry(), this.billData.getParentEntry(), this.billData.getDisableEntry()).flatMap(Collection::stream).collect(Collectors.toList());
        Map<Long, String> boVsStructNumber = this.hisMasterDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getString("structnumber"), MethodHelper.overlapMerger()));
        Map<Long, DynamicObject> orgBoVsEffectingStruct = this.getOrgBoVsEffectingDy(this.hisStructDyList);
        Map<Long, DynamicObject> orgBoVsEffectingSortCode = this.getOrgBoVsEffectingDy(this.hisSortCodeDyList);
        if (this.hisMasterDyList.size() != 0) {
            masterDyType = this.hisMasterDyList.get(0).getDynamicObjectType();
            structDyType = this.hisStructDyList.get(0).getDynamicObjectType();
            sortCodeDyType = this.hisSortCodeDyList.get(0).getDynamicObjectType();
        } else {
            masterDyType = QueryHelper.getMasterData().generateEmptyDynamicObject().getDynamicObjectType();
            structDyType = QueryHelper.getSTRUCT().generateEmptyDynamicObject().getDynamicObjectType();
            sortCodeDyType = QueryHelper.getSortCode().generateEmptyDynamicObject().getDynamicObjectType();
        }
        this.removeVersion(entryOrgList.stream().map(entryOrg -> entryOrg.getLong("adminorg.boid")).collect(Collectors.toSet()));
        IdCreator idCreator = new IdCreator();
        entryOrgList.forEach(entryOrg -> {
            AdminOrgData changeAdminOrgData = null;
            changeAdminOrgData = this.billData.getDisableBoSet().contains(entryOrg.getLong("adminorg.boid")) ? this.getDisableAdminOrgData((DynamicObject)entryOrg) : this.getChangeAdminOrgData((DynamicObject)entryOrg);
            changeAdminOrgData.structDy.set("isroot", (Object)(rootOrgId == entryOrg.getLong("adminorg.boid") ? 1 : 0));
            this.setStructNumber(changeAdminOrgData);
            long masterVid = idCreator.getId();
            DynamicObject newMasterDy = changeAdminOrgData.orgDy;
            newMasterDy.set("id", (Object)masterVid);
            this.virtualVersionDyList.add(newMasterDy);
            DynamicObject master = new DynamicObject(masterDyType);
            master.set("id", (Object)masterVid);
            long adminBo = entryOrg.getLong("adminorg.boid");
            master.set("boid", (Object)adminBo);
            master.set("index", entryOrg.get("index"));
            master.set("structnumber", boVsStructNumber.get(entryOrg.getLong("adminorg.boid")));
            master.set("belongcompany.id", (Object)(EffectBillConstant.BELONG_COMPANY_SELF_TYPE.contains(entryOrg.getLong("adminorgtype.adminorgtypestd.id")) ? adminBo : 0L));
            master.set("parentorg.id", entryOrg.get("parentorg.boid"));
            master.set("adminorgtype.adminorgtypestd.id", entryOrg.get("adminorgtype.adminorgtypestd.id"));
            this.setBsed(master, adminBo);
            master.set("bsled", (Object)HisEffDateCommonService.getInstance().getDate2999(null));
            this.hisMasterDyList.add(master);
            long structVid = idCreator.getId();
            long orgId = entryOrg.getLong("adminorg.boid");
            DynamicObject effectingStruct = (DynamicObject)orgBoVsEffectingStruct.get(orgId);
            DynamicObject newStructDy = changeAdminOrgData.structDy;
            newStructDy.set("id", (Object)structVid);
            newStructDy.set("boid", effectingStruct.get("boid"));
            newStructDy.set("structlongnumber", effectingStruct.get("structlongnumber"));
            newStructDy.set("level", effectingStruct.get("level"));
            this.virtualVersionDyList.add(newStructDy);
            DynamicObject structDy = new DynamicObject(structDyType);
            structDy.set("id", (Object)structVid);
            structDy.set("adminorg.id", (Object)orgId);
            structDy.set("structlongnumber", effectingStruct.get("structlongnumber"));
            structDy.set("level", effectingStruct.get("level"));
            this.setBsed(structDy, adminBo);
            structDy.set("bsled", (Object)HisEffDateCommonService.getInstance().getDate2999(null));
            this.hisStructDyList.add(structDy);
            long sortCodeVid = idCreator.getId();
            DynamicObject effectingSortCode = (DynamicObject)orgBoVsEffectingSortCode.get(orgId);
            DynamicObject newSortCodeDy = changeAdminOrgData.sortCodeDy;
            newSortCodeDy.set("id", (Object)sortCodeVid);
            newSortCodeDy.set("boid", effectingSortCode.get("boid"));
            newSortCodeDy.set("sortcode", effectingSortCode.get("sortcode"));
            this.virtualVersionDyList.add(newSortCodeDy);
            DynamicObject sortCodeDy = new DynamicObject(sortCodeDyType);
            sortCodeDy.set("id", (Object)sortCodeVid);
            sortCodeDy.set("adminorg.id", (Object)orgId);
            sortCodeDy.set("sortcode", effectingSortCode.get("sortcode"));
            this.setBsed(sortCodeDy, adminBo);
            sortCodeDy.set("bsled", (Object)HisEffDateCommonService.getInstance().getDate2999(null));
            this.hisSortCodeDyList.add(sortCodeDy);
        });
    }

    private void setBsed(DynamicObject dynamicObject, long adminBo) {
        switch (this.billData.getBillType()) {
            case "2": 
            case "3": 
            case "1": {
                dynamicObject.set("bsed", (Object)this.billData.getEffectDate());
                break;
            }
            case "4": {
                dynamicObject.set("bsed", (Object)this.billData.getEntryOrgEffectDate(adminBo));
                break;
            }
            default: {
                throw new RuntimeException("no support bill type");
            }
        }
    }

    private Map<Long, DynamicObject> getOrgBoVsEffectingDy(List<DynamicObject> hisDyList) {
        Set orgBoSet = Stream.of(this.billData.getInfoBoSet(), this.billData.getParentBoSet(), this.billData.getDisableBoSet()).flatMap(Collection::stream).collect(Collectors.toSet());
        return hisDyList.stream().filter(dy -> orgBoSet.contains(dy.getLong("adminorg.id"))).collect(Collectors.groupingBy(dy -> dy.getLong("adminorg.id"))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.findEffectingDy((List)entry.getValue())));
    }

    private DynamicObject findEffectingDy(List<DynamicObject> dynamicObjectList) {
        return dynamicObjectList.stream().filter(dy -> dy.getDate("bsled").getTime() == HisEffDateCommonService.getInstance().getDate2999(null).getTime()).findAny().orElseThrow(() -> new RuntimeException("no effecting his version, entity name :" + ((DynamicObject)dynamicObjectList.get(0)).getDynamicObjectType().getName()));
    }

    private Date getEffectDate(Long boId) {
        Date effectDate = this.billData.getEffectDate();
        if ("4".equals(this.billData.getBillType())) {
            effectDate = this.billData.getEntryOrgEffectDate(boId);
        }
        return effectDate;
    }

    private void removeVersion(Set<Long> changeSceneBoSet) {
        Map<Long, List<DynamicObject>> boVsDyList = this.hisMasterDyList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        boVsDyList.entrySet().stream().filter(entry -> changeSceneBoSet.contains(entry.getKey())).map(Map.Entry::getValue).forEach(dyList -> {
            Date effectDate = this.getEffectDate(((DynamicObject)dyList.get(0)).getLong("boid"));
            LocalDateRange newEffectRange = LocalDateRange.ofClosed((Date)effectDate, (Date)HisEffDateCommonService.getInstance().getDate2999(null));
            dyList.forEach(hisMaster -> {
                LocalDateRange effectDateRangeFromHisDy = MethodHelper.getEffectDateRangeFromHisDy(hisMaster);
                if (newEffectRange.encloses(effectDateRangeFromHisDy)) {
                    this.hisMasterDyList.remove(hisMaster);
                } else if (newEffectRange.overlaps(effectDateRangeFromHisDy)) {
                    hisMaster.set("bsled", (Object)HRDateTimeUtils.addDay((Date)effectDate, (long)-1L));
                }
            });
        });
        Map<Long, List<DynamicObject>> boVsStructDyList = this.hisStructDyList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("adminorg.id")));
        boVsStructDyList.entrySet().stream().filter(entry -> changeSceneBoSet.contains(entry.getKey())).map(Map.Entry::getValue).forEach(dyList -> {
            Date effectDate = this.getEffectDate(((DynamicObject)dyList.get(0)).getLong("adminorg.id"));
            LocalDateRange newEffectRange = LocalDateRange.ofClosed((Date)effectDate, (Date)HisEffDateCommonService.getInstance().getDate2999(null));
            dyList.forEach(hisStruct -> {
                LocalDateRange effectDateRangeFromHisDy = MethodHelper.getEffectDateRangeFromHisDy(hisStruct);
                if (newEffectRange.encloses(effectDateRangeFromHisDy)) {
                    this.hisStructDyList.remove(hisStruct);
                } else if (newEffectRange.overlaps(effectDateRangeFromHisDy)) {
                    hisStruct.set("bsled", (Object)HRDateTimeUtils.addDay((Date)effectDate, (long)-1L));
                }
            });
        });
        Map<Long, List<DynamicObject>> boVsSortCodeDyList = this.hisSortCodeDyList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("adminorg.id")));
        boVsSortCodeDyList.entrySet().stream().filter(entry -> changeSceneBoSet.contains(entry.getKey())).map(Map.Entry::getValue).forEach(dyList -> {
            Date effectDate = this.getEffectDate(((DynamicObject)dyList.get(0)).getLong("adminorg.id"));
            LocalDateRange newEffectRange = LocalDateRange.ofClosed((Date)effectDate, (Date)HisEffDateCommonService.getInstance().getDate2999(null));
            dyList.forEach(hisSortCode -> {
                LocalDateRange effectDateRangeFromHisDy = MethodHelper.getEffectDateRangeFromHisDy(hisSortCode);
                if (newEffectRange.encloses(effectDateRangeFromHisDy)) {
                    this.hisSortCodeDyList.remove(hisSortCode);
                } else if (newEffectRange.overlaps(effectDateRangeFromHisDy)) {
                    hisSortCode.set("bsled", (Object)HRDateTimeUtils.addDay((Date)effectDate, (long)-1L));
                }
            });
        });
    }

    private void splitAddVersion() {
        if (this.billData.getChangeRootData() != null) {
            return;
        }
        Map boVsMasterDys = this.hisMasterDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), MethodHelper.listMapper(), MethodHelper.listAddAllMerger()));
        Map boVsStructDys = this.hisStructDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), MethodHelper.listMapper(), MethodHelper.listAddAllMerger()));
        Map boVsSortCodeDys = this.hisSortCodeDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), MethodHelper.listMapper(), MethodHelper.listAddAllMerger()));
        this.billData.getAddEntry().forEach(entryOrg -> {
            Date establishDate;
            Optional<LocalDateRange> parentEffectRangeOpt = ((List)boVsMasterDys.get(entryOrg.getLong("parentorg.boid"))).stream().map(MethodHelper::getEffectDateRangeFromHisDy).reduce(LocalDateRange::span);
            LocalDateRange parentEffectRange = parentEffectRangeOpt.get();
            if (!parentEffectRange.encloses(LocalDateRange.ofClosed((Date)(establishDate = entryOrg.getDate("establishmentdate")), (Date)HisEffDateCommonService.getInstance().getDate2999(null)))) {
                DynamicObject effectingHisMaster = (DynamicObject)((List)boVsMasterDys.get(entryOrg.getLong("adminorg.boid"))).get(0);
                Date newStartDate = MethodHelper.toDate(parentEffectRange.getStart());
                Date newEndDate = HRDateTimeUtils.addDay((Date)newStartDate, (long)-1L);
                effectingHisMaster.set("bsed", (Object)newStartDate);
                AdminOrgData newAdminOrgData = this.createNewAdminOrgData((DynamicObject)entryOrg);
                this.setStructNumber(newAdminOrgData);
                DynamicObject newMasterHisDy = this.copySpecialHisDy(effectingHisMaster, establishDate, newEndDate);
                newMasterHisDy.set("parentorg.id", (Object)0L);
                long belongCompanyId = EffectBillConstant.BELONG_COMPANY_SELF_TYPE.contains(newMasterHisDy.getLong("adminorgtype.adminorgtypestd.id")) ? newMasterHisDy.getLong("boid") : 0L;
                newMasterHisDy.set("belongcompany.id", (Object)belongCompanyId);
                this.hisMasterDyList.add(newMasterHisDy);
                ((List)boVsMasterDys.get(newAdminOrgData.getOrgBoId())).add(newMasterHisDy);
                DynamicObject virtualHisMaster = newAdminOrgData.orgDy;
                virtualHisMaster.set("id", (Object)newMasterHisDy.getLong("id"));
                virtualHisMaster.set("parentorg", null);
                virtualHisMaster.set("belongcompany", (Object)QueryHelper.generateEmptySubEntityMasterDy(belongCompanyId));
                this.virtualVersionDyList.add(virtualHisMaster);
                DynamicObject hisStructDy = (DynamicObject)((List)boVsStructDys.get(entryOrg.getLong("adminorg.boid"))).get(0);
                hisStructDy.set("bsed", (Object)newStartDate);
                DynamicObject newStructDy = this.copySpecialHisDy(hisStructDy, establishDate, newEndDate);
                newStructDy.set("structlongnumber", (Object)newMasterHisDy.getString("structnumber"));
                newStructDy.set("level", (Object)1);
                this.hisStructDyList.add(newStructDy);
                DynamicObject virtualHisStruct = newAdminOrgData.structDy;
                virtualHisStruct.set("id", (Object)newStructDy.getLong("id"));
                virtualHisStruct.set("boid", (Object)newStructDy.getLong("boid"));
                this.setDefaultValue(virtualHisStruct);
                virtualHisStruct.set("parentorg", null);
                this.virtualVersionDyList.add(virtualHisStruct);
                DynamicObject hisSortCodeDy = (DynamicObject)((List)boVsSortCodeDys.get(entryOrg.getLong("adminorg.boid"))).get(0);
                hisSortCodeDy.set("bsed", (Object)newStartDate);
                DynamicObject newSortCodeDy = this.copySpecialHisDy(hisSortCodeDy, establishDate, newEndDate);
                newSortCodeDy.set("sortcode", (Object)String.format("%05d", newMasterHisDy.getInt("index")));
                this.hisSortCodeDyList.add(newSortCodeDy);
                DynamicObject VirtualHisSortCode = newAdminOrgData.sortCodeDy;
                VirtualHisSortCode.set("id", (Object)newSortCodeDy.getLong("id"));
                VirtualHisSortCode.set("boid", (Object)newSortCodeDy.getLong("boid"));
                this.setDefaultValue(VirtualHisSortCode);
                this.virtualVersionDyList.add(VirtualHisSortCode);
            }
        });
    }

    private void setEffectDate(DynamicObject dynamicObject, Date establishDate, Date newEndDate) {
        dynamicObject.set("bsed", (Object)establishDate);
        dynamicObject.set("bsled", (Object)newEndDate);
    }

    private void setStructNumber(AdminOrgData adminOrgData) {
        adminOrgData.orgDy.set("structnumber", (Object)this.orgBoVsStructNumber.get(adminOrgData.getOrgBoId()));
    }

    private DynamicObject copySpecialHisDy(DynamicObject hisDy, Date establishDate, Date newEndDate) {
        DynamicObject newDy = new DynamicObject(hisDy.getDynamicObjectType());
        HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)newDy);
        newDy.set("id", (Object)ORM.create().genLongId((IDataEntityType)hisDy.getDynamicObjectType()));
        newDy.set("bsed", (Object)establishDate);
        newDy.set("bsled", (Object)newEndDate);
        return newDy;
    }

    public void setDefaultValue(DynamicObject dynamicObject) {
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("enable", (Object)"1");
    }

    public AdminOrgData createNewAdminOrgData(DynamicObject entryOrg) {
        return this.getAdminOrgData(entryOrg);
    }

    public AdminOrgData getChangeAdminOrgData(DynamicObject entryOrg) {
        return this.getAdminOrgData(entryOrg);
    }

    public AdminOrgData getDisableAdminOrgData(DynamicObject entryOrg) {
        AdminOrgData adminOrgData = this.getAdminOrgData(entryOrg);
        adminOrgData.orgDy.set("tobedisableflag", null);
        adminOrgData.orgDy.set("tobedisabledate", null);
        return adminOrgData;
    }

    private AdminOrgData getAdminOrgData(DynamicObject entryOrg) {
        DynamicObject dynamicObjectFromDB = this.billBoId2DynMapFromDBMap.get(entryOrg.getLong("adminorg.boid"));
        DynamicObject adminOrg = BusinessDataServiceHelper.newDynamicObject((String)AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        DynamicObject struct = BusinessDataServiceHelper.newDynamicObject((String)AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
        DynamicObject sortCode = BusinessDataServiceHelper.newDynamicObject((String)AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey());
        if (dynamicObjectFromDB != null) {
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObjectFromDB, (DynamicObject)adminOrg);
        }
        HRDynamicObjectUtils.copy((DynamicObject)entryOrg, (DynamicObject)adminOrg);
        DynamicObject hisParent = entryOrg.getDynamicObject("parentorg");
        DynamicObject parentAdminOrg = null;
        if (hisParent != null) {
            parentAdminOrg = BusinessDataServiceHelper.newDynamicObject((String)AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
            parentAdminOrg.set("id", (Object)hisParent.getLong("boid"));
            parentAdminOrg.set("boid", (Object)hisParent.getLong("boid"));
        }
        adminOrg.set("boid", entryOrg.get("adminorg.boid"));
        adminOrg.set("parentorg", (Object)parentAdminOrg);
        adminOrg.set("status", (Object)"C");
        adminOrg.set("enable", (Object)"1");
        String billEnable = entryOrg.getString("billenable");
        if (billEnable != null) {
            adminOrg.set("enable", (Object)billEnable);
            if (HRStringUtils.equals((String)billEnable, (String)"0")) {
                adminOrg.set("disabledate", (Object)entryOrg.getDate("bsed"));
                adminOrg.set("tobedisableflag", null);
                adminOrg.set("tobedisabledate", null);
            }
        }
        adminOrg.set("firstbsed", entryOrg.get("establishmentdate"));
        MultiVersionProcessor.copySpecifyValue4AdminOrgPart(adminOrg, struct);
        MultiVersionProcessor.copySpecifyValue4AdminOrgPart(adminOrg, sortCode);
        DynamicObject curOrg = BusinessDataServiceHelper.newDynamicObject((String)AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        curOrg.set("id", (Object)adminOrg.getLong("boid"));
        struct.set("adminorg", (Object)curOrg);
        sortCode.set("adminorg", (Object)curOrg);
        struct.set("parentorg", adminOrg.get("parentorg"));
        sortCode.set("index", adminOrg.get("index"));
        struct.set("structproject", (Object)this.getAdminOrgStructProject());
        this.setBelongCompany(adminOrg);
        this.setBelongDepartment(adminOrg);
        return new AdminOrgData(adminOrg, struct, sortCode);
    }

    private void setBelongDepartment(DynamicObject adminOrg) {
        DynamicObject belongDepartment;
        if (1040L == adminOrg.getLong("adminorgtype.adminorgtypestd.id")) {
            MainEntityType orgDetail = MetadataServiceHelper.getDataEntityType((String)"haos_adminorgdetail");
            DynamicProperty belongDepartmentProperty = orgDetail.getProperty("belongdept");
            DynamicObjectType belongDepartmentType = ((BasedataProp)belongDepartmentProperty).getDynamicComplexPropertyType();
            belongDepartment = new DynamicObject(belongDepartmentType);
            HRDynamicObjectUtils.copy((DynamicObject)adminOrg, (DynamicObject)belongDepartment);
            belongDepartment.set("id", (Object)adminOrg.getLong("boid"));
        } else {
            belongDepartment = null;
        }
        adminOrg.set("belongdept", belongDepartment);
    }

    private void setBelongCompany(DynamicObject adminOrg) {
        if (EffectBillConstant.BELONG_COMPANY_SELF_TYPE.contains(adminOrg.getLong("adminorgtype.adminorgtypestd.id"))) {
            MainEntityType orgDetail = MetadataServiceHelper.getDataEntityType((String)"haos_adminorgdetail");
            DynamicProperty belongCompanyProperty = orgDetail.getProperty("belongcompany");
            DynamicObjectType belongCompanyType = ((BasedataProp)belongCompanyProperty).getDynamicComplexPropertyType();
            DynamicObject belongCompany = new DynamicObject(belongCompanyType);
            HRDynamicObjectUtils.copy((DynamicObject)adminOrg, (DynamicObject)belongCompany);
            belongCompany.set("id", (Object)adminOrg.getLong("boid"));
            adminOrg.set("belongcompany", (Object)belongCompany);
        }
    }

    private DynamicObject getAdminOrgStructProject() {
        if (this.adminStructProjectDy == null) {
            this.adminStructProjectDy = StructProjectRepository.getInstance().loadByIds(Collections.singletonList(1010L))[0];
        }
        return this.adminStructProjectDy;
    }

    private static void copySpecifyValue4AdminOrgPart(DynamicObject from, DynamicObject to) {
        to.set("status", from.get("status"));
        to.set("enable", from.get("enable"));
    }

    private List<Pair<Long, Date>> getParentBoOfAddVsEstDtBeforeBillEffDt() {
        Date billEffDt = this.billData.getEffectDate();
        return this.billData.getAddEntry().stream().map(dy -> new Pair((Object)dy.getLong("parentorg.boid"), (Object)dy.getDate("establishmentdate"))).filter(pair -> ((Date)pair.getValue()).before(billEffDt)).collect(Collectors.toList());
    }

    public void setBillData(BillData billData) {
        this.billData = billData;
    }

    public List<DynamicObject> getHisMasterDyList() {
        return this.hisMasterDyList;
    }

    public List<DynamicObject> getHisStructDyList() {
        return this.hisStructDyList;
    }

    public List<DynamicObject> getHisSortCodeDyList() {
        return this.hisSortCodeDyList;
    }

    public List<DynamicObject> getVirtualVersionDyList() {
        return this.virtualVersionDyList;
    }

    static class OrgDataQueryResult {
        List<DynamicObject> masterDys;
        List<DynamicObject> structDys;
        List<DynamicObject> sortCodeDys;

        OrgDataQueryResult() {
        }
    }

    static class ThisBillEntryOrgBo {
        Set<Long> parentBoIdSet = new HashSet<Long>();
        Set<Long> boIdSet = new HashSet<Long>();
        Set<Long> oldParentBoIdSet = new HashSet<Long>();

        public Set<Long> getAllBoIdSet() {
            HashSet<Long> orgBoIdList = new HashSet<Long>();
            orgBoIdList.addAll(this.boIdSet);
            orgBoIdList.addAll(this.parentBoIdSet);
            orgBoIdList.addAll(this.oldParentBoIdSet);
            return orgBoIdList;
        }
    }
}

