/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.bean.OrgTeamBasicInfoBO;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.business.service.adminorg.businessfile.AdminOrgBusinessFileService;
import kd.hr.haos.business.service.adminorg.fourlayermodel.Expression;
import kd.hr.haos.business.service.adminorg.fourlayermodel.OrgInfoExpression;
import kd.hr.haos.business.service.adminorg.fourlayermodel.OrgTypeChangeOnly4BatchChang;
import kd.hr.haos.business.service.adminorg.teamcoop.OrgTeamCoopRelService;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.haos.common.model.ChangeRootData;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.batcheffect.MethodHelper;
import kd.hr.homs.business.service.batcheffect.QueryHelper;
import kd.hr.homs.business.service.batcheffect.bo.AdminOrgData;
import kd.hr.homs.business.service.batcheffect.bo.AdminOrgDataEntryBO;
import kd.hr.homs.business.service.batcheffect.bo.BillData;
import kd.hr.homs.business.service.batcheffect.bo.OrgTeamData;
import kd.hr.homs.business.service.batcheffect.bo.OtherData;
import kd.hr.homs.business.service.batcheffect.constant.EffectBillConstant;
import kd.hr.homs.business.service.batcheffect.fieldchange.FieldChangeHolder;
import kd.hr.homs.business.service.batcheffect.fieldchange.FieldChangeRecorder;
import kd.hr.homs.business.service.batcheffect.util.IdCreator;

public class OrgHisParamCreator {
    private List<AdminOrgData> cascadeOrgDataList;
    private List<AdminOrgData> addCascadeOrgDataList;
    private BillData billData;
    private Map<String, List<DynamicObject>> entityNameVsDyList = new HashMap<String, List<DynamicObject>>();
    private AdminOrgDataEntryBO entryOrgDataListBO;
    private Map<Long, OtherData> otherDataMapLoadFromDB;
    private Map<Long, OrgTeamData> orgTeamDataMapLoadFromDB;
    private Map<Long, AdminOrgData> tempAdminOrgDataLoadFromDB;
    private Map<Long, DynamicObject> oldGroupInfoDynMap;
    private Map<Long, DynamicObject> oldCompInfoDynMap;
    private Map<Long, DynamicObject> oldDepartmentInfoDynMap;
    private OrgTeamInfo orgTeamInfo = new OrgTeamInfo();
    private FieldChangeRecorder<Long> adminOrgTypeChangedRecorder;
    private Set<Long> enableEntryOrgIdSet;
    private Map<Long, Long> firstVersionMap;
    private String openApiFlag;

    public Map<Long, Long> getFirstVersionMap() {
        return this.firstVersionMap;
    }

    public void setFirstVersionMap(Map<Long, Long> firstVersionMap) {
        this.firstVersionMap = firstVersionMap;
    }

    public void setOpenApiFlag(String openApiFlag) {
        this.openApiFlag = openApiFlag;
    }

    public OrgHisParamCreator() {
        this.orgTeamInfo.numberPrefix = OrgTeamSynService.getOrgTeamNumberPrefix((Long)OrgTeamInfo.ORG_TEAM_BASIC_INFO_BO.getNumberPrefix());
    }

    private void initOTData() {
        List<Long> needChangedOrgTeamIdList = Stream.of(this.entryOrgDataListBO.disableAdminOrgDataList, this.entryOrgDataListBO.infoChangeAdminOrgDataList, this.entryOrgDataListBO.parentChangeAdminOrgDataList, this.cascadeOrgDataList).flatMap(Collection::stream).map(AdminOrgData::getOrgBoId).collect(Collectors.toList());
        DynamicObject[] orgTeamDys = QueryHelper.loadOrgTeamByOrgBoId(needChangedOrgTeamIdList);
        DynamicObject[] orgTeamStructDys = QueryHelper.loadOrgTeamStructByOrgBoId(needChangedOrgTeamIdList);
        Map<Long, DynamicObject> orgTeamIdVsStructDy = MethodHelper.toLongVsDyMap(Arrays.asList(orgTeamStructDys), "orgteam.id");
        this.orgTeamDataMapLoadFromDB = Arrays.stream(orgTeamDys).map(orgTeamDy -> {
            OrgTeamData orgTeamData = new OrgTeamData();
            orgTeamData.orgTeamDy = orgTeamDy;
            orgTeamData.structDy = (DynamicObject)orgTeamIdVsStructDy.get(orgTeamDy.getLong("boid"));
            return orgTeamData;
        }).collect(Collectors.toMap(orgTeamData -> orgTeamData.orgTeamDy.getLong("boid"), orgTeamData -> orgTeamData));
    }

    private void initBusinessFile() {
        List<Long> entryAdminOrgIdList = Stream.of(this.entryOrgDataListBO.disableAdminOrgDataList, this.entryOrgDataListBO.infoChangeAdminOrgDataList, this.entryOrgDataListBO.parentChangeAdminOrgDataList).flatMap(Collection::stream).map(AdminOrgData::getOrgBoId).collect(Collectors.toList());
        entryAdminOrgIdList.addAll(this.enableEntryOrgIdSet);
        DynamicObject[] businessFileDys = QueryHelper.loadBusinessFileByOrgBoId(entryAdminOrgIdList);
        this.otherDataMapLoadFromDB = Arrays.stream(businessFileDys).map(businessFileDy -> {
            OtherData otherData = new OtherData();
            otherData.businessFileDy = businessFileDy;
            return otherData;
        }).collect(Collectors.toMap(otherData -> otherData.businessFileDy.getLong("adminorg.id"), otherData -> otherData));
    }

    private void initFourLayerDataFromDB() {
        List entryOrgBoIdList = this.entryOrgDataListBO.getAll().stream().map(AdminOrgData::getOrgBoId).collect(Collectors.toList());
        this.oldGroupInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(entryOrgBoIdList, (String)AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), (String)"adminorg");
        this.oldCompInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(entryOrgBoIdList, (String)AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), (String)"adminorg");
        this.oldDepartmentInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(entryOrgBoIdList, (String)AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), (String)"adminorg");
    }

    public void execute() {
        this.initBusinessFile();
        this.initFourLayerDataFromDB();
        this.initOTData();
        this.initTempData();
        Stream.of(new CascadeCreator().createWithCommonField(), new NewCreator().createWithCommonField(), new DisableCreator().createWithCommonField(), new EnableCreator().createWithCommonField(), new ChangeCreator(this.openApiFlag).createWithCommonField(), new SpecialNewCreator().createWithCommonField()).flatMap(Collection::stream).forEach(orgHisData -> {
            this.addToMap(this.entityNameVsDyList, orgHisData.adminOrg);
            this.addToMap(this.entityNameVsDyList, orgHisData.adminOrgStruct);
            this.addToMap(this.entityNameVsDyList, orgHisData.adminOrgSortCode);
            this.addToMap(this.entityNameVsDyList, orgHisData.orgTeam);
            this.addToMap(this.entityNameVsDyList, orgHisData.orgTeamStruct);
            this.addToMap(this.entityNameVsDyList, orgHisData.coopRelList);
            this.addToMap(this.entityNameVsDyList, orgHisData.group);
            this.addToMap(this.entityNameVsDyList, orgHisData.company);
            this.addToMap(this.entityNameVsDyList, orgHisData.department);
            this.addToMap(this.entityNameVsDyList, orgHisData.businessFile);
        });
        this.spiltNewAdminVersionIfNeed();
    }

    private void spiltNewAdminVersionIfNeed() {
        List adminOrgTeam = this.entityNameVsDyList.getOrDefault("haos_adminorgteam", new ArrayList());
        List allAdminOrg = this.entityNameVsDyList.getOrDefault("haos_adminorgdetail", new ArrayList());
        List allNewBoIds = this.entryOrgDataListBO.addAdminOrgDataList.stream().map(dyn -> dyn.getOrgBoId()).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> boIdToDynamicObjets = allAdminOrg.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("boid")));
        List exceptNewOrg = adminOrgTeam.stream().filter(dyn -> !allNewBoIds.contains(dyn.getLong("boid")) && (dyn.getLong("boid") != 0L || !allNewBoIds.contains(dyn.getLong("id")))).collect(Collectors.toList());
        HashMap<Long, List<DynamicObject>> newBoIdToDynamicObjects = new HashMap<Long, List<DynamicObject>>(16);
        ArrayList<DynamicObject> newNeedSaveList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needSaveList = new ArrayList<DynamicObject>(10);
        for (Map.Entry<Long, List<DynamicObject>> entry : boIdToDynamicObjets.entrySet()) {
            if (allNewBoIds.contains(entry.getKey())) {
                newBoIdToDynamicObjects.put(entry.getKey(), entry.getValue());
                continue;
            }
            needSaveList.addAll((Collection<DynamicObject>)entry.getValue());
        }
        this.spilt(newBoIdToDynamicObjects, newNeedSaveList, needSaveList);
        ArrayList<DynamicObject> otList = new ArrayList<DynamicObject>(newNeedSaveList.size());
        for (DynamicObject dyn2 : newNeedSaveList) {
            DynamicObject otDy = OrgTeamSynService.getInstance().createAddNewOrgTeam(dyn2, OrgTeamInfo.ORG_TEAM_BASIC_INFO_BO, this.orgTeamInfo.numberPrefix);
            otDy.set("boid", (Object)dyn2.getLong("boid"));
            otList.add(otDy);
        }
        exceptNewOrg.addAll(otList);
        this.entityNameVsDyList.put("haos_adminorgdetail", needSaveList);
        this.entityNameVsDyList.put("haos_adminorgteam", exceptNewOrg);
    }

    private void spilt(Map<Long, List<DynamicObject>> newBoIdToDynamicObjects, List<DynamicObject> newNeedSaveList, List<DynamicObject> needSaveList) {
        IdCreator idCreator = new IdCreator();
        for (Map.Entry<Long, List<DynamicObject>> entry : newBoIdToDynamicObjects.entrySet()) {
            List<DynamicObject> value = entry.getValue();
            List effectingAdmin = value.stream().filter(dyn -> HisEffDateCommonService.getInstance().getDate2999(null).equals(dyn.getDate("bsled"))).collect(Collectors.toList());
            List invalidAdmin = value.stream().filter(dyn -> !HisEffDateCommonService.getInstance().getDate2999(null).equals(dyn.getDate("bsled"))).collect(Collectors.toList());
            if (effectingAdmin.size() <= 0) continue;
            DynamicObject effectingAdminOrg = (DynamicObject)effectingAdmin.get(0);
            LocalDateRange itemDateRange = LocalDateRangeUtils.getEffectRange((DynamicObject)effectingAdminOrg);
            List<DynamicObject> overLapAdmin = invalidAdmin.stream().filter(dyn -> itemDateRange.overlaps(LocalDateRangeUtils.getEffectRange((DynamicObject)dyn))).collect(Collectors.toList());
            List noOverLapAdmin = invalidAdmin.stream().filter(dyn -> !itemDateRange.overlaps(LocalDateRangeUtils.getEffectRange((DynamicObject)dyn))).collect(Collectors.toList());
            needSaveList.addAll(noOverLapAdmin);
            if (overLapAdmin.stream().anyMatch(dy -> itemDateRange.overlaps(LocalDateRangeUtils.getEffectRange((DynamicObject)dy)))) {
                ArrayList dateRangeList = new ArrayList(overLapAdmin.size());
                overLapAdmin.forEach(dy -> dateRangeList.add(LocalDateRangeUtils.getEffectRange((DynamicObject)dy)));
                List subtractList = itemDateRange.subtract(dateRangeList);
                for (LocalDateRange dateRange : subtractList) {
                    DynamicObject newDy = new DynamicObject(effectingAdminOrg.getDynamicObjectType());
                    HRDynamicObjectUtils.copy((DynamicObject)effectingAdminOrg, (DynamicObject)newDy);
                    LocalDateRangeUtils.setEffectRange((DynamicObject)newDy, (LocalDateRange)dateRange);
                    newDy.set("id", (Object)idCreator.getId());
                    AdminOrgData adminOrgData = this.tempAdminOrgDataLoadFromDB.get(newDy.getLong("boid"));
                    if (adminOrgData != null && HisEffDateCommonService.getInstance().getDate2999(null).equals(newDy.getDate("bsled"))) {
                        DynamicObject orgDy = adminOrgData.orgDy;
                        if (orgDy == null) continue;
                        orgDy.set("bsed", (Object)newDy.getDate("bsed"));
                        needSaveList.add(orgDy);
                        newNeedSaveList.add(orgDy);
                        continue;
                    }
                    needSaveList.add(newDy);
                    newNeedSaveList.add(newDy);
                }
                needSaveList.addAll(overLapAdmin);
                newNeedSaveList.addAll(overLapAdmin);
                continue;
            }
            needSaveList.add(effectingAdminOrg);
            newNeedSaveList.add(effectingAdminOrg);
        }
    }

    private void initTempData() {
        ArrayList<Long> orgBoIdList = new ArrayList<Long>(this.billData.getAddBoSet());
        DynamicObject[] structDataDys = QueryHelper.loadStructByOrgBoId(orgBoIdList);
        DynamicObject[] masterDataDys = QueryHelper.loadMasterDataByOrgBoId(orgBoIdList);
        DynamicObject[] sortCodeDys = QueryHelper.loadSortCodeByOrgBoId(orgBoIdList);
        Map<Long, DynamicObject> orgBoIdVsMasterData = MethodHelper.toLongVsDyMap(Arrays.asList(masterDataDys), "boid");
        Map<Long, DynamicObject> orgBoIdVsStruct = MethodHelper.toLongVsDyMap(Arrays.asList(structDataDys), "adminorg.id");
        Map<Long, DynamicObject> orgBoIdVsSortCode = MethodHelper.toLongVsDyMap(Arrays.asList(sortCodeDys), "adminorg.id");
        this.tempAdminOrgDataLoadFromDB = new HashMap<Long, AdminOrgData>();
        orgBoIdList.stream().map(orgBo -> new AdminOrgData((DynamicObject)orgBoIdVsMasterData.get(orgBo), (DynamicObject)orgBoIdVsStruct.get(orgBo), (DynamicObject)orgBoIdVsSortCode.get(orgBo))).forEach(adminOrgData -> this.tempAdminOrgDataLoadFromDB.put(adminOrgData.getOrgBoId(), (AdminOrgData)adminOrgData));
    }

    public List<HisVersionParamBo> createEffectingVersionList() {
        Date date2999 = MethodHelper.getDate2999();
        return this.createVersionList(dy -> date2999.equals(dy.getDate("bsled")));
    }

    public List<HisVersionParamBo> createInvalidVersionList() {
        Date date2999 = MethodHelper.getDate2999();
        return this.createVersionList(dy -> !date2999.equals(dy.getDate("bsled")));
    }

    private List<HisVersionParamBo> createVersionList(Predicate<DynamicObject> isEffecting) {
        ArrayList<HisVersionParamBo> hisBoList = new ArrayList<HisVersionParamBo>();
        this.entityNameVsDyList.values().stream().map(dynamicObjectList -> {
            HisVersionParamBo hisVersionParam = this.getHisVersionParam((DynamicObject[])dynamicObjectList.stream().filter(isEffecting).toArray(DynamicObject[]::new));
            hisVersionParam.setNeedProcessAttachment(false);
            return hisVersionParam;
        }).filter(hisVersionParamBo -> hisVersionParamBo.getHisDyns() != null && hisVersionParamBo.getHisDyns().length != 0).forEach(hisBoList::add);
        return hisBoList;
    }

    private void addToMap(Map<String, List<DynamicObject>> entityNameVsDyList, List<DynamicObject> dynamicObjectList) {
        if (dynamicObjectList != null && dynamicObjectList.size() != 0) {
            entityNameVsDyList.computeIfAbsent(dynamicObjectList.get(0).getDynamicObjectType().getName(), key -> new ArrayList()).addAll(dynamicObjectList);
        }
    }

    private void addToMap(Map<String, List<DynamicObject>> entityNameVsDyList, DynamicObject dynamicObject) {
        if (dynamicObject != null) {
            entityNameVsDyList.computeIfAbsent(dynamicObject.getDynamicObjectType().getName(), key -> new ArrayList()).add(dynamicObject);
        }
    }

    public HisVersionParamBo getHisVersionParam(DynamicObject[] hisDyns) {
        String entityNumber = "";
        if (hisDyns != null && hisDyns.length > 0) {
            entityNumber = hisDyns[0].getDynamicObjectType().getName();
        }
        if (hisDyns != null && "haos_adminorgdetail".equals(entityNumber)) {
            this.setFirstVersionThreadLocal(hisDyns);
        }
        return AdminOrgHisServiceHelper.getHisVersionParam((DynamicObject[])hisDyns, (String)entityNumber, (boolean)false);
    }

    private void setFirstVersionThreadLocal(DynamicObject[] hisDyns) {
        HashMap<Long, Pair> boIdToVidPair = new HashMap<Long, Pair>();
        HashMap<Long, Long> boIdToVid = new HashMap<Long, Long>();
        IdCreator idCreator = new IdCreator();
        for (int idx = 0; idx < hisDyns.length; ++idx) {
            if (!this.billData.getAddBoSet().contains(hisDyns[idx].getLong("id"))) continue;
            long vid = idCreator.getId();
            boIdToVidPair.put(hisDyns[idx].getLong("id"), new Pair((Object)idx, (Object)vid));
            boIdToVid.put(hisDyns[idx].getLong("id"), vid);
        }
        if (boIdToVidPair.size() != 0) {
            long[] firstVersionIds = new long[hisDyns.length];
            for (Map.Entry entry : boIdToVidPair.entrySet()) {
                Long key = (Long)entry.getKey();
                Pair value = (Pair)entry.getValue();
                for (int idx = 0; idx < hisDyns.length; ++idx) {
                    if (!key.equals(hisDyns[idx].getLong("id"))) continue;
                    firstVersionIds[((Integer)value.getKey()).intValue()] = (Long)value.getValue();
                }
            }
            AdminOrgHisServiceHelper.FIRST_VERSION_IDS.set(firstVersionIds);
            this.firstVersionMap = boIdToVid;
        }
    }

    public void setEntryOrgDataListBO(AdminOrgDataEntryBO entryOrgDataListBO) {
        this.entryOrgDataListBO = entryOrgDataListBO;
    }

    public void setCascadeOrgDataList(List<AdminOrgData> cascadeOrgDataList) {
        this.cascadeOrgDataList = cascadeOrgDataList;
    }

    public void setBillData(BillData billData) {
        this.billData = billData;
    }

    public void setAddCascadeOrgDataList(List<AdminOrgData> addCascadeOrgDataList) {
        this.addCascadeOrgDataList = addCascadeOrgDataList;
    }

    public void setEnableEntryOrgIdSet(Set<Long> enableEntryOrgIdSet) {
        this.enableEntryOrgIdSet = enableEntryOrgIdSet;
    }

    private static DynamicObject copyToNewDy(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)dynamicObject.getDynamicObjectType().getName());
        HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)newDynamicObject);
        return newDynamicObject;
    }

    private static DynamicObject copyToNewDy(DynamicObject from, String entityName) {
        DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        HRDynamicObjectUtils.copy((DynamicObject)from, (DynamicObject)newDynamicObject);
        return newDynamicObject;
    }

    public void setAdminOrgTypeChangedRecorder(FieldChangeRecorder<Long> adminOrgTypeChangedRecorder) {
        this.adminOrgTypeChangedRecorder = adminOrgTypeChangedRecorder;
    }

    static class OrgHisData {
        DynamicObject adminOrg;
        DynamicObject adminOrgStruct;
        DynamicObject adminOrgSortCode;
        DynamicObject company;
        DynamicObject group;
        DynamicObject department;
        DynamicObject businessFile;
        DynamicObject orgTeam;
        DynamicObject orgTeamStruct;
        List<DynamicObject> coopRelList = Collections.emptyList();
        boolean onlyCoopRelTag = false;
        static ThreadLocal<Long> adminOrgBoIdThreadLocal = new ThreadLocal();

        OrgHisData() {
        }

        long getOrgBoId() {
            if (this.adminOrg != null) {
                return this.adminOrg.getLong("boid");
            }
            if (this.adminOrgStruct != null) {
                return this.adminOrgStruct.getLong("adminorg.id");
            }
            if (this.adminOrgSortCode != null) {
                return this.adminOrgSortCode.getLong("adminorg.id");
            }
            throw new RuntimeException("can not get bo id from no data");
        }
    }

    class ChangeCreator
    extends AbstractOrgHisCreator {
        private IdCreator idCreator;
        private String openApiFlag;

        public ChangeCreator(String openApiFlag) {
            this.openApiFlag = openApiFlag;
            this.sceneTag = 2;
            this.idCreator = new IdCreator();
        }

        @Override
        protected Consumer<DynamicObject> belongCompanyChangeTypeSetter() {
            return org -> {
                long boId = org.getLong("boid");
                FieldChangeHolder<Long> belongCompanyChangeHolder = OrgHisParamCreator.this.billData.getBelongCompanyChangedRecorder().getHolder(boId);
                belongCompanyChangeHolder.setNewValue(org.getLong("belongcompany.id"));
                if (belongCompanyChangeHolder.isChanged()) {
                    if (OrgHisParamCreator.this.billData.getParentBoSet().contains(boId) || OrgHisParamCreator.this.billData.getOrgTypeChangedBoSet().contains(boId)) {
                        org.set("companychangetype", (Object)AdminOrgConstants.CompanyChangeType.SELF_CHANGE.code());
                    } else {
                        org.set("companychangetype", (Object)AdminOrgConstants.CompanyChangeType.FOLLOW_CHANGE.code());
                    }
                } else {
                    org.set("companychangetype", (Object)AdminOrgConstants.CompanyChangeType.NO_CHANGE.code());
                }
            };
        }

        @Override
        public List<OrgHisData> create() {
            List<OrgHisData> orgHisDataList = Stream.of(((OrgHisParamCreator)OrgHisParamCreator.this).entryOrgDataListBO.parentChangeAdminOrgDataList, ((OrgHisParamCreator)OrgHisParamCreator.this).entryOrgDataListBO.infoChangeAdminOrgDataList).flatMap(Collection::stream).filter(adminOrgData -> !OrgHisParamCreator.this.enableEntryOrgIdSet.contains(adminOrgData.getOrgBoId())).map(adminOrgData -> {
                long vid = this.idCreator.getId();
                long orgBoId = adminOrgData.getOrgBoId();
                OrgHisData orgHisData = new OrgHisData();
                orgHisData.adminOrg = OrgHisParamCreator.copyToNewDy(adminOrgData.orgDy);
                orgHisData.adminOrg.set("id", (Object)vid);
                orgHisData.adminOrgStruct = OrgHisParamCreator.copyToNewDy(adminOrgData.structDy);
                this.setIsRootValue(orgHisData.adminOrgStruct);
                orgHisData.adminOrgSortCode = OrgHisParamCreator.copyToNewDy(adminOrgData.sortCodeDy);
                this.createFourLayerData(orgHisData, adminOrgData.orgDy);
                orgHisData.businessFile = this.changeBusinessFile(adminOrgData.orgDy);
                OrgTeamData orgTeamData = (OrgTeamData)OrgHisParamCreator.this.orgTeamDataMapLoadFromDB.get(orgBoId);
                orgHisData.orgTeam = OrgHisParamCreator.copyToNewDy(orgTeamData.orgTeamDy);
                orgHisData.orgTeam.set("id", (Object)vid);
                orgHisData.orgTeam.set("parent", orgHisData.adminOrg.get("parentorg"));
                orgHisData.orgTeamStruct = OrgHisParamCreator.copyToNewDy(orgTeamData.structDy);
                orgHisData.orgTeamStruct.set("orgteamhisid", (Object)vid);
                orgHisData.orgTeamStruct.set("otclassify", (Object)1010L);
                String billenable = this.getBillEnable(orgHisData.adminOrg);
                if (billenable != null) {
                    this.setEnable(orgHisData.orgTeam, billenable);
                    this.setEnable(orgHisData.orgTeamStruct, billenable);
                }
                return orgHisData;
            }).collect(Collectors.toList());
            OrgHisData orgHisData = new OrgHisData();
            orgHisData.coopRelList = this.createCoopRel(this.openApiFlag);
            orgHisData.onlyCoopRelTag = true;
            orgHisDataList.add(orgHisData);
            this.synOrgTeamField(orgHisDataList);
            return orgHisDataList;
        }

        private String getBillEnable(DynamicObject dyn) {
            if (!dyn.getDynamicObjectType().getProperties().containsKey((Object)"billenable")) {
                return null;
            }
            return dyn.getString("billenable");
        }

        private void setEnable(DynamicObject dyn, String billEnable) {
            if (dyn == null) {
                return;
            }
            dyn.set("enable", (Object)billEnable);
        }

        private DynamicObject changeBusinessFile(DynamicObject adminOrg) {
            DynamicObject oldBusinessFile = ((OtherData)((OrgHisParamCreator)OrgHisParamCreator.this).otherDataMapLoadFromDB.get((Object)Long.valueOf((long)adminOrg.getLong((String)"boid")))).businessFileDy;
            if (adminOrg.getLong("org.id") == oldBusinessFile.getLong("org.id")) {
                String oldEnable = oldBusinessFile.getString("enable");
                String newEnable = adminOrg.getString("billenable");
                if (newEnable != null && !HRStringUtils.equals((String)oldEnable, (String)newEnable)) {
                    DynamicObject copy = OrgHisParamCreator.copyToNewDy(oldBusinessFile);
                    copy.set("org", adminOrg.get("org"));
                    copy.set("enable", (Object)newEnable);
                    return copy;
                }
                return null;
            }
            DynamicObject copy = OrgHisParamCreator.copyToNewDy(oldBusinessFile);
            copy.set("org", adminOrg.get("org"));
            return copy;
        }

        private void synOrgTeamField(List<OrgHisData> orgHisDataList) {
            orgHisDataList.stream().filter(orgHisData -> !orgHisData.onlyCoopRelTag).forEach(orgHisData -> {
                this.synOrgTeamBizFields((OrgHisData)orgHisData);
                this.synOrgTeamStructBizFields((OrgHisData)orgHisData);
            });
        }

        private List<DynamicObject> createCoopRel(String openApiFlag) {
            Map changeCurBatchOrgCoopRelBOMap = AdminOrgHisServiceHelper.getCurBatchOrgCoopRelBOMap((DynamicObject[])((DynamicObject[])Stream.of(((OrgHisParamCreator)OrgHisParamCreator.this).entryOrgDataListBO.infoChangeAdminOrgDataList, ((OrgHisParamCreator)OrgHisParamCreator.this).entryOrgDataListBO.parentChangeAdminOrgDataList).flatMap(Collection::stream).map(adminOrgData -> adminOrgData.orgDy).toArray(DynamicObject[]::new)));
            HisVersionParamBo changeHisVersionParam = HRStringUtils.equals((String)"1", (String)openApiFlag) ? OrgTeamCoopRelService.getInstance().buildChangeHisParamOpenApi(changeCurBatchOrgCoopRelBOMap, OrgHisParamCreator.this.billData.getEffectDate()) : OrgTeamCoopRelService.getInstance().buildChangeHisParam(changeCurBatchOrgCoopRelBOMap, OrgHisParamCreator.this.billData.getEffectDate(), OrgHisParamCreator.this.billData.getChangeRootData() != null);
            return Arrays.asList(changeHisVersionParam.getHisDyns());
        }

        private void createFourLayerData(OrgHisData orgHisData, DynamicObject adminOrg) {
            FieldChangeHolder holder = OrgHisParamCreator.this.adminOrgTypeChangedRecorder.getHolder(adminOrg.getLong("boid"));
            if (holder == null) {
                return;
            }
            OrgInfoExpression expression = new OrgInfoExpression(null, OrgHisParamCreator.this.oldGroupInfoDynMap, OrgHisParamCreator.this.oldCompInfoDynMap, OrgHisParamCreator.this.oldDepartmentInfoDynMap);
            expression.setCurOrg(adminOrg);
            Pair typePair = new Pair((Object)AdminOrgType.getById((long)((Long)holder.getOldValue())), (Object)AdminOrgType.getById((long)((Long)holder.getNewValue())));
            expression.setTypePair(typePair);
            Map result = OrgTypeChangeOnly4BatchChang.RuleEngine.process((Expression)expression);
            result.forEach((key, value) -> {
                switch (key) {
                    case "haos_adminorggroup": {
                        orgHisData.group = value;
                        break;
                    }
                    case "haos_adminorgcompany": {
                        orgHisData.company = value;
                        break;
                    }
                    case "haos_adminorgdepartment": {
                        orgHisData.department = value;
                        break;
                    }
                }
            });
        }
    }

    class EnableCreator
    extends AbstractOrgHisCreator {
        private IdCreator idCreator;

        public EnableCreator() {
            this.sceneTag = 6;
            this.idCreator = new IdCreator();
        }

        @Override
        protected Consumer<DynamicObject> belongCompanyChangeTypeSetter() {
            return org -> {
                long boId = org.getLong("boid");
                FieldChangeHolder<Long> belongCompanyChangeHolder = OrgHisParamCreator.this.billData.getBelongCompanyChangedRecorder().getHolder(boId);
                belongCompanyChangeHolder.setNewValue(org.getLong("belongcompany.id"));
                if (belongCompanyChangeHolder.isChanged()) {
                    org.set("companychangetype", (Object)AdminOrgConstants.CompanyChangeType.FOLLOW_CHANGE.code());
                } else {
                    org.set("companychangetype", (Object)AdminOrgConstants.CompanyChangeType.NO_CHANGE.code());
                }
            };
        }

        @Override
        public List<OrgHisData> create() {
            HRBaseServiceHelper coopRelationHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
            QFilter hisFilter = new QFilter("datastatus", "=", (Object)"1").and("iscurrentversion", "=", (Object)"0");
            QFilter adminOrgFilter = new QFilter("org.id", "in", (Object)OrgHisParamCreator.this.enableEntryOrgIdSet);
            DynamicObject[] enableCoopInfo = coopRelationHelper.loadDynamicObjectArray(new QFilter[]{adminOrgFilter, hisFilter});
            Map<Long, List<DynamicObject>> orgIdVsCoopRelList = Arrays.stream(enableCoopInfo).collect(Collectors.groupingBy(dy -> dy.getLong("org.id")));
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
            QFilter filter = new QFilter("boid", "in", (Object)OrgHisParamCreator.this.enableEntryOrgIdSet);
            DynamicObject[] orgCreateTimeArr = serviceHelper.query("createtime,boid", new QFilter[]{filter, hisFilter});
            Map<Long, Date> orgCreateTimeMap = Arrays.stream(orgCreateTimeArr).collect(Collectors.toMap(obj -> obj.getLong("boid"), obj -> obj.getDate("createtime"), (v1, v2) -> v1));
            List<OrgHisData> collect = ((OrgHisParamCreator)OrgHisParamCreator.this).entryOrgDataListBO.infoChangeAdminOrgDataList.stream().filter(adminOrgData -> OrgHisParamCreator.this.enableEntryOrgIdSet.contains(adminOrgData.getOrgBoId())).map(adminOrgData -> {
                Long adminOrgTypeId;
                long vid = this.idCreator.getId();
                long orgBoId = adminOrgData.getOrgBoId();
                OrgHisData orgHisData = new OrgHisData();
                orgHisData.adminOrg = this.copy2NewDy4Enable(adminOrgData.orgDy);
                orgHisData.adminOrg.set("id", (Object)vid);
                orgHisData.adminOrgStruct = this.copy2NewDy4Enable(adminOrgData.structDy);
                orgHisData.adminOrgSortCode = this.copy2NewDy4Enable(adminOrgData.sortCodeDy);
                OtherData otherData = (OtherData)OrgHisParamCreator.this.otherDataMapLoadFromDB.get(orgBoId);
                if (otherData != null) {
                    orgHisData.businessFile = this.copy2NewDy4Enable(otherData.businessFileDy);
                }
                if ((adminOrgTypeId = HRDyObjectPropUtil.getIdLongObject((DynamicObject)orgHisData.adminOrg.getDynamicObject("adminorgtype"))) == 1010L) {
                    orgHisData.group = this.copy2NewDy4Enable((DynamicObject)OrgHisParamCreator.this.oldGroupInfoDynMap.get(orgBoId));
                    orgHisData.company = this.copy2NewDy4Enable((DynamicObject)OrgHisParamCreator.this.oldCompInfoDynMap.get(orgBoId));
                } else if (adminOrgTypeId == 1020L) {
                    orgHisData.company = this.copy2NewDy4Enable((DynamicObject)OrgHisParamCreator.this.oldCompInfoDynMap.get(orgBoId));
                } else if (adminOrgTypeId == 1040L) {
                    orgHisData.department = this.copy2NewDy4Enable((DynamicObject)OrgHisParamCreator.this.oldDepartmentInfoDynMap.get(orgBoId));
                }
                OrgTeamData orgTeamData = (OrgTeamData)OrgHisParamCreator.this.orgTeamDataMapLoadFromDB.get(orgBoId);
                if (orgTeamData != null) {
                    orgHisData.orgTeam = this.copy2NewDy4Enable(orgTeamData.orgTeamDy);
                    orgHisData.orgTeam.set("id", (Object)vid);
                    orgHisData.orgTeam.set("parent", (Object)orgHisData.adminOrg.getLong("parentorg.id"));
                    orgHisData.orgTeamStruct = this.copy2NewDy4Enable(orgTeamData.structDy);
                    orgHisData.orgTeamStruct.set("orgteamhisid", (Object)vid);
                    orgHisData.orgTeamStruct.set("otclassify", (Object)1010L);
                }
                Date createTime = (Date)orgCreateTimeMap.get(orgBoId);
                orgHisData.coopRelList = orgIdVsCoopRelList.getOrDefault(orgBoId, Collections.emptyList()).stream().filter(rel -> {
                    try {
                        return createTime != null && HRDateTimeUtils.parseDate((String)HRDateTimeUtils.format((Date)rel.getDate("createtime"), (String)"yyyy-MM-dd")).compareTo(HRDateTimeUtils.parseDate((String)HRDateTimeUtils.format((Date)createTime, (String)"yyyy-MM-dd"))) >= 0;
                    }
                    catch (ParseException parseException) {
                        return false;
                    }
                }).map(this::copy2NewDy4Enable).peek(newDy -> newDy.set("createtime", (Object)new Date())).collect(Collectors.toList());
                return orgHisData;
            }).collect(Collectors.toList());
            collect.forEach(this::synOrgTeamStructBizFields);
            return collect;
        }

        private DynamicObject copy2NewDy4Enable(DynamicObject dynamicObject) {
            if (dynamicObject == null) {
                return null;
            }
            DynamicObject newDy = OrgHisParamCreator.copyToNewDy(dynamicObject);
            this.setEnableField(newDy);
            return newDy;
        }

        private void setEnableField(DynamicObject dynamicObject) {
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("bsed", (Object)OrgHisParamCreator.this.billData.getEffectDate());
            dynamicObject.set("creator", (Object)OrgHisParamCreator.this.billData.getCreator());
        }
    }

    class DisableCreator
    extends AbstractOrgHisCreator {
        private IdCreator idCreator;

        public DisableCreator() {
            this.sceneTag = 0;
            this.idCreator = new IdCreator();
        }

        @Override
        protected Consumer<DynamicObject> belongCompanyChangeTypeSetter() {
            return org -> {
                long boId = org.getLong("boid");
                FieldChangeHolder<Long> belongCompanyChangeHolder = OrgHisParamCreator.this.billData.getBelongCompanyChangedRecorder().getHolder(boId);
                belongCompanyChangeHolder.setNewValue(org.getLong("belongcompany.id"));
                if (belongCompanyChangeHolder.isChanged()) {
                    org.set("companychangetype", (Object)AdminOrgConstants.CompanyChangeType.FOLLOW_CHANGE.code());
                } else {
                    org.set("companychangetype", (Object)AdminOrgConstants.CompanyChangeType.NO_CHANGE.code());
                }
            };
        }

        private Map<Long, List<DynamicObject>> getRelationCoop(List<Long> orgBoIdList) {
            if (CollectionUtils.isEmpty(orgBoIdList)) {
                return new HashMap<Long, List<DynamicObject>>(0);
            }
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and("coopreltype", "!=", (Object)1010L);
            DynamicObject[] cooArray = QueryHelper.loadCoopByOrgTeamBoId(orgBoIdList, qFilter);
            if (cooArray == null || cooArray.length == 0) {
                return new HashMap<Long, List<DynamicObject>>(0);
            }
            Map<Long, List<DynamicObject>> orgIdVsCoopRelList = Arrays.stream(cooArray).collect(Collectors.groupingBy(dy -> dy.getLong("org.id")));
            Map<Long, DynamicObject> orgDyMap = Stream.of(((OrgHisParamCreator)OrgHisParamCreator.this).entryOrgDataListBO.infoChangeAdminOrgDataList, ((OrgHisParamCreator)OrgHisParamCreator.this).entryOrgDataListBO.parentChangeAdminOrgDataList).flatMap(Collection::stream).map(adminOrgData -> adminOrgData.orgDy).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (key1, key2) -> key2));
            if (CollectionUtils.isEmpty(orgDyMap)) {
                return Arrays.stream(cooArray).collect(Collectors.groupingBy(dy -> dy.getLong("cooporgteam.boid")));
            }
            ArrayList coolList = new ArrayList(cooArray.length);
            for (Map.Entry<Long, List<DynamicObject>> entry : orgIdVsCoopRelList.entrySet()) {
                DynamicObject orgDy = orgDyMap.get(entry.getKey());
                if (orgDy != null) {
                    this.removeCool(entry.getValue(), orgDy.getDynamicObjectCollection("cooprelentryentity"));
                }
                coolList.addAll(entry.getValue());
            }
            return coolList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("cooporgteam.boid")));
        }

        private void removeCool(List<DynamicObject> list, DynamicObjectCollection coolDyCol) {
            if (CollectionUtils.isEmpty((Collection)coolDyCol)) {
                return;
            }
            Set set = coolDyCol.stream().map(dy -> dy.getLong("coopreltyp.id")).collect(Collectors.toSet());
            Iterator<DynamicObject> it = list.iterator();
            while (it.hasNext()) {
                DynamicObject dy2 = it.next();
                if (!set.contains(dy2.getLong("coopreltype.id"))) continue;
                it.remove();
            }
        }

        @Override
        public List<OrgHisData> create() {
            List<Long> orgBoIdList = ((OrgHisParamCreator)OrgHisParamCreator.this).entryOrgDataListBO.disableAdminOrgDataList.stream().map(AdminOrgData::getOrgBoId).collect(Collectors.toList());
            DynamicObject[] disableCoopInfo = QueryHelper.loadCoopRelationByOrgBoId(orgBoIdList, new QFilter("enable", "=", (Object)"1"));
            Map<Long, List<DynamicObject>> orgIdVsCoopRelList = Arrays.stream(disableCoopInfo).collect(Collectors.groupingBy(dy -> dy.getLong("org.id")));
            Map<Long, List<DynamicObject>> relationCoopMap = this.getRelationCoop(orgBoIdList);
            List<OrgHisData> collect = ((OrgHisParamCreator)OrgHisParamCreator.this).entryOrgDataListBO.disableAdminOrgDataList.stream().map(adminOrgData -> {
                long orgBoId = adminOrgData.getOrgBoId();
                long vid = this.idCreator.getId();
                OrgHisData orgHisData = new OrgHisData();
                orgHisData.adminOrg = adminOrgData.orgDy;
                orgHisData.adminOrg.set("id", (Object)vid);
                orgHisData.adminOrgStruct = adminOrgData.structDy;
                orgHisData.adminOrgSortCode = adminOrgData.sortCodeDy;
                OtherData otherData = (OtherData)OrgHisParamCreator.this.otherDataMapLoadFromDB.get(orgBoId);
                orgHisData.businessFile = otherData.businessFileDy;
                orgHisData.group = (DynamicObject)OrgHisParamCreator.this.oldGroupInfoDynMap.get(orgBoId);
                orgHisData.company = (DynamicObject)OrgHisParamCreator.this.oldCompInfoDynMap.get(orgBoId);
                orgHisData.department = (DynamicObject)OrgHisParamCreator.this.oldDepartmentInfoDynMap.get(orgBoId);
                OrgTeamData orgTeamData = (OrgTeamData)OrgHisParamCreator.this.orgTeamDataMapLoadFromDB.get(orgBoId);
                orgHisData.orgTeam = orgTeamData.orgTeamDy;
                orgHisData.orgTeam.set("id", (Object)vid);
                orgHisData.orgTeam.set("parent", orgHisData.adminOrg.get("parentorg"));
                orgHisData.orgTeamStruct = orgTeamData.structDy;
                orgHisData.orgTeamStruct.set("orgteamhisid", (Object)vid);
                orgHisData.orgTeamStruct.set("otclassify", (Object)1010L);
                orgHisData.coopRelList = orgIdVsCoopRelList.getOrDefault(orgBoId, Collections.emptyList());
                orgHisData.coopRelList.addAll(relationCoopMap.getOrDefault(orgBoId, Collections.emptyList()));
                return orgHisData;
            }).peek(this::disableCopy).collect(Collectors.toList());
            collect.forEach(this::synOrgTeamStructBizFields);
            return collect;
        }

        private void disableCopy(OrgHisData orgHisData) {
            long vid = orgHisData.adminOrg.getLong("id");
            orgHisData.adminOrg = this.copy2NewDy4Disable(orgHisData.adminOrg);
            orgHisData.adminOrg.set("id", (Object)vid);
            orgHisData.adminOrgStruct = this.copy2NewDy4Disable(orgHisData.adminOrgStruct);
            orgHisData.adminOrgSortCode = this.copy2NewDy4Disable(orgHisData.adminOrgSortCode);
            orgHisData.businessFile = this.copy2NewDy4Disable(orgHisData.businessFile);
            orgHisData.company = this.copy2NewDy4Disable(orgHisData.company);
            orgHisData.group = this.copy2NewDy4Disable(orgHisData.group);
            orgHisData.department = this.copy2NewDy4Disable(orgHisData.department);
            long orgTeamVid = orgHisData.orgTeam.getLong("id");
            orgHisData.orgTeam = this.copy2NewDy4Disable(orgHisData.orgTeam);
            orgHisData.orgTeam.set("id", (Object)orgTeamVid);
            orgHisData.orgTeamStruct = this.copy2NewDy4Disable(orgHisData.orgTeamStruct);
            orgHisData.coopRelList = orgHisData.coopRelList.stream().map(this::copyNewCoolDyByDisable).collect(Collectors.toList());
        }

        private DynamicObject copy2NewDy4Disable(DynamicObject dynamicObject) {
            if (dynamicObject == null) {
                return null;
            }
            DynamicObject newDy = OrgHisParamCreator.copyToNewDy(dynamicObject);
            this.setDisableField(newDy);
            return newDy;
        }

        private DynamicObject copyNewCoolDyByDisable(DynamicObject dynamicObject) {
            if (dynamicObject == null) {
                return null;
            }
            Date effectDate = dynamicObject.getDate("bsed");
            DynamicObject newDy = this.copy2NewDy4Disable(dynamicObject);
            if (effectDate.compareTo(OrgHisParamCreator.this.billData.getEffectDate()) > 0) {
                newDy.set("bsed", (Object)effectDate);
                newDy.set("disabledate", (Object)effectDate);
            }
            newDy.set("createtime", (Object)new Date());
            return newDy;
        }

        private void setDisableField(DynamicObject dynamicObject) {
            dynamicObject.set("enable", (Object)"0");
            dynamicObject.set("bsed", (Object)OrgHisParamCreator.this.billData.getEffectDate());
            dynamicObject.set("disabledate", (Object)OrgHisParamCreator.this.billData.getEffectDate());
            dynamicObject.set("creator", (Object)OrgHisParamCreator.this.billData.getCreator());
        }
    }

    class NewCreator
    extends AbstractOrgHisCreator {
        public NewCreator() {
            this.sceneTag = 1;
        }

        @Override
        protected void setFirstBsed(DynamicObject dynamicObject) {
            dynamicObject.set("firstbsed", dynamicObject.get("bsed"));
        }

        @Override
        protected void setInitStatus(DynamicObject dynamicObject) {
            MethodHelper.setInitFields(dynamicObject);
        }

        @Override
        protected Consumer<DynamicObject> belongCompanyChangeTypeSetter() {
            return org -> org.set("companychangetype", (Object)AdminOrgConstants.CompanyChangeType.NO_CHANGE.code());
        }

        @Override
        public List<OrgHisData> create() {
            List<OrgHisData> orgHisDataList = ((OrgHisParamCreator)OrgHisParamCreator.this).entryOrgDataListBO.addAdminOrgDataList.stream().map(adminOrgData -> {
                long orgBoId = adminOrgData.getOrgBoId();
                OrgHisData orgHisData = new OrgHisData();
                this.change2TempDataFromDB((AdminOrgData)adminOrgData);
                orgHisData.adminOrg = adminOrgData.orgDy;
                orgHisData.adminOrgStruct = adminOrgData.structDy;
                this.setIsRootValue(orgHisData.adminOrgStruct);
                orgHisData.adminOrgSortCode = adminOrgData.sortCodeDy;
                orgHisData.businessFile = this.createBusinessFile((AdminOrgData)adminOrgData);
                orgHisData.coopRelList = this.createCoopRel(adminOrgData.orgDy);
                orgHisData.orgTeam = this.createOrgTeam(adminOrgData.orgDy);
                orgHisData.orgTeam.set("parent", (Object)orgHisData.adminOrg.getLong("parentorg.id"));
                orgHisData.orgTeamStruct = this.createOrgTeamStruct(adminOrgData.structDy);
                orgHisData.orgTeamStruct.set("otclassify", (Object)1010L);
                orgHisData.group = (DynamicObject)OrgHisParamCreator.this.oldGroupInfoDynMap.get(orgBoId);
                orgHisData.company = (DynamicObject)OrgHisParamCreator.this.oldCompInfoDynMap.get(orgBoId);
                orgHisData.department = (DynamicObject)OrgHisParamCreator.this.oldDepartmentInfoDynMap.get(orgBoId);
                return orgHisData;
            }).collect(Collectors.toList());
            IdCreator idCreator = new IdCreator();
            orgHisDataList.forEach(orgHisData -> {
                orgHisData.businessFile.set("id", (Object)idCreator.getId());
                orgHisData.coopRelList.forEach(dy -> dy.set("id", (Object)idCreator.getId()));
            });
            return orgHisDataList;
        }

        private DynamicObject createOrgTeamStruct(DynamicObject adminOrgStruct) {
            DynamicObject orgTeamStruct = OrgHisParamCreator.copyToNewDy(adminOrgStruct, "haos_adminorgstructure");
            orgTeamStruct.set("orgteam", (Object)adminOrgStruct.getLong("adminorg.id"));
            orgTeamStruct.set("parentorgteam", (Object)adminOrgStruct.getLong("parentorg.id"));
            orgTeamStruct.set("id", (Object)adminOrgStruct.getLong("boid"));
            orgTeamStruct.set("boid", null);
            return orgTeamStruct;
        }

        private DynamicObject createOrgTeam(DynamicObject adminOrg) {
            DynamicObject addNewOrgTeam = OrgTeamSynService.getInstance().createAddNewOrgTeam(adminOrg, OrgTeamInfo.ORG_TEAM_BASIC_INFO_BO, ((OrgHisParamCreator)OrgHisParamCreator.this).orgTeamInfo.numberPrefix);
            addNewOrgTeam.set("id", adminOrg.get("boid"));
            return addNewOrgTeam;
        }

        private DynamicObject createBusinessFile(AdminOrgData adminOrgData) {
            return AdminOrgBusinessFileService.createAddNewBusinessFile((DynamicObject)adminOrgData.orgDy);
        }

        private List<DynamicObject> createCoopRel(DynamicObject adminOrg) {
            Map addCurBatchOrgCoopRelBOMap = AdminOrgHisServiceHelper.getCurBatchOrgCoopRelBOMap((DynamicObject[])new DynamicObject[]{adminOrg});
            HisVersionParamBo addHisVersionParamBo = OrgTeamCoopRelService.getInstance().buildAddNewHisParam(addCurBatchOrgCoopRelBOMap);
            Arrays.stream(addHisVersionParamBo.getHisDyns()).forEach(dy -> dy.set("id", null));
            return Arrays.asList(addHisVersionParamBo.getHisDyns());
        }

        private void change2TempDataFromDB(AdminOrgData adminOrgData) {
            AdminOrgData tempAdminOrgData = (AdminOrgData)OrgHisParamCreator.this.tempAdminOrgDataLoadFromDB.get(adminOrgData.getOrgBoId());
            Date estDate = tempAdminOrgData.orgDy.getDate("establishmentdate");
            HRDynamicObjectUtils.copy((DynamicObject)adminOrgData.orgDy, (DynamicObject)tempAdminOrgData.orgDy, EffectBillConstant.ID_IGNORE_KEYS);
            adminOrgData.orgDy = tempAdminOrgData.orgDy;
            adminOrgData.orgDy.set("iscurrentversion", (Object)true);
            adminOrgData.orgDy.set("bsed", (Object)estDate);
            HRDynamicObjectUtils.copy((DynamicObject)adminOrgData.structDy, (DynamicObject)tempAdminOrgData.structDy, EffectBillConstant.ID_IGNORE_KEYS);
            adminOrgData.structDy = tempAdminOrgData.structDy;
            adminOrgData.structDy.set("iscurrentversion", (Object)true);
            adminOrgData.structDy.set("bsed", (Object)estDate);
            HRDynamicObjectUtils.copy((DynamicObject)adminOrgData.sortCodeDy, (DynamicObject)tempAdminOrgData.sortCodeDy, EffectBillConstant.ID_IGNORE_KEYS);
            adminOrgData.sortCodeDy = tempAdminOrgData.sortCodeDy;
            adminOrgData.sortCodeDy.set("iscurrentversion", (Object)true);
            adminOrgData.sortCodeDy.set("bsed", (Object)estDate);
        }
    }

    class SpecialNewCreator
    extends AbstractOrgHisCreator {
        private IdCreator idCreator;

        public SpecialNewCreator() {
            this.sceneTag = 5;
            this.idCreator = new IdCreator();
        }

        @Override
        protected Consumer<DynamicObject> belongCompanyChangeTypeSetter() {
            return org -> org.set("companychangetype", (Object)AdminOrgConstants.CompanyChangeType.NO_CHANGE.code());
        }

        @Override
        protected void setInitStatus(DynamicObject dynamicObject) {
            MethodHelper.setInitFields(dynamicObject);
        }

        @Override
        public List<OrgHisData> create() {
            return OrgHisParamCreator.this.addCascadeOrgDataList.stream().map(adminOrgData -> {
                long vid = this.idCreator.getId();
                OrgHisData orgHisData = new OrgHisData();
                orgHisData.adminOrg = OrgHisParamCreator.copyToNewDy(adminOrgData.orgDy);
                if (orgHisData.adminOrg != null) {
                    orgHisData.adminOrg.set("id", (Object)vid);
                }
                orgHisData.adminOrgStruct = OrgHisParamCreator.copyToNewDy(adminOrgData.structDy);
                orgHisData.adminOrgSortCode = OrgHisParamCreator.copyToNewDy(adminOrgData.sortCodeDy);
                if (orgHisData.adminOrg != null) {
                    orgHisData.orgTeam = this.createOrgTeam(adminOrgData.orgDy);
                    orgHisData.orgTeam.set("id", (Object)vid);
                }
                if (orgHisData.adminOrg != null && orgHisData.adminOrgStruct != null) {
                    orgHisData.orgTeamStruct = this.createOrgTeamStruct(adminOrgData.structDy);
                    orgHisData.orgTeamStruct.set("orgteamhisid", (Object)vid);
                    orgHisData.orgTeamStruct.set("otclassify", (Object)1010L);
                }
                return orgHisData;
            }).collect(Collectors.toList());
        }

        private DynamicObject createOrgTeamStruct(DynamicObject adminOrgStruct) {
            DynamicObject orgTeamStruct = OrgHisParamCreator.copyToNewDy(adminOrgStruct, "haos_adminorgstructure");
            orgTeamStruct.set("orgteam", (Object)adminOrgStruct.getLong("adminorg.id"));
            orgTeamStruct.set("parentorgteam", (Object)adminOrgStruct.getLong("parentorg.id"));
            orgTeamStruct.set("boid", (Object)adminOrgStruct.getLong("boid"));
            return orgTeamStruct;
        }

        private DynamicObject createOrgTeam(DynamicObject adminOrg) {
            DynamicObject addNewOrgTeam = OrgTeamSynService.getInstance().createAddNewOrgTeam(adminOrg, OrgTeamInfo.ORG_TEAM_BASIC_INFO_BO, ((OrgHisParamCreator)OrgHisParamCreator.this).orgTeamInfo.numberPrefix);
            addNewOrgTeam.set("id", null);
            addNewOrgTeam.set("boid", adminOrg.get("boid"));
            return addNewOrgTeam;
        }
    }

    class CascadeCreator
    extends AbstractOrgHisCreator {
        private IdCreator idCreator;

        public CascadeCreator() {
            this.sceneTag = 4;
            this.idCreator = new IdCreator();
        }

        @Override
        protected void setCreator(DynamicObject dynamicObject) {
            MethodHelper.setCreatorAdministrator(dynamicObject);
        }

        @Override
        protected void setInitStatus(DynamicObject dynamicObject) {
            if (OrgHisParamCreator.this.billData.getAddBoSet().contains(OrgHisData.adminOrgBoIdThreadLocal.get())) {
                MethodHelper.setInitFields(dynamicObject);
            }
        }

        @Override
        protected Consumer<DynamicObject> belongCompanyChangeTypeSetter() {
            return org -> org.set("companychangetype", (Object)AdminOrgConstants.CompanyChangeType.FOLLOW_CHANGE.code());
        }

        @Override
        public List<OrgHisData> create() {
            return OrgHisParamCreator.this.cascadeOrgDataList.stream().map(adminOrgData -> {
                long vid = this.idCreator.getId();
                OrgHisData orgHisData = new OrgHisData();
                orgHisData.adminOrg = OrgHisParamCreator.copyToNewDy(adminOrgData.orgDy);
                if (orgHisData.adminOrg != null) {
                    orgHisData.adminOrg.set("id", (Object)vid);
                }
                orgHisData.adminOrgStruct = OrgHisParamCreator.copyToNewDy(adminOrgData.structDy);
                orgHisData.adminOrgSortCode = OrgHisParamCreator.copyToNewDy(adminOrgData.sortCodeDy);
                OrgTeamData orgTeamData = (OrgTeamData)OrgHisParamCreator.this.orgTeamDataMapLoadFromDB.get(adminOrgData.getOrgBoId());
                orgTeamData.orgTeamDy = OrgHisParamCreator.copyToNewDy(orgTeamData.orgTeamDy);
                if (orgHisData.adminOrg != null) {
                    orgHisData.orgTeam = OrgHisParamCreator.copyToNewDy(orgTeamData.orgTeamDy);
                    orgHisData.orgTeam.set("id", (Object)vid);
                    this.synOrgTeamBizFields(orgHisData);
                }
                if (orgHisData.adminOrg != null && orgHisData.adminOrgStruct != null) {
                    orgHisData.orgTeamStruct = OrgHisParamCreator.copyToNewDy(orgTeamData.structDy);
                    orgHisData.orgTeamStruct.set("orgteamhisid", (Object)vid);
                    orgHisData.orgTeamStruct.set("otclassify", (Object)1010L);
                    this.synOrgTeamStructBizFields(orgHisData);
                }
                return orgHisData;
            }).collect(Collectors.toList());
        }
    }

    abstract class AbstractOrgHisCreator
    implements OrgHisCreator {
        int sceneTag = 99;

        AbstractOrgHisCreator() {
        }

        List<OrgHisData> createWithCommonField() {
            List<OrgHisData> orgHisDataList = this.create();
            switch (this.sceneTag) {
                case 1: {
                    this.setCommonField4Add(orgHisDataList);
                    break;
                }
                case 4: 
                case 5: {
                    this.setCommonField4Cascade(orgHisDataList);
                    break;
                }
                case 0: 
                case 2: 
                case 3: 
                case 6: {
                    this.setCommonField(orgHisDataList);
                    break;
                }
                default: {
                    throw new RuntimeException("scene tag not found");
                }
            }
            orgHisDataList.stream().map(orgHisData -> orgHisData.adminOrg).forEach(this::setChangeTransactionFields);
            return orgHisDataList;
        }

        private void setCommonField(List<OrgHisData> orgHisDataList) {
            Map<Boolean, List<OrgHisData>> onlyCoopVsOrgHisDataList = orgHisDataList.stream().collect(Collectors.groupingBy(orgHisData -> orgHisData.onlyCoopRelTag));
            onlyCoopVsOrgHisDataList.getOrDefault(false, Collections.emptyList()).forEach(orgHisData -> {
                this.setCommonFieldWithoutEffectRange(orgHisData.adminOrg);
                this.setCommonFieldWithoutEffectRange(orgHisData.adminOrgStruct);
                this.setCommonFieldWithoutEffectRange(orgHisData.adminOrgSortCode);
                this.setCommonFieldWithoutEffectRange(orgHisData.orgTeam);
                this.setCommonFieldWithoutEffectRange(orgHisData.orgTeamStruct);
                Date effDate = this.getEffectDate(orgHisData.getOrgBoId());
                this.setCommonFieldWithEffDt(orgHisData.group, effDate);
                this.setCommonFieldWithEffDt(orgHisData.company, effDate);
                this.setCommonFieldWithEffDt(orgHisData.department, effDate);
                this.setCommonFieldWithEffDt(orgHisData.businessFile, effDate);
            });
            onlyCoopVsOrgHisDataList.getOrDefault(true, Collections.emptyList()).forEach(orgHisData -> orgHisData.coopRelList.forEach(coopRel -> this.setCommonFieldWithEffDt((DynamicObject)coopRel, this.getEffectDate(MethodHelper.smartGetId(coopRel, "org")))));
        }

        private void setCommonField4Cascade(List<OrgHisData> orgHisDataList) {
            orgHisDataList.forEach(orgHisData -> {
                try {
                    OrgHisData.adminOrgBoIdThreadLocal.set(orgHisData.getOrgBoId());
                    this.setCommonFieldWithoutEffectRange(orgHisData.adminOrg);
                    this.setCommonFieldWithoutEffectRange(orgHisData.adminOrgStruct);
                    this.setCommonFieldWithoutEffectRange(orgHisData.adminOrgSortCode);
                    this.setCommonFieldWithoutEffectRange(orgHisData.orgTeam);
                    this.setCommonFieldWithoutEffectRange(orgHisData.orgTeamStruct);
                }
                finally {
                    OrgHisData.adminOrgBoIdThreadLocal.remove();
                }
            });
        }

        private void setCommonField4Add(List<OrgHisData> orgHisDataList) {
            this.setCoopRelEffDt(orgHisDataList);
            orgHisDataList.forEach(orgHisData -> {
                Date establishmentDate = orgHisData.adminOrg.getDate("establishmentdate");
                this.setCommonFieldWithoutEffectRange(orgHisData.adminOrg);
                this.setCommonFieldWithoutEffectRange(orgHisData.orgTeam);
                this.setCommonFieldWithEffDt(orgHisData.group, establishmentDate);
                this.setCommonFieldWithEffDt(orgHisData.company, establishmentDate);
                this.setCommonFieldWithEffDt(orgHisData.department, establishmentDate);
                this.setCommonFieldWithEffDt(orgHisData.businessFile, establishmentDate);
                this.setCommonFieldWithoutEffectRange(orgHisData.adminOrgStruct);
                this.setCommonFieldWithoutEffectRange(orgHisData.adminOrgSortCode);
                this.setCommonFieldWithoutEffectRange(orgHisData.orgTeamStruct);
            });
        }

        private void setCoopRelEffDt(List<OrgHisData> orgHisDataList) {
            switch (OrgHisParamCreator.this.billData.getBillType()) {
                case "2": {
                    Date billEffDt = OrgHisParamCreator.this.billData.getEffectDate();
                    orgHisDataList.forEach(orgHisData -> orgHisData.coopRelList.forEach(coopRel -> this.setCommonFieldWithEffDt((DynamicObject)coopRel, billEffDt)));
                    break;
                }
                case "1": 
                case "3": 
                case "4": {
                    this.batchSetCoopRelEffDtByEstDt(orgHisDataList);
                    break;
                }
                default: {
                    throw new RuntimeException("no support bill type");
                }
            }
        }

        public void batchSetCoopRelEffDtByEstDt(List<OrgHisData> orgHisDataList) {
            Predicate<Long> noContainsCurBillFilter = id -> !OrgHisParamCreator.this.billData.getAllBoSet().contains(id);
            Set<Long> parentOrgTeamBoSet = orgHisDataList.stream().map(orgHisData -> orgHisData.coopRelList).flatMap(Collection::stream).map(coopRel -> coopRel.getLong("cooporgteam")).filter(noContainsCurBillFilter).collect(Collectors.toSet());
            Map<Long, Date> boIdVsEstDate = Arrays.stream(QueryHelper.queryOrgTeamEstDateByVid(parentOrgTeamBoSet)).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getDate("firstbsed")));
            OrgHisParamCreator.this.entryOrgDataListBO.getAll().stream().map(adminOrgData -> adminOrgData.orgDy).forEach(dy -> boIdVsEstDate.put(dy.getLong("boid"), dy.getDate("establishmentdate")));
            orgHisDataList.stream().map(orgHisData -> orgHisData.coopRelList).flatMap(Collection::stream).forEach(coopRel -> {
                Date coopOrgEstDate;
                Date curOrgEstDate = (Date)boIdVsEstDate.get(coopRel.getLong("org"));
                coopRel.set("bsed", (Object)(curOrgEstDate.after(coopOrgEstDate = (Date)boIdVsEstDate.get(coopRel.getLong("cooporgteam"))) ? curOrgEstDate : coopOrgEstDate));
            });
        }

        private void setCommonFieldWithEffDt(DynamicObject dynamicObject, Date orgEffDate) {
            if (dynamicObject != null) {
                MethodHelper.setEffectingRange(dynamicObject, orgEffDate);
                this.setCommonField(dynamicObject);
            }
        }

        private void setCommonFieldWithoutEffectRange(DynamicObject dynamicObject) {
            if (dynamicObject != null) {
                this.setCommonField(dynamicObject);
            }
        }

        private void setCommonField(DynamicObject dynamicObject) {
            MethodHelper.setCreateTime(dynamicObject);
            this.setCreator(dynamicObject);
            this.setFirstBsed(dynamicObject);
            this.setInitStatus(dynamicObject);
        }

        protected void setIsRootValue(DynamicObject structDy) {
            if (structDy == null) {
                return;
            }
            ChangeRootData changeRootData = OrgHisParamCreator.this.billData.getChangeRootData();
            if (changeRootData == null) {
                return;
            }
            if (structDy.getLong("adminorg.id") == changeRootData.getNewRootId().longValue()) {
                structDy.set("isroot", (Object)Boolean.TRUE);
            } else if (structDy.getLong("adminorg.id") == changeRootData.getOldRootId().longValue()) {
                structDy.set("isroot", (Object)Boolean.FALSE);
            }
        }

        protected void setInitStatus(DynamicObject dynamicObject) {
        }

        protected void setFirstBsed(DynamicObject dynamicObject) {
        }

        protected void setCreator(DynamicObject dynamicObject) {
            dynamicObject.set("creator", (Object)OrgHisParamCreator.this.billData.getCreator());
        }

        public void synOrgTeamBizFields(OrgHisData orgHisData) {
            OrgTeamSynService.getInstance().synOrgTeamBizFields(orgHisData.orgTeam, orgHisData.adminOrg, ((OrgHisParamCreator)OrgHisParamCreator.this).orgTeamInfo.numberPrefix);
        }

        public void synOrgTeamStructBizFields(OrgHisData orgHisData) {
            OrgTeamSynService.getInstance().synOrgTeamStructBizFields(orgHisData.orgTeamStruct, orgHisData.adminOrgStruct);
        }

        private void setChangeTransactionFields(DynamicObject org) {
            if (org != null) {
                this.belongCompanyChangeTypeSetter().accept(org);
            }
        }

        protected abstract Consumer<DynamicObject> belongCompanyChangeTypeSetter();

        private Date getEffectDate(long adminOrgBo) {
            Date effectDate;
            switch (OrgHisParamCreator.this.billData.getBillType()) {
                case "2": 
                case "3": 
                case "1": {
                    effectDate = OrgHisParamCreator.this.billData.getEffectDate();
                    break;
                }
                case "4": {
                    effectDate = OrgHisParamCreator.this.billData.getEntryOrgEffectDate(adminOrgBo);
                    break;
                }
                default: {
                    throw new RuntimeException("no support bill type");
                }
            }
            return effectDate;
        }
    }

    static interface OrgHisCreator {
        public List<OrgHisData> create();
    }

    static class OrgTeamInfo {
        private static final OrgTeamBasicInfoBO ORG_TEAM_BASIC_INFO_BO = new OrgTeamBasicInfoBO(Long.valueOf(1010L), Long.valueOf(1010L), Long.valueOf(1010L), Long.valueOf(1010L), "adminorg.id", "parentorg");
        public String numberPrefix;

        OrgTeamInfo() {
        }
    }
}

