/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgOpService;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.haos.common.model.ChangeRootData;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.homs.business.service.batcheffect.BatchEffectService;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;

public class OrgRootChangeController {
    private static final Log LOGGER = LogFactory.getLog(OrgRootChangeController.class);
    private Date nowDate;
    private Map<Long, DynamicObject> changeSceneMap;
    private Map<Long, DynamicObject> changeTypeMap;
    private BatchEffectService batchEffectService;

    public void asy(Long oldRootId, Long newRootId) {
        ThreadPools.executeOnce((String)"asyAdminOrg", () -> {
            this.syn(oldRootId, newRootId);
            this.afterSyn();
        });
    }

    public void syn(Long oldRootId, Long newRootId) {
        try (TXHandle required = TX.requiresNew();){
            try {
                this.initValue(oldRootId, newRootId);
                LOGGER.info("OrgRootChangeController saveAdminOrg start");
                this.batchEffectService.saveAdminOrg();
                this.changeStructProjectRootOrg(newRootId);
                this.changeInProcessBillEntryDataOldRootOrgParent(oldRootId, newRootId);
                LOGGER.info("OrgRootChangeController end");
            }
            catch (Exception ex) {
                LOGGER.error((Throwable)ex);
                required.markRollback();
                throw ex;
            }
        }
    }

    private void changeInProcessBillEntryDataOldRootOrgParent(Long oldRootId, Long newRootId) {
        LOGGER.info("changeInProcessBillEntryDataOldRootOrgParent start");
        DynamicObject bill = this.queryInProcessBillAndHasChangedOldRootOrg("id, billno, entryentity_all.parentorg, entryentity_all.oriparentorg, entryentity_all.adminorgid", oldRootId);
        if (bill != null) {
            DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity_all");
            Optional<DynamicObject> matchedOption = entryentity.stream().filter(row -> row.getLong("adminorgid.boid") == oldRootId.longValue()).findFirst();
            if (matchedOption.isPresent()) {
                DynamicObject entryOrg = matchedOption.get();
                DynamicObject newRootHis = this.queryNewRootCurrentHis(newRootId);
                DynamicObject newRoot = this.queryNewRootCurrent(newRootId);
                entryOrg.set("parentorg", (Object)newRootHis);
                entryOrg.set("oriparentorg", (Object)newRoot);
            }
            HRBaseServiceHelper billHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
            billHelper.save(new DynamicObject[]{bill});
        } else {
            LOGGER.info("queryInProcessBillAndHasChangedOldRootOrg no result");
        }
        LOGGER.info("changeInProcessBillEntryDataOldRootOrgParent end");
    }

    private DynamicObject queryNewRootCurrentHis(Long newRootId) {
        DynamicObject[] dynamicObjects = AdOrgRepository.getInstance().queryHisOrgColByBoDate("id", Collections.singleton(newRootId), new Date(), new Date());
        if (dynamicObjects.length != 0) {
            return dynamicObjects[0];
        }
        return null;
    }

    private DynamicObject queryNewRootCurrent(Long newRootId) {
        DynamicObject[] dynamicObjects = AdOrgRepository.getInstance().queryOrgInfoByBoId("id", Collections.singletonList(newRootId));
        if (dynamicObjects.length != 0) {
            return dynamicObjects[0];
        }
        return null;
    }

    private DynamicObject queryInProcessBillAndHasChangedOldRootOrg(String selectFields, Long oldRootId) {
        HRBaseServiceHelper billHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        QFilter billStatusFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "D"});
        QFilter oldRootFilter = new QFilter("entryentity_all.adminorgid.boid", "=", (Object)oldRootId);
        QFilter changeTypeFilter = new QFilter("entryentity_all.changescene.orgchangetype", "=", (Object)1030L);
        QFilter parentFilter = new QFilter("entryentity_all.parentorg", "=", (Object)0L);
        DynamicObject[] query = billHelper.query(selectFields, billStatusFilter.and(oldRootFilter).and(changeTypeFilter).and(parentFilter).toArray());
        if (query.length != 0) {
            return query[0];
        }
        return null;
    }

    private void changeStructProjectRootOrg(Long newRootId) {
        DynamicObject structProjectDy = StructProjectRepository.getInstance().queryByPk("id,rootorg", (Object)1010L);
        if (structProjectDy == null) {
            LOGGER.error("no find structProject");
            return;
        }
        structProjectDy.set("rootorg", (Object)newRootId);
        StructProjectRepository.getInstance().saveOne(structProjectDy);
    }

    public void afterSyn() {
        this.batchEffectService.synStrategy();
    }

    private void initValue(Long oldRootId, Long newRootId) {
        this.nowDate = HRDateTimeUtils.getNowDate();
        List<Long> idList = Arrays.asList(OrgBatchChgBillConstants.CHANGE_TYPE_ADD, OrgBatchChgBillConstants.CHANGE_TYPE_PARENT);
        this.changeSceneMap = this.getBaseInfoDyById("id,number,orgchangetype,changeoperat", "haos_changescene", idList);
        this.changeTypeMap = this.getBaseInfoDyById("id,number,name", "haos_orgchangetype", idList);
        DynamicObject newRootEntity = this.buildNewRootEntity(newRootId);
        DynamicObject parentChangeEntity = this.buildOldRootEntityDy(oldRootId, newRootEntity.getDynamicObject("adminorg"));
        LOGGER.info("OrgRootChangeController createRootChangeServices");
        this.batchEffectService = BatchEffectService.createRootChangeServices(this.buildBill(), new DynamicObject[]{newRootEntity, parentChangeEntity}, new ChangeRootData(oldRootId, newRootId));
    }

    private DynamicObject buildBill() {
        DynamicObject userDy = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        userDy.set("id", (Object)RequestContext.get().getCurrUserId());
        DynamicObject billDy = BusinessDataServiceHelper.newDynamicObject((String)"homs_orgbatchchgbill");
        billDy.set("billtype", (Object)"3");
        billDy.set("creator", (Object)userDy);
        billDy.set("effdt", (Object)HRDateTimeUtils.getNowDate());
        return billDy;
    }

    private DynamicObject buildNewRootEntity(Long newRootId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_adminorg");
        DynamicObject baseDy = helper.queryOne((Object)newRootId);
        DynamicObjectType bosOrgType = EntityMetadataCache.getSubDataEntityType((String)"bos_org", Collections.singletonList("id"));
        DynamicObject bosOrgDy = new DynamicObject(bosOrgType);
        bosOrgDy.set("id", (Object)newRootId);
        DynamicObject entityDy = BusinessDataServiceHelper.newDynamicObject((String)"homs_batchorgentity");
        entityDy.set("number", baseDy.get("number"));
        entityDy.set("name", baseDy.get("name"));
        Map<Long, DynamicObject> adminOrgTypeMap = this.getBaseInfoDyById("id,number,adminorgtypestd", "haos_adminorgtype", Collections.singletonList(AdminOrgType.GROUP.getId()));
        entityDy.set("adminorgtype", (Object)adminOrgTypeMap.get(AdminOrgType.GROUP.getId()));
        entityDy.set("status", (Object)"C");
        entityDy.set("establishmentdate", (Object)this.nowDate);
        entityDy.set("bsed", (Object)this.nowDate);
        entityDy.set("bsled", (Object)OrgDateTimeUtil.BSLED);
        entityDy.set("index", (Object)1);
        entityDy.set("org", (Object)bosOrgDy);
        entityDy.set("changescene", (Object)this.changeSceneMap.get(OrgBatchChgBillConstants.CHANGE_TYPE_ADD));
        entityDy.set("changetype", (Object)this.changeTypeMap.get(OrgBatchChgBillConstants.CHANGE_TYPE_ADD));
        entityDy.set("enable", (Object)"1");
        DynamicObject orgDy = this.buildOrgDy(entityDy, newRootId);
        entityDy.set("adminorg", (Object)orgDy);
        DynamicObject[] dynArr = new DynamicObject[]{orgDy};
        AdminOrgOpService.getInstance().saveTemporary(dynArr, Long.valueOf(0L), false);
        return entityDy;
    }

    private DynamicObject buildOrgDy(DynamicObject entityDy, Long newRootId) {
        DynamicObject orgDy = BusinessDataServiceHelper.newDynamicObject((String)"haos_adminorgdetail");
        HRDynamicObjectUtils.copy((DynamicObject)entityDy, (DynamicObject)orgDy);
        orgDy.set("id", (Object)newRootId);
        orgDy.set("boid", (Object)newRootId);
        return orgDy;
    }

    private DynamicObject buildOldRootEntityDy(Long oldRootId, DynamicObject parentDy) {
        DynamicObject oldOrgDy = AdOrgRepository.getInstance().loadByBoIdAndDate(oldRootId, this.nowDate);
        DynamicObject parentChangeEntityDy = BusinessDataServiceHelper.newDynamicObject((String)"homs_batchorgentity");
        HRDynamicObjectUtils.copy((DynamicObject)oldOrgDy, (DynamicObject)parentChangeEntityDy);
        parentChangeEntityDy.set("changescene", (Object)this.changeSceneMap.get(OrgBatchChgBillConstants.CHANGE_TYPE_PARENT));
        parentChangeEntityDy.set("changetype", (Object)this.changeTypeMap.get(OrgBatchChgBillConstants.CHANGE_TYPE_PARENT));
        parentChangeEntityDy.set("bsed", (Object)this.nowDate);
        parentChangeEntityDy.set("parentorg", (Object)parentDy);
        parentChangeEntityDy.set("adminorg", (Object)oldOrgDy);
        return parentChangeEntityDy;
    }

    private Map<Long, DynamicObject> getBaseInfoDyById(String selectProperties, String entityName, List<Long> idList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter idFilter = new QFilter("id", "in", idList);
        return Arrays.stream(serviceHelper.query(selectProperties, new QFilter[]{idFilter})).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
    }
}

