/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.homs.business.service.batcheffect.OrgRootChangeController;

public class OrgRootChangeServicePlugin
implements IEventServicePlugin {
    private static final Log LOGGER = LogFactory.getLog(OrgRootChangeServicePlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        LOGGER.info("homs OrgResetRootEventServicePlugin start.KDBizEvent={}", (Object)evt);
        String variableStr = evt.getVariables();
        JSONObject variables = (JSONObject)SerializationUtils.fromJsonString((String)variableStr, JSONObject.class);
        JSONObject operationParams = variables.getJSONObject("base_orgchange_resetroot");
        JSONArray synViewArray = operationParams.getJSONArray("synviews");
        long oldRootId = 0L;
        long newRootId = 0L;
        for (int i = 0; i < synViewArray.size(); ++i) {
            JSONObject jsonObject = synViewArray.getJSONObject(i);
            if (jsonObject.getLong("viewid") != 1L) continue;
            oldRootId = jsonObject.getLong("oldrootid");
            newRootId = jsonObject.getLong("newrootid");
            break;
        }
        if (newRootId == 0L || oldRootId == 0L) {
            LOGGER.error("homs OrgResetRootEventServicePlugin param error,oldRootId={},newRootId={}", (Object)oldRootId, (Object)newRootId);
            return null;
        }
        DynamicObjectCollection col = AdOrgRepository.getInstance().queryOriginalColByPks("id", Arrays.asList(newRootId, oldRootId));
        Set orgSet = col.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        if (orgSet.contains(newRootId)) {
            LOGGER.error("homs newRootId exists,newRootId={}", (Object)newRootId);
            return null;
        }
        if (!orgSet.contains(oldRootId)) {
            LOGGER.error("homs oldRootId not exists,oldRootId={}", (Object)oldRootId);
            return null;
        }
        OrgRootChangeController controller = new OrgRootChangeController();
        controller.asy(oldRootId, newRootId);
        return null;
    }
}

