/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.util.tree.TreeAssistUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.homs.business.service.batcheffect.MethodHelper;
import kd.hr.homs.business.service.helper.OrgBatchValidateHelper;
import org.apache.commons.collections4.trie.PatriciaTrie;

public class QueryHelper {
    public static final String HIS_STRUCT_QUERY_FIELDS = "id,boid, adminorg.id, structlongnumber,level, bsed, bsled, datastatus, iscurrentversion";
    private static HRBaseServiceHelper MASTER_DATA = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
    private static HRBaseServiceHelper STRUCT = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
    private static HRBaseServiceHelper SORT_CODE = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey());
    private static HRBaseServiceHelper COMPANY = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey());
    private static HRBaseServiceHelper DEPARTMENT = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey());
    private static HRBaseServiceHelper GROUP = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey());
    private static HRBaseServiceHelper BUSINESS_FILE = new HRBaseServiceHelper("haos_orgbusinessfile");
    private static HRBaseServiceHelper BILL_ENTRY_HELPER = OrgBatchValidateHelper.BATCHORGENTITY_HELPER;
    private static HRBaseServiceHelper ORG_TEAM = new HRBaseServiceHelper("haos_adminorgteam");
    private static HRBaseServiceHelper ORG_TEAM_STRUCT = new HRBaseServiceHelper("haos_adminorgstructure");
    private static HRBaseServiceHelper CO_OP_RELATION = new HRBaseServiceHelper("haos_orgteamcooprel");
    private static List<String> PROPERTIES = Collections.singletonList("id");

    public static DynamicObject[] queryHisStruct4InitCascade(List<Long> orgBoIdList, Date bsed) {
        QFilter adminOrgFilter = new QFilter("adminorg", "in", orgBoIdList);
        return STRUCT.queryOriginalArray("id, adminorg.id, structlongnumber, bsed, bsled,iscurrentversion", new QFilter[]{adminOrgFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get(), QueryHelper.createHisVersionFilter(bsed), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] queryHisOrgByVid(List<Long> orgIdList) {
        QFilter vidFilter = new QFilter("id", "in", orgIdList);
        return MASTER_DATA.queryOriginalArray("id, boid, adminorgtype.adminorgtypestd.id, belongcompany.id, index", new QFilter[]{vidFilter});
    }

    public static DynamicObject[] queryHisStructByStructLongNumber(Set<String> equalsStructLongNumberList, Set<String> likeStructLongNumberList, Date bsed) {
        Set equalsStructNumberList = equalsStructLongNumberList.stream().map(structLongNumber -> structLongNumber.substring(structLongNumber.lastIndexOf("!") + 1)).collect(Collectors.toSet());
        QFilter structNumberJoinFilter = new QFilter("adminorg.structnumber", "in", equalsStructNumberList);
        List<String> commonPrefixStructLongNumberList = QueryHelper.getCommonPrefixStructLongNumberList(likeStructLongNumberList);
        QFilter structLongNumberLikeFilter = commonPrefixStructLongNumberList.stream().map(likeStructLongNumber -> new QFilter("structlongnumber", "like", (Object)(likeStructLongNumber + "%"))).reduce(QueryHelper.create1NotEquals1Filter(), (qFilter, qFilter2) -> qFilter.or(qFilter2));
        DynamicObject[] structDynObjArr = STRUCT.queryOriginalArray(HIS_STRUCT_QUERY_FIELDS, new QFilter[]{structLongNumberLikeFilter.or(structNumberJoinFilter), (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get(), QueryHelper.createHisVersionFilter(bsed), QueryHelper.createInitFinishedFilter()});
        PatriciaTrie dynamicObjectPatriciaTrie = Arrays.stream(structDynObjArr).collect(Collectors.toMap(dyn -> dyn.getString("structlongnumber"), MethodHelper.listMapper(), MethodHelper.listAddAllMerger(), PatriciaTrie::new));
        HashMap structLongNumberVsStructDy = new HashMap();
        likeStructLongNumberList.forEach(structLongNumber -> {
            SortedMap stringDynamicObjectSortedMap = dynamicObjectPatriciaTrie.prefixMap(structLongNumber);
            structLongNumberVsStructDy.putAll(stringDynamicObjectSortedMap);
        });
        equalsStructLongNumberList.forEach(structLongNumber -> {
            List dynamicObject = (List)dynamicObjectPatriciaTrie.get(structLongNumber);
            structLongNumberVsStructDy.put(((DynamicObject)dynamicObject.get(0)).getString("structlongnumber"), dynamicObject);
        });
        return (DynamicObject[])structLongNumberVsStructDy.values().stream().flatMap(Collection::stream).toArray(DynamicObject[]::new);
    }

    private static List<String> getCommonPrefixStructLongNumberList(Set<String> likeStructLongNumberList) {
        return likeStructLongNumberList.stream().collect(Collectors.groupingBy(structLongNumber -> structLongNumber.substring(0, 12))).values().stream().map(TreeAssistUtils::getCommonPrefixStructLongNumber).collect(Collectors.toList());
    }

    public static DynamicObject[] queryHisStructByOrgBoId(List<Long> orgBoIdList, Date bsed) {
        QFilter boIdFilter = new QFilter("adminorg.id", "in", orgBoIdList);
        return STRUCT.queryOriginalArray(HIS_STRUCT_QUERY_FIELDS, new QFilter[]{boIdFilter, QueryHelper.createHisVersionFilter(bsed), QueryHelper.createInitFinishedFilter(), (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
    }

    public static DynamicObject[] queryHisMasterDataByOrgBoId(List<Long> orgBoIdList, Date bsed) {
        QFilter boIdFilter = new QFilter("boid", "in", orgBoIdList);
        return MASTER_DATA.queryOriginalArray("id,boid,parentorg.id,index,structnumber,belongcompany.id,adminorgtype.adminorgtypestd.id, iscurrentversion,bsed,bsled,datastatus", new QFilter[]{boIdFilter, QueryHelper.createHisVersionFilter(bsed), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] queryHisSortCodeByOrgBoId(List<Long> orgBoIdList, Date bsed) {
        QFilter boIdFilter = new QFilter("adminorg.id", "in", orgBoIdList);
        return SORT_CODE.queryOriginalArray("id,boid,sortcode,adminorg.id,bsed,bsled, iscurrentversion,datastatus", new QFilter[]{boIdFilter, QueryHelper.createHisVersionFilter(bsed), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] queryStructByParent4CountSub(List<Long> pBoIdList, List<Long> boIdList) {
        QFilter parentFilter = new QFilter("parentorg", "in", pBoIdList);
        QFilter adminOrgFilter = new QFilter("adminorg", "not in", boIdList);
        return STRUCT.queryOriginalArray("adminorg as adminorg.id, parentorg as parentorg.id", new QFilter[]{parentFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get(), adminOrgFilter, QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] loadBillEntry(long billId) {
        return BILL_ENTRY_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("billid", "=", (Object)billId)});
    }

    public static DynamicObject[] queryOrgTeamEstDateByVid(Set<Long> idSet) {
        if (CollectionUtils.isEmpty(idSet)) {
            return new DynamicObject[0];
        }
        return ORG_TEAM.queryOriginalArray("firstbsed, boid", new QFilter[]{new QFilter("id", "in", idSet)});
    }

    public static DynamicObject[] queryInitFieldsByVid(Set<Long> idSet) {
        if (CollectionUtils.isEmpty(idSet)) {
            return new DynamicObject[0];
        }
        return MASTER_DATA.queryOriginalArray("boid, initstatus, initbatch, initdatasource", new QFilter[]{new QFilter("id", "in", idSet)});
    }

    public static DynamicObject[] queryStructByParent4InitCascade(List<Long> orgBoIdList) {
        QFilter adminOrgFilter = new QFilter("adminorg", "in", orgBoIdList);
        return STRUCT.queryOriginalArray("adminorg.id, structlongnumber", new QFilter[]{adminOrgFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get(), QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] loadStructByStructLongNumber(List<String> equalsStructLongNumberList, List<String> likeStructLongNumberList) {
        Set equalsStructNumberList = equalsStructLongNumberList.stream().map(structLongNumber -> structLongNumber.substring(structLongNumber.lastIndexOf("!") + 1)).collect(Collectors.toSet());
        QFilter structNumberJoinFilter = new QFilter("adminorg.structnumber", "in", equalsStructNumberList);
        String commonPrefixStructLongNumber = TreeAssistUtils.getCommonPrefixStructLongNumber(likeStructLongNumberList);
        QFilter structLongNumberlikeFilter = new QFilter("structlongnumber", "like", (Object)(commonPrefixStructLongNumber + "%"));
        DynamicObject[] structDynObjArr = STRUCT.loadDynamicObjectArray(new QFilter[]{structLongNumberlikeFilter.or(structNumberJoinFilter), QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter(), (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
        PatriciaTrie dynamicObjectPatriciaTrie = Arrays.stream(structDynObjArr).collect(Collectors.toMap(dyn -> dyn.getString("structlongnumber"), dyn -> dyn, (value, value2) -> value, PatriciaTrie::new));
        HashMap structLongNumberVsStructDy = new HashMap();
        likeStructLongNumberList.forEach(structLongNumber -> {
            SortedMap stringDynamicObjectSortedMap = dynamicObjectPatriciaTrie.prefixMap(structLongNumber);
            structLongNumberVsStructDy.putAll(stringDynamicObjectSortedMap);
        });
        equalsStructLongNumberList.forEach(structLongNumber -> {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectPatriciaTrie.get(structLongNumber);
            structLongNumberVsStructDy.put(dynamicObject.getString("structlongnumber"), dynamicObject);
        });
        return structLongNumberVsStructDy.values().toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] loadMasterDataByOrgBoId(List<Long> orgBoIdList) {
        QFilter boIdFilter = new QFilter("boid", "in", orgBoIdList);
        return MASTER_DATA.loadDynamicObjectArray(new QFilter[]{boIdFilter, QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] loadStructByOrgBoId(List<Long> orgBoIdList) {
        QFilter boIdFilter = new QFilter("adminorg.id", "in", orgBoIdList);
        return STRUCT.loadDynamicObjectArray(new QFilter[]{boIdFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get(), QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] loadSortCodeByOrgBoId(List<Long> orgBoIdList) {
        QFilter boIdFilter = new QFilter("adminorg.id", "in", orgBoIdList);
        return SORT_CODE.loadDynamicObjectArray(new QFilter[]{boIdFilter, QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] loadCompanyByOrgBoId(List<Long> orgBoIdList) {
        QFilter boIdFilter = new QFilter("adminorg.id", "in", orgBoIdList);
        return COMPANY.loadDynamicObjectArray(new QFilter[]{boIdFilter, QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] loadDepartmentByOrgBoId(List<Long> orgBoIdList) {
        QFilter boIdFilter = new QFilter("adminorg.id", "in", orgBoIdList);
        return DEPARTMENT.loadDynamicObjectArray(new QFilter[]{boIdFilter, QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] loadGroupByOrgBoId(List<Long> orgBoIdList) {
        QFilter boIdFilter = new QFilter("adminorg.id", "in", orgBoIdList);
        return GROUP.loadDynamicObjectArray(new QFilter[]{boIdFilter, QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] loadById(String entityName, Set<Long> ids) {
        return new HRBaseServiceHelper(entityName).loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", ids)});
    }

    public static DynamicObject[] loadBusinessFileByOrgBoId(List<Long> orgBoIdList) {
        QFilter adminOrgFilter = new QFilter("adminorg.id", "in", orgBoIdList);
        return BUSINESS_FILE.loadDynamicObjectArray(new QFilter[]{adminOrgFilter, QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] loadOrgTeamByOrgBoId(List<Long> orgBoIdList) {
        QFilter boIdFilter = new QFilter("boid", "in", orgBoIdList);
        return ORG_TEAM.loadDynamicObjectArray(new QFilter[]{boIdFilter, QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] loadOrgTeamStructByOrgBoId(List<Long> orgBoIdList) {
        QFilter orgTeamFilter = new QFilter("orgteam", "in", orgBoIdList);
        return ORG_TEAM_STRUCT.loadDynamicObjectArray(new QFilter[]{orgTeamFilter, (QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get(), QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter()});
    }

    public static DynamicObject[] loadCoopRelationByOrgBoId(List<Long> orgBoIdList, QFilter enableFilter) {
        QFilter adminOrgFilter = new QFilter("org.id", "in", orgBoIdList);
        return CO_OP_RELATION.loadDynamicObjectArray(new QFilter[]{adminOrgFilter, QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter(), enableFilter});
    }

    public static DynamicObject[] loadCoopByOrgTeamBoId(List<Long> orgTeamBoIdList, QFilter qFilter) {
        QFilter adminOrgFilter = new QFilter("cooporgteam", "in", orgTeamBoIdList);
        return CO_OP_RELATION.loadDynamicObjectArray(new QFilter[]{adminOrgFilter, QueryHelper.createCurrentVersionFilter(), QueryHelper.createInitFinishedFilter(), qFilter});
    }

    public static Map<Long, Map<Long, DynamicObject>> getStructMap(Collection<Long> orgIds, Set<Long> structProjectIdSet) {
        DynamicObject[] structs = AdminOrgStructRepository.getInstance().queryOriginalEnableOtherStruct("id, structproject.id, parentorg.id, adminorg.id", structProjectIdSet, orgIds);
        return Arrays.stream(structs).collect(Collectors.groupingBy(dy -> dy.getLong("adminorg.id"), Collectors.toMap(dy -> dy.getLong("structproject.id"), dy -> dy)));
    }

    public static void updateBillEntryData(DynamicObject[] billEntryData) {
        BILL_ENTRY_HELPER.update(billEntryData);
    }

    public static DynamicObject generateEmptySubEntityMasterDy(long id) {
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)MASTER_DATA.getEntityName(), PROPERTIES);
        DynamicObject adminOrg = new DynamicObject(subDataEntityType);
        adminOrg.set("id", (Object)id);
        return adminOrg;
    }

    public static DynamicObject generateEmptyStructDy() {
        return STRUCT.generateEmptyDynamicObject();
    }

    public static DynamicObject generateEmptySortCodeDy() {
        return SORT_CODE.generateEmptyDynamicObject();
    }

    public static QFilter create1NotEquals1Filter() {
        return new QFilter("1", "!=", (Object)1);
    }

    public static QFilter create1Equals1Filter() {
        return new QFilter("1", "=", (Object)1);
    }

    public static QFilter createInitFinishedFilter() {
        return new QFilter("initstatus", "=", (Object)"2");
    }

    public static QFilter createCurrentVersionFilter() {
        return new QFilter("iscurrentversion", "=", (Object)"1");
    }

    public static QFilter createHisVersionFilter(Date bsed) {
        return new QFilter("bsled", ">=", (Object)bsed).and(new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.TEMP.getStatus()}));
    }

    public static HRBaseServiceHelper getMasterData() {
        return MASTER_DATA;
    }

    public static HRBaseServiceHelper getSTRUCT() {
        return STRUCT;
    }

    public static HRBaseServiceHelper getSortCode() {
        return SORT_CODE;
    }
}

