/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect.bo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.haos.common.model.ChangeRootData;
import kd.hr.homs.business.service.batcheffect.QueryHelper;
import kd.hr.homs.business.service.batcheffect.bo.BillEntryData;
import kd.hr.homs.business.service.batcheffect.bo.StructEntryData;
import kd.hr.homs.business.service.batcheffect.constant.EffectBillConstant;
import kd.hr.homs.business.service.batcheffect.fieldchange.FieldChangeHolder;
import kd.hr.homs.business.service.batcheffect.fieldchange.FieldChangeRecorder;
import kd.hr.homs.business.service.ext.function.DefaultBatchEffectServiceExtend;
import kd.hr.homs.business.service.ext.function.IBatchEffectServiceExtend;
import kd.hr.homs.common.model.batcheffect.DistributeOrgEntryExtendArgs;

public class BillData {
    DynamicObject bill;
    ChangeRootData changeRootData;
    BillEntryData entryBo;
    Date effectDate;
    DynamicObject creator;
    Set<Long> orgTypeChangedBoSet;
    Set<Long> indexChangedBoSet;
    Map<Long, DynamicObject> boVsEntryOrg;
    FieldChangeRecorder<Long> belongCompanyChangedRecorder;
    private static final Log LOGGER = LogFactory.getLog(BillData.class);

    private BillData(DynamicObject bill, DynamicObject[] entryOrg) {
        this.bill = bill;
        this.effectDate = bill.getDate("effdt");
        this.creator = bill.getDynamicObject("creator");
        if (entryOrg == null) {
            entryOrg = QueryHelper.loadBillEntry(this.bill.getLong("id"));
        }
        this.entryBo = this.initEntryBo(entryOrg);
        this.initChangedFileds();
    }

    private void distributeOrgEntryExtend(BillEntryData entryBo, DynamicObject[] entryOrg, DynamicObject bill) {
        DistributeOrgEntryExtendArgs distributeOrgEntryExtendArgs = new DistributeOrgEntryExtendArgs();
        distributeOrgEntryExtendArgs.setBill(bill);
        distributeOrgEntryExtendArgs.setBillOrgList(Arrays.asList(entryOrg));
        PluginProxy iBatchEffectServiceExtendPluginProxy = PluginProxy.create((Object)new DefaultBatchEffectServiceExtend(), IBatchEffectServiceExtend.class, (String)"kd.hr.homs.business.service.batcheffect.BatchEffectService.saveAdminOrg.beforeSave");
        iBatchEffectServiceExtendPluginProxy.callReplace(plugin -> {
            LOGGER.info(String.format("proxy plugin: %s", plugin.getClass()));
            LOGGER.info("before callReplace distributeOrgEntryExtend");
            plugin.distributeOrgEntryExtend(distributeOrgEntryExtendArgs);
            LOGGER.info("after callReplace distributeOrgEntryExtend");
            return null;
        });
        if (!CollectionUtils.isEmpty((Collection)distributeOrgEntryExtendArgs.getAddList())) {
            entryBo.addEntry.addAll(distributeOrgEntryExtendArgs.getAddList());
        }
        if (!CollectionUtils.isEmpty((Collection)distributeOrgEntryExtendArgs.getChgInfoList())) {
            entryBo.changeInfoEntry.addAll(distributeOrgEntryExtendArgs.getChgInfoList());
        }
        if (!CollectionUtils.isEmpty((Collection)distributeOrgEntryExtendArgs.getChgParentList())) {
            entryBo.changeParentEntry.addAll(distributeOrgEntryExtendArgs.getChgParentList());
        }
        if (!CollectionUtils.isEmpty((Collection)distributeOrgEntryExtendArgs.getDisableList())) {
            entryBo.disableEntry.addAll(distributeOrgEntryExtendArgs.getDisableList());
        }
    }

    private BillEntryData initEntryBo(DynamicObject[] entryOrg) {
        Map<Long, List<DynamicObject>> sceneIdVsEntry = Arrays.stream(entryOrg).collect(Collectors.groupingBy(dy -> dy.getLong("changescene.orgchangetype.id")));
        BillEntryData billEntryData = new BillEntryData();
        billEntryData.addEntry = sceneIdVsEntry.getOrDefault(EffectBillConstant.ADD, new ArrayList());
        billEntryData.changeInfoEntry = sceneIdVsEntry.getOrDefault(EffectBillConstant.INFO, new ArrayList());
        billEntryData.changeParentEntry = sceneIdVsEntry.getOrDefault(EffectBillConstant.PARENT, new ArrayList());
        billEntryData.disableEntry = sceneIdVsEntry.getOrDefault(EffectBillConstant.DISABLE, new ArrayList());
        this.distributeOrgEntryExtend(billEntryData, entryOrg, this.bill);
        billEntryData.mergeEntry = sceneIdVsEntry.getOrDefault(1070L, new ArrayList());
        billEntryData.splitEntry = sceneIdVsEntry.getOrDefault(1080L, new ArrayList());
        billEntryData.addSet = billEntryData.addEntry.stream().map(dy -> dy.getLong("adminorg.boid")).collect(Collectors.toSet());
        billEntryData.infoSet = billEntryData.changeInfoEntry.stream().map(dy -> dy.getLong("adminorg.boid")).collect(Collectors.toSet());
        billEntryData.parentSet = billEntryData.changeParentEntry.stream().map(dy -> dy.getLong("adminorg.boid")).collect(Collectors.toSet());
        billEntryData.disableSet = billEntryData.disableEntry.stream().map(dy -> dy.getLong("adminorg.boid")).collect(Collectors.toSet());
        this.setStructEntry4BillEntryData(billEntryData);
        return billEntryData;
    }

    private void setStructEntry4BillEntryData(BillEntryData billEntryData) {
        billEntryData.structAddEntry = new ArrayList<StructEntryData>();
        billEntryData.structChgEntry = new ArrayList<StructEntryData>();
        billEntryData.structDeleteEntry = new ArrayList<StructEntryData>();
        Set<Long> structProjectIdSet = Stream.of(billEntryData.addEntry, billEntryData.changeInfoEntry, billEntryData.changeParentEntry).flatMap(Collection::stream).map(dy -> dy.getDynamicObjectCollection("struct_project_entry")).flatMap(Collection::stream).map(structRow -> structRow.getLong("struct_project.id")).collect(Collectors.toSet());
        if (structProjectIdSet.size() == 0) {
            return;
        }
        Set<Long> allBoSet = this.getAllBoSet(billEntryData);
        Map<Long, Map<Long, DynamicObject>> orgBoVsStructProjectVsStructs = QueryHelper.getStructMap(allBoSet, structProjectIdSet);
        Stream.of(billEntryData.addEntry, billEntryData.changeInfoEntry, billEntryData.changeParentEntry).flatMap(Collection::stream).forEach(orgEntry -> {
            long orgBo = orgEntry.getLong("adminorg.boid");
            orgEntry.getDynamicObjectCollection("struct_project_entry").forEach(structEntry -> {
                long structProjectId = structEntry.getLong("struct_project.id");
                long parentId = structEntry.getLong("struct_parent_org.boid");
                Map structProjectVsStructs = orgBoVsStructProjectVsStructs.getOrDefault(orgBo, new HashMap());
                DynamicObject struct = (DynamicObject)structProjectVsStructs.get(structProjectId);
                boolean isEntryFillParent = parentId != 0L;
                boolean isDbExist = struct != null;
                Supplier<Boolean> isParentEqualsSupplier = () -> parentId == struct.getLong("parentorg.id");
                if (isEntryFillParent) {
                    if (isDbExist) {
                        if (!isParentEqualsSupplier.get().booleanValue()) {
                            StructEntryData structEntryData = new StructEntryData((DynamicObject)structEntry, orgBo, ChangeTransactionConstants.PARENT);
                            billEntryData.structChgEntry.add(structEntryData);
                        }
                    } else {
                        StructEntryData structEntryData = new StructEntryData((DynamicObject)structEntry, orgBo, ChangeTransactionConstants.ADD);
                        billEntryData.structAddEntry.add(structEntryData);
                    }
                } else if (isDbExist) {
                    StructEntryData structEntryData = new StructEntryData((DynamicObject)structEntry, orgBo, ChangeTransactionConstants.DISABLE);
                    billEntryData.structDeleteEntry.add(structEntryData);
                }
            });
        });
    }

    private void initChangedFileds() {
        this.belongCompanyChangedRecorder = new FieldChangeRecorder();
        FieldChangeRecorder orgTypeChangedRecorder = new FieldChangeRecorder();
        FieldChangeRecorder indexChangedRecorder = new FieldChangeRecorder();
        List<Long> infoEntryBeforeBaseInfoId = this.entryBo.changeInfoEntry.stream().peek(entryOrg -> orgTypeChangedRecorder.setNewValue(entryOrg.getLong("adminorg.boid"), entryOrg.getLong("adminorgtype.adminorgtypestd.id"))).peek(entryOrg -> indexChangedRecorder.setNewValue(entryOrg.getLong("adminorg.boid"), entryOrg.getInt("index"))).map(entryOrg -> entryOrg.getLong("adminorg.boid")).collect(Collectors.toList());
        infoEntryBeforeBaseInfoId.addAll(this.getParentBoSet());
        infoEntryBeforeBaseInfoId.addAll(this.getDisableBoSet());
        DynamicObject[] beforeHisOrg = QueryHelper.queryHisOrgByVid(infoEntryBeforeBaseInfoId);
        Set<Long> infoBoSet = this.getInfoBoSet();
        Arrays.stream(beforeHisOrg).forEach(hisOrg -> {
            long boId = hisOrg.getLong("boid");
            if (infoBoSet.contains(boId)) {
                orgTypeChangedRecorder.setOldValue(boId, hisOrg.getLong("adminorgtype.adminorgtypestd.id"));
            }
            this.belongCompanyChangedRecorder.setOldValue(boId, hisOrg.getLong("belongcompany.id"));
            indexChangedRecorder.setNewValue(boId, hisOrg.getInt("index"));
        });
        this.orgTypeChangedBoSet = orgTypeChangedRecorder.listChanged().stream().filter(holder -> EffectBillConstant.BELONG_COMPANY_SELF_TYPE.contains(holder.getNewValue()) && EffectBillConstant.BELONG_COMPANY_FOLLOW_TYPE.contains(holder.getOldValue()) || EffectBillConstant.BELONG_COMPANY_SELF_TYPE.contains(holder.getOldValue()) && EffectBillConstant.BELONG_COMPANY_FOLLOW_TYPE.contains(holder.getNewValue())).map(FieldChangeHolder::getId).collect(Collectors.toSet());
        this.indexChangedBoSet = indexChangedRecorder.listChanged().stream().map(FieldChangeHolder::getId).filter(infoBoSet::contains).collect(Collectors.toSet());
    }

    public static BillData createBillBo(DynamicObject bill) {
        return new BillData(bill, null);
    }

    public static BillData createBillBo(DynamicObject bill, DynamicObject[] entryOrg) {
        return new BillData(bill, entryOrg);
    }

    public Date getEffectDate() {
        return this.effectDate;
    }

    public DynamicObject getCreator() {
        return this.creator;
    }

    public long getBillId() {
        return this.bill.getLong("id");
    }

    public FieldChangeRecorder<Long> getBelongCompanyChangedRecorder() {
        return this.belongCompanyChangedRecorder;
    }

    public List<DynamicObject> getAddEntry() {
        return this.entryBo.addEntry;
    }

    public List<DynamicObject> getInfoEntry() {
        return this.entryBo.changeInfoEntry;
    }

    public List<DynamicObject> getParentEntry() {
        return this.entryBo.changeParentEntry;
    }

    public List<DynamicObject> getMergeEntry() {
        return this.entryBo.mergeEntry;
    }

    public List<DynamicObject> getSplitEntry() {
        return this.entryBo.splitEntry;
    }

    public List<DynamicObject> getDisableEntry() {
        return this.entryBo.disableEntry;
    }

    public List<DynamicObject> getAllEntry() {
        return Stream.of(this.entryBo.addEntry, this.entryBo.changeInfoEntry, this.entryBo.changeParentEntry, this.entryBo.disableEntry).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<DynamicObject> getMergeSplitEntry() {
        return Stream.of(this.entryBo.mergeEntry, this.entryBo.splitEntry).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Set<Long> getOrgTypeChangedBoSet() {
        return Collections.unmodifiableSet(this.orgTypeChangedBoSet);
    }

    public Set<Long> getIndexChangedBoSet() {
        return this.indexChangedBoSet;
    }

    public Set<Long> getAddBoSet() {
        return Collections.unmodifiableSet(this.entryBo.addSet);
    }

    public Set<Long> getInfoBoSet() {
        return Collections.unmodifiableSet(this.entryBo.infoSet);
    }

    public Set<Long> getParentBoSet() {
        return Collections.unmodifiableSet(this.entryBo.parentSet);
    }

    public Set<Long> getDisableBoSet() {
        return Collections.unmodifiableSet(this.entryBo.disableSet);
    }

    public Set<Long> getAllBoSet() {
        return this.getAllBoSet(this.entryBo);
    }

    private Set<Long> getAllBoSet(BillEntryData entryBo) {
        return Stream.of(entryBo.addSet, entryBo.infoSet, entryBo.parentSet, entryBo.disableSet).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public String getBillType() {
        return this.bill.getString("billtype");
    }

    public DynamicObject getBill() {
        return this.bill;
    }

    private DynamicObject getEntryOrg(long bo) {
        if (this.boVsEntryOrg == null) {
            this.boVsEntryOrg = this.getAllEntry().stream().collect(Collectors.toMap(dy -> dy.getLong("adminorg.boid"), dy -> dy));
        }
        return this.boVsEntryOrg.get(bo);
    }

    public Date getEntryOrgEffectDate(long bo) {
        return this.getEntryOrg(bo).getDate("bsed");
    }

    public ChangeRootData getChangeRootData() {
        return this.changeRootData;
    }

    public void setChangeRootData(ChangeRootData changeRootData) {
        this.changeRootData = changeRootData;
    }

    public List<StructEntryData> getStructAddEntry() {
        return this.entryBo.structAddEntry;
    }

    public List<StructEntryData> getStructChgEntry() {
        return this.entryBo.structChgEntry;
    }

    public List<StructEntryData> getStructDeleteEntry() {
        return this.entryBo.structDeleteEntry;
    }
}

