/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect.cascade.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.homs.business.service.batcheffect.cascade.model.CascadeModel;
import kd.hr.homs.business.service.batcheffect.cascade.model.MasterCascadeModel;
import kd.hr.homs.business.service.batcheffect.cascade.model.SortCodeCascadeModel;
import kd.hr.homs.business.service.batcheffect.cascade.model.StructCascadeModel;

public class CascadeBo {
    private long id;
    private long pid;
    private LocalDateRange effectRange;
    private int index;
    private String structNumber;
    private List<MasterCascadeModel> masterList;
    private List<StructCascadeModel> structList;
    private List<SortCodeCascadeModel> sortCodeList;
    private List<CascadeModel> changedList = new ArrayList<CascadeModel>();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getPid() {
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getStructNumber() {
        return this.structNumber;
    }

    public void setStructNumber(String structNumber) {
        this.structNumber = structNumber;
    }

    public LocalDateRange getEffectRange() {
        return this.effectRange;
    }

    public void setEffectRange(LocalDateRange effectRange) {
        this.effectRange = effectRange;
    }

    public List<MasterCascadeModel> getMasterList() {
        return this.masterList;
    }

    public void setMasterList(List<MasterCascadeModel> masterList) {
        this.masterList = masterList;
    }

    public List<StructCascadeModel> getStructList() {
        return this.structList;
    }

    public void setStructList(List<StructCascadeModel> structList) {
        this.structList = structList;
    }

    public List<SortCodeCascadeModel> getSortCodeList() {
        return this.sortCodeList;
    }

    public void setSortCodeList(List<SortCodeCascadeModel> sortCodeList) {
        this.sortCodeList = sortCodeList;
    }

    public List<CascadeModel> getChangedList() {
        return this.changedList;
    }

    public void setChangedList(List<CascadeModel> changedList) {
        this.changedList = changedList;
    }

    public void filterAndResetDateRange(LocalDateRange newDateRange) {
        this.masterList = this.masterList.stream().filter(cascadeModel -> cascadeModel.getEffectRange().overlaps(newDateRange)).peek(cascadeModel -> cascadeModel.setEffectRange(cascadeModel.getEffectRange().intersection(newDateRange))).collect(Collectors.toList());
        this.structList = this.structList.stream().filter(cascadeModel -> cascadeModel.getEffectRange().overlaps(newDateRange)).peek(cascadeModel -> cascadeModel.setEffectRange(cascadeModel.getEffectRange().intersection(newDateRange))).collect(Collectors.toList());
        this.sortCodeList = this.sortCodeList.stream().filter(cascadeModel -> cascadeModel.getEffectRange().overlaps(newDateRange)).peek(cascadeModel -> cascadeModel.setEffectRange(cascadeModel.getEffectRange().intersection(newDateRange))).collect(Collectors.toList());
    }

    public void overlapVersion(List<CascadeModel> changedCascadeModelList) {
        changedCascadeModelList.forEach(changedCascadeModel -> {
            if (changedCascadeModel instanceof MasterCascadeModel) {
                this.overlap((List)this.masterList, (CascadeModel)changedCascadeModel);
            } else if (changedCascadeModel instanceof StructCascadeModel) {
                this.overlap((List)this.structList, (CascadeModel)changedCascadeModel);
            } else if (changedCascadeModel instanceof SortCodeCascadeModel) {
                this.overlap((List)this.sortCodeList, (CascadeModel)changedCascadeModel);
            }
        });
    }

    private <T> void overlap(List<T> cascadeModelList, CascadeModel changedCascadeModel) {
        for (int i = 0; i < cascadeModelList.size(); ++i) {
            if (!cascadeModelList.get(i).equals(changedCascadeModel)) continue;
            cascadeModelList.set(i, changedCascadeModel);
            break;
        }
    }

    public CascadeBo clone() {
        CascadeBo cascadeBo = new CascadeBo();
        cascadeBo.masterList = this.masterList.stream().map(MasterCascadeModel::clone).collect(Collectors.toList());
        cascadeBo.structList = this.structList.stream().map(StructCascadeModel::clone).collect(Collectors.toList());
        cascadeBo.sortCodeList = this.sortCodeList.stream().map(SortCodeCascadeModel::clone).collect(Collectors.toList());
        return cascadeBo;
    }
}

