/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect.cascade.model;

import java.util.Comparator;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.homs.business.service.batcheffect.MethodHelper;
import kd.hr.homs.business.service.batcheffect.cascade.CascadeFunction;

public class CascadeModel
implements CascadeFunction {
    public static CascadeModel EMPTY = new CascadeModel();
    private long vid;
    private LocalDateRange effectRange;

    public long getVid() {
        return this.vid;
    }

    public void setVid(long vid) {
        this.vid = vid;
    }

    public LocalDateRange getEffectRange() {
        return this.effectRange;
    }

    public void setEffectRange(LocalDateRange effectRange) {
        this.effectRange = effectRange;
    }

    public CascadeModel getEmptyCascadeModel() {
        return EMPTY;
    }

    public boolean isChanged() {
        return this != EMPTY;
    }

    @Override
    public void dynamicObjectSetter(DynamicObject dynamicObject) {
        dynamicObject.set("bsed", (Object)MethodHelper.toDate(this.effectRange.getStart()));
        dynamicObject.set("bsled", (Object)MethodHelper.toDate(this.effectRange.getEndInclusive()));
    }

    @Override
    public void dynamicObjectGetter(DynamicObject dynamicObject) {
        this.effectRange = MethodHelper.getEffectDateRangeFromHisDy(dynamicObject);
        this.vid = dynamicObject.getLong("id");
    }

    @Override
    public boolean canCombine(CascadeModel cascadeModel) {
        if (!this.getClass().equals(cascadeModel.getClass())) {
            return false;
        }
        return cascadeModel.getVid() == this.vid && cascadeModel.effectRange.abuts(this.effectRange);
    }

    public static Comparator<CascadeModel> getDateRangeComparator() {
        return Comparator.comparing(cascadeModel -> cascadeModel.getEffectRange().getStart());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CascadeModel that = (CascadeModel)o;
        return this.vid == that.vid && Objects.equals(this.effectRange, that.effectRange);
    }

    public int hashCode() {
        return Objects.hash(this.vid, this.effectRange);
    }

    public CascadeModel clone() {
        CascadeModel cascadeModel = new CascadeModel();
        cascadeModel.effectRange = this.effectRange;
        cascadeModel.vid = this.vid;
        return cascadeModel;
    }

    protected void cloneFields(CascadeModel cascadeModel) {
        cascadeModel.setVid(this.vid);
        cascadeModel.setEffectRange(this.effectRange);
    }

    public String toString() {
        return "CascadeModel{vid=" + this.vid + ", effectRange=" + this.effectRange + '}';
    }
}

