/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect.cascade.model;

import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.homs.business.service.batcheffect.QueryHelper;
import kd.hr.homs.business.service.batcheffect.cascade.model.CascadeModel;
import kd.hr.homs.business.service.batcheffect.constant.EffectBillConstant;

public class MasterCascadeModel
extends CascadeModel {
    private long belongCompany;
    private boolean isFollowCompany;

    @Override
    public CascadeModel getCascadeModel(CascadeModel parentModel) {
        MasterCascadeModel result = new MasterCascadeModel();
        if (!this.isFollowCompany()) {
            return EMPTY;
        }
        result.setBelongCompany(((MasterCascadeModel)parentModel).getBelongCompany());
        if (this.cascadeFieldsEquals(result)) {
            return EMPTY;
        }
        result.setFollowCompany(this.isFollowCompany());
        result.setVid(this.getVid());
        result.setEffectRange(this.getEffectRange().intersection(parentModel.getEffectRange()));
        return result;
    }

    private boolean cascadeFieldsEquals(MasterCascadeModel result) {
        return this.getBelongCompany() == result.getBelongCompany();
    }

    @Override
    public void dynamicObjectSetter(DynamicObject dynamicObject) {
        super.dynamicObjectSetter(dynamicObject);
        dynamicObject.set("belongcompany", (Object)QueryHelper.generateEmptySubEntityMasterDy(this.belongCompany));
        dynamicObject.set("id", (Object)this.getVid());
    }

    @Override
    public void dynamicObjectGetter(DynamicObject dynamicObject) {
        super.dynamicObjectGetter(dynamicObject);
        this.belongCompany = dynamicObject.getLong("belongcompany.id");
        this.isFollowCompany = EffectBillConstant.BELONG_COMPANY_FOLLOW_TYPE.contains(dynamicObject.getLong("adminorgtype.adminorgtypestd.id"));
    }

    @Override
    public boolean canCombine(CascadeModel cascadeModel) {
        return super.canCombine(cascadeModel) && this.cascadeFieldsEquals((MasterCascadeModel)cascadeModel);
    }

    @Override
    public MasterCascadeModel clone() {
        MasterCascadeModel clone = new MasterCascadeModel();
        super.cloneFields(clone);
        clone.isFollowCompany = this.isFollowCompany;
        clone.belongCompany = this.belongCompany;
        return clone;
    }

    public long getBelongCompany() {
        return this.belongCompany;
    }

    public void setBelongCompany(long belongCompany) {
        this.belongCompany = belongCompany;
    }

    public boolean isFollowCompany() {
        return this.isFollowCompany;
    }

    public void setFollowCompany(boolean followCompany) {
        this.isFollowCompany = followCompany;
    }
}

