/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batcheffect.cascade.tree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.homs.business.service.batcheffect.MethodHelper;
import kd.hr.homs.business.service.batcheffect.cascade.model.CascadeBo;
import kd.hr.homs.business.service.batcheffect.cascade.model.CascadeModel;
import kd.hr.homs.business.service.batcheffect.cascade.model.CascadeResult;
import kd.hr.homs.business.service.batcheffect.cascade.model.MasterCascadeModel;
import kd.hr.homs.business.service.batcheffect.cascade.model.SortCodeCascadeModel;
import kd.hr.homs.business.service.batcheffect.cascade.model.StructCascadeModel;
import kd.hr.homs.business.service.batcheffect.cascade.tree.DateRangeNode;

public class MultiVersionTree {
    private DateRangeNode<CascadeBo> virtualRoot = MultiVersionTree.getVirtualRoot();
    private Map<Long, List<DateRangeNode<CascadeBo>>> boVsNodeList;

    private MultiVersionTree() {
    }

    public static MultiVersionTree buildTree(List<DynamicObject> masterList, List<DynamicObject> structList, List<DynamicObject> sortCodeList) {
        Map<Long, List<DynamicObject>> boVsMaster = masterList.stream().collect(Collectors.groupingBy(master -> master.getLong("boid")));
        Map<Long, List<DynamicObject>> boVsStruct = structList.stream().collect(Collectors.groupingBy(struct -> struct.getLong("adminorg.id")));
        Map<Long, List<DynamicObject>> boVsSortCode = sortCodeList.stream().collect(Collectors.groupingBy(sortCode -> sortCode.getLong("adminorg.id")));
        MultiVersionTree multiVersionTree = new MultiVersionTree();
        multiVersionTree.boVsNodeList = boVsMaster.entrySet().stream().map(entry -> ((List)entry.getValue()).stream().map(MultiVersionTree::createCascadeBo).map(cascadeBo -> MultiVersionTree.createDateRangeNode((List)boVsStruct.get(entry.getKey()), (List)boVsSortCode.get(entry.getKey()), cascadeBo)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toMap(node -> ((CascadeBo)node.getVal()).getId(), MethodHelper.listMapper(), MethodHelper.listAddAllMerger()));
        List<DateRangeNode<CascadeBo>> defaultParentList = Collections.singletonList(multiVersionTree.virtualRoot);
        multiVersionTree.boVsNodeList.values().forEach(nodeList -> nodeList.forEach(node -> {
            List<DateRangeNode<CascadeBo>> parentNodeList = multiVersionTree.boVsNodeList.getOrDefault(((CascadeBo)node.getVal()).getPid(), defaultParentList);
            AtomicBoolean noRealRoot = new AtomicBoolean(true);
            parentNodeList.forEach(parentNode -> {
                if (parentNode.getDateRange().overlaps(node.getDateRange())) {
                    parentNode.getChildList().add(node);
                    noRealRoot.set(false);
                }
            });
            if (noRealRoot.get()) {
                multiVersionTree.virtualRoot.getChildList().add((DateRangeNode<CascadeBo>)node);
            }
        }));
        return multiVersionTree;
    }

    private static DateRangeNode<CascadeBo> getVirtualRoot() {
        DateRangeNode<CascadeBo> virtualRoot = new DateRangeNode<CascadeBo>();
        virtualRoot.setDateRange(LocalDateRange.ALL);
        return virtualRoot;
    }

    private static DateRangeNode<CascadeBo> createDateRangeNode(List<DynamicObject> structDyList, List<DynamicObject> sortCodeDyList, CascadeBo cascadeBo) {
        DateRangeNode<CascadeBo> dateRangeNode = new DateRangeNode<CascadeBo>();
        dateRangeNode.setVal(cascadeBo);
        dateRangeNode.setDateRange(cascadeBo.getEffectRange());
        cascadeBo.setStructList(structDyList.stream().filter(dy -> LocalDateRange.ofClosed((Date)dy.getDate("bsed"), (Date)dy.getDate("bsled")).overlaps(dateRangeNode.getDateRange())).map(structDy -> {
            StructCascadeModel structCascadeModel = new StructCascadeModel();
            structCascadeModel.dynamicObjectGetter((DynamicObject)structDy);
            return structCascadeModel;
        }).collect(Collectors.toList()));
        cascadeBo.setSortCodeList(sortCodeDyList.stream().filter(dy -> LocalDateRange.ofClosed((Date)dy.getDate("bsed"), (Date)dy.getDate("bsled")).overlaps(dateRangeNode.getDateRange())).map(sortCodeDy -> {
            SortCodeCascadeModel sortCodeCascadeModel = new SortCodeCascadeModel();
            sortCodeCascadeModel.dynamicObjectGetter((DynamicObject)sortCodeDy);
            return sortCodeCascadeModel;
        }).collect(Collectors.toList()));
        cascadeBo.getStructList().forEach(structCascadeModel -> structCascadeModel.setStructNumber(cascadeBo.getStructNumber()));
        cascadeBo.getSortCodeList().forEach(sortCodeCascadeModel -> sortCodeCascadeModel.setIndex(cascadeBo.getIndex()));
        return dateRangeNode;
    }

    private static CascadeBo createCascadeBo(DynamicObject masterDy) {
        CascadeBo cascadeBo = new CascadeBo();
        cascadeBo.setId(masterDy.getLong("boid"));
        cascadeBo.setPid(masterDy.getLong("parentorg.id"));
        cascadeBo.setStructNumber(masterDy.getString("structnumber"));
        cascadeBo.setIndex(masterDy.getInt("index"));
        cascadeBo.setEffectRange(MethodHelper.getEffectDateRangeFromHisDy(masterDy));
        MasterCascadeModel masterCascadeModel = new MasterCascadeModel();
        masterCascadeModel.dynamicObjectGetter(masterDy);
        cascadeBo.setMasterList(Collections.singletonList(masterCascadeModel));
        return cascadeBo;
    }

    public void traverse() {
        ArrayDeque<SearchNode> queue = new ArrayDeque<SearchNode>();
        this.virtualRoot.getChildList().stream().map(node -> new SearchNode((CascadeBo)node.getVal(), node.getChildList(), node.getDateRange())).forEach(queue::offer);
        while (!queue.isEmpty()) {
            SearchNode parent = (SearchNode)queue.poll();
            for (DateRangeNode child : parent.childList) {
                if (!child.getDateRange().overlaps(parent.searchDateRange)) continue;
                LocalDateRange newSearchDateRange = child.getDateRange().intersection(parent.searchDateRange);
                List<CascadeModel> changedCascadeModelList = this.followParent(parent.timedParentData, (CascadeBo)child.getVal(), newSearchDateRange);
                CascadeBo clone = this.cloneCascadeBo(child, newSearchDateRange, changedCascadeModelList);
                SearchNode searchNode = new SearchNode(clone, child.getChildList(), newSearchDateRange);
                queue.offer(searchNode);
            }
        }
    }

    private CascadeBo cloneCascadeBo(DateRangeNode<CascadeBo> child, LocalDateRange newSearchDateRange, List<CascadeModel> changedCascadeModelList) {
        CascadeBo clone = child.getVal().clone();
        Map<Class, List<CascadeModel>> clzVsChangedCascadeModelList = changedCascadeModelList.stream().collect(Collectors.groupingBy(Object::getClass));
        List<? extends CascadeModel> masterCascadeModelList = this.overlapVersion(clone.getMasterList(), clzVsChangedCascadeModelList.getOrDefault(MasterCascadeModel.class, Collections.emptyList()), newSearchDateRange);
        clone.setMasterList(masterCascadeModelList);
        List<? extends CascadeModel> sortCodeCascadeModelList = this.overlapVersion(clone.getSortCodeList(), clzVsChangedCascadeModelList.getOrDefault(SortCodeCascadeModel.class, Collections.emptyList()), newSearchDateRange);
        clone.setSortCodeList(sortCodeCascadeModelList);
        List<? extends CascadeModel> structCascadeModelList = this.overlapVersion(clone.getStructList(), clzVsChangedCascadeModelList.getOrDefault(StructCascadeModel.class, Collections.emptyList()), newSearchDateRange);
        clone.setStructList(structCascadeModelList);
        return clone;
    }

    private List<? extends CascadeModel> overlapVersion(List<? extends CascadeModel> oldVersionList, List<? extends CascadeModel> newVersionList, LocalDateRange newEffectRange) {
        if (CollectionUtils.isEmpty(newVersionList)) {
            return oldVersionList.stream().filter(cascadeModel -> cascadeModel.getEffectRange().overlaps(newEffectRange)).peek(cascadeModel -> cascadeModel.setEffectRange(cascadeModel.getEffectRange().intersection(newEffectRange))).collect(Collectors.toList());
        }
        List newEffectRangeList = newVersionList.stream().map(CascadeModel::getEffectRange).collect(Collectors.toList());
        LocalDateRange oldEffectRange = oldVersionList.stream().map(CascadeModel::getEffectRange).reduce(LocalDateRange::span).get();
        List restOldEffectRangeList = oldEffectRange.subtract(newEffectRangeList);
        BiFunction<List, LocalDateRange, List> findAndSetEffectRangeCascadeModelByDateRange = (cascadeModelList, effectRange) -> cascadeModelList.stream().filter(cascadeModel -> cascadeModel.getEffectRange().overlaps(effectRange)).peek(cascadeModel -> cascadeModel.setEffectRange(cascadeModel.getEffectRange().intersection(effectRange))).collect(Collectors.toList());
        List restOldVersionList = restOldEffectRangeList.stream().map(restOldEffectRange -> (List)findAndSetEffectRangeCascadeModelByDateRange.apply(oldVersionList, (LocalDateRange)restOldEffectRange)).flatMap(Collection::stream).collect(Collectors.toList());
        return Stream.of(restOldVersionList, newVersionList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<CascadeModel> followParent(CascadeBo parentCascadeBo, CascadeBo childCascadeBo, LocalDateRange searchDateRange) {
        List<CascadeModel> masterChangedCascadeModelList = this.getChangedCascadeModelList(searchDateRange, parentCascadeBo.getMasterList(), childCascadeBo.getMasterList());
        List<CascadeModel> structChangedCascadeModelList = this.getChangedCascadeModelList(searchDateRange, parentCascadeBo.getStructList(), childCascadeBo.getStructList());
        List<CascadeModel> sortCodeChangedCascadeModelList = this.getChangedCascadeModelList(searchDateRange, parentCascadeBo.getSortCodeList(), childCascadeBo.getSortCodeList());
        ArrayList<CascadeModel> result = new ArrayList<CascadeModel>(masterChangedCascadeModelList);
        result.addAll(structChangedCascadeModelList);
        result.addAll(sortCodeChangedCascadeModelList);
        childCascadeBo.getChangedList().addAll(result);
        return result;
    }

    private List<CascadeModel> getChangedCascadeModelList(LocalDateRange searchDateRange, List<? extends CascadeModel> parentDataList, List<? extends CascadeModel> childDataList) {
        List checkedParentList = parentDataList.stream().filter(cascadeModel -> cascadeModel.getEffectRange().overlaps(searchDateRange)).collect(Collectors.toList());
        List checkedChildList = childDataList.stream().filter(cascadeModel -> cascadeModel.getEffectRange().overlaps(searchDateRange)).collect(Collectors.toList());
        return checkedParentList.stream().map(parentModel -> checkedChildList.stream().filter(childModel -> childModel.getEffectRange().overlaps(parentModel.getEffectRange())).map(childModel -> {
            CascadeModel cascadeModel = childModel.getCascadeModel((CascadeModel)parentModel);
            if (!CascadeModel.EMPTY.equals(cascadeModel)) {
                cascadeModel.setEffectRange(cascadeModel.getEffectRange().intersection(searchDateRange));
            }
            return cascadeModel;
        }).filter(CascadeModel::isChanged).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Map<Long, List<DateRangeNode<CascadeBo>>> getBoVsNodeList() {
        return this.boVsNodeList;
    }

    public List<CascadeResult> getChangedCascadeResult() {
        List<CascadeResult> cascadeResultList = this.boVsNodeList.values().stream().flatMap(Collection::stream).map(DateRangeNode::getVal).map(cascadeBo -> {
            CascadeResult cascadeResult = new CascadeResult();
            cascadeResult.setChangedCascadeModelList(cascadeBo.getChangedList());
            cascadeResult.setId(cascadeBo.getId());
            cascadeResult.setEffectRange(cascadeBo.getEffectRange());
            return cascadeResult;
        }).collect(Collectors.toList());
        this.combineVersion(cascadeResultList);
        return cascadeResultList;
    }

    private void combineVersion(List<CascadeResult> cascadeResultList) {
        cascadeResultList.forEach(cascadeResult -> {
            List<CascadeModel> changedCascadeModelList = cascadeResult.getChangedCascadeModelList();
            Map<Class, List<CascadeModel>> classVsModelList = changedCascadeModelList.stream().collect(Collectors.groupingBy(Object::getClass));
            List<CascadeModel> newList = classVsModelList.values().stream().map(this::combineVersion4SpecifyModel).flatMap(Collection::stream).collect(Collectors.toList());
            cascadeResult.setChangedCascadeModelList(newList);
        });
    }

    private List<CascadeModel> combineVersion4SpecifyModel(List<CascadeModel> changedCascadeModelList) {
        if (changedCascadeModelList.size() <= 1) {
            return changedCascadeModelList;
        }
        changedCascadeModelList.sort(CascadeModel.getDateRangeComparator());
        ArrayList<CascadeModel> newList = new ArrayList<CascadeModel>();
        newList.add(changedCascadeModelList.get(0));
        for (int i = 1; i < changedCascadeModelList.size(); ++i) {
            CascadeModel after;
            CascadeModel before = (CascadeModel)newList.get(newList.size() - 1);
            if (before.canCombine(after = changedCascadeModelList.get(i))) {
                before.setEffectRange(before.getEffectRange().union(after.getEffectRange()));
                continue;
            }
            CascadeModel newVersion = after;
            newList.add(newVersion);
        }
        return newList;
    }

    private static class SearchNode {
        private CascadeBo timedParentData;
        private List<DateRangeNode<CascadeBo>> childList;
        private LocalDateRange searchDateRange;

        public SearchNode(CascadeBo timedParentData, List<DateRangeNode<CascadeBo>> childList, LocalDateRange searchDateRange) {
            this.timedParentData = timedParentData;
            this.childList = childList;
            this.searchDateRange = searchDateRange;
        }
    }
}

