/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batchservice;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.batchservice.AdminOrgBatchBillBaseService;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.orgbatch.strategy.AdminOrgBatchViewStrategyContext;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.business.service.utils.PatternUtil;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;

public class AdminOrgBatchBillAfterBindDataService
extends AdminOrgBatchBillBaseService {
    private static String SELECT_ENTRY_FIELDE = "id, number, adminorg, name, simplename, adminorgtype, parentorg, oriparentorg, establishmentdate, changescene, changetype, changereason, corporateorg, changedescription, adminorglayer, adminorgfunction, companyarea, city, workplace, tobedisableflag,org, safetype,safelevel, beforemergeorgid, aftermergeorgid , beforesplitorgid, aftersplitorgid, mergesplitstatus";
    private static Map<String, String> entryType2PropertyNameOlyKeyCombine = new HashMap<String, String>(){
        {
            this.put("entryentity_merge", "aftermergeorgid");
            this.put("entryentity_split", "beforesplitorgid");
        }
    };
    private static Map<String, String> entryType2PropertyName = new HashMap<String, String>(){
        {
            this.put("entryentity_merge", "beforemergeorgid");
            this.put("entryentity_split", "aftersplitorgid");
        }
    };
    private static Map<String, String> entryType2MultiProperty = new HashMap<String, String>(){
        {
            this.put("entryentity_merge", "to_merge_org");
            this.put("entryentity_split", "split_target_org");
        }
    };
    private static List<String> mergeFiled = new ArrayList<String>(){
        {
            this.add("to_merge_org");
            this.add("merge_target_org");
            this.add("merge_changescene");
            this.add("merge_changereason");
            this.add("merge_changedescription");
            this.add("merge_origin_id");
        }
    };
    private static List<String> splitFiled = new ArrayList<String>(){
        {
            this.add("split_target_org");
            this.add("to_split_org");
            this.add("split_changescene");
            this.add("split_changereason");
            this.add("split_changedescription");
            this.add("split_origin_id");
        }
    };
    private static Map<String, List<String>> entryType2FiledName = new HashMap<String, List<String>>(){
        {
            this.put("entryentity_merge", mergeFiled);
            this.put("entryentity_split", splitFiled);
        }
    };

    public AdminOrgBatchBillAfterBindDataService(IFormView view) {
        super(view);
    }

    public void afterBindData(EventObject e) {
        this.genBillIdIfNotExist();
        this.handleViewElement();
        this.deleteAllEntryData();
        this.updateAllChangeSceneEntry();
        this.updateAllTabPageText();
        this.fixColumn();
        this.pageShowDetail();
        this.deleteAddEntryIfChangeOrg();
        this.changeOrgFiledTip();
        this.getModel().setDataChanged(false);
    }

    private void changeOrgFiledTip() {
        FieldTip orgTip = new FieldTip();
        orgTip.setFieldKey("org");
        orgTip.setSuccess(true);
        this.getView().showFieldTip(orgTip);
    }

    private void deleteAddEntryIfChangeOrg() {
        DynamicObject dy;
        String newId;
        String orgCache = this.getView().getPageCache().get("orgCache");
        Object org = this.getModel().getValue("org");
        if (Objects.isNull(orgCache)) {
            if (Objects.nonNull(org)) {
                DynamicObject dy2 = (DynamicObject)org;
                this.getView().getPageCache().put("orgCache", dy2.getLong("id") + "");
            }
        } else if (Objects.nonNull(org) && !orgCache.equals(newId = (dy = (DynamicObject)org).getLong("id") + "")) {
            long billId = this.getModel().getDataEntity().getLong("id");
            HRBaseServiceHelper orgChgBillEntryHelper = new HRBaseServiceHelper("homs_batchorgentity");
            QFilter billIdFilter = new QFilter("billid", "=", (Object)billId);
            DynamicObject[] orgChgBillEntryDynArr = orgChgBillEntryHelper.query("id, number, changetype,adminorg", new QFilter[]{billIdFilter});
            orgChgBillEntryHelper.deleteByFilter(new QFilter[]{billIdFilter});
            List<Long> addOrgIdList = Arrays.stream(orgChgBillEntryDynArr).filter(dyn -> dyn.getLong("changetype.id") == OrgBatchChgBillConstants.CHANGE_TYPE_ADD.longValue()).map(dyn -> dyn.getLong("adminorg.id")).collect(Collectors.toList());
            this.getView().getPageCache().put("orgCache", newId);
            this.getView().setVisible(Boolean.TRUE, new String[]{"noentrydata_flex"});
            if (addOrgIdList.size() == 0) {
                return;
            }
            AdminOrgBatchChgHelper.delAddMaster(addOrgIdList);
        }
    }

    private void genBillIdIfNotExist() {
        long billId = this.getModel().getDataEntity().getLong("id");
        if (billId == 0L) {
            billId = ORM.create().genLongId("homs_orgbatchchgbill");
            this.getModel().setValue("id", (Object)billId);
        }
    }

    private void handleViewElement() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        DynamicObject dynamicObject = serviceHelper.queryOne("billstatus", new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("id")));
        String billStatus = dynamicObject != null ? dynamicObject.getString("billstatus") : this.getModel().getDataEntity().getString("billstatus");
        AdminOrgBatchViewStrategyContext.handleViewElementByAuditStatus(billStatus, this.getView());
    }

    private void deleteAllEntryData() {
        Arrays.stream(BillEntryHelperEnum.values()).forEach(entryEum -> this.getModel().deleteEntryData(entryEum.getEntryName()));
    }

    private void updateAllChangeSceneEntry() {
        Long billId = this.getModel().getDataEntity().getLong("id");
        HRBaseServiceHelper batchOrgEntityHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter billIdFilter = new QFilter("billid", "=", (Object)billId);
        DynamicObject[] batchOrgEntryEntityDynArr = batchOrgEntityHelper.loadDynamicObjectArray(new QFilter[]{billIdFilter});
        Arrays.sort(batchOrgEntryEntityDynArr, Comparator.comparingLong(dyn -> dyn.getLong("sequence")));
        this.showMergeAndSplitEntry(batchOrgEntryEntityDynArr);
        Map<Long, String> orgId4LongNameMap = this.getOrgBoId4LongNameMap(batchOrgEntryEntityDynArr);
        Map<Long, List<DynamicObject>> changeTypeForBillDynMap = this.setTabApVisibleAndReturnChangeSceneColl(batchOrgEntryEntityDynArr);
        for (Map.Entry<Long, List<DynamicObject>> longListEntry : changeTypeForBillDynMap.entrySet()) {
            Long changeTypeId = longListEntry.getKey();
            List<DynamicObject> entryEntityDynList = longListEntry.getValue();
            String entryEntity = EntryEntityEnum.getEntryKeyByChangeTypeIdWithExt(changeTypeId);
            String prefix = BillEntryHelperEnum.getPrefixByChangeTypeIdWithExt(changeTypeId);
            List<String> entryFields = BillEntryHelperEnum.getEntryListByChangeTypeWithExt(changeTypeId);
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryEntity);
            DynamicObjectType dynamicObjectType = dynamicObjectCollection.getDynamicObjectType();
            DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            this.setTableValueSetterField(prefix, entryFields, tableValueSetter, properties);
            this.setTableValueSetterValue(prefix, entryFields, tableValueSetter, properties, entryEntityDynList, orgId4LongNameMap);
            this.batchCreateNewEntryRow(tableValueSetter, entryEntity);
        }
        if (batchOrgEntryEntityDynArr.length > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"noentrydata_flex"});
        }
    }

    private void showMergeAndSplitEntry(DynamicObject[] batchOrgEntryEntityDynArr) {
        Map<Long, List<DynamicObject>> byChangeType = Arrays.stream(batchOrgEntryEntityDynArr).collect(Collectors.groupingBy(entry -> entry.getLong("changetype.id")));
        List<DynamicObject> mergeDynamicObjects = byChangeType.get(OrgBatchChgBillConstants.CHANGE_TYPE_MERGE);
        List<DynamicObject> splitDynamicObjects = byChangeType.get(OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT);
        this.showEntry(mergeDynamicObjects, "entryentity_merge");
        this.showEntry(splitDynamicObjects, "entryentity_split");
    }

    private void showEntry(List<DynamicObject> mergeDynamicObjects, String entryType) {
        if (mergeDynamicObjects != null && mergeDynamicObjects.size() > 0) {
            TableValueSetter tableSetter = this.getTableValueSetter(entryType.substring(entryType.indexOf("_") + 1));
            Map<String, List<DynamicObject>> aftermergeorgid = mergeDynamicObjects.stream().collect(Collectors.groupingBy(dy -> dy.getLong("changetype.id") + "_" + dy.getLong(entryType2PropertyNameOlyKeyCombine.get(entryType))));
            int index = 0;
            for (Map.Entry<String, List<DynamicObject>> entry : aftermergeorgid.entrySet()) {
                List<DynamicObject> value = entry.getValue();
                String key = entry.getKey();
                List<DynamicObject> beforemergeorgid = value.stream().filter(dy -> dy.getLong(entryType2PropertyName.get(entryType)) != 0L).collect(Collectors.toList());
                if (beforemergeorgid.size() <= 0) continue;
                MulBasedataProp basedataProp = (MulBasedataProp)((EntryProp)this.getModel().getDataEntityType().getProperty(entryType)).getDynamicCollectionItemPropertyType().getProperty(entryType2MultiProperty.get(entryType));
                DynamicObjectCollection entireProcessCollection = new DynamicObjectCollection();
                beforemergeorgid.forEach(cooOrgId -> {
                    DynamicObject dy = new DynamicObject(basedataProp.getDynamicCollectionItemPropertyType());
                    dy.set("fbasedataid_id", (Object)cooOrgId.getLong(entryType2PropertyName.get(entryType)));
                    entireProcessCollection.add((Object)dy);
                });
                Long targetOrgId = Long.valueOf(key.substring(key.indexOf("_") + 1));
                List<Object> valueList = Arrays.asList(entireProcessCollection, targetOrgId, ((DynamicObject)beforemergeorgid.get(0)).getLong("changescene.id"), ((DynamicObject)beforemergeorgid.get(0)).getLong("changereason.id"), ((DynamicObject)beforemergeorgid.get(0)).get("changedescription"), targetOrgId);
                List<String> fields = entryType2FiledName.get(entryType);
                for (int idx = 0; idx < fields.size(); ++idx) {
                    tableSetter.set(fields.get(idx), valueList.get(idx), index);
                }
                ++index;
            }
            if (index != 0) {
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow(entryType, tableSetter);
                model.endInit();
                this.getView().updateView(entryType);
            }
        }
    }

    private TableValueSetter getTableValueSetter(String setterType) {
        TableValueSetter tableSetter = new TableValueSetter(new String[0]);
        switch (setterType) {
            case "merge": {
                tableSetter.addField("to_merge_org", new Object[0]);
                tableSetter.addField("merge_target_org", new Object[0]);
                tableSetter.addField("merge_changescene", new Object[0]);
                tableSetter.addField("merge_changereason", new Object[0]);
                tableSetter.addField("merge_changedescription", new Object[0]);
                tableSetter.addField("merge_origin_id", new Object[0]);
                break;
            }
            case "split": {
                tableSetter.addField("to_split_org", new Object[0]);
                tableSetter.addField("split_target_org", new Object[0]);
                tableSetter.addField("split_changescene", new Object[0]);
                tableSetter.addField("split_changereason", new Object[0]);
                tableSetter.addField("split_changedescription", new Object[0]);
                tableSetter.addField("split_origin_id", new Object[0]);
                break;
            }
        }
        return tableSetter;
    }

    private Map<Long, List<DynamicObject>> setTabApVisibleAndReturnChangeSceneColl(DynamicObject[] batchOrgEntryEntityDynArr) {
        if (HRArrayUtils.isEmpty((Object[])batchOrgEntryEntityDynArr)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap_add"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap_parent"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap_info"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap_disable"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap_merge"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap_split"});
            return Maps.newHashMap();
        }
        return this.setVisibleByChangeScene(batchOrgEntryEntityDynArr);
    }

    private void setTableValueSetterField(String prefix, List<String> entryFields, TableValueSetter tableValueSetter, DataEntityPropertyCollection properties) {
        if (HRStringUtils.isEmpty((String)prefix)) {
            return;
        }
        if (!CollectionUtils.isEmpty(entryFields)) {
            entryFields.forEach(entryField -> {
                if ("id".equals(entryField)) {
                    tableValueSetter.addField(entryField, new Object[0]);
                } else {
                    tableValueSetter.addField(this.spliceTwoStringByUnderLine(prefix, (String)entryField), new Object[0]);
                }
            });
        }
        if ("add".equals(prefix)) {
            tableValueSetter.addField(this.spliceTwoStringByUnderLine(prefix, "adminorg"), new Object[0]);
        }
        for (IDataEntityProperty property : properties) {
            if (!PatternUtil.isExProperty(property.getName())) continue;
            tableValueSetter.addField(property.getName(), new Object[0]);
        }
    }

    private void setTableValueSetterValue(String prefix, List<String> entryFields, TableValueSetter tableValueSetter, DataEntityPropertyCollection properties, List<DynamicObject> entryEntityDynList, Map<Long, String> orgId4LongNameMap) {
        if (HRStringUtils.isEmpty((String)prefix)) {
            return;
        }
        for (int i = 0; i < entryEntityDynList.size(); ++i) {
            if (!CollectionUtils.isEmpty(entryFields)) {
                Iterator iterator = entryFields.iterator();
                block11: while (iterator.hasNext()) {
                    String entryField;
                    switch (entryField = (String)iterator.next()) {
                        case "id": {
                            tableValueSetter.set("id", entryEntityDynList.get(i).get("id"), i);
                            continue block11;
                        }
                        case "oriparentorg_name": {
                            if ("parent".equals(prefix)) {
                                Long oriParentOrgId = HRDyObjectPropUtil.getIdLongObject((DynamicObject)entryEntityDynList.get(i).getDynamicObject("oriparentorg"));
                                tableValueSetter.set(this.spliceTwoStringByUnderLine(prefix, entryField), (Object)orgId4LongNameMap.get(oriParentOrgId), i);
                                continue block11;
                            }
                            Long parentOrgId = HRDyObjectPropUtil.getIdLongObject((DynamicObject)entryEntityDynList.get(i).getDynamicObject("parentorg"));
                            tableValueSetter.set(this.spliceTwoStringByUnderLine(prefix, entryField), (Object)orgId4LongNameMap.get(parentOrgId), i);
                            continue block11;
                        }
                        case "parentorg_name": {
                            Long parentOrgId = HRDyObjectPropUtil.getIdLongObject((DynamicObject)entryEntityDynList.get(i).getDynamicObject("parentorg"));
                            tableValueSetter.set(this.spliceTwoStringByUnderLine(prefix, entryField), (Object)orgId4LongNameMap.get(parentOrgId), i);
                            continue block11;
                        }
                    }
                    tableValueSetter.set(this.spliceTwoStringByUnderLine(prefix, entryField), this.getValue(entryEntityDynList.get(i).get(entryField)), i);
                }
            }
            if ("add".equals(prefix)) {
                tableValueSetter.set(this.spliceTwoStringByUnderLine(prefix, "adminorg"), (Object)entryEntityDynList.get(i).getLong("adminorg.id"), i);
            }
            for (IDataEntityProperty property : properties) {
                if (!PatternUtil.isExProperty(property.getName())) continue;
                tableValueSetter.set(property.getName(), this.getValue(entryEntityDynList.get(i).get(property.getName().substring(prefix.length() + 1))), i);
            }
        }
    }

    private Map<Long, String> getOrgBoId4LongNameMap(DynamicObject[] batchOrgEntryEntityDynArr) {
        Set<Long> idSet = this.getId2BoIdForParentOrgMap(batchOrgEntryEntityDynArr);
        Date modifyTime = OrgChgUtil.getView(this.getView()).getModel().getDataEntity().getDate("modifytime");
        return OrgBatchBillHelper.getOrgLongNameByFid(idSet, (Date)modifyTime, null);
    }

    private Set<Long> getId2BoIdForParentOrgMap(DynamicObject[] batchOrgEntryEntityDynList) {
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)(2 * batchOrgEntryEntityDynList.length));
        for (DynamicObject batchOrgEntryEntityDyn : batchOrgEntryEntityDynList) {
            if (Objects.nonNull(batchOrgEntryEntityDyn.getDynamicObject("parentorg"))) {
                idSet.add(batchOrgEntryEntityDyn.getLong("parentorg.id"));
            }
            if (!Objects.nonNull(batchOrgEntryEntityDyn.getDynamicObject("oriparentorg"))) continue;
            idSet.add(batchOrgEntryEntityDyn.getLong("oriparentorg.id"));
        }
        return idSet;
    }

    private String spliceTwoStringByUnderLine(String oneString, String otherString) {
        return oneString + "_" + otherString;
    }

    private Object getValue(Object object) {
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).get("id");
        }
        return object;
    }

    private Map<Long, List<DynamicObject>> setVisibleByChangeScene(DynamicObject[] batchOrgEntryEntityDyns) {
        Map<Long, List<DynamicObject>> changeTypeForBillDynMap = Arrays.stream(batchOrgEntryEntityDyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("changetype.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : changeTypeForBillDynMap.entrySet()) {
            Long changeScene = entry.getKey();
            List<DynamicObject> entryEntityList = entry.getValue();
            boolean visibleFlag = entryEntityList != null && entryEntityList.size() > 0;
            this.getView().setVisible(Boolean.valueOf(visibleFlag), new String[]{this.getTabPageApFlagByChangeScene(changeScene)});
        }
        return changeTypeForBillDynMap;
    }

    private String getTabPageApFlagByChangeScene(long changeScene) {
        if (OrgBatchChgBillConstants.CHANGE_SCENE_ADD.equals(changeScene)) {
            return "tabpageap_add";
        }
        if (OrgBatchChgBillConstants.CHANGE_SCENE_PARENT.equals(changeScene)) {
            return "tabpageap_parent";
        }
        if (OrgBatchChgBillConstants.CHANGE_SCENE_INFO.equals(changeScene)) {
            return "tabpageap_info";
        }
        if (OrgBatchChgBillConstants.CHANGE_SCENE_DISABLE.equals(changeScene)) {
            return "tabpageap_disable";
        }
        if (OrgBatchChgBillConstants.CHANGE_SCENE_MERGE.equals(changeScene)) {
            return "tabpageap_merge";
        }
        return "tabpageap_split";
    }

    private void batchCreateNewEntryRow(TableValueSetter tableValueSetter, String entryEntity) {
        if (CollectionUtils.isEmpty((Collection)tableValueSetter.getFields())) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow(entryEntity, tableValueSetter);
        model.endInit();
        this.getView().updateView(entryEntity);
    }

    private void updateAllTabPageText() {
        Set<String> operateKeySet = Arrays.stream(BillEntryHelperEnum.values()).map(BillEntryHelperEnum::getOperateKey).collect(Collectors.toSet());
        operateKeySet.forEach(opKey -> AdminOrgBatchChgHelper.setTabPageTextAndVisible(opKey, this.getView()));
    }

    private void fixColumn() {
        BillEntryHelperEnum.getAllEntryName().forEach(entry -> {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entry);
            String prefix = entry.split("_")[1];
            entryGrid.setColumnProperty("operationcolumnap_" + prefix, "isFixed", (Object)true);
            entryGrid.setColumnProperty("operationdetail_" + prefix, "isFixed", (Object)true);
            if (HRStringUtils.equals((String)prefix, (String)"add")) {
                entryGrid.setColumnProperty("add_number", "isFixed", (Object)true);
                entryGrid.setColumnProperty("add_name", "isFixed", (Object)true);
            } else {
                entryGrid.setColumnProperty(prefix + "_adminorg", "isFixed", (Object)true);
            }
        });
    }

    private void pageShowDetail() {
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        IFormView parentView = this.getView().getParentView();
        if ("A".equals(billStatus) || parentView != null && parentView.getEntityId().contains("wf_")) {
            ((SplitContainer)this.getView().getControl("splitcontainerap")).hidePanel(SplitDirection.right, true);
        }
    }
}

