/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batchservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.batchservice.AdminOrgBatchBillBaseService;
import kd.hr.homs.business.service.helper.AdminOrgBatchChartBaseHelper;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.AdminOrgMagicHelper;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.business.service.utils.PatternUtil;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;

public class AdminOrgBatchBillClosedCallBackService
extends AdminOrgBatchBillBaseService {
    private String pluginName;

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public AdminOrgBatchBillClosedCallBackService(IFormView view) {
        super(view);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "add_org": {
                Object returnData;
                if (this.onlyForView(closedCallBackEvent)) {
                    return;
                }
                this.updateAddEntryEntity();
                this.setFieldEnable("add");
                AdminOrgBatchChgHelper.setTabPageTextAndVisible("add", this.getView());
                AdminOrgBatchChgHelper.activeHasDataEntryAfterDelete("add", this.getView());
                if (HRStringUtils.equals((String)"0", (String)this.getView().getPageCache().get("isList")) && (returnData = closedCallBackEvent.getReturnData()) != null) {
                    String addOrgParentChange = this.getView().getPageCache().get("addOrgParentChange");
                    if (HRStringUtils.equals((String)addOrgParentChange, (String)"true")) {
                        AdminOrgMagicHelper.refreshOrgCubeView(this.getView(), "init", "init");
                    } else if (returnData instanceof Map) {
                        Map map = (Map)returnData;
                        String id = (String)map.get("id");
                        AdminOrgMagicHelper.refreshPartOfView(this.getView(), Collections.singletonList(Long.valueOf(id)), actionId, "update");
                    }
                }
                if (this.getView().getPageCache().get("lastTimeAddEntryId") == null) break;
                this.getView().invokeOperation("add");
                break;
            }
            case "infochg": {
                if (null == closedCallBackEvent.getReturnData()) break;
                this.infoChgF7Return(closedCallBackEvent);
                break;
            }
            case "disable": {
                if (null == closedCallBackEvent.getReturnData()) break;
                this.disableF7Return(closedCallBackEvent);
                break;
            }
            case "parent": {
                if (null == closedCallBackEvent.getReturnData()) break;
                this.entryEntityF7Return(closedCallBackEvent);
                break;
            }
            case "entryentity_parent": {
                this.saveReturn(closedCallBackEvent.getReturnData(), "entryentity_parent");
                if (!HRStringUtils.equals((String)"0", (String)this.getView().getPageCache().get("isList"))) break;
                AdminOrgMagicHelper.refreshOrgCubeView(this.getView(), "parent_chg", "update");
                break;
            }
            case "entryentity_info": {
                this.saveReturn(closedCallBackEvent.getReturnData(), "entryentity_info");
                break;
            }
            case "add_orgDisable": {
                this.addOrgDisableEntity(closedCallBackEvent);
                break;
            }
            case "add_orgParent": {
                this.updateOrgParentEntity(closedCallBackEvent);
                break;
            }
            case "add_orgInfo": {
                if (this.onlyForView(closedCallBackEvent)) {
                    return;
                }
                this.addOrgInfoEntity(closedCallBackEvent);
                break;
            }
            case "org_merge": {
                AdminOrgBatchChartBaseHelper.deleteAllUnSaveEntity(this.getView().getModel().getDataEntity().getLong("id"));
                this.addOrgMergeEntry(closedCallBackEvent);
                break;
            }
            case "edit_merge_detail": {
                AdminOrgBatchChartBaseHelper.deleteAllUnSaveEntity(this.getView().getModel().getDataEntity().getLong("id"));
                this.updateOrgMerEntry(closedCallBackEvent);
                break;
            }
            case "org_split": {
                AdminOrgBatchChartBaseHelper.deleteAllUnSaveEntity(this.getView().getModel().getDataEntity().getLong("id"));
                this.addOrgSplitEntry(closedCallBackEvent.getReturnData());
                break;
            }
            case "edit_split_detail": {
                AdminOrgBatchChartBaseHelper.deleteAllUnSaveEntity(this.getView().getModel().getDataEntity().getLong("id"));
                this.updateOrgSplitEntry(closedCallBackEvent.getReturnData());
            }
        }
    }

    private boolean onlyForView(ClosedCallBackEvent closedCallBackEvent) {
        return closedCallBackEvent.getReturnData() == null;
    }

    private void addOrgSplitEntry(Object returnData) {
        if (returnData == null) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("to_split_org", new Object[0]);
        vs.addField("split_target_org", new Object[0]);
        vs.addField("split_changescene", new Object[0]);
        vs.addField("split_changereason", new Object[0]);
        vs.addField("split_changedescription", new Object[0]);
        vs.addField("split_origin_id", new Object[0]);
        Map map = (Map)returnData;
        vs.addRow(new Object[]{map.get("split_origin_id"), this.getToMergeOrgRowValue("split_target_org", (List)map.get("split_target_org")), HRDyObjectPropUtil.getId((DynamicObject)((DynamicObject)map.get("changescene"))), HRDyObjectPropUtil.getId((DynamicObject)((DynamicObject)map.get("changereason"))), map.get("changedescription"), map.get("split_origin_id")});
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity_split", vs);
        model.endInit();
        this.afterConfirmMergeSplit(map, "split", "org_split");
    }

    private void updateOrgSplitEntry(Object returnData) {
        if (returnData == null) {
            return;
        }
        Map map = (Map)returnData;
        DynamicObjectCollection split = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_split");
        Optional<DynamicObject> editEntryOptional = split.stream().filter(entry -> entry.getLong("split_origin_id") == ((Long)map.get("split_origin_id")).longValue()).findFirst();
        if (editEntryOptional.isPresent()) {
            DynamicObject editEntry = editEntryOptional.get();
            DynamicObject toSplitOrg = (DynamicObject)map.get("to_split_org");
            editEntry.set("to_split_org", (Object)toSplitOrg);
            editEntry.set("split_target_org", (Object)this.getToMergeOrgRowValue("split_target_org", (List)map.get("split_target_org")));
            editEntry.set("split_changescene", map.get("changescene"));
            editEntry.set("split_changereason", map.get("changereason"));
            editEntry.set("split_changedescription", map.get("changedescription"));
            editEntry.set("split_origin_id", toSplitOrg.get("id"));
            this.afterConfirmMergeSplit(map, "split", "org_split");
        }
    }

    private void updateOrgMerEntry(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        Map map = (Map)returnData;
        DynamicObjectCollection merge = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_merge");
        Optional<DynamicObject> editEntryOptional = merge.stream().filter(entry -> HRStringUtils.equals((String)entry.getString("merge_origin_id"), (String)String.valueOf(map.get("originTargetOrg")))).findFirst();
        if (editEntryOptional.isPresent()) {
            DynamicObject editEntry = editEntryOptional.get();
            List toBeMergeOrgIdList = (List)map.get("tobemergeorg");
            DynamicObjectCollection collection = this.getToMergeOrgRowValue("to_merge_org", toBeMergeOrgIdList);
            editEntry.set("to_merge_org", (Object)collection);
            editEntry.set("merge_target_org", map.get("targetorg"));
            editEntry.set("merge_changescene", map.get("changescene"));
            editEntry.set("merge_changereason", map.get("changereason"));
            editEntry.set("merge_changedescription", map.get("changedescription"));
            editEntry.set("merge_origin_id", (Object)HRDyObjectPropUtil.getId((DynamicObject)((DynamicObject)map.get("targetorg"))));
            this.afterConfirmMergeSplit(map, "merge", "org_merge");
        }
    }

    private void addOrgMergeEntry(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("to_merge_org", new Object[0]);
        vs.addField("merge_target_org", new Object[0]);
        vs.addField("merge_changescene", new Object[0]);
        vs.addField("merge_changereason", new Object[0]);
        vs.addField("merge_changedescription", new Object[0]);
        vs.addField("merge_origin_id", new Object[0]);
        Map map = (Map)returnData;
        List toBeMergeOrgIdList = (List)map.get("tobemergeorg");
        DynamicObjectCollection collection = this.getToMergeOrgRowValue("to_merge_org", toBeMergeOrgIdList);
        long targetOrgId = HRDyObjectPropUtil.getId((DynamicObject)((DynamicObject)map.get("targetorg")));
        vs.addRow(new Object[]{collection, targetOrgId, HRDyObjectPropUtil.getId((DynamicObject)((DynamicObject)map.get("changescene"))), HRDyObjectPropUtil.getId((DynamicObject)((DynamicObject)map.get("changereason"))), map.get("changedescription"), targetOrgId});
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity_merge", vs);
        model.endInit();
        this.afterConfirmMergeSplit(map, "merge", "org_merge");
    }

    private void afterConfirmMergeSplit(Map<String, Object> map, String entryName, String eventName) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        AdminOrgBatchChartBaseHelper.delAndAddEntry(this.getView(), (HashSet)map.get("toSaveOrgIdSet"), (HashSet)map.get("deleteOrgIdSet"));
        model.endInit();
        this.getView().updateView("entryentity_" + entryName);
        this.getView().updateView("entryentity_add");
        this.getView().updateView("entryentity_parent");
        this.getView().updateView("entryentity_info");
        this.getView().updateView("entryentity_disable");
        AdminOrgBatchChgHelper.setTabPageTextAndVisible(entryName, this.getView());
        AdminOrgBatchChgHelper.setTabPageTextAndVisible("add", this.getView());
        AdminOrgBatchChgHelper.setTabPageTextAndVisible("parent", this.getView());
        AdminOrgBatchChgHelper.setTabPageTextAndVisible("info", this.getView());
        AdminOrgBatchChgHelper.setTabPageTextAndVisible("disable", this.getView());
        AdminOrgBatchChgHelper.activeTabByPrefix(entryName, this.getView());
        if (HRStringUtils.equals((String)"0", (String)this.getView().getPageCache().get("isList"))) {
            AdminOrgMagicHelper.refreshOrgCubeView(this.getView(), eventName, "init");
        }
    }

    private DynamicObjectCollection getToMergeOrgRowValue(String name, List<Long> toBeMergeOrgIdList) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgf7");
        DynamicObject[] query = helper.loadDynamicObjectArray(new QFilter("id", "in", toBeMergeOrgIdList).toArray());
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        MulBasedataProp property = (MulBasedataProp)dataEntityType.findProperty(name);
        DynamicObjectType type = property.getDynamicCollectionItemPropertyType();
        for (DynamicObject org : query) {
            DynamicObject object = new DynamicObject(type);
            object.set("fbasedataid", (Object)org);
            collection.add((Object)object);
        }
        return collection;
    }

    private void updateAddEntryEntity() {
        DataEntityPropertyCollection entryEntityInfo = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_add").getDynamicObjectType().getProperties();
        ArrayList<String> propList = new ArrayList<String>();
        StringBuilder selectSqlBuilder = new StringBuilder("id,number,name,simplename,adminorgtype,parentorg,establishmentdate,corporateorg,changescene,changereason,changedescription,adminorglayer,adminorgfunction,companyarea,city,workplace,adminorg,org,safelevel,safetype");
        for (IDataEntityProperty iDataEntityProperty : entryEntityInfo) {
            if (!PatternUtil.isExProperty(iDataEntityProperty.getName())) continue;
            String selectName = iDataEntityProperty.getName().substring(4);
            propList.add(selectName);
            selectSqlBuilder.append(",").append(selectName);
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_batchorgentityadd");
        Long billId = this.getModel().getDataEntity().getLong("id");
        QFilter qFilter = new QFilter("billid", "=", (Object)billId).and(new QFilter("changetype", "=", (Object)OrgBatchChgBillConstants.CHANGE_TYPE_ADD));
        DynamicObject[] addOrgDyArr = hrBaseServiceHelper.query(selectSqlBuilder.toString(), qFilter.toArray(), "sequence asc");
        HashSet<Long> parentIds = new HashSet<Long>();
        for (int i = 0; i < addOrgDyArr.length; ++i) {
            if (addOrgDyArr[i].getDynamicObject("parentorg") == null) continue;
            parentIds.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDyArr[i].getDynamicObject("parentorg")));
        }
        Date modifyTime = OrgChgUtil.getView(this.getView()).getModel().getDataEntity().getDate("modifytime");
        Map longNameMap = OrgBatchBillHelper.getOrgLongNameByFid(parentIds, (Date)modifyTime, null);
        this.getModel().deleteEntryData("entryentity_add");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]);
        vs.addField("add_number", new Object[0]);
        vs.addField("add_name", new Object[0]);
        vs.addField("add_simplename", new Object[0]);
        vs.addField("add_adminorgtype", new Object[0]);
        vs.addField("add_parentorg", new Object[0]);
        vs.addField("add_parentorg_name", new Object[0]);
        vs.addField("add_establishmentdate", new Object[0]);
        vs.addField("add_corporateorg", new Object[0]);
        vs.addField("add_changescene", new Object[0]);
        vs.addField("add_changereason", new Object[0]);
        vs.addField("add_changedescription", new Object[0]);
        vs.addField("add_adminorglayer", new Object[0]);
        vs.addField("add_adminorgfunction", new Object[0]);
        vs.addField("add_companyarea", new Object[0]);
        vs.addField("add_city", new Object[0]);
        vs.addField("add_workplace", new Object[0]);
        vs.addField("add_adminorg", new Object[0]);
        vs.addField("add_org", new Object[0]);
        vs.addField("add_safelevel", new Object[0]);
        vs.addField("add_safetype", new Object[0]);
        for (IDataEntityProperty iDataEntityProperty : entryEntityInfo) {
            if (!PatternUtil.isExProperty(iDataEntityProperty.getName())) continue;
            vs.addField(iDataEntityProperty.getName(), new Object[0]);
        }
        for (DynamicObject addOrgDy : addOrgDyArr) {
            ArrayList values = Lists.newArrayListWithCapacity((int)16);
            values.add(addOrgDy.getLong("id"));
            values.add(addOrgDy.getString("number"));
            values.add(addOrgDy.get("name"));
            values.add(addOrgDy.getString("simplename"));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("adminorgtype")));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("parentorg")));
            values.add(longNameMap.get(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("parentorg"))));
            values.add(addOrgDy.getDate("establishmentdate"));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("corporateorg")));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("changescene")));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("changereason")));
            values.add(addOrgDy.get("changedescription"));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("adminorglayer")));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("adminorgfunction")));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("companyarea")));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("city")));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("workplace")));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("adminorg")));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("org")));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("safelevel")));
            values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("safetype")));
            for (String prop : propList) {
                if (addOrgDy.get(prop) instanceof DynamicObject) {
                    values.add(((DynamicObject)addOrgDy.get(prop)).getLong("id"));
                    continue;
                }
                values.add(addOrgDy.get(prop));
            }
            vs.addRow(values.toArray());
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity_add", vs);
        model.endInit();
        this.getView().updateView("entryentity_add");
    }

    private void setFieldEnable(String prefix) {
        String entryName = BillEntryHelperEnum.getEntryNameByPrefix(prefix);
        DynamicObjectCollection entryEntityColl = this.getModel().getEntryEntity(entryName);
        for (int i = 0; i < entryEntityColl.size(); ++i) {
            String changeSceneFieldName = prefix + "_changescene";
            Object changeScene = ((DynamicObject)entryEntityColl.get(i)).get(changeSceneFieldName);
            if (!Objects.isNull(changeScene)) continue;
            String changeReasonFieldName = prefix + "_changereason";
            this.getView().setEnable(Boolean.FALSE, i, new String[]{changeReasonFieldName});
        }
    }

    private String spliceTwoStringByUnderLine(String oneString, String otherString) {
        return oneString + "_" + otherString;
    }

    private void infoChgF7Return(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectRowColl = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (selectRowColl != null && selectRowColl.size() > 0) {
            List list = selectRowColl.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgf7");
            QFilter filter = new QFilter("id", "in", list);
            DynamicObject[] orgArr = helper.loadDynamicObjectArray(filter.toArray());
            DataEntityPropertyCollection entryEntityInfo = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_info").getDynamicObjectType().getProperties();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("id", new Object[0]);
            vs.addField("info_adminorg", new Object[0]);
            vs.addField("info_number", new Object[0]);
            vs.addField("info_name", new Object[0]);
            vs.addField("info_parentorg", new Object[0]);
            vs.addField("info_oriparentorg_name", new Object[0]);
            vs.addField("info_simplename", new Object[0]);
            vs.addField("info_adminorgtype", new Object[0]);
            vs.addField("info_establishmentdate", new Object[0]);
            vs.addField("info_corporateorg", new Object[0]);
            vs.addField("info_tobedisableflag", new Object[0]);
            vs.addField("info_changescene", new Object[0]);
            vs.addField("info_changereason", new Object[0]);
            vs.addField("info_changedescription", new Object[0]);
            vs.addField("info_adminorglayer", new Object[0]);
            vs.addField("info_adminorgfunction", new Object[0]);
            vs.addField("info_companyarea", new Object[0]);
            vs.addField("info_city", new Object[0]);
            vs.addField("info_workplace", new Object[0]);
            vs.addField("info_org", new Object[0]);
            vs.addField("info_safelevel", new Object[0]);
            vs.addField("info_safetype", new Object[0]);
            ArrayList<String> propList = new ArrayList<String>();
            for (IDataEntityProperty iDataEntityProperty : entryEntityInfo) {
                if (!PatternUtil.isExProperty(iDataEntityProperty.getName())) continue;
                vs.addField(iDataEntityProperty.getName(), new Object[0]);
                propList.add(iDataEntityProperty.getName().substring(5));
            }
            Date modifyTime = OrgChgUtil.getView(this.getView()).getModel().getDataEntity().getDate("modifytime");
            Set parentOrgIdSet = Arrays.stream(orgArr).map(org -> org.getLong("parentorg.id")).collect(Collectors.toSet());
            Map id2LongNameMap = OrgBatchBillHelper.getOrgLongNameByFid(parentOrgIdSet, (Date)modifyTime, null);
            Long billOrgId = HRDyObjectPropUtil.getIdLongObject((DynamicObject)this.getModel().getDataEntity().getDynamicObject("org"));
            Long changeScene = AdminOrgBatchChgHelper.getChangeScene("info");
            long[] entryIds = ORM.create().genLongIds("homs_batchorgentity", orgArr.length);
            for (int i = 0; i < orgArr.length; ++i) {
                DynamicObject org2 = orgArr[i];
                long entryId = entryIds[i];
                ArrayList values = Lists.newArrayListWithCapacity((int)16);
                values.add(entryId);
                values.add(org2.getLong("id"));
                values.add(org2.getString("number"));
                values.add(org2.getLocaleString("name"));
                values.add(org2.getDynamicObject("parentorg") != null ? AdminOrgBatchChgHelper.getHisId(org2.getLong("parentorg.id")) : null);
                values.add(org2.getDynamicObject("parentorg") != null ? (Object)id2LongNameMap.get(org2.getLong("parentorg.id")) : null);
                values.add(org2.getLocaleString("simplename"));
                values.add(org2.getDynamicObject("adminorgtype") != null ? Long.valueOf(org2.getLong("adminorgtype.id")) : null);
                values.add(org2.getDate("establishmentdate"));
                values.add(org2.getDynamicObject("corporateorg") != null ? Long.valueOf(org2.getLong("corporateorg.id")) : null);
                values.add(org2.getString("tobedisableflag"));
                values.add(changeScene);
                values.add(null);
                values.add(null);
                values.add(org2.getDynamicObject("adminorglayer") != null ? Long.valueOf(org2.getLong("adminorglayer.id")) : null);
                values.add(org2.getDynamicObject("adminorgfunction") != null ? Long.valueOf(org2.getLong("adminorgfunction.id")) : null);
                values.add(org2.getDynamicObject("companyarea") != null ? Long.valueOf(org2.getLong("companyarea.id")) : null);
                values.add(org2.getDynamicObject("city") != null ? Long.valueOf(org2.getLong("city.id")) : null);
                values.add(org2.getDynamicObject("workplace") != null ? Long.valueOf(org2.getLong("workplace.id")) : null);
                values.add(billOrgId);
                values.add(org2.getDynamicObject("safelevel") != null ? Long.valueOf(org2.getLong("safelevel.id")) : null);
                values.add(org2.getDynamicObject("safetype") != null ? Long.valueOf(org2.getLong("safetype.id")) : null);
                for (String prop : propList) {
                    if (org2.get(prop) instanceof DynamicObject) {
                        values.add(((DynamicObject)org2.get(prop)).getLong("id"));
                        continue;
                    }
                    values.add(org2.get(prop));
                }
                vs.addRow(values.toArray());
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity_info", vs);
            model.endInit();
            this.getView().updateView("entryentity_info");
            this.setFieldEnable("info");
            AdminOrgBatchChgHelper.setTabPageTextAndVisible("info", this.getView());
            AdminOrgBatchChgHelper.activeTabByPrefix("info", this.getView());
        }
    }

    private void disableF7Return(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectRowColl = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (selectRowColl != null && selectRowColl.size() > 0) {
            List list = selectRowColl.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
            QFilter filter = new QFilter("id", "in", list);
            DynamicObject[] orgArr = helper.query("id,parentorg,adminorgtype,tobedisableflag", filter.toArray());
            Set parentOrgIdSet = Arrays.stream(orgArr).map(org -> org.getLong("parentorg.id")).collect(Collectors.toSet());
            Date modifyTime = OrgChgUtil.getView(this.getView()).getModel().getDataEntity().getDate("modifytime");
            Map id2LongNameMap = OrgBatchBillHelper.getOrgLongNameByFid(parentOrgIdSet, (Date)modifyTime, null);
            Long changeScene = AdminOrgBatchChgHelper.getChangeScene("disable");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("id", new Object[0]);
            vs.addField("disable_adminorg", new Object[0]);
            vs.addField("disable_parentorg", new Object[0]);
            vs.addField("disable_oriparentorg_name", new Object[0]);
            vs.addField("disable_adminorgtype", new Object[0]);
            vs.addField("disable_tobedisableflag", new Object[0]);
            vs.addField("disable_changescene", new Object[0]);
            vs.addField("disable_changereason", new Object[0]);
            vs.addField("disable_changedescription", new Object[0]);
            vs.addField("disable_org", new Object[0]);
            Long billOrgId = HRDyObjectPropUtil.getIdLongObject((DynamicObject)this.getModel().getDataEntity().getDynamicObject("org"));
            long[] entryIds = ORM.create().genLongIds("homs_batchorgentity", orgArr.length);
            HashSet<Long> orgIdSet = new HashSet<Long>(orgArr.length);
            for (int i = 0; i < orgArr.length; ++i) {
                DynamicObject org2 = orgArr[i];
                orgIdSet.add(org2.getLong("id"));
                long entryId = entryIds[i];
                vs.addRow(new Object[]{entryId, org2.get("id"), org2.getDynamicObject("parentorg") != null ? AdminOrgBatchChgHelper.getHisId(org2.getLong("parentorg.id")) : null, org2.getDynamicObject("parentorg") != null ? id2LongNameMap.get(org2.getLong("parentorg.id")) : null, org2.getDynamicObject("adminorgtype") != null ? Long.valueOf(org2.getLong("adminorgtype.id")) : null, org2.getString("tobedisableflag"), changeScene, null, null, billOrgId});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity_disable", vs);
            model.endInit();
            this.getView().updateView("entryentity_disable");
            this.setFieldEnable("disable");
            AdminOrgBatchChartBaseHelper.removeSplitTargetOrg(this.getView(), orgIdSet);
            AdminOrgBatchChgHelper.setTabPageTextAndVisible("disable", this.getView());
            AdminOrgBatchChgHelper.activeTabByPrefix("disable", this.getView());
        }
    }

    private void entryEntityF7Return(ClosedCallBackEvent event) {
        ListSelectedRowCollection selectRowColl = (ListSelectedRowCollection)event.getReturnData();
        List list = selectRowColl.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgf7");
        QFilter filter = new QFilter("id", "in", list);
        DynamicObject[] orgArr = helper.loadDynamicObjectArray(filter.toArray());
        DataEntityPropertyCollection entryEntityParent = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_parent").getDynamicObjectType().getProperties();
        String prefix = "parent";
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]);
        Stream<String> fields = Stream.of("adminorg", "number", "name", "oriparentorg", "oriparentorg_name", "parentorg", "parentorg_name", "simplename", "adminorgtype", "establishmentdate", "corporateorg", "tobedisableflag", "changescene", "changereason", "changedescription", "adminorglayer", "adminorgfunction", "companyarea", "city", "workplace", "org", "safelevel", "safetype");
        fields.forEach(s -> vs.addField(prefix + "_" + s, new Object[0]));
        ArrayList<String> propList = new ArrayList<String>();
        for (IDataEntityProperty iDataEntityProperty : entryEntityParent) {
            if (!PatternUtil.isExProperty(iDataEntityProperty.getName())) continue;
            vs.addField(iDataEntityProperty.getName(), new Object[0]);
            propList.add(iDataEntityProperty.getName().substring(7));
        }
        Long changeScene = AdminOrgBatchChgHelper.getChangeScene("parent");
        Long billOrgId = HRDyObjectPropUtil.getIdLongObject((DynamicObject)this.getModel().getDataEntity().getDynamicObject("org"));
        long[] entryIds = ORM.create().genLongIds("homs_batchorgentity", orgArr.length);
        for (int i = 0; i < orgArr.length; ++i) {
            DynamicObject org = orgArr[i];
            long entryId = entryIds[i];
            Date modifyTime = OrgChgUtil.getView(this.getView()).getModel().getDataEntity().getDate("modifytime");
            ArrayList<Object> values = new ArrayList<Object>(16);
            values.add(entryId);
            values.add(org.get("id"));
            values.add(org.getString("number"));
            values.add(org.getLocaleString("name"));
            values.add(this.getDynamicObjectId(org, "parentorg"));
            values.add(OrgBatchBillHelper.getOrgLongName((Long)org.getLong("parentorg.boid"), (Date)modifyTime, null));
            values.add(null);
            values.add(null);
            values.add(org.getLocaleString("simplename"));
            values.add(this.getDynamicObjectId(org, "adminorgtype"));
            values.add(org.getDate("establishmentdate"));
            values.add(this.getDynamicObjectId(org, "corporateorg"));
            values.add(org.getString("tobedisableflag"));
            values.add(changeScene);
            values.add(null);
            values.add(null);
            values.add(org.getDynamicObject("adminorglayer") != null ? Long.valueOf(org.getLong("adminorglayer.id")) : null);
            values.add(this.getDynamicObjectId(org, "adminorgfunction"));
            values.add(this.getDynamicObjectId(org, "companyarea"));
            values.add(this.getDynamicObjectId(org, "city"));
            values.add(this.getDynamicObjectId(org, "workplace"));
            values.add(billOrgId);
            values.add(this.getDynamicObjectId(org, "safelevel"));
            values.add(this.getDynamicObjectId(org, "safetype"));
            for (String prop : propList) {
                if (org.get(prop) instanceof DynamicObject) {
                    values.add(((DynamicObject)org.get(prop)).getLong("id"));
                    continue;
                }
                values.add(org.get(prop));
            }
            vs.addRow(values.toArray());
        }
        this.batchCreateNewEntryRow(vs, "parent");
        this.setFieldEnable("parent");
        AdminOrgBatchChgHelper.setTabPageTextAndVisible("parent", this.getView());
        AdminOrgBatchChgHelper.activeTabByPrefix("parent", this.getView());
    }

    private Long getDynamicObjectId(DynamicObject org, String key) {
        return org.getDynamicObject(key) != null ? Long.valueOf(org.getLong(key + ".id")) : null;
    }

    private void batchCreateNewEntryRow(TableValueSetter tableValueSetter, String prefix) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow(this.spliceTwoStringByUnderLine("entryentity", prefix), tableValueSetter);
        model.endInit();
        this.getView().updateView(this.spliceTwoStringByUnderLine("entryentity", prefix));
    }

    private void saveReturn(Object data, String entryEntityInfo) {
        if (data instanceof Map) {
            Map map = (Map)data;
            DynamicObjectCollection info = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryEntityInfo);
            DataEntityPropertyCollection properties = info.getDynamicObjectType().getProperties();
            Optional<DynamicObject> changeEntry = info.stream().filter(entry -> entry.getLong("id") == ((Long)map.get("id")).longValue()).findFirst();
            if (changeEntry.isPresent()) {
                DynamicObject dynamicObject = changeEntry.get();
                DataEntityPropertyCollection propers = dynamicObject.getDataEntityType().getProperties();
                map.keySet().forEach(item -> {
                    if (propers.containsKey(item)) {
                        dynamicObject.set(item, map.get(item));
                    }
                });
                this.getView().updateView(entryEntityInfo);
            } else {
                TableValueSetter vs = new TableValueSetter(new String[0]);
                List<String> infoEntryFieldsList = BillEntryHelperEnum.getEntryListByChangeType(OrgBatchChgBillConstants.CHANGE_SCENE_INFO);
                infoEntryFieldsList.forEach(field -> {
                    if ("id".equals(field)) {
                        vs.addField(field, new Object[0]);
                    } else {
                        vs.addField(this.spliceTwoStringByUnderLine("info", (String)field), new Object[0]);
                    }
                });
                ArrayList<String> propList = new ArrayList<String>();
                for (Object property : properties) {
                    if (!PatternUtil.isExProperty(property.getName())) continue;
                    vs.addField(property.getName(), new Object[0]);
                    propList.add(property.getName());
                }
                ArrayList values = Lists.newArrayListWithCapacity((int)16);
                values.add(map.get("id"));
                values.add(this.getLongId(map.get("info_adminorg")));
                values.add(map.get("info_number"));
                values.add(map.get("info_name"));
                values.add(AdminOrgBatchChgHelper.getHisId((Long)this.getLongId(map.get("info_parentorg"))));
                values.add(map.get("info_oriparentorg_name"));
                values.add(map.get("info_simplename"));
                values.add(this.getLongId(map.get("info_adminorgtype")));
                values.add(map.get("info_establishmentdate"));
                values.add(this.getLongId(map.get("info_corporateorg")));
                values.add(map.get("info_tobedisableflag"));
                values.add(this.getLongId(map.get("info_changescene")));
                values.add(this.getLongId(map.get("info_changereason")));
                values.add(map.get("info_changedescription"));
                values.add(this.getLongId(map.get("info_adminorglayer")));
                values.add(this.getLongId(map.get("info_adminorgfunction")));
                values.add(this.getLongId(map.get("info_companyarea")));
                values.add(this.getLongId(map.get("info_city")));
                values.add(this.getLongId(map.get("info_workplace")));
                values.add(this.getLongId(map.get("info_org")));
                values.add(this.getLongId(map.get("info_safelevel")));
                values.add(this.getLongId(map.get("info_safetype")));
                for (String prop : propList) {
                    Object obj = map.get(prop);
                    if (obj instanceof DynamicObject) {
                        values.add(this.getLongId(obj));
                        continue;
                    }
                    values.add(obj);
                }
                vs.addRow(values.toArray());
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow("entryentity_info", vs);
                model.endInit();
                this.getView().updateView("entryentity_info");
            }
        }
    }

    private Object getLongId(Object mapValue) {
        if (Objects.isNull(mapValue)) {
            return null;
        }
        if (mapValue instanceof DynamicObject) {
            return ((DynamicObject)mapValue).getLong("id");
        }
        return mapValue;
    }

    private void addOrgDisableEntity(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            DynamicObjectCollection disable = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_disable");
            Map<Long, DynamicObject> disableOrgEntryMap = disable.stream().collect(Collectors.toMap(obj -> obj.getLong("disable_adminorg.id"), obj -> obj));
            Set<Long> disableOrgIdSet = disableOrgEntryMap.keySet();
            Map<Boolean, List<DynamicObject>> disableEntryMap = dynamicObjects.stream().collect(Collectors.groupingBy(entry -> disableOrgIdSet.contains(entry.getLong("adminorg.id"))));
            this.updateOrgDisableEntry(disableOrgEntryMap, disableEntryMap);
            AdminOrgBatchChartBaseHelper.removeSplitTargetOrg(this.getView(), dynamicObjects.stream().map(org -> org.getLong("adminorg.id")).collect(Collectors.toSet()));
            this.addOrgDisableEntry(disableEntryMap);
            this.getView().updateView("entryentity_disable");
            AdminOrgBatchChgHelper.setTabPageTextAndVisible("disable", this.getView());
            List<Long> disableEntryIdList = dynamicObjects.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
            AdminOrgMagicHelper.refreshPartOfView(this.getView(), disableEntryIdList, "disable_org", "update");
        }
    }

    private void updateOrgDisableEntry(Map<Long, DynamicObject> disableOrgEntryMap, Map<Boolean, List<DynamicObject>> disableEntryMap) {
        List<DynamicObject> updateDisableEntry = disableEntryMap.get(Boolean.TRUE);
        if (!CollectionUtils.isEmpty(updateDisableEntry)) {
            updateDisableEntry.forEach(entry -> {
                long disableAdminOrgId = entry.getLong("adminorg.id");
                DynamicObject object = (DynamicObject)disableOrgEntryMap.get(disableAdminOrgId);
                object.set("disable_changescene", (Object)entry.getDynamicObject("changescene"));
                object.set("disable_changereason", (Object)entry.getDynamicObject("changereason"));
                object.set("disable_changedescription", entry.get("changedescription"));
                object.set("disable_org", (Object)entry.getDynamicObject("org"));
            });
        }
    }

    private void addOrgDisableEntry(Map<Boolean, List<DynamicObject>> disableEntryMap) {
        List<DynamicObject> addDisableEntry = disableEntryMap.get(Boolean.FALSE);
        if (!CollectionUtils.isEmpty(addDisableEntry)) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("id", new Object[0]);
            vs.addField("disable_adminorg", new Object[0]);
            vs.addField("disable_parentorg", new Object[0]);
            vs.addField("disable_oriparentorg_name", new Object[0]);
            vs.addField("disable_adminorgtype", new Object[0]);
            vs.addField("disable_tobedisableflag", new Object[0]);
            vs.addField("disable_changescene", new Object[0]);
            vs.addField("disable_changereason", new Object[0]);
            vs.addField("disable_changedescription", new Object[0]);
            vs.addField("disable_org", new Object[0]);
            HashSet<Long> parentIds = new HashSet<Long>();
            for (int i = 0; i < addDisableEntry.size(); ++i) {
                if (addDisableEntry.get(i).getDynamicObject("parentorg") == null) continue;
                parentIds.add(addDisableEntry.get(i).getDynamicObject("parentorg").getLong("id"));
            }
            Date modifyTime = OrgChgUtil.getView(this.getView()).getModel().getDataEntity().getDate("modifytime");
            Map longNameMap = OrgBatchBillHelper.getOrgLongNameByFid(parentIds, (Date)modifyTime, null);
            for (DynamicObject org : addDisableEntry) {
                vs.addRow(new Object[]{org.getLong("id"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("adminorg")), org.getDynamicObject("parentorg") != null ? AdminOrgBatchChgHelper.getHisId(org.getLong("parentorg.id")) : null, longNameMap.get(HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("parentorg"))), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("adminorgtype")), org.getString("tobedisableflag"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("changescene")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("changereason")), org.get("changedescription"), this.getModel().getDataEntity().getLong("org.id")});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity_disable", vs);
            model.endInit();
        }
    }

    private void updateOrgParentEntity(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            this.checkParentOrgChange(dynamicObjects);
            this.deleteHisEntryEntity(dynamicObjects);
            this.updateChartParentToParentEntry(dynamicObjects);
            this.updateChartParentToInfoEntry(dynamicObjects);
            AdminOrgBatchChgHelper.setTabPageTextAndVisible("info", this.getView());
            AdminOrgBatchChgHelper.setTabPageTextAndVisible("parent", this.getView());
            AdminOrgBatchChgHelper.setTabPageTextAndVisible("add", this.getView());
            AdminOrgBatchChgHelper.activeHasDataEntryAfterDelete("add", this.getView());
            this.updateAddEntryEntity();
            AdminOrgMagicHelper.refreshOrgCubeView(this.getView(), "parent_chg", "update");
        }
    }

    private void checkParentOrgChange(DynamicObjectCollection dynamicObjects) {
        dynamicObjects.forEach(dyn -> {
            long beforeParentOrgId;
            long parentOrgId = dyn.getLong("parentorg.boid");
            if (parentOrgId == (beforeParentOrgId = dyn.getLong("adminorg.parentorg.id"))) {
                dyn.set("changetype.id", (Object)OrgBatchChgBillConstants.CHANGE_TYPE_INFO);
            }
        });
    }

    private void updateChartParentToParentEntry(DynamicObjectCollection dynamicObjects) {
        String prefix = "parent";
        TableValueSetter vs = this.getTableVsByPrefix(prefix);
        Map<Long, DynamicObject> parentEntryInfoMap = AdminOrgBatchChgHelper.getEntryInfoMap(this.getView(), prefix);
        Date modifyTime = OrgChgUtil.getView(this.getView()).getModel().getDataEntity().getDate("modifytime");
        for (DynamicObject org : dynamicObjects) {
            if (org.getLong("changetype.id") != OrgBatchChgBillConstants.CHANGE_TYPE_PARENT.longValue()) continue;
            if (parentEntryInfoMap.containsKey(org.getLong("id"))) {
                DynamicObject entryEntityDyn = parentEntryInfoMap.get(org.getLong("id"));
                entryEntityDyn.set(prefix + "_number", (Object)org.getString("number"));
                entryEntityDyn.set(prefix + "_name", (Object)org.getString("name"));
                entryEntityDyn.set(prefix + "_simplename", (Object)org.getLocaleString("simplename"));
                entryEntityDyn.set(prefix + "_establishmentdate", (Object)org.getDate("establishmentdate"));
                entryEntityDyn.set(prefix + "_corporateorg", (Object)org.getDynamicObject("corporateorg"));
                entryEntityDyn.set(prefix + "_adminorglayer", (Object)org.getDynamicObject("adminorglayer"));
                entryEntityDyn.set(prefix + "_adminorgfunction", (Object)org.getDynamicObject("adminorgfunction"));
                entryEntityDyn.set(prefix + "_companyarea", (Object)org.getDynamicObject("companyarea"));
                entryEntityDyn.set(prefix + "_city", (Object)org.getDynamicObject("city"));
                entryEntityDyn.set(prefix + "_workplace", (Object)org.getDynamicObject("workplace"));
                entryEntityDyn.set(prefix + "_parentorg", (Object)org.getDynamicObject("parentorg"));
                entryEntityDyn.set(prefix + "_parentorg_name", (Object)OrgBatchBillHelper.getOrgLongName((Long)org.getLong("parentorg.id"), (Date)modifyTime, null));
                entryEntityDyn.set(prefix + "_changescene", (Object)HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("changescene")));
                entryEntityDyn.set(prefix + "_changereason", (Object)HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("changereason")));
                entryEntityDyn.set(prefix + "_changedescription", (Object)org.getString("changedescription"));
                entryEntityDyn.set(prefix + "_org", (Object)this.getModel().getDataEntity().getDynamicObject("org"));
                entryEntityDyn.set(prefix + "_safelevel", (Object)org.getDynamicObject("safelevel"));
                entryEntityDyn.set(prefix + "_safetype", (Object)org.getDynamicObject("safetype"));
                DataEntityPropertyCollection properties = entryEntityDyn.getDataEntityType().getProperties();
                for (IDataEntityProperty property : properties) {
                    if (!PatternUtil.isExProperty(property.getName())) continue;
                    entryEntityDyn.set(property.getName(), org.get(property.getName().substring(prefix.length() + 1)));
                }
                continue;
            }
            ArrayList<Object> values = new ArrayList<Object>(Arrays.asList(org.getLong("id"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("adminorg")), org.getString("number"), org.get("name"), OrgBatchBillHelper.getOrgLongName((Long)org.getLong("old_parentorg.id"), (Date)modifyTime, null), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("parentorg")), org.get("parentorg_name"), org.get("simplename"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("adminorgtype")), org.getDate("establishmentdate"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("corporateorg")), org.getString("tobedisableflag"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("changescene")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("changereason")), org.get("changedescription"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("adminorglayer")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("adminorgfunction")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("companyarea")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("city")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("workplace")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("org")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("safelevel")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("safetype"))));
            IDataEntityType dataEntityType = org.getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (IDataEntityProperty property : properties) {
                if (!PatternUtil.isExProperty(property.getName())) continue;
                vs.addField(prefix + "_" + property.getName(), new Object[0]);
                Object obj = org.get(property.getName());
                if (obj instanceof DynamicObject) {
                    values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)((DynamicObject)obj)));
                    continue;
                }
                values.add(obj);
            }
            vs.addRow(values.toArray());
        }
        this.batchCreateNewEntryRow(vs, prefix);
    }

    private TableValueSetter getTableVsByPrefix(String prefix) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "adminorg"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "number"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "name"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "oriparentorg_name"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "parentorg"), new Object[0]);
        if (prefix.equals("parent")) {
            vs.addField(this.spliceTwoStringByUnderLine(prefix, "parentorg_name"), new Object[0]);
        }
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "simplename"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "adminorgtype"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "establishmentdate"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "corporateorg"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "tobedisableflag"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "changescene"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "changereason"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "changedescription"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "adminorglayer"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "adminorgfunction"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "companyarea"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "city"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "workplace"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "org"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "safelevel"), new Object[0]);
        vs.addField(this.spliceTwoStringByUnderLine(prefix, "safetype"), new Object[0]);
        return vs;
    }

    private void updateChartParentToInfoEntry(DynamicObjectCollection dynamicObjects) {
        String prefix = "info";
        TableValueSetter vs = this.getTableVsByPrefix(prefix);
        Map<Long, DynamicObject> parentEntryInfoMap = AdminOrgBatchChgHelper.getEntryInfoMap(this.getView(), prefix);
        for (DynamicObject org : dynamicObjects) {
            if (org.getLong("changetype.id") != OrgBatchChgBillConstants.CHANGE_TYPE_INFO.longValue()) continue;
            if (parentEntryInfoMap.containsKey(org.getLong("id"))) {
                DynamicObject entryEntityDyn = parentEntryInfoMap.get(org.getLong("id"));
                entryEntityDyn.set(prefix + "_number", (Object)org.getString("number"));
                entryEntityDyn.set(prefix + "_name", (Object)org.getString("name"));
                entryEntityDyn.set(prefix + "_simplename", (Object)org.getLocaleString("simplename"));
                entryEntityDyn.set(prefix + "_establishmentdate", (Object)org.getDate("establishmentdate"));
                entryEntityDyn.set(prefix + "_corporateorg", (Object)org.getDynamicObject("corporateorg"));
                entryEntityDyn.set(prefix + "_adminorglayer", (Object)org.getDynamicObject("adminorglayer"));
                entryEntityDyn.set(prefix + "_adminorgfunction", (Object)org.getDynamicObject("adminorgfunction"));
                entryEntityDyn.set(prefix + "_companyarea", (Object)org.getDynamicObject("companyarea"));
                entryEntityDyn.set(prefix + "_city", (Object)org.getDynamicObject("city"));
                entryEntityDyn.set(prefix + "_workplace", (Object)org.getDynamicObject("workplace"));
                entryEntityDyn.set(prefix + "_parentorg", (Object)org.getDynamicObject("parentorg"));
                entryEntityDyn.set(prefix + "_oriparentorg_name", (Object)org.getDynamicObject("parentorg").getString("name"));
                entryEntityDyn.set(prefix + "_changescene", (Object)HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("changescene")));
                entryEntityDyn.set(prefix + "_changereason", (Object)HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("changereason")));
                entryEntityDyn.set(prefix + "_changedescription", (Object)org.getString("changedescription"));
                entryEntityDyn.set(prefix + "_org", (Object)HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("org")));
                DataEntityPropertyCollection properties = entryEntityDyn.getDataEntityType().getProperties();
                for (IDataEntityProperty property : properties) {
                    if (!PatternUtil.isExProperty(property.getName())) continue;
                    entryEntityDyn.set(property.getName(), org.get(property.getName().substring(prefix.length() + 1)));
                }
                continue;
            }
            vs.addRow(new Object[]{org.getLong("id"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("adminorg")), org.getString("number"), org.get("name"), HRDyObjectPropUtil.getName((DynamicObject)org.getDynamicObject("parentorg")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("parentorg")), org.get("simplename"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("adminorgtype")), org.getDate("establishmentdate"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("corporateorg")), org.getString("tobedisableflag"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("changescene")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("changereason")), org.get("changedescription"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("adminorglayer")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("adminorgfunction")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("companyarea")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("city")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("workplace")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)org.getDynamicObject("org"))});
        }
        this.batchCreateNewEntryRow(vs, prefix);
    }

    private void addOrgInfoEntity(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        this.saveReturn(returnData, "entryentity_info");
        AdminOrgBatchChgHelper.setTabPageTextAndVisible("info", this.getView());
        this.updateAddEntryEntity();
        if (returnData != null) {
            AdminOrgMagicHelper.refreshPartOfView(this.getView(), Collections.singletonList(Long.valueOf(((Map)returnData).get("id").toString())), "info_chg", "update");
        }
    }

    private void deleteHisEntryEntity(DynamicObjectCollection dynamicObjects) {
        DynamicObjectCollection infoDys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_info");
        HashMap<Long, Integer> infoMap = new HashMap<Long, Integer>(infoDys.size());
        for (int i = 0; i < infoDys.size(); ++i) {
            infoMap.put(((DynamicObject)infoDys.get(i)).getLong("id"), i);
        }
        DynamicObjectCollection parentDys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_parent");
        HashMap<Long, Integer> parentMap = new HashMap<Long, Integer>(infoDys.size());
        for (int i = 0; i < parentDys.size(); ++i) {
            parentMap.put(((DynamicObject)parentDys.get(i)).getLong("id"), i);
        }
        ArrayList infoDelRows = new ArrayList();
        ArrayList parentDelRows = new ArrayList();
        for (DynamicObject orgDy : dynamicObjects) {
            if (infoMap.containsKey(orgDy.getLong("id")) && OrgBatchChgBillConstants.CHANGE_TYPE_PARENT.equals(orgDy.getLong("changetype.id"))) {
                infoDelRows.add(infoMap.get(orgDy.getLong("id")));
            }
            if (!parentMap.containsKey(orgDy.getLong("id")) || !OrgBatchChgBillConstants.CHANGE_TYPE_INFO.equals(orgDy.getLong("changetype.id"))) continue;
            parentDelRows.add(parentMap.get(orgDy.getLong("id")));
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        if (infoDelRows.size() > 0) {
            int[] infoArr = infoDelRows.stream().mapToInt(Integer::valueOf).toArray();
            model.deleteEntryRows("entryentity_info", infoArr);
        }
        if (parentDelRows.size() > 0) {
            int[] parentArr = parentDelRows.stream().mapToInt(Integer::valueOf).toArray();
            model.deleteEntryRows("entryentity_parent", parentArr);
        }
        model.endInit();
        this.getView().updateView("entryentity_info");
        this.getView().updateView("entryentity_parent");
    }
}

