/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batchservice;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.batchservice.AdminOrgBatchBillBaseService;
import kd.hr.homs.business.service.helper.AdminOrgBatchChartBaseHelper;
import kd.hr.homs.business.service.helper.AdminOrgBatchChartHelper;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchValidateHelper;
import kd.hr.homs.common.constants.batchchg.ChangeTypeEnum;
import kd.hr.homs.common.model.ChgOrgInfoDto;
import kd.hr.homs.common.model.ChgOrgInfoUndoDto;
import kd.hr.homs.common.model.OrgChartCheckVO;
import kd.hr.homs.common.model.OrgChartChgRequest;
import kd.hr.homs.common.model.OrgChartChgUndoRequest;
import kd.hr.homs.common.model.OrgCubeTreeNode;

public class AdminOrgBatchBillCustomEventService
extends AdminOrgBatchBillBaseService {
    private String pluginName;
    private IFormPlugin closeCallBackPlugin;

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public IFormPlugin getCloseCallBackPlugin() {
        return this.closeCallBackPlugin;
    }

    public void setCloseCallBackPlugin(IFormPlugin closeCallBackPlugin) {
        this.closeCallBackPlugin = closeCallBackPlugin;
    }

    public AdminOrgBatchBillCustomEventService(IFormView view) {
        super(view);
    }

    public void customEvent(CustomEventArgs evt) {
        String key = evt.getKey();
        if ("customcontrolap".equals(key)) {
            String eventName = evt.getEventName();
            OrgChartChgRequest request = (OrgChartChgRequest)JSONObject.parseObject((String)evt.getEventArgs(), OrgChartChgRequest.class);
            if (CollectionUtils.isEmpty((Collection)request.getOrgList())) {
                return;
            }
            List orgList = request.getOrgList();
            Set<Long> orgIdSet = orgList.stream().map(ChgOrgInfoDto::getOrgId).collect(Collectors.toSet());
            Long parentId = ((ChgOrgInfoDto)orgList.get(0)).getParentId();
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            switch (eventName) {
                case "add_org": {
                    this.getView().getPageCache().put("parentId", String.valueOf(parentId));
                    this.getView().getPageCache().put("adminOrgTypeStdId", this.getAdminOrgTypeStd(parentId));
                    AdminOrgBatchChgHelper.openViewForm(this.getView(), "add", this.getPluginName(), null);
                    break;
                }
                case "disable_org": {
                    String disableMsg = AdminOrgBatchChartHelper.checkDisableOrg(orgIdSet, dataEntity);
                    if (HRStringUtils.isEmpty((String)disableMsg)) {
                        AdminOrgBatchChartBaseHelper.openChartList4Disable("homs_chartdisablelist", "add_orgDisable", orgList, this.getModel().getDataEntity(), this.getPluginName(), this.getView());
                        break;
                    }
                    this.getView().showTipNotification(disableMsg);
                    break;
                }
                case "parent_chg": {
                    String parentMsg = AdminOrgBatchChartHelper.checkParentOrg(orgIdSet, dataEntity);
                    if (HRStringUtils.isEmpty((String)parentMsg)) {
                        AdminOrgBatchChartBaseHelper.openChartList("homs_chartparentlist", "add_orgParent", orgList, this.getModel().getDataEntity(), this.getPluginName(), this.getView());
                        break;
                    }
                    this.getView().showTipNotification(parentMsg);
                    break;
                }
                case "info_chg": {
                    String infoMsg = AdminOrgBatchChartHelper.checkInfoOrg(orgIdSet, dataEntity);
                    this.getView().getPageCache().put("parentId", String.valueOf(parentId));
                    if (HRStringUtils.isEmpty((String)infoMsg)) {
                        this.openChartEditInfo(orgList);
                        break;
                    }
                    this.getView().showTipNotification(infoMsg);
                    break;
                }
                case "cancel_operation": 
                case "undo_adjustment": {
                    this.undoAdjustment(evt.getEventArgs());
                    break;
                }
                case "exchange_root": {
                    ListShowParameter listShowParameter = AdminOrgBatchChgHelper.getExchangeOrgList(this.getView());
                    listShowParameter.setCloseCallBack(new CloseCallBack("kd.hr.homs.formplugin.web.orgbatch.AdminorgCubeViewPlugin", "exchange_root"));
                    listShowParameter.setMultiSelect(false);
                    this.getView().showForm((FormShowParameter)listShowParameter);
                    break;
                }
                case "edit_detail": {
                    this.getView().getPageCache().put("parentId", String.valueOf(parentId));
                    this.openChartEditInfo(orgList);
                    break;
                }
                case "edit_merge_detail": {
                    this.editMergeDetail(orgList, dataEntity);
                    break;
                }
                case "org_merge": {
                    List<String> result = AdminOrgBatchChartBaseHelper.checkMergeOrg(dataEntity, orgIdSet, 0L, 0L);
                    if (CollectionUtils.isEmpty(result)) {
                        AdminOrgBatchChartBaseHelper.openNewMergePage(orgIdSet, this.getView(), this.closeCallBackPlugin);
                        break;
                    }
                    result.forEach(item -> this.getView().showTipNotification(item));
                    break;
                }
                case "edit_split_detail": {
                    AdminOrgBatchChartBaseHelper.openSplit(this.getSplitOriginId(dataEntity, ((ChgOrgInfoDto)orgList.get(0)).getOrgId()), ((ChgOrgInfoDto)orgList.get(0)).getOrgId(), this.getView(), new CloseCallBack(this.closeCallBackPlugin, "edit_split_detail"));
                    break;
                }
                case "org_split": {
                    this.openNewSplit(dataEntity, orgList);
                    break;
                }
            }
        }
    }

    private String getAdminOrgTypeStd(Long orgId) {
        Long adminOrgTypeStdId = null;
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter idFilter = new QFilter("id", "=", (Object)orgId);
        DynamicObject orgDy = adminOrgHelper.queryOriginalOne("adminorgtype.adminorgtypestd.id", idFilter.toArray());
        if (orgDy != null) {
            adminOrgTypeStdId = orgDy.getLong("adminorgtype.adminorgtypestd.id") == 1010L ? 1020L : 1040L;
        }
        return adminOrgTypeStdId == null ? null : String.valueOf(adminOrgTypeStdId);
    }

    private void openChartEditInfo(List<ChgOrgInfoDto> orgList) {
        Long orgId = orgList.get(0).getOrgId();
        BillShowParameter formShowParameter = AdminOrgBatchChartBaseHelper.showPageWithEntry(orgId, this.getView(), this.getPluginName(), "0");
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void openNewSplit(DynamicObject dataEntity, List<ChgOrgInfoDto> orgList) {
        Long orgId = orgList.get(0).getOrgId();
        QFilter qFilter = new QFilter("id", "=", (Object)orgId);
        DynamicObjectCollection col = AdminOrgBatchChartBaseHelper.queryOrgDetail("id,name,enable", qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)col)) {
            return;
        }
        DynamicObject dy = (DynamicObject)col.get(0);
        List<String> propertyNameList = Arrays.asList("entryentity_info", "entryentity_parent", "entryentity_disable");
        OrgCubeTreeNode node = AdminOrgBatchChartBaseHelper.buildOrgCube(dataEntity, orgId, dy.getString("name"), propertyNameList, false);
        ArrayList<OrgChartCheckVO> list = new ArrayList<OrgChartCheckVO>(orgList.size());
        list.add(new OrgChartCheckVO(orgId, node.getText(), dy.getString("enable")));
        List<String> errorMsg = AdminOrgBatchChartHelper.checkSplitOrg(dataEntity, list, null);
        if (CollectionUtils.isEmpty(errorMsg)) {
            AdminOrgBatchChartBaseHelper.openSplit(null, orgId, this.getView(), new CloseCallBack(this.closeCallBackPlugin, "org_split"));
        } else {
            errorMsg.forEach(error -> this.getView().showTipNotification(error));
        }
    }

    private Long getSplitOriginId(DynamicObject dataEntity, Long splitOrgId) {
        Optional<DynamicObject> optional;
        DynamicObjectCollection splitCol = dataEntity.getDynamicObjectCollection("entryentity_split");
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if ("C".equals(billStatus)) {
            DynamicObject hisOrg = AdOrgRepository.getInstance().queryByPk("boid", (Object)splitOrgId);
            long orgBoid = hisOrg.getLong("boid");
            optional = splitCol.stream().filter(item -> {
                DynamicObjectCollection toBeSplitOrgs = item.getDynamicObjectCollection("split_target_org");
                boolean toBeSplitOrg = toBeSplitOrgs.stream().anyMatch(org -> org.getDynamicObject("fbasedataid").getLong("boid") == orgBoid);
                if (toBeSplitOrg) {
                    return true;
                }
                DynamicObject targetOrg = item.getDynamicObject("to_split_org");
                return targetOrg.getLong("boid") == orgBoid;
            }).findFirst();
        } else {
            optional = splitCol.stream().filter(splitDy -> {
                if (splitDy.getLong("to_split_org.id") == splitOrgId.longValue()) {
                    return true;
                }
                return splitDy.getDynamicObjectCollection("split_target_org").stream().anyMatch(targetDy -> targetDy.getLong("fbasedataid.id") == splitOrgId.longValue());
            }).findFirst();
        }
        if (!optional.isPresent()) {
            return null;
        }
        return optional.get().getLong("split_origin_id");
    }

    private void editMergeDetail(List<ChgOrgInfoDto> orgList, DynamicObject dataEntity) {
        Optional<DynamicObject> mergeOrgEntryOptional;
        DynamicObjectCollection merge = dataEntity.getDynamicObjectCollection("entryentity_merge");
        Long orgId = orgList.get(0).getOrgId();
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if ("C".equals(billStatus)) {
            DynamicObject hisOrg = AdOrgRepository.getInstance().queryByPk("boid", (Object)orgId);
            long orgBoid = hisOrg.getLong("boid");
            mergeOrgEntryOptional = merge.stream().filter(item -> {
                DynamicObjectCollection toBeMergeOrgs = item.getDynamicObjectCollection("to_merge_org");
                boolean toBeMergeOrg = toBeMergeOrgs.stream().anyMatch(org -> org.getDynamicObject("fbasedataid").getLong("boid") == orgBoid);
                if (toBeMergeOrg) {
                    return true;
                }
                DynamicObject targetOrg = item.getDynamicObject("merge_target_org");
                return targetOrg.getLong("boid") == orgBoid;
            }).findFirst();
        } else {
            mergeOrgEntryOptional = merge.stream().filter(item -> {
                DynamicObjectCollection toBeMergeOrgs = item.getDynamicObjectCollection("to_merge_org");
                boolean toBeMergeOrg = toBeMergeOrgs.stream().anyMatch(org -> org.getDynamicObject("fbasedataid").getLong("id") == orgId.longValue());
                if (toBeMergeOrg) {
                    return true;
                }
                DynamicObject targetOrg = item.getDynamicObject("merge_target_org");
                return targetOrg.getLong("id") == orgId.longValue();
            }).findFirst();
        }
        if (mergeOrgEntryOptional.isPresent()) {
            DynamicObject mergeOrgEntry = mergeOrgEntryOptional.get();
            AdminOrgBatchChartBaseHelper.openEditMergePage(mergeOrgEntry, this.getView(), this.getCloseCallBackPlugin());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u57fa\u4e8e\u6700\u65b0\u7684\u4fe1\u606f\u8fdb\u884c\u8c03\u6574\u3002", (String)"OrgChgFeasibleCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]));
        }
    }

    private void undoAdjustment(String param) {
        OrgChartChgUndoRequest request = (OrgChartChgUndoRequest)JSONObject.parseObject((String)param, OrgChartChgUndoRequest.class);
        List orgList = request.getOrgList();
        HashSet orgIdSet = Sets.newHashSetWithExpectedSize((int)(orgList.size() << 3));
        HashSet childOrgIdList = Sets.newHashSetWithExpectedSize((int)(orgList.size() << 3));
        for (ChgOrgInfoUndoDto chgOrgInfoDto : orgList) {
            orgIdSet.add(chgOrgInfoDto.getOrgid());
        }
        for (ChgOrgInfoUndoDto chgOrgInfoDto : orgList) {
            this.collectChild(chgOrgInfoDto.getChildren(), childOrgIdList, orgIdSet);
        }
        childOrgIdList.removeAll(orgIdSet);
        List<DynamicObject> changeDataList = this.getChangeDataList();
        HashSet<Long> changeOrgSet = new HashSet<Long>(changeDataList.size());
        if (this.checkData(orgIdSet, changeDataList, changeOrgSet)) {
            return;
        }
        this.dataHandle(orgIdSet, changeDataList, changeOrgSet, childOrgIdList);
    }

    private List<DynamicObject> getChangeDataList() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        List<String> prefixList = Arrays.asList("add", "parent", "info", "disable", "merge", "split");
        ArrayList changeDataList = Lists.newArrayListWithCapacity((int)16);
        prefixList.forEach(prefix -> {
            DynamicObjectCollection entities = dataEntity.getDynamicObjectCollection("entryentity_" + prefix);
            if (HRStringUtils.equals((String)prefix, (String)"merge") || HRStringUtils.equals((String)prefix, (String)"split")) {
                this.buildMergeSplit(changeDataList, entities, (String)prefix);
            } else {
                this.buildSingle(changeDataList, entities, prefix + "_");
            }
        });
        return changeDataList;
    }

    private void collectChild(List<ChgOrgInfoUndoDto> children, Set<Long> childOrgIdSet, Set<Long> orgIdSet) {
        if (children == null || children.size() == 0) {
            return;
        }
        for (ChgOrgInfoUndoDto child : children) {
            long orgId = child.getOrgid();
            if (orgIdSet.contains(orgId)) continue;
            childOrgIdSet.add(orgId);
            this.collectChild(child.getChildren(), childOrgIdSet, orgIdSet);
        }
    }

    private void buildMergeSplit(List<DynamicObject> changeDataList, DynamicObjectCollection entities, String prefix) {
        boolean isMerge = HRStringUtils.equals((String)"merge", (String)prefix);
        String mulOrgFiledName = isMerge ? "to_merge_org" : "split_target_org";
        String singleOrgFiledName = isMerge ? "merge_target_org" : "to_split_org";
        for (DynamicObject entry : entities) {
            for (DynamicObject toMergeOrg : entry.getDynamicObjectCollection(mulOrgFiledName)) {
                DynamicObject org = toMergeOrg.getDynamicObject("fbasedataid");
                this.addChangeDataList(changeDataList, prefix, entry, org);
            }
            DynamicObject singleOrg = entry.getDynamicObject(singleOrgFiledName);
            this.addChangeDataList(changeDataList, prefix, entry, singleOrg);
        }
    }

    private void addChangeDataList(List<DynamicObject> changeDataList, String prefix, DynamicObject entry, DynamicObject org) {
        DynamicObject dy = OrgBatchValidateHelper.BATCHORGENTITY_HELPER.generateEmptyDynamicObject();
        dy.set("changescene", entry.get(prefix + "_" + "changescene"));
        dy.set("adminorg", (Object)org);
        dy.set("parentorg", org.get("parentorg"));
        dy.set("id", org.get("id"));
        changeDataList.add(dy);
    }

    private void buildSingle(List<DynamicObject> changeDataList, DynamicObjectCollection add, String prefix) {
        if (add.size() == 0) {
            return;
        }
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        Map<Object, Object> newOrgMap = Maps.newHashMapWithExpectedSize((int)add.size());
        if ("add_".equals(prefix)) {
            ArrayList orgId = Lists.newArrayListWithCapacity((int)add.size());
            for (DynamicObject dynamicObject : add) {
                orgId.add(dynamicObject.getLong(prefix + "adminorg"));
            }
            DynamicObject[] query = adminOrgHelper.query("id,number", new QFilter[]{new QFilter("id", "in", (Object)orgId)});
            newOrgMap = Arrays.stream(query).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        }
        for (DynamicObject dynamicObject : add) {
            DynamicObject dy2 = OrgBatchValidateHelper.BATCHORGENTITY_HELPER.generateEmptyDynamicObject();
            changeDataList.add(dy2);
            dy2.set("changescene", dynamicObject.get(prefix + "changescene"));
            if (CollectionUtils.isEmpty((Map)newOrgMap)) {
                dy2.set("adminorg", dynamicObject.get(prefix + "adminorg"));
            } else {
                long adminOrgId = dynamicObject.getLong(prefix + "adminorg");
                dy2.set("adminorg", newOrgMap.get(adminOrgId));
            }
            dy2.set("parentorg", dynamicObject.get(prefix + "parentorg"));
            dy2.set("index", dynamicObject.get("seq"));
            dy2.set("id", dynamicObject.get("id"));
        }
    }

    private boolean checkData(Set<Long> orgIdSet, List<DynamicObject> changeDataList, Set<Long> changeOrgSet) {
        for (DynamicObject dy : changeDataList) {
            long orgId = dy.getLong("adminorg.id");
            if (orgId == 0L) {
                orgId = dy.getLong("adminorg");
            }
            changeOrgSet.add(orgId);
        }
        boolean containsChange = false;
        for (Long orgId : orgIdSet) {
            if (!changeOrgSet.contains(orgId)) continue;
            containsChange = true;
            break;
        }
        if (!containsChange) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5bf9\u9009\u4e2d\u7ec4\u7ec7\u8fdb\u884c\u8c03\u6574\u3002", (String)"AdminorgBatchBillPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void dataHandle(Set<Long> orgIdSet, List<DynamicObject> changeDataList, Set<Long> changeOrgSet, Set<Long> childOrgIdList) {
        List childAdjust = childOrgIdList.stream().filter(changeOrgSet::contains).collect(Collectors.toList());
        orgIdSet.addAll(childAdjust);
        this.distinguishAddAndChange(orgIdSet, changeDataList);
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("undo_adjustment", this.getCloseCallBackPlugin());
        int size = orgIdSet.size();
        if (childAdjust.size() > 0) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u4e2d%s\u4e2a\u7ec4\u7ec7\uff0c\u5c06\u540c\u65f6\u64a4\u9500\u672c\u5355\u4e2d\u8fd9\u4e9b\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u8c03\u6574\u8bb0\u5f55\u5e76\u5220\u9664\u5217\u8868\u5206\u5f55\u4fe1\u606f\uff1b\u64a4\u9500\u540e\u5c06\u4e0d\u53ef\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminorgBatchBillPlugin_45", (String)"odc-homs-formplugin", (Object[])new Object[0]), size), MessageBoxOptions.OKCancel, confirmCallBackListener);
        } else {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u4e2d%s\u4e2a\u7ec4\u7ec7\uff0c\u5c06\u64a4\u9500\u672c\u5355\u4e2d\u8fd9\u4e9b\u7ec4\u7ec7\u7684\u8c03\u6574\u8bb0\u5f55\u5e76\u5220\u9664\u5217\u8868\u5206\u5f55\u4fe1\u606f\uff1b\u64a4\u9500\u540e\u5c06\u4e0d\u53ef\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminorgBatchBillPlugin_44", (String)"odc-homs-formplugin", (Object[])new Object[0]), size), MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
    }

    private void distinguishAddAndChange(Set<Long> orgIdList, List<DynamicObject> changeDataList) {
        Map changeDataMap = changeDataList.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("adminorg.id"), Collectors.toList()));
        ArrayList addListId = Lists.newArrayListWithCapacity((int)orgIdList.size());
        ArrayList addListIndex = Lists.newArrayListWithCapacity((int)orgIdList.size());
        ArrayList changeIdList = Lists.newArrayListWithCapacity((int)orgIdList.size());
        ArrayList changeSceneList = Lists.newArrayListWithCapacity((int)orgIdList.size());
        ArrayList mergeSplitOrgId = Lists.newArrayListWithCapacity((int)orgIdList.size());
        for (Long orgId : orgIdList) {
            List<DynamicObject> list = changeDataMap.get(orgId);
            if (CollectionUtils.isEmpty(list)) continue;
            list.forEach(dynamicObject -> {
                long changeTypeId = dynamicObject.getLong("changescene.orgchangetype.id");
                long id = dynamicObject.getLong("id");
                if (ChangeTypeEnum.ADD.getId() == changeTypeId) {
                    addListId.add(orgId);
                    addListIndex.add(dynamicObject.getInt("index"));
                    changeIdList.add(id);
                } else if (ChangeTypeEnum.PARENT.getId() == changeTypeId || ChangeTypeEnum.INFO.getId() == changeTypeId || ChangeTypeEnum.DISABLE.getId() == changeTypeId) {
                    if (id != 0L) {
                        changeIdList.add(id);
                    }
                    changeSceneList.add(dynamicObject.getString("changescene.orgchangetype.id") + ";" + dynamicObject.get("index"));
                } else {
                    mergeSplitOrgId.add(id);
                }
            });
        }
        this.getView().getPageCache().put("undo_adjustment_add_id", JSONObject.toJSONString((Object)addListId));
        this.getView().getPageCache().put("undo_adjustment_add_index", JSONObject.toJSONString((Object)addListIndex));
        this.getView().getPageCache().put("undo_adjustment_change_id", JSONObject.toJSONString((Object)changeIdList));
        this.getView().getPageCache().put("undo_adjustment_change_scene", JSONObject.toJSONString((Object)changeSceneList));
        this.getView().getPageCache().put("undo_adjustment_merge_split", JSONObject.toJSONString((Object)mergeSplitOrgId));
    }
}

