/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.batchservice;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.batchservice.AdminOrgBatchBillBaseService;
import kd.hr.homs.business.service.helper.AdminOrgBatchChartBaseHelper;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;

public class AdminOrgBatchBillPropertyChangedService
extends AdminOrgBatchBillBaseService {
    private IFormPlugin closeCallBackPlugin;

    public IFormPlugin getCloseCallBackPlugin() {
        return this.closeCallBackPlugin;
    }

    public void setCloseCallBackPlugin(IFormPlugin closeCallBackPlugin) {
        this.closeCallBackPlugin = closeCallBackPlugin;
    }

    public AdminOrgBatchBillPropertyChangedService(IFormView view) {
        super(view);
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        int rowIndex = changedArgs.getChangeSet()[0].getRowIndex();
        String fieldKey = changedArgs.getProperty().getName();
        String prefix = this.getPrefixByFieldKey(fieldKey);
        String entryName = BillEntryHelperEnum.getEntryNameByPrefix(prefix);
        Object objectNew = changedArgs.getChangeSet()[0].getNewValue();
        Object objectOld = changedArgs.getChangeSet()[0].getOldValue();
        switch (fieldKey) {
            case "parent_changescene": 
            case "info_changescene": 
            case "disable_changescene": 
            case "merge_changescene": 
            case "split_changescene": {
                this.showChangeReasonIfNeed(changedArgs, rowIndex, prefix, objectNew);
                break;
            }
            case "parent_adminorg": 
            case "info_adminorg": {
                if (objectNew == null) break;
                this.showConfirmByOldValue(changedArgs, prefix);
                break;
            }
            case "disable_adminorg": {
                this.modifySplitTargetOrg((DynamicObject)objectNew);
                if (objectNew == null) break;
                this.setOrgLongNameOrgTypeAndDisableFlag(prefix, objectNew);
                break;
            }
            case "parent_parentorg": {
                DynamicObject newParentOrg = (DynamicObject)objectNew;
                AdminOrgBatchChgHelper.propChgForParentOrg(this.getView(), newParentOrg, prefix, rowIndex);
                break;
            }
            case "parent_adminorgtype": 
            case "info_adminorgtype": {
                if (objectNew == null) break;
                this.showConfirmByChangeValue(fieldKey, objectNew, objectOld);
                break;
            }
            case "parent_companyarea": 
            case "info_companyarea": {
                DynamicObject workplace = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(entryName).get(rowIndex)).getDynamicObject(prefix + "_workplace");
                AdminOrgBatchChgHelper.propChgForCountryArea(changedArgs, this.getModel(), workplace, prefix);
                break;
            }
            case "parent_city": 
            case "info_city": {
                DynamicObject workplace = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(entryName).get(rowIndex)).getDynamicObject(prefix + "_workplace");
                AdminOrgBatchChgHelper.propChgForCity(changedArgs, this.getModel(), workplace, prefix);
                break;
            }
            case "to_merge_org": 
            case "merge_target_org": 
            case "split_target_org": 
            case "to_split_org": {
                this.checkMergeOrSplitOrgChg(fieldKey, rowIndex, objectNew, objectOld);
            }
        }
    }

    private void modifySplitTargetOrg(DynamicObject newOrgDy) {
        if (newOrgDy == null) {
            return;
        }
        long newOrgId = newOrgDy.getLong("id");
        AdminOrgBatchChartBaseHelper.removeSplitTargetOrg(this.getView(), Sets.newHashSet((Object[])new Long[]{newOrgId}));
    }

    private void showChangeReasonIfNeed(PropertyChangedArgs changedArgs, int rowIndex, String prefix, Object objectNew) {
        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{this.spliceTwoStringByUnderLine(prefix, "changereason")});
        this.getModel().setValue(this.spliceTwoStringByUnderLine(prefix, "changereason"), null, rowIndex);
        if (Objects.isNull(objectNew)) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{this.spliceTwoStringByUnderLine(prefix, "changereason")});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{this.spliceTwoStringByUnderLine(prefix, "changereason")});
            Set changeReasonSet = ((DynamicObject)changedArgs.getChangeSet()[0].getNewValue()).getDynamicObjectCollection("changereason").stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
            HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_orgchangereason");
            DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", changeReasonSet), BaseDataHelper.getBaseDataFilter((String)"haos_orgchangereason", (long)((DynamicObject)this.getModel().getValue("org")).getLong("id")), new QFilter("enable", "=", (Object)"1")});
            if (dynamicObjects.length == 1) {
                this.getModel().setValue(this.spliceTwoStringByUnderLine(prefix, "changereason"), (Object)dynamicObjects[0]);
            }
        }
    }

    private void showConfirmByOldValue(PropertyChangedArgs e, String prefix) {
        DynamicObject org = (DynamicObject)e.getChangeSet()[0].getOldValue();
        Long orgOld = org != null ? Long.valueOf(org.getLong("id")) : null;
        this.getView().getPageCache().put("orgOld", orgOld == null ? "" : String.valueOf(orgOld));
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("select_org_" + prefix, this.getCloseCallBackPlugin());
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u884c\u653f\u7ec4\u7ec7\u540e\uff0c\u5f53\u524d\u5df2\u4fee\u6539\u7684\u5185\u5bb9\u5c06\u4f1a\u4e22\u5931\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminorgFastChgPlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    private void setOrgLongNameOrgTypeAndDisableFlag(String prefix, Object objectNew) {
        Date modifyTime = OrgChgUtil.getView(this.getView()).getModel().getDataEntity().getDate("modifytime");
        DynamicObject disableOrg = (DynamicObject)objectNew;
        DynamicObject entryEntityDyn = AdminOrgBatchChgHelper.getFocusEntry(prefix, this.getView());
        long entryId = ORM.create().genLongId("homs_batchorgentity");
        entryEntityDyn.set("id", (Object)entryId);
        entryEntityDyn.set("disable_oriparentorg_name", (Object)OrgBatchBillHelper.getOrgLongName((Long)disableOrg.getLong("parentorg.id"), (Date)modifyTime, null));
        entryEntityDyn.set(prefix + "_parentorg", (Object)AdminOrgBatchChgHelper.getHisDynamicObject(disableOrg.getLong("parentorg.id")));
        entryEntityDyn.set(prefix + "_adminorgtype", (Object)disableOrg.getDynamicObject("adminorgtype"));
        entryEntityDyn.set(prefix + "_tobedisableflag", (Object)disableOrg.getString("tobedisableflag"));
        this.getView().updateView("entryentity_disable");
    }

    private void showConfirmByChangeValue(String fieldKey, Object objectNew, Object objectOld) {
        DynamicObject dynamicObjectNew = (DynamicObject)objectNew;
        DynamicObject dynamicObjectOld = (DynamicObject)objectOld;
        long valueOld = dynamicObjectOld == null ? 0L : dynamicObjectOld.getLong("id");
        long valueNew = dynamicObjectNew.getLong("id");
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("adminOrgType", this.getCloseCallBackPlugin());
        String tip = ResManager.loadKDString((String)"\u5207\u6362\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u540e\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u7ec4\u7ec7\u7684\u6240\u5c5e\u516c\u53f8\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminOrgBatchBasePlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(tip, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, null, valueOld + "#" + valueNew + "#" + fieldKey.split("_")[0]);
    }

    private String getPrefixByFieldKey(String fieldKey) {
        int charIndex = fieldKey.indexOf("_");
        String prefix = "";
        if (charIndex != -1) {
            prefix = fieldKey.substring(0, charIndex);
        }
        return prefix;
    }

    private String spliceTwoStringByUnderLine(String oneString, String otherString) {
        return oneString + "_" + otherString;
    }

    private void checkMergeOrSplitOrgChg(String actionId, int rowIndex, Object objectNew, Object objectOld) {
        if (objectNew == null) {
            return;
        }
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(actionId, this.getCloseCallBackPlugin());
        StringBuilder changStr = new StringBuilder();
        String entityName = actionId.equals("to_merge_org") || actionId.equals("merge_target_org") ? "entryentity_merge" : "entryentity_split";
        StringBuilder oldStr = new StringBuilder();
        StringBuilder newStr = new StringBuilder();
        Boolean change = true;
        if (actionId.equals("to_merge_org") || actionId.equals("split_target_org")) {
            DynamicObjectCollection dynamicObjectNews = (DynamicObjectCollection)objectNew;
            DynamicObjectCollection dynamicObjectOlds = (DynamicObjectCollection)objectOld;
            if (CollectionUtils.isEmpty((Collection)dynamicObjectOlds)) {
                oldStr.append("0");
            } else {
                dynamicObjectOlds.stream().forEach(dynamicObject -> oldStr.append(dynamicObject.getLong("fbasedataid.id")).append("-"));
            }
            dynamicObjectNews.stream().forEach(dynamicObject -> newStr.append(dynamicObject.getLong("fbasedataid.id")).append("-"));
            changStr.append((CharSequence)oldStr).append("#").append((CharSequence)newStr).append("#").append(entityName).append("#").append(rowIndex);
            if (HRStringUtils.equals((String)oldStr.toString(), (String)newStr.toString())) {
                change = false;
            }
        } else {
            DynamicObject dynamicObjectNew = (DynamicObject)objectNew;
            DynamicObject dynamicObjectOld = (DynamicObject)objectOld;
            long valueOld = dynamicObjectOld == null ? 0L : dynamicObjectOld.getLong("id");
            long valueNew = dynamicObjectNew.getLong("id");
            changStr.append(valueOld).append("#").append(valueNew).append("#").append(entityName).append("#").append(rowIndex);
        }
        if (change.booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u884c\u653f\u7ec4\u7ec7\u540e\uff0c\u82e5\u539f\u6765\u7684\u884c\u653f\u7ec4\u7ec7\u5728\u672c\u5355\u5b58\u5728\u5176\u4ed6\u53d8\u52a8\uff0c\u7cfb\u7edf\u5c06\u4e0d\u4f1a\u81ea\u52a8\u5220\u9664\u8be5\u6761\u53d8\u52a8\u6570\u636e\uff0c\u9700\u7528\u6237\u624b\u52a8\u5220\u9664\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminorgBatchBillPlugin_43", (String)"odc-homs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, null, changStr.toString());
        }
    }
}

