/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.chgbill;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.util.IdCreator;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchValidateHelper;
import kd.hr.homs.business.service.utils.PatternUtil;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;

public class AdminChgDetailService {
    public List<String> baseInfo = new ArrayList<String>(Arrays.asList("number", "name", "simplename", "adminorgtype", "parentorg", "establishmentdate", "org", "belongcompany", "corporateorg", "adminorglayer", "adminorgfunction", "tobedisableflag", "tobedisabledate", "enable", "companyarea", "city", "workplace", "detailaddress", "description", "index", "positioning", "mainduty", "safelevel", "safetype", "safedescription"));
    private static final Long[] NEED_COOP_REL_CHANGE_TYPES = new Long[]{OrgBatchChgBillConstants.CHANGE_TYPE_PARENT, OrgBatchChgBillConstants.CHANGE_TYPE_INFO, OrgBatchChgBillConstants.CHANGE_TYPE_MERGE, OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT, OrgBatchChgBillConstants.CHANGE_TYPE_COOP_CHANGE};
    public Map<String, Integer> baseInfoIndexMap = Maps.newHashMapWithExpectedSize((int)16);
    public int corStartIndex = 10000;
    public int spStartIndex = 20000;
    public int startIndex = 0;
    public int moreIndex = 10000;
    public List<String> companyInfo = Arrays.asList("companytype", "industrytype");
    public List<String> groupInfo = Arrays.asList("groupvision", "groupmission");
    public List<String> departmentInfo = new ArrayList<String>(){
        {
            this.add("departmenttype");
        }
    };
    public List<String> statusInfo = new ArrayList<String>(Arrays.asList("tobedisableflag", "tobedisabledate", "enable"));
    private Map<Long, DynamicObject> oldCompanyMap;
    private Map<Long, DynamicObject> oldGroupMap;
    private Map<Long, DynamicObject> oldDepartmentMap;
    private Map<Long, List<DynamicObject>> oldOrgId2CoopDynMap;
    private Map<Long, List<DynamicObject>> oldOrgId2structDynMap;
    private Map<Long, List<DynamicObject>> newOrgId2structDynMap;
    private List<Long> allOrgBoIds;
    private HRBaseServiceHelper orgChgEntryHelper;
    private HRBaseServiceHelper orgChgRecordHelper;
    private HRBaseServiceHelper subEntryEntity;
    private HRBaseServiceHelper adminOrgDetail;
    private List<DynamicObject> orgChgRecordResult;
    private List<DynamicObject> orgChgEntryResult;
    private List<DynamicObject> orgChgSubEntryEntity;
    private static final String ORG_CHG_RECORD = "homs_orgchgrecord";
    private static final String ORG_CHG_ENTRY = "homs_orgchgentry";
    private static final String SUB_ENTRY_ENTITY = "homs_subentryentity";
    private static final String ADMIN_ORG_DETAIL = "haos_adminorgdetail";
    private Map<Long, DynamicObject> adminBoIdToRecord;
    private List<Long> mergeBoIds;
    private List<Long> splitBoIds;
    private Map<Long, DynamicObject> mergeBoIdTODynamicObject;
    private Map<Long, DynamicObject> splitBoIdTODynamicObject;
    private Map<Long, DynamicObject> boIdToOrgChgEntry;
    private IdCreator idCreator;

    public AdminChgDetailService() {
        this.baseInfo.forEach(info -> this.baseInfoIndexMap.put((String)info, ++this.startIndex));
        this.groupInfo.forEach(group -> this.baseInfoIndexMap.put((String)group, ++this.startIndex));
        this.companyInfo.forEach(company -> this.baseInfoIndexMap.put((String)company, ++this.startIndex));
        this.departmentInfo.forEach(depart -> this.baseInfoIndexMap.put((String)depart, ++this.startIndex));
        this.mergeBoIds = new ArrayList<Long>(16);
        this.splitBoIds = new ArrayList<Long>(16);
        this.mergeBoIdTODynamicObject = new HashMap<Long, DynamicObject>(16);
        this.splitBoIdTODynamicObject = new HashMap<Long, DynamicObject>(16);
        this.boIdToOrgChgEntry = Maps.newHashMapWithExpectedSize((int)16);
        this.idCreator = new IdCreator();
        this.orgChgRecordResult = Lists.newArrayListWithExpectedSize((int)16);
        this.orgChgEntryResult = Lists.newArrayListWithExpectedSize((int)16);
        this.orgChgSubEntryEntity = Lists.newArrayListWithExpectedSize((int)16);
        this.adminOrgDetail = new HRBaseServiceHelper(ADMIN_ORG_DETAIL);
        this.orgChgRecordHelper = new HRBaseServiceHelper(ORG_CHG_RECORD);
        this.orgChgEntryHelper = new HRBaseServiceHelper(ORG_CHG_ENTRY);
        this.subEntryEntity = new HRBaseServiceHelper(SUB_ENTRY_ENTITY);
        this.adminBoIdToRecord = Maps.newHashMapWithExpectedSize((int)16);
    }

    public AdminChgDetailService(Map<Long, DynamicObject> oldCompanyMap, Map<Long, DynamicObject> oldGroupMap, Map<Long, DynamicObject> oldDepartmentMap, Map<Long, List<DynamicObject>> orgId2CoopDynMap, List<Long> allOrgBoIds) {
        this.baseInfo.forEach(info -> this.baseInfoIndexMap.put((String)info, ++this.startIndex));
        this.groupInfo.forEach(group -> this.baseInfoIndexMap.put((String)group, ++this.startIndex));
        this.companyInfo.forEach(company -> this.baseInfoIndexMap.put((String)company, ++this.startIndex));
        this.departmentInfo.forEach(depart -> this.baseInfoIndexMap.put((String)depart, ++this.startIndex));
        this.mergeBoIds = new ArrayList<Long>(16);
        this.splitBoIds = new ArrayList<Long>(16);
        this.mergeBoIdTODynamicObject = new HashMap<Long, DynamicObject>(16);
        this.splitBoIdTODynamicObject = new HashMap<Long, DynamicObject>(16);
        this.boIdToOrgChgEntry = Maps.newHashMapWithExpectedSize((int)16);
        this.idCreator = new IdCreator();
        this.orgChgRecordResult = Lists.newArrayListWithExpectedSize((int)16);
        this.orgChgEntryResult = Lists.newArrayListWithExpectedSize((int)16);
        this.orgChgSubEntryEntity = Lists.newArrayListWithExpectedSize((int)16);
        this.oldCompanyMap = oldCompanyMap;
        this.oldGroupMap = oldGroupMap;
        this.oldDepartmentMap = oldDepartmentMap;
        this.allOrgBoIds = allOrgBoIds;
        this.orgChgRecordHelper = new HRBaseServiceHelper(ORG_CHG_RECORD);
        this.orgChgEntryHelper = new HRBaseServiceHelper(ORG_CHG_ENTRY);
        this.subEntryEntity = new HRBaseServiceHelper(SUB_ENTRY_ENTITY);
        this.adminOrgDetail = new HRBaseServiceHelper(ADMIN_ORG_DETAIL);
        this.oldOrgId2CoopDynMap = orgId2CoopDynMap;
        DynamicObject[] records = this.orgChgRecordHelper.queryOriginalArray("id,adminorg", new QFilter[]{new QFilter("adminorg", "in", allOrgBoIds)});
        this.adminBoIdToRecord = Arrays.stream(records).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg"), dyn -> dyn, (k1, k2) -> k1));
    }

    public void saveAdminOrgChgDetail(DynamicObject bill, DynamicObject[] billEntries) {
        DynamicObject dynamicObject = OrgBatchValidateHelper.ORGBATCHCHGBILL_HELPER.queryOne("creator,isexistsworkflow,modifytime", new QFilter[]{new QFilter("id", "=", (Object)bill.getLong("id"))});
        Date billModifyTime = new Date();
        if (dynamicObject != null) {
            billModifyTime = dynamicObject.getDate("modifytime");
        }
        this.init();
        HashMap orgBoIdToAfterValues = Maps.newHashMapWithExpectedSize((int)billEntries.length);
        Map<Long, DynamicObject> newCompanyMap = AdminOrgFastChgHelper.getCompanyMap(this.allOrgBoIds, "1");
        Map<Long, DynamicObject> newGroupMap = AdminOrgFastChgHelper.getGroupMap(this.allOrgBoIds, "1");
        Map<Long, DynamicObject> newDepartmentMap = AdminOrgFastChgHelper.getDepartmentMap(this.allOrgBoIds, "1");
        HashMap newOrgId2CoopDynsMap = Maps.newHashMapWithExpectedSize((int)billEntries.length);
        ArrayList alOrgIds = Lists.newArrayListWithExpectedSize((int)(billEntries.length * 2));
        List noMergeSplitOrg = Arrays.stream(billEntries).filter(dyn -> dyn.getLong("changetype.id") != 1070L && dyn.getLong("changetype.id") != 1080L).collect(Collectors.toList());
        this.initMergeSplit(billEntries);
        for (DynamicObject data : noMergeSplitOrg) {
            this.fillSomeAttr(orgBoIdToAfterValues, newOrgId2CoopDynsMap, alOrgIds, data);
        }
        Map<Long, DynamicObject> dynamicObjectMap = Arrays.stream(this.adminOrgDetail.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)alOrgIds)})).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        long[] recordIds = ORM.create().genLongIds(ORG_CHG_RECORD, orgBoIdToAfterValues.size());
        long[] entryIds = ORM.create().genLongIds(ORG_CHG_ENTRY, orgBoIdToAfterValues.size());
        int recordIndex = 0;
        int entryIdIndex = 0;
        for (Map.Entry<Long, AdminBeforeAndAfterId> entry : orgBoIdToAfterValues.entrySet()) {
            AdminBeforeAndAfterId value = (AdminBeforeAndAfterId)entry.getValue();
            DynamicObject orgchgrecord = this.adminBoIdToRecord.get(entry.getKey());
            if (orgchgrecord == null) {
                orgchgrecord = this.orgChgRecordHelper.generateEmptyDynamicObject();
                orgchgrecord.set("id", (Object)recordIds[recordIndex++]);
                orgchgrecord.set("adminorg", entry.getKey());
                orgchgrecord.set("initstatus", (Object)"2");
            }
            DynamicObject orgchgentry = this.orgChgEntryHelper.generateEmptyDynamicObject();
            orgchgentry.set("chgbill", (Object)bill.getLong("id"));
            orgchgentry.set("orgentry", (Object)value.getEntryId());
            if (value.getChangeType() == OrgBatchChgBillConstants.CHANGE_TYPE_ADD.longValue()) {
                orgchgentry.set("chgeffecttime", (Object)value.getEstablishTime());
            } else {
                orgchgentry.set("chgeffecttime", (Object)bill.getDate("effdt"));
            }
            orgchgentry.set("changescene", (Object)value.getChangeScene());
            orgchgentry.set("changetype", (Object)value.getChangeType());
            orgchgentry.set("changedescription", value.getChangeDescription());
            orgchgentry.set("changereason", (Object)value.getChangeReason());
            orgchgentry.set("orgchgrecord", (Object)orgchgrecord.getLong("id"));
            if (dynamicObject != null && dynamicObject.getBoolean("isexistsworkflow")) {
                orgchgentry.set("operator", (Object)value.getModifier());
            } else {
                orgchgentry.set("operator", (Object)RequestContext.get().getCurrUserId());
            }
            orgchgentry.set("afterchgorg", (Object)value.getAfterId());
            orgchgentry.set("operationtime", (Object)billModifyTime);
            long entryId = entryIds[entryIdIndex++];
            orgchgentry.set("id", (Object)entryId);
            this.addOrgChgSubEntryEntity(newCompanyMap, newGroupMap, newDepartmentMap, newOrgId2CoopDynsMap, dynamicObjectMap, entry, value, entryId);
            this.orgChgEntryResult.add(orgchgentry);
            this.boIdToOrgChgEntry.put(entry.getKey(), orgchgentry);
            if (this.adminBoIdToRecord.get(entry.getKey()) != null) continue;
            this.adminBoIdToRecord.put(entry.getKey(), orgchgrecord);
            this.orgChgRecordResult.add(orgchgrecord);
        }
        this.handleMergeAndSplitEntry(bill, billEntries, dynamicObject, billModifyTime, true);
        this.handleMergeAndSplitEntry(bill, billEntries, dynamicObject, billModifyTime, false);
        this.saveEntity();
    }

    private void handleMergeAndSplitEntry(DynamicObject bill, DynamicObject[] billEntries, DynamicObject dynamicObject, Date billModifyTime, boolean isMerge) {
        List mergeOrg = Arrays.stream(billEntries).filter(dyn -> dyn.getLong("changetype.id") == (long)(isMerge ? 1070 : 1080)).collect(Collectors.toList());
        Map<String, List<DynamicObject>> aftermergeorgid = mergeOrg.stream().collect(Collectors.groupingBy(dy -> dy.getLong("changetype.id") + "_" + dy.getLong(isMerge ? "aftermergeorgid" : "beforesplitorgid")));
        for (Map.Entry<String, List<DynamicObject>> entry : aftermergeorgid.entrySet()) {
            String key = entry.getKey();
            List<DynamicObject> value = entry.getValue();
            Long targetOrgId = Long.valueOf(key.substring(key.indexOf("_") + 1));
            List beforemergeorgid = value.stream().filter(dy -> dy.getLong(isMerge ? "beforemergeorgid" : "aftersplitorgid") != 0L).collect(Collectors.toList());
            if (beforemergeorgid.size() <= 0) continue;
            MulBasedataProp baseDataProp = (MulBasedataProp)MetadataServiceHelper.getDataEntityType((String)ORG_CHG_ENTRY).getProperty("mulbasedatafield");
            List needSaveEntries = value.stream().filter(dyn -> dyn.getLong(isMerge ? "beforemergeorgid" : "beforesplitorgid") != dyn.getLong(isMerge ? "aftermergeorgid" : "aftersplitorgid")).collect(Collectors.toList());
            for (DynamicObject dyn2 : needSaveEntries) {
                DynamicObject orgchgentry;
                DynamicObject orgchgrecord = this.adminBoIdToRecord.get(dyn2.getLong("adminorg.boid"));
                if (orgchgrecord == null) {
                    orgchgrecord = this.orgChgRecordHelper.generateEmptyDynamicObject();
                    orgchgrecord.set("id", (Object)this.idCreator.getId());
                    orgchgrecord.set("adminorg", (Object)dyn2.getLong("adminorg.boid"));
                    orgchgrecord.set("initstatus", (Object)"2");
                }
                if ((orgchgentry = this.boIdToOrgChgEntry.get(dyn2.getLong("adminorg.boid"))) == null) {
                    orgchgentry = this.orgChgEntryHelper.generateEmptyDynamicObject();
                    orgchgentry.set("chgbill", (Object)bill.getLong("id"));
                    orgchgentry.set("orgentry", (Object)dyn2.getLong("id"));
                    orgchgentry.set("chgeffecttime", (Object)bill.getDate("effdt"));
                    orgchgentry.set("changescene", (Object)dyn2.getLong("changescene.id"));
                    orgchgentry.set("changetype", (Object)dyn2.getLong("changetype.id"));
                    orgchgentry.set("changedescription", dyn2.get("changedescription"));
                    orgchgentry.set("changereason", (Object)dyn2.getLong("changereason.id"));
                    orgchgentry.set("orgchgrecord", (Object)orgchgrecord.getLong("id"));
                    if (dynamicObject != null && dynamicObject.getBoolean("isexistsworkflow")) {
                        if (dyn2.getDynamicObjectType().getProperties().containsKey((Object)"modifier_id")) {
                            orgchgentry.set("operator", (Object)dyn2.getLong("modifier_id"));
                        } else {
                            orgchgentry.set("operator", (Object)dynamicObject.getLong("creator.id"));
                        }
                    } else {
                        orgchgentry.set("operator", (Object)RequestContext.get().getCurrUserId());
                    }
                    orgchgentry.set("operationtime", (Object)billModifyTime);
                    long entryId = this.idCreator.getId();
                    orgchgentry.set("id", (Object)entryId);
                    DynamicObjectCollection entireProcessCollection = new DynamicObjectCollection();
                    for (DynamicObject cooOrgId : beforemergeorgid) {
                        DynamicObject dy2 = new DynamicObject(baseDataProp.getDynamicCollectionItemPropertyType());
                        dy2.set("fbasedataid", (Object)cooOrgId.getLong("adminorg.id"));
                        entireProcessCollection.add((Object)dy2);
                    }
                    this.setOrgChgEntryProperties(isMerge, targetOrgId, orgchgentry, entireProcessCollection);
                    this.orgChgEntryResult.add(orgchgentry);
                    this.boIdToOrgChgEntry.put(dyn2.getLong("adminorg.boid"), orgchgentry);
                } else {
                    DynamicObjectCollection entireProcessCollection = new DynamicObjectCollection();
                    for (DynamicObject cooOrgId : beforemergeorgid) {
                        DynamicObject dy3 = new DynamicObject(baseDataProp.getDynamicCollectionItemPropertyType());
                        dy3.set("fbasedataid", (Object)cooOrgId.getLong("adminorg.id"));
                        entireProcessCollection.add((Object)dy3);
                    }
                    this.setOrgChgEntryProperties(isMerge, targetOrgId, orgchgentry, entireProcessCollection);
                }
                if (this.adminBoIdToRecord.get(dyn2.getLong("adminorg.boid")) != null) continue;
                this.adminBoIdToRecord.put(dyn2.getLong("adminorg.boid"), orgchgrecord);
                this.orgChgRecordResult.add(orgchgrecord);
            }
        }
    }

    private void setOrgChgEntryProperties(boolean isMerge, Long targetOrgId, DynamicObject orgchgentry, DynamicObjectCollection entireProcessCollection) {
        orgchgentry.set("mergesplitflag", (Object)(isMerge ? "1" : "2"));
        if (isMerge) {
            orgchgentry.set("mergedorg", (Object)targetOrgId);
        } else {
            orgchgentry.set("splitedorg", (Object)targetOrgId);
        }
        orgchgentry.set("mulbasedatafield", (Object)entireProcessCollection);
    }

    private void initMergeSplit(DynamicObject[] billEntries) {
        this.mergeBoIds.addAll(Arrays.stream(billEntries).filter(dyn -> dyn.getLong("changetype.id") == 1070L).map(dyn -> dyn.getLong("adminorg.boid")).collect(Collectors.toList()));
        this.splitBoIds.addAll(Arrays.stream(billEntries).filter(dyn -> dyn.getLong("changetype.id") == 1080L).map(dyn -> dyn.getLong("adminorg.boid")).collect(Collectors.toList()));
        this.mergeBoIdTODynamicObject.putAll(Arrays.stream(billEntries).filter(dyn -> dyn.getLong("changetype.id") == 1070L).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg.boid"), dyn -> dyn, (v1, v2) -> v1)));
        this.splitBoIdTODynamicObject.putAll(Arrays.stream(billEntries).filter(dyn -> dyn.getLong("changetype.id") == 1080L).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg.boid"), dyn -> dyn, (v1, v2) -> v1)));
    }

    private void init() {
        DynamicObject dynamicObject = this.adminOrgDetail.generateEmptyDynamicObject();
        MainEntityType dataEntityType = (MainEntityType)dynamicObject.getDataEntityType();
        Map allFields = dataEntityType.getAllFields();
        for (String property : allFields.keySet()) {
            if (!PatternUtil.isExProperty(property) || HRStringUtils.isEmpty((String)dataEntityType.getProperty(property).getAlias())) continue;
            this.baseInfo.add(property);
            this.baseInfoIndexMap.put(property, ++this.startIndex);
        }
    }

    private void addOrgChgSubEntryEntity(Map<Long, DynamicObject> newCompanyMap, Map<Long, DynamicObject> newGroupMap, Map<Long, DynamicObject> newDepartmentMap, Map<Long, List<DynamicObject>> newOrgId2CoopDynsMap, Map<Long, DynamicObject> dynamicObjectMap, Map.Entry<Long, AdminBeforeAndAfterId> entry, AdminBeforeAndAfterId value, long entryId) {
        if (Stream.of(NEED_COOP_REL_CHANGE_TYPES).anyMatch(changeType -> changeType.longValue() == value.getChangeType()) && OrgBatchChgBillConstants.CHANGE_SCENE_ENABLE.longValue() != value.getOriginalChangeScene() && OrgBatchChgBillConstants.CHANGE_SCENE_DISABLE.longValue() != value.getOriginalChangeScene()) {
            List<DynamicObject> dynamicObjects = this.oldOrgId2CoopDynMap.get(entry.getKey());
            this.orgChgSubEntryEntity.addAll(this.compare(entryId, ADMIN_ORG_DETAIL, dynamicObjectMap.get(value.getBeforeId()), dynamicObjectMap.get(value.getAfterId()), dynamicObjectMap.get(value.getBeforeId()).getLong("id"), dynamicObjectMap.get(value.getAfterId()).getLong("id"), this.baseInfo));
            this.orgChgSubEntryEntity.addAll(this.compare(entryId, "haos_adminorggroup", this.oldGroupMap.get(entry.getKey()), newGroupMap.get(entry.getKey()), this.oldGroupMap.get(entry.getKey()) != null ? this.oldGroupMap.get(entry.getKey()).getLong("sourcevid") : 0L, newGroupMap.get(entry.getKey()) != null ? newGroupMap.get(entry.getKey()).getLong("sourcevid") : 0L, this.groupInfo));
            this.orgChgSubEntryEntity.addAll(this.compare(entryId, "haos_adminorgcompany", this.oldCompanyMap.get(entry.getKey()), newCompanyMap.get(entry.getKey()), this.oldCompanyMap.get(entry.getKey()) != null ? this.oldCompanyMap.get(entry.getKey()).getLong("sourcevid") : 0L, newCompanyMap.get(entry.getKey()) != null ? newCompanyMap.get(entry.getKey()).getLong("sourcevid") : 0L, this.companyInfo));
            this.orgChgSubEntryEntity.addAll(this.compare(entryId, "haos_adminorgdepartment", this.oldDepartmentMap.get(entry.getKey()), newDepartmentMap.get(entry.getKey()), this.oldDepartmentMap.get(entry.getKey()) != null ? this.oldDepartmentMap.get(entry.getKey()).getLong("sourcevid") : 0L, newDepartmentMap.get(entry.getKey()) != null ? newDepartmentMap.get(entry.getKey()).getLong("sourcevid") : 0L, this.departmentInfo));
            this.orgChgSubEntryEntity.addAll(this.compareCol(entryId, dynamicObjects, newOrgId2CoopDynsMap.get(entry.getKey())));
            this.orgChgSubEntryEntity.addAll(this.compareStructProject(entryId, entry));
        }
        if (value.getOriginalChangeType() == OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.longValue() || value.getOriginalChangeScene() == OrgBatchChgBillConstants.CHANGE_SCENE_ENABLE.longValue()) {
            this.orgChgSubEntryEntity.addAll(this.compare(entryId, ADMIN_ORG_DETAIL, dynamicObjectMap.get(value.getBeforeId()), dynamicObjectMap.get(value.getAfterId()), dynamicObjectMap.get(value.getBeforeId()).getLong("id"), dynamicObjectMap.get(value.getAfterId()).getLong("id"), this.statusInfo));
        }
    }

    private void saveEntity() {
        if (this.orgChgRecordResult.size() != 0) {
            this.orgChgRecordHelper.save(this.orgChgRecordResult.toArray(new DynamicObject[0]));
        }
        if (this.orgChgEntryResult.size() != 0) {
            this.orgChgEntryHelper.save(this.orgChgEntryResult.toArray(new DynamicObject[0]));
        }
        if (this.orgChgSubEntryEntity.size() != 0) {
            this.subEntryEntity.save(this.orgChgSubEntryEntity.toArray(new DynamicObject[0]));
        }
    }

    private void fillSomeAttr(Map<Long, AdminBeforeAndAfterId> map, Map<Long, List<DynamicObject>> newOrgId2CoopDynsMap, List<Long> alOrgIds, DynamicObject data) {
        AdminBeforeAndAfterId orDefault = map.getOrDefault(data.getLong("adminorg.boid"), new AdminBeforeAndAfterId());
        alOrgIds.add(data.getLong("adminorg.id"));
        alOrgIds.add(data.getLong("afterbaseinfoid"));
        long changeSceneId = data.getLong("changescene.id");
        orDefault.setOriginalChangeScene(changeSceneId);
        if (this.mergeBoIds.contains(data.getLong("adminorg.boid"))) {
            changeSceneId = this.mergeBoIdTODynamicObject.get(data.getLong("adminorg.boid")).getLong("changescene.id");
        }
        if (this.splitBoIds.contains(data.getLong("adminorg.boid"))) {
            changeSceneId = this.splitBoIdTODynamicObject.get(data.getLong("adminorg.boid")).getLong("changescene.id");
        }
        long changeTypeId = data.getLong("changetype.id");
        orDefault.setOriginalChangeType(changeTypeId);
        if (this.mergeBoIds.contains(data.getLong("adminorg.boid"))) {
            changeTypeId = this.mergeBoIdTODynamicObject.get(data.getLong("adminorg.boid")).getLong("changetype.id");
        }
        if (this.splitBoIds.contains(data.getLong("adminorg.boid"))) {
            changeTypeId = this.splitBoIdTODynamicObject.get(data.getLong("adminorg.boid")).getLong("changetype.id");
        }
        long changeReason = data.getLong("changereason.id");
        if (this.mergeBoIds.contains(data.getLong("adminorg.boid"))) {
            changeReason = this.mergeBoIdTODynamicObject.get(data.getLong("adminorg.boid")).getLong("changereason.id");
        }
        if (this.splitBoIds.contains(data.getLong("adminorg.boid"))) {
            changeReason = this.splitBoIdTODynamicObject.get(data.getLong("adminorg.boid")).getLong("changereason.id");
        }
        Object changeDescription = data.get("changedescription");
        if (this.mergeBoIds.contains(data.getLong("adminorg.boid"))) {
            changeDescription = this.mergeBoIdTODynamicObject.get(data.getLong("adminorg.boid")).get("changedescription");
        }
        if (this.splitBoIds.contains(data.getLong("adminorg.boid"))) {
            changeDescription = this.splitBoIdTODynamicObject.get(data.getLong("adminorg.boid")).get("changedescription");
        }
        orDefault.setChangeScene(changeSceneId);
        orDefault.setChangeType(changeTypeId);
        orDefault.setBeforeId(data.getLong("adminorg.id"));
        orDefault.setChangeDescription(changeDescription);
        orDefault.setAfterId(data.getLong("afterbaseinfoid"));
        orDefault.setChangeReason(changeReason);
        orDefault.setEntryId(data.getLong("id"));
        orDefault.setEstablishTime(data.getDate("establishmentdate"));
        if (data.getDynamicObjectType().getProperties().containsKey((Object)"modifier")) {
            orDefault.setModifier(data.getLong("modifier.id"));
        }
        map.put(data.getLong("adminorg.boid"), orDefault);
        newOrgId2CoopDynsMap.put(data.getLong("adminorg.boid"), (List<DynamicObject>)data.getDynamicObjectCollection("cooprelentryentity"));
    }

    private Collection<? extends DynamicObject> compareStructProject(long entryId, Map.Entry<Long, AdminBeforeAndAfterId> orgBoIdVsAdminBeforeAndAfterIdModel) {
        if (CollectionUtils.isEmpty(this.oldOrgId2structDynMap) && CollectionUtils.isEmpty(this.newOrgId2structDynMap)) {
            return Collections.emptyList();
        }
        List<DynamicObject> oldStructDyList = this.oldOrgId2structDynMap.get(orgBoIdVsAdminBeforeAndAfterIdModel.getKey());
        List<DynamicObject> newStructDyList = this.newOrgId2structDynMap.get(orgBoIdVsAdminBeforeAndAfterIdModel.getKey());
        ArrayList collection = Lists.newArrayListWithExpectedSize((int)16);
        if (oldStructDyList == null || oldStructDyList.size() == 0) {
            for (DynamicObject newStructDy : newStructDyList) {
                long newStructParentId = newStructDy.getLong("struct_parent_org.id");
                if (newStructParentId == 0L) continue;
                collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(++this.spStartIndex).chgEntityNumber("haos_adminorgstruct").beforeChgEntity(0L).afterChgEntity(newStructParentId).entryId(entryId).structProject(newStructDy.getLong("struct_project.id")).build());
            }
            return collection;
        }
        Map<Long, DynamicObject> oldStructProjectVsStruct = oldStructDyList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("structproject.id"), dyn -> dyn));
        Map<Long, DynamicObject> newStructProjectVsStruct = newStructDyList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("struct_project.id"), dyn -> dyn));
        for (Map.Entry<Long, DynamicObject> oldStructProjectIdVsStructEntry : oldStructProjectVsStruct.entrySet()) {
            DynamicObject newStruct = newStructProjectVsStruct.get(oldStructProjectIdVsStructEntry.getKey());
            if (newStruct == null) {
                collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(++this.spStartIndex).chgEntityNumber("haos_adminorgstruct").beforeChgEntity(oldStructProjectIdVsStructEntry.getValue().getLong("parentorg.id")).afterChgEntity(0L).entryId(entryId).structProject(oldStructProjectIdVsStructEntry.getKey()).build());
                continue;
            }
            DynamicObject oldStruct = oldStructProjectIdVsStructEntry.getValue();
            if (oldStruct.getLong("parentorg.id") == newStruct.getLong("struct_parent_org.boid")) continue;
            collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(++this.spStartIndex).chgEntityNumber("haos_adminorgstruct").beforeChgEntity(oldStruct.getLong("parentorg.id")).afterChgEntity(newStruct.getLong("struct_parent_org.id")).entryId(entryId).structProject(oldStructProjectIdVsStructEntry.getKey()).build());
        }
        for (Map.Entry<Long, DynamicObject> newStructProjectIdVsStructEntry : newStructProjectVsStruct.entrySet()) {
            DynamicObject oldStruct = oldStructProjectVsStruct.get(newStructProjectIdVsStructEntry.getKey());
            if (oldStruct != null || newStructProjectIdVsStructEntry.getValue().getLong("struct_parent_org.id") == 0L) continue;
            collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(++this.spStartIndex).chgEntityNumber("haos_adminorgstruct").beforeChgEntity(0L).afterChgEntity(newStructProjectIdVsStructEntry.getValue().getLong("struct_parent_org.id")).entryId(entryId).structProject(newStructProjectIdVsStructEntry.getKey()).build());
        }
        return collection;
    }

    private List<DynamicObject> compareCol(long entryId, List<DynamicObject> oldRelList, List<DynamicObject> newRelList) {
        ArrayList collection = Lists.newArrayListWithExpectedSize((int)16);
        if (oldRelList == null || oldRelList.size() == 0) {
            for (DynamicObject newRel : newRelList) {
                collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(++this.corStartIndex).chgEntityNumber("haos_orgteamcooprel").beforeChgEntity(0L).afterChgEntity(newRel.getLong("cooporgteam.id")).entryId(entryId).coopRelType(newRel.getLong("coopreltyp.id")).build());
            }
            return collection;
        }
        Map<Long, DynamicObject> newRelTypeMap = newRelList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("coopreltyp.id"), dyn -> dyn));
        Map<Long, DynamicObject> oldRelTypeMap = oldRelList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("coopreltype.id"), dyn -> dyn));
        for (Map.Entry<Long, DynamicObject> entry : oldRelTypeMap.entrySet()) {
            DynamicObject newRel = newRelTypeMap.get(entry.getKey());
            if (newRel == null) {
                collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(++this.corStartIndex).chgEntityNumber("haos_orgteamcooprel").beforeChgEntity(entry.getValue().getLong("cooporgteam.id")).afterChgEntity(0L).entryId(entryId).coopRelType(entry.getKey()).build());
                continue;
            }
            DynamicObject oldRel = entry.getValue();
            if (oldRel.getLong("cooporgteam.boid") == newRel.getLong("cooporgteam.boid")) continue;
            collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(++this.corStartIndex).chgEntityNumber("haos_orgteamcooprel").beforeChgEntity(oldRel.getLong("cooporgteam.id")).afterChgEntity(newRel.getLong("cooporgteam.id")).entryId(entryId).coopRelType(entry.getKey()).build());
        }
        for (Map.Entry<Long, DynamicObject> entry : newRelTypeMap.entrySet()) {
            DynamicObject oldRel = oldRelTypeMap.get(entry.getKey());
            if (oldRel != null) continue;
            collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(++this.corStartIndex).chgEntityNumber("haos_orgteamcooprel").beforeChgEntity(0L).afterChgEntity(entry.getValue().getLong("cooporgteam.id")).entryId(entryId).coopRelType(entry.getKey()).build());
        }
        return collection;
    }

    private List<DynamicObject> compare(long entryId, String entityNumber, DynamicObject before, DynamicObject after, long beforeId, long afterId, List<String> properties) {
        ArrayList collection = Lists.newArrayListWithExpectedSize((int)16);
        if (before == null && after == null) {
            return collection;
        }
        if (before != null && after == null || before == null && after != null) {
            if (before != null) {
                for (String property : properties) {
                    this.comparePlainObject(entryId, entityNumber, before, beforeId, afterId, collection, property);
                }
            } else {
                for (String property : properties) {
                    this.comparePlainObject(entryId, entityNumber, after, beforeId, afterId, collection, property);
                }
            }
            return collection;
        }
        for (String property : properties) {
            Object be = before.get(property);
            Object af = after.get(property);
            if (be instanceof DynamicObject && af instanceof DynamicObject) {
                long id2;
                long id1 = ((DynamicObject)be).getLong("id");
                if (id1 == (id2 = ((DynamicObject)af).getLong("id"))) continue;
                collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(this.baseInfoIndexMap.getOrDefault(property, --this.moreIndex)).chgEntityNumber(entityNumber).chgPageElement(property).beforeChgEntity(beforeId).afterChgEntity(afterId).entryId(entryId).build());
                continue;
            }
            if (be instanceof OrmLocaleValue && af instanceof OrmLocaleValue) {
                AtomicBoolean breaked = new AtomicBoolean(false);
                ((OrmLocaleValue)be).forEach((beCode, beNameVal) -> {
                    if (HRStringUtils.equals((String)"GLang", (String)beCode)) {
                        return;
                    }
                    String afterVal = ((OrmLocaleValue)af).get(beCode);
                    if (afterVal == null && !HRStringUtils.isEmpty((String)beNameVal) && !breaked.get()) {
                        collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(this.baseInfoIndexMap.getOrDefault(property, --this.moreIndex)).chgEntityNumber(entityNumber).chgPageElement(property).beforeChgEntity(beforeId).afterChgEntity(afterId).entryId(entryId).build());
                        breaked.set(true);
                        return;
                    }
                    if (!breaked.get() && !HRStringUtils.equals((String)beNameVal, (String)afterVal)) {
                        collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(this.baseInfoIndexMap.getOrDefault(property, --this.moreIndex)).chgEntityNumber(entityNumber).chgPageElement(property).beforeChgEntity(beforeId).afterChgEntity(afterId).entryId(entryId).build());
                        breaked.set(true);
                        return;
                    }
                });
                ((OrmLocaleValue)af).forEach((afCode, afNameVal) -> {
                    if (HRStringUtils.equals((String)"GLang", (String)afCode)) {
                        return;
                    }
                    String beVal = ((OrmLocaleValue)be).get(afCode);
                    if (beVal == null && !HRStringUtils.isEmpty((String)afNameVal) && !breaked.get()) {
                        collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(this.baseInfoIndexMap.getOrDefault(property, --this.moreIndex)).chgEntityNumber(entityNumber).chgPageElement(property).beforeChgEntity(beforeId).afterChgEntity(afterId).entryId(entryId).build());
                        breaked.set(true);
                        return;
                    }
                });
                continue;
            }
            if (be == null && af == null || be != null && af != null && be.equals(af)) continue;
            if (be instanceof MulBasedataDynamicObjectCollection && af instanceof MulBasedataDynamicObjectCollection) {
                Set afSet;
                MulBasedataDynamicObjectCollection beCollection = (MulBasedataDynamicObjectCollection)be;
                MulBasedataDynamicObjectCollection afCollection = (MulBasedataDynamicObjectCollection)af;
                Set beSet = beCollection.stream().map(beC -> beC.getLong("fbasedataid_id")).collect(Collectors.toSet());
                if (beSet.equals(afSet = afCollection.stream().map(afC -> afC.getLong("fbasedataid_id")).collect(Collectors.toSet()))) continue;
                collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(this.baseInfoIndexMap.getOrDefault(property, --this.moreIndex)).chgEntityNumber(entityNumber).chgPageElement(property).beforeChgEntity(beforeId).afterChgEntity(afterId).entryId(entryId).build());
                continue;
            }
            collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(this.baseInfoIndexMap.getOrDefault(property, --this.moreIndex)).chgEntityNumber(entityNumber).chgPageElement(property).beforeChgEntity(beforeId).afterChgEntity(afterId).entryId(entryId).build());
        }
        return collection;
    }

    private void comparePlainObject(long entryId, String entityNumber, DynamicObject before, long beforeId, long afterId, List<DynamicObject> collection, String property) {
        Object be = before.get(property);
        if (be instanceof Long && (Long)be == 0L) {
            return;
        }
        if (be instanceof String && HRStringUtils.isEmpty((String)((String)be))) {
            return;
        }
        if (be == null) {
            return;
        }
        collection.add(new SubEntryEntityBuilder().serviceHelper(this.subEntryEntity).seq(this.baseInfoIndexMap.getOrDefault(property, --this.moreIndex)).chgEntityNumber(entityNumber).chgPageElement(property).beforeChgEntity(beforeId).afterChgEntity(afterId).entryId(entryId).build());
    }

    public void setOldOrgId2structDynMap(Map<Long, List<DynamicObject>> oldOrgId2structDynMap) {
        this.oldOrgId2structDynMap = oldOrgId2structDynMap;
    }

    public void setNewOrgId2structDynMap(Map<Long, List<DynamicObject>> newOrgId2structDynMap) {
        this.newOrgId2structDynMap = newOrgId2structDynMap;
    }

    private static class AdminBeforeAndAfterId {
        private long beforeId;
        private long afterId;
        private long changeType;
        private long changeScene;
        private long originalChangeType;
        private long originalChangeScene;
        private Object changeDescription;
        private long changeReason;
        private long entryId;
        private Date establishTime;
        private long modifier;

        public Date getEstablishTime() {
            return this.establishTime;
        }

        public void setEstablishTime(Date establishTime) {
            this.establishTime = establishTime;
        }

        public long getChangeReason() {
            return this.changeReason;
        }

        public void setChangeReason(long changeReason) {
            this.changeReason = changeReason;
        }

        public long getChangeType() {
            return this.changeType;
        }

        public void setChangeType(long changeType) {
            this.changeType = changeType;
        }

        public long getChangeScene() {
            return this.changeScene;
        }

        public void setChangeScene(long changeScene) {
            this.changeScene = changeScene;
        }

        public Object getChangeDescription() {
            return this.changeDescription;
        }

        public void setChangeDescription(Object changeDescription) {
            this.changeDescription = changeDescription;
        }

        public long getBeforeId() {
            return this.beforeId;
        }

        public void setBeforeId(long beforeId) {
            this.beforeId = beforeId;
        }

        public long getAfterId() {
            return this.afterId;
        }

        public void setAfterId(long afterId) {
            this.afterId = afterId;
        }

        public long getEntryId() {
            return this.entryId;
        }

        public void setEntryId(long entryId) {
            this.entryId = entryId;
        }

        public long getOriginalChangeType() {
            return this.originalChangeType;
        }

        public void setOriginalChangeType(long originalChangeType) {
            this.originalChangeType = originalChangeType;
        }

        public long getOriginalChangeScene() {
            return this.originalChangeScene;
        }

        public void setOriginalChangeScene(long originalChangeScene) {
            this.originalChangeScene = originalChangeScene;
        }

        public long getModifier() {
            return this.modifier;
        }

        public void setModifier(long modifier) {
            this.modifier = modifier;
        }
    }

    public static class SubEntryEntityBuilder {
        private HRBaseServiceHelper serviceHelper;
        private String chgEntityNumber;
        private String chgPageElement;
        private int seq;
        private long beforeChgEntity;
        private long afterChgEntity;
        private long coopRelType;
        private long entryId;

        public SubEntryEntityBuilder serviceHelper(HRBaseServiceHelper serviceHelper) {
            this.serviceHelper = serviceHelper;
            return this;
        }

        public SubEntryEntityBuilder chgEntityNumber(String chgEntityNumber) {
            this.chgEntityNumber = chgEntityNumber;
            return this;
        }

        public SubEntryEntityBuilder seq(int seq) {
            this.seq = seq;
            return this;
        }

        public SubEntryEntityBuilder chgPageElement(String chgPageElement) {
            this.chgPageElement = chgPageElement;
            return this;
        }

        public SubEntryEntityBuilder beforeChgEntity(long beforeChgEntity) {
            this.beforeChgEntity = beforeChgEntity;
            return this;
        }

        public SubEntryEntityBuilder afterChgEntity(long afterChgEntity) {
            this.afterChgEntity = afterChgEntity;
            return this;
        }

        public SubEntryEntityBuilder coopRelType(long coopRelType) {
            this.coopRelType = coopRelType;
            return this;
        }

        public SubEntryEntityBuilder structProject(long structProject) {
            this.coopRelType = structProject;
            return this;
        }

        public SubEntryEntityBuilder entryId(long entryId) {
            this.entryId = entryId;
            return this;
        }

        public DynamicObject build() {
            DynamicObject dynamicObject = this.serviceHelper.generateEmptyDynamicObject();
            dynamicObject.set("chgentitynumber", (Object)this.chgEntityNumber);
            dynamicObject.set("chgpageelement", (Object)this.chgPageElement);
            dynamicObject.set("sequence", (Object)this.seq);
            dynamicObject.set("beforechgentity", (Object)this.beforeChgEntity);
            dynamicObject.set("afterchgentity", (Object)this.afterChgEntity);
            dynamicObject.set("coopreltype", (Object)this.coopRelType);
            dynamicObject.set("entryid", (Object)this.entryId);
            dynamicObject.set("id", (Object)ORM.create().genLongId(AdminChgDetailService.SUB_ENTRY_ENTITY));
            return dynamicObject;
        }
    }
}

