/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.chgbill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class AdminOrgChgBillSaveService {
    public static final String TEMPSTATUS = "-3";
    private static AdminOrgChgBillSaveService INSTANCE = new AdminOrgChgBillSaveService();
    private static final Log LOG = LogFactory.getLog(AdminOrgChgBillSaveService.class);

    public static AdminOrgChgBillSaveService getInstance() {
        return INSTANCE;
    }

    public void infoCopy(DynamicObject[] dataEntities, String billEntityNumber, DynamicObject[] dynArr, List<Long> orgIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dyn = dataEntities[i];
            DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)emptyDynamicObject);
            long orgId = dyn.getLong("orgid");
            if (orgId == 0L) {
                orgId = dyn.getLong("adminorg.id");
            }
            orgIdList.add(orgId);
            emptyDynamicObject.set("id", (Object)orgId);
            if (HRStringUtils.equals((String)billEntityNumber, (String)"homs_batchorgentityadd")) {
                dyn.set("adminorg", (Object)orgId);
            }
            dynArr[i] = emptyDynamicObject;
        }
    }

    public void infoCopyBoid(DynamicObject[] dataEntities, String billEntityNumber, DynamicObject[] dynArr, List<Long> orgIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        HashMap parentIdMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dyn = dataEntities[i];
            DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)emptyDynamicObject);
            long orgId = dyn.getLong("orgid");
            if (orgId == 0L) {
                orgId = dyn.getLong("adminorg.boid");
            }
            orgIdList.add(orgId);
            emptyDynamicObject.set("id", (Object)orgId);
            emptyDynamicObject.set("boid", (Object)orgId);
            dynArr[i] = emptyDynamicObject;
            if (HRStringUtils.equals((String)billEntityNumber, (String)"homs_batchorgentityadd")) {
                dyn.set("adminorg", (Object)orgId);
            }
            parentIdMap.put(orgId, dyn.getLong("parentorg.boid"));
        }
        Map parents = AdminOrgHisServiceHelper.getEntityInfoByOrgId((List)Lists.newArrayList(parentIdMap.values()), (String)AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), (String)"boid");
        for (DynamicObject dyn : dynArr) {
            long id = dyn.getLong("id");
            Long parentId = (Long)parentIdMap.get(id);
            if (!parents.containsKey(parentId)) continue;
            dyn.set("parentorg", parents.get(parentId));
        }
    }

    public Map<Long, DynamicObject> getOrgBeforeChangeVersionBasicInfo(List<Long> orgIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        QFilter filter = new QFilter("id", "in", orgIdList);
        filter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.query("id,parentorg,name,sourcevid", new QFilter[]{filter});
        return Stream.of(dynamicObjects).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
    }

    public Map<Long, Map<String, Long>> getOrgRelateVersion(List<Long> orgIdList) {
        HashMap<Long, Map<String, Long>> infoMap = new HashMap<Long, Map<String, Long>>(orgIdList.size());
        StringBuilder sb = new StringBuilder();
        sb.append("select org.fid,org.fsourcevid as orgsourcevid,st.fsourcevid as structsourcevid,gp.fsourcevid as groupsourcevid,");
        sb.append(" dt.fsourcevid as detpsourcevid,cy.fsourcevid as companysourcevid ");
        sb.append(" from t_haos_adminorg org ");
        sb.append(" left join t_haos_adminstruct st on org.fboid = st.fadminorgid and org.fiscurrentversion = st.fiscurrentversion ");
        sb.append(" left join t_haos_group gp on org.fboid = gp.fadminorgid and org.fiscurrentversion = gp.fiscurrentversion ");
        sb.append(" left join t_haos_department dt on org.fboid = dt.fadminorgid and org.fiscurrentversion = dt.fiscurrentversion ");
        sb.append(" left join t_haos_company cy on org.fboid = cy.fadminorgid and org.fiscurrentversion = cy.fiscurrentversion ");
        sb.append(" where  org.fiscurrentversion = '1' and org.fid in ( ");
        orgIdList.forEach(org -> sb.append('?').append(','));
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        try (DataSet rs = HRDBUtil.queryDataSet((String)"getOrgRelateVersion", (DBRoute)new DBRoute("haos"), (String)sb.toString(), (Object[])orgIdList.toArray(new Long[0]));){
            rs.forEach(data -> {
                Map map = infoMap.computeIfAbsent(data.getLong("fid"), k -> new HashMap(8));
                map.put(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), data.getLong("orgsourcevid"));
                map.put(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), data.getLong("structsourcevid"));
                map.put(AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), data.getLong("groupsourcevid"));
                map.put(AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), data.getLong("detpsourcevid"));
                map.put(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), data.getLong("companysourcevid"));
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return infoMap;
    }

    public Map<Long, Map<String, Long>> getOrgRelateVersionInfo(List<Long> orgIdList) {
        Map<Long, Long> orgBasicInfoHisVersionMap = this.getCurVersionRelateHisVid(orgIdList, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), "id");
        Map<Long, Long> orgStructHisVersionMap = this.getCurVersionRelateHisVid(orgIdList, AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), "adminorg.id");
        Map<Long, Long> orgGroupHisVersionMap = this.getCurVersionRelateHisVid(orgIdList, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), "adminorg.id");
        Map<Long, Long> orgDepartmentHisVersionMap = this.getCurVersionRelateHisVid(orgIdList, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), "adminorg.id");
        Map<Long, Long> orgCompanyHisVersionMap = this.getCurVersionRelateHisVid(orgIdList, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), "adminorg.id");
        HashMap<Long, Map<String, Long>> map = new HashMap<Long, Map<String, Long>>(orgIdList.size());
        for (Long orgId : orgIdList) {
            HashMap<String, Long> entityHisVersionMap = (HashMap<String, Long>)map.get(orgId);
            if (Objects.isNull(entityHisVersionMap)) {
                entityHisVersionMap = new HashMap<String, Long>(5);
            }
            entityHisVersionMap.put(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), orgBasicInfoHisVersionMap.get(orgId));
            entityHisVersionMap.put(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), orgStructHisVersionMap.get(orgId));
            entityHisVersionMap.put(AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), orgGroupHisVersionMap.get(orgId));
            entityHisVersionMap.put(AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), orgDepartmentHisVersionMap.get(orgId));
            entityHisVersionMap.put(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), orgCompanyHisVersionMap.get(orgId));
            map.put(orgId, entityHisVersionMap);
        }
        return map;
    }

    private Map<Long, Long> getCurVersionRelateHisVid(List<Long> orgIdList, String entityNumber, String orgFieldName) {
        DynamicObject[] dynamicObjects;
        HashMap map = Maps.newHashMapWithExpectedSize((int)orgIdList.size());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter filter = new QFilter(orgFieldName, "in", orgIdList);
        filter.and("iscurrentversion", "=", (Object)"1");
        for (DynamicObject dyn : dynamicObjects = serviceHelper.query(orgFieldName + "," + "sourcevid" + "," + "datastatus", new QFilter[]{filter})) {
            if (map.get(dyn.getLong(orgFieldName)) != null && TEMPSTATUS.equals(dyn.getString("datastatus"))) continue;
            map.put(dyn.getLong(orgFieldName), dyn.getLong("sourcevid"));
        }
        return map;
    }

    public Map<Long, Map<String, Long>> parseAndProcessHisResponse(HisResponse<BatchVersionChangeRespData> response, int size) {
        List versionChangeRespDataList = ((BatchVersionChangeRespData)response.getData()).getVersionChangeRespDataList();
        HashMap<Long, Map<String, Long>> map = new HashMap<Long, Map<String, Long>>(size);
        versionChangeRespDataList.forEach(versionChangeRespData -> {
            String entityNumber = versionChangeRespData.getEntityNumber();
            if (AdminOrgHisDynKey.getOrgHisDynKeyList().contains(AdminOrgHisDynKey.getDynKey((String)entityNumber))) {
                String orgFieldName = HRStringUtils.equals((String)AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), (String)entityNumber) ? "boid" : "adminorg.id";
                for (DynamicObject dynamicObject : versionChangeRespData.getNewDynamicObjects()) {
                    if (!dynamicObject.getBoolean("iscurrentversion")) continue;
                    long orgId = dynamicObject.getLong(orgFieldName);
                    HashMap<String, Long> entityNumberHisVersionMap = (HashMap<String, Long>)map.get(orgId);
                    if (entityNumberHisVersionMap == null) {
                        entityNumberHisVersionMap = new HashMap<String, Long>(16);
                    }
                    entityNumberHisVersionMap.put(entityNumber, dynamicObject.getLong("sourcevid"));
                    map.put(orgId, entityNumberHisVersionMap);
                }
            }
        });
        return map;
    }

    public void setBeforeBillEntryVersionId(DynamicObject[] billEntryDynObjArr, Map<Long, Map<String, Long>> oldVersionMap, Map<Long, DynamicObject> oldOrgBasicInfo) {
        for (DynamicObject dy : billEntryDynObjArr) {
            Long orgId = dy.getLong("adminorg.boid");
            if (!ObjectUtils.isEmpty(oldVersionMap)) {
                Map<String, Long> beforeMap = oldVersionMap.get(orgId);
                dy.set("beforebaseinfoid", (Object)beforeMap.get(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey()));
                dy.set("beforestructid", (Object)beforeMap.get(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey()));
                dy.set("beforedepartmentid", (Object)beforeMap.get(AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey()));
                dy.set("beforecompanyid", (Object)beforeMap.get(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey()));
                dy.set("beforegroupid", (Object)beforeMap.get(AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey()));
            }
            if (ObjectUtils.isEmpty(oldOrgBasicInfo)) continue;
            dy.set("oriparentorg", oldOrgBasicInfo.get(orgId).get("parentorg"));
            dy.set("orgoriname", oldOrgBasicInfo.get(orgId).get("name"));
        }
    }

    public void setBeforeAndAfterChgVersionId(DynamicObject[] billEntryDynObjArr, Map<Long, Map<String, Long>> newOrgRelateVersionMap, Map<Long, Map<String, Long>> oldOrgRelateVersionMap, Map<Long, DynamicObject> oldOrgBasicInfo) {
        for (DynamicObject dynamicObject : billEntryDynObjArr) {
            Map<String, Long> newEntityNumberVersionMap;
            Object org = dynamicObject.get("adminorg.boid");
            LOG.info(String.format("==setBeforeAndAfterChgVersionId==org:%s", org));
            if (org == null) {
                LOG.info(String.format("==setBeforeAndAfterChgVersionId==dynamicObject:%s", dynamicObject));
                continue;
            }
            long orgId = (Long)org;
            if (!ObjectUtils.isEmpty(oldOrgRelateVersionMap)) {
                Map<String, Long> oldEntityNumberVersionMap = oldOrgRelateVersionMap.get(orgId);
                dynamicObject.set("beforebaseinfoid", (Object)oldEntityNumberVersionMap.get(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey()));
                dynamicObject.set("beforestructid", (Object)oldEntityNumberVersionMap.get(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey()));
                dynamicObject.set("beforedepartmentid", (Object)oldEntityNumberVersionMap.get(AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey()));
                dynamicObject.set("beforecompanyid", (Object)oldEntityNumberVersionMap.get(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey()));
                dynamicObject.set("beforegroupid", (Object)oldEntityNumberVersionMap.get(AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey()));
            }
            if (!ObjectUtils.isEmpty(oldOrgBasicInfo)) {
                dynamicObject.set("oriparentorg", (Object)oldOrgBasicInfo.get(orgId).getLong("parentorg.id"));
                dynamicObject.set("orgoriname", (Object)oldOrgBasicInfo.get(orgId).getString("name"));
            }
            if (ObjectUtils.isEmpty(newOrgRelateVersionMap) || ObjectUtils.isEmpty(newEntityNumberVersionMap = newOrgRelateVersionMap.get(orgId))) continue;
            dynamicObject.set("afterbaseinfoid", (Object)newEntityNumberVersionMap.get(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey()));
            dynamicObject.set("afterstructid", (Object)newEntityNumberVersionMap.get(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey()));
            dynamicObject.set("afterdepartmentid", (Object)newEntityNumberVersionMap.get(AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey()));
            dynamicObject.set("aftercompanyid", (Object)newEntityNumberVersionMap.get(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey()));
            dynamicObject.set("aftergroupid", (Object)newEntityNumberVersionMap.get(AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey()));
        }
    }

    public void saveAttachments(DynamicObject dataEntity, String entityTypeName) {
        long billId = dataEntity.getLong("id");
        long orgId = dataEntity.getLong("orgid");
        HRBaseServiceHelper attachmentServiceHelper = new HRBaseServiceHelper("bos_attachment");
        Object[] oldAttachments = this.getAttachmentsByCondition(attachmentServiceHelper, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), String.valueOf(orgId), null, Boolean.FALSE);
        ArrayList<DynamicObject> attachments = new ArrayList<DynamicObject>(4);
        if (!ObjectUtils.isEmpty((Object[])oldAttachments)) {
            DynamicObject[] updatedAttachments;
            Map<String, DynamicObject> attachmentMap = Stream.of(oldAttachments).collect(Collectors.toMap(dy -> dy.getString("fnumber"), dy -> dy));
            for (DynamicObject attachment : updatedAttachments = this.getAttachmentsByCondition(attachmentServiceHelper, null, null, attachmentMap.keySet(), Boolean.TRUE)) {
                DynamicObject dynamicObject = attachmentMap.get(attachment.getString("fnumber"));
                long id = 0L;
                if (!Objects.nonNull(dynamicObject) || (id = dynamicObject.getLong("id")) == attachment.getLong("id")) continue;
                DynamicObjectUtils.copy((DynamicObject)attachment, (DynamicObject)dynamicObject, this.getAttachCopyIgnoreKeys());
                dynamicObject.set("id", (Object)id);
                attachments.add(dynamicObject);
            }
        }
        DynamicObject[] dynamicObjectArr = this.getAttachmentsByCondition(attachmentServiceHelper, entityTypeName, String.valueOf(billId), null, Boolean.FALSE);
        long[] ids = new long[]{};
        int index = 0;
        if (dynamicObjectArr.length > 0) {
            ids = ORM.create().genLongIds("bos_attachment", dynamicObjectArr.length);
        }
        for (DynamicObject dynamicObject : dynamicObjectArr) {
            DynamicObject emptyDynamicObject = attachmentServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)emptyDynamicObject);
            emptyDynamicObject.set("id", (Object)ids[index++]);
            emptyDynamicObject.set("finterid", (Object)orgId);
            emptyDynamicObject.set("fbilltype", (Object)"haos_adminorgdetail");
            attachments.add(emptyDynamicObject);
        }
        attachmentServiceHelper.save(attachments.toArray(new DynamicObject[0]));
    }

    private DynamicObject[] getAttachmentsByCondition(HRBaseServiceHelper attachmentServiceHelper, String fBillTypeValue, String fInterIdValue, Set<String> fNumberSet, Boolean fnumberAsFilter) {
        QFilter filter;
        if (fnumberAsFilter.booleanValue()) {
            filter = new QFilter("fnumber", "in", fNumberSet);
        } else {
            filter = new QFilter("fbilltype", "=", (Object)fBillTypeValue);
            filter.and("finterid", "=", (Object)fInterIdValue);
        }
        return attachmentServiceHelper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    private Set<String> getAttachCopyIgnoreKeys() {
        HashSet<String> set = new HashSet<String>(4);
        set.add("fnumber");
        set.add("finterid");
        set.add("fbilltype");
        set.add("fcreatetime");
        set.add("fcreatemen");
        return set;
    }
}

