/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.domain.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class AdminOrgReviseLogHelper {
    private static final Map<String, EnabledLang> ENABLE_LANG = ((IInteService)ServiceFactory.getService(IInteService.class)).getEnabledLang().stream().collect(Collectors.toMap(EnabledLang::getNumber, lang -> lang));

    public static Map<String, Map<String, IDataEntityProperty>> getPropertyNameFromEntity(Set<String> reviseEntityNameSet) {
        HashMap entityDisplayNameMap = Maps.newHashMapWithExpectedSize((int)16);
        reviseEntityNameSet.forEach(entityName -> {
            MainEntityType chargeMainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            Map<String, IDataEntityProperty> displayNameMap = chargeMainEntityType.getProperties().stream().filter(prop -> HRStringUtils.isNotEmpty((String)prop.getName())).collect(Collectors.toMap(IMetadata::getName, prop -> prop, (v1, v2) -> v2));
            entityDisplayNameMap.put(entityName, displayNameMap);
        });
        return entityDisplayNameMap;
    }

    public static String getFieldValueByProperty(DynamicObject dynamicObject, IDataEntityProperty property) {
        if (dynamicObject == null) {
            return "";
        }
        String propertyName = property.getName();
        if (property instanceof MuliLangTextProp) {
            ILocaleString localeString = dynamicObject.getLocaleString(propertyName);
            StringBuilder valueStr = new StringBuilder();
            for (Map.Entry entry : localeString.entrySet()) {
                String langCode = (String)entry.getKey();
                String localeValue = (String)entry.getValue();
                if (HRStringUtils.isEmpty((String)localeValue) || ENABLE_LANG.get(langCode) == null) continue;
                valueStr.append(localeValue).append("(").append(ENABLE_LANG.get(langCode).getLangCode()).append(")");
                valueStr.append(",");
            }
            if (valueStr.length() > 0) {
                return valueStr.subSequence(0, valueStr.lastIndexOf(",")).toString();
            }
        } else {
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                return comboProp.getItemByName(dynamicObject.getString(propertyName));
            }
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                DynamicObject reviseAfterFieldValue = dynamicObject.getDynamicObject(propertyName);
                if (reviseAfterFieldValue != null) {
                    return reviseAfterFieldValue.getString(basedataProp.getDisplayProp());
                }
            } else {
                if (property instanceof MulBasedataProp) {
                    return dynamicObject.getDynamicObjectCollection(propertyName).stream().map(dy -> dy.getString("fbasedataid.name")).collect(Collectors.joining("\uff0c"));
                }
                if (property instanceof DateTimeProp) {
                    Date date = dynamicObject.getDate(propertyName);
                    if (date != null) {
                        return HRInteDateTimeUtil.formatDate((String)dynamicObject.getDataEntityType().getName(), (String)propertyName, (Date)date);
                    }
                } else {
                    if (property instanceof BooleanProp) {
                        boolean value = dynamicObject.getBoolean(propertyName);
                        return value ? ResManager.loadKDString((String)"\u662f", (String)"AdminOrgReviseLogHelper_1", (String)"odc-homs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"AdminOrgReviseLogHelper_2", (String)"odc-homs-business", (Object[])new Object[0]);
                    }
                    return dynamicObject.getString(propertyName);
                }
            }
        }
        return "";
    }

    public static List<String> getSelectOrgIds(IFormView formView) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        String adminOrgIdStr = (String)formShowParameter.getCustomParam("adminOrgIds");
        if (HRStringUtils.isNotEmpty((String)adminOrgIdStr)) {
            return JSON.parseArray((String)adminOrgIdStr, String.class);
        }
        return null;
    }
}

