/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.domain.service.impl.orgfast;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.OtherRepository;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.homs.business.service.domain.repository.AdminOrgReviseLogRepository;
import kd.hr.homs.business.service.domain.service.orgfast.IReviseLogService;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.business.service.utils.PatternUtil;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.constants.fastchg.AdminOrgReviseLogConstants;
import kd.hr.homs.common.model.ReviseLogEntity;
import kd.hr.homs.common.model.ReviseLogVO;

public class ReviseLogServiceImpl
implements IReviseLogService {
    private Map<String, List<String>> compareMap;

    @Override
    public void saveLog(ReviseLogEntity logEntity, Map<Long, List<Long>> sceneSubMap) {
        List reviseLogList = logEntity.getReviseLogList();
        if (CollectionUtils.isEmpty((Collection)reviseLogList)) {
            return;
        }
        Map<String, List<ReviseLogVO>> map = reviseLogList.stream().collect(Collectors.groupingBy(ReviseLogVO::getEntityName));
        List<ReviseLogVO> orgLogList = map.get("haos_adminorgdetail");
        DynamicObject logDy = this.buildLogDy(logEntity);
        DynamicObjectCollection subCol = logDy.getDynamicObjectCollection("entryentity");
        this.buildOrgDetailLog(subCol, orgLogList);
        this.addDetailLog(subCol, map.get("haos_adminorggroup"), this.getCompareProperties("haos_adminorggroup"));
        this.addDetailLog(subCol, map.get("haos_adminorgcompany"), this.getCompareProperties("haos_adminorgcompany"));
        this.addDetailLog(subCol, map.get("haos_adminorgdepartment"), this.getCompareProperties("haos_adminorgdepartment"));
        if (subCol.size() == 0) {
            return;
        }
        subCol.forEach(entryDy -> {
            if ("establishmentdate".equals(entryDy.getString("revisefieldname"))) {
                entryDy.set("seq", (Object)(subCol.size() + 3));
            }
        });
        this.saveOrgEntry(logDy.getDynamicObjectCollection("orgentryentity"), logEntity.getReviseDy().getLong("id"), sceneSubMap);
        AdminOrgReviseLogRepository.getInstance().save(new DynamicObject[]{logDy});
    }

    @Override
    public Map<Long, List<Long>> getSceneSubMap(ReviseLogEntity logEntity) {
        List reviseLogList = logEntity.getReviseLogList();
        if (CollectionUtils.isEmpty((Collection)reviseLogList)) {
            return new HashMap<Long, List<Long>>(0);
        }
        Map<String, List<ReviseLogVO>> map = reviseLogList.stream().collect(Collectors.groupingBy(ReviseLogVO::getEntityName));
        List<ReviseLogVO> orgLogList = map.remove("haos_adminorgdetail");
        Map<Long, List<Long>> sceneSubMap = this.getOrgSceneSub(orgLogList);
        Long sceneSub = 0L;
        for (Map.Entry<String, List<ReviseLogVO>> entry : map.entrySet()) {
            ReviseLogVO logVO;
            List<String> changeList;
            if (CollectionUtils.isEmpty((Collection)entry.getValue()) || CollectionUtils.isEmpty(changeList = OrgChgUtil.getChangeProperties((logVO = entry.getValue().get(0)).getBeforeDy(), logVO.getAfterDy(), this.getCompareProperties(logVO.getEntityName())))) continue;
            sceneSub = ChangeTransactionConstants.SCENE_SUB_CHANGE;
            break;
        }
        if (sceneSub == 0L) {
            return sceneSubMap;
        }
        if (CollectionUtils.isEmpty(sceneSubMap)) {
            sceneSubMap.put(logEntity.getReviseDy().getLong("id"), Lists.newArrayListWithCapacity((int)1));
        }
        for (Map.Entry<Object, List<Object>> entry : sceneSubMap.entrySet()) {
            if (entry.getValue().contains(sceneSub)) continue;
            entry.getValue().add(sceneSub);
        }
        return sceneSubMap;
    }

    private void buildOrgDetailLog(DynamicObjectCollection sub, List<ReviseLogVO> orgLogList) {
        if (CollectionUtils.isEmpty(orgLogList)) {
            return;
        }
        ReviseLogVO orgLogVO = orgLogList.get(orgLogList.size() - 1);
        ArrayList compareProperties = Lists.newArrayList(this.getCompareProperties(orgLogVO.getEntityName()));
        if (orgLogList.size() != 1) {
            compareProperties.remove("belongcompany");
        }
        List<String> properties = OrgChgUtil.getChangeProperties(orgLogVO.getBeforeDy(), orgLogVO.getAfterDy(), compareProperties);
        this.addDetailLog(sub, properties, orgLogVO, orgLogList.stream().map(dy -> dy.getAfterDy().getLong("id")).collect(Collectors.toList()));
        if (orgLogList.size() != 1) {
            this.addDetailLog(sub, orgLogList, Collections.singletonList("belongcompany"));
        }
    }

    private void addDetailLog(DynamicObjectCollection sub, List<ReviseLogVO> logList, List<String> compareProperties) {
        if (CollectionUtils.isEmpty(logList)) {
            return;
        }
        for (ReviseLogVO logVO : logList) {
            List<String> properties = OrgChgUtil.getChangeProperties(logVO.getBeforeDy(), logVO.getAfterDy(), compareProperties);
            this.addDetailLog(sub, properties, logVO, Collections.singletonList(logVO.getAfterDy().getLong("id")));
        }
    }

    private void addDetailLog(DynamicObjectCollection subDyCol, List<String> properties, ReviseLogVO logVO, List<Long> afterIdList) {
        int seq = subDyCol.size() == 0 ? 0 : subDyCol.size();
        for (String property : properties) {
            DynamicObject detailDy = new DynamicObject(subDyCol.getDynamicObjectType());
            detailDy.set("reviseentityname", (Object)logVO.getEntityName());
            detailDy.set("revisefieldname", (Object)property);
            detailDy.set("revisebefore", (Object)(logVO.getBeforeDy() == null ? 0L : logVO.getBeforeDy().getLong("id")));
            this.setMulValue(afterIdList, detailDy.getDynamicObjectCollection("reviseafter"));
            detailDy.set("seq", (Object)(++seq));
            detailDy.set("entrycreator", (Object)RequestContext.get().getCurrUserId());
            subDyCol.add((Object)detailDy);
        }
    }

    private Map<Long, List<Long>> getOrgSceneSub(List<ReviseLogVO> logList) {
        if (CollectionUtils.isEmpty(logList)) {
            return new HashMap<Long, List<Long>>(1);
        }
        ArrayList compareProperties = Lists.newArrayList(this.getCompareProperties("haos_adminorgdetail"));
        compareProperties.remove("belongcompany");
        List<String> belongCompanyCompare = Collections.singletonList("belongcompany");
        ReviseLogVO reviseLogVO = logList.get(logList.size() - 1);
        List<String> commonChangedList = OrgChgUtil.getChangeProperties(reviseLogVO.getBeforeDy(), reviseLogVO.getAfterDy(), compareProperties);
        HashMap<Long, List<Long>> sceneSubMap = new HashMap<Long, List<Long>>(logList.size());
        for (ReviseLogVO logVO : logList) {
            ArrayList changeList = Lists.newArrayList(commonChangedList);
            changeList.addAll(OrgChgUtil.getChangeProperties(logVO.getBeforeDy(), logVO.getAfterDy(), belongCompanyCompare));
            sceneSubMap.put(logVO.getAfterDy().getLong("id"), this.getSceneSub(new HashSet<String>(changeList)));
        }
        return sceneSubMap;
    }

    private void saveOrgEntry(DynamicObjectCollection subDyCol, long beforeId, Map<Long, List<Long>> sceneSubMap) {
        int seq = 0;
        for (Map.Entry<Long, List<Long>> entry : sceneSubMap.entrySet()) {
            DynamicObject orgDy = new DynamicObject(subDyCol.getDynamicObjectType());
            orgDy.set("beforeorg", (Object)beforeId);
            orgDy.set("afterorg", (Object)entry.getKey());
            orgDy.set("seq", (Object)(++seq));
            this.setMulValue(entry.getValue(), orgDy.getDynamicObjectCollection("scenesub"));
            subDyCol.add((Object)orgDy);
        }
    }

    private DynamicObject buildLogDy(ReviseLogEntity logEntity) {
        DynamicObject logDy = AdminOrgReviseLogRepository.getInstance().generateEmptyDy();
        logDy.set("event", (Object)logEntity.getEventId());
        logDy.set("changescene", (Object)this.buildBaseDy("haos_changescene", OrgBatchChgBillConstants.CHANGE_SCENE_REVISE));
        logDy.set("changetype", (Object)this.buildBaseDy("haos_orgchangetype", OrgBatchChgBillConstants.CHANGE_TYPE_REVISE));
        logDy.set("changeoperate", (Object)this.buildBaseDy("haos_changeoperat", AdminOrgReviseLogConstants.CHANGE_OPERAT_REVISE));
        logDy.set("revisereason", (Object)logEntity.getReviseDy().getLong("changereason.id"));
        logDy.set("adminorgbo", (Object)logEntity.getReviseDy().getLong("boid"));
        logDy.set("reviseexplain", logEntity.getReviseDy().get("reviseexplain"));
        logDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        return logDy;
    }

    private DynamicObject buildBaseDy(String entityName, Long id) {
        DynamicObject baseDy = OtherRepository.getInstance().generateEmptyDy(entityName);
        baseDy.set("id", (Object)id);
        return baseDy;
    }

    private List<Long> getSceneSub(Set<String> changeSet) {
        ArrayList subList = Lists.newArrayListWithExpectedSize((int)changeSet.size());
        if (CollectionUtils.isEmpty(changeSet)) {
            return subList;
        }
        if (changeSet.remove("tobedisableflag")) {
            subList.add(ChangeTransactionConstants.SCENE_SUB_TOBE_DISABLE);
        }
        if (changeSet.remove("name")) {
            subList.add(ChangeTransactionConstants.SCENE_SUB_NAME);
        }
        if (changeSet.remove("parentorg")) {
            subList.add(ChangeTransactionConstants.SCENE_SUB_TOBE_PARENT);
        }
        if (changeSet.remove("mainduty")) {
            subList.add(ChangeTransactionConstants.SCENE_SUB_MAINDUTY);
        }
        if (changeSet.remove("corporateorg")) {
            subList.add(ChangeTransactionConstants.SCENE_SUB_CORPORATE_ORG);
        }
        if (changeSet.remove("belongcompany")) {
            subList.add(ChangeTransactionConstants.SCENE_SUB_BELONG_COMPANY);
        }
        if (changeSet.remove("establishmentdate")) {
            subList.add(ChangeTransactionConstants.SCENE_SUB_ESTABLISHMENT_DATE);
        }
        if (changeSet.remove("org")) {
            subList.add(ChangeTransactionConstants.SCENE_SUB_ORG);
        }
        if (changeSet.size() > 0) {
            subList.add(ChangeTransactionConstants.SCENE_SUB_CHANGE);
        }
        return subList;
    }

    private void setMulValue(List<Long> list, DynamicObjectCollection mulCol) {
        list.forEach(sub -> {
            DynamicObject changeOperateObj = new DynamicObject(mulCol.getDynamicObjectType());
            changeOperateObj.set("fbasedataid", sub);
            mulCol.add((Object)changeOperateObj);
        });
    }

    private List<String> getCompareProperties(String entityName) {
        List<String> properties;
        if (this.compareMap == null) {
            this.compareMap = new HashMap<String, List<String>>(4);
        }
        if ((properties = this.compareMap.get(entityName)) == null) {
            switch (entityName) {
                case "haos_adminorgdetail": {
                    properties = this.initBaseProperties();
                    break;
                }
                case "haos_adminorggroup": {
                    properties = this.initGroupProperties();
                    break;
                }
                case "haos_adminorgcompany": {
                    properties = this.initCompanyProperties();
                    break;
                }
                case "haos_adminorgdepartment": {
                    properties = this.initDeptProperties();
                    break;
                }
                default: {
                    throw new KDBizException("not compare properties");
                }
            }
            this.compareMap.put(entityName, properties);
        }
        return properties;
    }

    private List<String> initGroupProperties() {
        return Arrays.asList("groupvision", "groupmission", "groupleader");
    }

    private List<String> initCompanyProperties() {
        return Arrays.asList("companytype", "industrytype");
    }

    private List<String> initDeptProperties() {
        return Collections.singletonList("departmenttype");
    }

    private List<String> initBaseProperties() {
        ArrayList compareProperties = Lists.newArrayListWithExpectedSize((int)20);
        compareProperties.addAll(Arrays.asList("number", "name", "simplename", "establishmentdate", "adminorgtype", "parentorg", "belongcompany", "corporateorg", "adminorglayer", "adminorgfunction", "tobedisableflag", "tobedisabledate", "enable", "companyarea", "city", "workplace", "detailaddress", "description", "index", "positioning", "mainduty", "safelevel", "safetype", "safedescription"));
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_adminorgdetail");
        Map allFields = mainEntityType.getAllFields();
        for (String property : allFields.keySet()) {
            if (!PatternUtil.isExProperty(property)) continue;
            compareProperties.add(property);
        }
        return compareProperties;
    }
}

