/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.domain.service.orgfast;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.domain.repository.OrgReviseFieldConfigRepository;
import kd.hr.homs.business.service.repository.HOMSAdminOrgRepository;

public class AdminOrgReviseService {
    private Map<String, EntityItem> fieldKeyNameMap;
    private String selectFields;

    public AdminOrgReviseService() {
        this.initFieldData();
    }

    public DynamicObject[] getHisVersions(Long orgId) {
        return HOMSAdminOrgRepository.getInstance().getDynamicObjectArrOrderDesc(orgId, this.selectFields);
    }

    private List<String> getMustField() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("id");
        fieldList.add("bsed");
        fieldList.add("bsled");
        fieldList.add("datastatus");
        return fieldList;
    }

    private List<String> getSettingField() {
        DynamicObject[] fieldSet = OrgReviseFieldConfigRepository.getInstance().queryAllField();
        return Arrays.stream(fieldSet).map(o -> o.getString("number")).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getFieldShowList(DynamicObject his, Map<Long, List<DynamicObject>> parentOrgHisMap) {
        ArrayList fieldKeyValueList = Lists.newArrayListWithExpectedSize((int)8);
        for (Map.Entry<String, EntityItem> entry : this.fieldKeyNameMap.entrySet()) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            String fieldKey = entry.getKey();
            EntityItem item = entry.getValue();
            fieldMap.put("fieldkey", item.getName().getLocaleValue());
            if (fieldKey.equals("parentorg")) {
                fieldMap.put("fieldvalue", this.getParentHisName(parentOrgHisMap, his));
            } else {
                fieldMap.put("fieldvalue", this.getFieldValue(his, fieldKey, this.fieldKeyNameMap));
            }
            fieldKeyValueList.add(fieldMap);
        }
        return fieldKeyValueList;
    }

    private Map<Long, List<DynamicObject>> getParentOrgHis(DynamicObject[] orgHisArr) {
        DynamicObject[] parentDyArr;
        HashMap parentMap = Maps.newHashMap();
        List<Long> parentBoIds = Arrays.asList(orgHisArr).stream().filter(dynamicObject -> dynamicObject.getDynamicObject("parentorg") != null).map(dynamicObject -> dynamicObject.getDynamicObject("parentorg").getLong("id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(parentBoIds)) {
            return parentMap;
        }
        for (DynamicObject parentDy : parentDyArr = HOMSAdminOrgRepository.getInstance().getDynamicObjectArrByBoIds(parentBoIds)) {
            Long parentBoId = parentDy.getLong("boid");
            if (parentMap.containsKey(parentBoId)) {
                ((List)parentMap.get(parentBoId)).add(parentDy);
                continue;
            }
            ArrayList parentList = Lists.newArrayList();
            parentList.add(parentDy);
            parentMap.put(parentBoId, parentList);
        }
        return parentMap;
    }

    private String getParentHisName(Map<Long, List<DynamicObject>> parentMap, DynamicObject orgHisDy) {
        String parentName;
        String string = parentName = orgHisDy.getDynamicObject("parentorg") != null ? orgHisDy.getDynamicObject("parentorg").getString("name") : "";
        if (orgHisDy.getDynamicObject("parentorg") != null) {
            Long parentBoId = orgHisDy.getDynamicObject("parentorg").getLong("id");
            Date bsed = orgHisDy.getDate("bsed");
            if (parentMap.containsKey(parentBoId)) {
                List<DynamicObject> parentList = parentMap.get(parentBoId);
                for (DynamicObject parentDy : parentList) {
                    Date parentBsed = parentDy.getDate("bsed");
                    Date parentBsled = parentDy.getDate("bsled");
                    if (parentBsed.compareTo(bsed) > 0 || parentBsled.compareTo(bsed) < 0) continue;
                    parentName = parentDy.getString("name");
                }
            }
        }
        return parentName;
    }

    private Object getFieldValue(DynamicObject his, String fieldKey, Map<String, EntityItem> fieldKeyNameMap) {
        EntityItem field = fieldKeyNameMap.get(fieldKey);
        if (field instanceof MulBasedataField) {
            DynamicObjectCollection mulBasedata = his.getDynamicObjectCollection(field.getKey());
            ArrayList<String> values = new ArrayList<String>();
            for (DynamicObject data : mulBasedata) {
                values.add(data.getDynamicObject("fbasedataid").getString(((MulBasedataField)field).getDisplayProp()));
            }
            return String.join((CharSequence)"\uff1b", values);
        }
        if (field instanceof DateTimeField) {
            return HRInteDateTimeUtil.formatDate((String)his.getDataEntityType().getName(), (String)field.getKey(), (Date)his.getDate(field.getKey()));
        }
        if (field instanceof BasedataField) {
            return his.getString(field.getKey() + "." + ((BasedataField)field).getDisplayProp());
        }
        if (field instanceof ComboField) {
            String hisValue = his.getString(field.getKey());
            Map<String, String> valueToDisplayValueMap = ((ComboField)field).getItems().stream().collect(Collectors.toMap(ComboItem::getValue, o -> o.getCaption().getLocaleValue()));
            return valueToDisplayValueMap.get(hisValue);
        }
        return his.getString(field.getKey());
    }

    public void customControlData(DynamicObject[] hisVersions, String selectId, IFormView view, String eventName, String eventStatus) {
        ArrayList<Map<String, Object>> initData = new ArrayList<Map<String, Object>>(hisVersions.length);
        Map<Long, List<DynamicObject>> parentOrgHisMap = this.getParentOrgHis(hisVersions);
        for (DynamicObject his : hisVersions) {
            Map<String, Object> dataMap = this.assembleCustomControData(his, selectId, parentOrgHisMap);
            initData.add(dataMap);
        }
        this.setDataToCustomControl(initData, eventStatus, eventName, view, selectId);
    }

    private void setDataToCustomControl(Object data, String eventStatus, String eventName, IFormView view, String selectId) {
        Map<String, Object> controlData = this.buildCustomControlData(data, eventStatus, eventName);
        CustomControl customcontrol = (CustomControl)view.getControl("customcontrolap");
        customcontrol.setData(controlData);
    }

    private Map<String, Object> assembleCustomControData(DynamicObject his, String selectId, Map<Long, List<DynamicObject>> parentOrgHisMap) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("id", his.getString("id"));
        dataMap.put("bsed", HRInteDateTimeUtil.formatDate((String)his.getDataEntityType().getName(), (String)"bsed", (Date)his.getDate("bsed")));
        if (HRStringUtils.equals((String)his.getString("datastatus"), (String)"1")) {
            dataMap.put("bsled", ResManager.loadKDString((String)"\u81f3\u4eca", (String)"AdminorgRevisePlugin_1", (String)"odc-homs-business", (Object[])new Object[0]));
        } else {
            dataMap.put("bsled", HRInteDateTimeUtil.formatDate((String)his.getDataEntityType().getName(), (String)"bsled", (Date)his.getDate("bsled")));
        }
        dataMap.put("isselect", HRStringUtils.equals((String)his.getString("id"), (String)selectId) ? 1 : 0);
        dataMap.put("filedData", this.getFieldShowList(his, parentOrgHisMap));
        return dataMap;
    }

    private void initFieldData() {
        this.fieldKeyNameMap = new LinkedHashMap<String, EntityItem>();
        List<String> settingFieldList = this.getSettingField();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"haos_adminorgdetail", (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
        for (String settingField : settingFieldList) {
            for (EntityItem item : entityMetadata.getItems()) {
                if (!HRStringUtils.equals((String)settingField, (String)item.getKey())) continue;
                this.fieldKeyNameMap.put(item.getKey(), item);
            }
        }
        HashSet<String> selectFieldSet = new HashSet<String>();
        selectFieldSet.addAll(this.fieldKeyNameMap.keySet());
        selectFieldSet.addAll(this.getMustField());
        this.selectFields = String.join((CharSequence)",", selectFieldSet);
    }

    private Map<String, Object> buildCustomControlData(Object data, String eventStatus, String eventName) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("data", data);
        dataMap.put("code", "200");
        dataMap.put("errorMessage", "");
        dataMap.put("eventStatus", eventStatus);
        dataMap.put("eventName", eventName);
        dataMap.put("time", System.currentTimeMillis());
        return dataMap;
    }
}

