/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.enums;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.model.MultiLangEnumBridge;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.ext.function.DefaultOrgBatchBillServiceExtend;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.sdk.odc.homs.service.IOrgBatchBillServiceExtend;

public enum EntryEntityEnum {
    addEntry("entryentity_add", "add", new MultiLangEnumBridge("\u65b0\u8bbe\u7ec4\u7ec7", "EntryEntityEnum_0", "odc-homs-business"), OrgBatchChgBillConstants.CHANGE_TYPE_ADD),
    parentEntry("entryentity_parent", "parent", new MultiLangEnumBridge("\u8c03\u6574\u4e0a\u7ea7", "EntryEntityEnum_1", "odc-homs-business"), OrgBatchChgBillConstants.CHANGE_TYPE_PARENT),
    infoEntry("entryentity_info", "info", new MultiLangEnumBridge("\u53d8\u66f4\u4fe1\u606f", "EntryEntityEnum_2", "odc-homs-business"), OrgBatchChgBillConstants.CHANGE_TYPE_INFO),
    disableEntry("entryentity_disable", "disable", new MultiLangEnumBridge("\u505c\u7528\u7ec4\u7ec7", "EntryEntityEnum_3", "odc-homs-business"), OrgBatchChgBillConstants.CHANGE_SCENE_DISABLE),
    mergeEntry("entryentity_merge", "merge", new MultiLangEnumBridge("\u5408\u5e76\u7ec4\u7ec7", "EntryEntityEnum_4", "odc-homs-business"), OrgBatchChgBillConstants.CHANGE_TYPE_MERGE),
    splitEntry("entryentity_split", "split", new MultiLangEnumBridge("\u62c6\u5206\u7ec4\u7ec7", "EntryEntityEnum_5", "odc-homs-business"), OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT);

    private String entryKey;
    private String changeType;
    private MultiLangEnumBridge entryNameBridge;
    private Long changeTypeId;

    private EntryEntityEnum(String entryKey, String changeType, MultiLangEnumBridge entryNameBridge, Long changeTypeId) {
        this.entryKey = entryKey;
        this.changeType = changeType;
        this.entryNameBridge = entryNameBridge;
        this.changeTypeId = changeTypeId;
    }

    public String getEntryKey() {
        return this.entryKey;
    }

    public void setEntryKey(String entryKey) {
        this.entryKey = entryKey;
    }

    public String getChangeType() {
        return this.changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getEntryName() {
        return this.entryNameBridge.loadKDString();
    }

    public Long getChangeTypeId() {
        return this.changeTypeId;
    }

    public void setChangeTypeId(Long changeTypeId) {
        this.changeTypeId = changeTypeId;
    }

    public static List<String> getEntryKeys() {
        EntryEntityEnum[] enums = EntryEntityEnum.values();
        ArrayList<String> list = new ArrayList<String>(enums.length);
        for (EntryEntityEnum entryEnum : enums) {
            list.add(entryEnum.getEntryKey());
        }
        return list;
    }

    public static List<String> getEntryKeysWithExt() {
        List<String> entryKeys = EntryEntityEnum.getEntryKeys();
        PluginProxy extendPluginProxy = PluginProxy.create((Object)new DefaultOrgBatchBillServiceExtend(), IOrgBatchBillServiceExtend.class, (String)"kd.hr.homs.business.service.ext.function.DefaultOrgBatchBillServiceExtend");
        extendPluginProxy.callReplace(plugin -> {
            Map entityParamMap = plugin.getBatchBillExtendParam();
            if (!CollectionUtils.isEmpty((Map)entityParamMap)) {
                entityParamMap.forEach((entityName, param) -> {
                    if (!CollectionUtils.isEmpty((Map)param) && !ObjectUtils.isEmpty(param.get("entryentity"))) {
                        entryKeys.add((String)param.get("entryentity"));
                    }
                });
            }
            return null;
        });
        return entryKeys;
    }

    public static String getEntryKeyByChangeTypeIdWithExt(Long changeTypeId) {
        EntryEntityEnum[] enums;
        for (EntryEntityEnum entryEnum : enums = EntryEntityEnum.values()) {
            if (!entryEnum.getChangeTypeId().equals(changeTypeId)) continue;
            return entryEnum.getEntryKey();
        }
        PluginProxy extendPluginProxy = PluginProxy.create((Object)new DefaultOrgBatchBillServiceExtend(), IOrgBatchBillServiceExtend.class, (String)"kd.hr.homs.business.service.ext.function.DefaultOrgBatchBillServiceExtend");
        AtomicReference<String> entryEntity = new AtomicReference<String>("");
        extendPluginProxy.callReplace(plugin -> {
            Map entityParamMap = plugin.getBatchBillExtendParam();
            if (!CollectionUtils.isEmpty((Map)entityParamMap)) {
                for (Map.Entry entry : entityParamMap.entrySet()) {
                    Long changeTypeIdExt;
                    Map param = (Map)entry.getValue();
                    if (CollectionUtils.isEmpty((Map)param) || !changeTypeId.equals(changeTypeIdExt = (Long)param.get("changetype"))) continue;
                    entryEntity.set((String)param.get("entryentity"));
                }
            }
            return null;
        });
        return entryEntity.get();
    }

    public static String getPrefixByEntryKey(String entryKey) {
        EntryEntityEnum[] enums;
        for (EntryEntityEnum entryEnum : enums = EntryEntityEnum.values()) {
            if (!HRStringUtils.equals((String)entryEnum.getEntryKey(), (String)entryKey)) continue;
            return entryEnum.getChangeType() + "_";
        }
        return null;
    }

    public static String getEntryNameByChangeType(String changeType) {
        for (EntryEntityEnum entityEnum : EntryEntityEnum.values()) {
            if (!HRStringUtils.equals((String)entityEnum.getChangeType(), (String)changeType)) continue;
            return entityEnum.getEntryName();
        }
        return null;
    }
}

