/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.ext.function;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.business.util.cascade.MultiVersionCascadeHelper;
import kd.hr.haos.common.model.cascade.CascadeBo;
import kd.hr.haos.common.model.cascade.CascadeResult;
import kd.hr.homs.business.service.ext.function.CascadeParamModel;
import kd.hr.homs.business.service.ext.function.model.AdOrgExtendCascadeBo;
import kd.hr.homs.business.service.ext.function.model.AdOrgExtendPartBo;

public class CascadeExtendHelper {
    public static CascadeResult execute(List<DynamicObject> adminOrgList, CascadeParamModel cascadeParamModel) {
        List<CascadeBo> adOrgCascadeBos = adminOrgList.stream().map(dy -> {
            AdOrgExtendPartBo adOrgExtendPartBo = cascadeParamModel.getAdOrgPartBoSupplier().get();
            adOrgExtendPartBo.setVid(dy.getLong("id"));
            adOrgExtendPartBo.setEffectRange(LocalDateRangeUtils.getEffectRange((DynamicObject)dy));
            adOrgExtendPartBo.setCascadeValue((DynamicObject)dy);
            AdOrgExtendCascadeBo adOrgExtendCascadeBo = new AdOrgExtendCascadeBo();
            adOrgExtendCascadeBo.setBo(dy.getLong("boid"));
            adOrgExtendCascadeBo.setParentBo(dy.getLong("parentorg.id"));
            adOrgExtendCascadeBo.setEffectRange(LocalDateRangeUtils.getEffectRange((DynamicObject)dy));
            ArrayList<AdOrgExtendPartBo> adOrgExtendPartBoList = new ArrayList<AdOrgExtendPartBo>();
            adOrgExtendPartBoList.add(adOrgExtendPartBo);
            adOrgExtendCascadeBo.setAdOrgPartBo(adOrgExtendPartBoList);
            return adOrgExtendCascadeBo;
        }).collect(Collectors.toList());
        CascadeExtendHelper.check(adOrgCascadeBos);
        return MultiVersionCascadeHelper.getCascadeResult(adOrgCascadeBos);
    }

    private static void check(List<CascadeBo> adOrgCascadeBos) {
        adOrgCascadeBos.forEach(cascadeBo -> {
            long bo = cascadeBo.getBo();
            if (bo == 0L) {
                throw new RuntimeException("AdOrgCascadeBo's bo is not allow be 0, please check your code.");
            }
            cascadeBo.getPartCascadeBoFunctionList().forEach(partBoListFunction -> ((List)partBoListFunction.apply(cascadeBo)).forEach(partBo -> {
                long vid = partBo.getVid();
                if (vid == 0L) {
                    throw new RuntimeException("AdOrgPartBo's vid is not allow be 0, please check your code.");
                }
            }));
        });
    }
}

