/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgOpService;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.chgbill.AdminOrgChgBillSaveService;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.AdminOrgMagicHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgbatch.OrgBatchBillSaveHelper;
import kd.hr.homs.business.service.orgbatch.strategy.AdminOrgBatchViewStrategyContext;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;
import kd.hr.homs.business.service.validcommon.OrgBatchBillConverter;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.ChangeTypeEnum;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.ChgOrgInfoDto;
import kd.hr.homs.common.model.OrgCubeTreeNode;
import org.apache.commons.lang3.time.DateUtils;

public class AdminOrgBatchChartBaseHelper {
    public static HRBaseServiceHelper HOMS_BATCHORGENTITY_HELPER = new HRBaseServiceHelper("homs_batchorgentity");
    public static HRBaseServiceHelper HAOS_ADMINORGDETAIL_HELPER = new HRBaseServiceHelper("haos_adminorgdetail");

    public static void initChangeSceneAndReason(IFormView view, Long changeTypeId, Long orgId) {
        DynamicObject changeSceneDy = view.getModel().getDataEntity().getDynamicObject("changescene");
        if (changeSceneDy != null) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_changescene");
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)Character.valueOf('1'));
        filter.and("orgchangetype.id", "=", (Object)changeTypeId);
        filter.and(BaseDataHelper.getBaseDataFilter((String)"haos_changescene", (long)orgId));
        filter.and("id", "!=", (Object)OrgBatchChgBillConstants.CHANGE_SCENE_ENABLE);
        DynamicObject[] changeSceneDys = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        if (changeSceneDys.length == 1) {
            changeSceneDy = changeSceneDys[0];
        }
        if (changeSceneDy == null) {
            view.setEnable(Boolean.FALSE, new String[]{"changereason"});
            return;
        }
        view.getModel().setValue("changescene", (Object)changeSceneDy);
        AdminOrgBatchChartBaseHelper.initChangeReasonByChangeScene(view.getModel(), changeSceneDy, orgId);
    }

    public static void initChangeReasonByChangeScene(IDataModel model, DynamicObject changeSceneDy, Long orgId) {
        DynamicObjectCollection col = changeSceneDy.getDynamicObjectCollection("changereason");
        if (col.size() != 1) {
            return;
        }
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)Character.valueOf('1'));
        filter.and(BaseDataHelper.getBaseDataFilter((String)"haos_orgchangereason", (long)orgId));
        filter.and("id", "=", (Object)((DynamicObject)col.get(0)).getLong("fbasedataid.id"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_orgchangereason");
        DynamicObject changeReasonDy = helper.queryOne(new QFilter[]{filter});
        if (changeReasonDy != null) {
            model.setValue("changereason", (Object)changeReasonDy);
        }
    }

    public static ListShowParameter getListShowParameter(Set<Long> newOrgSet, Set<Long> excludeOrgSet, Long orgId, boolean treeFlag) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (treeFlag) {
            listShowParameter.setFormId("haos_orgbatchtreelistf7");
            listShowParameter.setBillFormId("haos_adminorgf7");
        } else {
            listShowParameter.setFormId("bos_listf7");
            listShowParameter.setBillFormId("haos_adminorgbatch");
        }
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"AdminorgFastChgPlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("1000px");
        cssValue.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(cssValue);
        listShowParameter.setLookUp(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setHasRight(true);
        List filterList = listShowParameter.getListFilterParameter().getQFilters();
        AdminOrgBatchChartBaseHelper.addOrgFilter(filterList, newOrgSet, excludeOrgSet, orgId, treeFlag);
        listShowParameter.setShowApproved(false);
        Date date = DateUtils.truncate((Date)new Date(), (int)5);
        listShowParameter.getCustomParams().put("searchdate", date);
        return listShowParameter;
    }

    public static void setF7OrgFilter(BeforeF7SelectEvent event, Set<Long> newOrgSet, Set<Long> excludeOrgSet, Long orgId) {
        AdminOrgBatchChartBaseHelper.addOrgFilter(event.getCustomQFilters(), newOrgSet, excludeOrgSet, orgId, true);
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        Date date = DateUtils.truncate((Date)new Date(), (int)5);
        formShowParameter.getCustomParams().put("searchdate", date);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"AdminorgFastChgPlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        formShowParameter.setShowApproved(false);
    }

    private static void addOrgFilter(List<QFilter> filterList, Set<Long> newOrgSet, Set<Long> excludeOrgSet, Long orgId, boolean treeFlag) {
        AuthorizedOrgResult permResult;
        filterList.add(new QFilter("enable", "=", (Object)"1"));
        filterList.add(new QFilter("isvirtualorg", "=", (Object)Boolean.FALSE));
        filterList.add(new QFilter("initstatus", "=", (Object)"2"));
        QFilter authFilter = null;
        if (!treeFlag && (permResult = AdminOrgBatchChgHelper.getOrgAuthByPermItemId("47156aff000000ac")) != null && !permResult.isHasAllOrgPerm()) {
            authFilter = new QFilter("boid", "in", (Object)permResult.getHasPermOrgs());
        }
        if (!CollectionUtils.isEmpty(excludeOrgSet)) {
            QFilter disableOrgFilter = new QFilter("id", "not in", excludeOrgSet);
            filterList.add(disableOrgFilter);
        }
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        Date effDate = DateUtils.truncate((Date)new Date(), (int)5);
        filterList.add(new QFilter("bsed", "<=", (Object)effDate));
        filterList.add(new QFilter("bsled", ">=", (Object)effDate));
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter isCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"0");
        if (!CollectionUtils.isEmpty(newOrgSet)) {
            QFilter newOrgFilter = new QFilter("id", "in", newOrgSet);
            if (authFilter != null) {
                authFilter.or(newOrgFilter);
            }
            dataStatusFilter.or(newOrgFilter);
            statusFilter.or(newOrgFilter);
            isCurrentVersion.or(newOrgFilter);
        }
        filterList.add(dataStatusFilter);
        filterList.add(statusFilter);
        filterList.add(isCurrentVersion);
        if (authFilter != null) {
            filterList.add(authFilter);
        }
        QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", Collections.singletonList(orgId));
        filterList.add(baseDataFilter);
    }

    public static void buildDisableEntityDy(DynamicObject dy, Long billId) {
        Long adminOrgId = dy.getDynamicObject("adminorg").getLong("id");
        Long boId = dy.getDynamicObject("adminorg").getLong("boid");
        HRBaseServiceHelper batchOrgEntityHelper = new HRBaseServiceHelper("homs_batchorgentity");
        DynamicObject entityDy = batchOrgEntityHelper.generateEmptyDynamicObject();
        List<Long> boIdList = Collections.singletonList(boId);
        Map<Long, DynamicObject> orgBoId2DepartmentDynMapDynMap = AdminOrgBatchChgHelper.getOrgId2DepartmentDynMap(boIdList);
        Map<Long, DynamicObject> orgBoId2CompanyDynMap = AdminOrgBatchChgHelper.getOrgId2CompanyDynMap(boIdList);
        Map<Long, DynamicObject> orgBoId2GroupDynMap = AdminOrgBatchChgHelper.getOrgId2GroupDynMap(boIdList);
        Map<Long, DynamicObject> orgId2BasicInfoDynMap = AdminOrgBatchChgHelper.getOrgId2BasicInfoDynMapByIds(Collections.singletonList(adminOrgId));
        Map<Long, List<DynamicObject>> orgBoId2CoopDynsMap = AdminOrgBatchChgHelper.getOrgId2CoopDynsMap(boIdList);
        OrgBatchBillSaveHelper helper = OrgBatchBillSaveHelper.getInstance();
        DynamicObject baseInfoDy = orgId2BasicInfoDynMap.get(adminOrgId);
        Map<String, DynamicObject> groupInfoMap = helper.buildGroupMap4OrgType(baseInfoDy.getLong("adminorgtype.adminorgtypestd.id"), boId, orgBoId2CompanyDynMap, orgBoId2GroupDynMap, orgBoId2DepartmentDynMapDynMap);
        helper.assembleSaveEntryDyn(entityDy, adminOrgId, baseInfoDy, groupInfoMap, orgBoId2CoopDynsMap.get(boId));
        entityDy.set("billid", (Object)billId);
        entityDy.set("changetype", (Object)OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE);
        entityDy.set("changescene", dy.get("changescene"));
        entityDy.set("changereason", dy.get("changereason"));
        entityDy.set("changedescription", dy.get("changedescription"));
        entityDy.set("mergesplitstatus", (Object)"0");
        batchOrgEntityHelper.save(new DynamicObject[]{entityDy});
    }

    public static List<OrgCubeTreeNode> initOrgNode(List<DynamicObject> list, DynamicObject targetOrg, IFormView view) {
        if (list == null) {
            list = new ArrayList<DynamicObject>();
        }
        Set orgIds = list.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        if (targetOrg != null && !orgIds.contains(targetOrg.getLong("id"))) {
            list.add(targetOrg);
        }
        return AdminOrgBatchChartBaseHelper.getOrgNodes(list, view);
    }

    public static List<OrgCubeTreeNode> getOrgNodes(List<DynamicObject> list, IFormView view) {
        if (list == null || list.isEmpty()) {
            return new ArrayList<OrgCubeTreeNode>();
        }
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        Set<Long> orgIdSet = list.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] unSaveAndDeleteDataArr = AdminOrgBatchChartBaseHelper.getUnSaveAndDeleteData(dataEntity.getLong("id"), orgIdSet, "adminorg,changetype,mergesplitstatus");
        Map<String, DynamicObject> unSaveAndDeleteDataMap = Arrays.stream(unSaveAndDeleteDataArr).collect(Collectors.toMap(data -> data.getString("adminorg.id"), data -> data));
        Map<String, Map<String, String>> map = AdminOrgBatchChartBaseHelper.convertEntryToMap(dataEntity);
        List<OrgCubeTreeNode> nodeList = list.stream().map(item -> {
            String id = item.getString("id");
            OrgCubeTreeNode node = new OrgCubeTreeNode(id, item.getString("name"));
            node.setMergeOrSplit("1");
            node.setHasPermission("1");
            if (unSaveAndDeleteDataMap.containsKey(id)) {
                DynamicObject unSaveAndDeleteData = (DynamicObject)unSaveAndDeleteDataMap.get(id);
                String mergeSplitStatus = unSaveAndDeleteData.getString("mergesplitstatus");
                if (HRStringUtils.equals((String)mergeSplitStatus, (String)"0")) {
                    node.setText(unSaveAndDeleteData.getString("name"));
                    node.setChangeType(ChangeTypeEnum.getNumberById((Long)unSaveAndDeleteData.getLong("changetype.id")));
                }
                return node;
            }
            if (map.containsKey(id)) {
                Map infoMap = (Map)map.get(id);
                node.setText((String)infoMap.get("name"));
                node.setOldName((String)infoMap.get("beforename"));
                node.setChangeType((String)infoMap.get("changetype"));
            }
            return node;
        }).collect(Collectors.toList());
        Date date = new Date();
        AdminOrgMagicHelper.setOrgInfo(nodeList, date);
        return nodeList;
    }

    private static Map<String, Map<String, String>> convertEntryToMap(DynamicObject dataEntity) {
        List<String> entryNamePrefixList = Arrays.asList("add", "parent", "info", "disable");
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        entryNamePrefixList.forEach(prefix -> {
            DynamicObjectCollection entities = dataEntity.getDynamicObjectCollection("entryentity_" + prefix);
            entities.forEach(entity -> {
                String orgId;
                String oldName = "";
                if (HRStringUtils.equals((String)prefix, (String)"add")) {
                    orgId = entity.getString("add_adminorg");
                } else {
                    orgId = entity.getString(prefix + "_adminorg.id");
                    oldName = entity.getString(prefix + "_adminorg.name");
                }
                String name = HRStringUtils.equals((String)prefix, (String)"disable") ? entity.getString(prefix + "_adminorg.name") : entity.getString(prefix + "_name");
                HashMap<String, String> infoMap = new HashMap<String, String>();
                infoMap.put("name", name);
                infoMap.put("beforename", oldName);
                infoMap.put("changetype", ChangeTypeEnum.getNumberById((Long)entity.getLong(prefix + "_changetype.id")));
                map.put(orgId, infoMap);
            });
        });
        return map;
    }

    public static void initOrgMerge(List<DynamicObject> list, DynamicObject targetOrg, IFormView view, String eventName) {
        OrgCubeTreeNode targetOrgNode;
        List<OrgCubeTreeNode> nodeList = AdminOrgBatchChartBaseHelper.getOrgNodes(list, view.getParentView());
        if (targetOrg == null) {
            targetOrgNode = null;
        } else {
            List<OrgCubeTreeNode> targetOrgNodes = AdminOrgBatchChartBaseHelper.getOrgNodes(Collections.singletonList(targetOrg), view.getParentView());
            targetOrgNode = targetOrgNodes.stream().findAny().orElse(null);
        }
        AdminOrgBatchChartBaseHelper.setMergeCustomData(nodeList, targetOrgNode, view, eventName);
    }

    private static void setMergeCustomData(List<OrgCubeTreeNode> nodeList, OrgCubeTreeNode targetOrgNode, IFormView view, String eventName) {
        Map map = nodeList.stream().collect(Collectors.groupingBy(node -> HRStringUtils.equals((String)node.getChangeType(), (String)ChangeTypeEnum.DISABLE.getNumber()), Collectors.toList()));
        List reservedAfterMergeList = map.get(Boolean.FALSE);
        List disableAfterMergeList = map.get(Boolean.TRUE);
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, List<Object>> mergeData = new HashMap<String, List<Object>>();
        mergeData.put("reservedAfterMerge", reservedAfterMergeList);
        mergeData.put("disableAfterMerge", disableAfterMergeList);
        mergeData.put("targetOrg", (List<Object>)targetOrgNode);
        mergeData.put("changeTypeVo", (List<Object>)AdminOrgMagicHelper.getOrgChangeTypeVo());
        data.put("data", mergeData);
        data.put("eventName", eventName);
        data.put("eventStatus", "init");
        data.put("code", "200");
        data.put("errorMessage", "");
        data.put("viewStatus", AdminOrgBatchChartBaseHelper.getViewStatus(view));
        CustomControl customcontrol = (CustomControl)view.getControl("customcontrolap");
        customcontrol.setData(data);
    }

    public static DynamicObject getTeBeSaveDataByOrgId(Long billId, Long orgId, String field) {
        return AdminOrgBatchChartBaseHelper.getDataByStatus(billId, orgId, field, "0");
    }

    private static DynamicObject getDataByStatus(Long billId, Long orgId, String field, String mergeSplitStatus) {
        QFilter filter = new QFilter("billid", "=", (Object)billId).and(new QFilter("mergesplitstatus", "=", (Object)mergeSplitStatus)).and(new QFilter("adminorg", "=", (Object)orgId));
        return HOMS_BATCHORGENTITY_HELPER.queryOne(field, filter.toArray());
    }

    public static DynamicObjectCollection getEntryCol(Long billId, Set<Long> orgIdSet, String selectFields, List<String> statusList) {
        QFilter filter = new QFilter("billid", "=", (Object)billId);
        if (!CollectionUtils.isEmpty(orgIdSet)) {
            filter.and("adminorg", "in", orgIdSet);
        }
        filter.and("mergesplitstatus", "in", statusList);
        return HOMS_BATCHORGENTITY_HELPER.queryOriginalCollection(selectFields, filter.toArray());
    }

    public static DynamicObject[] getUnSaveAndDeleteData(Long billId, Set<Long> orgIdSet, String field) {
        if (CollectionUtils.isEmpty(orgIdSet)) {
            return new DynamicObject[0];
        }
        QFilter filter = new QFilter("billid", "=", (Object)billId).and(new QFilter("mergesplitstatus", "in", Arrays.asList("0", "1"))).and(new QFilter("adminorg", "in", orgIdSet));
        return HOMS_BATCHORGENTITY_HELPER.query(field, filter.toArray());
    }

    public static DynamicObject[] getUnSaveAndDeleteData(Long billId, String field) {
        QFilter filter = new QFilter("billid", "=", (Object)billId).and(new QFilter("mergesplitstatus", "in", Arrays.asList("0", "1")));
        return HOMS_BATCHORGENTITY_HELPER.query(field, filter.toArray());
    }

    public static void deleteUnSaveEntity(Long billId, Collection<Long> orgId) {
        if (CollectionUtils.isEmpty(orgId)) {
            return;
        }
        QFilter filter = new QFilter("billid", "=", (Object)billId).and(new QFilter("mergesplitstatus", "!=", (Object)"2")).and(new QFilter("adminorg", "in", orgId));
        HOMS_BATCHORGENTITY_HELPER.deleteByFilter(filter.toArray());
    }

    public static void deleteAllUnSaveEntity(Long billId) {
        QFilter filter = new QFilter("billid", "=", (Object)billId).and(new QFilter("mergesplitstatus", "in", Arrays.asList("0", "1")));
        DynamicObjectCollection entityCol = HOMS_BATCHORGENTITY_HELPER.queryOriginalCollection("id,adminorg,adminorg.datastatus", filter.toArray());
        if (CollectionUtils.isEmpty((Collection)entityCol)) {
            return;
        }
        HashSet<Long> idSet = new HashSet<Long>(entityCol.size());
        HashSet<Long> tmpOrgIdSet = new HashSet<Long>(entityCol.size());
        for (DynamicObject entityDy : entityCol) {
            idSet.add(entityDy.getLong("id"));
            if (!EnumHisDataVersionStatus.TEMP.getStatus().equals(entityDy.getString("adminorg.datastatus"))) continue;
            tmpOrgIdSet.add(entityDy.getLong("adminorg"));
        }
        HOMS_BATCHORGENTITY_HELPER.delete((Object[])idSet.toArray(new Long[0]));
        if (!CollectionUtils.isEmpty(tmpOrgIdSet)) {
            filter = new QFilter("billid", "=", (Object)billId);
            filter.and("mergesplitstatus", "=", (Object)"2");
            filter.and("adminorg", "in", tmpOrgIdSet);
            DynamicObjectCollection col = HOMS_BATCHORGENTITY_HELPER.queryOriginalCollection("adminorg", filter.toArray());
            col.forEach(entity -> tmpOrgIdSet.remove(entity.getLong("adminorg")));
            if (!CollectionUtils.isEmpty(tmpOrgIdSet)) {
                AdminOrgBatchChgHelper.delAddMaster(new ArrayList<Long>(tmpOrgIdSet));
            }
        }
    }

    public static void deleteToDeleteEntity(Long billId, long orgId) {
        QFilter filter = new QFilter("billid", "=", (Object)billId).and(new QFilter("mergesplitstatus", "=", (Object)"1")).and(new QFilter("adminorg", "=", (Object)orgId));
        HOMS_BATCHORGENTITY_HELPER.deleteByFilter(filter.toArray());
    }

    public static void addToDeleteDataList(Long billId, Collection<Long> orgIdCol) {
        ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(orgIdCol.size());
        for (Long orgId : orgIdCol) {
            DynamicObject deleteObj = HOMS_BATCHORGENTITY_HELPER.generateEmptyDynamicObject();
            deleteObj.set("billid", (Object)billId);
            deleteObj.set("mergesplitstatus", (Object)"1");
            deleteObj.set("adminorg", (Object)orgId);
            deleteObj.set("index", (Object)0);
            dyList.add(deleteObj);
        }
        HOMS_BATCHORGENTITY_HELPER.save(dyList.toArray(new DynamicObject[0]));
    }

    public static void addToDeleteData(Long billId, long orgId) {
        DynamicObject deleteObj = HOMS_BATCHORGENTITY_HELPER.generateEmptyDynamicObject();
        deleteObj.set("billid", (Object)billId);
        deleteObj.set("mergesplitstatus", (Object)"1");
        deleteObj.set("adminorg", (Object)orgId);
        deleteObj.set("index", (Object)0);
        HOMS_BATCHORGENTITY_HELPER.saveOne(deleteObj);
    }

    public static BillShowParameter openAddOrgPage(IFormView view, String pluginName, ClosedCallBackEvent closedCallBackEvent, String mergeSplit) {
        if (closedCallBackEvent.getReturnData() == null) {
            view.getPageCache().remove("lastTimeAddEntryId");
            return null;
        }
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("homs_batchorgentityadd");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("billid", (Object)view.getModel().getDataEntity().getLong("id"));
        formShowParameter.setCustomParam("billBsed", (Object)view.getModel().getDataEntity().getDate("effdt"));
        formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, "add_org"));
        formShowParameter.setCustomParam("adminOrgTypeId", (Object)String.valueOf(closedCallBackEvent.getReturnData()));
        if (HRStringUtils.equals((String)"0", (String)view.getPageCache().get("isList"))) {
            formShowParameter.setCustomParam("parentId", (Object)view.getPageCache().get("parentId"));
        }
        formShowParameter.setCustomParam("org", (Object)view.getModel().getDataEntity().getLong("org.id"));
        int sequence = AdminOrgBatchChgHelper.getEntrySeq(view.getModel(), OrgBatchChgBillConstants.CHANGE_TYPE_ADD);
        formShowParameter.setCustomParam("sequence", (Object)sequence);
        formShowParameter.setCustomParam("mergeSplit", (Object)mergeSplit);
        return formShowParameter;
    }

    public static void openChartList(String page, String closeId, List<ChgOrgInfoDto> orgList, DynamicObject dataEntity, String pluginName, IFormView view) {
        AdminOrgBatchChartBaseHelper.openChartList(page, closeId, orgList, dataEntity, pluginName, view, "0");
    }

    public static void openChartList4Disable(String page, String closeId, List<ChgOrgInfoDto> orgList, DynamicObject dataEntity, String pluginName, IFormView view) {
        FormShowParameter formShowParameter = new FormShowParameter();
        AdminOrgBatchChartBaseHelper.setEntityStatus(formShowParameter, view);
        AdminOrgBatchChartBaseHelper.openChartList(page, closeId, orgList, dataEntity, pluginName, view, "0", formShowParameter);
    }

    public static void openChartList(String page, String closeId, List<ChgOrgInfoDto> orgList, DynamicObject dataEntity, String pluginName, IFormView view, String openType) {
        AdminOrgBatchChartBaseHelper.openChartList(page, closeId, orgList, dataEntity, pluginName, view, openType, (FormShowParameter)new BillShowParameter());
    }

    private static void openChartList(String page, String closeId, List<ChgOrgInfoDto> orgList, DynamicObject dataEntity, String pluginName, IFormView view, String openType, FormShowParameter formShowParameter) {
        formShowParameter.setFormId(page);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("selectOrg", orgList);
        formShowParameter.setCustomParam("orgFixed", (Object)"1");
        formShowParameter.setCustomParam("billid", (Object)dataEntity.getLong("id"));
        OrgBatchCheckCacheModel cacheModel = AdminOrgBatchChartBaseHelper.loadOwnCheckCache(dataEntity);
        formShowParameter.setCustomParam("cacheModel", (Object)cacheModel);
        formShowParameter.setCustomParam("openType", (Object)openType);
        String billPageId = (String)view.getFormShowParameter().getCustomParam("billPageId");
        formShowParameter.setCustomParam("billPageId", (Object)billPageId);
        formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, closeId));
        view.showForm(formShowParameter);
    }

    private static OrgBatchCheckCacheModel loadOwnCheckCache(DynamicObject dataEntity) {
        OrgBatchCheckCacheModel cacheModel = new OrgBatchCheckCacheModel();
        cacheModel.setCurrentBillId(dataEntity.getLong("id"));
        Date effdt = dataEntity.getDate("effdt");
        cacheModel.setEffectDate(effdt == null ? new Date() : effdt);
        cacheModel.setOperateType(2);
        cacheModel.setOrgId(dataEntity.getLong("org.id"));
        OrgBatchBillConverter.processDynamicObject(dataEntity, cacheModel);
        return cacheModel;
    }

    public static void setEntityStatus(FormShowParameter formShowParameter, IFormView view) {
        if (!AdminOrgBatchViewStrategyContext.isEdit(view.getModel().getDataEntity().getString("billstatus"), view)) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
    }

    public static void setFormShowParameter(Long orgId, long id, String mergeSplit, BillShowParameter formShowParameter, IFormView view) {
        formShowParameter.setCustomParam("id", (Object)id);
        formShowParameter.setCustomParam("orgFixed", (Object)"1");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        IDataModel model = view.getModel();
        formShowParameter.setCustomParam("billid", (Object)model.getDataEntity().getLong("id"));
        formShowParameter.setCustomParam("orgid", (Object)String.valueOf(orgId));
        formShowParameter.setCustomParam("mergeSplit", (Object)mergeSplit);
        formShowParameter.setCustomParam("org", (Object)model.getDataEntity().getLong("org.id"));
        formShowParameter.setCustomParam("billPageId", (Object)view.getPageId());
        AdminOrgBatchChartBaseHelper.setEntityStatus((FormShowParameter)formShowParameter, view);
    }

    public static BillShowParameter showPageWithEntry(Long orgId, IFormView view, String pluginName, String mergeSplit) {
        HRBaseServiceHelper hrBaseServiceHelper;
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter idFilter = new QFilter("id", "=", (Object)orgId);
        DynamicObject org = adminOrgHelper.queryOriginalOne("boid", idFilter.toArray());
        long orgBoId = org.getLong("boid");
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        DynamicObjectCollection addEntryColl = dataEntity.getDynamicObjectCollection("entryentity_add");
        List addEntryList = addEntryColl.stream().filter(addEntry -> addEntry.getLong("add_adminorg") == orgId.longValue() || addEntry.getLong("add_adminorg") == orgBoId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(addEntryList)) {
            int row = ((DynamicObject)addEntryList.get(0)).getInt("seq") - 1;
            DynamicObject addDy = (DynamicObject)addEntryColl.get(row);
            Long addDyId = addDy.getLong("id");
            return AdminOrgBatchChartBaseHelper.openEditAddPageForChart(addDyId, view, pluginName, mergeSplit);
        }
        DynamicObjectCollection infoEntryEntity = dataEntity.getDynamicObjectCollection("entryentity_info");
        List entryInfoList = infoEntryEntity.stream().filter(entry -> entry.getLong("info_adminorg.boid") == orgBoId).collect(Collectors.toList());
        DynamicObjectCollection parentEntryEntity = dataEntity.getDynamicObjectCollection("entryentity_parent");
        List entryParentList = parentEntryEntity.stream().filter(entry -> entry.getLong("parent_adminorg.boid") == orgBoId).collect(Collectors.toList());
        long id = 0L;
        BillShowParameter formShowParameter = new BillShowParameter();
        if (!CollectionUtils.isEmpty(entryInfoList)) {
            formShowParameter.setFormId("homs_batchorgentityinfo");
            id = ((DynamicObject)entryInfoList.get(0)).getLong("id");
            formShowParameter.setCustomParam("selectObject", (Object)SerializationUtils.toJsonString(entryInfoList.get(0)));
            formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, "add_orgInfo"));
        } else if (!CollectionUtils.isEmpty(entryParentList)) {
            formShowParameter.setFormId("homs_batchorgentityparent");
            id = ((DynamicObject)entryParentList.get(0)).getLong("id");
            formShowParameter.setCustomParam("selectObject", (Object)SerializationUtils.toJsonString(entryParentList.get(0)));
            formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, "entryentity_parent"));
        } else {
            formShowParameter.setFormId("homs_batchorgentityinfo");
            formShowParameter.setCustomParam("iscard", (Object)"isCardTrue");
            formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, "add_orgInfo"));
        }
        if (id != 0L && (hrBaseServiceHelper = new HRBaseServiceHelper("homs_batchorgentity")).isExists((Object)id)) {
            formShowParameter.setPkId((Object)id);
        }
        AdminOrgBatchChartBaseHelper.setFormShowParameter(orgId, id, mergeSplit, formShowParameter, view);
        return formShowParameter;
    }

    public static BillShowParameter openEditAddPageForChart(Long addDyId, IFormView view, String pluginName, String mergeSplit) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("homs_batchorgentityadd");
        formShowParameter.setPkId((Object)addDyId);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, "add_org"));
        AdminOrgBatchChartBaseHelper.setEntityStatus((FormShowParameter)formShowParameter, view);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("mergeSplit", (Object)mergeSplit);
        formShowParameter.setCustomParam("id", (Object)addDyId);
        formShowParameter.setCustomParam("billPageId", (Object)view.getPageId());
        return formShowParameter;
    }

    public static void dealUnSaveAndDeleteData(long billId, Set<Long> toSaveOrgIdSet, Set<Long> deleteOrgIdSet) {
        QFilter billIdFilter = new QFilter("billid", "=", (Object)billId);
        QFilter unSaveDataFilter = new QFilter("mergesplitstatus", "in", Arrays.asList("0", "1"));
        DynamicObject[] objects = HOMS_BATCHORGENTITY_HELPER.loadDynamicObjectArray(new QFilter[]{billIdFilter, unSaveDataFilter});
        Map map = Arrays.stream(objects).collect(Collectors.groupingBy(obj -> obj.getString("mergesplitstatus"), Collectors.toList()));
        List<DynamicObject> toSaveEntryList = map.get("0");
        List toDeleteEntryList = map.get("1");
        if (!CollectionUtils.isEmpty(toSaveEntryList)) {
            toSaveOrgIdSet.addAll(toSaveEntryList.stream().map(entry -> {
                entry.set("mergesplitstatus", (Object)"2");
                return entry.getLong("adminorg.id");
            }).collect(Collectors.toSet()));
            AdminOrgBatchChartBaseHelper.effectTempOrg(toSaveEntryList);
            deleteOrgIdSet.addAll(toSaveOrgIdSet);
            QFilter toSaveFilter = new QFilter("adminorg", "in", toSaveOrgIdSet).and(new QFilter("mergesplitstatus", "=", (Object)"2")).and(billIdFilter);
            HOMS_BATCHORGENTITY_HELPER.deleteByFilter(toSaveFilter.toArray());
            DynamicObject[] toSaveEntryArr = toSaveEntryList.toArray(new DynamicObject[0]);
            HOMS_BATCHORGENTITY_HELPER.updateDatas(toSaveEntryArr);
        }
        if (!CollectionUtils.isEmpty(toDeleteEntryList)) {
            Set<Long> toDeleteOrgIdSet = toDeleteEntryList.stream().map(entry -> entry.getLong("adminorg.id")).collect(Collectors.toSet());
            AdminOrgBatchChartBaseHelper.delAddMaster(billId, toDeleteOrgIdSet, true);
            deleteOrgIdSet.addAll(toDeleteOrgIdSet);
            QFilter toDeleteFilter = billIdFilter.and(new QFilter("adminorg", "in", toDeleteOrgIdSet));
            HOMS_BATCHORGENTITY_HELPER.deleteByFilter(toDeleteFilter.toArray());
        }
    }

    private static void effectTempOrg(List<DynamicObject> toSaveEntryList) {
        DynamicObject[] addEntryArr = (DynamicObject[])toSaveEntryList.stream().filter(entry -> ChangeTypeEnum.ADD.getId().longValue() == entry.getLong("changetype.id")).peek(entry -> entry.set("bsed", (Object)entry.getDate("establishmentdate"))).toArray(DynamicObject[]::new);
        if (addEntryArr.length > 0) {
            int dataEntitiesLength = addEntryArr.length;
            DynamicObject[] dynArr = new DynamicObject[dataEntitiesLength];
            ArrayList<Long> orgIdList = new ArrayList<Long>(dataEntitiesLength);
            AdminOrgChgBillSaveService billSaveService = AdminOrgChgBillSaveService.getInstance();
            billSaveService.infoCopyBoid(addEntryArr, "homs_batchorgentityadd", dynArr, orgIdList);
            AdminOrgOpService.getInstance().saveTemporary(dynArr, Long.valueOf(0L));
        }
    }

    public static void delAndAddEntry(IFormView billView, Set<Long> toSaveOrgIdSet, Set<Long> deleteOrgIdSet) {
        TableValueSetter addTableValueSetter = null;
        TableValueSetter parentTableValueSetter = null;
        TableValueSetter infoTableValueSetter = null;
        TableValueSetter disableTableValueSetter = null;
        DynamicObject dataEntity = billView.getModel().getDataEntity(true);
        if (!CollectionUtils.isEmpty(toSaveOrgIdSet)) {
            QFilter filter = new QFilter("adminorg", "in", toSaveOrgIdSet).and(new QFilter("billid", "=", (Object)dataEntity.getLong("id")));
            DynamicObject[] toSaveEntryList = HOMS_BATCHORGENTITY_HELPER.loadDynamicObjectArray(filter.toArray());
            Map changeTypeMap = Stream.of(toSaveEntryList).collect(Collectors.groupingBy(entry -> entry.getLong("changetype.id"), Collectors.toList()));
            addTableValueSetter = AdminOrgBatchChartBaseHelper.getAddTableValueSetter(changeTypeMap.get(ChangeTypeEnum.ADD.getId()));
            parentTableValueSetter = AdminOrgBatchChartBaseHelper.getParentTableValueSetter(changeTypeMap.get(ChangeTypeEnum.PARENT.getId()), billView);
            infoTableValueSetter = AdminOrgBatchChartBaseHelper.getInfoTableValueSetter(changeTypeMap.get(ChangeTypeEnum.INFO.getId()), billView);
            disableTableValueSetter = AdminOrgBatchChartBaseHelper.disableTableValueSetter(changeTypeMap.get(ChangeTypeEnum.DISABLE.getId()), billView);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)billView.getModel();
        AdminOrgBatchChartBaseHelper.deleteEntryRows(deleteOrgIdSet, dataEntity, model, "entryentity_add", "add_adminorg");
        AdminOrgBatchChartBaseHelper.deleteEntryRows(deleteOrgIdSet, dataEntity, model, "entryentity_parent", "parent_adminorg.id");
        AdminOrgBatchChartBaseHelper.deleteEntryRows(deleteOrgIdSet, dataEntity, model, "entryentity_info", "info_adminorg.id");
        AdminOrgBatchChartBaseHelper.deleteEntryRows(deleteOrgIdSet, dataEntity, model, "entryentity_disable", "disable_adminorg.id");
        if (addTableValueSetter != null) {
            model.batchCreateNewEntryRow("entryentity_add", addTableValueSetter);
        }
        if (parentTableValueSetter != null) {
            model.batchCreateNewEntryRow("entryentity_parent", parentTableValueSetter);
        }
        if (infoTableValueSetter != null) {
            model.batchCreateNewEntryRow("entryentity_info", infoTableValueSetter);
        }
        if (disableTableValueSetter != null) {
            model.batchCreateNewEntryRow("entryentity_disable", disableTableValueSetter);
        }
    }

    private static void deleteEntryRows(Set<Long> deleteOrgIdSet, DynamicObject dataEntity, AbstractFormDataModel model, String entryEntity, String propertyOrgId) {
        DynamicObjectCollection entity = dataEntity.getDynamicObjectCollection(entryEntity);
        List deleteRow = entity.stream().filter(entry -> deleteOrgIdSet.contains(entry.getLong(propertyOrgId))).map(entry -> entry.getInt("seq") - 1).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(deleteRow)) {
            int[] deleteRowArr = new int[deleteRow.size()];
            for (int i = 0; i < deleteRow.size(); ++i) {
                deleteRowArr[i] = (Integer)deleteRow.get(i);
            }
            model.deleteEntryRows(entryEntity, deleteRowArr);
        }
    }

    public static List<String> checkMergeOrg(DynamicObject dataEntity, Set<Long> orgIdSet, Long mergeTargetOrgId, Long oldMergeTargetOrgId) {
        Set<Long> splitOrgIdSet;
        String splitOrgNameString;
        Set<Long> mergeOrgIdSet;
        String mergeOrgNameString;
        String addOrgNameString;
        ArrayList<String> errorMessages = new ArrayList<String>();
        boolean flag = false;
        if (mergeTargetOrgId != null && mergeTargetOrgId != 0L) {
            if (orgIdSet.contains(mergeTargetOrgId) && orgIdSet.size() == 1) {
                flag = true;
            }
            orgIdSet.add(mergeTargetOrgId);
        }
        Map<Long, Map<String, String>> orgInfoMap = AdminOrgBatchChartBaseHelper.getOrgInfoMap(orgIdSet, dataEntity);
        if (flag) {
            errorMessages.add(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5c06\u7ec4\u7ec7\u201c%s\u201d\u5408\u5e76\u4e3a\u7ec4\u7ec7\u672c\u8eab\uff0c\u8bf7\u9009\u62e9\u66f4\u591a\u5408\u5e76\u524d\u7ec4\u7ec7\u3002", (String)"AdminOrgBatchChartBaseHelper_6", (String)"odc-homs-business", (Object[])new Object[]{orgInfoMap.get(mergeTargetOrgId).get("name")}));
        }
        if (HRStringUtils.isNotEmpty((String)(addOrgNameString = dataEntity.getDynamicObjectCollection("entryentity_add").stream().map(entry -> entry.getLong("add_adminorg")).filter(orgId -> orgIdSet.contains(orgId) && !orgId.equals(mergeTargetOrgId)).map(orgId -> (String)((Map)orgInfoMap.get(orgId)).get("name")).collect(Collectors.joining(","))))) {
            errorMessages.add(ResManager.loadKDString((String)"\u5408\u5e76\u524d\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u80fd\u4e3a\u672c\u5355\u65b0\u589e\u7684\u7ec4\u7ec7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AdminOrgBatchChartBaseHelper_0", (String)"odc-homs-business", (Object[])new Object[]{addOrgNameString}));
        }
        if (HRStringUtils.isNotEmpty((String)(mergeOrgNameString = (mergeOrgIdSet = AdminOrgBatchChartBaseHelper.getMergeOrgIdSet(dataEntity, oldMergeTargetOrgId, orgIdSet)).stream().map(orgId -> (String)((Map)orgInfoMap.get(orgId)).get("name")).collect(Collectors.joining(","))))) {
            errorMessages.add(ResManager.loadKDString((String)"%s\u5b58\u5728\u5408\u5e76\u7ec4\u7ec7\u8bb0\u5f55\uff0c\u4e0d\u53ef\u64cd\u4f5c\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u3002", (String)"AdminOrgBatchChartBaseHelper_1", (String)"odc-homs-business", (Object[])new Object[]{mergeOrgNameString}));
        }
        if (HRStringUtils.isNotEmpty((String)(splitOrgNameString = (splitOrgIdSet = AdminOrgBatchChartBaseHelper.getSpiltOrgIdSet(dataEntity, orgIdSet)).stream().map(orgId -> (String)((Map)orgInfoMap.get(orgId)).get("name")).collect(Collectors.joining(","))))) {
            errorMessages.add(ResManager.loadKDString((String)"%s\u5b58\u5728\u62c6\u5206\u7ec4\u7ec7\u8bb0\u5f55\uff0c\u4e0d\u53ef\u64cd\u4f5c\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u3002", (String)"AdminOrgBatchChartBaseHelper_2", (String)"odc-homs-business", (Object[])new Object[]{splitOrgNameString}));
        }
        AdminOrgBatchChartBaseHelper.inWayCheck(dataEntity.getLong("id"), orgIdSet, errorMessages, orgInfoMap);
        AdminOrgBatchChartBaseHelper.disableOrgCheck(orgIdSet, errorMessages, orgInfoMap);
        DynamicObject orgChangeType = AdminOrgBatchChartBaseHelper.getOrgChangeType(dataEntity, mergeTargetOrgId);
        if (orgChangeType != null && orgChangeType.getLong("id") == ChangeTypeEnum.DISABLE.getId().longValue()) {
            errorMessages.add(ResManager.loadKDString((String)"\u5408\u5e76\u540e\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u80fd\u4e3a\u672c\u5355\u505c\u7528\u7684\u7ec4\u7ec7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AdminOrgBatchChartBaseHelper_5", (String)"odc-homs-business", (Object[])new Object[]{orgInfoMap.get(mergeTargetOrgId).get("name")}));
        }
        return errorMessages;
    }

    private static void disableOrgCheck(Set<Long> orgIdSet, List<String> errorMessages, Map<Long, Map<String, String>> orgInfoMap) {
        String disableOrgNameString = orgIdSet.stream().filter(orgId -> {
            Map orgInfo = (Map)orgInfoMap.get(orgId);
            String enable = (String)orgInfo.get("enable");
            return !HRStringUtils.equals((String)enable, (String)"1");
        }).map(orgId -> (String)((Map)orgInfoMap.get(orgId)).get("name")).collect(Collectors.joining(","));
        if (HRStringUtils.isNotEmpty((String)disableOrgNameString)) {
            errorMessages.add(ResManager.loadKDString((String)"%s\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u542f\u7528\u201d\uff0c\u4e0d\u53ef\u64cd\u4f5c\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u3002", (String)"AdminOrgBatchChartBaseHelper_4", (String)"odc-homs-business", (Object[])new Object[]{disableOrgNameString}));
        }
    }

    private static void inWayCheck(Long billId, Set<Long> orgIdSet, List<String> errorMessages, Map<Long, Map<String, String>> orgInfoMap) {
        List<OrgBatchCheckDto> checkDtoList = OrgBatchBillCheckHelper.queryBillOrgList();
        Set processOrgSet = checkDtoList.stream().filter(check -> !billId.equals(check.getBillId())).map(OrgBatchCheckDto::getOrgId).collect(Collectors.toSet());
        String inWayOrgNameString = processOrgSet.stream().filter(orgIdSet::contains).map(orgId -> (String)((Map)orgInfoMap.get(orgId)).get("name")).collect(Collectors.joining(","));
        if (HRStringUtils.isNotEmpty((String)inWayOrgNameString)) {
            errorMessages.add(ResManager.loadKDString((String)"%s\u5b58\u5728\u5176\u4ed6\u5728\u9014\u8c03\u6574\uff0c\u4e0d\u53ef\u64cd\u4f5c\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u3002", (String)"AdminOrgBatchChartBaseHelper_3", (String)"odc-homs-business", (Object[])new Object[]{inWayOrgNameString}));
        }
    }

    private static Set<Long> getSpiltOrgIdSet(DynamicObject dataEntity, Set<Long> orgIdSet) {
        DynamicObjectCollection split = dataEntity.getDynamicObjectCollection("entryentity_split");
        HashSet<Long> splitOrgIdSet = new HashSet<Long>();
        split.forEach(entry -> {
            long toSplitOrgId;
            DynamicObjectCollection splitTargetOrg = entry.getDynamicObjectCollection("split_target_org");
            DynamicObject toSplitOrg = entry.getDynamicObject("to_split_org");
            if (splitTargetOrg != null) {
                splitOrgIdSet.addAll(splitTargetOrg.stream().map(org -> org.getDynamicObject("fbasedataid").getLong("id")).filter(orgIdSet::contains).collect(Collectors.toSet()));
            }
            if (toSplitOrg != null && orgIdSet.contains(toSplitOrgId = toSplitOrg.getLong("id"))) {
                splitOrgIdSet.add(toSplitOrgId);
            }
        });
        return splitOrgIdSet;
    }

    private static Map<Long, Map<String, String>> getOrgInfoMap(Set<Long> orgIdSet, DynamicObject dataEntity) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter filter = new QFilter("id", "in", orgIdSet);
        DynamicObjectCollection orgs = helper.queryOriginalCollection("id,boid,name", filter.toArray());
        Map<Long, DynamicObject> orgMap = orgs.stream().collect(Collectors.toMap(org -> org.getLong("boid"), org -> org));
        Set<Long> boIdSet = orgMap.keySet();
        QFilter boIdFilter = new QFilter("id", "in", boIdSet);
        Map<Long, Map<String, String>> orgInfoMap = helper.queryOriginalCollection("id,enable", boIdFilter.toArray()).stream().collect(Collectors.toMap(org -> ((DynamicObject)orgMap.get(org.getLong("id"))).getLong("id"), org -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", ((DynamicObject)orgMap.get(org.getLong("id"))).getString("name"));
            map.put("enable", org.getString("enable"));
            return map;
        }));
        AdminOrgBatchChartBaseHelper.replaceNameFromEntry(orgIdSet, dataEntity, orgInfoMap);
        return orgInfoMap;
    }

    private static void replaceNameFromEntry(Set<Long> orgIdSet, DynamicObject dataEntity, Map<Long, Map<String, String>> orgInfoMap) {
        DynamicObject[] unSaveAndDeleteDataArr = AdminOrgBatchChartBaseHelper.getUnSaveAndDeleteData(dataEntity.getLong("id"), orgIdSet, "adminorg,changetype,mergesplitstatus");
        Arrays.stream(unSaveAndDeleteDataArr).filter(data -> HRStringUtils.equals((String)data.getString("mergesplitstatus"), (String)"0")).forEach(data -> {
            long orgId = data.getLong("adminorg.id");
            Map orgInfo = (Map)orgInfoMap.get(orgId);
            orgInfo.put("name", data.getString("name"));
        });
        Map<Long, DynamicObject> unSaveAndDeleteDataMap = Arrays.stream(unSaveAndDeleteDataArr).collect(Collectors.toMap(data -> data.getLong("adminorg.id"), data -> data));
        Arrays.asList("parent", "info").forEach(prefix -> dataEntity.getDynamicObjectCollection("entryentity_" + prefix).stream().filter(entry -> orgIdSet.contains(entry.getLong(prefix + "_adminorg.id"))).forEach(entry -> {
            long orgId = entry.getLong(prefix + "_adminorg.id");
            if (!unSaveAndDeleteDataMap.containsKey(orgId)) {
                Map orgInfo = (Map)orgInfoMap.get(orgId);
                orgInfo.put("name", entry.getString(prefix + "_name"));
            }
        }));
    }

    private static Set<Long> getMergeOrgIdSet(DynamicObject dataEntity, Long oldMergeTargetOrgId, Set<Long> orgIdSet) {
        DynamicObjectCollection merge = dataEntity.getDynamicObjectCollection("entryentity_merge");
        HashSet<Long> mergeOrgIdSet = new HashSet<Long>();
        merge.forEach(entry -> {
            DynamicObject targetOrg = entry.getDynamicObject("merge_target_org");
            if (oldMergeTargetOrgId == 0L || !oldMergeTargetOrgId.equals(entry.getLong("merge_origin_id"))) {
                DynamicObjectCollection toMergeOrg;
                long targetOrgId;
                if (targetOrg != null && orgIdSet.contains(targetOrgId = targetOrg.getLong("id"))) {
                    mergeOrgIdSet.add(targetOrgId);
                }
                if ((toMergeOrg = entry.getDynamicObjectCollection("to_merge_org")) != null) {
                    mergeOrgIdSet.addAll(toMergeOrg.stream().map(org -> org.getDynamicObject("fbasedataid").getLong("id")).filter(orgIdSet::contains).collect(Collectors.toSet()));
                }
            }
        });
        return mergeOrgIdSet;
    }

    public static void openSplit(Long splitOriginId, Long orgId, IFormView view, CloseCallBack closeCallBack) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("splitOrgId", (Object)orgId);
        formShowParameter.setCustomParam("customHRPermItemId", (Object)"47156aff000000ac");
        formShowParameter.setCustomParam("billPageId", (Object)view.getPageId());
        if (splitOriginId != null) {
            formShowParameter.setCustomParam("split_origin_id", (Object)splitOriginId);
        }
        formShowParameter.setFormId("homs_batchorgentitysplit");
        formShowParameter.setCloseCallBack(closeCallBack);
        AdminOrgBatchChartBaseHelper.setEntityStatus(formShowParameter, view);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(formShowParameter);
    }

    public static void openNewMergePage(Set<Long> orgIdSet, IFormView view, IFormPlugin closeCallBackPlugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("tobemergeorg", new ArrayList<Long>(orgIdSet));
        formShowParameter.setCustomParam("newMerge", (Object)"true");
        formShowParameter.setCustomParam("billPageId", (Object)view.getPageId());
        formShowParameter.setFormId("homs_batchorgentitymerge");
        formShowParameter.setCloseCallBack(new CloseCallBack(closeCallBackPlugin, "org_merge"));
        AdminOrgBatchChartBaseHelper.setEntityStatus(formShowParameter, view);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(formShowParameter);
    }

    public static void openEditMergePage(DynamicObject mergeOrgEntry, IFormView view, IFormPlugin closeCallBackPlugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("targetorg", (Object)mergeOrgEntry.getLong("merge_target_org.id"));
        DynamicObjectCollection toBeMergeOrgs = mergeOrgEntry.getDynamicObjectCollection("to_merge_org");
        List toBeMergeOrgId = toBeMergeOrgs.stream().map(org -> org.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        formShowParameter.setCustomParam("tobemergeorg", toBeMergeOrgId);
        formShowParameter.setCustomParam("changescene", (Object)mergeOrgEntry.getLong("merge_changescene.id"));
        formShowParameter.setCustomParam("changereason", (Object)mergeOrgEntry.getLong("merge_changereason.id"));
        formShowParameter.setCustomParam("changedescription", (Object)mergeOrgEntry.getString("merge_changedescription"));
        formShowParameter.setCustomParam("newMerge", (Object)"false");
        formShowParameter.setCustomParam("originTargetOrg", (Object)mergeOrgEntry.getLong("merge_origin_id"));
        formShowParameter.setCustomParam("billPageId", (Object)view.getPageId());
        formShowParameter.setFormId("homs_batchorgentitymerge");
        formShowParameter.setCloseCallBack(new CloseCallBack(closeCallBackPlugin, "edit_merge_detail"));
        AdminOrgBatchChartBaseHelper.setEntityStatus(formShowParameter, view);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(formShowParameter);
    }

    public static TableValueSetter getAddTableValueSetter(List<DynamicObject> addOrgDyList) {
        if (CollectionUtils.isEmpty(addOrgDyList)) {
            return null;
        }
        return AdminOrgBatchChartBaseHelper.getAddTableValueSetter(addOrgDyList.toArray(new DynamicObject[0]));
    }

    public static TableValueSetter getAddTableValueSetter(DynamicObject[] addOrgDyArr) {
        if (addOrgDyArr == null || addOrgDyArr.length == 0) {
            return null;
        }
        HashSet<Long> parentIds = new HashSet<Long>();
        for (DynamicObject dynamicObject : addOrgDyArr) {
            if (dynamicObject.getDynamicObject("parentorg") == null) continue;
            parentIds.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)dynamicObject.getDynamicObject("parentorg")));
        }
        Date modifyTime = new Date();
        Map longNameMap = OrgBatchBillHelper.getOrgLongNameByFid(parentIds, (Date)modifyTime, null);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List<String> addEntryFieldsList = BillEntryHelperEnum.getEntryListByChangeType(ChangeTypeEnum.ADD.getId());
        addEntryFieldsList.forEach(field -> {
            if ("id".equals(field)) {
                vs.addField(field, new Object[0]);
            } else {
                vs.addField(AdminOrgBatchChartBaseHelper.spliceTwoStringByUnderLine("add", field), new Object[0]);
            }
        });
        vs.addField("add_adminorg", new Object[0]);
        for (DynamicObject addOrgDy : addOrgDyArr) {
            vs.addRow(new Object[]{addOrgDy.getLong("id"), addOrgDy.getString("number"), addOrgDy.get("name"), addOrgDy.getString("simplename"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("adminorgtype")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("parentorg")), longNameMap.get(HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("parentorg"))), addOrgDy.getDate("establishmentdate"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("corporateorg")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("changescene")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("changereason")), addOrgDy.get("changedescription"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("adminorglayer")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("adminorgfunction")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("companyarea")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("city")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("workplace")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("org")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("safelevel")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("safetype")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addOrgDy.getDynamicObject("adminorg"))});
        }
        return vs;
    }

    private static TableValueSetter getParentTableValueSetter(List<DynamicObject> parentEntryList, IFormView view) {
        if (CollectionUtils.isEmpty(parentEntryList)) {
            return null;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List<String> parentEntryFieldsList = BillEntryHelperEnum.getEntryListByChangeType(ChangeTypeEnum.PARENT.getId());
        parentEntryFieldsList.forEach(field -> {
            if ("id".equals(field)) {
                vs.addField(field, new Object[0]);
            } else {
                vs.addField(AdminOrgBatchChartBaseHelper.spliceTwoStringByUnderLine("parent", field), new Object[0]);
            }
        });
        Long billOrgId = HRDyObjectPropUtil.getIdLongObject((DynamicObject)view.getModel().getDataEntity().getDynamicObject("org"));
        Date modifyTime = new Date();
        HashSet parentOrgIdSet = new HashSet();
        parentEntryList.forEach(entry -> {
            parentOrgIdSet.add(entry.getLong("parentorg.id"));
            parentOrgIdSet.add(entry.getLong("oriparentorg.id"));
        });
        Map id2LongNameMap = OrgBatchBillHelper.getOrgLongNameByFid(parentOrgIdSet, (Date)modifyTime, null);
        for (DynamicObject entry2 : parentEntryList) {
            vs.addRow(new Object[]{entry2.getLong("id"), entry2.getLong("adminorg.id"), entry2.getString("number"), entry2.getLocaleString("name"), entry2.getLong("oriparentorg.id"), id2LongNameMap.get(entry2.getLong("oriparentorg.id")), entry2.getLong("parentorg.id"), id2LongNameMap.get(entry2.getLong("parentorg.id")), entry2.getLocaleString("simplename"), entry2.getLong("adminorgtype.id"), entry2.getDate("establishmentdate"), entry2.getLong("corporateorg.id"), entry2.getString("tobedisableflag"), entry2.getLong("changescene.id"), entry2.getLong("changereason.id"), entry2.getString("changedescription"), entry2.getLong("adminorglayer.id"), entry2.getLong("adminorgfunction.id"), entry2.getLong("companyarea.id"), entry2.getLong("city.id"), entry2.getLong("workplace.id"), billOrgId, entry2.getLong("safelevel.id"), entry2.getLong("safetype.id")});
        }
        return vs;
    }

    private static TableValueSetter getInfoTableValueSetter(List<DynamicObject> infoEntryList, IFormView view) {
        if (CollectionUtils.isEmpty(infoEntryList)) {
            return null;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List<String> infoEntryFieldsList = BillEntryHelperEnum.getEntryListByChangeType(ChangeTypeEnum.INFO.getId());
        infoEntryFieldsList.forEach(field -> {
            if ("id".equals(field)) {
                vs.addField(field, new Object[0]);
            } else {
                vs.addField(AdminOrgBatchChartBaseHelper.spliceTwoStringByUnderLine("info", field), new Object[0]);
            }
        });
        Date modifyTime = new Date();
        Set parentOrgIdSet = infoEntryList.stream().map(org -> org.getLong("parentorg.id")).collect(Collectors.toSet());
        Map id2LongNameMap = OrgBatchBillHelper.getOrgLongNameByFid(parentOrgIdSet, (Date)modifyTime, null);
        Long billOrgId = HRDyObjectPropUtil.getIdLongObject((DynamicObject)view.getModel().getDataEntity().getDynamicObject("org"));
        for (DynamicObject entry : infoEntryList) {
            vs.addRow(new Object[]{entry.getLong("id"), entry.getLong("adminorg.id"), entry.getString("number"), entry.getLocaleString("name"), entry.getLong("parentorg.id"), id2LongNameMap.get(entry.getLong("parentorg.id")), entry.getLocaleString("simplename"), entry.getLong("adminorgtype.id"), entry.getDate("establishmentdate"), entry.getLong("corporateorg.id"), entry.getString("tobedisableflag"), entry.getLong("changescene.id"), entry.getLong("changereason.id"), entry.getString("changedescription"), entry.getLong("adminorglayer.id"), entry.getLong("adminorgfunction.id"), entry.getLong("companyarea.id"), entry.getLong("city.id"), entry.getLong("workplace.id"), billOrgId, entry.getLong("safelevel.id"), entry.getLong("safetype.id")});
        }
        return vs;
    }

    private static String spliceTwoStringByUnderLine(String oneString, String otherString) {
        return oneString + "_" + otherString;
    }

    private static TableValueSetter disableTableValueSetter(List<DynamicObject> disableEntryList, IFormView view) {
        if (CollectionUtils.isEmpty(disableEntryList)) {
            return null;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        List<String> disableEntryFieldsList = BillEntryHelperEnum.getEntryListByChangeType(ChangeTypeEnum.DISABLE.getId());
        disableEntryFieldsList.forEach(field -> {
            if ("id".equals(field)) {
                vs.addField(field, new Object[0]);
            } else {
                vs.addField(AdminOrgBatchChartBaseHelper.spliceTwoStringByUnderLine("disable", field), new Object[0]);
            }
        });
        Long billOrgId = HRDyObjectPropUtil.getIdLongObject((DynamicObject)view.getModel().getDataEntity().getDynamicObject("org"));
        Date modifyTime = new Date();
        Set parentOrgIdSet = disableEntryList.stream().map(org -> org.getLong("parentorg.id")).collect(Collectors.toSet());
        Map id2LongNameMap = OrgBatchBillHelper.getOrgLongNameByFid(parentOrgIdSet, (Date)modifyTime, null);
        for (DynamicObject entry : disableEntryList) {
            vs.addRow(new Object[]{entry.getLong("id"), entry.getLong("adminorg.id"), entry.getLong("parentorg.id"), id2LongNameMap.get(entry.getLong("parentorg.id")), entry.getLong("adminorgtype.id"), entry.getString("tobedisableflag"), entry.getLong("changescene.id"), entry.getLong("changereason.id"), entry.getString("changedescription"), billOrgId});
        }
        return vs;
    }

    public static DynamicObject getOrgChangeType(DynamicObject dataEntity, Long orgId) {
        if (orgId == null || 0L == orgId) {
            return null;
        }
        HashSet<Long> orgIdSet = new HashSet<Long>();
        orgIdSet.add(orgId);
        Map<Long, DynamicObject> changeTypeMap = AdminOrgBatchChartBaseHelper.getOrgChangeType(dataEntity, orgIdSet);
        return changeTypeMap.get(orgId);
    }

    public static Map<Long, DynamicObject> getOrgChangeType(DynamicObject dataEntity, Set<Long> orgIdSet) {
        DynamicObject[] unSaveAndDeleteData = AdminOrgBatchChartBaseHelper.getUnSaveAndDeleteData(dataEntity.getLong("id"), orgIdSet, "adminorg,changetype,mergesplitstatus");
        HashMap<Long, DynamicObject> changeTypeMap = new HashMap<Long, DynamicObject>(orgIdSet.size());
        for (DynamicObject data : unSaveAndDeleteData) {
            changeTypeMap.put(data.getLong("adminorg.id"), data.getDynamicObject("changetype"));
        }
        List<String> prefixList = Arrays.asList("add", "info", "parent", "disable");
        for (String prefix : prefixList) {
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entryentity_" + prefix);
            entries.forEach(entry -> {
                long orgId = HRStringUtils.equals((String)prefix, (String)"add") ? entry.getLong(prefix + "_adminorg") : entry.getLong(prefix + "_adminorg.id");
                if (orgIdSet.contains(orgId) && !changeTypeMap.containsKey(orgId)) {
                    changeTypeMap.put(orgId, entry.getDynamicObject(prefix + "_changetype"));
                }
            });
        }
        return changeTypeMap;
    }

    public static DynamicObjectCollection queryOrgDetail(String selectFields, QFilter[] qFilters) {
        return new HRBaseServiceHelper("haos_adminorgdetail").queryOriginalCollection(selectFields, qFilters);
    }

    public static OrgCubeTreeNode buildOrgCube(DynamicObject billDy, long orgId, String orgName, List<String> list, boolean nameFlag) {
        String changeType = "";
        String changeTypeId = "";
        String oldName = orgName;
        for (String propertyName : list) {
            boolean newFlag = "entryentity_add".equals(propertyName);
            String prefix = propertyName.substring(propertyName.indexOf("_") + 1);
            String idIdentify = prefix + "_" + (newFlag ? "adminorg" : "adminorg.id");
            Optional<DynamicObject> op = billDy.getDynamicObjectCollection(propertyName).stream().filter(dy -> dy.getLong(idIdentify) == orgId).findFirst();
            if (!op.isPresent()) continue;
            DynamicObject entityDy = op.get();
            orgName = newFlag ? orgName : ("entryentity_parent".equals(propertyName) || "entryentity_info".equals(propertyName) ? entityDy.getString(prefix + "_" + "name") : entityDy.getDynamicObject(prefix + "_" + "adminorg").getString("name"));
            DynamicObject changeTypeDy = entityDy.getDynamicObject(prefix + "_" + "changetype");
            changeType = nameFlag ? changeTypeDy.getString("name") : ChangeTypeEnum.getNumberById((Long)changeTypeDy.getLong("id"));
            oldName = newFlag ? "" : entityDy.getDynamicObject(prefix + "_" + "adminorg").getString("name");
            changeTypeId = changeTypeDy.getString("id");
            break;
        }
        OrgCubeTreeNode node = new OrgCubeTreeNode(String.valueOf(orgId), orgName, null, changeType, "1");
        node.setChangeTypeId(changeTypeId);
        node.setOldName(oldName);
        return node;
    }

    public static void delAddMaster(long billId, Set<Long> orgIdSet, boolean deleteAllAddOrg) {
        QFilter orgIdFilter = new QFilter("adminorg.id", "in", orgIdSet);
        QFilter changeTypeFilter = new QFilter("adminorg.datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        QFilter billIdFilter = new QFilter("billid", "=", (Object)billId);
        DynamicObjectCollection entities = HOMS_BATCHORGENTITY_HELPER.queryOriginalCollection("id,adminorg.id,mergesplitstatus", new QFilter[]{orgIdFilter, changeTypeFilter, billIdFilter});
        Set addOrgIdSet = entities.stream().map(entity -> entity.getLong("adminorg.id")).collect(Collectors.toSet());
        if (!deleteAllAddOrg) {
            Set hasAddOrgIdSet = entities.stream().filter(entity -> HRStringUtils.equals((String)"2", (String)entity.getString("mergesplitstatus"))).map(entity -> entity.getLong("adminorg.id")).collect(Collectors.toSet());
            addOrgIdSet.removeAll(hasAddOrgIdSet);
        }
        if (CollectionUtils.isEmpty(addOrgIdSet)) {
            return;
        }
        AdminOrgBatchChgHelper.delAddMaster(new ArrayList<Long>(addOrgIdSet));
    }

    public static void removeSplitTargetOrg(IFormView formView, Set<Long> orgIdSet) {
        DynamicObjectCollection splitCol = formView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_split");
        boolean flag = false;
        for (DynamicObject splitDy : splitCol) {
            long orgId;
            DynamicObjectCollection col;
            DynamicObject orgDy = splitDy.getDynamicObject("to_split_org");
            if (orgDy == null || !orgIdSet.contains(orgDy.getLong("id")) || CollectionUtils.isEmpty((Collection)(col = splitDy.getDynamicObjectCollection("split_target_org"))) || !col.removeIf(arg_0 -> AdminOrgBatchChartBaseHelper.lambda$removeSplitTargetOrg$58(orgId = orgDy.getLong("id"), arg_0))) continue;
            flag = true;
        }
        if (flag) {
            formView.updateView("entryentity_split");
        }
    }

    public static void removeSplitAndMergeTargetOrg(IFormView formView, Set<Long> orgIdSet) {
        DynamicObjectCollection splitCol = formView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_split");
        boolean flag = false;
        for (DynamicObject splitDy : splitCol) {
            DynamicObjectCollection col = splitDy.getDynamicObjectCollection("split_target_org");
            if (CollectionUtils.isEmpty((Collection)col) || !col.removeIf(dy -> orgIdSet.contains(dy.getLong("fbasedataid_id")))) continue;
            flag = true;
        }
        if (flag) {
            formView.updateView("entryentity_split");
        }
        DynamicObjectCollection mergeCol = formView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_merge");
        flag = false;
        for (DynamicObject splitDy : mergeCol) {
            long orgDy = splitDy.getLong("merge_target_org_id");
            if (orgDy == 0L || !orgIdSet.contains(orgDy)) continue;
            splitDy.set("merge_target_org", null);
            flag = true;
        }
        if (flag) {
            formView.updateView("entryentity_merge");
        }
    }

    public static String getViewStatus(IFormView view) {
        OperationStatus operationStatus = view.getFormShowParameter().getStatus();
        String status = "VIEW";
        if (operationStatus == null) {
            return status;
        }
        if (operationStatus == OperationStatus.ADDNEW || operationStatus == OperationStatus.EDIT) {
            status = "EDIT";
        }
        return status;
    }

    private static /* synthetic */ boolean lambda$removeSplitTargetOrg$58(long orgId, DynamicObject dy) {
        return dy.getDynamicObject("fbasedataid").getLong("id") == orgId;
    }
}

