/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.helper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.OrgChartCheckVO;

public class AdminOrgBatchChartHelper {
    private static List<String> entryPrefixList = Arrays.asList("add", "parent", "info", "merge", "split");

    public static String checkDisableOrg(Set<Long> orgIdSet, DynamicObject dataEntity) {
        AtomicBoolean isRootId = new AtomicBoolean(false);
        Map<Long, DynamicObject> orgMap = AdminOrgBatchChartHelper.queryAdminOrg(orgIdSet, isRootId);
        HashMap<Long, String> orgIdNameMap = new HashMap<Long, String>(orgMap.size());
        HashMap orgIdDutyMap = new HashMap(orgMap.size());
        orgMap.forEach((orgId, dy) -> {
            orgIdNameMap.put((Long)orgId, dy.getString("name"));
            orgIdDutyMap.put(orgId, dy.getLong("org.id"));
        });
        orgIdNameMap.putAll(AdminOrgBatchChartHelper.assembleOrgIdNameMap(dataEntity));
        Map<String, Set<Long>> map = AdminOrgBatchChartHelper.orgChangeTypeMap(orgIdSet, dataEntity);
        for (String prefix : entryPrefixList) {
            Set<Long> changeOrgIdSet = map.get(prefix);
            if (CollectionUtils.isEmpty(changeOrgIdSet)) continue;
            String message = map.get(prefix).stream().map(orgIdNameMap::get).collect(Collectors.joining(","));
            if (HRStringUtils.equals((String)prefix, (String)"add")) {
                return ResManager.loadKDString((String)"%s\u5b58\u5728\u672c\u5355\u65b0\u589e\u7ec4\u7ec7\u4e2d\uff0c\u4e0d\u53ef\u505c\u7528\u7ec4\u7ec7\u3002", (String)"AdminOrgBatchChartHelper_1", (String)"odc-homs-business", (Object[])new Object[]{message});
            }
            if (HRStringUtils.equals((String)prefix, (String)"parent")) {
                return ResManager.loadKDString((String)"%s\u5b58\u5728\u672c\u5355\u8c03\u6574\u4e0a\u7ea7\u4e2d\uff0c\u4e0d\u53ef\u505c\u7528\u7ec4\u7ec7\u3002", (String)"AdminOrgBatchChartHelper_2", (String)"odc-homs-business", (Object[])new Object[]{message});
            }
            if (HRStringUtils.equals((String)prefix, (String)"info")) {
                return ResManager.loadKDString((String)"%s\u5b58\u5728\u672c\u5355\u53d8\u66f4\u4fe1\u606f\u4e2d\uff0c\u4e0d\u53ef\u505c\u7528\u7ec4\u7ec7\u3002", (String)"AdminOrgBatchChartHelper_3", (String)"odc-homs-business", (Object[])new Object[]{message});
            }
            if (HRStringUtils.equals((String)prefix, (String)"merge")) {
                return ResManager.loadKDString((String)"%s\u4e3a\u672c\u5355\u5408\u5e76\u7ec4\u7ec7\u4e2d\u7684\u5408\u5e76\u540e\u7ec4\u7ec7\uff0c\u4e0d\u53ef\u505c\u7528\u7ec4\u7ec7\u3002", (String)"AdminOrgBatchChartHelper_19", (String)"odc-homs-business", (Object[])new Object[]{message});
            }
            if (!HRStringUtils.equals((String)prefix, (String)"split")) continue;
            return ResManager.loadKDString((String)"%s\u4e3a\u672c\u5355\u62c6\u5206\u7ec4\u7ec7\u4e2d\u7684\u62c6\u5206\u540e\u7ec4\u7ec7\uff08\u975e\u62c6\u5206\u524d\u7ec4\u7ec7\uff09\uff0c\u4e0d\u53ef\u505c\u7528\u7ec4\u7ec7\u3002", (String)"AdminOrgBatchChartHelper_20", (String)"odc-homs-business", (Object[])new Object[]{message});
        }
        DynamicObject dutyOrg = dataEntity.getDynamicObject("org");
        long dutyOrgId = dutyOrg.getLong("id");
        String dutyOrgMessage = orgIdSet.stream().filter(orgId -> (Long)orgIdDutyMap.get(orgId) != dutyOrgId).map(orgIdNameMap::get).collect(Collectors.joining(","));
        if (HRStringUtils.isNotEmpty((String)dutyOrgMessage)) {
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5728\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\uff0c\u4e0d\u53ef\u505c\u7528\u7ec4\u7ec7\u3002", (String)"AdminOrgBatchChartHelper_16", (String)"odc-homs-business", (Object[])new Object[0]), dutyOrgMessage, dutyOrg.getString("name"));
        }
        if (isRootId.get()) {
            return ResManager.loadResFormat((String)"\u6839\u7ec4\u7ec7\u4e0d\u53ef\u64cd\u4f5c\u201c\u505c\u7528\u7ec4\u7ec7\u201d\u3002", (String)"AdminOrgBatchChartHelper_8", (String)"odc-homs-business", (Object[])new Object[0]);
        }
        return null;
    }

    private static Map<String, Set<Long>> orgChangeTypeMap(Set<Long> orgIdSet, DynamicObject dataEntity) {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>();
        entryPrefixList.forEach(prefix -> {
            if (HRStringUtils.equals((String)prefix, (String)"split")) {
                Set splitTargetOrgIdSet = AdminOrgBatchChgHelper.getSplitTargetOrgIdSet(dataEntity).stream().filter(orgIdSet::contains).collect(Collectors.toSet());
                map.put((String)prefix, splitTargetOrgIdSet);
            } else {
                DynamicObjectCollection entities = dataEntity.getDynamicObjectCollection("entryentity_" + prefix);
                map.put((String)prefix, entities.stream().map(dy -> AdminOrgBatchChartHelper.getEntryOrgId(prefix, dy)).filter(orgIdSet::contains).collect(Collectors.toSet()));
            }
        });
        return map;
    }

    private static Long getEntryOrgId(String prefix, DynamicObject dy) {
        if (HRStringUtils.equals((String)prefix, (String)"add")) {
            return dy.getLong("add_adminorg");
        }
        if (HRStringUtils.equals((String)prefix, (String)"parent")) {
            return dy.getLong("parent_adminorg.id");
        }
        if (HRStringUtils.equals((String)prefix, (String)"info")) {
            return dy.getLong("info_adminorg.id");
        }
        if (HRStringUtils.equals((String)prefix, (String)"merge")) {
            return dy.getLong("merge_target_org.id");
        }
        return 0L;
    }

    public static String checkParentOrg(Set<Long> orgIdSet, DynamicObject dataEntity) {
        DynamicObject dutyOrg = dataEntity.getDynamicObject("org");
        Map<Long, String> orgIdNameMap = AdminOrgBatchChartHelper.assembleOrgIdNameMap(dataEntity);
        DynamicObjectCollection disableColl = dataEntity.getDynamicObjectCollection("entryentity_disable");
        Set disOrgIdSet = disableColl.stream().map(dy -> dy.getLong("disable_adminorg.id")).collect(Collectors.toSet());
        DynamicObject[] billOrgArr = AdminOrgBatchChartHelper.queryBillOrg(orgIdSet);
        AtomicBoolean isRootId = new AtomicBoolean(false);
        Map<Long, DynamicObject> orgMap = AdminOrgBatchChartHelper.queryAdminOrg(orgIdSet, isRootId);
        for (Long orgId : orgIdSet) {
            DynamicObject adminOrg = orgMap.get(orgId);
            String orgName = orgIdNameMap.get(orgId);
            if (HRStringUtils.isEmpty((String)orgName)) {
                orgName = adminOrg.getString("name");
            }
            if (disOrgIdSet.contains(orgId)) {
                return String.format(Locale.ROOT, ResManager.loadResFormat((String)"%s\u5b58\u5728\u672c\u5355\u505c\u7528\u7ec4\u7ec7\u4e2d\uff0c\u4e0d\u53ef\u8c03\u6574\u4e0a\u7ea7\u3002", (String)"AdminOrgBatchChartHelper_5", (String)"odc-homs-business", (Object[])new Object[0]), orgName);
            }
            if (adminOrg.getLong("org.id") != dutyOrg.getLong("id")) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5728\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\uff0c\u4e0d\u53ef\u8c03\u6574\u4e0a\u7ea7\u3002", (String)"AdminOrgBatchChartHelper_17", (String)"odc-homs-business", (Object[])new Object[0]), orgName, dutyOrg.getString("name"));
            }
            String message = AdminOrgBatchChartHelper.checkBillOrg(OrgBatchChgBillConstants.CHANGE_TYPE_PARENT, orgId, orgName, billOrgArr);
            if (!HRStringUtils.isNotEmpty((String)message)) continue;
            return message;
        }
        if (isRootId.get()) {
            return ResManager.loadResFormat((String)"\u6839\u7ec4\u7ec7\u4e0d\u53ef\u64cd\u4f5c\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u3002", (String)"AdminOrgBatchChartHelper_9", (String)"odc-homs-business", (Object[])new Object[0]);
        }
        return null;
    }

    public static String checkInfoOrg(Set<Long> orgIdSet, DynamicObject dataEntity) {
        DynamicObject dutyOrg = dataEntity.getDynamicObject("org");
        Map<Long, String> orgIdNameMap = AdminOrgBatchChartHelper.assembleOrgIdNameMap(dataEntity);
        DynamicObject[] billOrgArr = AdminOrgBatchChartHelper.queryBillOrg(orgIdSet);
        Map<Long, DynamicObject> orgMap = AdminOrgBatchChartHelper.queryAdminOrg(orgIdSet, null);
        for (Long orgId : orgIdSet) {
            DynamicObject adminOrg = orgMap.get(orgId);
            String orgName = orgIdNameMap.get(orgId);
            if (HRStringUtils.isEmpty((String)orgName)) {
                orgName = adminOrg.getString("name");
            }
            if (adminOrg.getLong("org.id") != dutyOrg.getLong("id")) {
                return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5728\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\uff0c\u4e0d\u53ef\u53d8\u66f4\u4fe1\u606f\u3002", (String)"AdminOrgBatchChartHelper_18", (String)"odc-homs-business", (Object[])new Object[0]), orgName, dutyOrg.getString("name"));
            }
            String message = AdminOrgBatchChartHelper.checkBillOrg(OrgBatchChgBillConstants.CHANGE_TYPE_INFO, orgId, orgName, billOrgArr);
            if (!HRStringUtils.isNotEmpty((String)message)) continue;
            return message;
        }
        return null;
    }

    private static String checkBillOrg(Long changeType, Long orgId, String orgName, DynamicObject[] billOrgArr) {
        String result = null;
        for (DynamicObject dy : billOrgArr) {
            if (!orgId.equals(dy.getLong("adminorg.id"))) continue;
            String changeTypeName = dy.getString("changetype.name");
            if (HRStringUtils.isEmpty((String)orgName)) {
                orgName = dy.getString("adminorg.name");
            }
            if (OrgBatchChgBillConstants.CHANGE_TYPE_PARENT.equals(changeType)) {
                result = String.format(Locale.ROOT, ResManager.loadResFormat((String)"\u201c%1$s\u201d\u5b58\u5728\u5ba1\u6279\u4e2d\u7684\u201c%2$s\u201d\u8bb0\u5f55\uff0c\u4e0d\u53ef\u8c03\u6574\u4e0a\u7ea7\u3002", (String)"AdminOrgBatchChartHelper_6", (String)"odc-homs-business", (Object[])new Object[0]), orgName, changeTypeName);
                break;
            }
            if (!OrgBatchChgBillConstants.CHANGE_TYPE_INFO.equals(changeType)) break;
            result = String.format(Locale.ROOT, ResManager.loadResFormat((String)"\u201c%1$s\u201d\u5b58\u5728\u5ba1\u6279\u4e2d\u7684\u201c%2$s\u201d\u8bb0\u5f55\uff0c\u4e0d\u53ef\u53d8\u66f4\u4fe1\u606f\u3002", (String)"AdminOrgBatchChartHelper_7", (String)"odc-homs-business", (Object[])new Object[0]), orgName, changeTypeName);
            break;
        }
        return result;
    }

    private static Map<Long, String> assembleOrgIdNameMap(DynamicObject dataEntity) {
        HashMap orgIdNameMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection addColl = dataEntity.getDynamicObjectCollection("entryentity_add");
        addColl.forEach(dy -> orgIdNameMap.put(dy.getLong("add_adminorg"), dy.getString("add_name")));
        DynamicObjectCollection parentColl = dataEntity.getDynamicObjectCollection("entryentity_parent");
        parentColl.forEach(dy -> orgIdNameMap.put(dy.getLong("parent_adminorg.id"), dy.getString("parent_name")));
        DynamicObjectCollection infoColl = dataEntity.getDynamicObjectCollection("entryentity_info");
        infoColl.forEach(dy -> orgIdNameMap.put(dy.getLong("info_adminorg.id"), dy.getString("info_name")));
        DynamicObjectCollection disableColl = dataEntity.getDynamicObjectCollection("entryentity_disable");
        disableColl.forEach(dy -> orgIdNameMap.put(dy.getLong("disable_adminorg.id"), dy.getString("disable_adminorg.name")));
        return orgIdNameMap;
    }

    public static Map<Long, String> queryAdminOrgByOrgIdSet(Set<Long> orgIdSet, AtomicBoolean isRootId) {
        QFilter adminFilter = new QFilter("id", "in", orgIdSet);
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObjectCollection orgColl = adminHelper.queryOriginalCollection("id,boid,name", new QFilter[]{adminFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)1);
        for (DynamicObject dy : orgColl) {
            result.put(dy.getLong("id"), dy.getString("name"));
            if (PlatformRootUtils.getLongRootIdOfPlatform() != dy.getLong("boid")) continue;
            isRootId.set(true);
        }
        return result;
    }

    private static Map<Long, DynamicObject> queryAdminOrg(Set<Long> orgIdSet, AtomicBoolean isRootId) {
        QFilter adminFilter = new QFilter("id", "in", orgIdSet);
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObjectCollection orgColl = adminHelper.queryOriginalCollection("id,boid,name,org.id", new QFilter[]{adminFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)1);
        for (DynamicObject dy : orgColl) {
            result.put(dy.getLong("id"), dy);
            if (isRootId == null || PlatformRootUtils.getLongRootIdOfPlatform() != dy.getLong("boid")) continue;
            isRootId.set(true);
        }
        return result;
    }

    public static DynamicObject[] queryBillOrg(Set<Long> orgIdSet) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        QFilter auditFilter = new QFilter("auditstatus", "in", Arrays.asList("B", "D"));
        DynamicObjectCollection billColl = baseServiceHelper.queryOriginalCollection("id", new QFilter[]{auditFilter});
        List billIdList = billColl.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper entryHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter entryFilter = new QFilter("billid", "in", billIdList);
        entryFilter.and(new QFilter("adminorg", "in", orgIdSet));
        return Arrays.stream(entryHelper.loadDynamicObjectArray(new QFilter[]{entryFilter})).filter(entry -> HRStringUtils.isEmpty((String)entry.getString("number"))).collect(Collectors.toList()).toArray(new DynamicObject[0]);
    }

    public static List<String> checkSplitOrg(DynamicObject billDy, List<OrgChartCheckVO> orgList, Long splitOriginId) {
        Set<Long> orgIdSet = orgList.stream().map(OrgChartCheckVO::getOrgId).collect(Collectors.toSet());
        Set<Long> processBillSet = AdminOrgBatchChartHelper.queryBillByOrg(billDy.getLong("id"), orgIdSet);
        Set<Long> splitOrgSet = AdminOrgBatchChartHelper.getMergeAndSplitOrg(billDy.getDynamicObjectCollection("entryentity_split"), "to_split_org", "split_target_org", splitOriginId);
        Set<Long> mergeOrgSet = AdminOrgBatchChartHelper.getMergeAndSplitOrg(billDy.getDynamicObjectCollection("entryentity_merge"), "merge_target_org", "to_merge_org", null);
        ArrayList<String> errInfoList = new ArrayList<String>(orgList.size());
        ArrayList<String> splitOrgNames = new ArrayList<String>(orgList.size());
        ArrayList<String> mergeOrgNames = new ArrayList<String>(orgList.size());
        ArrayList<String> processBillNames = new ArrayList<String>(orgList.size());
        ArrayList<String> disableNames = new ArrayList<String>(orgList.size());
        for (OrgChartCheckVO org : orgList) {
            if (splitOrgSet.contains(org.getOrgId())) {
                splitOrgNames.add(org.getOrgName());
            }
            if (mergeOrgSet.contains(org.getOrgId())) {
                mergeOrgNames.add(org.getOrgName());
            }
            if (processBillSet.contains(org.getOrgId())) {
                processBillNames.add(org.getOrgName());
            }
            if (!"0".equals(org.getEnable())) continue;
            disableNames.add(org.getOrgName());
        }
        if (splitOrgNames.size() != 0) {
            errInfoList.add(ResManager.loadKDString((String)"%s\u5b58\u5728\u62c6\u5206\u7ec4\u7ec7\u8bb0\u5f55\uff0c\u4e0d\u53ef\u64cd\u4f5c\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u3002", (String)"AdminOrgBatchChartHelper_12", (String)"odc-homs-business", (Object[])new Object[]{String.join((CharSequence)",", splitOrgNames)}));
        }
        if (mergeOrgNames.size() != 0) {
            errInfoList.add(ResManager.loadKDString((String)"%s\u5b58\u5728\u5408\u5e76\u7ec4\u7ec7\u8bb0\u5f55\uff0c\u4e0d\u53ef\u64cd\u4f5c\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u3002", (String)"AdminOrgBatchChartHelper_13", (String)"odc-homs-business", (Object[])new Object[]{String.join((CharSequence)",", mergeOrgNames)}));
        }
        if (processBillNames.size() != 0) {
            errInfoList.add(ResManager.loadKDString((String)"%s\u5b58\u5728\u5176\u4ed6\u5728\u9014\u8c03\u6574\uff0c\u4e0d\u53ef\u64cd\u4f5c\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u3002", (String)"AdminOrgBatchChartHelper_14", (String)"odc-homs-business", (Object[])new Object[]{String.join((CharSequence)",", processBillNames)}));
        }
        if (disableNames.size() != 0) {
            errInfoList.add(ResManager.loadKDString((String)"%s\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u542f\u7528\u201d\uff0c\u4e0d\u53ef\u64cd\u4f5c\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u3002", (String)"AdminOrgBatchChartHelper_15", (String)"odc-homs-business", (Object[])new Object[]{String.join((CharSequence)",", disableNames)}));
        }
        return errInfoList;
    }

    private static Set<Long> queryBillByOrg(Long billId, Set<Long> orgIdSet) {
        HRBaseServiceHelper billHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        QFilter auditFilter = new QFilter("billstatus", "in", Arrays.asList("B", "D"));
        auditFilter.and("id", "!=", (Object)billId);
        DynamicObjectCollection billColl = billHelper.queryOriginalCollection("id", auditFilter.toArray());
        List billIdList = billColl.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper entityHelp = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter entityFilter = new QFilter("billid", "in", billIdList);
        entityFilter.and(new QFilter("adminorg", "in", orgIdSet));
        DynamicObjectCollection entityCol = entityHelp.queryOriginalCollection("adminorg", entityFilter.toArray());
        return entityCol.stream().map(dy -> dy.getLong("adminorg")).collect(Collectors.toSet());
    }

    private static Set<Long> getMergeAndSplitOrg(DynamicObjectCollection entityCol, String propertyName, String multiPropertyName, Long splitOriginId) {
        HashSet<Long> set = new HashSet<Long>(16);
        for (DynamicObject entityDy : entityCol) {
            DynamicObjectCollection col;
            if (splitOriginId != null && splitOriginId.longValue() == entityDy.getLong("split_origin_id")) continue;
            DynamicObject orgDy = entityDy.getDynamicObject(propertyName);
            if (orgDy != null) {
                set.add(orgDy.getLong("id"));
            }
            if ((col = entityDy.getDynamicObjectCollection(multiPropertyName)) == null) continue;
            col.forEach(dy -> set.add(dy.getDynamicObject("fbasedataid").getLong("id")));
        }
        return set;
    }
}

