/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.rpc.HRCSRPCServiceHelper;
import kd.hr.haos.business.service.adminorg.util.AdminOrgFindBelongCompanyHelper;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.HAOSPermUtils;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.model.adminorg.FindBelongCompanyModel;
import kd.hr.haos.common.util.DyCollectors;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.constants.HRBaseConstants;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.model.AuthorizedStructResult;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.AdminOrgBatchChartBaseHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.ChangeTypeEnum;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.sdk.odc.homs.model.SetFilterEvent;
import kd.sdk.odc.homs.service.IBatchBillFilterService;
import org.apache.commons.lang3.time.DateUtils;

public class AdminOrgBatchChgHelper
implements HRBaseConstants {
    private static final Log log = LogFactory.getLog(AdminOrgBatchChgHelper.class);
    private static final Map<String, String> changeTypeToLocaleMap;
    private static final String ORG_DETAIL_PROPERTIES = "id,boid,adminorgtype.id,parentorg.id,name,simplename,number,establishmentdate,corporateorg,adminorgfunction,companyarea,city,detailaddress,index,description,positioning,mainduty,safelevel,safetype,safedescription,workplace,tobedisableflag,tobedisabledate,adminorglayer";
    public static Set<String> mergeAndSplitFields;
    public static Map<String, String> mergeAndSplitFieldsExcludeMap;
    public static String[] entryEntityName;

    public static String getAuditstatusName(String status) {
        String statusName = "";
        switch (status) {
            case "B": {
                statusName = ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"BillAUDITSTATUS_1", (String)"odc-homs-business", (Object[])new Object[0]);
                break;
            }
            case "D": {
                statusName = ResManager.loadKDString((String)"\u5ba1\u6279\u4e2d", (String)"BillAUDITSTATUS_2", (String)"odc-homs-business", (Object[])new Object[0]);
                break;
            }
            case "C": {
                statusName = ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7", (String)"BillAUDITSTATUS_3", (String)"odc-homs-business", (Object[])new Object[0]);
                break;
            }
            case "E": {
                statusName = ResManager.loadKDString((String)"\u5ba1\u6279\u4e0d\u901a\u8fc7", (String)"BillAUDITSTATUS_4", (String)"odc-homs-business", (Object[])new Object[0]);
                break;
            }
            case "F": {
                statusName = ResManager.loadKDString((String)"\u5df2\u5e9f\u5f03", (String)"BillAUDITSTATUS_5", (String)"odc-homs-business", (Object[])new Object[0]);
                break;
            }
            case "G": {
                statusName = ResManager.loadKDString((String)"\u5f85\u91cd\u65b0\u63d0\u4ea4", (String)"BillAUDITSTATUS_6", (String)"odc-homs-business", (Object[])new Object[0]);
                break;
            }
            case "LD": {
                statusName = ResManager.loadKDString((String)"\u5df2\u5220\u9664", (String)"BillAUDITSTATUS_7", (String)"odc-homs-business", (Object[])new Object[0]);
                break;
            }
        }
        return statusName;
    }

    public static void openViewForm(IFormView iFormView, String operation, String pluginName, QFilter filter) {
        String billStatus;
        if (iFormView.getModel().getValue("org") == null) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"MainDutyUnitTip", (String)"odc-homs-business", (Object[])new Object[0]));
            return;
        }
        HRBaseServiceHelper orgBatchChgBillHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        QFilter idFilter = new QFilter("id", "=", (Object)iFormView.getModel().getDataEntity().getLong("id"));
        DynamicObject dynamicObject = orgBatchChgBillHelper.queryOne("id, billstatus", idFilter.toArray());
        if (!(dynamicObject == null || (billStatus = dynamicObject.getString("billstatus")).equals("A") || billStatus.equals("G") || billStatus.equals("D") || billStatus.equals("B") && HRStringUtils.equals((String)iFormView.getFormShowParameter().getAppId(), (String)"wftask"))) {
            String operateLocaleName = changeTypeToLocaleMap.get(operation);
            String auditstatusName = AdminOrgBatchChgHelper.getAuditstatusName(dynamicObject.getString("billstatus"));
            iFormView.showErrorNotification(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5355\u636e\u4e0d\u80fd\u201c%2$s\u201d\u3002", (String)"AdminorgBatchChgPlugin_1", (String)"odc-homs-business", (Object[])new Object[]{auditstatusName, operateLocaleName}));
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        if (filter != null) {
            listShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
        switch (operation) {
            case "add": {
                BillShowParameter formShowParameter = new BillShowParameter();
                formShowParameter.setFormId("homs_batchorgentityadd");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCustomParam("billid", (Object)iFormView.getModel().getDataEntity().getLong("id"));
                formShowParameter.setCustomParam("billBsed", (Object)iFormView.getModel().getDataEntity().getDate("effdt"));
                formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, "add_org"));
                if (HRStringUtils.equals((String)"0", (String)iFormView.getPageCache().get("isList"))) {
                    formShowParameter.setCustomParam("parentId", (Object)iFormView.getPageCache().get("parentId"));
                    formShowParameter.setCustomParam("adminOrgTypeStdId", (Object)iFormView.getPageCache().get("adminOrgTypeStdId"));
                }
                formShowParameter.setCustomParam("org", (Object)iFormView.getModel().getDataEntity().getLong("org.id"));
                int sequence = AdminOrgBatchChgHelper.getEntrySeq(iFormView.getModel(), OrgBatchChgBillConstants.CHANGE_TYPE_ADD);
                formShowParameter.setCustomParam("sequence", (Object)sequence);
                iFormView.showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "parent": 
            case "infochg": 
            case "disable": {
                QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", Collections.singletonList(((DynamicObject)iFormView.getModel().getValue("org")).getLong("id")));
                listShowParameter.getListFilterParameter().getQFilters().add(baseDataFilter);
                AdminOrgBatchChgHelper.getAdminorgList(iFormView, operation, listShowParameter);
                if (HRStringUtils.equals((String)operation, (String)"disable")) {
                    AdminOrgBatchChgHelper.excludeMergeSplitTargetOrg(iFormView, listShowParameter.getListFilterParameter().getQFilters());
                }
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("isvirtualorg", "!=", (Object)Character.valueOf('1')));
                listShowParameter.getListFilterParameter().getQFilters().add(AdminOrgBatchChgHelper.getHomsCurUserPermFilter("homs_orgbatchchgbill", "adminorgboid", "47150e89000000ac"));
                AdminOrgBatchChgHelper.bachBillAddRowFilterExtend(operation, listShowParameter.getListFilterParameter().getQFilters());
                listShowParameter.setCloseCallBack(new CloseCallBack(pluginName, operation));
                listShowParameter.setHasRight(true);
                iFormView.showForm((FormShowParameter)listShowParameter);
                break;
            }
        }
    }

    private static QFilter getHomsCurUserPermFilter(String entity, String propKey, String permItem) {
        return (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRuleForBdProp", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "217WYC/L9U7E", entity, propKey, permItem, null});
    }

    private static void bachBillAddRowFilterExtend(String operation, List<QFilter> filterList) {
        SetFilterEvent setFilterEvent = new SetFilterEvent();
        setFilterEvent.setEventName(operation);
        setFilterEvent.setFilterList(filterList);
        PluginProxy batchBillFilterServicePluginProxy = PluginProxy.create(IBatchBillFilterService.class, (String)"kd.sdk.odc.homs.service.IBatchBillFilterService");
        if (batchBillFilterServicePluginProxy != null) {
            batchBillFilterServicePluginProxy.callReplace(plugin -> {
                plugin.setFilter(setFilterEvent);
                return null;
            });
        }
    }

    public static void excludeMergeSplitTargetOrg(IFormView iFormView, List<QFilter> list) {
        DynamicObject dataEntity = iFormView.getModel().getDataEntity(true);
        DynamicObjectCollection merge = dataEntity.getDynamicObjectCollection("entryentity_merge");
        Set mergeSplitTargetOrgIdSet = merge.stream().filter(entry -> entry.getDynamicObject("merge_target_org") != null).map(entry -> entry.getDynamicObject("merge_target_org").getLong("id")).collect(Collectors.toSet());
        mergeSplitTargetOrgIdSet.addAll(AdminOrgBatchChgHelper.getSplitTargetOrgIdSet(dataEntity));
        if (!CollectionUtils.isEmpty(mergeSplitTargetOrgIdSet)) {
            list.add(new QFilter("id", "not in", mergeSplitTargetOrgIdSet));
        }
    }

    public static Set<Long> getSplitTargetOrgIdSet(DynamicObject dataEntity) {
        HashSet<Long> splitTargetOrgIdSet = new HashSet<Long>();
        DynamicObjectCollection split = dataEntity.getDynamicObjectCollection("entryentity_split");
        split.forEach(entry -> {
            DynamicObjectCollection splitTargetOrg = entry.getDynamicObjectCollection("split_target_org");
            long toSplitOrgId = entry.getLong("to_split_org.id");
            if (splitTargetOrg != null) {
                splitTargetOrgIdSet.addAll(splitTargetOrg.stream().filter(org -> toSplitOrgId != org.getDynamicObject("fbasedataid").getLong("id")).map(org -> org.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet()));
            }
        });
        return splitTargetOrgIdSet;
    }

    public static void getAdminorgList(IFormView iFormView, String operation, ListShowParameter listShowParameter) {
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("haos_orgbatchtreelistf7");
        listShowParameter.setBillFormId("haos_adminorgf7");
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"AdminorgFastChgPlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("960px");
        cssValue.setHeight("620px");
        listShowParameter.getOpenStyle().setInlineStyleCss(cssValue);
        listShowParameter.setLookUp(true);
        listShowParameter.setHasRight(true);
        listShowParameter.setShowTitle(false);
        Date date = DateUtils.truncate((Date)new Date(), (int)5);
        listShowParameter.getCustomParams().put("searchdate", date);
        listShowParameter.getListFilterParameter().getQFilters().add(AdminOrgBatchChgHelper.setOrgAuth(iFormView));
    }

    public static ListShowParameter getExchangeOrgList(IFormView iFormView) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("haos_adminorgbatch");
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"AdminorgFastChgPlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("1000px");
        cssValue.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(cssValue);
        listShowParameter.setLookUp(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setHasRight(true);
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        enableFilter.and(new QFilter("org", "=", (Object)iFormView.getModel().getDataEntity().getLong("org.id")));
        AuthorizedOrgResult permResult = AdminOrgBatchChgHelper.getOrgAuth(iFormView);
        if (permResult != null && !permResult.isHasAllOrgPerm()) {
            QFilter authFilter = new QFilter("boid", "in", (Object)permResult.getHasPermOrgs());
            enableFilter.and(authFilter);
        }
        qFilters.add(enableFilter);
        QFilter isCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"0");
        Date effDate = new Date();
        qFilters.add(new QFilter("bsed", "<=", (Object)effDate));
        qFilters.add(new QFilter("bsled", ">=", (Object)effDate));
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection addCollection = iFormView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_add");
        if (!CollectionUtils.isEmpty((Collection)addCollection)) {
            Set longSet = addCollection.stream().map(s -> s.getLong("add_adminorg")).collect(Collectors.toSet());
            QFilter currentOrderFilter = new QFilter("id", "in", longSet);
            isCurrentVersion = isCurrentVersion.or(currentOrderFilter);
            dataStatusFilter = dataStatusFilter.or(currentOrderFilter);
            statusFilter = statusFilter.or(currentOrderFilter);
        }
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        qFilters.add(initStatusFilter);
        qFilters.add(isCurrentVersion);
        qFilters.add(dataStatusFilter);
        qFilters.add(statusFilter);
        listShowParameter.setShowApproved(false);
        return listShowParameter;
    }

    public static QFilter setOrgAuth(IFormView iFormView) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        QFilter currentBillOrgFilter = AdminOrgBatchChgHelper.filterCurrentBillOrg(iFormView);
        qFilter.and(currentBillOrgFilter);
        return qFilter;
    }

    public static void filterF7Org(IFormView iFormView, BeforeF7SelectEvent event, QFilter filter) {
        FormShowParameter formShowParameter = event.getFormShowParameter();
        formShowParameter.setFormId("haos_orgbatchtreelistf7");
        log.info("[\u884c\u653f\u7ec4\u7ec7F7\u8fc7\u6ee4\u6761\u4ef6]");
        event.getCustomQFilters().add(filter);
        Object originalValue = event.getOriginalValue();
        if (originalValue instanceof DynamicObject) {
            DynamicObject originalVal = (DynamicObject)originalValue;
            long currentOrgId = originalVal.getLong("id");
            QFilter orgIdFilter = new QFilter("id", "!=", (Object)currentOrgId);
            event.getCustomQFilters().add(orgIdFilter);
        }
        if (!mergeAndSplitFields.contains(event.getProperty().getName())) {
            QFilter currentBillOrgFilter = AdminOrgBatchChgHelper.filterCurrentBillOrg(iFormView);
            event.getCustomQFilters().add(currentBillOrgFilter);
        }
        Date date = DateUtils.truncate((Date)new Date(), (int)5);
        QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", Collections.singletonList(((DynamicObject)iFormView.getModel().getValue("org")).getLong("id")));
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        QFilter dateFilter = new QFilter("bsed", "<=", (Object)date).and("bsled", ">=", (Object)date);
        dateFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        event.getCustomQFilters().add(dateFilter);
        dataStatusFilter.and(new QFilter("initstatus", "in", (Object)"2"));
        event.getCustomQFilters().add(dataStatusFilter);
        event.getCustomQFilters().add(baseDataFilter);
        event.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"AdminorgFastChgPlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
    }

    public static QFilter filterCurrentBillOrg(IFormView iFormView) {
        ArrayList list = new ArrayList();
        DynamicObjectCollection info = new DynamicObjectCollection();
        DynamicObjectCollection parent = new DynamicObjectCollection();
        DynamicObjectCollection disable = new DynamicObjectCollection();
        if (iFormView.getEntityId().equals("homs_orgbatchchgbill")) {
            info = iFormView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_info");
            parent = iFormView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_parent");
            disable = iFormView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_disable");
        } else if (iFormView.getEntityId().equals("homs_chartparentlist")) {
            info = iFormView.getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_info");
            parent = iFormView.getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_parent");
            disable = iFormView.getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_disable");
        }
        if (info != null) {
            list.addAll(info.stream().map(org -> org.getLong("info_adminorg.id")).collect(Collectors.toList()));
        }
        if (parent != null) {
            list.addAll(parent.stream().map(org -> org.getLong("parent_adminorg.id")).collect(Collectors.toList()));
        }
        if (disable != null) {
            list.addAll(disable.stream().map(org -> org.getLong("disable_adminorg.id")).collect(Collectors.toList()));
        }
        if (list.isEmpty()) {
            return new QFilter("id", "!=", (Object)20000L);
        }
        return new QFilter("id", "not in", list);
    }

    public static AuthorizedOrgResult getOrgAuth(IFormView iFormView, Long structId) {
        Long userId = RequestContext.get().getCurrUserId();
        String permItemId = "47150e89000000ac";
        String appId = "homs";
        String propKey = "struct_parent_org";
        Map map = HAOSPermUtils.getStructProjectCustomInParam((String)propKey, (long)structId);
        AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserAdminOrgsF7", (Object[])new Object[]{userId, appId, iFormView.getEntityId(), permItemId, propKey, map});
        return permResult;
    }

    public static AuthorizedOrgResult getOrgAuth(IFormView iFormView) {
        Long userId = RequestContext.get().getCurrUserId();
        String permItemId = "47150e89000000ac";
        String appId = "homs";
        AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgsF7", (Object[])new Object[]{userId, appId, "homs_orgbatchchgbill", permItemId, "adminorgboid", Boolean.FALSE});
        return permResult;
    }

    public static AuthorizedOrgResult getOrgAuthByPermItemId(String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgsF7", (Object[])new Object[]{userId, "homs", "homs_orgbatchchgbill", permItemId, "adminorgboid", Boolean.FALSE});
        return permResult;
    }

    public static AuthorizedOrgResult getOrgAuth(String entityName, String propKey) {
        Long userId = RequestContext.get().getCurrUserId();
        String permItemId = "47150e89000000ac";
        String appId = "homs";
        AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgsF7", (Object[])new Object[]{userId, appId, entityName, permItemId, propKey, Boolean.FALSE});
        return permResult;
    }

    public static DynamicObject[] getOrgDyCollectionByIds(List<Long> orgIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("id", "in", orgIds);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(qFilter.toArray());
        return dynamicObjects;
    }

    public static Map<Long, DynamicObject> getOrgId2BasicInfoDynMapByIds(List<Long> orgIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("id", "in", orgIdList);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(qFilter.toArray());
        Map<Long, DynamicObject> orgId2DynMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        return orgId2DynMap;
    }

    public static DynamicObject getOrgDyById(Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("id", "=", (Object)orgId);
        DynamicObject dynamicObject = serviceHelper.loadDynamicObject(qFilter.toArray());
        return dynamicObject;
    }

    public static DynamicObject[] getOrgDyById(List<Long> orgIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("id", "in", orgIds);
        DynamicObject[] dynamicObject = serviceHelper.loadDynamicObjectArray(qFilter.toArray());
        return dynamicObject;
    }

    public static DynamicObject[] getOrgDyById(String selectedProperties, List<Long> orgIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("id", "in", orgIds);
        DynamicObject[] dynamicObject = serviceHelper.query(selectedProperties, qFilter.toArray());
        return dynamicObject;
    }

    public static Map<Long, Boolean> getAdminOrg2FlagMap(List<Long> orgIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("id", "in", orgIdList);
        DynamicObject[] adminOrgDetails = serviceHelper.query("id, tobedisableflag", qFilter.toArray());
        Map<Long, Boolean> adminOrg2FlagMap = Arrays.stream(adminOrgDetails).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getBoolean("tobedisableflag")));
        return adminOrg2FlagMap;
    }

    public static DynamicObject[] getOldOrgCoopArr(Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.query("id,coopreltype,cooporgteam,cooporgteam.otclassify,bsed", new QFilter[]{filter}, "index asc");
        return dynamicObjects;
    }

    public static Map<Long, List<DynamicObject>> getOrgId2CoopDynsMap(List<Long> orgIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter filter = new QFilter("org", "in", orgIdList);
        filter.and("coopreltype", "!=", (Object)1010L);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        Map<Long, List<DynamicObject>> orgId2OrgCoopListMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dyn -> dyn.getLong("org.id")));
        return orgId2OrgCoopListMap;
    }

    public static Map<Long, List<DynamicObject>> getOrgId2CoopDynsMapIngnoreEnabled(Set<Long> orgIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter filter = new QFilter("org", "in", orgIdList);
        filter.and("coopreltype", "!=", (Object)1010L);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        Map<Long, List<DynamicObject>> orgId2OrgCoopListMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dyn -> dyn.getLong("org.id")));
        return orgId2OrgCoopListMap;
    }

    public static DynamicObject getCompany(Long orgId) {
        HRBaseServiceHelper companyServiceHelper = new HRBaseServiceHelper("haos_adminorgcompany");
        QFilter companyFilter = new QFilter("adminorg", "=", (Object)orgId).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)"1");
        DynamicObject dynamicObject = companyServiceHelper.queryOne("id,adminorg,companytype,industrytype", companyFilter.toArray());
        return dynamicObject;
    }

    public static Map<Long, DynamicObject> getOrgId2CompanyDynMap(List<Long> orgIdList) {
        HRBaseServiceHelper companyServiceHelper = new HRBaseServiceHelper("haos_adminorgcompany");
        QFilter companyFilter = new QFilter("adminorg", "in", orgIdList).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = companyServiceHelper.query("id,adminorg,companytype,industrytype", companyFilter.toArray());
        Map<Long, DynamicObject> orgId2CompanyDynMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg.id"), dyn -> dyn));
        return orgId2CompanyDynMap;
    }

    public static DynamicObject getGroup(Long orgId) {
        HRBaseServiceHelper groupServiceHelper = new HRBaseServiceHelper("haos_adminorggroup");
        QFilter groupFilter = new QFilter("adminorg", "=", (Object)orgId).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)"1");
        DynamicObject dynamicObject = groupServiceHelper.queryOne("id,adminorg,groupvision,groupleader,groupmission", groupFilter.toArray());
        return dynamicObject;
    }

    public static Map<Long, DynamicObject> getOrgId2GroupDynMap(List<Long> orgIdList) {
        HRBaseServiceHelper companyServiceHelper = new HRBaseServiceHelper("haos_adminorggroup");
        QFilter groupFilter = new QFilter("adminorg", "in", orgIdList).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = companyServiceHelper.query("id,adminorg,groupvision,groupleader,groupmission", groupFilter.toArray());
        Map<Long, DynamicObject> orgId2GroupDynMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg.id"), dyn -> dyn));
        return orgId2GroupDynMap;
    }

    public static DynamicObject getDepartment(Long orgId) {
        HRBaseServiceHelper departmentServiceHelper = new HRBaseServiceHelper("haos_adminorgdepartment");
        QFilter departmentFilter = new QFilter("adminorg", "=", (Object)orgId).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)"1");
        DynamicObject dynamicObject = departmentServiceHelper.queryOne("id,adminorg,departmenttype", departmentFilter.toArray());
        return dynamicObject;
    }

    public static Map<Long, DynamicObject> getOrgId2DepartmentDynMap(List<Long> orgIdList) {
        HRBaseServiceHelper companyServiceHelper = new HRBaseServiceHelper("haos_adminorgdepartment");
        QFilter departmentFilter = new QFilter("adminorg", "in", orgIdList).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = companyServiceHelper.query("id,adminorg,departmenttype", departmentFilter.toArray());
        Map<Long, DynamicObject> orgId2GroupDynMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg.id"), dyn -> dyn));
        return orgId2GroupDynMap;
    }

    public static void setOrgInfoViewByType(Long adminOrgTypeId, IFormView iFormView) {
        iFormView.setVisible(Boolean.TRUE, new String[]{"group_flex", "company_flex", "dept_flex"});
        if (adminOrgTypeId.equals(1010L)) {
            iFormView.setVisible(Boolean.FALSE, new String[]{"dept_flex"});
        } else if (adminOrgTypeId.equals(1020L)) {
            iFormView.setVisible(Boolean.FALSE, new String[]{"dept_flex", "group_flex"});
        } else if (adminOrgTypeId.equals(1030L)) {
            iFormView.setVisible(Boolean.FALSE, new String[]{"dept_flex", "group_flex", "company_flex"});
        } else if (adminOrgTypeId.equals(1040L)) {
            iFormView.setVisible(Boolean.FALSE, new String[]{"group_flex", "company_flex"});
        }
    }

    public static List<Long> getOrgAndChildren(Long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HRBaseServiceHelper departmentServiceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        QFilter departmentFilter = new QFilter("adminorg", "=", (Object)orgId).and("iscurrentversion", "=", (Object)"1");
        departmentFilter.and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        DynamicObject dynamicObject = departmentServiceHelper.queryOne("id,adminorg,structlongnumber", departmentFilter.toArray());
        if (dynamicObject != null) {
            QFilter allFilter = new QFilter("structlongnumber", "like", (Object)("%" + dynamicObject.getString("structlongnumber") + "%")).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)"1");
            DynamicObjectCollection dynamicObjects = departmentServiceHelper.queryOriginalCollection("id,adminorg", allFilter.toArray());
            dynamicObjects.forEach(dy -> orgIds.add(dy.getLong("adminorg")));
        }
        return orgIds;
    }

    public static void anchorCtlByType(int orgTypeId, IFormView iFormView) {
        AnchorControl anchorCtl = (AnchorControl)iFormView.getControl("anchorcontrolap");
        ArrayList<AnchorItems> anchorItems = new ArrayList<AnchorItems>();
        String org = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7", (String)"AdminOrgBatchChgHelper_5", (String)"odc-homs-business", (Object[])new Object[0]);
        AnchorItems orgItem = new AnchorItems("flexpanelap", org, null);
        anchorItems.add(orgItem);
        String changeCaption = ResManager.loadKDString((String)"\u53d8\u52a8\u4fe1\u606f", (String)"orgBatch_anchor_1", (String)"odc-homs-business", (Object[])new Object[0]);
        AnchorItems changeItem = new AnchorItems("change_flex", changeCaption, null);
        anchorItems.add(changeItem);
        String baseCaption = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"orgBatch_anchor_12", (String)"odc-homs-business", (Object[])new Object[0]);
        AnchorItems baseItem = new AnchorItems("info_flex", baseCaption, null);
        anchorItems.add(baseItem);
        String companyCaption = ResManager.loadKDString((String)"\u516c\u53f8\u4fe1\u606f", (String)"orgBatch_anchor_2", (String)"odc-homs-business", (Object[])new Object[0]);
        AnchorItems companyItem = new AnchorItems("company_flex", companyCaption, null);
        switch (orgTypeId) {
            case 1010: {
                String groupCaption = ResManager.loadKDString((String)"\u96c6\u56e2\u4fe1\u606f", (String)"orgBatch_anchor_3", (String)"odc-homs-business", (Object[])new Object[0]);
                AnchorItems groupItem = new AnchorItems("group_flex", groupCaption, null);
                anchorItems.add(companyItem);
                anchorItems.add(groupItem);
                iFormView.setVisible(Boolean.FALSE, new String[]{"dept_flex"});
                break;
            }
            case 1020: {
                anchorItems.add(companyItem);
                iFormView.setVisible(Boolean.FALSE, new String[]{"dept_flex", "group_flex"});
                break;
            }
            case 1030: {
                iFormView.setVisible(Boolean.FALSE, new String[]{"dept_flex", "group_flex", "company_flex"});
                break;
            }
            case 1040: {
                String deptCaption = ResManager.loadKDString((String)"\u90e8\u95e8\u4fe1\u606f", (String)"orgBatch_anchor_4", (String)"odc-homs-business", (Object[])new Object[0]);
                AnchorItems deptItem = new AnchorItems("dept_flex", deptCaption, null);
                anchorItems.add(deptItem);
                iFormView.setVisible(Boolean.FALSE, new String[]{"group_flex", "company_flex"});
                break;
            }
        }
        String orgStatusCaption = ResManager.loadKDString((String)"\u7ec4\u7ec7\u72b6\u6001", (String)"orgBatch_anchor_8", (String)"odc-homs-business", (Object[])new Object[0]);
        AnchorItems orgStatusItem = new AnchorItems("status_flex", orgStatusCaption, null);
        String orgDutyCaption = ResManager.loadKDString((String)"\u7ec4\u7ec7\u804c\u8d23", (String)"orgBatch_anchor_5", (String)"odc-homs-business", (Object[])new Object[0]);
        AnchorItems orgDutyItem = new AnchorItems("duty_flex", orgDutyCaption, null);
        String collaCaption = ResManager.loadKDString((String)"\u534f\u4f5c\u5173\u7cfb", (String)"orgBatch_anchor_6", (String)"odc-homs-business", (Object[])new Object[0]);
        AnchorItems collaItem = new AnchorItems("coop_flex", collaCaption, null);
        String safeCaption = ResManager.loadKDString((String)"\u4fdd\u5bc6\u4fe1\u606f", (String)"orgBatch_anchor_7", (String)"odc-homs-business", (Object[])new Object[0]);
        AnchorItems safeItem = new AnchorItems("safe_flex", safeCaption, null);
        anchorItems.add(orgStatusItem);
        anchorItems.add(orgDutyItem);
        if (HRStringUtils.equals((String)iFormView.getPageCache().get("visibleStruct"), (String)"true")) {
            String structCaption = ResManager.loadKDString((String)"\u77e9\u9635\u7ec4\u7ec7\u4fe1\u606f", (String)"orgBatch_anchor_9", (String)"odc-homs-business", (Object[])new Object[0]);
            AnchorItems structItem = new AnchorItems("structproject_flex", structCaption, null);
            anchorItems.add(structItem);
        }
        anchorItems.add(collaItem);
        anchorItems.add(safeItem);
        anchorCtl.addItems(anchorItems);
        anchorCtl.setHighlight(true);
    }

    public static void setChangeReasonF7Filter(BeforeF7SelectEvent beforeF7SelectEvent, IDataModel model, String prefix, Boolean isEntry) {
        DynamicObject changeSceneDyn = null;
        if (isEntry.booleanValue()) {
            int row = beforeF7SelectEvent.getRow();
            String changeSceneFieldName = prefix + "_changescene";
            String entryName = BillEntryHelperEnum.getEntryNameByPrefix(prefix);
            DynamicObjectCollection entryEityColl = model.getDataEntity().getDynamicObjectCollection(entryName);
            changeSceneDyn = ((DynamicObject)entryEityColl.get(row)).getDynamicObject(changeSceneFieldName);
        } else {
            String changeSceneFieldName = "changeScene";
            changeSceneDyn = (DynamicObject)model.getValue(changeSceneFieldName);
        }
        if (Objects.nonNull(changeSceneDyn)) {
            Set changeReasonSet = changeSceneDyn.getDynamicObjectCollection("changereason").stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
            QFilter changeReasonFilter = new QFilter("id", "in", changeReasonSet);
            beforeF7SelectEvent.getCustomQFilters().add(changeReasonFilter);
        }
    }

    public static void setCityF7Filter(BeforeF7SelectEvent beforeF7SelectEvent, IDataModel model, String countryAreaFieldName) {
        beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6240\u5728\u57ce\u5e02", (String)"AdminorgFastChgPlugin_10", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        DynamicObject compantarea = model.getDataEntity().getDynamicObject(countryAreaFieldName);
        if (compantarea != null && compantarea.getLong("id") != 0L) {
            QFilter countryFilter = new QFilter("country", "=", (Object)compantarea.getLong("id"));
            beforeF7SelectEvent.getCustomQFilters().add(countryFilter);
        }
    }

    public static void propChgForCountryArea(PropertyChangedArgs e, IDataModel model, DynamicObject workplace, String prefix) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (Objects.nonNull(e.getChangeSet()[0].getOldValue())) {
            if (HRStringUtils.isNotEmpty((String)prefix)) {
                String cityEntryfieldName = "";
                cityEntryfieldName = !"entryentity".equals(prefix) ? prefix + "_" + "city" : "city";
                model.setValue(cityEntryfieldName, null, rowIndex);
            } else {
                model.setValue("city", null);
            }
        }
        DynamicObject compantarea = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (Objects.isNull(workplace) && Objects.nonNull(compantarea)) {
            AdminOrgBatchChgHelper.setWorkplace(model, compantarea.getLong("id"), null, prefix, rowIndex);
        }
    }

    public static void propChgForCity(PropertyChangedArgs e, IDataModel model, DynamicObject workplace, String prefix) {
        DynamicObject city = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (Objects.isNull(city)) {
            return;
        }
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (HRStringUtils.isNotEmpty((String)prefix)) {
            if ("entryentity".equals(prefix)) {
                model.setValue("companyarea", (Object)city.getLong("country.id"), rowIndex);
            } else {
                model.setValue(prefix + "_" + "companyarea", (Object)city.getLong("country.id"), rowIndex);
            }
        } else {
            model.setValue("companyarea", (Object)city.getLong("country.id"));
        }
        if (Objects.isNull(workplace)) {
            DynamicObject countryObj = city.getDynamicObject("country");
            List<Long> curCityAndChildCityIds = AdminOrgBatchChgHelper.queryCityIdList(city.getLong("id"));
            AdminOrgBatchChgHelper.setWorkplace(model, countryObj.getLong("id"), curCityAndChildCityIds, prefix, rowIndex);
        }
    }

    private static void setWorkplace(IDataModel model, long countryId, List<Long> cityIds, String prefix, int rowIndex) {
        HRBaseServiceHelper helper;
        DynamicObjectCollection cityColl;
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter countryFilter = new QFilter("country", "=", (Object)countryId);
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(statusFilter);
        list.add(enableFilter);
        list.add(countryFilter);
        if (!CollectionUtils.isEmpty(cityIds)) {
            list.add(new QFilter("city", "in", cityIds));
        }
        if (!CollectionUtils.isEmpty((Collection)(cityColl = (helper = new HRBaseServiceHelper("hbss_workplace")).queryOriginalCollection("id", list.toArray(new QFilter[list.size()])))) && cityColl.size() == 1) {
            if (HRStringUtils.isEmpty((String)prefix)) {
                model.setValue("workplace", ((DynamicObject)cityColl.get(0)).get("id"));
            } else if ("entryentity".equals(prefix)) {
                model.setValue("workplace", ((DynamicObject)cityColl.get(0)).get("id"), rowIndex);
            } else {
                model.setValue(prefix + "_workplace", ((DynamicObject)cityColl.get(0)).get("id"), rowIndex);
            }
        }
    }

    private static List<Long> queryCityIdList(Long id) {
        HRBaseServiceHelper adminDivisionHelper = new HRBaseServiceHelper("bd_admindivision");
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject longnumberObj = adminDivisionHelper.queryOriginalOne("longnumber", idFilter);
        QFilter qFilter = new QFilter("longnumber", "ftlike", (Object)longnumberObj.getString("longnumber")).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection collection = adminDivisionHelper.queryOriginalCollection("id", new QFilter[]{qFilter});
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            return collection.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return Lists.newArrayList((Object[])new Long[]{id});
    }

    public static void setParentFilter(IFormView view, DynamicObject orgObject, BeforeF7SelectEvent event) {
        AuthorizedOrgResult permResult;
        DynamicObject dataEntityParent = view.getModel().getDataEntity(true);
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        event.addCustomQFilter(initStatusFilter);
        QFilter isCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"0");
        DynamicObjectCollection addCollection = dataEntityParent.getDynamicObjectCollection("entryentity_add");
        Set adminOrgSet = addCollection.stream().map(s -> s.getString("add_adminorg")).collect(Collectors.toSet());
        Set<Long> addOrgIdSet = adminOrgSet.stream().map(Long::valueOf).collect(Collectors.toSet());
        DynamicObjectCollection disableObj = dataEntityParent.getDynamicObjectCollection("entryentity_disable");
        Set<Long> disableOrgIdSet = disableObj.stream().map(obj -> obj.getLong("disable_adminorg.id")).collect(Collectors.toSet());
        AdminOrgBatchChgHelper.setAddAndDisableOrgSet(dataEntityParent, addOrgIdSet, disableOrgIdSet);
        QFilter currentOrderFilter = new QFilter("id", "in", addOrgIdSet);
        if (!CollectionUtils.isEmpty(disableOrgIdSet)) {
            QFilter disableOrgFilter = new QFilter("id", "not in", disableOrgIdSet);
            event.getCustomQFilters().add(disableOrgFilter);
        }
        if ((permResult = AdminOrgBatchChgHelper.getOrgAuth(view)) != null && !permResult.isHasAllOrgPerm()) {
            log.info("[\u975e\u5168\u529f\u80fd\u7528\u6237\u8fc7\u6ee4\u6761\u4ef6]");
            QFilter authFilter = new QFilter("boid", "in", (Object)permResult.getHasPermOrgs());
            event.getCustomQFilters().add(authFilter.or(currentOrderFilter));
        }
        if (orgObject != null) {
            event.getCustomQFilters().add(new QFilter("id", "!=", (Object)orgObject.getLong("id")));
        }
        Date effDate = DateUtils.truncate((Date)new Date(), (int)5);
        event.getCustomQFilters().add(new QFilter("bsed", "<=", (Object)effDate));
        event.getCustomQFilters().add(new QFilter("bsled", ">=", (Object)effDate));
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        event.getCustomQFilters().add(dataStatusFilter.or(currentOrderFilter));
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        event.getCustomQFilters().add(statusFilter.or(currentOrderFilter));
        event.getCustomQFilters().add(isCurrentVersion.or(currentOrderFilter));
        HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg();
        if (!hrPermOrg.hasAllOrgPerm()) {
            QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", (List)hrPermOrg.getHasPermOrgs());
            event.getCustomQFilters().add(baseDataFilter);
        }
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setShowApproved(false);
    }

    public static void setMergeAndSplitOrgFilter(IFormView view, BeforeF7SelectEvent event, QFilter currentOrderFilter) {
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        event.addCustomQFilter(initStatusFilter);
        AuthorizedOrgResult permResult = AdminOrgBatchChgHelper.getOrgAuthByPermItemId("47156aff000000ac");
        if (permResult != null && !permResult.isHasAllOrgPerm()) {
            log.info("[\u975e\u5168\u529f\u80fd\u7528\u6237\u8fc7\u6ee4\u6761\u4ef6]");
            QFilter authFilter = new QFilter("boid", "in", (Object)permResult.getHasPermOrgs());
            event.getCustomQFilters().add(authFilter.or(currentOrderFilter));
        }
        Date effDate = DateUtils.truncate((Date)new Date(), (int)5);
        event.getCustomQFilters().add(new QFilter("bsed", "<=", (Object)effDate));
        event.getCustomQFilters().add(new QFilter("bsled", ">=", (Object)effDate));
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        event.getCustomQFilters().add(dataStatusFilter.or(currentOrderFilter));
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        event.getCustomQFilters().add(statusFilter.or(currentOrderFilter));
        HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg();
        if (!hrPermOrg.hasAllOrgPerm()) {
            QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", (List)hrPermOrg.getHasPermOrgs());
            event.getCustomQFilters().add(baseDataFilter);
        }
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setShowApproved(false);
    }

    private static void setAddAndDisableOrgSet(DynamicObject dataEntityParent, Set<Long> addOrgIdSet, Set<Long> disableOrgIdSet) {
        List toDeleteOrgIdList;
        DynamicObject[] unSaveAndDeleteData = AdminOrgBatchChartBaseHelper.getUnSaveAndDeleteData(dataEntityParent.getLong("id"), "adminorg,changetype,mergesplitstatus");
        Map unSaveAndDeleteDataMap = Arrays.stream(unSaveAndDeleteData).collect(Collectors.groupingBy(data -> data.getString("mergesplitstatus"), Collectors.toList()));
        List toSaveOrgIdList = unSaveAndDeleteDataMap.get("0");
        if (!CollectionUtils.isEmpty(toSaveOrgIdList)) {
            for (DynamicObject data2 : toSaveOrgIdList) {
                long changeTypeId = data2.getLong("changetype.id");
                long orgId2 = data2.getLong("adminorg.id");
                if (changeTypeId == ChangeTypeEnum.ADD.getId()) {
                    addOrgIdSet.add(orgId2);
                    continue;
                }
                if (changeTypeId == ChangeTypeEnum.DISABLE.getId()) {
                    disableOrgIdSet.add(orgId2);
                    continue;
                }
                disableOrgIdSet.remove(orgId2);
            }
        }
        if (!CollectionUtils.isEmpty(toDeleteOrgIdList = unSaveAndDeleteDataMap.get("1"))) {
            toDeleteOrgIdList.stream().map(data -> data.getLong("adminorg.id")).forEach(orgId -> {
                addOrgIdSet.remove(orgId);
                disableOrgIdSet.remove(orgId);
            });
        }
    }

    public static void setOrgTypeFilter(BeforeF7SelectEvent beforeF7SelectEvent, DynamicObject adminOrgType) {
        if (adminOrgType == null) {
            return;
        }
        ArrayList<Long> orgTypeStdIdList = new ArrayList<Long>();
        Long orgTypeStdId = adminOrgType.getLong("adminorgtypestd.id");
        if (orgTypeStdId.equals(OrgBatchChgBillConstants.ADMINORGORGTYPE_GROUP)) {
            orgTypeStdIdList.add(OrgBatchChgBillConstants.ADMINORGORGTYPE_GROUP);
            orgTypeStdIdList.add(OrgBatchChgBillConstants.ADMINORGORGTYPE_AREA);
        } else if (orgTypeStdId.equals(OrgBatchChgBillConstants.ADMINORGORGTYPE_COMPANY)) {
            orgTypeStdIdList.add(OrgBatchChgBillConstants.ADMINORGORGTYPE_GROUP);
            orgTypeStdIdList.add(OrgBatchChgBillConstants.ADMINORGORGTYPE_COMPANY);
            orgTypeStdIdList.add(OrgBatchChgBillConstants.ADMINORGORGTYPE_AREA);
        }
        if (orgTypeStdIdList.size() > 0) {
            QFilter qFilter = new QFilter("adminorgtype.adminorgtypestd", "in", orgTypeStdIdList);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter);
        }
    }

    public static void propChgForParentOrg(IFormView view, DynamicObject newValue, String prefix, int rowIndex) {
        IDataModel model = view.getModel();
        if (newValue == null) {
            String tag = HRStringUtils.isNotEmpty((String)prefix) ? prefix + "_" : prefix;
            model.setValue(tag + "parentorg_name", null);
            return;
        }
        if (AdminOrgBatchChgHelper.validateParentOrg(view, newValue)) {
            if (HRStringUtils.isNotEmpty((String)prefix) && "parent".equals(prefix)) {
                model.setValue("parent_parentorg", null, rowIndex);
            } else {
                model.setValue("parentorg", null, rowIndex);
            }
            return;
        }
        AdminOrgBatchChgHelper.setCorporateOrg(model, newValue, prefix, rowIndex);
        Long adminOrgId = newValue.getLong("id");
        Date modifyTime = OrgChgUtil.getView(view).getModel().getDataEntity().getDate("modifytime");
        String orgLongName = OrgBatchBillHelper.getOrgLongName((Long)adminOrgId, (Date)modifyTime, null);
        if (HRStringUtils.isNotEmpty((String)prefix)) {
            if ("entryentity".equals(prefix)) {
                model.setValue("parentorg_name", (Object)orgLongName, rowIndex);
            } else {
                model.setValue("parent_parentorg_name", (Object)orgLongName, rowIndex);
            }
        } else {
            model.setValue("parentorg_name", (Object)orgLongName);
        }
    }

    private static boolean validateParentOrg(IFormView view, DynamicObject newValue) {
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        long parentOrgBoid = newValue.getLong("boid");
        long parentOrgId = newValue.getLong("id");
        QFilter qFilter = new QFilter("boid", "=", (Object)parentOrgBoid);
        qFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1'));
        DynamicObject parent = orgHelper.loadDynamicObject(qFilter);
        boolean fromBill = "homs_orgbatchchgbill".equals(view.getEntityId());
        String entityId = view.getEntityId();
        Long buOrgId = view.getModel().getValue("org") != null ? ((DynamicObject)view.getModel().getValue("org")).getLong("id") : 100000L;
        boolean isNewOrg = HRStringUtils.equals((String)entityId, (String)"homs_batchorgentityadd");
        if (parent != null && HRStringUtils.equals((String)parent.getString("enable"), (String)"0")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminorgBatchBillPlugin_20", (String)"odc-homs-formplugin", (Object[])new Object[]{newValue.getString("name")}));
            return true;
        }
        if (parent != null && parent.getBoolean("tobedisableflag") && !"homs_batchorgentityinfo".equals(view.getEntityId()) && !SystemParamHelper.getAllowTobeDisableChg(buOrgId)) {
            String controlName = isNewOrg ? "promptadd" : "promptparent";
            List tipList = HRCSRPCServiceHelper.queryPromptForString((IFormView)view, (String)"homs_adminorgdetail", (String)controlName);
            view.showTipNotification(String.format((String)tipList.get(0), newValue.getString("name")));
            return true;
        }
        if (AdminOrgBatchChgHelper.inBillStop(view, newValue, parentOrgBoid, isNewOrg)) {
            return true;
        }
        if (AdminOrgBatchChgHelper.inBillTobeDistable(view, newValue, parentOrgId, isNewOrg, buOrgId)) {
            return true;
        }
        return view.getParentView() != null && AdminOrgBatchChgHelper.inThisBillCheck(view, newValue, parentOrgBoid, fromBill, isNewOrg);
    }

    private static boolean inThisBillCheck(IFormView view, DynamicObject newValue, long parentOrgBoid, boolean fromBill, boolean isNewOrg) {
        String entityId;
        IFormView billView = fromBill ? view : (HRStringUtils.equals((String)(entityId = view.getParentView().getEntityId()), (String)"homs_batchorgentitymerge") || HRStringUtils.equals((String)entityId, (String)"homs_batchorgentitysplit") ? view.getParentView().getParentView() : view.getParentView());
        DynamicObjectCollection entryentityInfo = fromBill ? view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_info") : ("homs_orgbatchchgbill".equals(view.getParentView().getEntityId()) ? view.getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_info") : ("homs_orgbatchchgbill".equals(view.getParentView().getParentView()) ? (view.getParentView().getParentView() != null ? view.getParentView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_info") : new DynamicObjectCollection()) : new DynamicObjectCollection()));
        for (DynamicObject dyn : entryentityInfo) {
            if (dyn.getLong("info_adminorg.boid") != parentOrgBoid || !dyn.getBoolean("info_tobedisableflag")) continue;
            if (isNewOrg) {
                view.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u5728\u672c\u5355\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\u3002", (String)"AdminorgBatchBillPlugin_31", (String)"odc-homs-formplugin", (Object[])new Object[0]), newValue.getString("name")));
            } else {
                view.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u5728\u672c\u5355\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\u3002", (String)"AdminorgBatchBillPlugin_32", (String)"odc-homs-formplugin", (Object[])new Object[0]), newValue.getString("name")));
            }
            return true;
        }
        DynamicObjectCollection entryentityParent = fromBill ? view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_parent") : ("homs_orgbatchchgbill".equals(view.getParentView().getEntityId()) ? view.getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_parent") : ("homs_orgbatchchgbill".equals(view.getParentView().getParentView()) ? (view.getParentView().getParentView() != null ? view.getParentView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_parent") : new DynamicObjectCollection()) : new DynamicObjectCollection()));
        for (DynamicObject dyn : entryentityParent) {
            if (dyn.getLong("parent_adminorg.boid") != parentOrgBoid || !dyn.getBoolean("parent_tobedisableflag")) continue;
            if (isNewOrg) {
                view.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u5728\u672c\u5355\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\u3002", (String)"AdminorgBatchBillPlugin_31", (String)"odc-homs-formplugin", (Object[])new Object[0]), newValue.getString("name")));
            } else {
                view.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u5728\u672c\u5355\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\u3002", (String)"AdminorgBatchBillPlugin_32", (String)"odc-homs-formplugin", (Object[])new Object[0]), newValue.getString("name")));
            }
            return true;
        }
        return false;
    }

    private static boolean inBillTobeDistable(IFormView view, DynamicObject newValue, long parentOrgId, boolean isNewOrg, Long buOrgId) {
        List<OrgBatchCheckDto> orgBatchCheckDtos = OrgBatchBillCheckHelper.queryBillOrgList();
        for (OrgBatchCheckDto dto : orgBatchCheckDtos) {
            if (SystemParamHelper.getAllowTobeDisableChg(buOrgId) || dto.getOrgId() != parentOrgId || !dto.isTobeDisableFlag()) continue;
            if (isNewOrg) {
                view.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%2$s\uff09\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\u3002", (String)"AdminorgBatchBillPlugin_29", (String)"odc-homs-formplugin", (Object[])new Object[0]), newValue.getString("name"), dto.getBillNo()));
            } else {
                view.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%2$s\uff09\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\u3002", (String)"AdminorgBatchBillPlugin_30", (String)"odc-homs-formplugin", (Object[])new Object[0]), newValue.getString("name"), dto.getBillNo()));
            }
            return true;
        }
        return false;
    }

    private static boolean inBillStop(IFormView view, DynamicObject newValue, long parentOrgBoid, boolean isNewOrg) {
        HRBaseServiceHelper billHelper = new HRBaseServiceHelper("homs_orgfastchgdisable");
        String[] auditStausArr = new String[]{"B", "D"};
        QFilter billQf = new QFilter("auditstatus", "in", (Object)auditStausArr).and(new QFilter("entryentity.adminorg.boid", "=", (Object)parentOrgBoid)).and(new QFilter("entryentity.changetype", "=", (Object)1040L));
        DynamicObject billDy = billHelper.queryOne("id,billno", billQf.toArray());
        if (billDy != null) {
            if (isNewOrg) {
                view.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u4e2d\u505a\u4e86\u201c\u505c\u7528\u201d\u64cd\u4f5c\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminorgBatchBillPlugin_23", (String)"odc-homs-formplugin", (Object[])new Object[0]), billDy.getString("billno")));
            } else {
                view.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u4e2d\u505a\u4e86\u201c\u505c\u7528\u201d\u64cd\u4f5c\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminorgBatchBillPlugin_28", (String)"odc-homs-formplugin", (Object[])new Object[0]), billDy.getString("billno")));
            }
            return true;
        }
        return false;
    }

    private static void setCorporateOrg(IDataModel model, DynamicObject parentOrg, String prefix, int rowIndex) {
        Long adminOrgTypeStdId;
        String adminOrgTypeFieldName = "adminorgtype";
        String corporateOrgFieldName = "corporateorg";
        DynamicObject adminOrgTypeDyn = null;
        if (HRStringUtils.isNotEmpty((String)prefix)) {
            if ("entryentity".equals(prefix)) {
                adminOrgTypeDyn = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection(prefix).get(rowIndex)).getDynamicObject(adminOrgTypeFieldName);
            } else {
                adminOrgTypeFieldName = prefix + "_" + adminOrgTypeFieldName;
                corporateOrgFieldName = prefix + "_" + corporateOrgFieldName;
                String entryName = BillEntryHelperEnum.getEntryNameByPrefix(prefix);
                adminOrgTypeDyn = ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection(entryName).get(rowIndex)).getDynamicObject(adminOrgTypeFieldName);
            }
        } else {
            adminOrgTypeDyn = model.getDataEntity().getDynamicObject(adminOrgTypeFieldName);
        }
        if (adminOrgTypeDyn != null && (adminOrgTypeStdId = Long.valueOf(adminOrgTypeDyn.getLong("adminorgtypestd.id"))).equals(OrgBatchChgBillConstants.ADMINORGORGTYPE_DEPARTMENT)) {
            if (parentOrg == null || parentOrg.getLong("id") == 0L) {
                AdminOrgBatchChgHelper.setValue(model, corporateOrgFieldName, 0L, prefix, rowIndex);
            } else {
                HRBaseServiceHelper structServiceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
                String selectLongStruct = "id,structlongnumber";
                QFilter structQFilter = new QFilter("adminorg", "=", (Object)parentOrg.getLong("boid")).and("enable", "=", (Object)"1").and("iscurrentversion", "=", (Object)"1").and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
                DynamicObject longStructDy = structServiceHelper.queryOne(selectLongStruct, structQFilter);
                if (Objects.isNull(longStructDy)) {
                    return;
                }
                String longStruct = longStructDy.getString("structlongnumber");
                String[] adminstructArr = longStruct.split("!");
                String selectAdminStruct = "id,name,corporateorg,structnumber";
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
                QFilter qFilter = new QFilter("structnumber", "in", (Object)adminstructArr).and("iscurrentversion", "=", (Object)"1");
                DynamicObjectCollection dynamicObjects = serviceHelper.queryOriginalCollection(selectAdminStruct, qFilter.toArray());
                Map<String, Long> map = dynamicObjects.stream().collect(Collectors.toMap(org -> org.getString("structnumber"), org -> org.getLong("corporateorg")));
                for (int i = adminstructArr.length - 1; i >= 0; --i) {
                    Long corporateorg;
                    if (!map.containsKey(adminstructArr[i]) || (corporateorg = map.get(adminstructArr[i])) == null || corporateorg.equals(0L)) continue;
                    AdminOrgBatchChgHelper.setValue(model, corporateOrgFieldName, corporateorg, prefix, rowIndex);
                    return;
                }
            }
        }
    }

    private static void setValue(IDataModel model, String corporateOrgFieldName, Long value, String prefix, int rowIndex) {
        if (HRStringUtils.isEmpty((String)prefix)) {
            model.setValue(corporateOrgFieldName, (Object)value);
        } else {
            model.setValue(corporateOrgFieldName, (Object)value, rowIndex);
        }
    }

    public static Long getChangeScene(String prefix) {
        DynamicObject dynamicObject = AdminOrgBatchChgHelper.getChangeSceneObj(prefix);
        if (dynamicObject != null) {
            return dynamicObject.getLong("id");
        }
        return 0L;
    }

    public static DynamicObject getChangeSceneObj(String prefix) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_changescene");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        Long changeTypeId = BillEntryHelperEnum.getChangeTypeIdByPrefix(prefix);
        QFilter changeTyeFilter = new QFilter("orgchangetype.id", "=", (Object)changeTypeId);
        DynamicObject[] changeSceneDyns = serviceHelper.query(new QFilter[]{statusFilter, enableFilter, changeTyeFilter});
        if (changeSceneDyns.length == 1) {
            return changeSceneDyns[0];
        }
        return null;
    }

    public static Map<Long, DynamicObject> getEntryInfoMap(IFormView iFormView) {
        DynamicObject bill = AdminOrgBatchChgHelper.getOrgBatchBillDynamicObject(iFormView);
        DynamicObjectCollection addDys = bill.getDynamicObjectCollection("entryentity_add");
        DynamicObjectCollection parentDys = bill.getDynamicObjectCollection("entryentity_parent");
        DynamicObjectCollection infoDys = bill.getDynamicObjectCollection("entryentity_info");
        DynamicObjectCollection disableDys = bill.getDynamicObjectCollection("entryentity_disable");
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        if (!CollectionUtils.isEmpty((Collection)addDys)) {
            addDys.stream().forEach(dynamicObject -> map.put(dynamicObject.getLong("add_adminorg"), (DynamicObject)dynamicObject));
        }
        if (!CollectionUtils.isEmpty((Collection)parentDys)) {
            parentDys.stream().forEach(dynamicObject -> map.put(dynamicObject.getLong("parent_adminorg.boid"), (DynamicObject)dynamicObject));
        }
        if (!CollectionUtils.isEmpty((Collection)infoDys)) {
            infoDys.stream().forEach(dynamicObject -> map.put(dynamicObject.getLong("info_adminorg.boid"), (DynamicObject)dynamicObject));
        }
        if (!CollectionUtils.isEmpty((Collection)disableDys)) {
            disableDys.stream().forEach(dynamicObject -> map.put(dynamicObject.getLong("disable_adminorg.boid"), (DynamicObject)dynamicObject));
        }
        return map;
    }

    public static Map<Long, DynamicObject> getEntryInfoMap(IFormView iFormView, String prefix) {
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        if (prefix.equals("parent")) {
            dynamicObjects = iFormView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_parent");
        } else if (prefix.equals("info")) {
            dynamicObjects = iFormView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_info");
        }
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            dynamicObjects.stream().forEach(dynamicObject -> map.put(dynamicObject.getLong("id"), (DynamicObject)dynamicObject));
        }
        return map;
    }

    public static void delAddMaster(List<Long> orgIdList) {
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        detailHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", orgIdList)});
        HRBaseServiceHelper companyHelper = new HRBaseServiceHelper("haos_adminorgcompany");
        QFilter companyQF = new QFilter("adminorg", "in", orgIdList);
        companyHelper.deleteByFilter(companyQF.toArray());
        HRBaseServiceHelper groupHelper = new HRBaseServiceHelper("haos_adminorggroup");
        groupHelper.deleteByFilter(companyQF.toArray());
        HRBaseServiceHelper departmentHelper = new HRBaseServiceHelper("haos_adminorgdepartment");
        departmentHelper.deleteByFilter(companyQF.toArray());
        HRBaseServiceHelper structHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        structHelper.deleteByFilter(companyQF.toArray());
        HRBaseServiceHelper sortCodeHelper = new HRBaseServiceHelper("haos_orgsortcode");
        sortCodeHelper.deleteByFilter(companyQF.toArray());
        HRBaseServiceHelper coopRelHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter coopRel = new QFilter("org", "in", orgIdList);
        coopRelHelper.deleteByFilter(coopRel.toArray());
    }

    public static void setTabPageTextAndVisible(String opKeyPrefix, IFormView view) {
        String entryName = AdminOrgBatchChgHelper.spliceTwoStringByUnderLine("entryentity", opKeyPrefix);
        DynamicObjectCollection org = view.getModel().getDataEntity(true).getDynamicObjectCollection(entryName);
        String opKeyTabPageName = "tabpageap_" + opKeyPrefix;
        TabPage tabPageInfo = (TabPage)view.getControl(opKeyTabPageName);
        if (org.size() == 0) {
            view.setVisible(Boolean.FALSE, new String[]{opKeyTabPageName});
        } else {
            tabPageInfo.setText(new LocaleString(String.format(Locale.ROOT, BillEntryHelperEnum.getOperateLocaleNameByPrefix(opKeyPrefix), org.size())));
            view.setVisible(Boolean.TRUE, new String[]{opKeyTabPageName});
            String activePage = view.getPageCache().get("activePage");
            if (HRStringUtils.isEmpty((String)activePage)) {
                ((Tab)view.getControl("tabapentry")).activeTab(opKeyTabPageName);
                view.getPageCache().put("activePage", opKeyTabPageName);
            }
        }
    }

    public static void activeTabByPrefix(String prefix, IFormView view) {
        if (HRStringUtils.isEmpty((String)prefix)) {
            view.setVisible(Boolean.TRUE, new String[]{"noentrydata_flex"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"noentrydata_flex"});
        }
        Tab tabAp = (Tab)view.getControl("tabapentry");
        if (null != tabAp) {
            tabAp.activeTab("tabpageap_" + prefix);
        }
    }

    public static void activeHasDataEntryAfterDelete(String postFix, IFormView view) {
        String currentEntryName = BillEntryHelperEnum.getEntryNameByPrefix(postFix);
        DynamicObjectCollection currentEntryEntity = view.getModel().getEntryEntity(currentEntryName);
        if (CollectionUtils.isEmpty((Collection)currentEntryEntity)) {
            String hasDataEntryPrefix = "";
            for (BillEntryHelperEnum billEnum : BillEntryHelperEnum.values()) {
                DynamicObjectCollection entryEntity = view.getModel().getEntryEntity(billEnum.getEntryName());
                if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
                hasDataEntryPrefix = billEnum.getOperateKey();
            }
            AdminOrgBatchChgHelper.activeTabByPrefix(hasDataEntryPrefix, view);
        } else {
            AdminOrgBatchChgHelper.activeTabByPrefix(postFix, view);
        }
    }

    private static String spliceTwoStringByUnderLine(String oneString, String otherString) {
        return oneString + "_" + otherString;
    }

    public static DynamicObject getFocusEntry(String prefix, IFormView view) {
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity_" + prefix);
        int row = entryGrid.getEntryState().getFocusRow();
        DynamicObject entryEntityDyn = (DynamicObject)view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_" + prefix).get(row);
        long entityId = entryEntityDyn.getLong("id");
        if (entityId != 0L) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_batchorgentity");
            serviceHelper.deleteOne((Object)entityId);
            entryEntityDyn.set("id", (Object)0L);
        }
        return entryEntityDyn;
    }

    public static Long getHisId(Long boId) {
        DynamicObject dynamicObject = AdminOrgBatchChgHelper.getHisDynamicObject(boId);
        if (dynamicObject != null) {
            return dynamicObject.getLong("id");
        }
        return boId;
    }

    public static Map<Long, Long> getHisId(Set<Long> boIds) {
        Map<Long, Long> result = new HashMap<Long, Long>();
        if (boIds == null || boIds.isEmpty()) {
            return result;
        }
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter idFilter = new QFilter("boid", "in", boIds);
        Date effDate = new Date();
        QFilter hisVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0").and(new QFilter("bsed", "<=", (Object)effDate).and(new QFilter("bsled", ">=", (Object)effDate))).and(new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus())));
        DynamicObject[] query = adminOrgHelper.query("id,boid", new QFilter[]{idFilter, hisVersionFilter});
        result = Arrays.stream(query).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getLong("id")));
        return result;
    }

    public static DynamicObject getHisDynamicObject(Long boId) {
        if (boId == null || boId == 0L) {
            return null;
        }
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter idFilter = new QFilter("boid", "=", (Object)boId);
        Date effDate = new Date();
        QFilter hisVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0").and(new QFilter("bsed", "<=", (Object)effDate).and(new QFilter("bsled", ">=", (Object)effDate))).and(new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus())));
        return adminOrgHelper.queryOne("id", new QFilter[]{idFilter, hisVersionFilter});
    }

    public static boolean getIsHasModifyPerm(String entityName) {
        Long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"homs", (String)entityName, (String)"4715a0df000000ac");
    }

    public static boolean dataExistFromDB(Long id, String entityName) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        return helper.isExists(idFilter);
    }

    public static int getEntrySeq(IDataModel iDataModel, Long changeType) {
        Long billId = iDataModel.getDataEntity().getLong("id");
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter qFilter = new QFilter("billid", "=", (Object)billId);
        qFilter.and("changetype", "=", (Object)changeType);
        String order = "sequence desc";
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOne("id,sequence", qFilter.toArray(), order);
        if (dynamicObject == null) {
            return 1;
        }
        return dynamicObject.getInt("sequence") + 1;
    }

    public static void saveAttachment(IFormView view) {
        String attachmentCacheKey;
        Object pkId = view.getModel().getDataEntity().getPkValue();
        IPageCache cache = (IPageCache)view.getService(IPageCache.class);
        String cacheJsonString = cache.get(attachmentCacheKey = "TampAttCache" + view.getPageId());
        if (!StringUtils.isEmpty((CharSequence)cacheJsonString)) {
            String appId = view.getFormShowParameter().getFormConfig().getAppId();
            Map attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
            AttachmentServiceHelper.saveTempAttachments((String)"homs_orgbatchchgbill", (Object)pkId, (String)appId, (Map)attachmentInfo);
            cache.put(attachmentCacheKey, "");
        }
    }

    public static void setCoopOrgTeamFilter(BeforeF7SelectEvent beforeF7SelectEvent, IFormView iFormView, String metaData, String filed) {
        AuthorizedOrgTeamResult authorizedOrgResult;
        Object org = iFormView.getModel().getValue("org");
        if (Objects.isNull(org)) {
            return;
        }
        boolean chooseAllOrg = SystemParamHelper.getOrgParameter(((DynamicObject)org).getLong("id"));
        if (chooseAllOrg) {
            String searchValueString;
            String[] split;
            beforeF7SelectEvent.getFormShowParameter().setFormId("haos_emptyorgteam");
            QFilter searchFilter = ((BasedataEdit)beforeF7SelectEvent.getSource()).getSearchFilter();
            if (searchFilter == null) {
                return;
            }
            Object searchValue = searchFilter.getValue();
            if (searchValue instanceof String && !HRStringUtils.isEmpty((String)((String)searchValue)) && (split = (searchValueString = (String)searchValue).split("#")) != null && split.length != 0) {
                String nameOrNumber = split[split.length - 1];
                QFilter qFilter = new QFilter("name", "=", (Object)nameOrNumber);
                qFilter.or(new QFilter("number", "=", (Object)nameOrNumber));
                beforeF7SelectEvent.getCustomQFilters().add(qFilter);
            }
            return;
        }
        if ("homs_orgfastchgbill".equals(metaData)) {
            beforeF7SelectEvent.getFormShowParameter().setFormId("haos_orgfast_orgteamf7");
        }
        if (!(authorizedOrgResult = (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedOrgTeamsF7", (Object[])new Object[]{RequestContext.get().getCurrUserId(), PermCommonUtil.getAppIdFromSuspectedAppNum((String)"homs"), metaData, "47150e89000000ac", filed})).isHasAllOrgPerm()) {
            Map hasPermOrgTeamMap = authorizedOrgResult.getHasPermOrgTeamMap();
            ArrayList allBoids = Lists.newArrayListWithCapacity((int)10);
            hasPermOrgTeamMap.forEach((key, val) -> allBoids.addAll(val));
            QFilter allFilter = new QFilter("boid", "in", (Object)allBoids);
            allFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
            allFilter.and(new QFilter("enable", "=", (Object)"1"));
            allFilter.and(new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1"));
            beforeF7SelectEvent.getCustomQFilters().add(allFilter);
        }
        beforeF7SelectEvent.getFormShowParameter().setCustomParam("chooseAllOrg", (Object)chooseAllOrg);
        List<Long> otClassifyIdList = Arrays.asList(OrgBatchChgBillConstants.OTCLASSIFY_1010, OrgBatchChgBillConstants.OTCLASSIFY_1020, OrgBatchChgBillConstants.OTCLASSIFY_1030);
        QFilter otClassfyIdFilter = new QFilter("otclassify.id", "in", otClassifyIdList);
        beforeF7SelectEvent.addCustomQFilter(otClassfyIdFilter);
        QFilter baseFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        baseFilter.and(new QFilter("enable", "=", (Object)"1"));
        beforeF7SelectEvent.getCustomQFilters().add(baseFilter);
        HasPermOrgResult hasHrOrgResult = OrgPermHelper.getHRPermOrg((long)RequestContext.get().getCurrUserId(), (String)"homs", (String)metaData, (String)"47150e89000000ac");
        if (!hasHrOrgResult.hasAllOrgPerm()) {
            List permOrgs = hasHrOrgResult.getHasPermOrgs();
            QFilter baseDataFilter = new QFilter("org", "in", (Object)permOrgs);
            beforeF7SelectEvent.getCustomQFilters().add(baseDataFilter);
            log.info("permOrgs:{}", (Object)permOrgs.toString());
        }
    }

    public static Boolean codeRuleExistFlag(String entityId, long orgId, DynamicObject dynamicObject) {
        boolean cudeRule = CodeRuleServiceHelper.isExist((String)entityId, (DynamicObject)dynamicObject, (String)String.valueOf(orgId));
        return cudeRule;
    }

    public static void addOperateLog(String formId, String operationKey) {
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)formId);
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        appLogInfo.setBizAppID(appId);
        appLogInfo.setBizObjID(formId);
        appLogInfo.setOpName(operationKey, new MultiLangEnumBridge("\u5e9f\u5f03", "AdminOrgBatchChgHelper_6", "odc-homs-business"));
        appLogInfo.setOpDesc(new MultiLangEnumBridge("\u5e9f\u5f03\u5931\u8d25", "AdminOrgBatchChgHelper_7", "odc-homs-business"), new String[0]);
        service.addLog((AppLogInfo)appLogInfo);
    }

    public static void setAdminorgBoIdToEntryEntity(IFormView formView) {
        IDataModel model = formView.getModel();
        DynamicObjectCollection addCollection = model.getDataEntity().getDynamicObjectCollection("entryentity_add");
        DynamicObjectCollection parentCollection = model.getDataEntity().getDynamicObjectCollection("entryentity_parent");
        DynamicObjectCollection infoCollection = model.getDataEntity().getDynamicObjectCollection("entryentity_info");
        DynamicObjectCollection disableCollection = model.getDataEntity().getDynamicObjectCollection("entryentity_disable");
        DynamicObjectCollection mergeCollection = model.getDataEntity().getDynamicObjectCollection("entryentity_merge");
        DynamicObjectCollection splitCollection = model.getDataEntity().getDynamicObjectCollection("entryentity_split");
        ArrayList orgBoIds = new ArrayList(addCollection.size() + parentCollection.size() + infoCollection.size() + disableCollection.size());
        addCollection.stream().forEach(dynamicObject -> orgBoIds.add(dynamicObject.getLong("add_parentorg.boid")));
        parentCollection.stream().forEach(dynamicObject -> orgBoIds.add(dynamicObject.getLong("parent_adminorg.boid")));
        infoCollection.stream().forEach(dynamicObject -> orgBoIds.add(dynamicObject.getLong("info_adminorg.boid")));
        disableCollection.stream().forEach(dynamicObject -> orgBoIds.add(dynamicObject.getLong("disable_adminorg.boid")));
        mergeCollection.stream().forEach(dynamicObject -> {
            DynamicObjectCollection beforeMerges = dynamicObject.getDynamicObjectCollection("to_merge_org");
            DynamicObject afterMerge = dynamicObject.getDynamicObject("merge_target_org");
            beforeMerges.stream().forEach(beforeMerge -> orgBoIds.add(beforeMerge.getLong("fbasedataid.id")));
            if (afterMerge != null) {
                orgBoIds.add(afterMerge.getLong("id"));
            }
        });
        splitCollection.stream().forEach(dynamicObject -> {
            DynamicObjectCollection afterSplits = dynamicObject.getDynamicObjectCollection("split_target_org");
            DynamicObject beforeSplit = dynamicObject.getDynamicObject("to_split_org");
            afterSplits.stream().forEach(afterSplit -> orgBoIds.add(afterSplit.getLong("fbasedataid.id")));
            if (beforeSplit != null) {
                orgBoIds.add(beforeSplit.getLong("id"));
            }
        });
        DynamicObjectCollection allDyCollection = model.getEntryEntity("entryentity_all");
        HashSet allOrgIdSet = new HashSet(allDyCollection.size());
        allDyCollection.stream().forEach(dy -> {
            DynamicObject adminBoIdDy = dy.getDynamicObject("adminorgboid");
            if (adminBoIdDy != null) {
                allOrgIdSet.add(adminBoIdDy.getLong("boid"));
            }
        });
        if (!CollectionUtils.isEmpty(orgBoIds)) {
            AbstractFormDataModel createAllModel = (AbstractFormDataModel)formView.getModel();
            createAllModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("adminorgboid", new Object[0]);
            for (Long orgBoId : orgBoIds) {
                if (allOrgIdSet.contains(orgBoId)) continue;
                vs.addRow(new Object[]{orgBoId});
            }
            createAllModel.batchCreateNewEntryRow("entryentity_all", vs);
            createAllModel.endInit();
            formView.updateView("entryentity_all");
        }
    }

    public static Map<Long, DynamicObject> getEntityByOrgIds(List<Long> orgIds, Long billId, Long buId) {
        DynamicObject[] orgMasterInfoArr = AdminOrgBatchChgHelper.getOrgDyCollectionByIds(orgIds);
        List<Long> boIdList = Arrays.asList(orgMasterInfoArr).stream().map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        Map<Long, DynamicObject> orgBoId2CompanyDynMap = AdminOrgBatchChgHelper.getOrgId2CompanyDynMap(boIdList);
        Map<Long, DynamicObject> orgBoId2GroupDynMap = AdminOrgBatchChgHelper.getOrgId2GroupDynMap(boIdList);
        Map<Long, DynamicObject> orgBoId2DepartmentDynMapDynMap = AdminOrgBatchChgHelper.getOrgId2DepartmentDynMap(boIdList);
        HashMap<Long, DynamicObject> orgChgEntityMap = new HashMap<Long, DynamicObject>(orgIds.size());
        for (DynamicObject orgMasterInfo : orgMasterInfoArr) {
            Long orgBoId = orgMasterInfo.getLong("boid");
            DynamicObject orgDeptInfo = orgBoId2DepartmentDynMapDynMap.get(orgBoId);
            DynamicObject orgCompanyInfo = orgBoId2CompanyDynMap.get(orgBoId);
            DynamicObject orgGroupInfo = orgBoId2GroupDynMap.get(orgBoId);
            DynamicObject orgEntityDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"homs_batchorgentity"));
            orgEntityDy.set("adminorg", orgMasterInfo.get("sourcevid"));
            orgEntityDy.set("adminorgboid", (Object)orgBoId);
            orgEntityDy.set("adminorgtype", (Object)orgMasterInfo.getLong("adminorgtype.id"));
            orgEntityDy.set("parentorg", (Object)AdminOrgBatchChgHelper.getHisId(orgMasterInfo.getLong("parentorg.id")));
            orgEntityDy.set("orgoriname", orgMasterInfo.get("name"));
            orgEntityDy.set("number", orgMasterInfo.get("number"));
            orgEntityDy.set("simplename", (Object)orgMasterInfo.getLocaleString("simplename"));
            orgEntityDy.set("parentorg", (Object)orgMasterInfo.getLong("parentorg.id"));
            orgEntityDy.set("establishmentdate", orgMasterInfo.get("establishmentdate"));
            orgEntityDy.set("corporateorg", orgMasterInfo.get("corporateorg"));
            orgEntityDy.set("tobedisableflag", orgMasterInfo.get("tobedisableflag"));
            orgEntityDy.set("adminorglayer", orgMasterInfo.get("adminorglayer"));
            orgEntityDy.set("adminorgfunction", orgMasterInfo.get("adminorgfunction"));
            orgEntityDy.set("companyarea", orgMasterInfo.get("companyarea"));
            orgEntityDy.set("city", orgMasterInfo.get("city"));
            orgEntityDy.set("workplace", orgMasterInfo.get("workplace"));
            orgEntityDy.set("detailaddress", orgMasterInfo.get("detailaddress"));
            orgEntityDy.set("index", (Object)orgMasterInfo.getInt("index"));
            orgEntityDy.set("description", orgMasterInfo.get("description"));
            orgEntityDy.set("positioning", orgMasterInfo.get("positioning"));
            orgEntityDy.set("mainduty", orgMasterInfo.get("mainduty"));
            orgEntityDy.set("safelevel", orgMasterInfo.get("safelevel"));
            orgEntityDy.set("safetype", orgMasterInfo.get("safetype"));
            orgEntityDy.set("safedescription", orgMasterInfo.get("safedescription"));
            if (orgCompanyInfo != null) {
                orgEntityDy.set("companytype", orgCompanyInfo.get("companytype"));
                orgEntityDy.set("industrytype", orgCompanyInfo.get("industrytype"));
            } else {
                orgEntityDy.set("companytype", null);
                orgEntityDy.set("industrytype", null);
            }
            if (orgGroupInfo != null) {
                orgEntityDy.set("groupvision", orgGroupInfo.get("groupvision"));
                orgEntityDy.set("groupmission", orgGroupInfo.get("groupmission"));
            } else {
                orgEntityDy.set("groupvision", null);
                orgEntityDy.set("groupmission", null);
            }
            if (orgDeptInfo != null) {
                orgEntityDy.set("departmenttype", orgDeptInfo.get("departmenttype"));
            } else {
                orgEntityDy.set("departmenttype", null);
            }
            orgEntityDy.set("org", (Object)buId);
            orgEntityDy.set("billid", (Object)billId);
            orgChgEntityMap.put(orgMasterInfo.getLong("id"), orgEntityDy);
        }
        return orgChgEntityMap;
    }

    public static DynamicObject getAdminorgHrDy(DynamicObject addDy) {
        DynamicObject adminorgHrDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_adminorghr"));
        HRDynamicObjectUtils.copy((DynamicObject)addDy, (DynamicObject)adminorgHrDy);
        adminorgHrDy.set("id", (Object)addDy.getLong("id"));
        adminorgHrDy.set("parent", addDy.get("parentorg"));
        adminorgHrDy.set("orgtype", addDy.get("adminorgtype"));
        if (addDy.containsProperty("belongcompany")) {
            adminorgHrDy.set("company", addDy.get("belongcompany"));
        }
        return adminorgHrDy;
    }

    public static void setStructProjectEntry(IFormView iFormView, boolean orgChg, boolean isBatchChg) {
        if (OperationStatus.VIEW.equals((Object)iFormView.getFormShowParameter().getStatus())) {
            return;
        }
        if (isBatchChg) {
            long billEntryId = iFormView.getModel().getDataEntity().getLong("id");
            HRBaseServiceHelper billEntryHelper = new HRBaseServiceHelper("homs_batchorgentity");
            boolean exists = billEntryHelper.isExists((Object)billEntryId);
            if (!orgChg && exists) {
                return;
            }
        }
        AdminOrgBatchChgHelper.setStructView(iFormView);
    }

    public static void setStructView(IFormView iFormView) {
        DynamicObject changeTypeDy = iFormView.getModel().getDataEntity().getDynamicObject("changetype");
        if (changeTypeDy == null) {
            return;
        }
        Long userId = RequestContext.get().getCurrUserId();
        AuthorizedStructResult permResult = (AuthorizedStructResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserStructProjectsF7", (Object[])new Object[]{userId, "homs", iFormView.getEntityId(), "47150e89000000ac", "struct_parent_org", null});
        DynamicObject[] structArr = permResult.isHasAllStruct() ? StructProjectRepository.getInstance().queryAllStructArrBySyncorg() : StructProjectRepository.getInstance().queryAllStructArrBySyncorg(permResult.getAuthorizedStructs(), "id,parentorg.id,parentorg.structnumber,parentorg.sourcevid");
        if (structArr.length > 0) {
            HashMap orgStructMap = Maps.newHashMap();
            HashSet orgStructNumberSet = Sets.newHashSet();
            Long changeTypeId = changeTypeDy.getLong("id");
            if (changeTypeId != 1010L) {
                DynamicObject[] orgStructDyArr;
                DynamicObject adminorgDy = iFormView.getModel().getDataEntity().getDynamicObject("adminorg");
                for (DynamicObject orgStructDy : orgStructDyArr = AdminOrgStructRepository.getInstance().queryEffStructInfoByOrgId("id,parentorg,structproject,structlongnumber", Long.valueOf(adminorgDy.getLong("boid")))) {
                    orgStructMap.put(orgStructDy.getLong("structproject.id"), orgStructDy);
                    String structLongNumber = orgStructDy.getString("structlongnumber");
                    if (!HRStringUtils.isNotEmpty((String)structLongNumber)) continue;
                    String[] structNumberArr = structLongNumber.split("!");
                    Arrays.asList(structNumberArr).stream().forEach(structNumber -> orgStructNumberSet.add(structNumber));
                }
            }
            String selectField = "id, name, number, boid, enable, structnumber,isvirtualorg";
            DynamicObject[] adminOrgInfoArr = AdOrgRepository.getInstance().queryOriginalByStructNumber(selectField, (Set)orgStructNumberSet);
            Map<String, DynamicObject> adminOrgDynMap = Arrays.stream(adminOrgInfoArr).collect(Collectors.toMap(adminOrgInfo -> adminOrgInfo.getString("structnumber"), adminOrgInfo -> adminOrgInfo));
            AbstractFormDataModel model = (AbstractFormDataModel)iFormView.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            long[] entryIds = ORM.create().genLongIds("homs_orgchgstructentry", structArr.length);
            vs.addField("id", new Object[0]);
            vs.addField("struct_project", new Object[0]);
            vs.addField("struct_parent_org", new Object[0]);
            vs.addField("struct_long_name", new Object[0]);
            boolean isView = OperationStatus.VIEW.equals((Object)iFormView.getFormShowParameter().getStatus());
            for (int i = 0; i < structArr.length; ++i) {
                DynamicObject structDy = structArr[i];
                Long parentId = AdminOrgBatchChgHelper.getParentIdByStruct(structDy.getLong("id"), orgStructMap);
                if (isView && (parentId == null || parentId == 0L || changeTypeId == 1010L) || structDy.getLong("id") == 1010L || structDy.getLong("id") == 1020L || structDy.getLong("id") == 1030L) continue;
                vs.addRow(new Object[]{entryIds[i], structDy.getLong("id"), changeTypeId == 1010L ? null : AdminOrgBatchChgHelper.getParentIdByStruct(structDy.getLong("id"), orgStructMap), changeTypeId == 1010L ? "" : AdminOrgBatchChgHelper.getStructLongNameByStruct(structDy.getLong("id"), orgStructMap, adminOrgDynMap)});
            }
            model.batchCreateNewEntryRow("struct_project_entry", vs);
            model.endInit();
            iFormView.updateView("struct_project_entry");
            iFormView.getPageCache().put("visibleStruct", "true");
        } else {
            iFormView.setVisible(Boolean.valueOf(false), new String[]{"structproject_flex"});
            iFormView.getPageCache().put("visibleStruct", "false");
        }
    }

    private static Long getParentIdByStruct(Long structId, Map<Long, DynamicObject> orgStructMap) {
        if (orgStructMap.containsKey(structId)) {
            DynamicObject structInfoDy = orgStructMap.get(structId);
            return HRDyObjectPropUtil.getId((DynamicObject)structInfoDy.getDynamicObject("parentorg"));
        }
        return null;
    }

    private static String getStructLongNameByStruct(Long structId, Map<Long, DynamicObject> orgStructMap, Map<String, DynamicObject> adminOrgDynMap) {
        if (orgStructMap.containsKey(structId)) {
            DynamicObject structInfoDy = orgStructMap.get(structId);
            String structLongNumber = structInfoDy.getString("structlongnumber");
            if (HRStringUtils.isEmpty((String)structLongNumber)) {
                return "";
            }
            String[] structnumberArr = structLongNumber.split("!");
            StringBuilder structLongNameBuilder = new StringBuilder();
            for (int i = 0; i < structnumberArr.length - 1; ++i) {
                String structnumber = structnumberArr[i];
                DynamicObject adminorgDy = adminOrgDynMap.get(structnumber);
                if (adminorgDy == null) continue;
                structLongNameBuilder.append("_").append(adminorgDy.getString("name"));
            }
            if (HRStringUtils.isNotEmpty((String)structLongNameBuilder.toString())) {
                return structLongNameBuilder.substring(1);
            }
        }
        return "";
    }

    public static void showStructParentOrgF7(BeforeF7SelectEvent event, IFormView iFormView) {
        DynamicObject orgObject = (DynamicObject)iFormView.getModel().getValue("adminorg");
        int rowIndex = event.getRow();
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        List qFilters = formShowParameter.getListFilterParameter().getQFilters();
        if (!CollectionUtils.isEmpty((Collection)qFilters) && qFilters.size() > 0) {
            qFilters.remove(0);
        }
        DynamicObjectCollection entryDynColl = iFormView.getModel().getDataEntity(true).getDynamicObjectCollection("struct_project_entry");
        DynamicObject focusEntryDyn = (DynamicObject)entryDynColl.get(rowIndex);
        long structId = focusEntryDyn.getLong("struct_project.id");
        DynamicObject dataEntityParent = AdminOrgBatchChgHelper.getOrgBatchBillDynamicObject(iFormView);
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        event.addCustomQFilter(initStatusFilter);
        QFilter isCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"0");
        DynamicObjectCollection disableObj = dataEntityParent.getDynamicObjectCollection("entryentity_disable");
        Set disableOrgIdSet = disableObj.stream().map(obj -> obj.getLong("disable_adminorg.id")).collect(Collectors.toSet());
        QFilter currentOrderFilter = AdminOrgBatchChgHelper.getCurrStructQf(dataEntityParent, structId);
        if (!CollectionUtils.isEmpty(disableOrgIdSet)) {
            QFilter disableOrgFilter = new QFilter("id", "not in", disableOrgIdSet);
            event.getCustomQFilters().add(disableOrgFilter);
        }
        DynamicObject[] structOrgArr = AdminOrgStructRepository.getInstance().queryStructInfoByStruct("id,adminorg", Long.valueOf(structId), null);
        Set orgIds = Arrays.asList(structOrgArr).stream().map(dynamicObject -> dynamicObject.getLong("adminorg.id")).collect(Collectors.toSet());
        event.getCustomQFilters().add(new QFilter("boid", "in", orgIds).or(currentOrderFilter));
        AuthorizedOrgResult permResult = AdminOrgBatchChgHelper.getOrgAuth(iFormView, structId);
        event.getFormShowParameter().setHasRight(false);
        if (permResult != null && !permResult.isHasAllOrgPerm()) {
            log.info("[\u975e\u5168\u529f\u80fd\u7528\u6237\u8fc7\u6ee4\u6761\u4ef6]");
            QFilter authFilter = new QFilter("boid", "in", (Object)permResult.getHasPermOrgs());
            event.getCustomQFilters().add(authFilter.or(currentOrderFilter));
        }
        if (orgObject != null) {
            event.getCustomQFilters().add(new QFilter("id", "!=", (Object)orgObject.getLong("id")));
        }
        Date effDate = DateUtils.truncate((Date)new Date(), (int)5);
        event.getCustomQFilters().add(new QFilter("bsed", "<=", (Object)effDate));
        event.getCustomQFilters().add(new QFilter("bsled", ">=", (Object)effDate));
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        event.getCustomQFilters().add(dataStatusFilter.or(currentOrderFilter));
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        event.getCustomQFilters().add(statusFilter.or(currentOrderFilter));
        event.getCustomQFilters().add(isCurrentVersion.or(currentOrderFilter));
        HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg();
        if (!hrPermOrg.hasAllOrgPerm()) {
            QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", (List)hrPermOrg.getHasPermOrgs());
            event.getCustomQFilters().add(baseDataFilter);
        }
        formShowParameter.setShowApproved(false);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7", (String)"VirtualOrgDetailPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
    }

    private static DynamicObject getOrgBatchBillDynamicObject(IFormView view) {
        String billPageId = (String)view.getFormShowParameter().getCustomParam("billPageId");
        IFormView billView = null;
        if (StringUtils.isNotBlank((CharSequence)billPageId)) {
            SessionManager sm = SessionManager.getCurrent();
            sm.setRequestThread(true);
            billView = sm.getView(billPageId);
        } else {
            billView = view.getParentView();
        }
        return billView.getModel().getDataEntity(true);
    }

    private static QFilter getCurrStructQf(DynamicObject dataEntityParent, Long structId) {
        DynamicObject[] entryArr;
        DynamicObjectCollection addCollection = dataEntityParent.getDynamicObjectCollection("entryentity_add");
        DynamicObjectCollection parentCollection = dataEntityParent.getDynamicObjectCollection("entryentity_parent");
        DynamicObjectCollection infoCollection = dataEntityParent.getDynamicObjectCollection("entryentity_info");
        HashSet entryIds = Sets.newHashSet();
        HashSet entryStructIds = Sets.newHashSet();
        HashMap entryOrgMap = Maps.newHashMap();
        HashSet currOrgIdSet = Sets.newHashSet();
        addCollection.forEach(addEntry -> {
            if (addEntry.getLong("id") != 0L) {
                entryIds.add(addEntry.getLong("id"));
                entryOrgMap.put(addEntry.getLong("id"), Long.valueOf(addEntry.getString("add_adminorg")));
            }
        });
        parentCollection.forEach(parentEntry -> {
            if (parentEntry.getLong("id") != 0L) {
                entryIds.add(parentEntry.getLong("id"));
                entryOrgMap.put(parentEntry.getLong("id"), HRDyObjectPropUtil.getId((DynamicObject)parentEntry.getDynamicObject("parent_adminorg")));
            }
        });
        infoCollection.forEach(infoEntry -> {
            if (infoEntry.getLong("id") != 0L) {
                entryIds.add(infoEntry.getLong("id"));
                entryOrgMap.put(infoEntry.getLong("id"), HRDyObjectPropUtil.getId((DynamicObject)infoEntry.getDynamicObject("info_adminorg")));
            }
        });
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_orgchgstructentry");
        QFilter entryQf = new QFilter("entryid", "in", (Object)entryIds);
        for (DynamicObject structEntry : entryArr = hrBaseServiceHelper.query("id,entryid,struct_project,struct_parent_org", entryQf.toArray())) {
            long entryid = structEntry.getLong("entryid");
            if (!entryOrgMap.containsKey(entryid) || !structId.equals(HRDyObjectPropUtil.getId((DynamicObject)structEntry.getDynamicObject("struct_project"))) || structEntry.getDynamicObject("struct_parent_org") == null) continue;
            entryStructIds.add(entryid);
        }
        for (Long next : entryStructIds) {
            if (!entryOrgMap.containsKey(next)) continue;
            currOrgIdSet.add(entryOrgMap.get(next));
        }
        return new QFilter("id", "in", (Object)currOrgIdSet);
    }

    public static void structProjectChg(IFormView iFormView, PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (newValue != null) {
            Map<Long, DynamicObject> entryInfoMap = AdminOrgBatchChgHelper.getEntryInfoMap(iFormView);
            Long parentBoId = (Long)newValue.get("boid");
            DynamicObjectCollection entryDynColl = iFormView.getModel().getDataEntity(true).getDynamicObjectCollection("struct_project_entry");
            DynamicObject focusEntryDyn = (DynamicObject)entryDynColl.get(rowIndex);
            long structId = focusEntryDyn.getLong("struct_project.id");
            if (entryInfoMap.containsKey(parentBoId)) {
                DynamicObject dynamicObject = entryInfoMap.get(parentBoId);
                long entryid = dynamicObject.getLong("id");
                HRBaseServiceHelper structEntryHelper = new HRBaseServiceHelper("homs_orgchgstructentry");
                QFilter qFilter = new QFilter("entryid", "=", (Object)entryid);
                qFilter.and("struct_project", "=", (Object)structId);
                DynamicObject structEntryDy = structEntryHelper.queryOriginalOne("id,struct_long_name", qFilter);
                if (structEntryDy != null) {
                    String parentName = structEntryDy.getString("struct_long_name");
                    if (StringUtils.isNotEmpty((CharSequence)parentName)) {
                        String name = newValue.getString("name");
                        parentName = parentName + "_" + name;
                        iFormView.getModel().setValue("struct_long_name", (Object)parentName, rowIndex);
                    } else {
                        iFormView.getModel().setValue("struct_long_name", (Object)"", rowIndex);
                    }
                }
            } else {
                String orgLongName = OrgBatchBillHelper.getOrgLongName((Long)newValue.getLong("boid"), (Date)new Date(), (String)String.valueOf(structId));
                iFormView.getModel().setValue("struct_long_name", (Object)orgLongName, rowIndex);
            }
        } else {
            iFormView.getModel().setValue("struct_long_name", (Object)"", rowIndex);
        }
    }

    public static void delNoneStructParent(IFormView iFormView) {
        DynamicObjectCollection dynamicObjectCollection;
        OperationStatus status = iFormView.getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status) && !CollectionUtils.isEmpty((Collection)(dynamicObjectCollection = iFormView.getModel().getDataEntity(true).getDynamicObjectCollection("struct_project_entry")))) {
            ArrayList ids = Lists.newArrayList();
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                if (((DynamicObject)dynamicObjectCollection.get(i)).getDynamicObject("struct_parent_org") != null) continue;
                ids.add(i);
            }
            if (!CollectionUtils.isEmpty((Collection)ids)) {
                int[] idArr = new int[ids.size()];
                for (int i = 0; i < ids.size(); ++i) {
                    idArr[i] = (Integer)ids.get(i);
                }
                iFormView.getModel().deleteEntryRows("struct_project_entry", idArr);
            }
        }
    }

    public static void saveStructToEntry(DynamicObject[] dataEntities) {
        List orgIds = Arrays.asList(dataEntities).stream().map(dynamicObject -> dynamicObject.getLong("adminorg.boid")).collect(Collectors.toList());
        Long userId = RequestContext.get().getCurrUserId();
        AuthorizedStructResult permResult = (AuthorizedStructResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserStructProjectsF7", (Object[])new Object[]{userId, "homs", dataEntities[0].getDataEntityType().getName(), "47150e89000000ac", "struct_parent_org", null});
        DynamicObject[] structArr = permResult.isHasAllStruct() ? StructProjectRepository.getInstance().queryAllStructArrBySyncorg() : StructProjectRepository.getInstance().queryAllStructArrBySyncorg(permResult.getAuthorizedStructs(), "id,parentorg.id,parentorg.structnumber,parentorg.sourcevid");
        if (structArr.length > 0) {
            DynamicObject[] orgStructDyArr;
            HashMap orgStructMap = Maps.newHashMap();
            HashSet orgStructNumberSet = Sets.newHashSet();
            for (DynamicObject orgStructDy : orgStructDyArr = AdminOrgStructRepository.getInstance().queryEffStructInfoByOrgIds("id,adminorg,parentorg,structproject,structlongnumber", orgIds)) {
                Map<Long, DynamicObject> structMap;
                Long orgId = orgStructDy.getLong("adminorg.id");
                if (orgStructMap.containsKey(orgId)) {
                    structMap = (Map)orgStructMap.get(orgId);
                    structMap.put(orgStructDy.getLong("structproject.id"), orgStructDy);
                } else {
                    structMap = Maps.newHashMap();
                    structMap.put(orgStructDy.getLong("structproject.id"), orgStructDy);
                    orgStructMap.put(orgId, structMap);
                }
                String structLongNumber = orgStructDy.getString("structlongnumber");
                if (!HRStringUtils.isNotEmpty((String)structLongNumber)) continue;
                String[] structNumberArr = structLongNumber.split("!");
                Arrays.asList(structNumberArr).stream().forEach(structNumber -> orgStructNumberSet.add(structNumber));
            }
            String selectField = "id, name, number, boid, enable, structnumber,isvirtualorg";
            DynamicObject[] adminOrgInfoArr = AdOrgRepository.getInstance().queryOriginalByStructNumber(selectField, (Set)orgStructNumberSet);
            Map<String, DynamicObject> adminOrgDynMap = Arrays.stream(adminOrgInfoArr).collect(Collectors.toMap(adminOrgInfo -> adminOrgInfo.getString("structnumber"), adminOrgInfo -> adminOrgInfo));
            for (DynamicObject entryDy : dataEntities) {
                long orgBoId = entryDy.getLong("adminorg.boid");
                DynamicObjectCollection structEntryCollection = entryDy.getDynamicObjectCollection("struct_project_entry");
                int seq = 1;
                if (!structEntryCollection.isEmpty()) {
                    for (DynamicObject dy : structEntryCollection) {
                        if (seq > dy.getInt("seq")) continue;
                        ++seq;
                    }
                }
                for (DynamicObject structDy : structArr) {
                    DynamicObject structEntryDy = structEntryCollection.addNew();
                    Long structId = structDy.getLong("id");
                    structEntryDy.set("struct_project", (Object)structId);
                    structEntryDy.set("seq", (Object)seq++);
                    if (!orgStructMap.containsKey(orgBoId) || !((Map)orgStructMap.get(orgBoId)).containsKey(structId) || HRDyObjectPropUtil.getIdLongObject((DynamicObject)((DynamicObject)((Map)orgStructMap.get(orgBoId)).get(structId)).getDynamicObject("parentorg")) == null) continue;
                    Long parentId = HRDyObjectPropUtil.getIdLongObject((DynamicObject)((DynamicObject)((Map)orgStructMap.get(orgBoId)).get(structId)).getDynamicObject("parentorg"));
                    structEntryDy.set("struct_parent_org", (Object)parentId);
                    structEntryDy.set("struct_long_name", (Object)AdminOrgBatchChgHelper.getStructLongNameByStruct(structId, (Map)orgStructMap.get(orgBoId), adminOrgDynMap));
                }
            }
        }
    }

    public static Map<Long, DynamicObject> findBelongCompanyMap(DynamicObject[] entryOrgs) {
        List addDys = Arrays.stream(entryOrgs).filter(dynamicObject -> dynamicObject.getLong("changetype.id") == OrgBatchChgBillConstants.CHANGE_TYPE_ADD.longValue() && StringUtils.isEmpty((CharSequence)dynamicObject.getString("number"))).map(org -> {
            FindBelongCompanyModel findBelongCompanyModel = new FindBelongCompanyModel();
            findBelongCompanyModel.setId(org.getLong("adminorg.id"));
            findBelongCompanyModel.setParentId(org.getLong("parentorg.boid"));
            findBelongCompanyModel.setTypeStdId(org.getLong("adminorgtype.adminorgtypestd.id"));
            return findBelongCompanyModel;
        }).collect(Collectors.toList());
        List changeDys = Arrays.stream(entryOrgs).filter(dynamicObject -> {
            long changeTypeId = dynamicObject.getLong("changetype.id");
            return changeTypeId == OrgBatchChgBillConstants.CHANGE_TYPE_PARENT || changeTypeId == OrgBatchChgBillConstants.CHANGE_TYPE_INFO;
        }).map(org -> {
            FindBelongCompanyModel findBelongCompanyModel = new FindBelongCompanyModel();
            findBelongCompanyModel.setId(org.getLong("adminorg.boid"));
            findBelongCompanyModel.setParentId(org.getLong("parentorg.boid"));
            findBelongCompanyModel.setTypeStdId(org.getLong("adminorgtype.adminorgtypestd.id"));
            return findBelongCompanyModel;
        }).collect(Collectors.toList());
        DynamicObject entryOrg = entryOrgs[0];
        DynamicObjectType belongCompanyComplexType = (DynamicObjectType)((BasedataProp)entryOrg.getDataEntityType().getProperties().get((Object)"belongcompany")).getComplexType();
        Map belongCompanyMap = AdminOrgFindBelongCompanyHelper.findBelongCompanyMap(addDys, changeDys);
        DynamicObject[] belongCompanys = BusinessDataServiceHelper.load((Object[])belongCompanyMap.values().toArray(), (DynamicObjectType)belongCompanyComplexType);
        Map idVsCompany = (Map)Arrays.stream(belongCompanys).collect(DyCollectors.toIdVsDy());
        return belongCompanyMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (DynamicObject)idVsCompany.get(entry.getValue())));
    }

    static {
        mergeAndSplitFields = new HashSet<String>(){
            {
                this.add("merge_target_org");
                this.add("to_split_org");
                this.add("to_merge_org");
                this.add("split_target_org");
            }
        };
        mergeAndSplitFieldsExcludeMap = new HashMap<String, String>(){
            {
                this.put("merge_target_org", "entryentity_split");
                this.put("to_merge_org", "entryentity_split");
                this.put("to_split_org", "entryentity_merge");
                this.put("split_target_org", "entryentity_merge");
            }
        };
        entryEntityName = new String[]{"entryentity_merge", "entryentity_split"};
        changeTypeToLocaleMap = Maps.newHashMapWithExpectedSize((int)4);
        changeTypeToLocaleMap.put("add", ResManager.loadResFormat((String)"\u65b0\u589e\u7ec4\u7ec7", (String)"AdminOrgBatchChgHelper_1", (String)"odc-homs-business", (Object[])new Object[0]));
        changeTypeToLocaleMap.put("parent", ResManager.loadResFormat((String)"\u8c03\u6574\u4e0a\u7ea7", (String)"AdminOrgBatchChgHelper_2", (String)"odc-homs-business", (Object[])new Object[0]));
        changeTypeToLocaleMap.put("infochg", ResManager.loadResFormat((String)"\u53d8\u66f4\u4fe1\u606f", (String)"AdminOrgBatchChgHelper_3", (String)"odc-homs-business", (Object[])new Object[0]));
        changeTypeToLocaleMap.put("disable", ResManager.loadResFormat((String)"\u505c\u7528\u7ec4\u7ec7", (String)"AdminOrgBatchChgHelper_4", (String)"odc-homs-business", (Object[])new Object[0]));
    }
}

