/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.TipsSupport;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.rpc.HRCSRPCServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.AppIdServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.domain.repository.OrgOperateStepsRepository;
import kd.hr.homs.business.domain.repository.OrgOperateTaskRepository;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.repository.HOMSAdminOrgRepository;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.constants.fastchg.OrgFastChgBillConstants;
import kd.hr.homs.common.constants.fastchg.OrgOperateTaskConstants;
import org.apache.commons.lang3.time.DateUtils;

public class AdminOrgFastChgHelper {
    public static void openTypeViewForm(IFormView iFormView, String adminorgbillnumber, String pluginName, DynamicObject orgDy) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("homs_selectorgtypetpl");
        TreeView orgTree = (TreeView)iFormView.getControl("treeview");
        Map focusNode = orgTree.getTreeState().getFocusNode();
        HRBaseServiceHelper orgTypeHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject haosAdminOrgDetail = orgTypeHelper.queryOne((Object)Long.valueOf(focusNode.get("id").toString()));
        DynamicObject parentOrg = haosAdminOrgDetail.getDynamicObject("adminorgtype");
        showParameter.setCustomParam("parentOrgType", (Object)String.valueOf(parentOrg.getLong("adminorgtypestd.id")));
        showParameter.setCustomParam("adminorgbillnumber", (Object)adminorgbillnumber);
        showParameter.setCustomParam("enable", (Object)haosAdminOrgDetail.getString("enable"));
        showParameter.setCustomParam("auth", (Object)AdminOrgFastChgHelper.isOrgAuth(AdminOrgFastChgHelper.getOrgAuth(iFormView), Long.valueOf(focusNode.get("id").toString())));
        AuthorizedOrgResult orgAuth = AdminOrgFastChgHelper.getOrgAuth(iFormView);
        HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg();
        if (orgAuth.isHasAllOrgPerm() && hrPermOrg.hasAllOrgPerm()) {
            showParameter.setCustomParam("master_org", (Object)String.valueOf(orgDy.getLong("org.id")));
        } else {
            HashSet authIdSet = new HashSet(orgAuth.getHasPermOrgs());
            HashSet hrPermOrgSet = new HashSet(hrPermOrg.getHasPermOrgs());
            if (authIdSet.contains(haosAdminOrgDetail.get("boid")) && hrPermOrgSet.contains(orgDy.getLong("org.id"))) {
                showParameter.setCustomParam("master_org", (Object)String.valueOf(haosAdminOrgDetail.getLong("org.id")));
            } else {
                showParameter.setCustomParam("master_org", (Object)iFormView.getPageCache().get("master_org"));
            }
        }
        showParameter.setCustomParam("orgFilter", (Object)Boolean.TRUE);
        showParameter.setCloseCallBack(new CloseCallBack(pluginName, "selectOrgType"));
        iFormView.showForm(showParameter);
    }

    public static AuthorizedOrgResult getOrgAuth(IFormView iFormView) {
        Long userId = RequestContext.get().getCurrUserId();
        String permItemId = "47150e89000000ac";
        String appId = AdminOrgFastChgHelper.getAppIdWithDealThirdApp(iFormView.getFormShowParameter(), "haos_adminorgdetail");
        AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{userId, appId, "homs_adminorgdetail", permItemId, "boid"});
        return permResult;
    }

    public static AuthorizedOrgResultWithSub getAuthorizedAdminOrgWithSubInfo() {
        Long userId = RequestContext.get().getCurrUserId();
        String permItemId = "47150e89000000ac";
        String appId = "homs";
        AuthorizedOrgResultWithSub dataPermResult = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgsF7WithSubInfo", (Object[])new Object[]{userId, appId, "homs_orgbatchchgbill", permItemId, "adminorgboid"});
        return dataPermResult;
    }

    private static String getAppIdWithDealThirdApp(FormShowParameter showParameter, String entityNumber) {
        String entryAppId = AdminOrgFastChgHelper.getAppIdFromShowParam(showParameter);
        return AppIdServiceHelper.getPermAppId((String)entryAppId, (String)entityNumber);
    }

    public static String getAppIdFromShowParam(FormShowParameter showParameter) {
        String appNumber = showParameter.getAppId();
        if (HRStringUtils.isEmpty((String)appNumber)) {
            return null;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        if (appInfo != null) {
            return appInfo.getId();
        }
        return null;
    }

    public static void openChgParentBillPage(IFormView iFormView, Long orgId, String orgName) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("homs_orgfastchgparent");
        String mainPageId = "";
        if (iFormView.getMainView() != null) {
            mainPageId = iFormView.getMainView().getPageId();
        }
        showParameter.setPageId("homs_orgfastchgparent_" + orgId + "_" + mainPageId);
        showParameter.setCustomParam("orgid", (Object)orgId);
        if (iFormView.getParentView() != null && iFormView.getParentView() instanceof ListView) {
            showParameter.setParentPageId(iFormView.getParentView().getPageId());
        }
        String caption = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7-%s", (String)"AdminorgDetailListPlugin_24", (String)"odc-homs-formplugin", (Object[])new Object[0]), orgName);
        showParameter.setCaption(caption);
        iFormView.showForm((FormShowParameter)showParameter);
    }

    public static void showDisableInfoPage(AbstractFormPlugin that, List<Long> orgIds) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("homs_orgfastchgdisable");
        formShowParameter.setCustomParam("selectRowIds", orgIds);
        formShowParameter.setCloseCallBack(new CloseCallBack(that.getPluginName(), "stopuse_callback"));
        that.getView().showForm((FormShowParameter)formShowParameter);
    }

    public static void showEnableInfoPage(AbstractFormPlugin that, List<Long> orgIds) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("homs_orgfastchgenable");
        formShowParameter.setCustomParam("selectRowIds", orgIds);
        formShowParameter.setCloseCallBack(new CloseCallBack(that.getPluginName(), "enable_callback"));
        that.getView().showForm((FormShowParameter)formShowParameter);
    }

    public static void showRevisePage(AbstractFormPlugin that, Long orgId, String orgName) {
        FormShowParameter formShowParameter = new FormShowParameter();
        String caption = String.format(ResManager.loadKDString((String)"\u5386\u53f2\u8bb0\u5f55-%s", (String)"FastAdminOrgInfoChange_2", (String)"odc-homs-business", (Object[])new Object[0]), orgName);
        formShowParameter.setCaption(caption);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("homs_adminorgrevise");
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOne("id,boid", (Object)orgId);
        String mainPageId = "";
        if (that.getView().getMainView() != null) {
            mainPageId = that.getView().getMainView().getPageId();
        }
        formShowParameter.setPageId("homs_adminorgrevise_" + dynamicObject.getLong("boid") + "_" + mainPageId);
        formShowParameter.setCustomParam("orgBoId", (Object)String.valueOf(dynamicObject.getLong("boid")));
        that.getView().showForm(formShowParameter);
    }

    public static void showDeptLeaderSet(AbstractFormPlugin formPlugin, Long orgId) {
        DynamicObject adminOrgInfo = AdOrgRepository.getInstance().queryOriginalOneByPk("id, boid, name, number, enable, establishmentdate, org", (Object)orgId);
        if ("0".equals(adminOrgInfo.getString("enable"))) {
            formPlugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53ea\u80fd\u5bf9\u5df2\u542f\u7528\u7684\u884c\u653f\u7ec4\u7ec7\u8fdb\u884c\u90e8\u95e8\u8d1f\u8d23\u4eba\u8bbe\u7f6e\u3002", (String)"AdminorgDetailListPlugin_35", (String)"odc-homs-formplugin", (Object[])new Object[0]), adminOrgInfo.getString("number")));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%1$s-\u90e8\u95e8\u8d1f\u8d23\u4eba\u8bbe\u7f6e", (String)"AdminorgDetailListPlugin_36", (String)"odc-homs-formplugin", (Object[])new Object[0]), adminOrgInfo.getString("name")));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("homs_chargepersonset");
        String mainPageId = "";
        if (formPlugin.getView().getMainView() != null) {
            mainPageId = formPlugin.getView().getMainView().getPageId();
        }
        formShowParameter.setPageId("homs_chargepersonset_" + adminOrgInfo.getLong("id") + "_" + mainPageId);
        formShowParameter.setCustomParam("adminorg", (Object)adminOrgInfo.getString("boid"));
        formShowParameter.setCustomParam("org", (Object)adminOrgInfo.getString("org"));
        formShowParameter.setCustomParam("establishmentdate", (Object)adminOrgInfo.getDate("establishmentdate"));
        formPlugin.getView().showForm(formShowParameter);
    }

    public static boolean checkInfoChgBefore(IFormView that, Long orgId, boolean checkSourceVid) {
        DynamicObject orgDyById;
        boolean hasSpecificPerm = PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"homs", (String)"homs_orgfastchginfo", (String)"47150e89000000ac");
        if (!hasSpecificPerm) {
            that.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u53d8\u66f4\u4fe1\u606f\u7684\u6743\u9650\u3002", (String)"AdminorgDetailListPlugin_15", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (checkSourceVid) {
            DynamicObject orgDy = AdminOrgFastChgHelper.getNowOrgDyById(orgId);
            if (orgId.longValue() != orgDy.getLong("sourcevid")) {
                that.showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u88ab\u66f4\u6539\uff0c\u60a8\u9700\u8981\u91cd\u65b0\u5237\u65b0\uff0c\u57fa\u4e8e\u8be5\u7ec4\u7ec7\u7684\u6700\u65b0\u4fe1\u606f\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdminorgDetailListPlugin_25", (String)"odc-homs-formplugin", (Object[])new Object[]{orgDy.getString("name")}));
                return false;
            }
        }
        DynamicObject org = AdminOrgFastChgHelper.getOrgDyById(orgId);
        String orgResultString = that.getPageCache().get("perm_org_result_withsub");
        if (HRStringUtils.isEmpty((String)orgResultString)) {
            AuthorizedOrgResult orgAuth = AdminOrgFastChgHelper.getOrgAuth(that);
            if (!orgAuth.isHasAllOrgPerm() && Objects.nonNull(orgAuth.getHasPermOrgs()) && !orgAuth.getHasPermOrgs().contains(org.getLong("boid"))) {
                that.showTipNotification(ResManager.loadKDString((String)"\u672a\u5206\u914d\u6570\u636e\u8303\u56f4\u3002", (String)"OrgDiffTreeList_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            AuthorizedOrgResultWithSub authorizedOrgResultWithSub = (AuthorizedOrgResultWithSub)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgResultWithSub.class);
            if (!authorizedOrgResultWithSub.isHasAllOrgPerm()) {
                String curStructLongNumber = org.getString("structlongnumber");
                List permOrgWithSubList = authorizedOrgResultWithSub.getHasPermOrgsWithSub();
                boolean isNotHadPerm = false;
                for (OrgSubInfo orgSubInfo : permOrgWithSubList) {
                    String longStructNumber = orgSubInfo.getLongStructNumber();
                    if (longStructNumber.equals(curStructLongNumber) || orgSubInfo.isContainsSub() && curStructLongNumber.contains(longStructNumber)) {
                        isNotHadPerm = false;
                        break;
                    }
                    isNotHadPerm = true;
                }
                if (isNotHadPerm) {
                    that.showTipNotification(ResManager.loadKDString((String)"\u672a\u5206\u914d\u6570\u636e\u8303\u56f4\u3002", (String)"OrgDiffTreeList_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        if (HRStringUtils.equals((String)(orgDyById = AdminOrgFastChgHelper.getOrgDyById(org.getLong("boid"))).getString("enable"), (String)"0")) {
            that.showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u201c\u4fe1\u606f\u9879\u53d8\u66f4\u201d\u7684\u64cd\u4f5c\u3002", (String)"AdminorgDetailListPlugin_11", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        List<OrgBatchCheckDto> orgBatchCheckDtos = OrgBatchBillCheckHelper.queryBillOrgList();
        boolean result = true;
        for (OrgBatchCheckDto dto : orgBatchCheckDtos) {
            if (!orgId.equals(dto.getOrgId()) || HRStringUtils.isEmpty((String)dto.getBillNo())) continue;
            that.showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d,\u8bf7\u5148\u7b49\u5355\u636e\u751f\u6548\u540e\u518d\u64cd\u4f5c\u3002", (String)"AdminorgDetailListPlugin_12", (String)"odc-homs-formplugin", (Object[])new Object[0]), org.getString("name"), dto.getBillNo(), BillEntryHelperEnum.getEntryDescriptionByChangeType(dto.getChangeTypeId())));
            result = false;
        }
        if (!AdminOrgFastChgHelper.checkOrgOperateTask(Collections.singletonList(orgId), that, true)) {
            return false;
        }
        return result;
    }

    public static void showChangeInfoPage(AbstractFormPlugin that, DynamicObject[] dynamicObjects) {
        String orgName = dynamicObjects[0].getString("name");
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("homs_orgfastchginfo");
        String mainPageId = "";
        if (that.getView().getMainView() != null) {
            mainPageId = that.getView().getMainView().getPageId();
        }
        formShowParameter.setPageId("homs_orgfastchginfo_" + dynamicObjects[0].getLong("sourcevid") + "_" + mainPageId);
        formShowParameter.setCustomParam("selectRowId", (Object)dynamicObjects[0].getLong("sourcevid"));
        String caption = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7-%s", (String)"FastAdminOrgInfoChange_1", (String)"odc-homs-business", (Object[])new Object[0]), orgName);
        formShowParameter.setCaption(caption);
        formShowParameter.setCloseCallBack(new CloseCallBack(that.getPluginName(), "infochg_callback"));
        that.getView().showForm((FormShowParameter)formShowParameter);
    }

    public static boolean checkOrgBillStatus(Long orgBoId, IFormView iFormView) {
        HRBaseServiceHelper billHelper = new HRBaseServiceHelper("homs_orgfastchgdisable");
        String[] auditStausArr = new String[]{"B", "D"};
        QFilter billQf = new QFilter("billstatus", "in", (Object)auditStausArr);
        billQf.and(new QFilter("entryentity.adminorg.boid", "=", (Object)orgBoId));
        DynamicObject billDy = billHelper.queryOne("id,billno,entryentity.adminorg,entryentity.changetype", billQf.toArray());
        if (billDy != null) {
            DynamicObjectCollection entryentity = billDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject orgChgDy : entryentity) {
                if (orgChgDy.getLong("adminorg.boid") != orgBoId.longValue()) continue;
                if (orgChgDy.getLong("changetype.id") == OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.longValue()) {
                    iFormView.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5728\u9014\u5355\u636e(\u7f16\u53f7\uff1a%s\uff09\u5df2\u505c\u7528\u8be5\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8fdb\u884c\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u7684\u64cd\u4f5c\u3002", (String)"AdminorgFastChgPlugin_24", (String)"odc-homs-formplugin", (Object[])new Object[0]), billDy.getString("billno")));
                    return false;
                }
                if (orgChgDy.getLong("changetype.id") != OrgBatchChgBillConstants.CHANGE_TYPE_INFO.longValue() && orgChgDy.getLong("changetype.id") != OrgBatchChgBillConstants.CHANGE_TYPE_PARENT.longValue() && orgChgDy.getLong("changetype.id") != OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT.longValue() && orgChgDy.getLong("changetype.id") != OrgBatchChgBillConstants.CHANGE_TYPE_MERGE.longValue()) continue;
                iFormView.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d \u7684\u201c%3$s\u201d\u4e2d\uff0c\u8bf7\u5148\u7b49\u5355\u636e\u751f\u6548\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdminorgFastChgPlugin_25", (String)"odc-homs-formplugin", (Object[])new Object[0]), orgChgDy.getString("adminorg.name"), billDy.getString("billno"), orgChgDy.getString("changetype.name")));
                return false;
            }
        }
        return true;
    }

    public static void openChgInfoBillPage(IFormView iFormView, Long orgId, String orgName) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("homs_orgfastchginfo");
        String mainPageId = "";
        if (iFormView.getMainView() != null) {
            mainPageId = iFormView.getMainView().getPageId();
        }
        showParameter.setPageId("homs_orgfastchginfo_" + orgId + "_" + mainPageId);
        showParameter.setCustomParam("selectRowId", (Object)orgId);
        String caption = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7-%s", (String)"FastAdminOrgInfoChange_1", (String)"odc-homs-business", (Object[])new Object[0]), orgName);
        if (iFormView.getParentView() != null && iFormView.getParentView() instanceof ListView) {
            showParameter.setParentPageId(iFormView.getParentView().getPageId());
        }
        showParameter.setCaption(caption);
        iFormView.showForm((FormShowParameter)showParameter);
    }

    public static DynamicObjectCollection getOrgDyCollectionByIds(List<Long> orgIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("id", "in", orgIds);
        DynamicObjectCollection collection = serviceHelper.queryOriginalCollection("id,boid,org,adminorgtype.id,parentorg.id,name,simplename,number,tobedisableflag,tobedisabledate,establishmentdate,corporateorg,adminorglayer,adminorgfunction,companyarea,city,detailaddress,index,enable,description,positioning,mainduty,safelevel,safetype,safedescription,workplace", qFilter.toArray());
        return collection;
    }

    public static DynamicObject getOrgDyById(Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("id", "=", (Object)orgId);
        DynamicObject dynamicObject = serviceHelper.loadDynamicObject(qFilter.toArray());
        return dynamicObject;
    }

    public static DynamicObject[] getOverLapAdminArray(Date startTime, Date endTime) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("bsed", "<=", (Object)endTime);
        qFilter.and(new QFilter("bsled", ">=", (Object)startTime));
        qFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] dynamicObject = serviceHelper.query("id,boid,parentorg,adminorgtype,name,number,bsed,bsled", qFilter.toArray());
        return dynamicObject;
    }

    public static DynamicObject[] getOverNameLapAdminArray(Date startTime, Date endTime, Long parentBoId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("bsed", "<=", (Object)endTime);
        qFilter.and(new QFilter("bsled", ">=", (Object)startTime));
        qFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("parentorg", "=", (Object)parentBoId));
        DynamicObject[] dynamicObject = serviceHelper.query("id,boid,name,bsed,bsled", qFilter.toArray());
        return dynamicObject;
    }

    public static DynamicObject[] getOverNumberLapAdminArray(Date startTime, Date endTime, String number) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("bsed", "<=", (Object)endTime);
        qFilter.and(new QFilter("bsled", ">=", (Object)startTime));
        qFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        qFilter.and(new QFilter("number", "=", (Object)number));
        DynamicObject[] dynamicObject = serviceHelper.queryOriginalArray("id,boid,number,bsed,bsled", qFilter.toArray());
        return dynamicObject;
    }

    public static DynamicObject[] getOverAdminOrgTypeLapAdminArray(Date startTime, Date endTime, Long parentBoId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("bsed", "<=", (Object)endTime);
        qFilter.and(new QFilter("bsled", ">=", (Object)startTime));
        qFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("parentorg", "=", (Object)parentBoId));
        DynamicObject[] dynamicObject = serviceHelper.queryOriginalArray("id,boid,adminorgtype.adminorgtypestd.id,bsed,bsled", qFilter.toArray());
        return dynamicObject;
    }

    public static Map<Long, DynamicObject> getCompanyMap(List<Long> orgIds, String enable) {
        HRBaseServiceHelper companyServiceHelper = new HRBaseServiceHelper("haos_adminorgcompany");
        QFilter companyFilter = new QFilter("adminorg", "in", orgIds).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)enable);
        DynamicObjectCollection companyDyCollection = companyServiceHelper.queryOriginalCollection("id,sourcevid,adminorg,companytype,industrytype", companyFilter.toArray());
        Map<Long, DynamicObject> companyMap = companyDyCollection.stream().collect(Collectors.toMap(dy -> dy.getLong("adminorg"), dy -> dy));
        return companyMap;
    }

    public static Map<Long, List<DynamicObject>> getStructMap(List<Long> orgIds, Set<Long> structProjectIdSet) {
        DynamicObject[] structs = AdminOrgStructRepository.getInstance().queryOriginalEnableOtherStruct("id, structproject.id, parentorg.id, adminorg.id", structProjectIdSet, orgIds);
        return Arrays.stream(structs).collect(Collectors.groupingBy(dy -> dy.getLong("adminorg.id")));
    }

    public static Map<Long, DynamicObject> getCompanyMap(List<Long> orgIds) {
        HRBaseServiceHelper companyServiceHelper = new HRBaseServiceHelper("haos_adminorgcompany");
        QFilter companyFilter = new QFilter("adminorg", "in", orgIds).and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] companyDyCollection = companyServiceHelper.loadDynamicObjectArray(companyFilter.toArray());
        Map<Long, DynamicObject> companyMap = Arrays.stream(companyDyCollection).collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), dy -> dy));
        return companyMap;
    }

    public static Map<Long, DynamicObject> getGroupMap(List<Long> orgIds, String enable) {
        HRBaseServiceHelper groupServiceHelper = new HRBaseServiceHelper("haos_adminorggroup");
        QFilter groupFilter = new QFilter("adminorg", "in", orgIds).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)enable);
        DynamicObjectCollection groupDyCollection = groupServiceHelper.queryOriginalCollection("id,sourcevid,adminorg,groupvision,groupmission,groupleader", groupFilter.toArray());
        Map<Long, DynamicObject> groupMap = groupDyCollection.stream().collect(Collectors.toMap(dy -> dy.getLong("adminorg"), dy -> dy));
        return groupMap;
    }

    public static Map<Long, DynamicObject> getGroupMap(List<Long> orgIds) {
        HRBaseServiceHelper groupServiceHelper = new HRBaseServiceHelper("haos_adminorggroup");
        QFilter groupFilter = new QFilter("adminorg", "in", orgIds).and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] groupDyCollection = groupServiceHelper.loadDynamicObjectArray(groupFilter.toArray());
        Map<Long, DynamicObject> groupMap = Arrays.stream(groupDyCollection).collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), dy -> dy));
        return groupMap;
    }

    public static Map<Long, DynamicObject> getDepartmentMap(List<Long> orgIds, String enable) {
        HRBaseServiceHelper departmentServiceHelper = new HRBaseServiceHelper("haos_adminorgdepartment");
        QFilter departmentFilter = new QFilter("adminorg", "in", orgIds).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)enable);
        DynamicObjectCollection departmentDyCollection = departmentServiceHelper.queryOriginalCollection("id,sourcevid,adminorg,departmenttype", departmentFilter.toArray());
        Map<Long, DynamicObject> departmentMap = departmentDyCollection.stream().collect(Collectors.toMap(dy -> dy.getLong("adminorg"), dy -> dy));
        return departmentMap;
    }

    public static Map<Long, DynamicObject> getDepartmentMap(List<Long> orgIds) {
        HRBaseServiceHelper departmentServiceHelper = new HRBaseServiceHelper("haos_adminorgdepartment");
        QFilter departmentFilter = new QFilter("adminorg", "in", orgIds).and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] departmentDyCollection = departmentServiceHelper.loadDynamicObjectArray(departmentFilter.toArray());
        Map<Long, DynamicObject> departmentMap = Arrays.stream(departmentDyCollection).collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), dy -> dy));
        return departmentMap;
    }

    public static DynamicObject getCompany(Long orgId) {
        HRBaseServiceHelper companyServiceHelper = new HRBaseServiceHelper("haos_adminorgcompany");
        QFilter companyFilter = new QFilter("adminorg", "=", (Object)orgId).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)"1");
        DynamicObject dynamicObject = companyServiceHelper.queryOne("id,adminorg,companytype,industrytype", companyFilter.toArray());
        return dynamicObject;
    }

    public static DynamicObject getCompany(Long orgId, Date bsed) {
        HRBaseServiceHelper companyServiceHelper = new HRBaseServiceHelper("haos_adminorgcompany");
        QFilter filter = new QFilter("adminorg", "=", (Object)orgId);
        filter.and(new QFilter("bsed", "<=", (Object)bsed).and(new QFilter("bsled", ">=", (Object)bsed)));
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"}).and("iscurrentversion", "=", (Object)"0");
        filter.and(statusFilter);
        DynamicObject dynamicObject = companyServiceHelper.queryOne("id,adminorg,companytype,industrytype", filter.toArray());
        return dynamicObject;
    }

    public static DynamicObject getGroup(Long orgId) {
        HRBaseServiceHelper groupServiceHelper = new HRBaseServiceHelper("haos_adminorggroup");
        QFilter groupFilter = new QFilter("adminorg", "=", (Object)orgId).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)"1");
        DynamicObject dynamicObject = groupServiceHelper.queryOne("id,adminorg,groupvision,groupmission,groupleader", groupFilter.toArray());
        return dynamicObject;
    }

    public static DynamicObject getGroup(Long orgId, Date bsed) {
        HRBaseServiceHelper groupServiceHelper = new HRBaseServiceHelper("haos_adminorggroup");
        QFilter filter = new QFilter("adminorg", "=", (Object)orgId);
        filter.and(new QFilter("bsed", "<=", (Object)bsed).and(new QFilter("bsled", ">=", (Object)bsed)));
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"}).and("iscurrentversion", "=", (Object)"0");
        filter.and(statusFilter);
        DynamicObject dynamicObject = groupServiceHelper.queryOne("id,adminorg,groupvision,groupmission,groupleader", filter.toArray());
        return dynamicObject;
    }

    public static DynamicObject getDepartment(Long orgId) {
        HRBaseServiceHelper departmentServiceHelper = new HRBaseServiceHelper("haos_adminorgdepartment");
        QFilter departmentFilter = new QFilter("adminorg", "=", (Object)orgId).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)"1");
        DynamicObject dynamicObject = departmentServiceHelper.queryOne("id,adminorg,departmenttype", departmentFilter.toArray());
        return dynamicObject;
    }

    public static DynamicObject getDepartment(Long orgId, Date bsed) {
        HRBaseServiceHelper departmentServiceHelper = new HRBaseServiceHelper("haos_adminorgdepartment");
        QFilter filter = new QFilter("adminorg", "=", (Object)orgId);
        filter.and(new QFilter("bsed", "<=", (Object)bsed).and(new QFilter("bsled", ">=", (Object)bsed)));
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"}).and("iscurrentversion", "=", (Object)"0");
        filter.and(statusFilter);
        DynamicObject dynamicObject = departmentServiceHelper.queryOne("id,adminorg,departmenttype", filter.toArray());
        return dynamicObject;
    }

    public static Map<Long, List<DynamicObject>> getStructEntryMapFromOrgEntry(DynamicObject[] orgEntry) {
        return Arrays.stream(orgEntry).collect(Collectors.groupingBy(orgRow -> orgRow.getLong("adminorg.boid"), Collectors.mapping(orgRow -> orgRow.getDynamicObjectCollection("struct_project_entry"), Collectors.collectingAndThen(Collectors.toList(), dyColList -> dyColList.stream().flatMap(Collection::stream).collect(Collectors.toList())))));
    }

    public static void getBUFieldItemInfo(IFormView iFormView) {
        iFormView.getModel().setValue("org", (Object)OrgUnitServiceHelper.getRootOrgId());
    }

    public static void getAnchorItemsByBillType(Long adminOrgTypeId, IFormView iFormView) {
        ArrayList<AnchorItems> anchorItems = new ArrayList<AnchorItems>();
        iFormView.setVisible(Boolean.TRUE, new String[]{"group_flex", "company_flex", "dept_flex"});
        AnchorItems orgItems = new AnchorItems("orgflex", ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7", (String)"AdminOrgBatchChgHelper_5", (String)"odc-homs-business", (Object[])new Object[0]), null);
        anchorItems.add(orgItems);
        AnchorItems anchorItems1 = new AnchorItems("change_flex", ResManager.loadKDString((String)"\u53d8\u52a8\u4fe1\u606f", (String)"AdminorgFastChgPlugin_11", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
        AnchorItems anchorItems2 = new AnchorItems("info_flex", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"AdminorgFastChgPlugin_12", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
        anchorItems.add(anchorItems1);
        anchorItems.add(anchorItems2);
        if (adminOrgTypeId.equals(1010L)) {
            AnchorItems anchorItems7 = new AnchorItems("company_flex", ResManager.loadKDString((String)"\u516c\u53f8\u4fe1\u606f", (String)"AdminorgFastChgPlugin_13", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
            AnchorItems anchorItems8 = new AnchorItems("group_flex", ResManager.loadKDString((String)"\u96c6\u56e2\u4fe1\u606f", (String)"AdminorgFastChgPlugin_14", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
            anchorItems.add(anchorItems7);
            anchorItems.add(anchorItems8);
            iFormView.setVisible(Boolean.FALSE, new String[]{"dept_flex"});
        } else if (adminOrgTypeId.equals(1020L)) {
            AnchorItems anchorItems9 = new AnchorItems("company_flex", ResManager.loadKDString((String)"\u516c\u53f8\u4fe1\u606f", (String)"AdminorgFastChgPlugin_13", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
            anchorItems.add(anchorItems9);
            iFormView.setVisible(Boolean.FALSE, new String[]{"dept_flex", "group_flex"});
        } else if (adminOrgTypeId.equals(1030L)) {
            iFormView.setVisible(Boolean.FALSE, new String[]{"dept_flex", "group_flex", "company_flex"});
        } else if (adminOrgTypeId.equals(1040L)) {
            AnchorItems anchorItems10 = new AnchorItems("dept_flex", ResManager.loadKDString((String)"\u90e8\u95e8\u4fe1\u606f", (String)"AdminorgFastChgPlugin_16", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
            anchorItems.add(anchorItems10);
            iFormView.setVisible(Boolean.FALSE, new String[]{"group_flex", "company_flex"});
        }
        String orgStatusCaption = ResManager.loadKDString((String)"\u7ec4\u7ec7\u72b6\u6001", (String)"orgBatch_anchor_8", (String)"odc-homs-business", (Object[])new Object[0]);
        AnchorItems orgStatusItem = new AnchorItems("status_flex", orgStatusCaption, null);
        AnchorItems anchorItems3 = new AnchorItems("duty_flex", ResManager.loadKDString((String)"\u7ec4\u7ec7\u804c\u8d23", (String)"AdminorgFastChgPlugin_17", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
        AnchorItems anchorItems4 = new AnchorItems("coop_flex", ResManager.loadKDString((String)"\u534f\u4f5c\u4fe1\u606f", (String)"AdminorgFastChgPlugin_18", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
        AnchorItems anchorItems5 = new AnchorItems("safe_flex", ResManager.loadKDString((String)"\u4fdd\u5bc6\u4fe1\u606f", (String)"AdminorgFastChgPlugin_19", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
        anchorItems.add(orgStatusItem);
        anchorItems.add(anchorItems3);
        if (HRStringUtils.equals((String)iFormView.getPageCache().get("visibleStruct"), (String)"true")) {
            String structCaption = ResManager.loadKDString((String)"\u77e9\u9635\u7ec4\u7ec7\u4fe1\u606f", (String)"orgBatch_anchor_9", (String)"odc-homs-business", (Object[])new Object[0]);
            AnchorItems anchorItems6 = new AnchorItems("structproject_flex", structCaption, null);
        }
        anchorItems.add(anchorItems4);
        anchorItems.add(anchorItems5);
        AnchorControl anchorCtl = (AnchorControl)iFormView.getControl("anchorcontrolap");
        anchorCtl.addItems(anchorItems);
        anchorCtl.setHighlight(Boolean.TRUE.booleanValue());
    }

    public static List<Long> getOrgAndChildren(Long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HRBaseServiceHelper departmentServiceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        QFilter departmentFilter = new QFilter("adminorg", "=", (Object)orgId).and("iscurrentversion", "=", (Object)"1").and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        DynamicObject dynamicObject = departmentServiceHelper.queryOne("id,adminorg,structlongnumber", departmentFilter.toArray());
        if (dynamicObject != null) {
            QFilter allFilter = new QFilter("structlongnumber", "like", (Object)("%" + dynamicObject.getString("structlongnumber") + "%")).and("iscurrentversion", "=", (Object)"1").and("enable", "=", (Object)"1");
            DynamicObjectCollection dynamicObjects = departmentServiceHelper.queryOriginalCollection("id,adminorg", allFilter.toArray());
            dynamicObjects.forEach(dy -> orgIds.add(dy.getLong("adminorg")));
        }
        return orgIds;
    }

    public static QFilter getOrgAndChildrenFilter(Long orgId) {
        HRBaseServiceHelper departmentServiceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        QFilter departmentFilter = new QFilter("adminorg", "=", (Object)orgId).and("iscurrentversion", "=", (Object)"1");
        DynamicObject orgDyn = departmentServiceHelper.queryOne("id,adminorg,structlongnumber", departmentFilter.toArray());
        if (orgDyn != null) {
            return new QFilter("structlongnumber", "not like", (Object)(orgDyn.getString("structlongnumber") + "%"));
        }
        return null;
    }

    public static void setBelongCompany(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject orgTypeDy = model.getDataEntity().getDynamicObject("adminorgtype");
        DynamicObject parentDy = model.getDataEntity().getDynamicObject("parentorg");
        if (orgTypeDy != null) {
            Long typestd = orgTypeDy.getLong("adminorgtypestd.id");
            if (OrgFastChgBillConstants.ID_ORGTYPE_GROUP.equals(typestd) || OrgFastChgBillConstants.ID_ORGTYPE_COMPANY.equals(typestd)) {
                model.setValue("belongcompany", (Object)view.getModel().getDataEntity().getDynamicObject("adminorg"));
                if (view.getEntityId().equals("homs_orgfastchgadd")) {
                    model.setValue("belongcompany_name", (Object)model.getDataEntity().getString("name"));
                }
            } else if ((OrgFastChgBillConstants.ID_ORGTYPE_REGION.equals(typestd) || OrgFastChgBillConstants.ID_ORGTYPE_DEPARTMENT.equals(typestd)) && parentDy != null) {
                DynamicObject parentBelongCompany = parentDy.getDynamicObject("belongcompany");
                model.setValue("belongcompany", (Object)parentBelongCompany);
                if (view.getEntityId().equals("homs_orgfastchgadd")) {
                    model.setValue("belongcompany_name", (Object)parentBelongCompany.getString("name"));
                }
            }
        }
    }

    public static Map<Long, Map<Long, String>> enabledChildren(Set<Long> orgIdSet) {
        HashMap parentOrgIdOrgIdSetMap = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter orgIdFilter = new QFilter("parentorg", "in", orgIdSet);
        orgIdFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        orgIdFilter.and(new QFilter("enable", "=", (Object)"1"));
        orgIdFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        orgIdFilter.and("boid", "not in", orgIdSet);
        DynamicObjectCollection orgColl = serviceHelper.queryOriginalCollection("boid,parentorg,name", new QFilter[]{orgIdFilter});
        if (CollectionUtils.isEmpty((Collection)orgColl)) {
            return parentOrgIdOrgIdSetMap;
        }
        Map<Long, List<DynamicObject>> orgIdOrgMap = orgColl.stream().collect(Collectors.groupingBy(dy -> dy.getLong("parentorg")));
        for (Map.Entry<Long, List<DynamicObject>> entry : orgIdOrgMap.entrySet()) {
            List<DynamicObject> dyList = entry.getValue();
            HashMap boidToName = Maps.newHashMapWithExpectedSize((int)dyList.size());
            for (DynamicObject dy2 : dyList) {
                boidToName.put(dy2.getLong("boid"), dy2.getString("name"));
            }
            parentOrgIdOrgIdSetMap.put(entry.getKey(), boidToName);
        }
        return parentOrgIdOrgIdSetMap;
    }

    public static boolean isOrgAuth(AuthorizedOrgResult authorizedOrgResult, Long orgId) {
        HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg();
        if (authorizedOrgResult.isHasAllOrgPerm() && hrPermOrg.hasAllOrgPerm()) {
            return true;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        DynamicObject adminOrgDynObj = serviceHelper.queryOne((Object)orgId);
        return authorizedOrgResult.getHasPermOrgs().contains(adminOrgDynObj.getLong("boid")) && hrPermOrg.getHasPermOrgs().contains(adminOrgDynObj.getLong("org.id"));
    }

    public static DynamicObject getNowOrgDyById(Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("id", "=", (Object)orgId);
        DynamicObject orgBoIdDy = serviceHelper.queryOne("id,boid", qFilter.toArray());
        QFilter boIdQF = new QFilter("boid", "=", (Object)orgBoIdDy.getLong("boid"));
        boIdQF.and(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1')));
        DynamicObject dynamicObject = serviceHelper.queryOne("id,boid,adminorgtype.id,adminorgtype.adminorgtypestd,parentorg.id,name,simplename,number,establishmentdate,corporateorg,enable,adminorglayer,adminorgfunction,companyarea,city,detailaddress,index,description,positioning,mainduty,safelevel,safetype,safedescription,workplace,enable,belongcompany,sourcevid", boIdQF.toArray());
        return dynamicObject;
    }

    public static DynamicObject[] getCoopInfoByIds(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgteam");
        QFilter qFilter = new QFilter("id", "in", ids);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public static void setChangeScence(IDataModel model) {
        QFilter buFilter;
        QFilter changeTyeFilter;
        QFilter enableFilter;
        QFilter statusFilter;
        HRBaseServiceHelper serviceHelper;
        DynamicObject[] changeSceneDyns;
        List changeLists;
        if (model.getValue("org") == null) {
            return;
        }
        DynamicObject changeSence = model.getDataEntity().getDynamicObject("changescene");
        if (changeSence == null && (changeLists = Arrays.stream(changeSceneDyns = (serviceHelper = new HRBaseServiceHelper("haos_changescene")).loadDynamicObjectArray(new QFilter[]{statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1')), changeTyeFilter = new QFilter("orgchangetype.id", "=", (Object)model.getDataEntity().getLong("changetype.id")), buFilter = BaseDataHelper.getBaseDataFilter((String)"haos_changescene", (long)((DynamicObject)model.getValue("org")).getLong("id"))})).filter(dyn -> dyn.getLong("id") != 1070L).collect(Collectors.toList())) != null && changeLists.size() == 1) {
            AdminOrgFastChgHelper.setDefaultValue((DynamicObject)changeLists.get(0), model);
        }
    }

    private static void setDefaultValue(DynamicObject dynamicObject, IDataModel model) {
        model.setValue("changescene", (Object)dynamicObject);
        Set changeReasonSet = dynamicObject.getDynamicObjectCollection("changereason").stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_orgchangereason");
        DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", changeReasonSet), BaseDataHelper.getBaseDataFilter((String)"haos_orgchangereason", (long)((DynamicObject)model.getValue("org")).getLong("id")), new QFilter("enable", "=", (Object)"1")});
        if (dynamicObjects.length == 1) {
            model.setValue("changereason", (Object)dynamicObjects[0]);
        }
    }

    public static AuthorizedOrgTeamResult getAuthorizedOrgTeams(String entityNumber, String propKey) {
        return (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedOrgTeams", (Object[])new Object[]{RequestContext.get().getCurrUserId(), PermCommonUtil.getAppIdFromSuspectedAppNum((String)"homs"), entityNumber, "47156aff000000ac", propKey});
    }

    public static boolean listCheckRevise(IFormView iFormView, DynamicObject[] dynamicObjects) {
        if (dynamicObjects.length > 1) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"AdminorgDetailListPlugin_10", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long orgId = dynamicObjects[0].getLong("sourcevid");
        boolean hasSpecificPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"homs", (String)"homs_adminorgdetail", (String)"37LU0YWHT9+2");
        if (!hasSpecificPerm) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u7ec7\u4fee\u8ba2\u7684\u6743\u9650\u3002", (String)"AdminorgDetailListPlugin_32", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject org = AdminOrgFastChgHelper.getOrgDyById(orgId);
        AuthorizedOrgResult orgAuth = AdminOrgFastChgHelper.getOrgAuth(iFormView);
        if (!orgAuth.isHasAllOrgPerm() && Objects.nonNull(orgAuth.getHasPermOrgs()) && !orgAuth.getHasPermOrgs().contains(org.getLong("boid"))) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u672a\u5206\u914d\u6570\u636e\u8303\u56f4\u3002", (String)"OrgDiffTreeList_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean checkReviseBefore(IFormView that, Long orgBoId, Long orgId) {
        Map<String, String> billMap;
        DynamicObject org = HOMSAdminOrgRepository.getInstance().getOrgDyById(orgId);
        if (HRStringUtils.equals((String)org.getString("enable"), (String)"0")) {
            that.showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u201c\u7ec4\u7ec7\u4fee\u8ba2\u201d\u7684\u64cd\u4f5c\u3002", (String)"AdminorgDetailListPlugin_39", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject orgBoDy = HOMSAdminOrgRepository.getInstance().getOrgDyByBoId(orgBoId);
        if (HRStringUtils.equals((String)orgBoDy.getString("enable"), (String)"0")) {
            that.showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u201c\u7ec4\u7ec7\u4fee\u8ba2\u201d\u7684\u64cd\u4f5c\u3002", (String)"AdminorgDetailListPlugin_39", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject orgNowDy = HOMSAdminOrgRepository.getInstance().getOrgDyByBoId(orgBoId);
        if (orgId.equals(orgNowDy.getLong("sourcevid")) && (billMap = HOMSAdminOrgRepository.getInstance().queryBillByOrgBoId(orgBoId)).containsKey("billno") && !HRStringUtils.isEmpty((String)billMap.get("billno")) && billMap.containsKey("changetype")) {
            that.showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d \u7684\u201c%3$s\u201d\u4e2d\uff0c\u8bf7\u5148\u7b49\u5355\u636e\u751f\u6548\u540e\u518d\u64cd\u4f5c\u3002", (String)"AdminorgDetailListPlugin_33", (String)"odc-homs-formplugin", (Object[])new Object[0]), billMap.get("adminorg"), billMap.get("billno"), billMap.get("changetype")));
            return false;
        }
        if ("-2".equals(org.getString("datastatus"))) {
            that.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u88ab\u66f4\u6539\uff0c\u60a8\u9700\u8981\u91cd\u65b0\u5237\u65b0\uff0c\u57fa\u4e8e\u8be5\u7ec4\u7ec7\u7684\u6700\u65b0\u4fe1\u606f\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AdminorgDetailListPlugin_34", (String)"odc-homs-formplugin", (Object[])new Object[0]), org.getString("name")));
            return false;
        }
        return true;
    }

    public static void setParentFilter(DynamicObject orgObject, BeforeF7SelectEvent event, Date qureryDate, IFormView iFormView) {
        DynamicObject orgtype = iFormView.getModel().getDataEntity().getDynamicObject("adminorgtype");
        if (orgtype != null && orgtype.getLong("id") != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            Long orgtypeId = orgtype.getLong("adminorgtypestd.id");
            if (orgtypeId.equals(1010L)) {
                list.add(1010L);
                list.add(1030L);
            } else if (orgtypeId.equals(1020L)) {
                list.add(1010L);
                list.add(1030L);
                list.add(1020L);
            } else {
                list.add(1010L);
                list.add(1030L);
                list.add(1020L);
                list.add(1040L);
            }
            if (list.size() > 0) {
                QFilter qFilter = new QFilter("adminorgtype.adminorgtypestd", "in", list);
                event.getCustomQFilters().add(qFilter);
            }
        }
        if (orgObject != null) {
            event.getCustomQFilters().add(new QFilter("id", "!=", (Object)orgObject.getLong("id")));
        }
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setShowApproved(false);
        event.getCustomQFilters().add(new QFilter("iscurrentversion", "=", (Object)"0"));
        event.getCustomQFilters().add(new QFilter("bsed", "<=", (Object)qureryDate));
        event.getCustomQFilters().add(new QFilter("bsled", ">=", (Object)qureryDate));
        event.getCustomQFilters().add(new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()}));
        formShowParameter.setCustomParam("custom_list_data_status_bsed_filter", (Object)"custom_list_data_status_bsed_filter");
        formShowParameter.setCustomParam("searchdate", (Object)qureryDate);
    }

    public static void setTips(String tipsName, IFormView iFormView, String pageName) {
        Tips tips = new Tips();
        List tipsStr = HRCSRPCServiceHelper.queryPromptForString((IFormView)iFormView, (String)pageName, (String)tipsName);
        if (!CollectionUtils.isEmpty((Collection)tipsStr)) {
            tips.setContent(new LocaleString((String)tipsStr.get(0)));
            tips.setType("text");
            tips.setTriggerType("hover");
            tips.setIsConfirm(false);
            tips.setShowIcon(true);
            TipsSupport control = (TipsSupport)iFormView.getControl(tipsName);
            if (control != null) {
                control.addTips(tips);
            }
        }
    }

    public static void showChargePersonImportDetail(AbstractFormPlugin formPlugin) {
        IFormView formView = formPlugin.getView();
        FormConfig config = FormMetadataCache.getFormConfig((String)"hrpi_chargeperson");
        String mainEntityDisplayName = config.getCaption().getLocaleValue();
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u5bfc\u5165\u7ed3\u679c", (String)"ImportDetails_1", (String)"bos-import", (Object[])new Object[0]), mainEntityDisplayName));
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("bos_importlog");
        showParameter.setListFilterParameter(AdminOrgFastChgHelper.buildListFilterParameter(config.getEntityTypeId()));
        showParameter.setCustomParam("MainEntityDisplayName", (Object)mainEntityDisplayName);
        showParameter.setCustomParam("MainEntityId", (Object)config.getEntityTypeId());
        showParameter.setCustomParam("ParentEntityId", (Object)((ListView)formView).getBillFormId());
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        IFormView mainView = formView.getMainView();
        if (mainView != null && !mainView.getPageId().equals(formView.getPageId())) {
            IFormView appView = SessionManager.getCurrent().getViewNoPlugin(formView.getFormShowParameter().getAppId() + mainView.getPageId());
            appView.showForm((FormShowParameter)showParameter);
            formView.sendFormAction(appView);
        }
    }

    private static ListFilterParameter buildListFilterParameter(String entityId) {
        QFilter f1 = new QFilter("sourceobj", "=", (Object)entityId).and("creator", "=", (Object)RequestContext.get().getCurrUserId());
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(f1);
        return listFilterParameter;
    }

    public static void showChargePersonImportPage(AbstractFormPlugin formPlugin) {
        FormShowParameter currentFormParameter = formPlugin.getView().getFormShowParameter();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_importstart");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("RealPermissionEntityId", (Object)"homs_adminorgdetail");
        formShowParameter.setCustomParam("OperateName", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u90e8\u95e8\u8d1f\u8d23\u4eba", (String)"AdminOrgFastChgHelper_0", (String)"odc-homs-business", (Object[])new Object[0]));
        formShowParameter.setCustomParam("BillFormId", (Object)"hrpi_chargeperson");
        FormConfig config = FormMetadataCache.getFormConfig((String)"hrpi_chargeperson");
        formShowParameter.setCustomParam("ListName", (Object)config.getCaption().toString());
        formShowParameter.setCustomParam("BillTypeId", null);
        formShowParameter.setCustomParam("CheckRightAppId", (Object)currentFormParameter.getCheckRightAppId());
        formShowParameter.setCustomParam("PermissionItemId", (Object)"37LU3EETSVC=");
        formShowParameter.setCustomParam("ServiceAppId", (Object)config.getAppId());
        formShowParameter.setCustomParam("ImportPlugin", (Object)"kd.hrmp.hrpi.formplugin.web.chargeperson.ChargePersonImportPlugin");
        formPlugin.getView().showForm(formShowParameter);
    }

    public static void showLogPage(String billFormId, IFormView formView, List<Long> orgLists, String fieldKey, String buFieldKey) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setBillFormId(billFormId);
        formShowParameter.setFormId("bos_list");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter filter = null;
        if (!CollectionUtils.isEmpty(orgLists)) {
            DynamicObject[] adminOrgArr = AdOrgRepository.getInstance().queryOrgInfoByBoId("boid", orgLists);
            if (adminOrgArr != null && adminOrgArr.length > 0) {
                Set adminOrgIds = Arrays.stream(adminOrgArr).map(adminOrg -> adminOrg.getLong("boid")).collect(Collectors.toSet());
                formShowParameter.setCustomParam("adminOrgIds", (Object)JSON.toJSONString(adminOrgIds));
            }
        } else {
            HasPermOrgResult hrPermOrg;
            AuthorizedOrgResult orgAuth = AdminOrgFastChgHelper.getOrgAuth(formView);
            if (!orgAuth.isHasAllOrgPerm()) {
                filter = new QFilter(fieldKey, "in", (Object)orgAuth.getHasPermOrgs());
            }
            if (!(hrPermOrg = OrgPermHelper.getHRPermOrg()).hasAllOrgPerm()) {
                filter = new QFilter(buFieldKey, "in", (Object)hrPermOrg.getHasPermOrgs());
            }
        }
        if (filter != null) {
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
        formView.showForm((FormShowParameter)formShowParameter);
    }

    public static void orgPropertyChanged(PropertyChangedArgs changedArgs, IFormView iFormView, IFormPlugin formPlugin) {
        ChangeData changeData = changedArgs.getChangeSet()[0];
        DynamicObject newDy = (DynamicObject)changeData.getNewValue();
        DynamicObject oldDy = (DynamicObject)changeData.getOldValue();
        String masterOrg = iFormView.getPageCache().get("masterOrg");
        if (changedArgs.getChangeSet()[0].getNewValue() == null) {
            return;
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        boolean exists = hrBaseServiceHelper.isExists((Object)iFormView.getModel().getDataEntity().getLong("id"));
        if (exists) {
            return;
        }
        Long orgIdNew = newDy.getLong("id");
        if (StringUtils.isNotEmpty((CharSequence)masterOrg) && !StringUtils.equals((CharSequence)masterOrg, (CharSequence)String.valueOf(orgIdNew))) {
            Long orgIDOld = oldDy == null ? 0L : oldDy.getLong("id");
            iFormView.getPageCache().put("masterOrg", String.valueOf(orgIDOld));
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("chg_org", formPlugin);
            iFormView.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e3b\u7ba1\u8d23\u4efb\u5355\u4f4d\u540e\uff0c\u5c06\u6e05\u9664\u8be5\u7ec4\u7ec7\u4e0d\u53ef\u4f7f\u7528\u7684\u57fa\u7840\u8d44\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"AdminorgFastChgPlugin_35", (String)"odc-homs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
    }

    public static void cleanOrgBaseInfo(long orgId, IFormView iFormView) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)iFormView.getEntityId());
        IDataModel model = iFormView.getModel();
        for (IDataEntityProperty property : entityType.getAllFields().values()) {
            DynamicObject baseDy;
            IDataEntityType parent;
            if (!(property instanceof BasedataProp) || (parent = property.getParent()) == null) continue;
            if (!parent.getName().equals(iFormView.getEntityId())) {
                DynamicObjectCollection dynamicObjectCollection;
                if (!model.getDataEntity().containsProperty(property.getParent().getName()) || CollectionUtils.isEmpty((Collection)(dynamicObjectCollection = model.getDataEntity(true).getDynamicObjectCollection(property.getParent().getName())))) continue;
                for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                    DynamicObject entrtyDy = (DynamicObject)dynamicObjectCollection.get(i);
                    DynamicObject baseDy2 = entrtyDy.getDynamicObject(property.getName());
                    if (baseDy2 == null || !AdminOrgFastChgHelper.cleanBastInfo(baseDy2, property, iFormView, orgId)) continue;
                    model.setValue(property.getName(), null, i);
                }
                continue;
            }
            if (!model.getDataEntity().containsProperty(property.getName()) || (baseDy = model.getDataEntity().getDynamicObject(property.getName())) == null || !AdminOrgFastChgHelper.cleanBastInfo(baseDy, property, iFormView, orgId)) continue;
            model.setValue(property.getName(), null);
        }
    }

    private static boolean cleanBastInfo(DynamicObject baseDy, IDataEntityProperty property, IFormView iFormView, long orgId) {
        HRBaseServiceHelper baseServiceHelper;
        DynamicObject baseInfoDy;
        String ctrlstrategy;
        Boolean baseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)((BasedataProp)property).getBaseEntityId());
        return baseDataCtrl != false && (HRStringUtils.equals((String)(ctrlstrategy = (baseInfoDy = (baseServiceHelper = new HRBaseServiceHelper(((BasedataProp)property).getBaseEntityId())).queryOne("id,ctrlstrategy", baseDy.get("id"))).getString("ctrlstrategy")), (String)"2") || HRStringUtils.equals((String)ctrlstrategy, (String)"7")) && !AdminOrgFastChgHelper.checkAssign(iFormView, property, baseDy, orgId);
    }

    private static boolean checkAssign(IFormView iFormView, IDataEntityProperty property, DynamicObject baseDy, long orgId) {
        IDataEntityType dataEntityType = baseDy.getDataEntityType();
        String baseDataTableName = dataEntityType.getAlias();
        String dbRouteKey = dataEntityType.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        String bsaeDataUseRegTableName = baseDataTableName + "UseReg";
        String countUseRegSql = "select FDataID from " + bsaeDataUseRegTableName + " where FDataID = ? and fuseorgid = ? ";
        Object[] params = new Object[]{baseDy.get("id"), orgId};
        Boolean assign = (Boolean)DB.query((DBRoute)dbRoute, (String)countUseRegSql, (Object[])params, ResultSet::next);
        return assign;
    }

    public static void showStructParentOrgF7(BeforeF7SelectEvent event, IFormView iFormView) {
        DynamicObject orgObject = (DynamicObject)iFormView.getModel().getValue("adminorg");
        int rowIndex = event.getRow();
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        DynamicObjectCollection entryDynColl = iFormView.getModel().getDataEntity(true).getDynamicObjectCollection("struct_project_entry");
        DynamicObject focusEntryDyn = (DynamicObject)entryDynColl.get(rowIndex);
        long structId = focusEntryDyn.getLong("struct_project.id");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        event.addCustomQFilter(initStatusFilter);
        QFilter isCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"0");
        DynamicObject[] structOrgArr = AdminOrgStructRepository.getInstance().queryStructInfoByStruct("id,adminorg", Long.valueOf(structId), null);
        Set orgIds = Arrays.asList(structOrgArr).stream().map(dynamicObject -> dynamicObject.getLong("adminorg.id")).collect(Collectors.toSet());
        event.getCustomQFilters().add(new QFilter("boid", "in", orgIds));
        AuthorizedOrgResult permResult = AdminOrgBatchChgHelper.getOrgAuth(iFormView, structId);
        event.getFormShowParameter().setHasRight(false);
        if (permResult != null && !permResult.isHasAllOrgPerm()) {
            QFilter authFilter = new QFilter("boid", "in", (Object)permResult.getHasPermOrgs());
            event.getCustomQFilters().add(authFilter);
        }
        if (orgObject != null) {
            event.getCustomQFilters().add(new QFilter("id", "!=", (Object)orgObject.getLong("id")));
        }
        Date effDate = DateUtils.truncate((Date)new Date(), (int)5);
        event.getCustomQFilters().add(new QFilter("bsed", "<=", (Object)effDate));
        event.getCustomQFilters().add(new QFilter("bsled", ">=", (Object)effDate));
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        event.getCustomQFilters().add(dataStatusFilter);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        event.getCustomQFilters().add(statusFilter);
        event.getCustomQFilters().add(isCurrentVersion);
        HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg();
        if (!hrPermOrg.hasAllOrgPerm()) {
            QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", (List)hrPermOrg.getHasPermOrgs());
            event.getCustomQFilters().add(baseDataFilter);
        }
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7", (String)"VirtualOrgDetailPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
    }

    public static void structProjectChg(IFormView iFormView, PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (newValue != null) {
            DynamicObjectCollection entryDynColl = iFormView.getModel().getDataEntity(true).getDynamicObjectCollection("struct_project_entry");
            DynamicObject focusEntryDyn = (DynamicObject)entryDynColl.get(rowIndex);
            long structId = focusEntryDyn.getLong("struct_project.id");
            String orgLongName = OrgBatchBillHelper.getOrgLongName((Long)newValue.getLong("boid"), (Date)new Date(), (String)String.valueOf(structId));
            iFormView.getModel().setValue("struct_long_name", (Object)orgLongName, rowIndex);
        } else {
            iFormView.getModel().setValue("struct_long_name", (Object)"", rowIndex);
        }
    }

    public static void showOperateStepsPage(IFormView formView) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setBillFormId("homs_orgoperatetask");
        formShowParameter.setFormId("bos_list");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formView.showForm((FormShowParameter)formShowParameter);
    }

    public static boolean checkOrgOperateTask(List<Long> orgIds, IFormView view, boolean isCheckChild) {
        DynamicObject[] adminorgDyArr;
        DynamicObject[] operateTaskIng = OrgOperateTaskRepository.getInstance().getAllOrgTaskByIng();
        if (operateTaskIng.length == 0) {
            return true;
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        for (DynamicObject adminorgDy : adminorgDyArr = hrBaseServiceHelper.query("id,boid,name,structlongnumber", new QFilter[]{new QFilter("id", "in", orgIds)})) {
            String orgStructLongNumber = adminorgDy.getString("structlongnumber");
            Long orgId = adminorgDy.getLong("boid");
            for (DynamicObject orgOperateTask : operateTaskIng) {
                if (orgId.equals(orgOperateTask.getLong("adminorgid.id"))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6b63\u5728\u6267\u884c\u201c\u53d8\u66f4\u201d\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u64cd\u4f5c\u3002\u53ef\u901a\u8fc7\u201c\u7ec4\u7ec7\u53d1\u5c55\u4e91>\u7ec4\u7ec7\u7ba1\u7406>\u7ec4\u7ec7\u5feb\u901f\u7ef4\u62a4\u201d\u70b9\u51fb\u201c\u66f4\u591a>\u67e5\u770b\u7ec4\u7ec7\u53d8\u52a8\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u201d\u67e5\u770b\u5904\u7406\u8fdb\u5ea6\u3002", (String)"AdminorgDetailListPlugin_37", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                    return false;
                }
                String operateTaskStructLongNumber = orgOperateTask.getString("structlongnumber");
                DynamicObject adminorg = orgOperateTask.getDynamicObject("adminorgid");
                if (!isCheckChild) continue;
                if (orgStructLongNumber.startsWith(operateTaskStructLongNumber)) {
                    view.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u56e0\u4e0a\u7ea7\u7ec4\u7ec7\u201c%1$s\u201d/\u201c%2$s\u201d\u53d8\u66f4\u540c\u6b65\u66f4\u65b0\u672c\u7ec4\u7ec7\u7684\u4fe1\u606f\uff0c\u8be5\u52a8\u4f5c\u5c1a\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u64cd\u4f5c\u3002\u53ef\u901a\u8fc7\u201c\u7ec4\u7ec7\u53d1\u5c55\u4e91>\u7ec4\u7ec7\u7ba1\u7406>\u7ec4\u7ec7\u5feb\u901f\u7ef4\u62a4\u201d\u70b9\u51fb\u201c\u66f4\u591a>\u67e5\u770b\u7ec4\u7ec7\u53d8\u52a8\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u201d\u67e5\u770b\u5904\u7406\u8fdb\u5ea6\u3002", (String)"AdminorgDetailListPlugin_38", (String)"odc-homs-formplugin", (Object[])new Object[0]), adminorg.getString("name"), adminorg.getString("number")));
                    return false;
                }
                if (!operateTaskStructLongNumber.startsWith(orgStructLongNumber)) continue;
                view.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u56e0\u672c\u7ec4\u7ec7\u53d8\u66f4\u9700\u8981\u540c\u6b65\u5904\u7406\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u4fe1\u606f\uff0c\u4f46\u662f\u8fd9\u4e9b\u4e0b\u7ea7\u7ec4\u7ec7\u5728\u7ec4\u7ec7\u201c%1$s\u201d/\u201c%2$s\u201d\u53d8\u66f4\u4e8b\u52a1\u4e2d\u5c1a\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u64cd\u4f5c\u3002\u53ef\u901a\u8fc7\u201c\u7ec4\u7ec7\u53d1\u5c55\u4e91>\u7ec4\u7ec7\u7ba1\u7406>\u7ec4\u7ec7\u5feb\u901f\u7ef4\u62a4\u201d\u70b9\u51fb\u201c\u67e5\u770b\u7ec4\u7ec7\u53d8\u52a8\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u201d\u67e5\u770b\u5904\u7406\u8fdb\u5ea6\u3002", (String)"AdminorgDetailListPlugin_40", (String)"odc-homs-formplugin", (Object[])new Object[0]), adminorg.getString("name"), adminorg.getString("number")));
                return false;
            }
        }
        return true;
    }

    public static DynamicObject createNewOperateTaskDy(DynamicObject orgDy, long changeopid) {
        DynamicObject[] allOrgOperateSteps;
        DynamicObject operateTaskDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"homs_orgoperatetask"));
        long id = ORM.create().genLongId("homs_orgoperatetask");
        operateTaskDy.set("id", (Object)id);
        operateTaskDy.set("org", orgDy.get("org"));
        operateTaskDy.set("number", orgDy.get("number"));
        operateTaskDy.set("name", orgDy.get("number"));
        operateTaskDy.set("changeopid", (Object)changeopid);
        operateTaskDy.set("savestatus", (Object)"1");
        operateTaskDy.set("adminorgid", orgDy.get("id"));
        operateTaskDy.set("structlongnumber", orgDy.get("structlongnumber"));
        operateTaskDy.set("structlongnumber", orgDy.get("structlongnumber"));
        operateTaskDy.set("retrycount", (Object)0);
        operateTaskDy.set("creator", (Object)RequestContext.get().getUserId());
        operateTaskDy.set("org", orgDy.get("org"));
        DynamicObjectCollection dynamicObjectCollection = operateTaskDy.getDynamicObjectCollection("entryentity");
        DynamicObject firstDy = dynamicObjectCollection.addNew();
        DynamicObject secondDy = dynamicObjectCollection.addNew();
        DynamicObject thirdDy = dynamicObjectCollection.addNew();
        DynamicObject fourthDy = dynamicObjectCollection.addNew();
        DynamicObject fifthDy = dynamicObjectCollection.addNew();
        HashMap<Long, DynamicObject> stepsMap = new HashMap<Long, DynamicObject>(5);
        stepsMap.put(OrgOperateTaskConstants.SETPS_FIRST, firstDy);
        stepsMap.put(OrgOperateTaskConstants.SETPS_SECOND, secondDy);
        stepsMap.put(OrgOperateTaskConstants.SETPS_THIRD, thirdDy);
        stepsMap.put(OrgOperateTaskConstants.SETPS_FOURTH, fourthDy);
        stepsMap.put(OrgOperateTaskConstants.SETPS_FIFTH, fifthDy);
        for (DynamicObject orgOperateSteps : allOrgOperateSteps = OrgOperateStepsRepository.getInstance().getAllOrgOperateSteps()) {
            if (!stepsMap.containsKey(orgOperateSteps.getLong("id"))) continue;
            DynamicObject stepsEntityDy = (DynamicObject)stepsMap.get(orgOperateSteps.getLong("id"));
            stepsEntityDy.set("opstepsid", (Object)orgOperateSteps.getLong("id"));
            stepsEntityDy.set("opstepsname", orgOperateSteps.get("name"));
            stepsEntityDy.set("stepsstatus", (Object)"0");
            stepsEntityDy.set("starttime", (Object)HisEffDateCommonService.getInstance().getDate2999(null));
            stepsEntityDy.set("endtime", (Object)HisEffDateCommonService.getInstance().getDate2999(null));
        }
        return operateTaskDy;
    }
}

