/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.helper;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.hr.haos.business.domain.repository.adorg.ChangeTypeRepository;
import kd.hr.haos.business.rpc.HRPIRPCServiceHelper;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.haos.common.util.tree.TreeAssistUtils;
import kd.hr.hbp.business.dao.IHRBaseDao;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.orgbatch.strategy.AdminOrgBatchViewStrategyContext;
import kd.hr.homs.common.constants.batchchg.ChangeTypeEnum;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.ChangeTypeVo;
import kd.hr.homs.common.model.OrgCubeTreeNode;

public class AdminOrgMagicHelper {
    private static final Log logger = LogFactory.getLog(AdminOrgMagicHelper.class);
    private static final String PARENT_ORG_ID = "parentorg.id";
    private static final String IS_EDIT = "isEdit";
    private static final String DISPLAY_CHGORG = "display_chgorg";
    public static final String EVENT_STATUS_UPDATE = "update";
    public static final String EVENT_STATUS_INIT = "init";
    private static final int MAX_CYCLE_TIME = 15;
    private static final String CHART_TREE_NODE_LIST = "chartTreeNodeList";
    private static final String SHOW_LEVEL = "showLevel";
    private static final String ROOT_NODE_ID = "rootNodeId";
    private static final String ROOT_NODE = "rootNode";

    public static void returnToList(IFormView view) {
        view.setVisible(Boolean.valueOf(true), new String[]{"chg_info"});
        view.setVisible(Boolean.valueOf(false), new String[]{"org_magic"});
        view.getPageCache().put("isList", "1");
        Container baseInfo = (Container)view.getControl("fs_baseinfo");
        baseInfo.setCollapse(false);
    }

    public static void refreshPartOfView(IFormView view, List<Long> entryIdList, String eventName, String eventStatus) {
        List<Object> treeNodes;
        boolean onlyChangeOrg = (Boolean)view.getModel().getValue(DISPLAY_CHGORG);
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        IPageCache pageCache = view.getPageCache();
        Integer showLevel = Optional.ofNullable(pageCache.get(SHOW_LEVEL)).map(Integer::valueOf).orElse(0);
        Map<String, OrgCubeTreeNode> entryNodeMap = AdminOrgMagicHelper.buildEntryNode(dataEntity).stream().collect(Collectors.toMap(OrgCubeTreeNode::getId, node -> node));
        switch (eventName) {
            case "info_chg": {
                DynamicObjectCollection info = dataEntity.getDynamicObjectCollection("entryentity_info");
                treeNodes = info.stream().filter(item -> entryIdList.contains(item.getLong("id"))).map(item -> (OrgCubeTreeNode)entryNodeMap.get(item.getString("info_adminorg.id"))).collect(Collectors.toList());
                if (!AdminOrgMagicHelper.setNewRootNode(view, onlyChangeOrg, treeNodes, pageCache, showLevel)) break;
                return;
            }
            case "add_org": {
                DynamicObjectCollection add = dataEntity.getDynamicObjectCollection("entryentity_add");
                treeNodes = add.stream().filter(item -> entryIdList.contains(item.getLong("id"))).map(item -> (OrgCubeTreeNode)entryNodeMap.get(item.getString("add_adminorg"))).collect(Collectors.toList());
                showLevel = AdminOrgMagicHelper.getAddOrgLevel(treeNodes, pageCache, showLevel);
                break;
            }
            case "disable_org": {
                DynamicObjectCollection disable = dataEntity.getDynamicObjectCollection("entryentity_disable");
                treeNodes = disable.stream().filter(item -> entryIdList.contains(item.getLong("id"))).map(item -> (OrgCubeTreeNode)entryNodeMap.get(item.getString("disable_adminorg.id"))).collect(Collectors.toList());
                break;
            }
            default: {
                treeNodes = new ArrayList<OrgCubeTreeNode>();
            }
        }
        AdminOrgMagicHelper.setChangeTypeList(treeNodes);
        AdminOrgMagicHelper.setDataForCustomControl(treeNodes, view, onlyChangeOrg, showLevel, eventName, eventStatus);
    }

    private static boolean setNewRootNode(IFormView view, boolean onlyChangeOrg, List<OrgCubeTreeNode> treeNodes, IPageCache pageCache, Integer showLevel) {
        OrgCubeTreeNode orgCubeTreeNode = treeNodes.get(0);
        String id = orgCubeTreeNode.getId();
        String parentId = orgCubeTreeNode.getParentid();
        if (HRStringUtils.equals((String)pageCache.get(ROOT_NODE_ID), (String)id) && HRStringUtils.isNotEmpty((String)parentId) && !HRStringUtils.equals((String)parentId, (String)"0")) {
            Date date = AdminOrgMagicHelper.getDate(view.getModel().getDataEntity());
            List<Long> permOrgId = AdminOrgMagicHelper.getPermOrgs(view, date);
            DynamicObject parentOrg = AdminOrgBatchChgHelper.getOrgDyById(Long.valueOf(parentId));
            Long parentBoId = parentOrg.getLong("boid");
            OrgCubeTreeNode parentOrgCubeTreeNode = new OrgCubeTreeNode(parentId, parentOrg.getString("name"), parentOrg.getString(PARENT_ORG_ID), "", permOrgId.contains(parentBoId) ? "1" : "0");
            String rootNode = pageCache.get(ROOT_NODE);
            if (rootNode != null) {
                ArrayList<OrgCubeTreeNode> treeNodeList = new ArrayList<OrgCubeTreeNode>();
                OrgCubeTreeNode orgRootNode = (OrgCubeTreeNode)JSON.parseObject((String)rootNode, OrgCubeTreeNode.class);
                orgRootNode.setChangeType(ChangeTypeEnum.INFO.getNumber());
                orgRootNode.setText(orgCubeTreeNode.getText());
                treeNodeList.add(orgRootNode);
                parentOrgCubeTreeNode.setChildren(treeNodeList);
                ArrayList<OrgCubeTreeNode> orgList = new ArrayList<OrgCubeTreeNode>();
                orgList.add(parentOrgCubeTreeNode);
                AdminOrgMagicHelper.setOrgInfo(orgList, date);
                try {
                    pageCache.put(ROOT_NODE, JSONUtils.toString((Object)parentOrgCubeTreeNode));
                }
                catch (IOException e) {
                    logger.error("JSONUtils.toString(chartTreeNodeList) error");
                }
                pageCache.put(SHOW_LEVEL, showLevel + 1 + "");
                pageCache.put(ROOT_NODE_ID, parentId);
                AdminOrgMagicHelper.setChangeTypeList(Collections.singletonList(parentOrgCubeTreeNode));
                AdminOrgMagicHelper.setDataForCustomControl(parentOrgCubeTreeNode, view, onlyChangeOrg, showLevel + 1, EVENT_STATUS_INIT, EVENT_STATUS_INIT);
                return true;
            }
        }
        return false;
    }

    private static Integer getAddOrgLevel(List<OrgCubeTreeNode> treeNodes, IPageCache pageCache, Integer showLevel) {
        String chartTreeNodeListString = pageCache.get(CHART_TREE_NODE_LIST);
        if (chartTreeNodeListString != null) {
            List chartTreeNodeList = JSON.parseArray((String)chartTreeNodeListString, OrgCubeTreeNode.class);
            OrgCubeTreeNode orgCubeTreeNode = treeNodes.get(0);
            boolean noneMatch = chartTreeNodeList.stream().noneMatch(node -> HRStringUtils.equals((String)node.getId(), (String)orgCubeTreeNode.getId()));
            if (noneMatch) {
                chartTreeNodeList.add(orgCubeTreeNode);
                try {
                    pageCache.put(CHART_TREE_NODE_LIST, JSONUtils.toString((Object)chartTreeNodeList));
                }
                catch (IOException e) {
                    logger.error("JSONUtils.toString(chartTreeNodeList) error");
                }
                Map<String, String> collect = chartTreeNodeList.stream().collect(Collectors.toMap(OrgCubeTreeNode::getId, OrgCubeTreeNode::getParentid, (v1, v2) -> v1));
                int addOrgLevel = AdminOrgMagicHelper.countLevel(orgCubeTreeNode.getId(), collect, pageCache.get(ROOT_NODE_ID), 1);
                if (addOrgLevel > showLevel) {
                    showLevel = addOrgLevel;
                    pageCache.put(SHOW_LEVEL, showLevel + "");
                }
            }
        }
        return showLevel;
    }

    public static void refreshOrgCubeView(IFormView view, String eventName, String eventStatus) {
        String rootOrgId = view.getPageCache().get("exchange_root");
        if (HRStringUtils.isEmpty((String)rootOrgId)) {
            rootOrgId = "0";
        }
        AdminOrgMagicHelper.showOrgCubeView(view, Long.parseLong(rootOrgId), eventName, eventStatus);
    }

    public static void showOrgCubeView(IFormView view, long rootOrgId, String eventName, String eventStatus) {
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        boolean onlyChangeOrg = dataEntity.getBoolean(DISPLAY_CHGORG);
        List<OrgCubeTreeNode> entryNodeList = AdminOrgMagicHelper.buildEntryNode(dataEntity);
        if (CollectionUtils.isEmpty(entryNodeList)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u56fe\u5f62\u5316\u68c0\u67e5\u9700\u8981\u81f3\u5c11\u6dfb\u52a0\u4e00\u6761\u7ec4\u7ec7\u8c03\u6574\u8bb0\u5f55\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgMagicHelper_0", (String)"odc-homs-business", (Object[])new Object[0]));
            AdminOrgMagicHelper.returnToList(view);
            return;
        }
        Map<String, List<OrgCubeTreeNode>> entryNodeMap = entryNodeList.stream().collect(Collectors.groupingBy(OrgCubeTreeNode::getChangeType));
        Date date = AdminOrgMagicHelper.getDate(dataEntity);
        List<Long> changeIdSet = entryNodeList.stream().map(node -> Long.valueOf(node.getId())).collect(Collectors.toList());
        List<Long> parentOrgIdList = AdminOrgMagicHelper.getParentOrgIdList(entryNodeMap);
        Map<String, String> latestHisIdMap = AdminOrgMagicHelper.getLatestHisIdMap(changeIdSet, parentOrgIdList, date);
        BillOperationStatus billStatus = ((BillShowParameter)view.getFormShowParameter()).getBillStatus();
        if (BillOperationStatus.EDIT.equals((Object)billStatus) && AdminOrgMagicHelper.checkLatestVersion(view, entryNodeList, latestHisIdMap)) {
            return;
        }
        List parentNodeList = entryNodeMap.getOrDefault(ChangeTypeEnum.PARENT.getNumber(), new ArrayList());
        List<Long> parentChangeBoIdList = AdminOrgMagicHelper.getBoIdList(parentNodeList.stream().map(node -> Long.valueOf(node.getId())).collect(Collectors.toList()));
        List<Long> mergeSplitParentOrgIdList = entryNodeList.stream().filter(node -> {
            String changeType = node.getChangeType();
            return HRStringUtils.equals((String)ChangeTypeEnum.MERGE.getNumber(), (String)changeType) || HRStringUtils.equals((String)ChangeTypeEnum.SPLIT.getNumber(), (String)changeType);
        }).map(node -> {
            String parentId = node.getParentid();
            if (HRStringUtils.equals((String)"0", (String)parentId)) {
                return PlatformRootUtils.getLongRootIdOfPlatform();
            }
            return Long.valueOf(parentId);
        }).collect(Collectors.toList());
        Map<Long, Long> mergeSplitParentOrgIdMap = AdminOrgMagicHelper.getHisIdList(mergeSplitParentOrgIdList, date).stream().collect(Collectors.toMap(org -> org.getLong("boid"), org -> org.getLong("id")));
        parentOrgIdList.addAll(mergeSplitParentOrgIdMap.values());
        List<Long> orgIdList = AdminOrgMagicHelper.getBoIdList(parentOrgIdList);
        Set<String> parentChangeOrgStruct = AdminOrgMagicHelper.getParentChangeOrgStruct(parentChangeBoIdList, date);
        OrgCubeTreeNode orgRootNode = AdminOrgMagicHelper.getRootNode(rootOrgId, orgIdList, parentChangeOrgStruct, date);
        if (orgRootNode == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u6839\u8282\u70b9\u3002", (String)"AdminOrgMagicHelper_1", (String)"odc-homs-business", (Object[])new Object[0]));
            AdminOrgMagicHelper.returnToList(view);
            return;
        }
        List<Long> permOrgId = AdminOrgMagicHelper.getPermOrgs(view, date);
        List<OrgCubeTreeNode> chartTreeNodeList = onlyChangeOrg ? AdminOrgMagicHelper.getTreeViewCollection(orgIdList, orgRootNode.getLongStructNumber(), date) : AdminOrgMagicHelper.getTreeViewCollection(permOrgId, orgRootNode.getLongStructNumber(), date);
        List<Long> permOrgHisId = AdminOrgMagicHelper.getHisIdList(permOrgId, date).stream().map(org -> org.getLong("id")).collect(Collectors.toList());
        String rootNodeId = orgRootNode.getId();
        chartTreeNodeList = AdminOrgMagicHelper.filter(changeIdSet, chartTreeNodeList, permOrgHisId);
        AdminOrgMagicHelper.addEntryNode(entryNodeList, mergeSplitParentOrgIdMap, chartTreeNodeList, latestHisIdMap);
        orgRootNode = AdminOrgMagicHelper.getOrgCubeTreeNode(orgRootNode, chartTreeNodeList, permOrgHisId, rootNodeId);
        if (onlyChangeOrg && !CollectionUtils.isEmpty((Collection)parentNodeList)) {
            AdminOrgMagicHelper.removeOldParentNode(chartTreeNodeList);
        }
        AdminOrgMagicHelper.addChildNodes(orgRootNode, chartTreeNodeList);
        chartTreeNodeList.add(orgRootNode);
        AdminOrgMagicHelper.setOrgInfo(chartTreeNodeList, date);
        IPageCache pageCache = view.getPageCache();
        pageCache.put(ROOT_NODE_ID, rootNodeId);
        try {
            pageCache.put(ROOT_NODE, JSONUtils.toString((Object)orgRootNode));
            pageCache.put(CHART_TREE_NODE_LIST, JSONUtils.toString(chartTreeNodeList));
        }
        catch (IOException e) {
            logger.error("JSONUtils.toString(chartTreeNodeList) error");
        }
        Map<String, String> collect = chartTreeNodeList.stream().collect(Collectors.toMap(OrgCubeTreeNode::getId, OrgCubeTreeNode::getParentid, (v1, v2) -> v1));
        int showLevel = changeIdSet.stream().map(id -> AdminOrgMagicHelper.countLevel(latestHisIdMap.getOrDefault(id.toString(), id.toString()), collect, rootNodeId, 1)).max(Comparator.comparing(item -> item)).orElse(1);
        pageCache.put(SHOW_LEVEL, showLevel + "");
        AdminOrgMagicHelper.setChangeTypeList(Collections.singletonList(orgRootNode));
        AdminOrgMagicHelper.setDataForCustomControl(orgRootNode, view, onlyChangeOrg, showLevel, eventName, eventStatus);
    }

    public static ChangeTypeVo getOrgChangeTypeVo() {
        DynamicObject[] dynamicObjects = ChangeTypeRepository.getInstance().queryOriginalArrayAllByEnabled("number, name");
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("name"), (val, val2) -> val, ChangeTypeVo::new));
    }

    private static boolean checkLatestVersion(IFormView view, List<OrgCubeTreeNode> entryNodeList, Map<String, String> latestHisIdMap) {
        HRBaseServiceHelper billHelper;
        DynamicObject billDy;
        long billid = view.getModel().getDataEntity().getLong("id");
        if (billid != 0L && (billDy = (billHelper = new HRBaseServiceHelper("homs_orgbatchchgbill")).queryOne("id,billstatus", (Object)billid)) != null && HRStringUtils.equals((String)billDy.getString("billstatus"), (String)"C")) {
            return false;
        }
        List<String> latestVersionErrorList = entryNodeList.stream().filter(node -> latestHisIdMap.containsKey(node.getId())).map(node -> {
            if (HRStringUtils.equals((String)ChangeTypeEnum.PARENT.getNumber(), (String)node.getChangeType())) {
                return ResManager.loadKDString((String)"\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u5f53\u524d\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u57fa\u4e8e\u6700\u65b0\u7684\u4fe1\u606f\u8fdb\u884c\u8c03\u6574\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_10", (String)"odc-homs-business", (Object[])new Object[]{node.getText()});
            }
            if (HRStringUtils.equals((String)ChangeTypeEnum.INFO.getNumber(), (String)node.getChangeType())) {
                return ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u4fe1\u606f\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u5f53\u524d\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u57fa\u4e8e\u6700\u65b0\u7684\u4fe1\u606f\u8fdb\u884c\u8c03\u6574\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_11", (String)"odc-homs-business", (Object[])new Object[]{node.getText()});
            }
            if (HRStringUtils.equals((String)ChangeTypeEnum.MERGE.getNumber(), (String)node.getChangeType())) {
                return ResManager.loadKDString((String)"\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u5f53\u524d\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u57fa\u4e8e\u6700\u65b0\u7684\u4fe1\u606f\u8fdb\u884c\u8c03\u6574\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_12", (String)"odc-homs-business", (Object[])new Object[]{node.getText()});
            }
            if (HRStringUtils.equals((String)ChangeTypeEnum.SPLIT.getNumber(), (String)node.getChangeType())) {
                return ResManager.loadKDString((String)"\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u5f53\u524d\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u57fa\u4e8e\u6700\u65b0\u7684\u4fe1\u606f\u8fdb\u884c\u8c03\u6574\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_16", (String)"odc-homs-business", (Object[])new Object[]{node.getText()});
            }
            return null;
        }).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(latestVersionErrorList)) {
            latestVersionErrorList.forEach(arg_0 -> ((IFormView)view).showTipNotification(arg_0));
            AdminOrgMagicHelper.returnToList(view);
            return true;
        }
        return false;
    }

    private static void addEntryNode(List<OrgCubeTreeNode> entryNodeList, Map<Long, Long> mergeSplitParentOrgIdMap, List<OrgCubeTreeNode> chartTreeNodeList, Map<String, String> latestHisIdMap) {
        entryNodeList.forEach(node -> {
            node.setId(latestHisIdMap.getOrDefault(node.getId(), node.getId()));
            String parentId = mergeSplitParentOrgIdMap.getOrDefault(Long.valueOf(node.getParentid()), Long.valueOf(node.getParentid())).toString();
            node.setParentid(latestHisIdMap.getOrDefault(parentId, parentId));
            String changeType = node.getChangeType();
            if (HRStringUtils.equals((String)changeType, (String)ChangeTypeEnum.MERGE.getNumber()) || HRStringUtils.equals((String)changeType, (String)ChangeTypeEnum.SPLIT.getNumber())) {
                node.setChangeType(null);
            }
        });
        chartTreeNodeList.addAll(entryNodeList);
    }

    private static List<OrgCubeTreeNode> filter(List<Long> changeIdSet, List<OrgCubeTreeNode> chartTreeNodeList, List<Long> permOrgHisId) {
        List<Long> changeBoIdList = AdminOrgMagicHelper.getBoIdList(changeIdSet);
        chartTreeNodeList = chartTreeNodeList.stream().filter(item -> HRStringUtils.isNotEmpty((String)item.getId()) && !changeIdSet.contains(Long.parseLong(item.getId()))).filter(item -> !changeBoIdList.contains(item.getBoId())).collect(Collectors.toList());
        chartTreeNodeList.forEach(item -> AdminOrgMagicHelper.getOrgCubeTreeNode(permOrgHisId, item));
        return chartTreeNodeList;
    }

    private static Date getDate(DynamicObject dataEntity) {
        String billStatus = dataEntity.getString("billstatus");
        Date date = billStatus.equals("A") || billStatus.equals("G") ? new Date() : dataEntity.getDate("modifytime");
        try {
            String dateString = HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
            date = HRDateTimeUtils.parseDate((String)dateString, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            logger.error(MessageFormat.format("date:{0}", date));
            date = new Date();
        }
        return date;
    }

    private static List<OrgCubeTreeNode> buildEntryNode(DynamicObject dataEntity) {
        List<String> entryKeys = EntryEntityEnum.getEntryKeysWithExt();
        ArrayList<OrgCubeTreeNode> entryNodeList = new ArrayList<OrgCubeTreeNode>();
        Map<String, OrgCubeTreeNode> orgNodeMap = new HashMap<String, OrgCubeTreeNode>();
        for (String entryName : entryKeys) {
            DynamicObjectCollection entities = dataEntity.getDynamicObjectCollection(entryName);
            String prefix = entryName.split("_")[1];
            if (HRStringUtils.equals((String)prefix, (String)"merge") || HRStringUtils.equals((String)prefix, (String)"split")) {
                if (!CollectionUtils.isEmpty(entryNodeList) && orgNodeMap.size() == 0) {
                    orgNodeMap = entryNodeList.stream().collect(Collectors.toMap(OrgCubeTreeNode::getId, node -> node));
                }
                AdminOrgMagicHelper.buildMergeSplitNode(entryNodeList, orgNodeMap, entities, prefix);
                continue;
            }
            entryNodeList.addAll(entities.stream().map(item -> AdminOrgMagicHelper.wrapEntryToTreeNode(item, prefix)).collect(Collectors.toList()));
        }
        return entryNodeList;
    }

    private static void buildMergeSplitNode(List<OrgCubeTreeNode> entryNodeList, Map<String, OrgCubeTreeNode> orgNodeMap, DynamicObjectCollection entities, String prefix) {
        boolean isMerge = HRStringUtils.equals((String)"merge", (String)prefix);
        String mulOrgFiledName = isMerge ? "to_merge_org" : "split_target_org";
        String singleOrgFiledName = isMerge ? "merge_target_org" : "to_split_org";
        for (DynamicObject entry : entities) {
            String changeType = ChangeTypeEnum.getNumberById((Long)entry.getLong(prefix + "_changescene.orgchangetype.id"));
            for (DynamicObject toMergeOrg : entry.getDynamicObjectCollection(mulOrgFiledName)) {
                DynamicObject org = toMergeOrg.getDynamicObject("fbasedataid");
                AdminOrgMagicHelper.buildMergeSplitNode(entryNodeList, orgNodeMap, changeType, org);
            }
            DynamicObject singleOrg = entry.getDynamicObject(singleOrgFiledName);
            AdminOrgMagicHelper.buildMergeSplitNode(entryNodeList, orgNodeMap, changeType, singleOrg);
        }
    }

    private static void buildMergeSplitNode(List<OrgCubeTreeNode> entryNodeList, Map<String, OrgCubeTreeNode> orgNodeMap, String changeType, DynamicObject org) {
        OrgCubeTreeNode node;
        if (org == null) {
            return;
        }
        String orgId = org.getString("id");
        if (orgNodeMap.containsKey(orgId)) {
            node = orgNodeMap.get(orgId);
        } else {
            node = new OrgCubeTreeNode(orgId, org.getString("name"), org.getString(PARENT_ORG_ID), changeType, "1");
            entryNodeList.add(node);
            orgNodeMap.put(orgId, node);
        }
        if (HRStringUtils.equals((String)ChangeTypeEnum.MERGE.getNumber(), (String)changeType)) {
            node.setMergeOrSplit("1");
        } else {
            node.setMergeOrSplit("2");
        }
    }

    private static void removeOldParentNode(List<OrgCubeTreeNode> chartTreeNodeList) {
        Map<String, List<OrgCubeTreeNode>> parentNodeMap;
        boolean flag;
        if (CollectionUtils.isEmpty(chartTreeNodeList)) {
            return;
        }
        int count = 0;
        while ((flag = chartTreeNodeList.removeIf(arg_0 -> AdminOrgMagicHelper.lambda$removeOldParentNode$30(parentNodeMap = chartTreeNodeList.stream().collect(Collectors.groupingBy(OrgCubeTreeNode::getParentid)), arg_0))) && ++count <= 15) {
        }
    }

    private static OrgCubeTreeNode getOrgCubeTreeNode(OrgCubeTreeNode orgRootNode, List<OrgCubeTreeNode> chartTreeNodeList, List<Long> permOrgHisId, String rootNodeId) {
        Optional<OrgCubeTreeNode> treeNodeOptional = chartTreeNodeList.stream().filter(node -> HRStringUtils.equals((String)node.getId(), (String)rootNodeId)).findFirst();
        if (treeNodeOptional.isPresent()) {
            orgRootNode = treeNodeOptional.get();
            chartTreeNodeList.removeIf(node -> HRStringUtils.equals((String)node.getId(), (String)rootNodeId));
        } else {
            AdminOrgMagicHelper.getOrgCubeTreeNode(permOrgHisId, orgRootNode);
        }
        return orgRootNode;
    }

    private static List<Long> getParentOrgIdList(Map<String, List<OrgCubeTreeNode>> entryNodeMap) {
        List addAdminOrgNodeList = entryNodeMap.getOrDefault(ChangeTypeEnum.ADD.getNumber(), new ArrayList());
        List addAdminOrgIdList = addAdminOrgNodeList.stream().map(node -> Long.valueOf(node.getId())).collect(Collectors.toList());
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        entryNodeMap.forEach((changeType, list) -> {
            if (!HRStringUtils.equals((String)ChangeTypeEnum.MERGE.getNumber(), (String)changeType) && !HRStringUtils.equals((String)ChangeTypeEnum.SPLIT.getNumber(), (String)changeType)) {
                orgIdList.addAll(list.stream().map(node -> {
                    if (HRStringUtils.equals((String)"0", (String)node.getParentid())) {
                        return Long.valueOf(node.getId());
                    }
                    return Long.valueOf(node.getParentid());
                }).filter(item -> !addAdminOrgIdList.contains(item)).collect(Collectors.toList()));
            }
        });
        return orgIdList;
    }

    private static Map<String, String> getLatestHisIdMap(List<Long> changeIdSet, List<Long> parentOrgIdList, Date date) {
        ArrayList<Long> changeAndParentOrgIdList = new ArrayList<Long>(changeIdSet.size() + parentOrgIdList.size());
        changeAndParentOrgIdList.addAll(changeIdSet);
        changeAndParentOrgIdList.addAll(parentOrgIdList);
        DynamicObjectCollection boIdObj = AdminOrgMagicHelper.getBoIdObj(changeAndParentOrgIdList);
        Map<Long, Long> boIdMap = boIdObj.stream().collect(Collectors.toMap(fid -> fid.getLong("id"), boId -> boId.getLong("boid"), (v1, v2) -> v2));
        DynamicObjectCollection hisIdList = AdminOrgMagicHelper.getHisIdList(new ArrayList<Long>(boIdMap.values()), date);
        Map<Long, Long> hisIdMap = hisIdList.stream().collect(Collectors.toMap(boId -> boId.getLong("boid"), fid -> fid.getLong("id"), (v1, v2) -> v2));
        HashMap<String, String> latestFidMap = new HashMap<String, String>(boIdMap.size());
        boIdMap.forEach((k, v) -> {
            Long value;
            if (hisIdMap.containsKey(v) && !k.equals(value = (Long)hisIdMap.get(v))) {
                latestFidMap.put(String.valueOf(k), String.valueOf(value));
            }
        });
        return latestFidMap;
    }

    public static DynamicObjectCollection getHisIdList(List<Long> orgIdList, Date date) {
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter idFilter = new QFilter("boid", "in", orgIdList).and(AdminOrgMagicHelper.getHisVersionFilter(date));
        return adminOrgHelper.queryOriginalCollection("id,boid,name,parentorg.id", idFilter.toArray());
    }

    private static List<Long> getBoIdList(List<Long> orgIdList) {
        if (CollectionUtils.isEmpty(orgIdList)) {
            return new ArrayList<Long>();
        }
        DynamicObjectCollection org = AdminOrgMagicHelper.getBoIdObj(orgIdList);
        return org.stream().map(item -> item.getLong("boid")).collect(Collectors.toList());
    }

    private static DynamicObjectCollection getBoIdObj(List<Long> orgIdList) {
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter idFilter = new QFilter("id", "in", orgIdList);
        return adminOrgHelper.queryOriginalCollection("id,boid,name,parentorg", idFilter.toArray());
    }

    private static int countLevel(String id, Map<String, String> collect, String rootId, int level) {
        if (HRStringUtils.equals((String)id, (String)rootId)) {
            return level;
        }
        String parentId = collect.get(id);
        if (parentId == null || HRStringUtils.equals((String)parentId, (String)"0")) {
            return 1;
        }
        ++level;
        if (HRStringUtils.equals((String)parentId, (String)rootId)) {
            return level;
        }
        if (level >= 15) {
            return level;
        }
        level = AdminOrgMagicHelper.countLevel(parentId, collect, rootId, level);
        return level;
    }

    private static OrgCubeTreeNode getRootNode(long rootOrgId, List<Long> orgIdList, Set<String> parentChangeOrgStruct, Date date) {
        if (rootOrgId == 0L) {
            return AdminOrgMagicHelper.getRootNodeDynamicObj(orgIdList, parentChangeOrgStruct, date);
        }
        List<Long> orgList = Collections.singletonList(rootOrgId);
        DynamicObjectCollection org = AdminOrgMagicHelper.getBoIdObj(orgList);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        QFilter orgIdFilter = new QFilter("adminorg.id", "=", (Object)((DynamicObject)org.get(0)).getLong("boid"));
        QFilter hisVersionFilter = AdminOrgMagicHelper.getHisVersionFilter(date);
        String selectFields = "structlongnumber";
        DynamicObject rootNodeDynamicObj = serviceHelper.queryOne(selectFields, new QFilter[]{orgIdFilter, hisVersionFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
        if (rootNodeDynamicObj == null) {
            rootNodeDynamicObj = serviceHelper.queryOne(selectFields, new QFilter[]{orgIdFilter});
        }
        Long parentId = Long.parseLong(((DynamicObject)org.get(0)).getString("parentorg"));
        String parentFid = AdminOrgBatchChgHelper.getHisId(parentId).toString();
        return new OrgCubeTreeNode(String.valueOf(rootOrgId), ((DynamicObject)org.get(0)).getString("name"), parentFid, rootNodeDynamicObj.getString("structlongnumber"));
    }

    private static OrgCubeTreeNode getRootNodeDynamicObj(List<Long> permOrgIds, Set<String> parentChangeOrgStruct, Date date) {
        String commonParentStructLongNumber;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        QFilter orgTeamIdFilter = new QFilter("adminorg.id", "in", permOrgIds);
        QFilter hisVersionFilter = AdminOrgMagicHelper.getHisVersionFilter(date);
        hisVersionFilter.and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        String selectFields = "id, adminorg.id,adminorg.name, structlongnumber, parentorg";
        Object[] dynamicObjects = serviceHelper.queryOriginalArray(selectFields, new QFilter[]{orgTeamIdFilter, hisVersionFilter});
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return null;
        }
        if (1 == dynamicObjects.length) {
            commonParentStructLongNumber = dynamicObjects[0].getString("structlongnumber");
        } else {
            List longNumberList = Arrays.stream(dynamicObjects).map(obj -> obj.getString("structlongnumber")).filter(obj -> parentChangeOrgStruct.stream().noneMatch(obj::startsWith)).collect(Collectors.toList());
            logger.info(MessageFormat.format("longNumberList:{0}", longNumberList));
            commonParentStructLongNumber = TreeAssistUtils.getCommonPrefixStructLongNumber(longNumberList);
        }
        logger.info(MessageFormat.format("commonParentStructLongNumber:{0}", commonParentStructLongNumber));
        QFilter[] filters = new QFilter[]{new QFilter("structlongnumber", "=", (Object)commonParentStructLongNumber), hisVersionFilter};
        DynamicObject dynamicObject = serviceHelper.queryOne(selectFields, filters);
        long boId = dynamicObject.getLong("adminorg.id");
        DynamicObjectCollection hisIdList = AdminOrgMagicHelper.getHisIdList(Collections.singletonList(boId), date);
        if (CollectionUtils.isEmpty((Collection)hisIdList)) {
            return new OrgCubeTreeNode(dynamicObject.getString("adminorg.id"), dynamicObject.getString("adminorg.name"), dynamicObject.getString(PARENT_ORG_ID), commonParentStructLongNumber);
        }
        DynamicObject org = (DynamicObject)hisIdList.get(0);
        Long parentId = Long.parseLong(org.getString(PARENT_ORG_ID));
        String parentFid = AdminOrgBatchChgHelper.getHisId(parentId).toString();
        return new OrgCubeTreeNode(org.getString("id"), org.getString("name"), parentFid, commonParentStructLongNumber);
    }

    private static Set<String> getParentChangeOrgStruct(List<Long> parentChangeBoIdList, Date date) {
        Set<String> parentChangeOrgStruct;
        if (!CollectionUtils.isEmpty(parentChangeBoIdList)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
            String selectFields = "id, adminorg.id,adminorg.name, structlongnumber, parentorg";
            QFilter hisVersionFilter = AdminOrgMagicHelper.getHisVersionFilter(date);
            QFilter parentChangeOrgIdFilter = new QFilter("adminorg.id", "in", parentChangeBoIdList);
            DynamicObjectCollection parentChangeOrgCollection = serviceHelper.queryOriginalCollection(selectFields, new QFilter[]{parentChangeOrgIdFilter, hisVersionFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
            parentChangeOrgStruct = parentChangeOrgCollection.stream().map(item -> item.getString("structlongnumber")).collect(Collectors.toSet());
        } else {
            parentChangeOrgStruct = new HashSet<String>();
        }
        return parentChangeOrgStruct;
    }

    public static void setOrgInfo(List<OrgCubeTreeNode> chartTreeNodeList, Date date) {
        String today;
        String modifyDate;
        int code;
        List<Long> nodeIdList = chartTreeNodeList.stream().map(node -> Long.parseLong(node.getId())).collect(Collectors.toList());
        DynamicObjectCollection nodeOrg = AdminOrgMagicHelper.getBoIdObj(nodeIdList);
        List nodeBoIdList = nodeOrg.stream().map(item -> item.getLong("boid")).collect(Collectors.toList());
        Map<Long, Long> nodeBoIdMap = nodeOrg.stream().collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getLong("boid")));
        Map orgPositionMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IPositionService", (String)"queryPositionHisByOrgIds", (Object[])new Object[]{nodeBoIdList, date});
        Map<Object, Object> positionSumMap = new HashMap(nodeBoIdList.size());
        if (!CollectionUtils.isEmpty((Map)orgPositionMap) && (code = ((Integer)orgPositionMap.get("code")).intValue()) == 200) {
            List positionInfoList = (List)orgPositionMap.get("data");
            positionSumMap = positionInfoList.stream().collect(Collectors.groupingBy(position -> Long.parseLong(position.get("adminorg").toString()), Collectors.counting()));
        }
        date = HRStringUtils.equals((String)(modifyDate = HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd")), (String)(today = HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd"))) ? null : date;
        List personCountAndChargeInfoMap = HRPIRPCServiceHelper.getPersonCountAndChargeInfo(nodeBoIdList, (Date)date);
        Map<Object, Object> managerInfoMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)personCountAndChargeInfoMap)) {
            managerInfoMap = personCountAndChargeInfoMap.stream().collect(Collectors.groupingBy(org -> (Long)org.get("adminorg")));
        }
        for (OrgCubeTreeNode node2 : chartTreeNodeList) {
            Long id = nodeBoIdMap.get(Long.parseLong(node2.getId()));
            node2.setPositionSum(positionSumMap.getOrDefault(id, 0L).intValue());
            List managerInfoList = (List)managerInfoMap.get(id);
            if (CollectionUtils.isEmpty((Collection)managerInfoList)) continue;
            List primaryManagerInfoList = managerInfoList.stream().filter(org -> org.get("isprimary") != null && Boolean.parseBoolean(org.get("isprimary").toString())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(primaryManagerInfoList)) {
                primaryManagerInfoList.sort((map1, map2) -> {
                    Object number1 = map1.get("number");
                    Object number2 = map2.get("number");
                    if (number1 == null) {
                        if (number2 == null) {
                            return 0;
                        }
                        return 1;
                    }
                    if (number2 == null) {
                        return -1;
                    }
                    return ((String)number1).compareTo((String)number2);
                });
                Map manager = (Map)primaryManagerInfoList.get(0);
                String name = manager.getOrDefault("name", "");
                String img = manager.getOrDefault("headsculpture", "");
                node2.setManagerName(name);
                String imageFullUrl = HRImageUrlUtil.getImageFullUrl((String)img);
                node2.setManagerImg(imageFullUrl);
            }
            int count = ((Map)managerInfoList.get(0)).get("count") == null ? 0 : Integer.parseInt(((Map)managerInfoList.get(0)).get("count").toString());
            node2.setPersonSum(count);
        }
    }

    private static void getOrgCubeTreeNode(List<Long> permOrgHisId, OrgCubeTreeNode orgRootNode) {
        String hasPermission = "0";
        if (permOrgHisId.contains(Long.parseLong(orgRootNode.getId()))) {
            hasPermission = "1";
        }
        orgRootNode.setHasPermission(hasPermission);
        orgRootNode.setBoId(null);
        orgRootNode.setLongStructNumber(null);
    }

    private static List<Long> getPermOrgs(IFormView view, Date date) {
        List orgIds;
        AuthorizedOrgResult permResult = AdminOrgBatchChgHelper.getOrgAuth(view);
        if (!permResult.isHasAllOrgPerm()) {
            orgIds = permResult.getHasPermOrgs();
        } else {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter hisVersionFilter = AdminOrgMagicHelper.getHisVersionFilter(date);
            DynamicObject[] allOrg = helper.queryOriginalArray("boid", new QFilter[]{enableFilter, hisVersionFilter});
            orgIds = Arrays.stream(allOrg).map(org -> org.getLong("boid")).collect(Collectors.toList());
        }
        return orgIds;
    }

    private static QFilter getHisVersionFilter(Date effDate) {
        return new QFilter("iscurrentversion", "=", (Object)"0").and(new QFilter("bsed", "<=", (Object)effDate).and(new QFilter("bsled", ">=", (Object)effDate))).and(new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus())));
    }

    private static OrgCubeTreeNode wrapEntryToTreeNode(DynamicObject dynamicObject, String prefix) {
        String name = HRStringUtils.equals((String)prefix, (String)"disable") ? dynamicObject.getString("disable_adminorg.name") : dynamicObject.getString(prefix + "_" + "name");
        String parentId = dynamicObject.getString(prefix + "_" + PARENT_ORG_ID);
        Object entryData = dynamicObject.get(prefix + "_adminorg");
        String id = String.valueOf(entryData);
        String oldName = "";
        if (entryData instanceof DynamicObject) {
            id = ((DynamicObject)entryData).getString("id");
            oldName = ((DynamicObject)entryData).getString("name");
        }
        if (HRStringUtils.equals((String)id, (String)"0")) {
            id = "-1";
        }
        OrgCubeTreeNode node = new OrgCubeTreeNode(id, name, parentId, ChangeTypeEnum.getNumberById((Long)dynamicObject.getLong(prefix + "_changetype.id")), "1");
        node.setOldName(oldName);
        return node;
    }

    private static List<OrgCubeTreeNode> getTreeViewCollection(List<Long> orgIdList, String parentStructLongNumber, Date date) {
        String selectStructFields = "id,adminorg, structlongnumber, parentorg";
        IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct");
        QFilter orgTeamIdFilter = new QFilter("adminorg.id", "in", orgIdList);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        QFilter hisVersionFilter = AdminOrgMagicHelper.getHisVersionFilter(date);
        QFilter initFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter childrenFilter = new QFilter("structlongnumber", "like", (Object)(parentStructLongNumber + "%"));
        DynamicObjectCollection belongAdminOrgStructCollection = structInstance.queryColl(selectStructFields, new QFilter[]{orgTeamIdFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get(), statusFilter, hisVersionFilter, childrenFilter, initFilter}, null);
        Set<String> childStructLongNumbers = AdminOrgMagicHelper.buildChildStructLongNumbers(belongAdminOrgStructCollection, parentStructLongNumber);
        childStructLongNumbers.remove(parentStructLongNumber);
        Set childStructNumbers = childStructLongNumbers.stream().filter(HRStringUtils::isNotEmpty).map(number -> {
            String[] str = number.split("!");
            return str[str.length - 1];
        }).collect(Collectors.toSet());
        QFilter parentStructNumberFilter = new QFilter("structnumber", "in", childStructNumbers);
        String selectFields = "id,boid,name, parentorg.id,parentorg.boid";
        DynamicObjectCollection collection = HRBaseDaoFactory.getInstance((String)"haos_adminorgdetail").queryColl(selectFields, new QFilter[]{parentStructNumberFilter, hisVersionFilter, initFilter}, "index asc,number asc");
        List<Long> parentBoId = collection.stream().map(item -> item.getLong("parentorg.boid")).distinct().collect(Collectors.toList());
        DynamicObjectCollection parentBoObj = AdminOrgMagicHelper.getHisIdList(parentBoId, date);
        Map<String, String> parentBoMap = parentBoObj.stream().collect(Collectors.toMap(item -> item.getString("boid"), item -> item.getString("id"), (v1, v2) -> v1));
        return collection.stream().map(org -> {
            OrgCubeTreeNode orgCubeTreeNode = new OrgCubeTreeNode(org.getString("id"), org.getString("name"), parentBoMap.getOrDefault(org.getString(PARENT_ORG_ID), org.getString(PARENT_ORG_ID)), null);
            orgCubeTreeNode.setBoId(Long.valueOf(org.getLong("boid")));
            return orgCubeTreeNode;
        }).collect(Collectors.toList());
    }

    private static Set<String> buildChildStructLongNumbers(DynamicObjectCollection belongAdminOrgStructCollection, String parentStructLongNumber) {
        HashSet<String> childLongNumbers = new HashSet<String>();
        belongAdminOrgStructCollection.forEach(belongAdminOrgStruct -> {
            int tempIndex;
            String structLongNumber = belongAdminOrgStruct.getString("structlongnumber");
            if (structLongNumber.length() > parentStructLongNumber.length() && structLongNumber.startsWith(parentStructLongNumber)) {
                childLongNumbers.add(structLongNumber);
            }
            while (-1 != (tempIndex = structLongNumber.lastIndexOf(33)) && !structLongNumber.equals(parentStructLongNumber) && structLongNumber.length() >= parentStructLongNumber.length() && structLongNumber.startsWith(parentStructLongNumber)) {
                structLongNumber = structLongNumber.substring(0, tempIndex);
                childLongNumbers.add(structLongNumber);
            }
        });
        return childLongNumbers;
    }

    private static void setDataForCustomControl(Object treeNode, IFormView view, boolean onlyChangeOrg, int showLevel, String eventName, String eventStatus) {
        CustomControl customcontrol = (CustomControl)view.getControl("customcontrolap");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("onlyChangeOrg", onlyChangeOrg ? 1 : 0);
        data.put("data", treeNode);
        data.put(SHOW_LEVEL, showLevel);
        data.put("code", "200");
        data.put("errorMessage", "");
        data.put("eventName", eventName);
        data.put("eventStatus", eventStatus);
        data.put("changeTypeVo", AdminOrgMagicHelper.getOrgChangeTypeVo());
        String billStatus = view.getModel().getDataEntity().getString("billstatus");
        data.put(IS_EDIT, AdminOrgBatchViewStrategyContext.isEdit(billStatus, view));
        data.put("time", System.currentTimeMillis());
        customcontrol.setData(data);
    }

    public static void setChangeTypeList(List<OrgCubeTreeNode> orgCubeTreeNodeList) {
        Consumer<OrgCubeTreeNode> changeTypeListSetter = AdminOrgMagicHelper.changeTypeListSetter();
        ArrayDeque<OrgCubeTreeNode> queue = new ArrayDeque<OrgCubeTreeNode>(orgCubeTreeNodeList);
        while (!queue.isEmpty()) {
            OrgCubeTreeNode poll = (OrgCubeTreeNode)queue.poll();
            changeTypeListSetter.accept(poll);
            Optional.ofNullable(poll.getChildren()).ifPresent(queue::addAll);
        }
    }

    private static Consumer<OrgCubeTreeNode> changeTypeListSetter() {
        DynamicObject[] dynamicObjects = ChangeTypeRepository.getInstance().loadByIds(Arrays.asList(OrgBatchChgBillConstants.CHANGE_TYPE_MERGE, OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT));
        Optional<String> mergeTypeOpt = Arrays.stream(dynamicObjects).filter(dy -> OrgBatchChgBillConstants.CHANGE_TYPE_MERGE.equals(dy.getLong("id"))).map(dy -> dy.getString("number")).findFirst();
        Optional<String> splitTypeOpt = Arrays.stream(dynamicObjects).filter(dy -> OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT.equals(dy.getLong("id"))).map(dy -> dy.getString("number")).findFirst();
        String splitNumber = splitTypeOpt.orElse("");
        String mergeNumber = mergeTypeOpt.orElse("");
        return node -> {
            ArrayList<String> changeTypeList = new ArrayList<String>();
            String mergeOrSplit = node.getMergeOrSplit();
            if (mergeOrSplit != null) {
                switch (mergeOrSplit) {
                    case "1": {
                        changeTypeList.add(mergeNumber);
                        break;
                    }
                    case "2": {
                        changeTypeList.add(splitNumber);
                    }
                }
            }
            Optional.ofNullable(node.getChangeType()).ifPresent(changeTypeList::add);
            node.setChangeTypeList(changeTypeList);
        };
    }

    public static void addChildNodes(OrgCubeTreeNode rootNode, List<OrgCubeTreeNode> childNodeList) {
        ArrayList<OrgCubeTreeNode> list = new ArrayList<OrgCubeTreeNode>();
        HashMap<String, OrgCubeTreeNode> dctItems = new HashMap<String, OrgCubeTreeNode>(childNodeList.size());
        for (OrgCubeTreeNode node : childNodeList) {
            dctItems.put(node.getId(), node);
        }
        for (OrgCubeTreeNode node : childNodeList) {
            OrgCubeTreeNode parentNode = (OrgCubeTreeNode)dctItems.get(node.getParentid());
            if (parentNode != null) {
                if (parentNode.getChildren() == null) {
                    parentNode.addChildren(new ArrayList());
                }
                parentNode.getChildren().add(node);
                continue;
            }
            String parentId = node.getParentid();
            if (!rootNode.getId().equals(parentId)) continue;
            list.add(node);
        }
        rootNode.addChildren(list);
    }

    private static /* synthetic */ boolean lambda$removeOldParentNode$30(Map parentNodeMap, OrgCubeTreeNode node) {
        return HRStringUtils.isEmpty((String)node.getChangeType()) && !parentNodeMap.containsKey(node.getId()) && HRStringUtils.isEmpty((String)node.getMergeOrSplit());
    }
}

