/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.orgbatch.OrgLevel4ModelCheckServiceImpl;
import kd.hr.homs.business.service.validcommon.CycleOrgBean;
import kd.hr.homs.business.service.validcommon.OrgBatchCheck4LayerModelBO;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.business.service.validcommon.StructCycleOrgBean;
import kd.hr.homs.common.constants.batchchg.ChangeTypeEnum;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.OrgCoopInfo;

public class OrgBatchBillCheckHelper {
    private static final Log LOGGER = LogFactory.getLog(OrgBatchBillCheckHelper.class);
    public static Date lastDate;
    public static Date lastDate3000;

    public static Map<String, String> assembleMultiEntryName() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        map.put("entryentity_add", ResManager.loadResFormat((String)"\u65b0\u589e\u7ec4\u7ec7", (String)"OrgBatchBillCheckHelper_3", (String)"odc-homs-business", (Object[])new Object[0]));
        map.put("entryentity_parent", ResManager.loadResFormat((String)"\u8c03\u6574\u4e0a\u7ea7", (String)"OrgBatchBillCheckHelper_4", (String)"odc-homs-business", (Object[])new Object[0]));
        map.put("entryentity_info", ResManager.loadResFormat((String)"\u53d8\u66f4\u4fe1\u606f", (String)"OrgBatchBillCheckHelper_5", (String)"odc-homs-business", (Object[])new Object[0]));
        map.put("entryentity_disable", ResManager.loadResFormat((String)"\u505c\u7528\u7ec4\u7ec7", (String)"OrgBatchBillCheckHelper_6", (String)"odc-homs-business", (Object[])new Object[0]));
        map.put("entryentity_merge", ResManager.loadResFormat((String)"\u5408\u5e76\u7ec4\u7ec7", (String)"OrgBatchBillCheckHelper_7", (String)"odc-homs-business", (Object[])new Object[0]));
        map.put("entryentity_split", ResManager.loadResFormat((String)"\u62c6\u5206\u7ec4\u7ec7", (String)"OrgBatchBillCheckHelper_8", (String)"odc-homs-business", (Object[])new Object[0]));
        return map;
    }

    public static List<OrgBatchCheckDto> queryBillOrgList(Long changeTypeId) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        StringBuilder sb = new StringBuilder();
        sb.append("select b.fid,b.fbillno,a.fentryid,b.feffdt,a.festablishmentdate,a.fnumber,a.fmergesplitstatus,a.fadminorgboid,a.fname,a.fadminorgid,a.fmodifytime,").append("c.fboid,c.fname name,c.fnumber number,c.fadminorgtypeid orgtype,d.ftobedisableflag flag,c.fparentid parent,g.fboid parentBoId,").append("a.fparentid,a.forgtypeid,a.ftobedisableflag, a.fchangesceneid,a.fchangetypeid,").append("a.fbeforemergeorgid,a.faftermergeorgid,a.fbeforesplitorgid,a.faftersplitorgid ").append("from t_homs_orgchgbillentry a ").append("left join t_homs_orgchgbill b on b.fid = a.fid ").append("left join t_haos_adminorg c on a.fadminorgid = c.fid ").append("left join t_haos_adminorg g on g.fid = a.fparentid ").append("left join t_haos_adminorg_a d on d.fid = c.fid ").append("where b.fbillstatus in('B','D') ");
        Object[] obj = null;
        if (changeTypeId != null) {
            sb.append("and a.fchangetypeid=?");
            obj = new Long[]{changeTypeId};
        }
        HashMap<Long, OrgBatchCheckDto> map = new HashMap<Long, OrgBatchCheckDto>();
        Date modifyTime = null;
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryBillOrgList", (DBRoute)new DBRoute("haos"), (String)sb.toString(), (Object[])obj);){
            for (Row data : ds) {
                if (modifyTime == null) {
                    modifyTime = data.getDate("fmodifytime");
                }
                OrgBatchCheckDto checkDto = OrgBatchBillCheckHelper.getNewCheckDto(data);
                Long type = data.getLong("fchangetypeid");
                if (OrgBatchChgBillConstants.CHANGE_TYPE_MERGE.equals(type) || OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT.equals(type)) {
                    OrgBatchBillCheckHelper.setCheckDtoCommonFiled(map, checkDto, data);
                } else {
                    OrgBatchBillCheckHelper.createChangeCheckDto(map, data, checkDto);
                }
                result.add(checkDto);
            }
        }
        OrgBatchBillCheckHelper.queryBillStructEntryOrgList(result);
        return result;
    }

    private static void createChangeCheckDto(Map<Long, OrgBatchCheckDto> map, Row data, OrgBatchCheckDto checkDto) {
        checkDto.setTobeDisableFlag(data.getBoolean("ftobedisableflag"));
        checkDto.setNumber(data.getString("fnumber"));
        checkDto.setName(data.getString("fname"));
        checkDto.setParentOrgId(data.getLong("fparentid"));
        checkDto.setParentOrgBoId(data.getLong("parent"));
        checkDto.setAfterParentBoId(data.getLong("parentBoId"));
        checkDto.setOrgTypeId(data.getLong("forgtypeid"));
        map.put(checkDto.getOrgId(), checkDto);
        if (map.containsKey(checkDto.getOrgId())) {
            OrgBatchCheckDto existCheckDto = map.get(checkDto.getOrgId());
            existCheckDto.setTobeDisableFlag(checkDto.isTobeDisableFlag());
            existCheckDto.setNumber(checkDto.getNumber());
            existCheckDto.setName(checkDto.getName());
            existCheckDto.setParentOrgId(checkDto.getParentOrgId());
            existCheckDto.setParentOrgBoId(checkDto.getParentOrgBoId());
            existCheckDto.setOrgTypeId(checkDto.getOrgTypeId());
        }
    }

    private static OrgBatchCheckDto getNewCheckDto(Row data) {
        OrgBatchCheckDto checkDto = new OrgBatchCheckDto();
        checkDto.setBillId(data.getLong("fid"));
        checkDto.setBillNo(data.getString("fbillno"));
        checkDto.setEntryId(data.getLong("fentryid"));
        checkDto.setChangeTypeId(data.getLong("fchangetypeid"));
        checkDto.setChangeSceneId(data.getLong("fchangesceneid"));
        checkDto.setOrgId(data.getLong("fadminorgid"));
        checkDto.setOrgBoId(data.getLong("fboid"));
        checkDto.setAdminOrgBoid(data.getLong("fboid"));
        checkDto.setEstablishmentDate(data.getDate("festablishmentdate"));
        checkDto.setAfterParentBoId(data.getLong("parentBoId"));
        checkDto.setEffectDate(data.getDate("feffdt"));
        return checkDto;
    }

    private static void setCheckDtoCommonFiled(Map<Long, OrgBatchCheckDto> map, OrgBatchCheckDto checkDto, Row data) {
        if (map.containsKey(checkDto.getOrgId())) {
            OrgBatchCheckDto existCheckDto = map.get(checkDto.getOrgId());
            OrgBatchBillCheckHelper.setFiledFromExistCheckDto(checkDto, existCheckDto);
        } else {
            checkDto.setTobeDisableFlag(data.getBoolean("flag"));
            checkDto.setNumber(data.getString("number"));
            checkDto.setName(data.getString("name"));
            checkDto.setParentOrgBoId(data.getLong("parent"));
            checkDto.setAfterParentBoId(data.getLong("parentBoId"));
            checkDto.setParentOrgId(data.getLong("fparentid"));
            checkDto.setOrgTypeId(data.getLong("orgtype"));
            checkDto.setOrgBoId(data.getLong("fboid"));
            checkDto.setEstablishmentDate(data.getDate("festablishmentdate"));
            checkDto.setEffectDate(data.getDate("feffdt"));
        }
    }

    private static void setFiledFromExistCheckDto(OrgBatchCheckDto checkDto, OrgBatchCheckDto existCheckDto) {
        checkDto.setTobeDisableFlag(existCheckDto.isTobeDisableFlag());
        checkDto.setNumber(existCheckDto.getNumber());
        checkDto.setName(existCheckDto.getName());
        checkDto.setParentOrgId(existCheckDto.getParentOrgId());
        checkDto.setParentOrgBoId(existCheckDto.getParentOrgBoId());
        checkDto.setOrgTypeId(existCheckDto.getOrgTypeId());
        checkDto.setOrgId(existCheckDto.getOrgId());
        checkDto.setOrgBoId(existCheckDto.getOrgBoId());
        checkDto.setAdminOrgBoid(existCheckDto.getAdminOrgBoid());
    }

    public static List<OrgBatchCheckDto> queryBillOrgList() {
        return OrgBatchBillCheckHelper.queryBillOrgList(null);
    }

    public static DynamicObjectCollection queryCurrentOrgCollectionByBillId(Long billId) {
        HRBaseServiceHelper entryHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter entryFilter = new QFilter("billid", "=", (Object)billId);
        QFilter changeTypeFilter = new QFilter("changetype.id", "not in", Arrays.asList(ChangeTypeEnum.MERGE.getId(), ChangeTypeEnum.SPLIT.getId()));
        DynamicObject[] dyArr = entryHelper.query("id,adminorg.id,adminorgtype.id,parentorg,number,name,tobedisableflag,changetype,mergesplitstatus,struct_project_entry.struct_project,struct_project_entry.struct_parent_org", new QFilter[]{entryFilter, changeTypeFilter});
        DynamicObjectCollection collection = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : dyArr) {
            collection.add((Object)dynamicObject);
        }
        Map statusMap = collection.stream().collect(Collectors.groupingBy(entry -> entry.getString("mergesplitstatus"), Collectors.toList()));
        Set toSaveOrgIdSet = ((List)statusMap.getOrDefault("0", new ArrayList())).stream().map(entry -> entry.getLong("adminorg.id")).collect(Collectors.toSet());
        Set toDeleteOrgIdSet = ((List)statusMap.getOrDefault("1", new ArrayList())).stream().map(entry -> entry.getLong("adminorg.id")).collect(Collectors.toSet());
        collection.removeIf(entry -> {
            long orgId = entry.getLong("adminorg.id");
            String status = entry.getString("mergesplitstatus");
            if (toSaveOrgIdSet.contains(orgId) && HRStringUtils.equals((String)"2", (String)status)) {
                return true;
            }
            return toDeleteOrgIdSet.contains(orgId);
        });
        return collection;
    }

    public static Set<String> queryBosOrgNumberSet(Set<Long> boIdSet, Set<String> numberSet) {
        DynamicObjectCollection numberDynamicObjects;
        HRBaseServiceHelper bosOrgHelper = new HRBaseServiceHelper("bos_org");
        QFilter qFilter = new QFilter("number", "in", numberSet);
        if (!CollectionUtils.isEmpty(boIdSet)) {
            qFilter.and("id", "not in", boIdSet);
        }
        if (CollectionUtils.isEmpty((Collection)(numberDynamicObjects = bosOrgHelper.queryOriginalCollection("id", new QFilter[]{qFilter})))) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        HashSet orgIds = Sets.newHashSetWithExpectedSize((int)numberDynamicObjects.size());
        numberDynamicObjects.forEach(dy -> orgIds.add(dy.getLong("id")));
        QFilter bosOrgFilter = new QFilter("isfreeze", "=", (Object)"0");
        bosOrgFilter.and("org.id", "in", (Object)orgIds);
        bosOrgHelper = new HRBaseServiceHelper("bos_org_structure");
        DynamicObjectCollection orgColl = bosOrgHelper.queryOriginalCollection("org.number", new QFilter[]{bosOrgFilter});
        return orgColl.stream().map(dy -> dy.getString("org.number")).collect(Collectors.toSet());
    }

    public static boolean isMultiLangeFieldPropChanged(ILocaleString newLocaleString, ILocaleString oldLocaleString) {
        AtomicBoolean isChanged = new AtomicBoolean(false);
        newLocaleString.forEach((code, newVal) -> {
            if (HRStringUtils.equals((String)code, (String)"GLang")) {
                return;
            }
            ILocaleString oldLocaleValue = Optional.ofNullable(oldLocaleString).orElseGet(LocaleString::new);
            if (!HRStringUtils.equals((String)newVal, (String)((String)oldLocaleValue.get(code)))) {
                isChanged.set(true);
            }
        });
        return isChanged.get();
    }

    public static boolean dynIsSame(DynamicObject one, DynamicObject another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return one.getLong("id") == another.getLong("id");
    }

    public static boolean isChangeOrgteamcooprel(Long currentOrgId, DynamicObject targetObject, Map<Long, DynamicObject> orgOldInfoMap) {
        DynamicObjectCollection cooEntityView = targetObject.getDynamicObjectCollection("cooprelentryentity");
        DynamicObject orgOldInfo = orgOldInfoMap.get(currentOrgId);
        DynamicObjectCollection oldOrgCoopInfo = orgOldInfo.getDynamicObjectCollection("cooprelentryentity");
        int oldOrgCoopInfoSize = oldOrgCoopInfo.size();
        int newOrgCoopInfoSize = cooEntityView.size();
        if (oldOrgCoopInfoSize == 0 && newOrgCoopInfoSize == 0) {
            return false;
        }
        if (oldOrgCoopInfoSize == newOrgCoopInfoSize) {
            List<OrgCoopInfo> orgNewCoopInfo = OrgBatchBillCheckHelper.constructOrgCoopInfo(currentOrgId, cooEntityView);
            List<OrgCoopInfo> orgOldCoopInfo = OrgBatchBillCheckHelper.constructOrgCoopInfo(currentOrgId, oldOrgCoopInfo);
            return !orgOldCoopInfo.containsAll(orgNewCoopInfo);
        }
        return true;
    }

    private static List<OrgCoopInfo> constructOrgCoopInfo(Long orgId, DynamicObjectCollection orgCoopInfo) {
        ArrayList list = Lists.newArrayListWithCapacity((int)orgCoopInfo.size());
        for (DynamicObject dynamicObject : orgCoopInfo) {
            long coopTypeId = Optional.ofNullable(dynamicObject.getDynamicObject("coopreltyp")).map(dy -> dy.getLong("id")).orElse(0L);
            long coopOrgId = Optional.ofNullable(dynamicObject.getDynamicObject("cooporgteam")).map(dy -> dy.getLong("boid")).orElse(0L);
            list.add(new OrgCoopInfo(orgId.longValue(), coopOrgId, coopTypeId));
        }
        return list;
    }

    public static Map<Long, Long> queryOrgTypeTypeStdIdMap() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgtype");
        QFilter idFilter = new QFilter("enable", "in", Arrays.asList("1", "0"));
        DynamicObject[] dynamicObjArr = serviceHelper.queryOriginalArray("id,adminorgtypestd", new QFilter[]{idFilter});
        return Arrays.stream(dynamicObjArr).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("adminorgtypestd")));
    }

    public static Map<Long, Long> queryOrgTypeTypeStdIdMap(Map<Long, Long> orgIdOrgtypeIdMap) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgtype");
        QFilter idFilter = new QFilter("id", "in", orgIdOrgtypeIdMap.values());
        DynamicObjectCollection orgTypeColl = serviceHelper.queryOriginalCollection("id,adminorgtypestd", new QFilter[]{idFilter});
        return orgTypeColl.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("adminorgtypestd")));
    }

    public static DynamicObject queryOrgTypeById(Long orgTypeId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgtype");
        QFilter idFilter = new QFilter("id", "=", (Object)orgTypeId);
        return serviceHelper.loadDynamicObject(idFilter);
    }

    public static Map<Long, String> queryBaseDataInfo(String entityName, String selectProperties) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        DynamicObject[] objects = serviceHelper.query(selectProperties, new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        return Arrays.stream(objects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name")));
    }

    public static Map<String, String> queryAdminOrgTypeNameMap(long orgId) {
        HRBaseServiceHelper orgtypeHelper = new HRBaseServiceHelper("haos_adminorgtype");
        QFilter qFilter = new QFilter("adminorgtypestd.id", "in", OrgBatchCheckConstants.ADMINORGTYPE_SYSPRESET_ID);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        if (orgId != 0L) {
            qFilter.and(BaseDataHelper.getBaseDataFilter((String)"haos_adminorgtype", (long)orgId));
        }
        DynamicObject[] orgTypeDys = orgtypeHelper.query("id,name,adminorgtypestd", new QFilter[]{qFilter});
        ArrayList aboveGroupList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList aboveCompanyList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList lowerCompanyList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList lowerDeptList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject dy : orgTypeDys) {
            Long typeStdId = dy.getLong("adminorgtypestd.id");
            String orgTypeName = dy.getString("name");
            if (OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(typeStdId)) {
                aboveGroupList.add(orgTypeName);
            }
            if (OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(typeStdId)) {
                aboveCompanyList.add(orgTypeName);
            }
            if (OrgBatchCheckConstants.LEVEL4_LOWER_COMPANY.contains(typeStdId)) {
                lowerCompanyList.add(orgTypeName);
            }
            if (!OrgBatchCheckConstants.LEVEL4_LOWER_DEPT.contains(typeStdId)) continue;
            lowerDeptList.add(orgTypeName);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        result.put("level4_above_group", OrgBatchBillCheckHelper.generateOrgTypeNameStr(aboveGroupList));
        result.put("level4_above_company", OrgBatchBillCheckHelper.generateOrgTypeNameStr(aboveCompanyList));
        result.put("level4_lower_company", OrgBatchBillCheckHelper.generateOrgTypeNameStr(lowerCompanyList));
        result.put("level4_lower_dept", OrgBatchBillCheckHelper.generateOrgTypeNameStr(lowerDeptList));
        return result;
    }

    public static List<String> queryGroupOrgTypeNameList(Long adminorgtypestd) {
        HRBaseServiceHelper orgtypeHelper = new HRBaseServiceHelper("haos_adminorgtype");
        QFilter qFilter = new QFilter("adminorgtypestd.id", "in", OrgBatchCheckConstants.ADMINORGTYPE_SYSPRESET_ID);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("adminorgtypestd", "=", (Object)adminorgtypestd));
        DynamicObject[] nameDynamicObject = orgtypeHelper.query("name", new QFilter[]{qFilter});
        ArrayList list = Lists.newArrayListWithExpectedSize((int)nameDynamicObject.length);
        for (int i = 0; i < nameDynamicObject.length; ++i) {
            list.add(nameDynamicObject[i].getString("name"));
        }
        return list;
    }

    public static String groupCompanyStr() {
        String orgTypeName;
        int i;
        List<String> groupList = OrgBatchBillCheckHelper.queryGroupOrgTypeNameList(1010L);
        List<String> companyList = OrgBatchBillCheckHelper.queryGroupOrgTypeNameList(1020L);
        StringBuilder stringBuilder = new StringBuilder();
        for (i = 0; i < groupList.size(); ++i) {
            orgTypeName = groupList.get(i);
            stringBuilder.append(orgTypeName);
            if (i == groupList.size() - 1) {
                stringBuilder.append("]\u3001[");
                continue;
            }
            stringBuilder.append("\u3001");
        }
        for (i = 0; i < companyList.size(); ++i) {
            orgTypeName = companyList.get(i);
            stringBuilder.append(orgTypeName);
            if (i == groupList.size() - 1) continue;
            stringBuilder.append("\u3001");
        }
        int strLength = stringBuilder.length();
        return strLength == 0 ? "" : stringBuilder.substring(0, strLength - 1);
    }

    public static String generateOrgTypeNameStr(List<String> orgTypeNameList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String orgTypeName : orgTypeNameList) {
            if (!HRStringUtils.isNotEmpty((String)orgTypeName)) continue;
            stringBuilder.append('[').append(orgTypeName).append("]\u3001");
        }
        int strLength = stringBuilder.length();
        return strLength == 0 ? "" : stringBuilder.substring(0, strLength - 1);
    }

    public static Map<Long, Date> getOrgInfoLatestBsed(Map<Long, Date> orgIdBsedMap, String openApiFlag) {
        Set<Long> orgIdSet = orgIdBsedMap.keySet();
        Map<Long, Date> baseInfoOrgIdBsed = OrgBatchBillCheckHelper.getOrgIdBsedMapBasInfo(orgIdSet);
        HRBaseServiceHelper companyHelper = new HRBaseServiceHelper("haos_adminorgcompany");
        Map<Long, Date> companyOrgIdBsed = OrgBatchBillCheckHelper.getOrgIdBsedMapCommon(orgIdSet, companyHelper);
        HRBaseServiceHelper groupHelper = new HRBaseServiceHelper("haos_adminorggroup");
        Map<Long, Date> groupOrgIdBsed = OrgBatchBillCheckHelper.getOrgIdBsedMapCommon(orgIdSet, groupHelper);
        HRBaseServiceHelper deptHelper = new HRBaseServiceHelper("haos_adminorgdepartment");
        Map<Long, Date> deptOrgIdBsed = OrgBatchBillCheckHelper.getOrgIdBsedMapCommon(orgIdSet, deptHelper);
        Map<Long, Date> orgCoopRelBsed = OrgBatchBillCheckHelper.getOrgCoopRelLastBsed(orgIdBsedMap.keySet());
        for (Map.Entry<Long, Date> longDateEntry : orgIdBsedMap.entrySet()) {
            Long orgId = longDateEntry.getKey();
            Date latestBsed = longDateEntry.getValue();
            if (latestBsed == null) continue;
            if (companyOrgIdBsed.get(orgId) != null && companyOrgIdBsed.get(orgId).after(latestBsed)) {
                latestBsed = companyOrgIdBsed.get(orgId);
            }
            if (groupOrgIdBsed.get(orgId) != null && groupOrgIdBsed.get(orgId).after(latestBsed)) {
                latestBsed = groupOrgIdBsed.get(orgId);
            }
            if (deptOrgIdBsed.get(orgId) != null && deptOrgIdBsed.get(orgId).after(latestBsed)) {
                latestBsed = deptOrgIdBsed.get(orgId);
            }
            if (orgCoopRelBsed.get(orgId) != null && orgCoopRelBsed.get(orgId).after(latestBsed)) {
                latestBsed = orgCoopRelBsed.get(orgId);
            }
            if (baseInfoOrgIdBsed.get(orgId) != null && baseInfoOrgIdBsed.get(orgId).after(latestBsed)) {
                latestBsed = baseInfoOrgIdBsed.get(orgId);
            }
            orgIdBsedMap.put(orgId, latestBsed);
        }
        return orgIdBsedMap;
    }

    public static Map<Long, Date> getOrgInfoLatestBsed(Map<Long, Date> orgIdBsedMap) {
        return OrgBatchBillCheckHelper.getOrgInfoLatestBsed(orgIdBsedMap, null);
    }

    public static Map<Long, Date> getOrgIdBsedMapCommon(Set<Long> orgIdSet, HRBaseServiceHelper helper) {
        QFilter qFilter = new QFilter("adminorg", "in", orgIdSet);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        DynamicObjectCollection orgInfoColl = helper.queryOriginalCollection("adminorg,bsed", new QFilter[]{qFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)orgIdSet.size());
        for (DynamicObject dynamicObject : orgInfoColl) {
            Long orgId = dynamicObject.getLong("adminorg");
            Date curDate = dynamicObject.getDate("bsed");
            if (result.containsKey(orgId)) {
                Date date = (Date)result.get(orgId);
                if (!curDate.after(date)) continue;
                result.put(orgId, curDate);
                continue;
            }
            result.put(orgId, curDate);
        }
        return result;
    }

    public static Map<Long, Date> getOrgIdBsedMapBasInfo(Set<Long> orgIdSet) {
        HRBaseServiceHelper baseInfoHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("id", "in", orgIdSet);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        DynamicObjectCollection orgInfoColl = baseInfoHelper.queryOriginalCollection("id,bsed", new QFilter[]{qFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)orgIdSet.size());
        for (DynamicObject dynamicObject : orgInfoColl) {
            Long orgId = dynamicObject.getLong("id");
            Date curDate = dynamicObject.getDate("bsed");
            if (result.containsKey(orgId)) {
                Date date = (Date)result.get(orgId);
                if (!curDate.after(date)) continue;
                result.put(orgId, curDate);
                continue;
            }
            result.put(orgId, curDate);
        }
        return result;
    }

    public static Map<Long, Date> getOrgCoopRelLastBsed(Set<Long> orgIdSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter orgIdFilter = new QFilter("org", "in", orgIdSet);
        orgIdFilter.and(new QFilter("enable", "=", (Object)"1"));
        orgIdFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        orgIdFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("org,bsed", new QFilter[]{orgIdFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)orgIdSet.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long orgId = dynamicObject.getLong("org");
            Date curDate = dynamicObject.getDate("bsed");
            if (result.containsKey(orgId)) {
                Date date = (Date)result.get(orgId);
                if (!curDate.after(date)) continue;
                result.put(orgId, curDate);
                continue;
            }
            result.put(orgId, curDate);
        }
        return result;
    }

    public static Map<Long, List<String>> invokePersonService(Set<Long> orgIds, Long buOrgId) {
        boolean isAllow = SystemParamHelper.getAllowPersonOnPosDisableParameter(buOrgId);
        return OrgBatchBillCheckHelper.invokePersonService(orgIds, isAllow);
    }

    public static Map<Long, List<String>> invokePersonService(Set<Long> orgIds, boolean isAllow) {
        HashMap<Long, List<String>> orgIdNameMap = new HashMap<Long, List<String>>(16);
        if (!isAllow) {
            ArrayList<Long> orgIdList = new ArrayList<Long>(orgIds);
            LOGGER.info("request param:{}", (Object)SerializationUtils.toJsonString(orgIdList));
            List personResult = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonByOrgs", (Object[])new Object[]{orgIdList, null});
            LOGGER.info("response date:{}", (Object)SerializationUtils.toJsonString((Object)personResult));
            Map<Long, List<Map>> orgIdPersonMap = personResult.stream().collect(Collectors.groupingBy(personMap -> (Long)personMap.get("adminorg")));
            for (Map.Entry<Long, List<Map>> longListEntry : orgIdPersonMap.entrySet()) {
                List<String> names = OrgBatchBillCheckHelper.getNames(longListEntry.getValue());
                orgIdNameMap.put(longListEntry.getKey(), names);
            }
        }
        return orgIdNameMap;
    }

    public static List<String> getNames(List<Map<String, Object>> personList) {
        ArrayList nameList = Lists.newArrayListWithCapacity((int)personList.size());
        for (Map<String, Object> person : personList) {
            nameList.add(String.valueOf(person.get("name")));
        }
        return nameList;
    }

    public static String generateMultiNameComboKey(long parentId, String locale, String name) {
        return parentId + "#" + locale.toLowerCase() + "#" + name;
    }

    public static Set<String> assembleMultiNameComboKey(DynamicObject dynamicObject) {
        HashSet<String> orgNameKeySet = new HashSet<String>(3);
        long parentOrgId = dynamicObject.getLong("parentorg.id");
        OrmLocaleValue nameOrm = (OrmLocaleValue)dynamicObject.get("name");
        for (String ormKey : nameOrm.keySet()) {
            String multiNameKey = OrgBatchBillCheckHelper.generateMultiNameComboKey(parentOrgId, ormKey, nameOrm.get((Object)ormKey));
            orgNameKeySet.add(multiNameKey);
        }
        return orgNameKeySet;
    }

    public static Map<String, String> assembleMultiName() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put("zh_CN", ResManager.loadKDString((String)"\u7b80\u4f53\u4e2d\u6587", (String)"OrgBatchBillCheckHelper_1", (String)"odc-homs-business", (Object[])new Object[0]));
        map.put("zh_TW", ResManager.loadKDString((String)"\u7e41\u4f53\u4e2d\u6587", (String)"OrgBatchBillCheckHelper_2", (String)"odc-homs-business", (Object[])new Object[0]));
        map.put("en_US", "English");
        return map;
    }

    public static boolean isValidateOrgId(Long orgId) {
        return orgId == null || orgId.equals(0L);
    }

    public static Set<Long> queryCurrentDisableOrgIdSet(Set<Long> boIdList) {
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter adminFilter = new QFilter("boid", "in", boIdList);
        adminFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        adminFilter.and(new QFilter("enable", "=", (Object)"0"));
        DynamicObjectCollection orgColl = adminHelper.queryOriginalCollection("id", new QFilter[]{adminFilter});
        return orgColl.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    public static Map<Long, DynamicObject> batchQueryOrgDetailInfoById(Set<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", orgIds)});
        Map<Long, DynamicObject> orgDetailInfoMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        Map<Long, List<DynamicObject>> orgCoopInfoMap = OrgBatchBillCheckHelper.queryOrgCoopInfoByOrgTeamId(orgIds);
        orgCoopInfoMap.forEach((orgId, orgCoopInfos) -> Optional.ofNullable(orgDetailInfoMap.get(orgId)).ifPresent(dy -> {
            DynamicObjectCollection collection = dy.getDynamicObjectCollection("cooprelentryentity");
            for (DynamicObject coopInfo : orgCoopInfos) {
                DynamicObject object = new DynamicObject(collection.getDynamicObjectType());
                object.set("coopreltyp", (Object)coopInfo.getDynamicObject("coopreltype"));
                object.set("cooporgteam", (Object)coopInfo.getDynamicObject("cooporgteam"));
                object.set("cooprelid", (Object)coopInfo.getLong("sourcevid"));
                object.set("ceffectdate", (Object)coopInfo.getDate("bsed"));
                collection.add((Object)object);
            }
        }));
        Map<Long, OrgBatchCheck4LayerModelBO> org4LayerModelBOMap = OrgBatchBillCheckHelper.batchQueryOrgCompDepGroupInfo(orgIds);
        org4LayerModelBOMap.forEach((orgId, org4LayerModel) -> Optional.ofNullable(orgDetailInfoMap.get(orgId)).ifPresent(org -> {
            for (String fieldKey : OrgBatchCheckConstants.INFOCHG_CHECK_COMPANY_GROUP_FIELD) {
                Optional.ofNullable(org4LayerModel.getPropValue(fieldKey)).ifPresent(fieldVal -> org.set(fieldKey, fieldVal));
            }
        }));
        return orgDetailInfoMap;
    }

    private static Map<Long, List<DynamicObject>> queryOrgCoopInfoByOrgTeamId(Set<Long> orgIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter qFilter = new QFilter("org", "in", orgIds);
        qFilter.and("iscurrentversion", "=", (Object)"1");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("coopreltype", "!=", (Object)1010L);
        DynamicObject[] dynamicObjects = serviceHelper.query("sourcevid,org,cooporgteam,coopreltype,bsed", new QFilter[]{qFilter});
        return Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getLong("org.id")));
    }

    public static Map<Long, OrgBatchCheck4LayerModelBO> batchQueryOrgCompDepGroupInfo(Set<Long> orgIds) {
        DynamicObject[] orgDepartmentInfo;
        DynamicObject[] companyInfo;
        DynamicObject[] groupInfo;
        if (CollectionUtils.isEmpty(orgIds)) {
            return Maps.newHashMapWithExpectedSize((int)orgIds.size());
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey());
        QFilter qFilter = new QFilter("adminorg", "in", orgIds);
        qFilter.and("iscurrentversion", "=", (Object)"1");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("datastatus", "=", (Object)"1");
        HashMap map = Maps.newHashMapWithExpectedSize((int)orgIds.size());
        for (DynamicObject object : groupInfo = serviceHelper.query("adminorg,groupvision,groupmission", new QFilter[]{qFilter})) {
            long orgId = object.getLong("adminorg.id");
            ILocaleString groupVision = object.getLocaleString("groupvision");
            ILocaleString groupMission = object.getLocaleString("groupmission");
            map.put(orgId, new OrgBatchCheck4LayerModelBO(orgId, groupMission, groupVision));
        }
        serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey());
        for (DynamicObject object : companyInfo = serviceHelper.query("adminorg,companytype,industrytype", new QFilter[]{qFilter})) {
            long orgId = object.getLong("adminorg.id");
            DynamicObject companyTypeDyn = object.getDynamicObject("companytype");
            DynamicObject industryTypeDyn = object.getDynamicObject("industrytype");
            Optional.of(map.computeIfAbsent(orgId, OrgBatchCheck4LayerModelBO::new)).ifPresent(orgBatchCheck4LayerModelBO -> {
                orgBatchCheck4LayerModelBO.setCompanyType(companyTypeDyn);
                orgBatchCheck4LayerModelBO.setIndustryType(industryTypeDyn);
            });
        }
        serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey());
        for (DynamicObject object : orgDepartmentInfo = serviceHelper.query("adminorg,departmenttype", new QFilter[]{qFilter})) {
            long orgId = object.getLong("adminorg.id");
            DynamicObject departmentType = object.getDynamicObject("departmenttype");
            Optional.of(map.computeIfAbsent(orgId, OrgBatchCheck4LayerModelBO::new)).ifPresent(orgBatchCheck4LayerModelBO -> orgBatchCheck4LayerModelBO.setDepartmentType(departmentType));
        }
        return map;
    }

    public static Set<Long> queryDisableOrgBoIdSet(Set<Long> boIdSet, Date effectDate) {
        QFilter adminFilter = new QFilter("boid", "in", boIdSet);
        adminFilter.and(new QFilter("bsled", ">=", (Object)effectDate));
        adminFilter.and(new QFilter("enable", "=", (Object)"0"));
        adminFilter.and(new QFilter("datastatus", "in", (Object)new String[]{"1", "2"}));
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObjectCollection orgColl = adminHelper.queryOriginalCollection("boid", new QFilter[]{adminFilter});
        return orgColl.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
    }

    public static Map<Long, DynamicObject> queryCurBillInfoChgOrgs(Long currentBillId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter qFilter = new QFilter("billid", "=", (Object)currentBillId);
        qFilter.and("changetype", "=", (Object)OrgBatchChgBillConstants.CHANGE_TYPE_INFO);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        return Stream.of(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("adminorg.boid"), dy -> dy));
    }

    public static Map<Long, Long> queryNewBoIdOrgIdMap(Set<Long> boIdSet) {
        QFilter adminFilter = new QFilter("boid", "in", boIdSet);
        adminFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        adminFilter.and(new QFilter("enable", "=", (Object)"1"));
        adminFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        adminFilter.and(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')));
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObjectCollection orgColl = adminHelper.queryOriginalCollection("boid,id", new QFilter[]{adminFilter}, "bsed desc");
        Map<Long, List<DynamicObject>> orgGroupMap = orgColl.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        HashMap boIdOrgIdMap = Maps.newHashMapWithExpectedSize((int)orgColl.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : orgGroupMap.entrySet()) {
            Long orgId = entry.getValue().get(0).getLong("id");
            boIdOrgIdMap.put(entry.getKey(), orgId);
        }
        return boIdOrgIdMap;
    }

    public static List<CycleOrgBean> queryAdminOrgColl(Date effectDate) {
        QFilter adminFilter = new QFilter("enable", "=", (Object)"1");
        adminFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        adminFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        adminFilter.and(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')));
        adminFilter.and(new QFilter("bsled", ">=", (Object)effectDate));
        adminFilter.and(new QFilter("bsed", "<=", (Object)effectDate));
        adminFilter.and("coopreltype", "=", (Object)1010L);
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        DynamicObjectCollection orgColl = adminHelper.queryOriginalCollection("org,cooporgteam,bsed,bsled", new QFilter[]{adminFilter});
        ArrayList result = Lists.newArrayListWithCapacity((int)orgColl.size());
        for (DynamicObject dy : orgColl) {
            Long orgId = dy.getLong("org");
            Long coopOrgId = dy.getLong("cooporgteam");
            if (OrgBatchBillCheckHelper.isValidateOrgId(orgId) || OrgBatchBillCheckHelper.isValidateOrgId(coopOrgId)) continue;
            CycleOrgBean cycleOrg = new CycleOrgBean();
            cycleOrg.setOrgId(orgId);
            cycleOrg.setCoopOrgId(coopOrgId);
            cycleOrg.setBsed(dy.getDate("bsed"));
            cycleOrg.setBsled(dy.getDate("bsled"));
            cycleOrg.setDataSource("admin");
            result.add(cycleOrg);
        }
        return result;
    }

    public static List<StructCycleOrgBean> queryStructAdminOrgColl(Set<Long> orgIds, Date effectDate) {
        QFilter adminFilter = new QFilter("enable", "=", (Object)"1");
        adminFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        adminFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        adminFilter.and(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')));
        adminFilter.and(new QFilter("bsled", ">=", (Object)effectDate));
        adminFilter.and(new QFilter("bsed", "<=", (Object)effectDate));
        adminFilter.and("adminorg", "in", orgIds);
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        DynamicObjectCollection orgColl = adminHelper.queryOriginalCollection("adminorg,parentorg,structproject,structlongnumber,bsed,bsled", new QFilter[]{adminFilter});
        ArrayList result = Lists.newArrayListWithCapacity((int)orgColl.size());
        for (DynamicObject dy : orgColl) {
            Long orgId = dy.getLong("adminorg");
            Long parentOrgId = dy.getLong("parentorg");
            if (OrgBatchBillCheckHelper.isValidateOrgId(orgId) || OrgBatchBillCheckHelper.isValidateOrgId(parentOrgId)) continue;
            StructCycleOrgBean cycleOrg = new StructCycleOrgBean();
            cycleOrg.setOrgId(orgId);
            cycleOrg.setParentId(parentOrgId);
            cycleOrg.setStructproject(dy.getLong("structproject"));
            cycleOrg.setStructLongNumber(dy.getString("structlongnumber"));
            cycleOrg.setBsed(dy.getDate("bsed"));
            cycleOrg.setBsled(dy.getDate("bsled"));
            cycleOrg.setDataSource("admin");
            result.add(cycleOrg);
        }
        return result;
    }

    public static boolean isTimeOverlap(boolean isTime, CycleOrgBean checkOrg, CycleOrgBean coopOrg) {
        if (isTime) {
            return checkOrg.getBsed().before(coopOrg.getBsled()) && checkOrg.getBsled().after(coopOrg.getBsed()) || HRDateTimeUtils.dayEquals((Date)checkOrg.getBsed(), (Date)coopOrg.getBsled()) || HRDateTimeUtils.dayEquals((Date)checkOrg.getBsled(), (Date)coopOrg.getBsed());
        }
        return true;
    }

    public static Deque<CycleOrgBean> containsCycle(CycleOrgBean checkOrg, Map<Long, List<CycleOrgBean>> orgIdNodesMap, boolean isTime) {
        ArrayDeque<CycleOrgBean> stack = new ArrayDeque<CycleOrgBean>();
        if (checkOrg.getOrgId() != null && checkOrg.getCoopOrgId() != null && checkOrg.getOrgId().equals(checkOrg.getCoopOrgId())) {
            stack.push(checkOrg);
            return stack;
        }
        HashSet recordSet = Sets.newHashSetWithExpectedSize((int)(orgIdNodesMap.size() << 3));
        stack.push(checkOrg);
        Long checkOrgId = checkOrg.getOrgId();
        boolean hasCycle = false;
        block0: while (!hasCycle && !stack.isEmpty()) {
            CycleOrgBean current = (CycleOrgBean)stack.pop();
            Long coopId = current.getCoopOrgId();
            List coopNodeList = orgIdNodesMap.getOrDefault(coopId, new ArrayList(48));
            for (CycleOrgBean coopOrg : coopNodeList) {
                if (!recordSet.add(coopOrg) || !OrgBatchBillCheckHelper.isTimeOverlap(isTime, current, coopOrg)) continue;
                if (checkOrgId.equals(coopOrg.getCoopOrgId()) && OrgBatchBillCheckHelper.isTimeOverlap(isTime, checkOrg, coopOrg)) {
                    hasCycle = true;
                    current.setBillNo(coopOrg.getBillNo());
                    stack.push(current);
                    continue block0;
                }
                stack.push(current);
                stack.push(coopOrg);
            }
        }
        return hasCycle ? stack : null;
    }

    public static boolean isExistsHisInterval(Date checkDate, DynamicObject dynamicObject) {
        Date bsed = dynamicObject.getDate("bsed");
        Date bsled = dynamicObject.getDate("bsled");
        return HRDateTimeUtils.dayBefore((Date)bsed, (Date)checkDate) && HRDateTimeUtils.dayBefore((Date)checkDate, (Date)bsled) || HRDateTimeUtils.dayEquals((Date)checkDate, (Date)bsed) || HRDateTimeUtils.dayEquals((Date)checkDate, (Date)bsled) || HRDateTimeUtils.dayBefore((Date)checkDate, (Date)bsed);
    }

    public static List<OrgBatchCheckDto> queryAdminOrgLocaleNames(Set<Long> parentBoIdSet, Date effectDate, boolean isEnabled) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fboid,a.fparentid,b.flocaleid,b.fname ").append("from t_haos_adminorg a ").append("left join t_haos_adminorg_l b on b.fid = a.fid ").append("where a.fparentid in (");
        parentBoIdSet.forEach(id -> sb.append('?').append(','));
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        sb.append(" and a.fdatastatus in ('1','2') ");
        if (isEnabled) {
            sb.append(" and a.fenable = '1' ");
        }
        sb.append(" and a.finitstatus = '2' ");
        sb.append(" and a.fbsled >= ?");
        ArrayList params = Lists.newArrayListWithExpectedSize((int)(parentBoIdSet.size() + 1));
        params.addAll(parentBoIdSet);
        params.add(effectDate);
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryAdminOrgLocaleNames", (DBRoute)new DBRoute("haos"), (String)sb.toString(), (Object[])params.toArray());){
            for (Row data : ds) {
                OrgBatchCheckDto checkDto = new OrgBatchCheckDto();
                checkDto.setOrgBoId(data.getLong("fboid"));
                checkDto.setParentOrgId(data.getLong("fparentid"));
                checkDto.setLocaleId(data.getString("flocaleid"));
                checkDto.setName(data.getString("fname"));
                result.add(checkDto);
            }
        }
        return result;
    }

    public static List<OrgBatchCheckDto> queryBillOrgLocaleNames(Set<Long> parentIdSet) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fbillno,b.fadminorgid,a.feffdt,b.festablishmentdate,b.fchangetypeid,b.fparentid,c.flocaleid,c.fname, b.fadminorgboid, b.fnumber ").append("from t_homs_orgchgbill a ").append("left join t_homs_orgchgbillentry b on b.fid = a.fid ").append("left join t_homs_orgchgbillentry_l c on c.fentryid = b.fentryid ").append("where a.fbillstatus in('B','D') ").append("and b.fparentid in (");
        parentIdSet.forEach(id -> sb.append('?').append(','));
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryBillOrgLocaleNames", (DBRoute)new DBRoute("haos"), (String)sb.toString(), (Object[])parentIdSet.toArray());){
            for (Row data : ds) {
                Long type = data.getLong("fchangetypeid");
                if (OrgBatchChgBillConstants.CHANGE_TYPE_MERGE.equals(type) || OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT.equals(type)) continue;
                OrgBatchCheckDto checkDto = new OrgBatchCheckDto();
                checkDto.setOrgId(data.getLong("fadminorgid"));
                checkDto.setChangeTypeId(type);
                checkDto.setOrgBoId(data.getLong("fadminorgboid"));
                checkDto.setNumber(data.getString("fnumber"));
                checkDto.setBillNo(data.getString("fbillno"));
                checkDto.setParentOrgId(data.getLong("fparentid"));
                checkDto.setLocaleId(data.getString("flocaleid"));
                checkDto.setName(data.getString("fname"));
                checkDto.setEffectDate(data.getDate("feffdt"));
                checkDto.setEstablishmentDate(data.getDate("festablishmentdate"));
                result.add(checkDto);
            }
        }
        return result;
    }

    public static List<OrgBatchCheckDto> queryBillOrgLocaleNamesByParentBoId(Set<Long> parentIdSet) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fbillno,b.fadminorgid,a.feffdt,b.festablishmentdate,b.fchangetypeid,b.fparentid,c.flocaleid,c.fname, b.fadminorgboid, b.fnumber ").append("from t_homs_orgchgbill a ").append("left join t_homs_orgchgbillentry b on b.fid = a.fid ").append("left join t_homs_orgchgbillentry_l c on c.fentryid = b.fentryid ").append("left join t_haos_adminorg d on d.fid = b.fparentid ").append("where a.fbillstatus in('B','D') ").append("and d.fboid in (");
        parentIdSet.forEach(id -> sb.append('?').append(','));
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryBillOrgLocaleNamesByParentBoId", (DBRoute)new DBRoute("haos"), (String)sb.toString(), (Object[])parentIdSet.toArray());){
            for (Row data : ds) {
                Long type = data.getLong("fchangetypeid");
                if (OrgBatchChgBillConstants.CHANGE_TYPE_MERGE.equals(type) || OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT.equals(type)) continue;
                OrgBatchCheckDto checkDto = new OrgBatchCheckDto();
                checkDto.setOrgId(data.getLong("fadminorgid"));
                checkDto.setChangeTypeId(type);
                checkDto.setOrgBoId(data.getLong("fadminorgboid"));
                checkDto.setNumber(data.getString("fnumber"));
                checkDto.setBillNo(data.getString("fbillno"));
                checkDto.setParentOrgId(data.getLong("fparentid"));
                checkDto.setLocaleId(data.getString("flocaleid"));
                checkDto.setName(data.getString("fname"));
                checkDto.setEstablishmentDate(data.getDate("festablishmentdate"));
                checkDto.setEffectDate(data.getDate("feffdt"));
                checkDto.setEstablishmentDate(data.getDate("festablishmentdate"));
                result.add(checkDto);
            }
        }
        return result;
    }

    public static CycleOrgBean assembleCycleOrg(Long orgId, Long coopOrgId, Date effectDate) {
        CycleOrgBean cycleOrg = new CycleOrgBean();
        cycleOrg.setOrgId(orgId);
        cycleOrg.setCoopOrgId(coopOrgId);
        cycleOrg.setBsed(effectDate);
        Date bsled = new Date();
        try {
            bsled = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            LOGGER.error("parseDate error:", (Throwable)e);
        }
        cycleOrg.setBsled(bsled);
        return cycleOrg;
    }

    public static String getTimeSpan(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            LOGGER.info("kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper.getTimeSpan startTime [{}], endTime: [{}]", (Object)startTime, (Object)endTime);
        }
        String toNow = ResManager.loadKDString((String)"\u81f3\u4eca", (String)"OrgBatchDisableCheckServiceImpl_9", (String)"odc-homs-business", (Object[])new Object[0]);
        return HRDateTimeUtils.format((Date)startTime, (String)"yyyy-MM-dd") + "-" + (lastDate.equals(endTime) || lastDate3000.equals(endTime) ? toNow : HRDateTimeUtils.format((Date)endTime, (String)"yyyy-MM-dd"));
    }

    public static Map<Long, OrgLevel4ModelCheckServiceImpl.OrgAboveLevel4ModelParam> getParentAdminStdTypeByBoId(Set<Long> parentBoIds, Date effectDate) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("boid", "in", parentBoIds);
        qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        qFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("bsled", ">=", (Object)effectDate));
        qFilter.and(new QFilter("bsed", "<=", (Object)effectDate));
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id,boid,adminorgtype,bsed,bsled", new QFilter[]{qFilter});
        HashMap<Long, OrgLevel4ModelCheckServiceImpl.OrgAboveLevel4ModelParam> result = new HashMap<Long, OrgLevel4ModelCheckServiceImpl.OrgAboveLevel4ModelParam>();
        for (DynamicObject dy : dynamicObjects) {
            boolean existsHisInterval = OrgBatchBillCheckHelper.isExistsHisInterval(effectDate, dy);
            if (!existsHisInterval) continue;
            result.put(dy.getLong("boid"), new OrgLevel4ModelCheckServiceImpl.OrgAboveLevel4ModelParam(false, dy.getLong("adminorgtype"), effectDate, dy.getDate("bsled")));
        }
        return result;
    }

    public static Map<Long, Set<Long>> getParentOrgIdOrgIdSetMap(Map<Long, List<DynamicObject>> parentOrgIdOrgDynamicMap) {
        HashMap parentOrgIdOrgIdSetMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, List<DynamicObject>> entry : parentOrgIdOrgDynamicMap.entrySet()) {
            List<DynamicObject> dyList = entry.getValue();
            HashSet orgBoIdSet = Sets.newHashSetWithExpectedSize((int)dyList.size());
            for (DynamicObject dy : dyList) {
                orgBoIdSet.add(dy.getLong("boid"));
            }
            parentOrgIdOrgIdSetMap.put(entry.getKey(), orgBoIdSet);
        }
        return parentOrgIdOrgIdSetMap;
    }

    public static Map<Long, EnableSubValidate> getParentOrg2SubNames(Map<Long, List<DynamicObject>> parentOrgIdOrgDynamicMap) {
        HashMap parentOrg2SubNames = Maps.newHashMapWithExpectedSize((int)parentOrgIdOrgDynamicMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : parentOrgIdOrgDynamicMap.entrySet()) {
            List<DynamicObject> value = entry.getValue();
            EnableSubValidate enableSubValidate = new EnableSubValidate();
            HashMap boidToNames = Maps.newHashMapWithExpectedSize((int)parentOrgIdOrgDynamicMap.size());
            Date lastDate = new Date(0L);
            for (DynamicObject dynamicObject : value) {
                boidToNames.put(dynamicObject.getLong("boid"), "[" + dynamicObject.getString("name") + "]");
                Date bsled = dynamicObject.getDate("bsled");
                if (!bsled.after(lastDate)) continue;
                lastDate = bsled;
            }
            enableSubValidate.setEndTime(lastDate);
            enableSubValidate.setBoidToNames(boidToNames);
            parentOrg2SubNames.put(entry.getKey(), enableSubValidate);
        }
        return parentOrg2SubNames;
    }

    public static Map<Long, Long> getPositionCountByOrg(List<Long> boidList) {
        int code;
        Map orgPositionMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IPositionService", (String)"queryPositionHisByOrgIds", (Object[])new Object[]{boidList, new Date()});
        Map<Long, Long> positionSumMap = new HashMap<Long, Long>(boidList.size());
        if (!CollectionUtils.isEmpty((Map)orgPositionMap) && (code = ((Integer)orgPositionMap.get("code")).intValue()) == 200) {
            List positionInfoList = (List)orgPositionMap.get("data");
            positionSumMap = positionInfoList.stream().collect(Collectors.groupingBy(position -> Long.parseLong(position.get("adminorg").toString()), Collectors.counting()));
        }
        return positionSumMap;
    }

    public static List<StructCycleOrgBean> queryParentOrgColl(Date effectDate, Set<Long> parentIds) {
        QFilter adminFilter = new QFilter("enable", "=", (Object)"1");
        adminFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        adminFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        adminFilter.and(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')));
        adminFilter.and(new QFilter("bsled", ">=", (Object)effectDate));
        adminFilter.and(new QFilter("bsed", "<=", (Object)effectDate));
        adminFilter.and(new QFilter("adminorg", "in", parentIds));
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        DynamicObjectCollection orgColl = adminHelper.queryOriginalCollection("adminorg,parentorg,structlongnumber,structproject,bsed,bsled", new QFilter[]{adminFilter});
        ArrayList result = Lists.newArrayListWithCapacity((int)orgColl.size());
        for (DynamicObject dy : orgColl) {
            Long orgId = dy.getLong("adminorg");
            StructCycleOrgBean cycleOrg = new StructCycleOrgBean();
            cycleOrg.setOrgId(orgId);
            cycleOrg.setStructLongNumber(dy.getString("structlongnumber"));
            cycleOrg.setStructproject(dy.getLong("structproject"));
            cycleOrg.setBsed(dy.getDate("bsed"));
            cycleOrg.setBsled(dy.getDate("bsled"));
            cycleOrg.setParentId(dy.getLong("parentorg"));
            result.add(cycleOrg);
        }
        return result;
    }

    public static Deque<StructCycleOrgBean> containsStructCycle(StructCycleOrgBean checkOrg, Map<Long, List<StructCycleOrgBean>> orgIdNodesMap, boolean isTime) {
        ArrayDeque<StructCycleOrgBean> stack = new ArrayDeque<StructCycleOrgBean>();
        HashSet recordSet = Sets.newHashSetWithExpectedSize((int)(orgIdNodesMap.size() << 3));
        stack.push(checkOrg);
        Long checkOrgId = checkOrg.getOrgId();
        boolean hasCycle = false;
        block0: while (!hasCycle && !stack.isEmpty()) {
            StructCycleOrgBean current = (StructCycleOrgBean)stack.pop();
            Long parentId = current.getParentId();
            List coopNodeList = orgIdNodesMap.getOrDefault(parentId, new ArrayList(48));
            for (StructCycleOrgBean coopOrg : coopNodeList) {
                if (!recordSet.add(coopOrg) || !OrgBatchBillCheckHelper.isTimeOverlapStruct(isTime, current, coopOrg)) continue;
                if (checkOrgId.equals(coopOrg.getParentId()) && OrgBatchBillCheckHelper.isTimeOverlapStruct(isTime, checkOrg, coopOrg)) {
                    hasCycle = true;
                    current.setBillNo(coopOrg.getBillNo());
                    stack.push(current);
                    continue block0;
                }
                stack.push(current);
                stack.push(coopOrg);
            }
        }
        return hasCycle ? stack : null;
    }

    public static boolean isTimeOverlapStruct(boolean isTime, StructCycleOrgBean checkOrg, StructCycleOrgBean coopOrg) {
        if (isTime) {
            return checkOrg.getStructproject().equals(coopOrg.getStructproject()) && (checkOrg.getBsed().before(coopOrg.getBsled()) && checkOrg.getBsled().after(coopOrg.getBsed()) || HRDateTimeUtils.dayEquals((Date)checkOrg.getBsed(), (Date)coopOrg.getBsled()) || HRDateTimeUtils.dayEquals((Date)checkOrg.getBsled(), (Date)coopOrg.getBsed()));
        }
        return true;
    }

    public static void queryBillStructEntryOrgList(List<OrgBatchCheckDto> checkDtoList) {
        if (CollectionUtils.isEmpty(checkDtoList)) {
            return;
        }
        List entryIds = checkDtoList.stream().map(orgBatchCheckDto -> orgBatchCheckDto.getEntryId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entryIds)) {
            return;
        }
        Map<Long, String> billNoMap = checkDtoList.stream().collect(Collectors.toMap(orgBatchCheckDto -> orgBatchCheckDto.getEntryId(), orgBatchCheckDto -> orgBatchCheckDto.getBillNo()));
        HRBaseServiceHelper entryHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter entryFilter = new QFilter("id", "in", entryIds);
        DynamicObject[] dyArr = entryHelper.query("id,adminorg,struct_project_entry.struct_project,struct_project_entry.struct_parent_org", new QFilter[]{entryFilter});
        Map<Long, DynamicObject> entryMap = Arrays.asList(dyArr).stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
        for (OrgBatchCheckDto orgBatchCheckDto2 : checkDtoList) {
            DynamicObjectCollection structCollection;
            DynamicObject entryDy;
            Long entryId = orgBatchCheckDto2.getEntryId();
            if (!entryMap.containsKey(entryId) || !(entryDy = entryMap.get(entryId)).containsProperty("struct_project_entry") || CollectionUtils.isEmpty((Collection)(structCollection = entryDy.getDynamicObjectCollection("struct_project_entry")))) continue;
            orgBatchCheckDto2.setStructCycleOrgBeans(new ArrayList<StructCycleOrgBean>(structCollection.size()));
            structCollection.forEach(dynamicObject -> orgBatchCheckDto2.getStructCycleOrgBeans().add(new StructCycleOrgBean(entryDy.getDynamicObject("adminorg").getLong("id"), HRDyObjectPropUtil.getId((DynamicObject)dynamicObject.getDynamicObject("struct_parent_org")), HRDyObjectPropUtil.getId((DynamicObject)dynamicObject.getDynamicObject("struct_project")), (String)billNoMap.get(entryId))));
        }
    }

    static {
        try {
            lastDate = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
            lastDate3000 = HRDateTimeUtils.parseDate((String)"3000-01-01", (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            LOGGER.error("HRDateTimeUtils.parseDate error");
        }
    }

    public static class EnableSubValidate {
        private Map<Long, String> boidToNames;
        private Date endTime;

        public Map<Long, String> getBoidToNames() {
            return this.boidToNames;
        }

        public void setBoidToNames(Map<Long, String> boidToNames) {
            this.boidToNames = boidToNames;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }
    }
}

