/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.helper.bean.CycleCheckBean;
import kd.hr.homs.business.service.orgbatch.OrgValidateParametersBean;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import org.apache.commons.collections4.CollectionUtils;

public class OrgBatchValidateHelper {
    private static final String BSED = "bsed";
    private static final String BSLED = "bsled";
    public static final String OWN_BILL_DISABLE = "own_bill_disable";
    public static final String DISABLE = "disable";
    public static final String DISABLEING = "disableing";
    public static final HRBaseServiceHelper ORGBATCHCHGBILL_HELPER = new HRBaseServiceHelper("homs_orgbatchchgbill");
    public static final HRBaseServiceHelper BATCHORGENTITY_HELPER = new HRBaseServiceHelper("homs_batchorgentity");
    public static final HRBaseServiceHelper ORGTEAMCOOPREL_HELPER = new HRBaseServiceHelper("haos_orgteamcooprel");
    public static final HRBaseServiceHelper ADMIN_ORG_TEAM_HELPER = new HRBaseServiceHelper("haos_adminorgteam");
    public static final HRBaseServiceHelper ADMIN_ORG = new HRBaseServiceHelper("haos_adminorgdetail");
    private static final Log LOG = LogFactory.getLog(OrgBatchValidateHelper.class);
    public static final String COOP_REL_ENTRY_ENTITY = "cooprelentryentity";
    private static final String ADMINORG = "adminorg";
    private static final String COOP_ORG_TEAM = "cooporgteam";
    private static final String COOPRE_LTYP = "coopreltyp";
    private static final String COOP_REL_TYPE = "coopreltype";
    public static final Long ADD = 1010L;
    public static final Long PARENT = 1020L;
    public static final Long INFO = 1030L;
    public static final Long DELETE = 1040L;
    public static final String CHANGESCENE_ID = "changescene.orgchangetype.id";
    private static final String COOPRELTYP_ID = "coopreltyp.id";
    private static final String COOPORGTEAM_BOID = "cooporgteam.boid";
    private static java.util.Date DEFAULT_END_DATE = DateUtils.parseDateTime((String)"2999-12-31", (String)"yyyy-MM-dd");

    public static OrgValidateParametersBean queryAndBuildCheckData(DynamicObject entity, Long billId, java.util.Date effectdate, List<Long> entryentityDisable) {
        long start = System.currentTimeMillis();
        DynamicObject[] datas = BATCHORGENTITY_HELPER.query("name,sequence,changescene,adminorg,cooprelentryentity.coopreltyp,cooprelentryentity.cooporgteam,cooprelentryentity.cooprelteamclass", new QFilter[]{new QFilter("billid", "=", (Object)billId)});
        List<DynamicObject> entryentityAdd = Arrays.stream(datas).filter(dynamicObject -> ADD.equals(dynamicObject.getLong(CHANGESCENE_ID))).collect(Collectors.toList());
        List<DynamicObject> entryentityParent = Arrays.stream(datas).filter(dynamicObject -> PARENT.equals(dynamicObject.getLong(CHANGESCENE_ID))).collect(Collectors.toList());
        List<DynamicObject> entryentityInfo = Arrays.stream(datas).filter(dynamicObject -> INFO.equals(dynamicObject.getLong(CHANGESCENE_ID))).collect(Collectors.toList());
        ArrayList coopRelEntryEntity = Lists.newArrayListWithCapacity((int)(entryentityAdd.size() + entryentityParent.size() + entryentityInfo.size() << 3));
        ArrayList allEntity = Lists.newArrayListWithCapacity((int)(entryentityAdd.size() + entryentityParent.size() + entryentityInfo.size()));
        allEntity.addAll(entryentityAdd);
        allEntity.addAll(entryentityParent);
        allEntity.addAll(entryentityInfo);
        for (DynamicObject dynamicObject2 : allEntity) {
            DynamicObjectCollection cooprelentryentity = dynamicObject2.getDynamicObjectCollection(COOP_REL_ENTRY_ENTITY);
            coopRelEntryEntity.addAll(cooprelentryentity);
        }
        List<Long> typeList = coopRelEntryEntity.stream().map(dy -> dy.getLong(COOPRELTYP_ID)).collect(Collectors.toList());
        if (entity.getDataEntityType().getName().contains("homs_batchorgentity")) {
            DynamicObjectCollection dynamicObjectCollection = entity.getDynamicObjectCollection(COOP_REL_ENTRY_ENTITY);
            List currentPageCoopType = dynamicObjectCollection.stream().map(dy -> dy.getLong(COOPRELTYP_ID)).collect(Collectors.toList());
            typeList.addAll(currentPageCoopType);
        }
        long min1 = System.currentTimeMillis();
        java.util.Date today = new java.util.Date();
        DynamicObject[] effectiveData = OrgBatchValidateHelper.queryEffectiveData(ORGTEAMCOOPREL_HELPER, typeList, OrgBatchValidateHelper.formatDate(today), OrgBatchValidateHelper.formatDate(effectdate == null ? today : effectdate));
        long min2 = System.currentTimeMillis();
        Long[] needCheckSence = new Long[]{PARENT, INFO, DELETE};
        List<OrgBatchCheckDto> orgBatchCheckDtos = OrgBatchBillCheckHelper.queryBillOrgList();
        HashMap orgBoidToBillNo = Maps.newHashMapWithExpectedSize((int)orgBatchCheckDtos.size());
        for (OrgBatchCheckDto dto : orgBatchCheckDtos) {
            orgBoidToBillNo.put(dto.getAdminOrgBoid(), dto.getBillNo());
        }
        DynamicObject[] inProgressDataAll = HRBaseDaoFactory.getInstance((String)"homs_cooprelquery").query("changetype,homs_orgbatchchgbill.effdt,coopreltyp,cooporgteam,adminorg,homs_orgbatchchgbill.billstatus", new QFilter[]{new QFilter("homs_orgbatchchgbill.billstatus", "in", (Object)new String[]{"B", "D"}), new QFilter("changetype", "in", (Object)needCheckSence)});
        Map<Long, java.util.Date> effdtMap = OrgBatchValidateHelper.getLongDateMap(needCheckSence, inProgressDataAll);
        List<DynamicObject> inProgressDeleteData = Arrays.stream(inProgressDataAll).filter(dynamicObject -> DELETE.equals(dynamicObject.getLong("changetype.id"))).collect(Collectors.toList());
        List<DynamicObject> inProgressData = Arrays.stream(inProgressDataAll).filter(dynamicObject -> !DELETE.equals(dynamicObject.getLong("changetype.id"))).collect(Collectors.toList());
        long min3 = System.currentTimeMillis();
        OrgValidateParametersBean orgValidateParametersBean = new OrgValidateParametersBean(entity, allEntity, entryentityAdd, entryentityParent, entryentityInfo, entryentityDisable, effectiveData);
        orgValidateParametersBean.setInProgressData(inProgressData);
        orgValidateParametersBean.setInProgressDeleteData(inProgressDeleteData);
        orgValidateParametersBean.setEffectdate(effectdate);
        orgValidateParametersBean.setAllCoopRelEntryEntity(coopRelEntryEntity);
        orgValidateParametersBean.setEffdtMap(effdtMap);
        orgValidateParametersBean.setOrgBoidToBillNo(orgBoidToBillNo);
        LOG.info(String.format("==queryAndBuildCheckData== step1:%s", min1 - start));
        LOG.info(String.format("==queryAndBuildCheckData== step2:%s", min2 - min1));
        LOG.info(String.format("==queryAndBuildCheckData== step3:%s", min3 - min2));
        LOG.info(String.format("==queryAndBuildCheckData== step4:%s", System.currentTimeMillis() - min3));
        return orgValidateParametersBean;
    }

    private static Map<Long, java.util.Date> getLongDateMap(Long[] needCheckSence, DynamicObject[] inProgressDataAll) {
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select A.feffdt,C.fdetailid ,B.FCHANGETYPEID,C.fentryid from t_homs_orgchgbill A INNER JOIN t_homs_orgchgbillentry B on A.fid= B.Fid INNER JOIN t_homs_orgchgbillcoop C on B.fentryid=C.fentryid where A.fbillstatus in ('B','D') and B.FCHANGETYPEID IN (1020,1030)");
        HashMap effdtMap = Maps.newHashMap();
        HRDBUtil.query((DBRoute)new DBRoute("hr"), (String)selectSql.toString(), null, rs -> {
            while (rs.next()) {
                Date effdt = rs.getDate("feffdt");
                long entryid = rs.getLong("fdetailid");
                effdtMap.put(entryid, effdt);
            }
            return effdtMap;
        });
        return effdtMap;
    }

    public static Map<String, Map<String, List<DynamicObject>>> checkOrgDisabled(List<DynamicObject> entryEntity, List<Long> disableEntity, List<DynamicObject> inProgressDeleteData) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        if (CollectionUtils.isEmpty(entryEntity)) {
            return result;
        }
        Set inProgressDeleteIds = null;
        if (CollectionUtils.isNotEmpty(inProgressDeleteData)) {
            inProgressDeleteIds = inProgressDeleteData.stream().map(dy -> dy.getLong("adminorg.boid")).collect(Collectors.toSet());
        }
        Map<Long, DynamicObject> coopOrgTeamMaps = OrgBatchValidateHelper.getCurrentCoopData(entryEntity);
        for (DynamicObject dynamicObject : entryEntity) {
            ArrayList disableEdByOwnBill = Lists.newArrayListWithCapacity((int)entryEntity.size());
            ArrayList disabledList = Lists.newArrayListWithCapacity((int)entryEntity.size());
            ArrayList alreadyDisabledList = Lists.newArrayListWithCapacity((int)inProgressDeleteData.size());
            HashMap preResult = Maps.newHashMapWithExpectedSize((int)3);
            DynamicObjectCollection coops = dynamicObject.getDynamicObjectCollection(COOP_REL_ENTRY_ENTITY);
            for (DynamicObject coop : coops) {
                DynamicObject nowCoop;
                if (CollectionUtils.isNotEmpty(disableEntity)) {
                    LOG.info(String.format("==checkOrgDisabled==disableEntity:%s", disableEntity));
                    if (disableEntity.contains(coop.getLong(COOPORGTEAM_BOID))) {
                        disableEdByOwnBill.add(coop);
                    }
                }
                if ((nowCoop = coopOrgTeamMaps.get(coop.getLong(COOPORGTEAM_BOID))) == null) {
                    LOG.info(String.format("==checkOrgDisabled== cooporgteam.boid:%s", coop.getLong(COOPORGTEAM_BOID)));
                    continue;
                }
                if ("0".equals(nowCoop.getString("enable"))) {
                    disabledList.add(coop);
                }
                if (inProgressDeleteIds == null) continue;
                LOG.info(String.format("==checkOrgDisabled==inProgressDeleteIds:%s", inProgressDeleteIds));
                long teamId = nowCoop.getLong("id");
                LOG.info(String.format("==checkOrgDisabled==teamId:%s", teamId));
                if (!inProgressDeleteIds.contains(teamId)) continue;
                alreadyDisabledList.add(coop);
            }
            if (CollectionUtils.isNotEmpty((Collection)disableEdByOwnBill)) {
                preResult.put(OWN_BILL_DISABLE, disableEdByOwnBill);
            }
            if (CollectionUtils.isNotEmpty((Collection)disabledList)) {
                preResult.put(DISABLE, disabledList);
            }
            if (CollectionUtils.isNotEmpty((Collection)alreadyDisabledList)) {
                preResult.put(DISABLEING, alreadyDisabledList);
            }
            result.put(dynamicObject.getString("name"), preResult);
        }
        return result;
    }

    private static Map<Long, DynamicObject> getCurrentCoopData(List<DynamicObject> entryEntity) {
        HashSet coopOrgTeamIds = Sets.newHashSetWithExpectedSize((int)(entryEntity.size() << 2));
        for (DynamicObject dynamicObject : entryEntity) {
            DynamicObjectCollection coops = dynamicObject.getDynamicObjectCollection(COOP_REL_ENTRY_ENTITY);
            for (DynamicObject coop : coops) {
                coopOrgTeamIds.add(coop.getLong(COOPORGTEAM_BOID));
            }
        }
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] coopOrgTeamDys = ADMIN_ORG_TEAM_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)coopOrgTeamIds), filter});
        Map<Long, DynamicObject> coopOrgTeamMaps = Arrays.stream(coopOrgTeamDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        return coopOrgTeamMaps;
    }

    public static Set<DynamicObject> checkSameTypeCollaborationUnique(DynamicObject entity) {
        DynamicObjectCollection cooprelentryentity = entity.getDynamicObjectCollection(COOP_REL_ENTRY_ENTITY);
        HashSet result = Sets.newHashSetWithExpectedSize((int)cooprelentryentity.size());
        Map coopRelTypMap = cooprelentryentity.stream().collect(Collectors.groupingBy(item -> item.getLong(COOPRELTYP_ID), Collectors.toList()));
        for (List value : coopRelTypMap.values()) {
            if (value.size() <= 1) continue;
            result.add(value.get(0));
        }
        return result;
    }

    public static List<Deque<CycleCheckBean>> checkCollaborationCycle(List<DynamicObject> toBeCheckEntity, List<DynamicObject> allEntity, java.util.Date effectdate, List<Long> deleteEntity, boolean checkNew, DynamicObject[] effctiveData, List<DynamicObject> inProgressData, Map<Long, java.util.Date> effdtMap) {
        boolean effectiveDataNotNull;
        ArrayList<CycleCheckBean> emptyList;
        if (CollectionUtils.isEmpty(toBeCheckEntity)) {
            return new ArrayList<Deque<CycleCheckBean>>(1);
        }
        long start = System.currentTimeMillis();
        int parentRowSize = toBeCheckEntity.size();
        ArrayList result = Lists.newArrayListWithCapacity((int)parentRowSize);
        java.util.Date today = DEFAULT_END_DATE;
        effectdate = effectdate == null ? today : OrgBatchValidateHelper.formatDate(effectdate);
        List<CycleCheckBean> otherTwoEntityCoopRel = OrgBatchValidateHelper.packageOtherCoopRelData(allEntity, effectdate, today);
        HashMap coopRelEntryEntityMap = Maps.newHashMapWithExpectedSize((int)parentRowSize);
        for (DynamicObject dynamicObject : toBeCheckEntity) {
            DynamicObjectCollection coopRelEntryEntity = dynamicObject.getDynamicObjectCollection(COOP_REL_ENTRY_ENTITY);
            DynamicObject org = dynamicObject.getDynamicObject(ADMINORG);
            if (org == null) continue;
            DynamicObject orgDyn = new DynamicObject(org.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)org, (DynamicObject)orgDyn);
            orgDyn.set("name", (Object)dynamicObject.getString("name"));
            orgDyn.set("id", (Object)dynamicObject.getLong("id"));
            coopRelEntryEntityMap.put(orgDyn, coopRelEntryEntity);
        }
        ArrayList currentBillData = Lists.newArrayListWithCapacity((int)(parentRowSize << 3));
        OrgBatchValidateHelper.packageCurrentBillData(effectdate, coopRelEntryEntityMap, today, currentBillData);
        if (checkNew) {
            inProgressData = null;
            effctiveData = null;
        }
        ArrayList<CycleCheckBean> effectiveDataList = emptyList = new ArrayList<CycleCheckBean>(1);
        boolean bl = effectiveDataNotNull = effctiveData != null && effctiveData.length > 0;
        if (effectiveDataNotNull) {
            List<Long> currentBillOrgId = OrgBatchValidateHelper.findWillFailureDateInEffectiveDate(currentBillData, otherTwoEntityCoopRel);
            OrgBatchValidateHelper.packageEffectiveData(effctiveData, effectiveDataList, currentBillOrgId);
        }
        boolean inProgressDataNotNull = CollectionUtils.isNotEmpty(inProgressData);
        List<CycleCheckBean> inProgressDataList = emptyList;
        inProgressDataList = OrgBatchValidateHelper.packageInProgressData(today, inProgressData, inProgressDataNotNull, inProgressDataList, effdtMap);
        List<CycleCheckBean> allDataList = OrgBatchValidateHelper.uninData(effectiveDataList, effectiveDataNotNull, currentBillData, inProgressDataNotNull, inProgressDataList, otherTwoEntityCoopRel);
        OrgBatchValidateHelper.removeDeleteData(deleteEntity, allDataList);
        long min = System.currentTimeMillis();
        OrgBatchValidateHelper.checkCycle(result, currentBillData, allDataList);
        LOG.info(String.format("==checkCollaborationCycle== prepareTime:%s", min - start));
        LOG.info(String.format("==checkCollaborationCycle== checkCycleTime:%s", System.currentTimeMillis() - min));
        return result;
    }

    private static List<Long> findWillFailureDateInEffectiveDate(List<CycleCheckBean> currentBillData, List<CycleCheckBean> otherTwoEntityCoopRel) {
        ArrayList currentBillOrgId = Lists.newArrayListWithCapacity((int)(otherTwoEntityCoopRel.size() + currentBillData.size()));
        for (CycleCheckBean currentBillDatum : currentBillData) {
            currentBillOrgId.add(currentBillDatum.getCheckTarget().getLong("boid"));
        }
        for (CycleCheckBean currentBillDatum : otherTwoEntityCoopRel) {
            currentBillOrgId.add(currentBillDatum.getCheckTarget().getLong("boid"));
        }
        return currentBillOrgId;
    }

    private static void packageEffectiveData(DynamicObject[] effctiveData, List<CycleCheckBean> effectiveDataList, List<Long> currentBillOrgId) {
        List effectList = Arrays.asList(effctiveData).stream().filter(dynamicObject -> dynamicObject.get("org") != null).collect(Collectors.toList());
        for (DynamicObject dynamicObject2 : effectList) {
            DynamicObject org = dynamicObject2.getDynamicObject("org");
            if (currentBillOrgId.contains(org.getLong("boid"))) continue;
            DynamicObject parent = dynamicObject2.getDynamicObject(COOP_ORG_TEAM);
            DynamicObject type = dynamicObject2.getDynamicObject(COOP_REL_TYPE);
            if (parent == null || type == null) continue;
            CycleCheckBean cycleCheckBean = new CycleCheckBean();
            cycleCheckBean.setBsed(OrgBatchValidateHelper.formatDate(dynamicObject2.getDate(BSED)));
            cycleCheckBean.setBsled(OrgBatchValidateHelper.formatDate(dynamicObject2.getDate(BSLED)));
            cycleCheckBean.setCheckTarget(org);
            cycleCheckBean.setParent(parent);
            cycleCheckBean.setCoopType(type);
            cycleCheckBean.setDataSource("effectiveData");
            effectiveDataList.add(cycleCheckBean);
        }
    }

    private static void removeDeleteData(List<Long> deleteOrgBoid, List<CycleCheckBean> allDataList) {
        if (CollectionUtils.isEmpty(deleteOrgBoid)) {
            return;
        }
        ArrayList<CycleCheckBean> deleteCoopRel = new ArrayList<CycleCheckBean>(16);
        for (CycleCheckBean bean : allDataList) {
            DynamicObject parent = bean.getParent();
            if (!deleteOrgBoid.contains(bean.getCheckTarget().getLong("boid")) && !deleteOrgBoid.contains(parent.getLong("boid"))) continue;
            deleteCoopRel.add(bean);
        }
        if (CollectionUtils.isEmpty(deleteCoopRel)) {
            allDataList.removeAll(deleteCoopRel);
        }
    }

    private static void checkCycle(List<Deque<CycleCheckBean>> result, List<CycleCheckBean> currentBillData, List<CycleCheckBean> allDataList) {
        Map coopRelTypeMap = allDataList.stream().collect(Collectors.groupingBy(item -> item.getCoopType().getLong("id"), Collectors.toList()));
        for (CycleCheckBean coopData : currentBillData) {
            Map<Long, List<CycleCheckBean>> coopInfoByTime;
            Deque<CycleCheckBean> cycleStack;
            Long coopreltypId = coopData.getCoopType().getLong("id");
            List sameCoopTypeList = coopRelTypeMap.get(coopreltypId);
            if (CollectionUtils.isEmpty(sameCoopTypeList) || (cycleStack = OrgBatchValidateHelper.getCycleStack(coopInfoByTime = sameCoopTypeList.stream().collect(Collectors.groupingBy(item -> item.getCheckTarget().getLong("boid"), Collectors.toList())), coopData)) == null) continue;
            result.add(cycleStack);
        }
    }

    private static List<CycleCheckBean> packageOtherCoopRelData(List<DynamicObject> otherTwoEntity, java.util.Date effectDate, java.util.Date today) {
        if (CollectionUtils.isNotEmpty(otherTwoEntity)) {
            ArrayList otherTwoEntityCoopRel = Lists.newArrayListWithCapacity((int)(otherTwoEntity.size() << 3));
            for (DynamicObject dynamicObject : otherTwoEntity) {
                DynamicObject adminOrg = dynamicObject.getDynamicObject(ADMINORG);
                if (adminOrg == null) continue;
                DynamicObjectCollection coopRelEntryEntity = dynamicObject.getDynamicObjectCollection(COOP_REL_ENTRY_ENTITY);
                for (DynamicObject coop : coopRelEntryEntity) {
                    if (coop.getDynamicObject(COOP_ORG_TEAM) == null || coop.getDynamicObject(COOPRE_LTYP) == null) continue;
                    CycleCheckBean cycleCheckBean = new CycleCheckBean();
                    cycleCheckBean.setBsed(effectDate);
                    cycleCheckBean.setBsled(today);
                    cycleCheckBean.setCheckTarget(adminOrg);
                    cycleCheckBean.setParent(coop.getDynamicObject(COOP_ORG_TEAM));
                    cycleCheckBean.setCoopType(coop.getDynamicObject(COOPRE_LTYP));
                    cycleCheckBean.setDataSource("currentBill");
                    otherTwoEntityCoopRel.add(cycleCheckBean);
                }
            }
            return otherTwoEntityCoopRel;
        }
        return new ArrayList<CycleCheckBean>(0);
    }

    private static List<CycleCheckBean> packageInProgressData(java.util.Date today, List<DynamicObject> inProgressData, boolean inProgressDataNotNull, List<CycleCheckBean> inProgressDataList, Map<Long, java.util.Date> effdtMap) {
        if (inProgressDataNotNull) {
            inProgressDataList = Lists.newArrayListWithCapacity((int)inProgressData.size());
            for (DynamicObject inProgressDatum : inProgressData) {
                DynamicObjectCollection cooprelentryentity = inProgressDatum.getDynamicObjectCollection(COOP_REL_ENTRY_ENTITY);
                DynamicObject org = inProgressDatum.getDynamicObject(ADMINORG);
                if (HRObjectUtils.isEmpty((Object)org)) continue;
                DynamicObject orgDyn = new DynamicObject(org.getDynamicObjectType());
                HRDynamicObjectUtils.copy((DynamicObject)org, (DynamicObject)orgDyn);
                orgDyn.set("id", (Object)org.getLong("boid"));
                for (DynamicObject dynamicObject : cooprelentryentity) {
                    DynamicObject parent = dynamicObject.getDynamicObject(COOP_ORG_TEAM);
                    DynamicObject type = dynamicObject.getDynamicObject(COOPRE_LTYP);
                    if (parent == null || type == null || effdtMap.get(dynamicObject.getLong("id")) == null) continue;
                    DynamicObject newParent = new DynamicObject(parent.getDynamicObjectType());
                    HRDynamicObjectUtils.copy((DynamicObject)parent, (DynamicObject)newParent);
                    newParent.set("id", (Object)org.getLong("boid"));
                    CycleCheckBean cycleCheckBean = new CycleCheckBean();
                    cycleCheckBean.setBsed(OrgBatchValidateHelper.formatDate(effdtMap.get(dynamicObject.getLong("id"))));
                    cycleCheckBean.setBsled(today);
                    cycleCheckBean.setCheckTarget(orgDyn);
                    cycleCheckBean.setParent(newParent);
                    cycleCheckBean.setCoopType(type);
                    cycleCheckBean.setDataSource("inProgress");
                    inProgressDataList.add(cycleCheckBean);
                }
            }
        }
        return inProgressDataList;
    }

    private static void packageCurrentBillData(java.util.Date effectdate, Map<DynamicObject, List<DynamicObject>> coopRelEntryEntityMap, java.util.Date today, List<CycleCheckBean> currentBillData) {
        for (Map.Entry<DynamicObject, List<DynamicObject>> dynamicObjectListEntry : coopRelEntryEntityMap.entrySet()) {
            ArrayList cycleCheckBeans = Lists.newArrayListWithCapacity((int)dynamicObjectListEntry.getValue().size());
            DynamicObject org = dynamicObjectListEntry.getKey();
            for (DynamicObject dynamicObject : dynamicObjectListEntry.getValue()) {
                if (dynamicObject.getDynamicObject(COOP_ORG_TEAM) == null || dynamicObject.getDynamicObject(COOPRE_LTYP) == null) continue;
                CycleCheckBean cycleCheckBean = new CycleCheckBean();
                cycleCheckBean.setBsed(effectdate);
                cycleCheckBean.setBsled(today);
                cycleCheckBean.setCheckTarget(org);
                cycleCheckBean.setParent(dynamicObject.getDynamicObject(COOP_ORG_TEAM));
                cycleCheckBean.setCoopType(dynamicObject.getDynamicObject(COOPRE_LTYP));
                cycleCheckBean.setDataSource("currentBill");
                cycleCheckBeans.add(cycleCheckBean);
            }
            currentBillData.addAll(cycleCheckBeans);
        }
    }

    private static List<CycleCheckBean> uninData(List<CycleCheckBean> effctiveDataList, boolean effctiveDataNotNull, List<CycleCheckBean> currentBillData, boolean inProgressDataNotNull, List<CycleCheckBean> inProgressDataList, List<CycleCheckBean> twoOtherDataList) {
        boolean twoOtherDataNotNull;
        int size = currentBillData.size();
        if (effctiveDataNotNull) {
            size += effctiveDataList.size();
        }
        if (inProgressDataNotNull) {
            size += inProgressDataList.size();
        }
        if (twoOtherDataNotNull = CollectionUtils.isNotEmpty(twoOtherDataList)) {
            size += twoOtherDataList.size();
        }
        ArrayList allDataList = Lists.newArrayListWithCapacity((int)size);
        allDataList.addAll(currentBillData);
        if (effctiveDataNotNull) {
            allDataList.addAll(effctiveDataList);
        }
        if (inProgressDataNotNull) {
            allDataList.addAll(inProgressDataList);
        }
        if (twoOtherDataNotNull) {
            allDataList.addAll(twoOtherDataList);
        }
        return allDataList;
    }

    public static Deque<CycleCheckBean> getCycleStack(Map<Long, List<CycleCheckBean>> coopInfoByTime, CycleCheckBean coopData) {
        ArrayDeque<CycleCheckBean> stack = new ArrayDeque<CycleCheckBean>();
        stack.push(coopData);
        Long orgBoId = coopData.getCheckTarget().getLong("boid");
        HashSet visited = Sets.newHashSetWithExpectedSize((int)coopInfoByTime.size());
        boolean hasCycle = false;
        long[] overlappingDate = new long[2];
        block0: while (!stack.isEmpty() && !hasCycle) {
            CycleCheckBean current = (CycleCheckBean)stack.pop();
            if (current == coopData) {
                overlappingDate = new long[2];
            }
            Long parentId = current.getParent().getLong("boid");
            List parents = coopInfoByTime.getOrDefault(parentId, new ArrayList(0));
            for (CycleCheckBean parent : parents) {
                if (!visited.add(parent) || !OrgBatchValidateHelper.hasTimeOverlapping(current, parent, overlappingDate)) continue;
                if (orgBoId.equals(parent.getCheckTarget().getLong("boid"))) {
                    hasCycle = true;
                    stack.push(current);
                    continue block0;
                }
                stack.push(current);
                stack.push(parent);
            }
        }
        return hasCycle ? stack : null;
    }

    private static boolean hasTimeOverlapping(CycleCheckBean current, CycleCheckBean dynamicObject, long[] overlappingDate) {
        boolean result;
        long currentStart = current.getBsed().getTime();
        long currentEnd = current.getBsled().getTime();
        long dyStart = dynamicObject.getBsed().getTime();
        long dyEnd = dynamicObject.getBsled().getTime();
        if (overlappingDate[0] != 0L && overlappingDate[1] != 0L) {
            currentStart = overlappingDate[0];
            currentEnd = overlappingDate[1];
        }
        boolean bl = result = dyEnd >= currentStart && dyStart <= currentEnd;
        if (result) {
            Long repeatTimeStart = Math.max(currentStart, dyStart);
            Long repeatTimeEnd = Math.min(currentEnd, dyEnd);
            overlappingDate[0] = repeatTimeStart;
            overlappingDate[1] = repeatTimeEnd;
        }
        return result;
    }

    public static DynamicObject[] queryEffectiveData(HRBaseServiceHelper serviceHelper, List<Long> reportcoreltypeIds, java.util.Date today, java.util.Date effectdate) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter typeFilter = new QFilter(COOP_REL_TYPE, "in", reportcoreltypeIds);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"}).and("iscurrentversion", "=", (Object)"0");
        QFilter dateFilter = new QFilter(BSED, "<=", (Object)today).and(new QFilter(BSLED, ">=", (Object)effectdate));
        return serviceHelper.query("id,bsed,bsled,cooporgteam,cooporgteam.id,cooporgteam.boid,cooporgteam.number,cooporgteam.name,org,org.id,org.boid,org.number,org.name,coopreltype,coopreltype.id,coopreltype.name,coopreltype.number", new QFilter[]{enableFilter, typeFilter, statusFilter, dateFilter});
    }

    public static java.util.Date formatDate(java.util.Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return format.parse(format.format(date));
        }
        catch (ParseException e) {
            LOG.error((Throwable)e);
            return new java.util.Date();
        }
    }

    public static Map<String, Set<Long>> getBaseDataIdsByHrOrgBuID(Collection<String> entityTypes, long orgId) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)entityTypes.size());
        entityTypes.forEach(entityType -> {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityType);
            result.put(entityType, Arrays.stream(helper.query("id", new QFilter[]{BaseDataServiceHelper.getBaseDataFilter((String)entityType, (Long)orgId)})).map(dy -> dy.getLong("id")).collect(Collectors.toSet()));
        });
        return result;
    }
}

