/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.helper;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.bean.StrategyChangeBo;
import kd.hr.haos.business.service.adminorg.strategy.OrgStrategyService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class OrgStrategyHelper {
    public static final String ADMIN_ORG_BO_ID_TAG_FROM_BILL = "adminorg.boid";
    public static final String PARENT_ORG_BO_ID_TAG_FROM_BILL = "parentorg.boid";

    public static void addStrategy4BatchModify(List<DynamicObject> orgList) {
        List adminOrgBoIdList = orgList.stream().map(dyn -> dyn.getLong(ADMIN_ORG_BO_ID_TAG_FROM_BILL)).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
        QFilter adminBoIdOrgFilter = new QFilter("adminorg", "in", adminOrgBoIdList);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObjectCollection sortAdminOrgColl = serviceHelper.queryOriginalCollection("adminorg.boid,adminorg.parentorg.boid parentorg.boid", new QFilter[]{adminBoIdOrgFilter, currentVersionFilter}, "level");
        List collect = sortAdminOrgColl.stream().map(OrgStrategyHelper::convert4BatchModify).collect(Collectors.toList());
        OrgStrategyService.getInstance().addOrgStrategy(collect);
    }

    public static void changeStrategy4BatchModify(List<DynamicObject> orgList) {
        QFilter idFilter = new QFilter("id", "in", orgList.stream().map(dy -> dy.getLong("adminorg.id")).collect(Collectors.toList()));
        DynamicObjectCollection preDynamicObjectCollection = QueryServiceHelper.query((String)"haos_adminorgdetail", (String)"id, boid, parentorg.id, adminorgtype.adminorgtypestd.id", (QFilter[])new QFilter[]{idFilter});
        Map<Long, DynamicObject> idVsDy = preDynamicObjectCollection.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        List strategyChangeBoList = orgList.stream().map(newAdminOrg -> OrgStrategyHelper.convert4BatchModify(newAdminOrg, (DynamicObject)idVsDy.get(newAdminOrg.getLong(ADMIN_ORG_BO_ID_TAG_FROM_BILL)))).filter(Objects::nonNull).filter(model -> model.isParentChange() || model.isOrgTypeChange()).collect(Collectors.toList());
        OrgStrategyService.getInstance().changeOrgStrategy(strategyChangeBoList);
    }

    public static void changeStrategyModify(DynamicObject oldDy, DynamicObject newDy) {
        StrategyChangeBo bo = OrgStrategyHelper.convertModify(oldDy, newDy);
        if (bo.isParentChange() || bo.isOrgTypeChange()) {
            OrgStrategyService.getInstance().changeOrgStrategy(Collections.singletonList(bo));
        }
    }

    public static void disableStrategy4BatchModify(List<DynamicObject> orgList) {
        OrgStrategyService.getInstance().disableOrgStrategy(orgList.stream().map(dy -> dy.getLong(ADMIN_ORG_BO_ID_TAG_FROM_BILL)).collect(Collectors.toList()));
    }

    public static void enableStrategy4BatchModify(List<DynamicObject> orgList) {
        OrgStrategyService.getInstance().enableOrgStrategy(orgList.stream().map(dy -> dy.getLong(ADMIN_ORG_BO_ID_TAG_FROM_BILL)).collect(Collectors.toList()));
    }

    private static DynamicObject convert4BatchModify(DynamicObject newAdminOrg) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_adminorghr");
        DynamicObject adminOrg = hrBaseServiceHelper.generateEmptyDynamicObject();
        DynamicObject parentOrg = hrBaseServiceHelper.generateEmptyDynamicObject();
        parentOrg.set("id", newAdminOrg.get(PARENT_ORG_BO_ID_TAG_FROM_BILL));
        adminOrg.set("id", (Object)newAdminOrg.getLong(ADMIN_ORG_BO_ID_TAG_FROM_BILL));
        adminOrg.set("parent", (Object)parentOrg);
        return adminOrg;
    }

    private static StrategyChangeBo convert4BatchModify(DynamicObject newAdminOrg, DynamicObject oldAdminOrg) {
        long oldOrgType;
        long newOrgType;
        if (newAdminOrg == null || oldAdminOrg == null) {
            return null;
        }
        StrategyChangeBo strategyChangeBo = new StrategyChangeBo();
        strategyChangeBo.setOrgTeamId(newAdminOrg.getLong(ADMIN_ORG_BO_ID_TAG_FROM_BILL));
        strategyChangeBo.setParentChange(false);
        strategyChangeBo.setOrgTypeChange(false);
        long newParent = newAdminOrg.getLong(PARENT_ORG_BO_ID_TAG_FROM_BILL);
        long oldParent = oldAdminOrg.getLong("parentorg.id");
        if (newParent != oldParent) {
            strategyChangeBo.setParentChange(true);
            strategyChangeBo.setParentOrgTeamId(newParent);
        }
        if ((newOrgType = newAdminOrg.getLong("adminorgtype.adminorgtypestd.id")) != (oldOrgType = oldAdminOrg.getLong("adminorgtype.adminorgtypestd.id"))) {
            strategyChangeBo.setOrgTypeChange(true);
            strategyChangeBo.setOldOrgTypeId(oldOrgType);
            strategyChangeBo.setOrgTypeId(newOrgType);
        }
        return strategyChangeBo;
    }

    private static StrategyChangeBo convertModify(DynamicObject oldAdminOrg, DynamicObject newAdminOrg) {
        long oldOrgType;
        long newOrgType;
        StrategyChangeBo bo = new StrategyChangeBo();
        bo.setOrgTeamId(oldAdminOrg.getLong("boid"));
        long newParent = newAdminOrg.getLong(PARENT_ORG_BO_ID_TAG_FROM_BILL);
        if (newParent != oldAdminOrg.getLong(PARENT_ORG_BO_ID_TAG_FROM_BILL)) {
            bo.setParentChange(true);
            bo.setParentOrgTeamId(newParent);
        }
        if ((newOrgType = newAdminOrg.getLong("adminorgtype.adminorgtypestd.id")) != (oldOrgType = oldAdminOrg.getLong("adminorgtype.adminorgtypestd.id"))) {
            bo.setOrgTypeChange(true);
            bo.setOldOrgTypeId(oldOrgType);
            bo.setOrgTypeId(newOrgType);
        }
        return bo;
    }
}

