/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.CycleOrgBean;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgAffiliationCheckServiceImpl
implements IOrgBatchBillCheckService {
    private static final Log LOGGER = LogFactory.getLog(OrgAffiliationCheckServiceImpl.class);

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        String changeType = cacheModel.getChangeType();
        Long orgBoId = targetObject.getLong("adminorg.boid");
        if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.addEntry.getChangeType()) || HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.parentEntry.getChangeType())) {
            List<CycleOrgBean> adminOrgList;
            Map<Long, List<CycleOrgBean>> adminCyCleMap;
            if (PlatformRootUtils.getLongRootIdOfPlatform() == orgBoId || 0L == orgBoId) {
                return result;
            }
            Date effectDate = cacheModel.getEffectDate();
            Long parentOrgBoId = targetObject.getLong("parentorg.boid");
            CycleOrgBean cycleOrg = this.assembleCurrentCycleOrg(orgBoId, parentOrgBoId, effectDate);
            Deque<CycleOrgBean> adminCycleOrgs = OrgBatchBillCheckHelper.containsCycle(cycleOrg, adminCyCleMap = (adminOrgList = OrgBatchBillCheckHelper.queryAdminOrgColl(cacheModel.getEffectDate())).stream().collect(Collectors.groupingBy(CycleOrgBean::getOrgId, Collectors.toList())), true);
            if (!CollectionUtils.isEmpty(adminCycleOrgs)) {
                result.add(new CalibratorBean("OrgAffiliationCheckServiceImpl_1", ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u6216\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgAffiliationCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
            Long orgId = targetObject.getLong("adminorg.id");
            Long parentOrgId = targetObject.getLong("parentorg.id");
            CycleOrgBean currentCycleOrg = this.assembleCurrentCycleOrg(orgId, parentOrgId, effectDate);
            DynamicObjectCollection currentOrgColl = cacheModel.getCurrentOrgColl();
            ArrayList ownOrgList = Lists.newArrayListWithCapacity((int)currentOrgColl.size());
            currentOrgColl.forEach(dy -> ownOrgList.add(new CycleOrgBean(HRDyObjectPropUtil.getId((DynamicObject)dy.getDynamicObject("adminorg")), HRDyObjectPropUtil.getId((DynamicObject)dy.getDynamicObject("parentorg")))));
            Map<Long, List<CycleOrgBean>> ownCyCleMap = ownOrgList.stream().collect(Collectors.groupingBy(CycleOrgBean::getOrgId, Collectors.toList()));
            Deque<CycleOrgBean> ownCycleOrgs = OrgBatchBillCheckHelper.containsCycle(currentCycleOrg, ownCyCleMap, false);
            if (!CollectionUtils.isEmpty(ownCycleOrgs)) {
                result.add(new CalibratorBean("OrgAffiliationCheckServiceImpl_2", ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u672c\u5355\u4e2d\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgAffiliationCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
                LOGGER.info("OrgAffiliationCheckServiceImpl own bill org contain cycle:{}", JSONObject.toJSON(ownCycleOrgs));
            }
            List<OrgBatchCheckDto> billOrgList = cacheModel.getBillOrgList();
            ArrayList billCycleOrgList = Lists.newArrayListWithCapacity((int)billOrgList.size());
            billOrgList.forEach(dto -> billCycleOrgList.add(new CycleOrgBean(dto.getOrgId(), dto.getBillNo(), dto.getParentOrgId())));
            Map<Long, List<CycleOrgBean>> billCyCleMap = billCycleOrgList.stream().collect(Collectors.groupingBy(CycleOrgBean::getOrgId, Collectors.toList()));
            Deque<CycleOrgBean> billCycleOrgs = OrgBatchBillCheckHelper.containsCycle(currentCycleOrg, billCyCleMap, false);
            if (!CollectionUtils.isEmpty(billCycleOrgs) && !HRStringUtils.isEmpty((String)billCycleOrgs.getFirst().getBillNo())) {
                result.add(new CalibratorBean("OrgAffiliationCheckServiceImpl_3", ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u5728\u9014\u5355\u636e\u201c%s\u201d\u4e2d\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgAffiliationCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{billCycleOrgs.getFirst().getBillNo()}));
                LOGGER.info("OrgAffiliationCheckServiceImpl on bill org contain cycle:{}", JSONObject.toJSON(billCycleOrgs));
            }
        }
        return result;
    }

    private CycleOrgBean assembleCurrentCycleOrg(Long orgId, Long parentOrgId, Date effectDate) {
        CycleOrgBean cycleOrg = new CycleOrgBean();
        cycleOrg.setOrgId(orgId);
        cycleOrg.setCoopOrgId(parentOrgId);
        cycleOrg.setBsed(effectDate);
        Date bsled = new Date();
        try {
            bsled = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            LOGGER.error("parseDate error:", (Throwable)e);
        }
        cycleOrg.setBsled(bsled);
        return cycleOrg;
    }
}

