/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.CycleOrgBean;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgBatchAffiliationCheckServiceImpl
implements IOrgBatchBillCheckService {
    private static final Log LOGGER = LogFactory.getLog(OrgBatchAffiliationCheckServiceImpl.class);
    private OrgBatchCheckCacheModel cacheModel;
    private Map<String, String> multiEntryNameMap;
    private Map<Long, List<CycleOrgBean>> adminCyCleMap;
    private Map<Long, List<CycleOrgBean>> billCyCleMap;

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        long startTime = System.currentTimeMillis();
        this.cacheModel = cacheModel;
        this.initParam();
        long initTime = System.currentTimeMillis();
        LOGGER.info(String.format("OrgBatchAffiliationCheckServiceImpl init time:%s", initTime - startTime));
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        List<String> entryKeys = EntryEntityEnum.getEntryKeys();
        for (String entryKey : entryKeys) {
            if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.infoEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.disableEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.mergeEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.splitEntry.getEntryKey())) continue;
            DynamicObjectCollection orgColl = targetObject.getDynamicObjectCollection(entryKey);
            String entryName = this.multiEntryNameMap.get(entryKey);
            for (DynamicObject dynamicObject : orgColl) {
                this.checkOrgAffiliation(entryName, dynamicObject, result);
                if (CollectionUtils.isEmpty(result)) continue;
                return result;
            }
        }
        LOGGER.info(String.format("OrgBatchAffiliationCheckServiceImpl check time:%s", System.currentTimeMillis() - initTime));
        return result;
    }

    private void checkOrgAffiliation(String entryName, DynamicObject dynamicObject, List<CalibratorBean> result) {
        Long parentOrgId;
        CycleOrgBean currentCycleOrg;
        Deque<CycleOrgBean> billCycleOrgs;
        Long parentOrgBoId;
        CycleOrgBean cycleOrg;
        Deque<CycleOrgBean> adminCycleOrgs;
        String orgName = dynamicObject.getString("name");
        Long orgId = dynamicObject.getLong("adminorg.id");
        Long boid = dynamicObject.getLong("adminorg.boid");
        long changeTypeId = dynamicObject.getLong("changescene.orgchangetype.id");
        if (changeTypeId == 1010L && this.cacheModel.getOperateType() == 2) {
            boid = orgId = Long.valueOf(dynamicObject.getLong("adminorg"));
        }
        if (!CollectionUtils.isEmpty(adminCycleOrgs = OrgBatchBillCheckHelper.containsCycle(cycleOrg = this.assembleCycleOrg(boid, parentOrgBoId = Long.valueOf(dynamicObject.getLong("parentorg.boid"))), this.adminCyCleMap, true))) {
            LOGGER.info("OrgBatchAffiliationCheckServiceImpl org contain cycle:{}", JSONObject.toJSON(adminCycleOrgs));
            for (CycleOrgBean bean : adminCycleOrgs) {
                if (HRStringUtils.equals((String)"admin", (String)bean.getDataSource())) {
                    result.add(new CalibratorBean("OrgBatchAffiliationCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchAffiliationCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName}));
                    return;
                }
                if (!HRStringUtils.equals((String)"own", (String)bean.getDataSource())) continue;
                result.add(new CalibratorBean("OrgBatchAffiliationCheckServiceImpl_3", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u4e0d\u80fd\u9009\u62e9\u672c\u5355\u4e2d\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchAffiliationCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName}));
                return;
            }
        }
        if (!CollectionUtils.isEmpty(billCycleOrgs = OrgBatchBillCheckHelper.containsCycle(currentCycleOrg = this.assembleCycleOrg(orgId, parentOrgId = Long.valueOf(dynamicObject.getLong("parentorg.id"))), this.billCyCleMap, false)) && !HRStringUtils.isEmpty((String)billCycleOrgs.getFirst().getBillNo())) {
            result.add(new CalibratorBean("OrgBatchAffiliationCheckServiceImpl_2", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u4e0d\u80fd\u9009\u62e9\u5728\u9014\u5355\u636e\u201c%3$s\u201d\u4e2d\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchAffiliationCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, billCycleOrgs.getFirst().getBillNo()}));
            LOGGER.info("OrgBatchAffiliationCheckServiceImpl own bill org contain cycle:{}", JSONObject.toJSON(billCycleOrgs));
        }
    }

    private void initParam() {
        this.multiEntryNameMap = OrgBatchBillCheckHelper.assembleMultiEntryName();
        List<CycleOrgBean> adminOrgList = OrgBatchBillCheckHelper.queryAdminOrgColl(this.cacheModel.getEffectDate());
        this.cacheModel.getOwnEnableOrgList().forEach(dto -> adminOrgList.add(this.assembleCycleOrg(dto.getOrgBoId(), dto.getParentOrgBoId())));
        this.adminCyCleMap = adminOrgList.stream().collect(Collectors.groupingBy(CycleOrgBean::getOrgId, Collectors.toList()));
        List<OrgBatchCheckDto> billOrgList = this.cacheModel.getBillOrgList();
        ArrayList billCycleOrgList = Lists.newArrayListWithCapacity((int)billOrgList.size());
        billOrgList.forEach(dto -> billCycleOrgList.add(new CycleOrgBean(dto.getOrgId(), dto.getParentOrgId(), "bill", dto.getBillNo())));
        this.billCyCleMap = billCycleOrgList.stream().collect(Collectors.groupingBy(CycleOrgBean::getOrgId, Collectors.toList()));
    }

    private CycleOrgBean assembleCycleOrg(Long orgId, Long parentOrgId) {
        CycleOrgBean cycleOrg = new CycleOrgBean();
        cycleOrg.setOrgId(orgId);
        cycleOrg.setCoopOrgId(parentOrgId);
        cycleOrg.setBsed(this.cacheModel.getEffectDate());
        Date bsled = new Date();
        try {
            bsled = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            LOGGER.error("parseDate error:", (Throwable)e);
        }
        cycleOrg.setBsled(bsled);
        cycleOrg.setDataSource("own");
        return cycleOrg;
    }
}

