/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.UserProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.utils.PatternUtil;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hrmp.hbpm.business.utils.DynamicConvertUtils;

public class OrgBatchBillSaveHelper
implements OrgBatchChgBillConstants {
    private static OrgBatchBillSaveHelper INSTANCE = new OrgBatchBillSaveHelper();
    private static final Log logger = LogFactory.getLog(OrgBatchBillSaveHelper.class);
    private static String COMPANY = "conpany";
    private static String GROUP = "group";
    private static String DEPARTMENT = "department";
    String COOP_REL_TYPE = "coopreltype";
    private static String[] mergeProp = new String[]{"billid", "beforemergeorgid", "aftermergeorgid", "adminorg", "number", "adminorgboid", "name", "parentorg", "simplename", "adminorgtype", "establishmentdate", "corporateorg", "tobedisableflag", "adminorglayer", "adminorgfunction", "companyarea", "city", "workplace", "detailaddress", "index", "org", "description", "changetype", "changescene", "changereason", "changedescription", "mergesplitstatus", "creator"};
    private static String[] splitProp = new String[]{"billid", "aftersplitorgid", "beforesplitorgid", "adminorg", "number", "adminorgboid", "name", "parentorg", "simplename", "adminorgtype", "establishmentdate", "corporateorg", "tobedisableflag", "adminorglayer", "adminorgfunction", "companyarea", "city", "workplace", "detailaddress", "index", "org", "description", "changetype", "changescene", "changereason", "changedescription", "mergesplitstatus", "creator"};
    private static Map<String, String> type2Dyn = new HashMap<String, String>(){
        {
            this.put("merge", "merge_target_org");
            this.put("split", "to_split_org");
        }
    };
    private static Map<String, String> type2DynCollection = new HashMap<String, String>(){
        {
            this.put("merge", "to_merge_org");
            this.put("split", "split_target_org");
        }
    };
    private static Map<String, String[]> type2PropArray = new HashMap<String, String[]>(){
        {
            this.put("merge", mergeProp);
            this.put("split", splitProp);
        }
    };
    private static Map<String, Long> type2ChangeType = new HashMap<String, Long>(){
        {
            this.put("merge", OrgBatchChgBillConstants.CHANGE_TYPE_MERGE);
            this.put("split", OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT);
        }
    };
    private static String[] mergeAndSplit = new String[]{"merge", "split"};

    public static OrgBatchBillSaveHelper getInstance() {
        return INSTANCE;
    }

    public void orgBatchBillSave(DynamicObject dataEntity) {
        long startTime = System.currentTimeMillis();
        this.formatAndSetCreatime(dataEntity);
        HRBaseServiceHelper batchOrgEntityHelper = new HRBaseServiceHelper("homs_batchorgentity");
        Long billId = dataEntity.getLong("id");
        QFilter billIdFilter = new QFilter("billid", "=", (Object)billId);
        QFilter changeTypeFilter = new QFilter("changetype", "in", Arrays.asList(OrgBatchChgBillConstants.CHANGE_TYPE_MERGE, OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT));
        batchOrgEntityHelper.deleteByFilter(new QFilter[]{billIdFilter, changeTypeFilter});
        List<DynamicObject> needSaveMergeSplitEntries = this.saveMergeAndSplitEntryEntity(batchOrgEntityHelper, dataEntity);
        DynamicObject[] batchOrgEntityDyns = batchOrgEntityHelper.loadDynamicObjectArray(new QFilter[]{billIdFilter});
        Set adminOrgIdSetFromDB = Arrays.stream(batchOrgEntityDyns).map(dyn -> dyn.getLong("adminorg.id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> adminOrgId2DynFromDBMap = Arrays.stream(batchOrgEntityDyns).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg.id"), dyn -> dyn));
        DynamicObjectCollection allEntryEntityDynFromPage = this.getEntryEntityDataFromPage(dataEntity);
        if (allEntryEntityDynFromPage.size() == 0 && needSaveMergeSplitEntries.size() == 0) {
            return;
        }
        List<Long> adminOrgIdListFromPage = this.getAllEntryAdminOrgId(allEntryEntityDynFromPage);
        Map<Long, DynamicObject> orgId2BasicInfoDynMap = AdminOrgBatchChgHelper.getOrgId2BasicInfoDynMapByIds(adminOrgIdListFromPage);
        List<Long> boIdList = orgId2BasicInfoDynMap.values().stream().map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> orgBoId2CoopDynsMap = AdminOrgBatchChgHelper.getOrgId2CoopDynsMap(boIdList);
        Map<Long, DynamicObject> orgBoId2CompanyDynMap = AdminOrgBatchChgHelper.getOrgId2CompanyDynMap(boIdList);
        Map<Long, DynamicObject> orgBoId2GroupDynMap = AdminOrgBatchChgHelper.getOrgId2GroupDynMap(boIdList);
        Map<Long, DynamicObject> orgBoId2DepartmentDynMapDynMap = AdminOrgBatchChgHelper.getOrgId2DepartmentDynMap(boIdList);
        ArrayList needSaveEntryDynList = Lists.newArrayListWithExpectedSize((int)allEntryEntityDynFromPage.size());
        for (DynamicObject entryEntityDynFromPage : allEntryEntityDynFromPage) {
            boolean neeSave;
            DynamicObject batchOrgEntryDyn;
            String prefix;
            Long adminOrgId = this.getAdminOrgId(entryEntityDynFromPage, prefix = this.getPrefixFromEntryEntityDyn(entryEntityDynFromPage));
            if (adminOrgIdSetFromDB.contains(adminOrgId)) {
                batchOrgEntryDyn = adminOrgId2DynFromDBMap.get(adminOrgId);
            } else {
                batchOrgEntryDyn = batchOrgEntityHelper.generateEmptyDynamicObject();
                batchOrgEntryDyn.set("billid", (Object)dataEntity.getLong("id"));
                Long changeTypeId = BillEntryHelperEnum.getChangeTypeIdByPrefix(prefix);
                batchOrgEntryDyn.set("mergesplitstatus", (Object)"2");
                batchOrgEntryDyn.set("changetype", (Object)changeTypeId);
                DynamicObject basicInfoDyn = orgId2BasicInfoDynMap.get(adminOrgId);
                long adminOrgBoid = basicInfoDyn.getLong("boid");
                String adminOrgTypeFieldName = this.spliceTwoStringByUnderLine(prefix, "adminorgtype.adminorgtypestd.id");
                Long adminOrgTypeId = entryEntityDynFromPage.getLong(adminOrgTypeFieldName);
                Map<String, DynamicObject> groupInfoMap = this.buildGroupMap4OrgType(adminOrgTypeId, adminOrgBoid, orgBoId2CompanyDynMap, orgBoId2GroupDynMap, orgBoId2DepartmentDynMapDynMap);
                List<DynamicObject> coopDynList = orgBoId2CoopDynsMap.get(adminOrgBoid);
                this.assembleSaveEntryDyn(batchOrgEntryDyn, adminOrgId, basicInfoDyn, groupInfoMap, coopDynList);
            }
            if (!(neeSave = this.coverdEntryValue(batchOrgEntryDyn, entryEntityDynFromPage, prefix)) && adminOrgIdSetFromDB.contains(adminOrgId)) continue;
            needSaveEntryDynList.add(batchOrgEntryDyn);
        }
        if (needSaveEntryDynList.isEmpty()) {
            logger.info("needSaveEntryDynList is empty");
        }
        this.resetSequence(needSaveEntryDynList);
        this.setToBeDisableDate(dataEntity, needSaveEntryDynList, orgId2BasicInfoDynMap);
        this.setAdminOrgBoId(needSaveEntryDynList, orgId2BasicInfoDynMap);
        needSaveEntryDynList.addAll(needSaveMergeSplitEntries);
        if (needSaveEntryDynList.isEmpty()) {
            logger.info("needSaveEntryDynList is empty after add needSaveMergeSplitEntries");
            return;
        }
        batchOrgEntityHelper.save(needSaveEntryDynList.toArray(new DynamicObject[0]));
        billIdFilter.and("adminorg.id", "=", (Object)0);
        batchOrgEntityHelper.deleteByFilter(billIdFilter.toArray());
        logger.info(String.format(Locale.ROOT, "orgBatchBillSave() time cost is: %s", System.currentTimeMillis() - startTime));
    }

    private boolean compare(IDataEntityProperty prop, String prefix, DynamicObject dynamicObject, DynamicObject sourceDynamic) {
        boolean same = true;
        try {
            String col = prop.getName();
            String entryFieldName = this.spliceTwoStringByUnderLine(prefix, col);
            IDataEntityProperty entryProp = (IDataEntityProperty)sourceDynamic.getDynamicObjectType().getProperties().get((Object)entryFieldName);
            if (entryProp == null || entryProp.getClass() != prop.getClass()) {
                logger.error("type filter:{}", (Object)col);
                return true;
            }
            if ("oriparentorg_name".equals(col) || "parentorg_name".equals(col)) {
                logger.error("field filter ex:{}", (Object)col);
                return true;
            }
            if (prop instanceof MuliLangTextProp) {
                ILocaleString data = dynamicObject.getLocaleString(col);
                ILocaleString sourceData = sourceDynamic.getLocaleString(entryFieldName);
                same = DynamicConvertUtils.compareMulLangTextCol((ILocaleString)data, (ILocaleString)sourceData);
                if (ObjectUtils.isEmpty((Object)data) && !ObjectUtils.isEmpty((Object)sourceData)) {
                    return sourceData.values().stream().filter(val -> val != null && val.length() > 0 && !" ".equals(val)).collect(Collectors.toSet()).isEmpty();
                }
                if (!ObjectUtils.isEmpty((Object)data) && ObjectUtils.isEmpty((Object)sourceData)) {
                    return data.values().stream().filter(val -> val != null && val.length() > 0 && !" ".equals(val)).collect(Collectors.toSet()).isEmpty();
                }
            } else if (prop instanceof UserProp) {
                Object data = dynamicObject.get(col);
                Object sourceData = sourceDynamic.get(entryFieldName);
                Long dataId = 0L;
                Long sourceDataId = 0L;
                if (data instanceof DynamicObject) {
                    dataId = ((DynamicObject)data).getLong("id");
                } else if (data instanceof Long) {
                    dataId = (Long)data;
                }
                if (sourceData instanceof DynamicObject) {
                    sourceDataId = ((DynamicObject)sourceData).getLong("id");
                } else if (sourceData instanceof Long) {
                    sourceDataId = (Long)sourceData;
                }
                same = DynamicConvertUtils.compareCommonCol((Object)dataId, (Object)sourceDataId);
            } else if (prop instanceof BasedataProp) {
                Object data = dynamicObject.get(col);
                Object sourceData = sourceDynamic.get(entryFieldName);
                Long dataId = 0L;
                Long sourceDataId = 0L;
                if (data instanceof DynamicObject) {
                    dataId = ((DynamicObject)data).getLong("id");
                } else if (data instanceof Long) {
                    dataId = (Long)data;
                }
                if (sourceData instanceof DynamicObject) {
                    sourceDataId = ((DynamicObject)sourceData).getLong("id");
                } else if (sourceData instanceof Long) {
                    sourceDataId = (Long)sourceData;
                }
                same = dataId != null && dataId.equals(sourceDataId);
            } else if (prop instanceof DynamicObjectCollection) {
                DynamicObjectCollection data = dynamicObject.getDynamicObjectCollection(col);
                DynamicObjectCollection sourceData = sourceDynamic.getDynamicObjectCollection(entryFieldName);
                same = DynamicConvertUtils.compareDynaCollectCol((DynamicObjectCollection)data, (DynamicObjectCollection)sourceData);
            } else if (prop instanceof DateProp || prop instanceof DateTimeProp) {
                Date data = dynamicObject.getDate(col);
                Date sourceData = sourceDynamic.getDate(entryFieldName);
                same = DynamicConvertUtils.compareDateCol((Date)data, (Date)sourceData);
            } else {
                Object data = dynamicObject.get(col);
                Object sourceData = sourceDynamic.get(entryFieldName);
                same = DynamicConvertUtils.compareCommonCol((Object)data, (Object)sourceData);
            }
        }
        catch (Exception exception) {
            logger.error("compare ex:{}", (Object)prop, (Object)exception);
        }
        return same;
    }

    private List<DynamicObject> saveMergeAndSplitEntryEntity(HRBaseServiceHelper batchOrgEntityHelper, DynamicObject dataEntity) {
        ArrayList resultDynamicObjectList = Lists.newArrayListWithExpectedSize((int)16);
        Map<Long, Long> boIdToId = this.getBoIdToIdMap(dataEntity);
        for (String entryName : mergeAndSplit) {
            DynamicObjectCollection mergeEntities = dataEntity.getDynamicObjectCollection("entryentity_" + entryName);
            for (DynamicObject dy : mergeEntities) {
                DynamicObject dynamicObject = batchOrgEntityHelper.generateEmptyDynamicObject();
                DynamicObjectCollection toMergeOrg = dy.getDynamicObjectCollection(type2DynCollection.get(entryName));
                DynamicObject mergeTargetOrg = dy.getDynamicObject(type2Dyn.get(entryName));
                for (DynamicObject org : toMergeOrg) {
                    DynamicObject dynOb = batchOrgEntityHelper.generateEmptyDynamicObject();
                    DynamicObject fBaseDataId = org.getDynamicObject("fbasedataid");
                    List<Object> values = Arrays.asList(dataEntity.getLong("id"), fBaseDataId.getLong("id"), mergeTargetOrg.getLong("id"), fBaseDataId.getLong("id"), fBaseDataId.get("number"), fBaseDataId.getLong("boid"), fBaseDataId.get("name"), boIdToId.get(fBaseDataId.getLong("parentorg.id")), fBaseDataId.get("simplename"), fBaseDataId.get("adminorgtype"), fBaseDataId.get("establishmentdate"), fBaseDataId.get("corporateorg"), fBaseDataId.get("tobedisableflag"), fBaseDataId.get("adminorglayer"), fBaseDataId.get("adminorgfunction"), fBaseDataId.get("companyarea"), fBaseDataId.get("city"), fBaseDataId.get("workplace"), fBaseDataId.get("detailaddress"), fBaseDataId.get("index"), dataEntity.getLong("org.id"), fBaseDataId.get("description"), type2ChangeType.get(entryName), dy.getLong(entryName + "_changescene.id"), dy.getLong(entryName + "_changereason.id"), dy.get(entryName + "_changedescription"), "2", RequestContext.get().getCurrUserId());
                    for (int idx = 0; idx < type2PropArray.get(entryName).length; ++idx) {
                        dynOb.set(type2PropArray.get(entryName)[idx], values.get(idx));
                    }
                    resultDynamicObjectList.add(dynOb);
                }
                List<Object> values = Arrays.asList(dataEntity.getLong("id"), 0, mergeTargetOrg.getLong("id"), mergeTargetOrg.getLong("id"), mergeTargetOrg.get("number"), mergeTargetOrg.getLong("boid"), mergeTargetOrg.get("name"), boIdToId.get(mergeTargetOrg.getLong("parentorg.id")), mergeTargetOrg.get("simplename"), mergeTargetOrg.get("adminorgtype"), mergeTargetOrg.get("establishmentdate"), mergeTargetOrg.get("corporateorg"), mergeTargetOrg.get("tobedisableflag"), mergeTargetOrg.get("adminorglayer"), mergeTargetOrg.get("adminorgfunction"), mergeTargetOrg.get("companyarea"), mergeTargetOrg.get("city"), mergeTargetOrg.get("workplace"), mergeTargetOrg.get("detailaddress"), mergeTargetOrg.get("index"), dataEntity.getLong("org.id"), mergeTargetOrg.get("description"), type2ChangeType.get(entryName), dy.getLong(entryName + "_changescene.id"), dy.getLong(entryName + "_changereason.id"), dy.get(entryName + "_changedescription"), "2", RequestContext.get().getCurrUserId());
                for (int idx = 0; idx < type2PropArray.get(entryName).length; ++idx) {
                    dynamicObject.set(type2PropArray.get(entryName)[idx], values.get(idx));
                }
                resultDynamicObjectList.add(dynamicObject);
            }
        }
        return resultDynamicObjectList;
    }

    private Map<Long, Long> getBoIdToIdMap(DynamicObject dataEntity) {
        DynamicObject[] orgDyById;
        HashSet allParenBoIds = Sets.newHashSetWithExpectedSize((int)16);
        for (String entryName : mergeAndSplit) {
            DynamicObjectCollection mergeEntities = dataEntity.getDynamicObjectCollection("entryentity_" + entryName);
            for (DynamicObject dy : mergeEntities) {
                DynamicObjectCollection toMergeOrg = dy.getDynamicObjectCollection(type2DynCollection.get(entryName));
                DynamicObject mergeTargetOrg = dy.getDynamicObject(type2Dyn.get(entryName));
                for (DynamicObject org : toMergeOrg) {
                    DynamicObject fBaseDataId = org.getDynamicObject("fbasedataid");
                    allParenBoIds.add(fBaseDataId.getLong("parentorg.id"));
                }
                allParenBoIds.add(mergeTargetOrg.getLong("parentorg.id"));
            }
        }
        Map<Long, Long> boIdToId = new HashMap<Long, Long>(16);
        if (allParenBoIds.size() != 0 && (orgDyById = AdminOrgBatchChgHelper.getOrgDyById("id,sourcevid", new ArrayList<Long>(allParenBoIds))) != null && orgDyById.length != 0) {
            boIdToId = Arrays.stream(orgDyById).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("sourcevid"), (v1, v2) -> v1));
        }
        return boIdToId;
    }

    private void resetSequence(List<DynamicObject> needSaveEntryDynList) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        needSaveEntryDynList.stream().forEach(dyn -> {
            long changeTypeId = dyn.getLong("changetype.id");
            if (changeTypeId == 0L) {
                changeTypeId = dyn.getLong("changetype");
            }
            if (Objects.isNull(map.get(changeTypeId))) {
                dyn.set("sequence", (Object)1);
                map.put(changeTypeId, 1);
            } else {
                Integer sequence;
                Integer n = sequence = (Integer)map.get(changeTypeId);
                Integer n2 = sequence = Integer.valueOf(sequence + 1);
                dyn.set("sequence", (Object)sequence);
                map.put(changeTypeId, sequence);
            }
        });
    }

    private Long getAdminOrgId(DynamicObject entryEntityDynFromPage, String prefix) {
        String adminOrgFiledName = this.spliceTwoStringByUnderLine(prefix, "adminorg.id");
        return entryEntityDynFromPage.getLong(adminOrgFiledName);
    }

    private String getPrefixFromEntryEntityDyn(DynamicObject entryEntityDynFromPage) {
        String entryEntityName = entryEntityDynFromPage.getDynamicObjectType().getName();
        int underLineIndex = entryEntityName.indexOf("_");
        return entryEntityName.substring(underLineIndex + 1);
    }

    public void assembleSaveEntryDyn(DynamicObject batchOrgEntryDyn, Long adminOrgId, DynamicObject basicInfoDyn, Map<String, DynamicObject> groupInfoMap, List<DynamicObject> coopDynList) {
        DataEntityPropertyCollection properties = batchOrgEntryDyn.getDataEntityType().getProperties();
        batchOrgEntryDyn.set("adminorg", (Object)adminOrgId);
        batchOrgEntryDyn.set("name", basicInfoDyn.get("name"));
        batchOrgEntryDyn.set("simplename", basicInfoDyn.get("simplename"));
        batchOrgEntryDyn.set("number", basicInfoDyn.get("number"));
        batchOrgEntryDyn.set("orgid", (Object)adminOrgId);
        batchOrgEntryDyn.set("adminorgtype", (Object)basicInfoDyn.getLong("adminorgtype.id"));
        batchOrgEntryDyn.set("parentorg", (Object)basicInfoDyn.getLong("parentorg.id"));
        batchOrgEntryDyn.set("establishmentdate", basicInfoDyn.get("establishmentdate"));
        batchOrgEntryDyn.set("adminorglayer", basicInfoDyn.get("adminorglayer"));
        batchOrgEntryDyn.set("corporateorg", basicInfoDyn.get("corporateorg"));
        batchOrgEntryDyn.set("adminorgfunction", basicInfoDyn.get("adminorgfunction"));
        batchOrgEntryDyn.set("companyarea", basicInfoDyn.get("companyarea"));
        batchOrgEntryDyn.set("city", basicInfoDyn.get("city"));
        batchOrgEntryDyn.set("workplace", basicInfoDyn.get("workplace"));
        batchOrgEntryDyn.set("detailaddress", basicInfoDyn.get("detailaddress"));
        batchOrgEntryDyn.set("index", (Object)this.getOrgIndex(basicInfoDyn.getInt("index"), basicInfoDyn));
        batchOrgEntryDyn.set("description", basicInfoDyn.get("description"));
        batchOrgEntryDyn.set("positioning", basicInfoDyn.get("positioning"));
        batchOrgEntryDyn.set("mainduty", basicInfoDyn.get("mainduty"));
        batchOrgEntryDyn.set("safelevel", basicInfoDyn.get("safelevel"));
        batchOrgEntryDyn.set("safetype", basicInfoDyn.get("safetype"));
        batchOrgEntryDyn.set("safedescription", basicInfoDyn.get("safedescription"));
        batchOrgEntryDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
        this.setCoopInfo(batchOrgEntryDyn, coopDynList);
        this.setGroupInfo(batchOrgEntryDyn, groupInfoMap);
        for (IDataEntityProperty property : properties) {
            if (!PatternUtil.isExProperty(property.getName())) continue;
            Object obj = basicInfoDyn.get(property.getName());
            if (obj instanceof MulBasedataDynamicObjectCollection) {
                logger.info("assembleSaveEntryDyn the property name is {}", (Object)property.getName());
                DynamicObjectCollection doc = (DynamicObjectCollection)obj;
                MulBasedataProp baseDataProp = (MulBasedataProp)MetadataServiceHelper.getDataEntityType((String)"homs_batchorgentity").getProperty(property.getName());
                DynamicObjectCollection entireProcessCollection = new DynamicObjectCollection();
                for (DynamicObject cooOrgId : doc) {
                    DynamicObject dy = new DynamicObject(baseDataProp.getDynamicCollectionItemPropertyType());
                    dy.set("fbasedataid", cooOrgId.get("fbasedataid"));
                    entireProcessCollection.add((Object)dy);
                }
                batchOrgEntryDyn.set(property.getName(), (Object)entireProcessCollection);
                continue;
            }
            batchOrgEntryDyn.set(property.getName(), basicInfoDyn.get(property.getName()));
        }
    }

    public Map<String, DynamicObject> buildGroupMap4OrgType(Long adminOrgTypeId, long adminOrgBoid, Map<Long, DynamicObject> orgBoId2CompanyDynMap, Map<Long, DynamicObject> orgBoId2GroupDynMap, Map<Long, DynamicObject> orgBoId2DepartmentDynMapDynMap) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        if (adminOrgTypeId == 1010L) {
            DynamicObject conpanyDyn = orgBoId2CompanyDynMap.get(adminOrgBoid);
            map.put(COMPANY, conpanyDyn);
            DynamicObject groupDyn = orgBoId2GroupDynMap.get(adminOrgBoid);
            map.put(GROUP, groupDyn);
        } else if (adminOrgTypeId == 1020L) {
            DynamicObject conpanyDyn = orgBoId2CompanyDynMap.get(adminOrgBoid);
            map.put(COMPANY, conpanyDyn);
        } else if (adminOrgTypeId == 1040L) {
            DynamicObject departMentDyn = orgBoId2DepartmentDynMapDynMap.get(adminOrgBoid);
            map.put(DEPARTMENT, departMentDyn);
        }
        return map;
    }

    private void setGroupInfo(DynamicObject batchOrgEntryDyn, Map<String, DynamicObject> groupInfoMap) {
        DynamicObject groupInfoDyn = groupInfoMap.get(GROUP);
        DynamicObject conpanyInfoDyn = groupInfoMap.get(COMPANY);
        DynamicObject departmentInfoDyn = groupInfoMap.get(DEPARTMENT);
        if (groupInfoDyn != null) {
            batchOrgEntryDyn.set("groupvision", groupInfoDyn.get("groupvision"));
            batchOrgEntryDyn.set("groupleader", groupInfoDyn.get("groupleader"));
            batchOrgEntryDyn.set("groupmission", groupInfoDyn.get("groupmission"));
        }
        if (conpanyInfoDyn != null) {
            batchOrgEntryDyn.set("companytype", conpanyInfoDyn.get("companytype"));
            batchOrgEntryDyn.set("industrytype", conpanyInfoDyn.get("industrytype"));
        }
        if (departmentInfoDyn != null) {
            batchOrgEntryDyn.set("departmenttype", departmentInfoDyn.get("departmenttype"));
        }
    }

    private DynamicObjectCollection getEntryEntityDataFromPage(DynamicObject dataEntity) {
        List<String> entryEncludeAddName = BillEntryHelperEnum.getEntryNameExcludeAdd();
        DynamicObjectCollection dynColl = new DynamicObjectCollection();
        entryEncludeAddName.stream().forEach(entryName -> dynColl.addAll((Collection)dataEntity.getDynamicObjectCollection(entryName)));
        return dynColl;
    }

    private List<Long> getAllEntryAdminOrgId(DynamicObjectCollection allEntryEntityDynsFromPage) {
        ArrayList adminOrgIdListFromPage = Lists.newArrayListWithExpectedSize((int)allEntryEntityDynsFromPage.size());
        allEntryEntityDynsFromPage.stream().forEach(dyn -> {
            String prefix = this.getPrefixFromEntryEntityDyn((DynamicObject)dyn);
            Long adminOrgId = this.getAdminOrgId((DynamicObject)dyn, prefix);
            adminOrgIdListFromPage.add(adminOrgId);
        });
        return adminOrgIdListFromPage;
    }

    private void setToBeDisableDate(DynamicObject dataEntity, List<DynamicObject> needSaveEntryDynList, Map<Long, DynamicObject> orgId2BasicInfoDynMap) {
        needSaveEntryDynList.forEach(needSaveEntryDyn -> {
            long adminOrgId;
            DynamicObject basicInfoDyn;
            boolean toBeDisableFlag4Master;
            boolean toBeDisableFlag = needSaveEntryDyn.getBoolean("tobedisableflag");
            if (toBeDisableFlag != (toBeDisableFlag4Master = (basicInfoDyn = (DynamicObject)orgId2BasicInfoDynMap.get(adminOrgId = needSaveEntryDyn.getLong("adminorg.id"))).getBoolean("tobedisableflag"))) {
                if (toBeDisableFlag) {
                    needSaveEntryDyn.set("tobedisabledate", (Object)dataEntity.getDate("effdt"));
                } else {
                    needSaveEntryDyn.set("tobedisabledate", null);
                }
            }
        });
    }

    private void setAdminOrgBoId(List<DynamicObject> needSaveEntryDynList, Map<Long, DynamicObject> orgId2BasicInfoDynMap) {
        needSaveEntryDynList.forEach(entryDyn -> {
            long adminOrgId = entryDyn.getLong("adminorg.id");
            DynamicObject basicInfoDyn = (DynamicObject)orgId2BasicInfoDynMap.get(adminOrgId);
            entryDyn.set("adminorgboid", (Object)basicInfoDyn.getLong("boid"));
        });
    }

    private void formatAndSetCreatime(DynamicObject dataEntity) {
        Date createTime = AdminOrgHisDynamicUtils.dateWithoutTime((Date)dataEntity.getDate("createtime"));
        dataEntity.set("createtime", (Object)createTime);
    }

    private boolean coverdEntryValue(DynamicObject batchOrgEntityDyn, DynamicObject entryEntity, String prefix) {
        boolean needSave = false;
        List<String> entryEntryFields = BillEntryHelperEnum.getEntryListByPrefix(prefix);
        DataEntityPropertyCollection props = batchOrgEntityDyn.getDataEntityType().getProperties();
        for (String entryEntryField : entryEntryFields) {
            if (entryEntryField.equals("id")) {
                batchOrgEntityDyn.set(entryEntryField, entryEntity.get("id"));
                continue;
            }
            IDataEntityProperty prop = (IDataEntityProperty)props.get((Object)entryEntryField);
            if (prop != null && !this.compare(prop, prefix, batchOrgEntityDyn, entryEntity)) {
                needSave = true;
            }
            String entryFieldName = this.spliceTwoStringByUnderLine(prefix, entryEntryField);
            batchOrgEntityDyn.set(entryEntryField, entryEntity.get(entryFieldName));
        }
        DataEntityPropertyCollection properties = entryEntity.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (!PatternUtil.isExProperty(property.getName())) continue;
            IDataEntityProperty prop = (IDataEntityProperty)props.get((Object)property.getName().substring(prefix.length() + 1));
            if (prop != null && !this.compare(prop, prefix, batchOrgEntityDyn, entryEntity)) {
                needSave = true;
            }
            batchOrgEntityDyn.set(property.getName().substring(prefix.length() + 1), entryEntity.get(property.getName()));
        }
        return needSave;
    }

    private void setCoopInfo(DynamicObject batchOrgEntryDyn, List<DynamicObject> coopDynList) {
        if (!CollectionUtils.isEmpty(coopDynList)) {
            DynamicObjectCollection cooprelentryentityColl = new DynamicObjectCollection();
            HRBaseServiceHelper orgChgBillEntryHelper = new HRBaseServiceHelper("homs_batchorgentity");
            for (int i = 0; i < coopDynList.size(); ++i) {
                DynamicObject orgCoopInfo = coopDynList.get(i);
                DynamicObject cooprelentryEntity = orgChgBillEntryHelper.generateEmptyEntryDynamicObject("cooprelentryentity");
                cooprelentryEntity.set("seq", (Object)i);
                cooprelentryEntity.set("coopreltyp", (Object)this.getDynFieldLong(orgCoopInfo, this.COOP_REL_TYPE));
                cooprelentryEntity.set("cooporgteam", (Object)this.getDynFieldLong(orgCoopInfo, "cooporgteam"));
                cooprelentryEntity.set("cooprelid", (Object)orgCoopInfo.getLong("id"));
                cooprelentryentityColl.add((Object)cooprelentryEntity);
            }
            batchOrgEntryDyn.set("cooprelentryentity", (Object)cooprelentryentityColl);
        }
    }

    private Long getDynFieldLong(DynamicObject dyn, String field) {
        if (Objects.nonNull(dyn.getDynamicObject(field))) {
            return dyn.getLong(field + ".id");
        }
        return 0L;
    }

    private int getOrgIndex(Integer index, DynamicObject orgMasterInfo) {
        if (index == null || index < 1 || index > 99999) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
            QFilter qFilter = new QFilter("parentorg", "=", (Object)orgMasterInfo.getLong("parentorg.id")).and("id", "!=", (Object)orgMasterInfo.getLong("id")).and("iscurrentversion", "=", (Object)"1");
            DynamicObjectCollection dynamicObjects = serviceHelper.queryOriginalCollection("id, parentorg.id, index", qFilter.toArray());
            index = 1;
            if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                for (DynamicObject dy : dynamicObjects) {
                    if (dy.getInt("index") < index || index >= 100000) continue;
                    index = dy.getInt("index") + 1;
                }
            }
        }
        return index;
    }

    private String spliceTwoStringByUnderLine(String oneString, String otherString) {
        return oneString + "_" + otherString;
    }

    public static void setOrgNumber(List<DynamicObject> addDys, List<DynamicObject> adminorgHrDys, List<String> numberList) {
        if (!CollectionUtils.isEmpty(numberList)) {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
            QFilter qFilter = new QFilter("number", "in", numberList);
            DynamicObject[] numberDys = hrBaseServiceHelper.query("number", new QFilter[]{qFilter});
            if (numberDys.length == 0) {
                return;
            }
            Set numberSet = Arrays.stream(numberDys).map(dynamicObject -> dynamicObject.getString("number")).collect(Collectors.toSet());
            Iterator<DynamicObject> iterator = adminorgHrDys.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = iterator.next();
                String number = next.getString("number");
                if (numberSet.contains(number)) continue;
                iterator.remove();
            }
            OrgBatchBillSaveHelper.setOrgNumber(addDys, adminorgHrDys, new ArrayList<String>(adminorgHrDys.size()));
        } else {
            List numbers = CodeRuleServiceHelper.getNumbers((String)"haos_adminorghr", adminorgHrDys);
            HashMap numberMap = new HashMap(adminorgHrDys.size());
            for (int i = 0; i < numbers.size(); ++i) {
                numberMap.put(adminorgHrDys.get(i).getLong("id"), numbers.get(i));
            }
            addDys.stream().forEach(addDy -> {
                Long entityId = addDy.getLong("id");
                if (numberMap.containsKey(entityId)) {
                    addDy.set("number", numberMap.get(entityId));
                }
            });
            adminorgHrDys.stream().forEach(adminorgHrDy -> {
                Long entityId = adminorgHrDy.getLong("id");
                if (numberMap.containsKey(entityId)) {
                    adminorgHrDy.set("number", numberMap.get(entityId));
                }
            });
            OrgBatchBillSaveHelper.setOrgNumber(addDys, adminorgHrDys, numbers);
        }
    }
}

