/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgBatchChgFeasibleCheckServiceImpl
implements IOrgBatchBillCheckService {
    private Map<Long, String> changeTypeIdNameMap;
    private Set<OrgBatchCheckDto> billOrgSet;
    private Set<Long> ownOrgIdReSet;
    private Set<Long> currentDisableOrgIdSet;
    private Map<Long, Long> boIdOrgIdMap;
    private static final String[] MERGE_SPLIT_ENTRY = new String[]{"entryentity_merge", "entryentity_split"};
    private static final List<Long> CHANGE_TYPE_LIST = Arrays.asList(OrgBatchChgBillConstants.CHANGE_TYPE_PARENT, OrgBatchChgBillConstants.CHANGE_TYPE_INFO, OrgBatchChgBillConstants.CHANGE_TYPE_MERGE, OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT);

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        List<OrgBatchCheckDto> ownEnableOrgList = cacheModel.getOwnEnableOrgList();
        HashSet ownOrgIdSet = Sets.newHashSetWithExpectedSize((int)ownEnableOrgList.size());
        HashSet ownBoIdSet = Sets.newHashSetWithExpectedSize((int)ownEnableOrgList.size());
        for (OrgBatchCheckDto orgBatchCheckDto : ownEnableOrgList) {
            ownOrgIdSet.add(orgBatchCheckDto.getOrgId());
            ownBoIdSet.add(orgBatchCheckDto.getOrgBoId());
        }
        DynamicObject originalDynamicObject = cacheModel.getOriginalDynamicObject();
        for (String entryEntryEntity : MERGE_SPLIT_ENTRY) {
            if (originalDynamicObject == null) break;
            for (DynamicObject dynamicObject : originalDynamicObject.getDynamicObjectCollection(entryEntryEntity)) {
                DynamicObjectCollection toMergeOrg = dynamicObject.getDynamicObjectCollection("entryentity_merge".equals(entryEntryEntity) ? "to_merge_org" : "split_target_org");
                DynamicObject mergeTargetOrg = dynamicObject.getDynamicObject("entryentity_merge".equals(entryEntryEntity) ? "merge_target_org" : "to_split_org");
                for (DynamicObject mergeOrg : toMergeOrg) {
                    ownOrgIdSet.add(mergeOrg.getDynamicObject("fbasedataid").getLong("id"));
                    ownBoIdSet.add(mergeOrg.getDynamicObject("fbasedataid").getLong("boid"));
                }
                ownOrgIdSet.add(mergeTargetOrg.getLong("id"));
                ownBoIdSet.add(mergeTargetOrg.getLong("boid"));
            }
        }
        Long l = cacheModel.getCurrentBillId();
        this.changeTypeIdNameMap = OrgBatchBillCheckHelper.queryBaseDataInfo("haos_orgchangetype", "id,name");
        this.billOrgSet = cacheModel.getBillOrgList().stream().filter(dto -> !currentBillId.equals(dto.getBillId())).filter(dto -> ownOrgIdSet.contains(dto.getOrgId())).collect(Collectors.toSet());
        this.ownOrgIdReSet = Sets.newHashSetWithExpectedSize((int)10);
        Map<Long, List<OrgBatchCheckDto>> ownOrgIdMap = ownEnableOrgList.stream().filter(dto -> !OrgBatchBillCheckHelper.isValidateOrgId(dto.getOrgId())).collect(Collectors.groupingBy(OrgBatchCheckDto::getOrgId));
        ownOrgIdMap.forEach((k, v) -> {
            if (v.size() > 1) {
                this.ownOrgIdReSet.add((Long)k);
            }
        });
        this.currentDisableOrgIdSet = OrgBatchBillCheckHelper.queryCurrentDisableOrgIdSet(ownBoIdSet);
        this.boIdOrgIdMap = OrgBatchBillCheckHelper.queryNewBoIdOrgIdMap(ownBoIdSet);
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        List<String> entryKeys = EntryEntityEnum.getEntryKeys();
        for (String entryKey : entryKeys) {
            if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.parentEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.infoEntry.getEntryKey())) {
                DynamicObjectCollection orgColl = targetObject.getDynamicObjectCollection(entryKey);
                for (DynamicObject dynamicObject : orgColl) {
                    this.checkParentChg(entryKey, dynamicObject, result);
                    this.checkInfoChg(entryKey, dynamicObject, result);
                }
            }
            if (!HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.mergeEntry.getEntryKey()) && !HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.splitEntry.getEntryKey())) continue;
            this.checkMergeAndSplit(entryKey, result, cacheModel);
        }
        this.inThisBillCheck(result, cacheModel);
        this.inThisBillRowCheck(result, cacheModel);
        return result;
    }

    private void checkMergeAndSplit(String entryKey, List<CalibratorBean> result, OrgBatchCheckCacheModel cacheModel) {
        boolean isMerge = HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.mergeEntry.getEntryKey());
        DynamicObject originalDynamicObject = cacheModel.getOriginalDynamicObject();
        if (originalDynamicObject == null) {
            return;
        }
        DynamicObjectCollection entryentityMerge = originalDynamicObject.getDynamicObjectCollection(isMerge ? "entryentity_merge" : "entryentity_split");
        for (DynamicObject dynamicObject : entryentityMerge) {
            Long newOrgId;
            DynamicObjectCollection toMergeOrg = dynamicObject.getDynamicObjectCollection(isMerge ? "to_merge_org" : "split_target_org");
            ArrayList disabledToMergeOrg = Lists.newArrayListWithExpectedSize((int)16);
            for (DynamicObject dyn : toMergeOrg) {
                Long newOrgId2;
                long boId = dyn.getDynamicObject("fbasedataid").getLong("boid");
                String orgName = dyn.getDynamicObject("fbasedataid").getString("name");
                long orgId = dyn.getDynamicObject("fbasedataid").getLong("id");
                if (this.currentDisableOrgIdSet.contains(boId) || !HRStringUtils.equals((String)"1", (String)dyn.getDynamicObject("fbasedataid").getString("enable"))) {
                    disabledToMergeOrg.add(orgName);
                }
                if (!Objects.isNull(newOrgId2 = this.boIdOrgIdMap.get(boId)) && !newOrgId2.equals(orgId)) {
                    result.add(new CalibratorBean(isMerge ? "OrgBatchChgFeasibleCheckServiceImpl_12" : "OrgBatchChgFeasibleCheckServiceImpl_16", isMerge ? ResManager.loadKDString((String)"\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u5f53\u524d\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u57fa\u4e8e\u6700\u65b0\u7684\u4fe1\u606f\u8fdb\u884c\u8c03\u6574\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_12", (String)"odc-homs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u5f53\u524d\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u57fa\u4e8e\u6700\u65b0\u7684\u4fe1\u606f\u8fdb\u884c\u8c03\u6574\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_16", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName}));
                }
                if (!isMerge && cacheModel.getOwnDisableOrgIdMap().containsKey(orgId)) {
                    result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_25", ResManager.loadKDString((String)"\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u7ec4\u7ec7\u201c%2$s\u201d\u5df2\u5b58\u5728\u505c\u7528\u7ec4\u7ec7\u4e2d\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u5230\u505c\u7528\u7ec4\u7ec7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_25", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, orgName}));
                }
                this.inBillCheck(isMerge, result, orgName, boId);
            }
            if (disabledToMergeOrg.size() != 0) {
                result.add(new CalibratorBean(isMerge ? "OrgBatchChgFeasibleCheckServiceImpl_13" : "OrgBatchChgFeasibleCheckServiceImpl_17", isMerge ? ResManager.loadKDString((String)"\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u5408\u5e76\u7ec4\u7ec7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_13", (String)"odc-homs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u7ec4\u7ec7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_17", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{String.join((CharSequence)",", disabledToMergeOrg)}));
            }
            DynamicObject mergeTargetOrg = dynamicObject.getDynamicObject(isMerge ? "merge_target_org" : "to_split_org");
            long boId = mergeTargetOrg.getLong("boid");
            String orgName = mergeTargetOrg.getString("name");
            long orgId = mergeTargetOrg.getLong("id");
            if (this.currentDisableOrgIdSet.contains(boId) || !HRStringUtils.equals((String)"1", (String)mergeTargetOrg.getString("enable"))) {
                result.add(new CalibratorBean(isMerge ? "OrgBatchChgFeasibleCheckServiceImpl_13" : "OrgBatchChgFeasibleCheckServiceImpl_17", isMerge ? ResManager.loadKDString((String)"\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u5408\u5e76\u7ec4\u7ec7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_13", (String)"odc-homs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u7ec4\u7ec7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_17", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName}));
            }
            if (!Objects.isNull(newOrgId = this.boIdOrgIdMap.get(boId)) && !newOrgId.equals(orgId)) {
                result.add(new CalibratorBean(isMerge ? "OrgBatchChgFeasibleCheckServiceImpl_12" : "OrgBatchChgFeasibleCheckServiceImpl_16", isMerge ? ResManager.loadKDString((String)"\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u5f53\u524d\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u57fa\u4e8e\u6700\u65b0\u7684\u4fe1\u606f\u8fdb\u884c\u8c03\u6574\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_12", (String)"odc-homs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u5f53\u524d\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u57fa\u4e8e\u6700\u65b0\u7684\u4fe1\u606f\u8fdb\u884c\u8c03\u6574\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_16", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName}));
            }
            if (isMerge && cacheModel.getOwnDisableOrgIdMap().containsKey(orgId)) {
                result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_24", ResManager.loadKDString((String)"\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u7ec4\u7ec7\u201c%2$s\u201d\u5df2\u5b58\u5728\u505c\u7528\u7ec4\u7ec7\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5408\u5e76\u5230\u505c\u7528\u7ec4\u7ec7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_24", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, orgName}));
            }
            this.inBillCheck(isMerge, result, orgName, boId);
        }
    }

    private void inBillCheck(boolean isMerge, List<CalibratorBean> result, String orgName, long orgId) {
        for (OrgBatchCheckDto dto : this.billOrgSet) {
            long billOrgId = dto.getOrgBoId();
            String billNo = dto.getBillNo();
            long changeTypeId = dto.getChangeTypeId();
            String changeTypeNm = this.changeTypeIdNameMap.get(changeTypeId);
            if (!HRStringUtils.isEmpty((String)billNo) && billOrgId == orgId && changeTypeId == OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE) {
                result.add(new CalibratorBean(isMerge ? "OrgBatchChgFeasibleCheckServiceImpl_14" : "OrgBatchChgFeasibleCheckServiceImpl_18", isMerge ? ResManager.loadKDString((String)"\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5408\u5e76\u7ec4\u7ec7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_14", (String)"odc-homs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u7ec4\u7ec7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_18", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billNo, changeTypeNm}));
            }
            if (HRStringUtils.isEmpty((String)billNo) || billOrgId != orgId || !CHANGE_TYPE_LIST.contains(changeTypeId)) continue;
            result.add(new CalibratorBean(isMerge ? "OrgBatchChgFeasibleCheckServiceImpl_15" : "OrgBatchChgFeasibleCheckServiceImpl_19", isMerge ? ResManager.loadKDString((String)"\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_15", (String)"odc-homs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_19", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billNo, changeTypeNm}));
        }
    }

    private void inThisBillRowCheck(List<CalibratorBean> result, OrgBatchCheckCacheModel cacheModel) {
        DynamicObject originalDynamicObject = cacheModel.getOriginalDynamicObject();
        if (originalDynamicObject == null) {
            return;
        }
        DynamicObjectCollection entryentityMerges = originalDynamicObject.getDynamicObjectCollection("entryentity_merge");
        DynamicObjectCollection entryentitySplits = originalDynamicObject.getDynamicObjectCollection("entryentity_split");
        for (DynamicObject entryentityMerge : entryentityMerges) {
            DynamicObjectCollection beforeMerges = entryentityMerge.getDynamicObjectCollection("to_merge_org");
            DynamicObject afterMerge = entryentityMerge.getDynamicObject("merge_target_org");
            if (beforeMerges.size() != 1) continue;
            Long beforeMergeId = ((DynamicObject)beforeMerges.get(0)).getLong("fbasedataid.id");
            Long afterMergeId = afterMerge.getLong("id");
            String afterMergeName = afterMerge.getString("name");
            if (!beforeMergeId.equals(afterMergeId)) continue;
            result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_22", ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5c06\u7ec4\u7ec7\u201c%s\u201d\u5408\u5e76\u4e3a\u7ec4\u7ec7\u672c\u8eab\uff0c\u8bf7\u586b\u5199\u66f4\u591a\u5408\u5e76\u524d\u7ec4\u7ec7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_22", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{afterMergeName}));
        }
        for (DynamicObject entryentitySplit : entryentitySplits) {
            DynamicObjectCollection afterSplits = entryentitySplit.getDynamicObjectCollection("split_target_org");
            DynamicObject beforeSplit = entryentitySplit.getDynamicObject("to_split_org");
            if (afterSplits.size() != 1) continue;
            Long afterSplitId = ((DynamicObject)afterSplits.get(0)).getLong("fbasedataid.id");
            Long beforeSplitId = beforeSplit.getLong("id");
            String beforeSplitName = beforeSplit.getString("name");
            if (!afterSplitId.equals(beforeSplitId)) continue;
            result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_23", ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5c06\u7ec4\u7ec7\u201c%s\u201d\u62c6\u5206\u4e3a\u7ec4\u7ec7\u672c\u8eab\uff0c\u8bf7\u586b\u5199\u66f4\u591a\u62c6\u5206\u540e\u7ec4\u7ec7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_23", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{beforeSplitName}));
        }
    }

    private void inThisBillCheck(List<CalibratorBean> result, OrgBatchCheckCacheModel cacheModel) {
        DynamicObject originalDynamicObject = cacheModel.getOriginalDynamicObject();
        if (originalDynamicObject == null) {
            return;
        }
        DynamicObjectCollection entryentityMerges = originalDynamicObject.getDynamicObjectCollection("entryentity_merge");
        DynamicObjectCollection entryentitySplits = originalDynamicObject.getDynamicObjectCollection("entryentity_split");
        HashMap orgMergeMap = Maps.newHashMapWithExpectedSize((int)entryentityMerges.size());
        HashMap orgSplitMap = Maps.newHashMapWithExpectedSize((int)entryentitySplits.size());
        for (DynamicObject entryentityMerge : entryentityMerges) {
            DynamicObjectCollection beforeMerges = entryentityMerge.getDynamicObjectCollection("to_merge_org");
            DynamicObject afterMerge = entryentityMerge.getDynamicObject("merge_target_org");
            Long mergeId = entryentityMerge.getLong("merge_origin_id");
            for (DynamicObject beforeMerge : beforeMerges) {
                Long beforeMergeId = beforeMerge.getLong("fbasedataid.id");
                String beforeMergeName = beforeMerge.getString("fbasedataid.name");
                if (orgMergeMap.containsKey(beforeMergeId) && !((Long)orgMergeMap.get(beforeMergeId)).equals(mergeId)) {
                    result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_20", ResManager.loadKDString((String)"\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u7ec4\u7ec7\u201c%2$s\u201d\u5df2\u5b58\u5728\u5408\u5e76\u7ec4\u7ec7\u4e2d\uff0c\u540c\u4e00\u4e2a\u7ec4\u7ec7\u5728\u4e00\u4e2a\u7533\u8bf7\u5355\u4e2d\u53ea\u80fd\u505a\u4e00\u6b21\u5408\u5e76\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_20", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{beforeMergeName, beforeMergeName}));
                    continue;
                }
                orgMergeMap.put(beforeMergeId, mergeId);
            }
            Long afterMergeId = afterMerge.getLong("id");
            String afterMergeName = afterMerge.getString("name");
            if (orgMergeMap.containsKey(afterMergeId) && !((Long)orgMergeMap.get(afterMergeId)).equals(mergeId)) {
                result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_20", ResManager.loadKDString((String)"\u201c\u5408\u5e76\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u7ec4\u7ec7\u201c%2$s\u201d\u5df2\u5b58\u5728\u5408\u5e76\u7ec4\u7ec7\u4e2d\uff0c\u540c\u4e00\u4e2a\u7ec4\u7ec7\u5728\u4e00\u4e2a\u7533\u8bf7\u5355\u4e2d\u53ea\u80fd\u505a\u4e00\u6b21\u5408\u5e76\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_20", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{afterMergeName, afterMergeName}));
                continue;
            }
            orgMergeMap.put(afterMergeId, mergeId);
        }
        for (DynamicObject entryentitySplit : entryentitySplits) {
            DynamicObjectCollection afterSplits = entryentitySplit.getDynamicObjectCollection("split_target_org");
            DynamicObject beforeSplit = entryentitySplit.getDynamicObject("to_split_org");
            Long splitId = entryentitySplit.getLong("split_origin_id");
            for (DynamicObject afterSplit : afterSplits) {
                Long afterSplitId = afterSplit.getLong("fbasedataid.id");
                String afterSplitName = afterSplit.getString("fbasedataid.name");
                if (orgSplitMap.containsKey(afterSplitId) && !((Long)orgSplitMap.get(afterSplitId)).equals(splitId)) {
                    result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_21", ResManager.loadKDString((String)"\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u7ec4\u7ec7\u201c%2$s\u201d\u5df2\u5b58\u5728\u62c6\u5206\u7ec4\u7ec7\u4e2d\uff0c\u540c\u4e00\u4e2a\u7ec4\u7ec7\u5728\u4e00\u4e2a\u7533\u8bf7\u5355\u4e2d\u53ea\u80fd\u505a\u4e00\u6b21\u62c6\u5206\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_21", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{afterSplitName, afterSplitName}));
                    continue;
                }
                orgSplitMap.put(afterSplitId, splitId);
            }
            Long beforeSplitId = beforeSplit.getLong("id");
            String beforeSplitName = beforeSplit.getString("name");
            if (orgSplitMap.containsKey(beforeSplitId) && !((Long)orgSplitMap.get(beforeSplitId)).equals(splitId)) {
                result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_21", ResManager.loadKDString((String)"\u201c\u62c6\u5206\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u7ec4\u7ec7\u201c%2$s\u201d\u5df2\u5b58\u5728\u62c6\u5206\u7ec4\u7ec7\u4e2d\uff0c\u540c\u4e00\u4e2a\u7ec4\u7ec7\u5728\u4e00\u4e2a\u7533\u8bf7\u5355\u4e2d\u53ea\u80fd\u505a\u4e00\u6b21\u62c6\u5206\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_21", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{beforeSplitName, beforeSplitName}));
                continue;
            }
            orgSplitMap.put(beforeSplitId, splitId);
        }
    }

    private void checkParentChg(String entryKey, DynamicObject dynamicObject, List<CalibratorBean> result) {
        if (!HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.parentEntry.getEntryKey())) {
            return;
        }
        DynamicObject adminorg = dynamicObject.getDynamicObject("adminorg");
        Long orgId = adminorg.getLong("id");
        Long boId = adminorg.getLong("boid");
        String orgName = adminorg.getString("name");
        Long ownChangeTypeId = dynamicObject.getLong("changetype.id");
        String changeTypeName = this.changeTypeIdNameMap.get(ownChangeTypeId);
        Long newOrgId = this.boIdOrgIdMap.get(boId);
        if (!Objects.isNull(newOrgId) && !newOrgId.equals(orgId)) {
            result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_10", ResManager.loadKDString((String)"\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u5f53\u524d\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u57fa\u4e8e\u6700\u65b0\u7684\u4fe1\u606f\u8fdb\u884c\u8c03\u6574\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_10", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName}));
        }
        if (boId == PlatformRootUtils.getLongRootIdOfPlatform()) {
            result.add(new CalibratorBean("OrgChgFeasibleCheckServiceImpl_6", ResManager.loadKDString((String)"\u6839\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u3002", (String)"OrgChgFeasibleCheckServiceImpl_6", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
        }
        if (this.currentDisableOrgIdSet.contains(boId) || !HRStringUtils.equals((String)"1", (String)adminorg.getString("enable"))) {
            result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u4e0a\u7ea7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, changeTypeName}));
        }
        if (this.ownOrgIdReSet.contains(orgId)) {
            result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_3", ResManager.loadKDString((String)"\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u201c%2$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, changeTypeName}));
        }
        for (OrgBatchCheckDto dto : this.billOrgSet) {
            long billOrgId = dto.getOrgId();
            String billNo = dto.getBillNo();
            long changeTypeId = dto.getChangeTypeId();
            String changeTypeNm = this.changeTypeIdNameMap.get(changeTypeId);
            if (!HRStringUtils.isEmpty((String)billNo) && billOrgId == orgId && changeTypeId == OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE) {
                result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_2", ResManager.loadKDString((String)"\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u4e0a\u7ea7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billNo, changeTypeNm}));
            }
            if (HRStringUtils.isEmpty((String)billNo) || billOrgId != orgId || !CHANGE_TYPE_LIST.contains(changeTypeId)) continue;
            result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_4", ResManager.loadKDString((String)"\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billNo, changeTypeNm}));
        }
    }

    private void checkInfoChg(String entryKey, DynamicObject dynamicObject, List<CalibratorBean> result) {
        Long orgTypeId;
        if (!HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.infoEntry.getEntryKey())) {
            return;
        }
        DynamicObject adminorg = dynamicObject.getDynamicObject("adminorg");
        Long boId = adminorg.getLong("boid");
        Long orgId = adminorg.getLong("id");
        String orgName = adminorg.getString("name");
        Long ownChangeTypeId = dynamicObject.getLong("changetype.id");
        String changeTypeName = this.changeTypeIdNameMap.get(ownChangeTypeId);
        Long newOrgId = this.boIdOrgIdMap.get(boId);
        if (!Objects.isNull(newOrgId) && !newOrgId.equals(orgId)) {
            result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_11", ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u4fe1\u606f\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u5f53\u524d\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u57fa\u4e8e\u6700\u65b0\u7684\u4fe1\u606f\u8fdb\u884c\u8c03\u6574\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_11", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName}));
        }
        if (this.currentDisableOrgIdSet.contains(boId) || !HRStringUtils.equals((String)"1", (String)adminorg.getString("enable"))) {
            result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_5", ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u4fe1\u606f\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u4fe1\u606f\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_5", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName}));
        }
        if (this.ownOrgIdReSet.contains(orgId)) {
            result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_7", ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u4fe1\u606f\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u201c%2$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_7", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, changeTypeName}));
        }
        if (!Objects.isNull(boId) && boId == PlatformRootUtils.getLongRootIdOfPlatform() && !OrgBatchCheckConstants.LEVEL4_COMPANY_GROPU.contains(orgTypeId = Long.valueOf(dynamicObject.getLong("adminorgtype.adminorgtypestd.id")))) {
            result.add(new CalibratorBean("OrgChgFeasibleCheckServiceImpl_9", ResManager.loadKDString((String)"\u6839\u7ec4\u7ec7\u7684\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%s\u201d\u3002", (String)"OrgChgFeasibleCheckServiceImpl_9", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{OrgBatchBillCheckHelper.groupCompanyStr()}));
        }
        for (OrgBatchCheckDto dto : this.billOrgSet) {
            long billOrgId = dto.getOrgId();
            String billNo = dto.getBillNo();
            long changeTypeId = dto.getChangeTypeId();
            String changeTypeNm = this.changeTypeIdNameMap.get(changeTypeId);
            if (!HRStringUtils.isEmpty((String)billNo) && billOrgId == orgId && changeTypeId == OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE) {
                result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_6", ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u4fe1\u606f\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u4fe1\u606f\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_6", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billNo, changeTypeNm}));
            }
            if (HRStringUtils.isEmpty((String)billNo) || billOrgId != orgId || !CHANGE_TYPE_LIST.contains(changeTypeId)) continue;
            result.add(new CalibratorBean("OrgBatchChgFeasibleCheckServiceImpl_8", ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u4fe1\u606f\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_8", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billNo, changeTypeNm}));
        }
    }

    private void wrapTargetObject(DynamicObject targetObject, DynamicObject targetObjOldInfo, DynamicObject targetObjNewInfo) {
        DynamicObject targetInfoCopyFromDy = Optional.ofNullable(targetObjNewInfo).orElse(targetObjOldInfo);
        for (String fieldKey : OrgBatchCheckConstants.BILL_ENTRY_NOTEXIST_FIELD) {
            targetObject.set(fieldKey, targetInfoCopyFromDy.get(fieldKey));
        }
    }
}

