/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.service.impl.orgmsg.CommonOrgMsgService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class OrgBatchChgMsgSendHelper {
    private static HRBaseServiceHelper batchOrgEntityHelper = new HRBaseServiceHelper("homs_batchorgentity");
    private static HRBaseServiceHelper batchOrgHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");

    public static void sendMsg(DynamicObject[] dataEntities, String operationKey) {
        List billIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("id")).distinct().collect(Collectors.toList());
        QFilter billIdFilter = new QFilter("billid", "in", billIds);
        DynamicObject[] billEntries = batchOrgEntityHelper.loadDynamicObjectArray(billIdFilter.toArray());
        DynamicObject[] chgbills = batchOrgHelper.query("effdt, id", new QFilter("id", "in", billIds).toArray());
        Map<Long, Date> bsedMap = Arrays.stream(chgbills).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getDate("effdt")));
        Arrays.stream(billEntries).forEach(dy -> {
            long billId = dy.getLong("billid");
            dy.set("bsed", bsedMap.get(billId));
        });
        CommonOrgMsgService.handleBatchOrgMsg((DynamicObject[])billEntries, null, (String)operationKey);
    }
}

