/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgBatchDisableCheckServiceImpl
implements IOrgBatchBillCheckService {
    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        String toNow = ResManager.loadKDString((String)"\u81f3\u4eca", (String)"OrgBatchDisableCheckServiceImpl_9", (String)"odc-homs-business", (Object[])new Object[0]);
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        String disableKey = EntryEntityEnum.disableEntry.getEntryKey();
        DynamicObjectCollection orgColl = targetObject.getDynamicObjectCollection(disableKey);
        if (CollectionUtils.isEmpty((Collection)orgColl)) {
            return result;
        }
        HashMap orgIdBsedMap = Maps.newHashMapWithExpectedSize((int)orgColl.size());
        HashSet ownDisableBoIdSet = Sets.newHashSetWithExpectedSize((int)orgColl.size());
        HashSet ownDisableOrgIdSet = Sets.newHashSetWithExpectedSize((int)orgColl.size());
        orgColl.stream().forEach(dyn -> {
            orgIdBsedMap.put(dyn.getLong("adminorg.boid"), dyn.getDate("adminorg.bsed"));
            ownDisableBoIdSet.add(dyn.getLong("adminorg.boid"));
            ownDisableOrgIdSet.add(dyn.getLong("adminorg.id"));
        });
        Map<Long, Date> orgInfoLatestBsedMap = OrgBatchBillCheckHelper.getOrgInfoLatestBsed(orgIdBsedMap);
        List<OrgBatchCheckDto> ownEnableOrgList = cacheModel.getOwnEnableOrgList();
        HashMap ownOrgIdChangeTypeMap = Maps.newHashMapWithExpectedSize((int)ownEnableOrgList.size());
        HashMap ownParentIdSet = Maps.newHashMapWithExpectedSize((int)ownEnableOrgList.size());
        ownEnableOrgList.forEach(dto -> {
            ownOrgIdChangeTypeMap.put(dto.getOrgId(), dto.getChangeTypeId());
            List childOrgNames = ownParentIdSet.getOrDefault(dto.getParentOrgId(), new ArrayList());
            childOrgNames.add("[" + dto.getName() + "],");
            ownParentIdSet.put(dto.getParentOrgId(), childOrgNames);
        });
        Map<Long, String> changeTypeIdNameMap = OrgBatchBillCheckHelper.queryBaseDataInfo("haos_orgchangetype", "id,name");
        List<OrgBatchCheckDto> billOrgList = cacheModel.getBillOrgList();
        HashMap billDisableOrgIdBillNoMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap billParentOrgIdBillNoMap = Maps.newHashMapWithExpectedSize((int)16);
        Long currentBillId = cacheModel.getCurrentBillId();
        for (OrgBatchCheckDto dto2 : billOrgList) {
            if (currentBillId.equals(dto2.getBillId())) continue;
            if (OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.equals(dto2.getChangeTypeId())) {
                billDisableOrgIdBillNoMap.put(dto2.getOrgId(), dto2.getBillNo());
            }
            if (!ownDisableOrgIdSet.contains(dto2.getParentOrgId())) continue;
            Map parentIdToBillNoSubOrgs = billParentOrgIdBillNoMap.getOrDefault(dto2.getParentOrgId(), new HashMap());
            List billNoToSubOrgs = parentIdToBillNoSubOrgs.getOrDefault(dto2.getBillNo(), new ArrayList());
            billNoToSubOrgs.add(dto2.getName());
            parentIdToBillNoSubOrgs.put(dto2.getBillNo(), billNoToSubOrgs);
            billParentOrgIdBillNoMap.put(dto2.getParentOrgId(), parentIdToBillNoSubOrgs);
        }
        List newBillOrgList = billOrgList.stream().filter(dto -> ownDisableOrgIdSet.contains(dto.getOrgId())).filter(dto -> !currentBillId.equals(dto.getBillId())).filter(dto -> OrgBatchChgBillConstants.CHANGE_TYPE_PARENT.equals(dto.getChangeTypeId()) || OrgBatchChgBillConstants.CHANGE_TYPE_INFO.equals(dto.getChangeTypeId()) || OrgBatchChgBillConstants.CHANGE_TYPE_MERGE.equals(dto.getChangeTypeId()) || OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT.equals(dto.getChangeTypeId())).collect(Collectors.toList());
        Map<Long, Long> positionCountByOrg = OrgBatchBillCheckHelper.getPositionCountByOrg(new ArrayList<Long>(ownDisableBoIdSet));
        Date effdtDate = targetObject.getDate("effdt");
        Map<Long, List<DynamicObject>> parentOrgIdOrgDynamicMap = this.queryEnabledChildren(orgIdBsedMap.keySet(), effdtDate);
        Map<Long, Set<Long>> parentOrgIdOrgIdSetMap = OrgBatchBillCheckHelper.getParentOrgIdOrgIdSetMap(parentOrgIdOrgDynamicMap);
        Map<Long, OrgBatchBillCheckHelper.EnableSubValidate> parentOrg2SubNames = OrgBatchBillCheckHelper.getParentOrg2SubNames(parentOrgIdOrgDynamicMap);
        Set<Long> dbOrgBoIdSet = OrgBatchBillCheckHelper.queryDisableOrgBoIdSet(ownDisableBoIdSet, cacheModel.getEffectDate());
        DynamicObject originalDynamicObject = Optional.ofNullable(cacheModel.getOriginalDynamicObject()).orElse(targetObject);
        Set mergeTargetOrgIdSet = originalDynamicObject.getDynamicObjectCollection("entryentity_merge").stream().map(entry -> entry.getDynamicObject("merge_target_org").getLong("id")).collect(Collectors.toSet());
        Set<Long> splitTargetOrgIdSet = AdminOrgBatchChgHelper.getSplitTargetOrgIdSet(originalDynamicObject);
        for (DynamicObject dy : orgColl) {
            Long buOrgId = dy.getLong("org.id");
            DynamicObject adminorgDy = dy.getDynamicObject("adminorg");
            Long orgId = adminorgDy.getLong("id");
            Long boId = adminorgDy.getLong("boid");
            Object orgName = adminorgDy.get("name");
            Date lastEffect = orgInfoLatestBsedMap.get(boId);
            if (effdtDate.before(lastEffect)) {
                result.add(new CalibratorBean("OrgBatchDisableCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c\u505c\u7528\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u7ec4\u7ec7\u8c03\u6574\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7ec4\u7ec7\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchDisableCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, DateUtils.formatDate((Date)lastEffect, (Object[])new Object[0])}));
            }
            if ("0".equals(adminorgDy.getString("enable")) || dbOrgBoIdSet.contains(boId)) {
                result.add(new CalibratorBean("OrgBatchDisableCheckServiceImpl_2", ResManager.loadKDString((String)"\u201c\u505c\u7528\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u505c\u7528\u3002", (String)"OrgBatchDisableCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName}));
            }
            if (billDisableOrgIdBillNoMap.containsKey(orgId)) {
                result.add(new CalibratorBean("OrgBatchDisableCheckServiceImpl_3", ResManager.loadKDString((String)"\u201c\u505c\u7528\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c\u505c\u7528\u7ec4\u7ec7\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u505c\u7528\u3002", (String)"OrgBatchDisableCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billDisableOrgIdBillNoMap.get(orgId)}));
            }
            if (ownOrgIdChangeTypeMap.containsKey(orgId) && !cacheModel.isMergeSplitFlag()) {
                Long changeTypeId = (Long)ownOrgIdChangeTypeMap.get(orgId);
                result.add(new CalibratorBean("OrgBatchDisableCheckServiceImpl_5", ResManager.loadKDString((String)"\u201c\u505c\u7528\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"OrgBatchDisableCheckServiceImpl_5", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, changeTypeIdNameMap.get(changeTypeId)}));
            }
            for (OrgBatchCheckDto dto3 : newBillOrgList) {
                if (!orgId.equals(dto3.getOrgId())) continue;
                result.add(new CalibratorBean("OrgBatchDisableCheckServiceImpl_5", ResManager.loadKDString((String)"\u201c\u505c\u7528\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"OrgBatchDisableCheckServiceImpl_5", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, dto3.getBillNo(), changeTypeIdNameMap.get(dto3.getChangeTypeId())}));
            }
            Set chOrgBoIdSet = parentOrgIdOrgIdSetMap.getOrDefault(boId, new HashSet());
            chOrgBoIdSet.removeAll(cacheModel.getParentEntryIds());
            cacheModel.getParentEntryIds().forEach(key -> {
                if (parentOrg2SubNames.get(boId) != null) {
                    ((OrgBatchBillCheckHelper.EnableSubValidate)parentOrg2SubNames.get(boId)).getBoidToNames().remove(key);
                }
            });
            if (!CollectionUtils.isEmpty((Collection)chOrgBoIdSet) && !ownDisableBoIdSet.containsAll(chOrgBoIdSet)) {
                OrgBatchBillCheckHelper.EnableSubValidate enableSubValidate = parentOrg2SubNames.get(boId);
                result.add(new CalibratorBean("OrgBatchDisableCheckServiceImpl_8", ResManager.loadKDString((String)"\u201c\u505c\u7528\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u201c%2$s\u201d-\u201c%3$s\u201d\u5b58\u5728\u542f\u7528\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%4$s\u201d\uff0c\u4e0d\u5141\u8bb8\u505c\u7528,\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchDisableCheckServiceImpl_8", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, DateUtils.formatDate((Date)effdtDate, (Object[])new Object[]{"yyyy-MM-dd"}), OrgBatchBillCheckHelper.lastDate.equals(enableSubValidate.getEndTime()) ? toNow : DateUtils.formatDate((Date)enableSubValidate.getEndTime(), (Object[])new Object[]{"yyyy-MM-dd"}), String.join((CharSequence)",", enableSubValidate.getBoidToNames().values())}));
            }
            if (ownParentIdSet.containsKey(orgId)) {
                List childNames = (List)ownParentIdSet.get(orgId);
                result.add(new CalibratorBean("OrgBatchDisableCheckServiceImpl_6", ResManager.loadKDString((String)"\u201c\u505c\u7528\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5728\u672c\u5355\u4e2d\u5b58\u5728\u542f\u7528\u4e2d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%2$s\u201d\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchDisableCheckServiceImpl_6", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, String.join((CharSequence)",", childNames)}));
            }
            if (billParentOrgIdBillNoMap.containsKey(orgId)) {
                Map stringListMap = (Map)billParentOrgIdBillNoMap.get(orgId);
                stringListMap.forEach((key, value) -> result.add(new CalibratorBean("OrgBatchDisableCheckServiceImpl_4", ResManager.loadKDString((String)"\u201c\u505c\u7528\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u5728\u9014\u5355\u636e\u201c%2$s\u201d\u5b58\u5728\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u201c%3$s\u201d\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\u3002", (String)"OrgBatchDisableCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, key, String.join((CharSequence)",", value)})));
            }
            if (!SystemParamHelper.getAllowEnabledPosition(buOrgId) && positionCountByOrg.getOrDefault(boId, 0L).intValue() > 0) {
                result.add(new CalibratorBean("OrgBatchDisableCheckServiceImpl_10", ResManager.loadKDString((String)"\u201c\u505c\u7528\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u5b58\u5728\u542f\u7528\u4e2d\u7684\u5c97\u4f4d\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\u3002", (String)"OrgBatchDisableCheckServiceImpl_10", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName}));
            }
            if (mergeTargetOrgIdSet.contains(orgId)) {
                result.add(new CalibratorBean("OrgBatchDisableCheckServiceImpl_12", ResManager.loadKDString((String)"\u201c\u505c\u7528\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u4e3a\u672c\u5355\u5408\u5e76\u7ec4\u7ec7\u4e2d\u7684\u5408\u5e76\u540e\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchDisableCheckServiceImpl_12", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName}));
            }
            if (!splitTargetOrgIdSet.contains(orgId)) continue;
            result.add(new CalibratorBean("OrgBatchDisableCheckServiceImpl_11", ResManager.loadKDString((String)"\u201c\u505c\u7528\u7ec4\u7ec7\u201d\u9875\u7b7e\u4e0b\u201c%1$s\u201d\uff1a\u4e3a\u672c\u5355\u62c6\u5206\u7ec4\u7ec7\u4e2d\u7684\u62c6\u5206\u540e\u7ec4\u7ec7\uff08\u975e\u62c6\u5206\u524d\u7ec4\u7ec7\uff09\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchDisableCheckServiceImpl_11", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName}));
        }
        return result;
    }

    private Map<Long, List<DynamicObject>> queryEnabledChildren(Set<Long> orgIdSet, Date checkDate) {
        HashMap parentOrgIdOrgIdSetMap = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter orgIdFilter = new QFilter("parentorg", "in", orgIdSet);
        orgIdFilter.and(new QFilter("datastatus", "in", Arrays.asList("1", "2")));
        orgIdFilter.and(new QFilter("enable", "=", (Object)"1"));
        orgIdFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        orgIdFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        orgIdFilter.and(new QFilter("bsled", ">=", (Object)checkDate));
        orgIdFilter.and("boid", "not in", orgIdSet);
        DynamicObjectCollection orgColl = serviceHelper.queryOriginalCollection("boid,name,parentorg,bsed,bsled", new QFilter[]{orgIdFilter});
        if (CollectionUtils.isEmpty((Collection)orgColl)) {
            return parentOrgIdOrgIdSetMap;
        }
        return orgColl.stream().collect(Collectors.groupingBy(dy -> dy.getLong("parentorg")));
    }

    private String generatePersonNameStr(List<String> personNames) {
        StringBuilder stringBuilder = new StringBuilder();
        int size = personNames.size();
        for (int i = 0; i < size; ++i) {
            stringBuilder.append('[').append(personNames.get(i)).append("]\u3001");
            if (i != 4) continue;
            stringBuilder.append('[').append(personNames.get(i)).append("]......");
            break;
        }
        return size > 5 ? stringBuilder.toString() : stringBuilder.substring(0, stringBuilder.length() - 1);
    }
}

