/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.common.constants.TeamCoopRelConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgBatchEffectDateCheckServiceImpl
implements IOrgBatchBillCheckService {
    private Map<Long, Date> orgInfoLatestBsedMap;
    private List<OrgBatchCheckDto> coopOrgInfo;

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        Date effdt = targetObject.getDate("effdt");
        LocalDate localEffdt = LocalDate.parse(DateUtils.formatDate((Date)effdt, (Object[])new Object[0]));
        this.initOrgInfo(cacheModel.getOwnEnableOrgList(), effdt, cacheModel.getCurrentOrgColl());
        Map<String, String> multiEntryNameMap = OrgBatchBillCheckHelper.assembleMultiEntryName();
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        List<String> entryKeys = EntryEntityEnum.getEntryKeys();
        DynamicObjectCollection currentOrgColl = cacheModel.getCurrentOrgColl();
        HashSet structIds = Sets.newHashSet();
        HashMap entryStructMap = Maps.newHashMap();
        for (DynamicObject chgOrgDy : currentOrgColl) {
            DynamicObjectCollection structEntryCollection = chgOrgDy.getDynamicObjectCollection("struct_project_entry");
            long entryId = chgOrgDy.getLong("id");
            if (CollectionUtils.isEmpty((Collection)structEntryCollection)) continue;
            structEntryCollection.forEach(dynamicObject -> {
                structIds.add(dynamicObject.getDynamicObject("struct_project").getLong("id"));
                if (dynamicObject.getDynamicObject("struct_parent_org") != null) {
                    if (entryStructMap.containsKey(entryId)) {
                        ((List)entryStructMap.get(entryId)).add(dynamicObject.getDynamicObject("struct_project").getLong("id"));
                    } else {
                        ArrayList structEntryList = Lists.newArrayList();
                        structEntryList.add(dynamicObject.getDynamicObject("struct_project").getLong("id"));
                        entryStructMap.put(entryId, structEntryList);
                    }
                }
            });
        }
        Map<Object, Object> structDateMap = Maps.newHashMap();
        if (structIds.size() > 0) {
            DynamicObject[] structDyArr = StructProjectRepository.getInstance().queryByStructProjectIds("id,name,effdt", (Set)structIds);
            structDateMap = Arrays.asList(structDyArr).stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
        }
        for (String entryKey : entryKeys) {
            if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.disableEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.mergeEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.splitEntry.getEntryKey())) continue;
            DynamicObjectCollection orgColl = targetObject.getDynamicObjectCollection(entryKey);
            String entryName = multiEntryNameMap.get(entryKey);
            for (DynamicObject dynamicObject2 : orgColl) {
                this.checkEstablishmentdate(entryName, localEffdt, dynamicObject2, result);
                this.checkParentOrgEstablishmentdate(entryName, entryKey, localEffdt, dynamicObject2, result);
                this.checkOrgInfoLatestBsed(entryName, entryKey, localEffdt, dynamicObject2, result);
                this.checkCoopOrgEstablishmentdate(entryName, entryKey, dynamicObject2, result);
                this.checkEstablishmentStructdate(entryName, effdt, dynamicObject2, entryStructMap, structDateMap, result);
            }
        }
        return result;
    }

    private void checkEstablishmentdate(String entryName, LocalDate localEffdt, DynamicObject dynamicObject, List<CalibratorBean> result) {
        String localEstablishmentdate = DateUtils.formatDate((Date)dynamicObject.getDate("establishmentdate"), (Object[])new Object[0]);
        String originalName = null;
        if (dynamicObject.get("adminorg") instanceof DynamicObject) {
            originalName = dynamicObject.getDynamicObject("adminorg").getString("name");
        }
        if (localEffdt.isBefore(LocalDate.parse(localEstablishmentdate))) {
            result.add(new CalibratorBean("OrgBatchEffectDateCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u7ec4\u7ec7\u8c03\u6574\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u672c\u884c\u653f\u7ec4\u7ec7\u7684\u6210\u7acb\u65e5\u671f\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchEffectDateCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : dynamicObject.get("name"), localEstablishmentdate}));
        }
    }

    private void checkEstablishmentStructdate(String entryName, Date effdt, DynamicObject dynamicObject, Map<Long, List<Long>> entryStructMap, Map<Long, DynamicObject> structDateMap, List<CalibratorBean> result) {
        long entryId;
        String originalName = null;
        if (dynamicObject.get("adminorg") instanceof DynamicObject) {
            originalName = dynamicObject.getDynamicObject("adminorg").getString("name");
        }
        if (entryStructMap.containsKey(entryId = dynamicObject.getLong("id"))) {
            List<Long> structList = entryStructMap.get(entryId);
            for (Long structId : structList) {
                Date structEffdt;
                DynamicObject structDy = structDateMap.get(structId);
                if (structDy == null || !(structEffdt = structDateMap.get(structId).getDate("effdt")).after(effdt)) continue;
                String localEstablishmentdate = DateUtils.formatDate((Date)structEffdt, (Object[])new Object[0]);
                result.add(new CalibratorBean("OrgBatchEffectDateCheckServiceImpl_5", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u7ec4\u7ec7\u8c03\u6574\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u201c%3$s\u201d\u7684\u751f\u6548\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchEffectDateCheckServiceImpl_5", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : dynamicObject.get("name"), structDy.getString("name"), localEstablishmentdate}));
            }
        }
    }

    private void checkParentOrgEstablishmentdate(String entryName, String entryKey, LocalDate localEffdt, DynamicObject dynamicObject, List<CalibratorBean> result) {
        Date effectDateOfParent;
        String effectDateOfParentStr;
        if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.infoEntry.getEntryKey())) {
            return;
        }
        String originalName = null;
        if (dynamicObject.get("adminorg") instanceof DynamicObject) {
            originalName = dynamicObject.getDynamicObject("adminorg").getString("name");
        }
        if ((effectDateOfParentStr = DateUtils.formatDate((Date)(effectDateOfParent = dynamicObject.getDate("parentorg.establishmentdate")), (Object[])new Object[0])) != null && localEffdt.isBefore(LocalDate.parse(effectDateOfParentStr))) {
            result.add(new CalibratorBean("OrgBatchEffectDateCheckServiceImpl_2", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u7ec4\u7ec7\u8c03\u6574\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7684\u6210\u7acb\u65e5\u671f\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchEffectDateCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : dynamicObject.get("name"), effectDateOfParentStr}));
        }
    }

    private void checkOrgInfoLatestBsed(String entryName, String entryKey, LocalDate localEffdt, DynamicObject dynamicObject, List<CalibratorBean> result) {
        Long orgBoId;
        String lastEffectStr;
        if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.addEntry.getEntryKey())) {
            return;
        }
        String originalName = null;
        if (dynamicObject.get("adminorg") instanceof DynamicObject) {
            originalName = dynamicObject.getDynamicObject("adminorg").getString("name");
        }
        if (HRStringUtils.isNotEmpty((String)(lastEffectStr = DateUtils.formatDate((Date)this.orgInfoLatestBsedMap.get(orgBoId = Long.valueOf(dynamicObject.getLong("adminorg.boid"))), (Object[])new Object[0])))) {
            LocalDate lastEffect = LocalDate.parse(lastEffectStr);
            if (localEffdt != null && localEffdt.isBefore(lastEffect)) {
                result.add(new CalibratorBean("OrgBatchEffectDateCheckServiceImpl_3", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u7ec4\u7ec7\u8c03\u6574\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u8c03\u6574\u5185\u5bb9\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchEffectDateCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : dynamicObject.get("name"), lastEffectStr}));
            }
        }
    }

    private void checkCoopOrgEstablishmentdate(String entryName, String entryKey, DynamicObject dynamicObject, List<CalibratorBean> result) {
        if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.addEntry.getEntryKey())) {
            return;
        }
        String originalName = null;
        if (dynamicObject.get("adminorg") instanceof DynamicObject) {
            originalName = dynamicObject.getDynamicObject("adminorg").getString("name");
        }
        Long entryId = dynamicObject.getLong("id");
        for (OrgBatchCheckDto dto : this.coopOrgInfo) {
            if (!entryId.equals(dto.getEntryId())) continue;
            String coopBesdStr = DateUtils.formatDate((Date)dto.getOrgBsed(), (Object[])new Object[0]);
            result.add(new CalibratorBean("OrgBatchEffectDateCheckServiceImpl_4", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u7ec4\u7ec7\u8c03\u6574\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u534f\u4f5c\u7c7b\u578b\u4e3a\u201c%3$s\u201d\u7684\u534f\u4f5c\u7ec4\u7ec7\u201c%4$s\u201d\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u201c%5$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchEffectDateCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : dynamicObject.get("name"), dto.getOrgCoopTypeName(), dto.getOrgNameObj(), coopBesdStr}));
        }
    }

    private void initOrgInfo(List<OrgBatchCheckDto> ownEnableOrgList, Date effdt, DynamicObjectCollection entryCollection) {
        HashMap orgIdBsedMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet entryIdSet = Sets.newHashSetWithExpectedSize((int)ownEnableOrgList.size());
        for (OrgBatchCheckDto dto : ownEnableOrgList) {
            Long orgBoId = dto.getOrgBoId();
            if (!Objects.isNull(orgBoId) && orgBoId != 0L) {
                orgIdBsedMap.put(orgBoId, effdt);
            }
            entryIdSet.add(dto.getEntryId());
        }
        if (CollectionUtils.isEmpty((Map)orgIdBsedMap)) {
            this.orgInfoLatestBsedMap = Maps.newHashMapWithExpectedSize((int)1);
            this.coopOrgInfo = Lists.newArrayListWithCapacity((int)1);
        } else {
            this.orgInfoLatestBsedMap = OrgBatchBillCheckHelper.getOrgInfoLatestBsed(orgIdBsedMap);
            this.coopOrgInfo = OrgBatchEffectDateCheckServiceImpl.getCoopOrgInfo(entryIdSet, effdt);
        }
    }

    public static List<OrgBatchCheckDto> getCoopOrgInfo(Set<Long> entryIdSet, Date effdt) {
        ArrayList result = Lists.newArrayListWithCapacity((int)10);
        HRBaseServiceHelper entryHelper = new HRBaseServiceHelper("homs_batchentrycoop");
        QFilter entryFilter = new QFilter("entryid", "in", entryIdSet);
        entryFilter.and(new QFilter("coopreltyp", "<>", (Object)TeamCoopRelConstants.AFFILIATION_ID));
        DynamicObjectCollection coopOrgColl = entryHelper.queryOriginalCollection("entryid,cooporgteam.firstbsed,cooporgteam.name,coopreltyp.name", new QFilter[]{entryFilter});
        for (Long entryId : entryIdSet) {
            for (DynamicObject dy : coopOrgColl) {
                Long coopEntryId = dy.getLong("entryid");
                Date coopBsed = dy.getDate("cooporgteam.firstbsed");
                Object coopOrgName = dy.get("cooporgteam.name");
                if (!entryId.equals(coopEntryId) || coopBsed == null || !effdt.before(coopBsed)) continue;
                OrgBatchCheckDto dto = new OrgBatchCheckDto();
                dto.setEntryId(coopEntryId);
                dto.setOrgBsed(coopBsed);
                dto.setOrgNameObj(coopOrgName);
                dto.setOrgCoopTypeName(dy.getString("coopreltyp.name"));
                result.add(dto);
            }
        }
        return result;
    }
}

