/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgbatch.OrgLevel4ModelCheckServiceImpl;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgBatchLevel4ModelCheckServiceImpl
implements IOrgBatchBillCheckService {
    private Map<Long, Long> parentOrgTypeStdIdMap;
    private Map<Long, Map<String, String>> billOrgIdTypeStdIdMap;
    private Map<Long, Map<Long, Pair<Date, Date>>> adminLowerOrgIdTypeStdMap;
    private Map<Long, Map<Long, Set<String>>> billLowerOrgIdTypeStdMap;
    private Map<String, String> adminOrgTypeNameMap;
    private Map<Long, Long> orgIdOrgTypeIdMap;
    private Map<Long, OrgLevel4ModelCheckServiceImpl.OrgAboveLevel4ModelParam> parentAdminStdTypeByBoId;
    private Date effectDate;

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        this.initCheckParam(cacheModel, targetObject.getLong("org.id") != 0L ? targetObject.getLong("org.id") : cacheModel.getOrgId().longValue());
        Map<String, String> multiEntryNameMap = OrgBatchBillCheckHelper.assembleMultiEntryName();
        List<String> entryKeys = EntryEntityEnum.getEntryKeys();
        this.effectDate = cacheModel.getEffectDate();
        for (String entryKey : entryKeys) {
            if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.disableEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.mergeEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.splitEntry.getEntryKey())) continue;
            DynamicObjectCollection orgColl = targetObject.getDynamicObjectCollection(entryKey);
            String entryName = multiEntryNameMap.get(entryKey);
            for (DynamicObject dynamicObject : orgColl) {
                this.checkLevel4Model(entryKey, entryName, result, dynamicObject);
            }
        }
        return result;
    }

    private void checkLevel4Model(String entryKey, String entryName, List<CalibratorBean> result, DynamicObject dynamicObject) {
        DynamicObject orgtype = dynamicObject.getDynamicObject("adminorgtype");
        Long orgtypeStdNumber = orgtype.getLong("adminorgtypestd.id");
        if (OrgBatchChgBillConstants.NUMBER_ORGTYPE_GROUP.equals(orgtypeStdNumber)) {
            this.checkAboveLevel4Model(entryName, result, dynamicObject);
        } else if (OrgBatchChgBillConstants.NUMBER_ORGTYPE_COMPANY.equals(orgtypeStdNumber)) {
            this.checkAboveLevel4Model(entryName, result, dynamicObject);
            this.checkLowerLevel4Model(entryKey, entryName, result, dynamicObject);
        } else if (OrgBatchChgBillConstants.NUMBER_ORGTYPE_DEPARTMENT.equals(orgtypeStdNumber)) {
            this.checkLowerLevel4Model(entryKey, entryName, result, dynamicObject);
        }
    }

    private void checkAboveLevel4Model(String entryName, List<CalibratorBean> result, DynamicObject dynamicObject) {
        Long parentorgId;
        OrgLevel4ModelCheckServiceImpl.OrgAboveLevel4ModelParam orgAboveLevel4ModelParam;
        Long orgBoId = dynamicObject.getLong("adminorg.boid");
        if (PlatformRootUtils.getLongRootIdOfPlatform() == orgBoId) {
            return;
        }
        DynamicObject orgtype = dynamicObject.getDynamicObject("adminorgtype");
        Long orgtypeStdId = orgtype.getLong("adminorgtypestd.id");
        DynamicObject parentOrg = dynamicObject.getDynamicObject("parentorg");
        Long parentOrgId = parentOrg.getLong("id");
        Long parentOrgBoId = parentOrg.getLong("boid");
        Object orgName = dynamicObject.get("name");
        if (AdminOrgType.GROUP.getId() == orgtypeStdId.longValue()) {
            orgAboveLevel4ModelParam = this.parentAdminStdTypeByBoId.get(parentOrgBoId);
            if (!EnumHisDataVersionStatus.TEMP.getStatus().equals(parentOrg.getString("datastatus")) && orgAboveLevel4ModelParam != null && !OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(this.parentOrgTypeStdIdMap.get(orgAboveLevel4ModelParam.getType()))) {
                result.add(new CalibratorBean("OrgBatchLevel4ModelCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%3$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchLevel4ModelCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_above_group"), OrgBatchBillCheckHelper.getTimeSpan(orgAboveLevel4ModelParam.getStartTime(), orgAboveLevel4ModelParam.getEndTime())}));
            }
            if (this.orgIdOrgTypeIdMap.get(parentOrgId) != null && !OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(this.orgIdOrgTypeIdMap.get(parentOrgId))) {
                result.add(new CalibratorBean("OrgBatchLevel4ModelCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%3$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchLevel4ModelCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_above_group")}));
            }
        }
        if (AdminOrgType.COMPANY.getId() == orgtypeStdId.longValue()) {
            orgAboveLevel4ModelParam = this.parentAdminStdTypeByBoId.get(parentOrgBoId);
            if (!EnumHisDataVersionStatus.TEMP.getStatus().equals(parentOrg.getString("datastatus")) && orgAboveLevel4ModelParam != null && !OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(this.parentOrgTypeStdIdMap.get(this.parentOrgTypeStdIdMap.get(orgAboveLevel4ModelParam.getType())))) {
                result.add(new CalibratorBean("OrgBatchLevel4ModelCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%3$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchLevel4ModelCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_above_company"), OrgBatchBillCheckHelper.getTimeSpan(orgAboveLevel4ModelParam.getStartTime(), orgAboveLevel4ModelParam.getEndTime())}));
            }
            if (this.orgIdOrgTypeIdMap.get(parentOrgId) != null && !OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(this.orgIdOrgTypeIdMap.get(parentOrgId))) {
                result.add(new CalibratorBean("OrgBatchLevel4ModelCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%3$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchLevel4ModelCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_above_company")}));
            }
        }
        if (this.billOrgIdTypeStdIdMap.containsKey(parentorgId = Long.valueOf(dynamicObject.getLong("parentorg.id")))) {
            if (AdminOrgType.GROUP.getId() == orgtypeStdId.longValue() && !OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(Long.valueOf(this.billOrgIdTypeStdIdMap.get(parentorgId).get("typeStdId")))) {
                result.add(new CalibratorBean("OrgBatchLevel4ModelCheckServiceImpl_2", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%3$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%4$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%5$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchLevel4ModelCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_above_group"), this.billOrgIdTypeStdIdMap.get(parentorgId).get("billNo")}));
            }
            if (AdminOrgType.COMPANY.getId() == orgtypeStdId.longValue() && !OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(Long.valueOf(this.billOrgIdTypeStdIdMap.get(parentorgId).get("typeStdId")))) {
                result.add(new CalibratorBean("OrgBatchLevel4ModelCheckServiceImpl_2", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%3$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%4$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%5$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchLevel4ModelCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_above_company"), this.billOrgIdTypeStdIdMap.get(parentorgId).get("billNo")}));
            }
        }
    }

    private void checkLowerLevel4Model(String entryKey, String entryName, List<CalibratorBean> result, DynamicObject dynamicObject) {
        Map<Long, Set<String>> billLowerTypeStdSet;
        if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.addEntry.getEntryKey())) {
            return;
        }
        DynamicObject orgtype = dynamicObject.getDynamicObject("adminorgtype");
        Long orgtypeStdId = orgtype.getLong("adminorgtypestd.id");
        Object orgName = dynamicObject.get("name");
        Map<Long, Pair<Date, Date>> sets = this.adminLowerOrgIdTypeStdMap.get(dynamicObject.getLong("adminorg.boid"));
        if (!CollectionUtils.isEmpty(sets)) {
            String timeSpan;
            if (AdminOrgType.COMPANY.getId() == orgtypeStdId.longValue() && sets != null && !OrgBatchCheckConstants.LEVEL4_LOWER_COMPANY.containsAll(sets.keySet())) {
                timeSpan = null;
                timeSpan = sets.get(1010L) != null ? OrgBatchBillCheckHelper.getTimeSpan((Date)sets.get(1010L).getKey(), (Date)sets.get(1010L).getValue()) : OrgBatchBillCheckHelper.getTimeSpan(this.effectDate, OrgBatchBillCheckHelper.lastDate);
                result.add(new CalibratorBean("OrgBatchLevel4ModelCheckServiceImpl_3", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%3$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%4$s\u201d\uff0c\u5728\u201c%5$s\u201d\u671f\u95f4\u4e0d\u6ee1\u8db3\u89c4\u5219\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchLevel4ModelCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_lower_company"), timeSpan}));
            }
            if (AdminOrgType.DEPARTMENT.getId() == orgtypeStdId.longValue() && sets != null && !OrgBatchCheckConstants.LEVEL4_LOWER_DEPT.containsAll(sets.keySet())) {
                timeSpan = null;
                timeSpan = sets.get(1020L) != null ? OrgBatchBillCheckHelper.getTimeSpan((Date)sets.get(1020L).getKey(), (Date)sets.get(1020L).getValue()) : OrgBatchBillCheckHelper.getTimeSpan(this.effectDate, OrgBatchBillCheckHelper.lastDate);
                result.add(new CalibratorBean("OrgBatchLevel4ModelCheckServiceImpl_3", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%3$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%4$s\u201d\uff0c\u5728\u201c%5$s\u201d\u671f\u95f4\u4e0d\u6ee1\u8db3\u89c4\u5219\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchLevel4ModelCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_lower_dept"), timeSpan}));
            }
        }
        if (!CollectionUtils.isEmpty(billLowerTypeStdSet = this.billLowerOrgIdTypeStdMap.get(dynamicObject.getLong("adminorg.id")))) {
            if (AdminOrgType.COMPANY.getId() == orgtypeStdId.longValue() && !OrgBatchCheckConstants.LEVEL4_LOWER_COMPANY.containsAll(billLowerTypeStdSet.keySet())) {
                result.add(new CalibratorBean("OrgBatchLevel4ModelCheckServiceImpl_4", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%3$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%4$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%5$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchLevel4ModelCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_lower_company"), billLowerTypeStdSet.get(1010L).stream().collect(Collectors.joining(","))}));
            }
            if (AdminOrgType.DEPARTMENT.getId() == orgtypeStdId.longValue() && !OrgBatchCheckConstants.LEVEL4_LOWER_DEPT.containsAll(billLowerTypeStdSet.keySet())) {
                result.add(new CalibratorBean("OrgBatchLevel4ModelCheckServiceImpl_4", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%3$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%4$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%5$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchLevel4ModelCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_lower_dept"), billLowerTypeStdSet.get(1020L).stream().collect(Collectors.joining(","))}));
            }
        }
    }

    private void initCheckParam(OrgBatchCheckCacheModel cacheModel, long buOrgId) {
        List<OrgBatchCheckDto> ownEnableOrgList = cacheModel.getOwnEnableOrgList();
        HashSet ownBoIdSet = Sets.newHashSetWithExpectedSize((int)10);
        HashSet ownOrgIdSet = Sets.newHashSetWithExpectedSize((int)10);
        HashMap orgIdOrgTypeIdMap = Maps.newHashMapWithExpectedSize((int)ownEnableOrgList.size());
        HashSet oweParentBoIdSet = Sets.newHashSetWithExpectedSize((int)10);
        for (OrgBatchCheckDto dto : ownEnableOrgList) {
            Long orgBoId = dto.getOrgBoId();
            if (OrgBatchBillCheckHelper.isValidateOrgId(orgBoId)) continue;
            Long orgId = dto.getOrgId();
            ownBoIdSet.add(orgBoId);
            ownOrgIdSet.add(orgId);
            oweParentBoIdSet.add(dto.getParentOrgBoId());
            orgIdOrgTypeIdMap.put(orgId, dto.getOrgTypeStdId());
        }
        this.parentAdminStdTypeByBoId = OrgBatchBillCheckHelper.getParentAdminStdTypeByBoId(oweParentBoIdSet, cacheModel.getEffectDate());
        this.parentOrgTypeStdIdMap = OrgBatchBillCheckHelper.queryOrgTypeTypeStdIdMap();
        this.billOrgIdTypeStdIdMap = this.assembleOrgIdTypeStdIdMap(cacheModel);
        this.adminLowerOrgIdTypeStdMap = this.queryAdminLowerOrgIdTypestdMap(ownBoIdSet, cacheModel.getEffectDate());
        this.billLowerOrgIdTypeStdMap = this.queryBillLowerOrgIdTypestdMap(cacheModel.getCurrentBillId(), ownOrgIdSet);
        this.adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(buOrgId);
        this.orgIdOrgTypeIdMap = orgIdOrgTypeIdMap;
    }

    private Map<Long, Map<String, String>> assembleOrgIdTypeStdIdMap(OrgBatchCheckCacheModel cacheModel) {
        HashMap<Long, Long> orgIdOrgtypeIdMap = new HashMap<Long, Long>(16);
        for (OrgBatchCheckDto dto2 : cacheModel.getBillOrgList()) {
            if (cacheModel.getCurrentBillId().equals(dto2.getBillId())) continue;
            orgIdOrgtypeIdMap.put(dto2.getOrgId(), dto2.getOrgTypeId());
        }
        Map<Long, Long> orgTypeTypeStdIdMap = OrgBatchBillCheckHelper.queryOrgTypeTypeStdIdMap(orgIdOrgtypeIdMap);
        HashMap<Long, Map<String, String>> orgIdTypeStdIdMap = new HashMap<Long, Map<String, String>>(16);
        for (Map.Entry longLongEntry : orgIdOrgtypeIdMap.entrySet()) {
            Long typeStdId = orgTypeTypeStdIdMap.get(longLongEntry.getValue());
            typeStdId = typeStdId != null ? typeStdId : 0L;
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("typeStdId", typeStdId.toString());
            map.put("billNo", cacheModel.getBillOrgList().stream().filter(dto -> dto.getOrgId().equals(longLongEntry.getKey())).findFirst().get().getBillNo());
            orgIdTypeStdIdMap.put((Long)longLongEntry.getKey(), (Map<String, String>)map);
        }
        return orgIdTypeStdIdMap;
    }

    private Map<Long, Map<Long, Pair<Date, Date>>> queryAdminLowerOrgIdTypestdMap(Set<Long> ownBoIdSet, Date effectDate) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')));
        if (!CollectionUtils.isEmpty(ownBoIdSet)) {
            qFilter.and(new QFilter("parentorg.id", "in", ownBoIdSet));
        }
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id,parentorg,adminorgtype.adminorgtypestd,bsed,bsled", new QFilter[]{qFilter});
        Map<Long, List<DynamicObject>> orgIdToSumMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getLong("parentorg")));
        HashMap<Long, Map<Long, Pair<Date, Date>>> result = new HashMap<Long, Map<Long, Pair<Date, Date>>>();
        try {
            for (Map.Entry<Long, List<DynamicObject>> entry : orgIdToSumMap.entrySet()) {
                Map sunPair = result.getOrDefault(entry.getKey(), new HashMap());
                List<DynamicObject> dyns = entry.getValue();
                for (DynamicObject dyn : dyns) {
                    Date bsled;
                    boolean existsHisInterval = OrgBatchBillCheckHelper.isExistsHisInterval(effectDate, dyn);
                    if (!existsHisInterval) continue;
                    long adminorgtype = dyn.getLong("adminorgtype.adminorgtypestd");
                    Pair typeTimeSpan = sunPair.getOrDefault(adminorgtype, new Pair((Object)HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd"), (Object)new Date(0L)));
                    Date bsed = dyn.getDate("bsed");
                    if (bsed.before((Date)typeTimeSpan.getKey())) {
                        typeTimeSpan.setKey((Object)bsed);
                    }
                    if ((bsled = dyn.getDate("bsled")).after((Date)typeTimeSpan.getValue())) {
                        typeTimeSpan.setValue((Object)bsled);
                    }
                    typeTimeSpan.setKey((Object)effectDate);
                    sunPair.put(adminorgtype, typeTimeSpan);
                }
                result.put(entry.getKey(), sunPair);
            }
        }
        catch (Exception ex) {
            return null;
        }
        return result;
    }

    private Map<Long, Map<Long, Set<String>>> queryBillLowerOrgIdTypestdMap(Long billId, Set<Long> ownOrgIdSet) {
        HRBaseServiceHelper billHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        QFilter auditFilter = new QFilter("billstatus", "in", Arrays.asList("B", "D"));
        DynamicObjectCollection billColl = billHelper.queryOriginalCollection("id,billno", new QFilter[]{auditFilter});
        List billIdList = billColl.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        Map<Long, String> billIdToBillNo = billColl.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("billno")));
        HRBaseServiceHelper entryHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter entryFilter = new QFilter("billid", "in", billIdList);
        entryFilter.and(new QFilter("billid", "<>", (Object)billId));
        entryFilter.and(new QFilter("parentorg.id", "in", ownOrgIdSet));
        DynamicObject[] dynamicObjects = entryHelper.loadDynamicObjectArray(new QFilter[]{entryFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        for (Long org : ownOrgIdSet) {
            Map typeStdToBillNo = result.getOrDefault(org, new HashMap());
            for (DynamicObject dy2 : dynamicObjects) {
                if (!org.equals(dy2.getLong("parentorg.id"))) continue;
                long typeStd = dy2.getLong("adminorgtype.adminorgtypestd.id");
                Set set = typeStdToBillNo.getOrDefault(typeStd, new HashSet());
                set.add(billIdToBillNo.get(dy2.getLong("billid")));
                typeStdToBillNo.put(typeStd, set);
            }
            result.put(org, typeStdToBillNo);
        }
        return result;
    }
}

