/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.util.NameSeparatorTipsUtil;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgBatchNameCheckServiceImpl
implements IOrgBatchBillCheckService {
    private OrgBatchCheckCacheModel cacheModel;
    private Map<String, String> multiNameMap;
    private Map<String, List<DynamicObject>> adminOrgMap;
    private List<String> ownRepeatComboKeySet = Lists.newArrayListWithCapacity((int)10);
    private Map<String, String> billComboKeyMap = Maps.newHashMapWithExpectedSize((int)10);
    private Map<Long, String> billIdToBillNo;
    private PatternUtil patternUtil = new PatternUtil();
    private NameSeparatorTipsUtil nameSeparatorTipsUtil = new NameSeparatorTipsUtil();

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        this.cacheModel = cacheModel;
        this.initParam();
        Map<String, String> multiEntryNameMap = OrgBatchBillCheckHelper.assembleMultiEntryName();
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        List<String> entryKeys = EntryEntityEnum.getEntryKeys();
        for (String entryKey : entryKeys) {
            if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.disableEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.mergeEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.splitEntry.getEntryKey())) continue;
            String entryName = multiEntryNameMap.get(entryKey);
            DynamicObjectCollection orgColl = targetObject.getDynamicObjectCollection(entryKey);
            for (DynamicObject dynamicObject : orgColl) {
                this.checkOrgName(entryKey, entryName, dynamicObject, result);
            }
        }
        return result;
    }

    private void checkOrgName(String entryKey, String entryName, DynamicObject dynamicObject, List<CalibratorBean> result) {
        Long parentBoId = dynamicObject.getLong("parentorg.boid");
        Long parentOrgId = dynamicObject.getLong("parentorg.id");
        String parentOrgName = dynamicObject.getString("parentorg.name");
        OrmLocaleValue nameOrm = (OrmLocaleValue)dynamicObject.get("name");
        for (Map.Entry entry : nameOrm.entrySet()) {
            String billMultiNameKey;
            String key = (String)entry.getKey();
            String orgName = (String)entry.getValue();
            if (!this.multiNameMap.containsKey(key) || HRStringUtils.isEmpty((String)orgName)) continue;
            String originalName = null;
            if (dynamicObject.get("adminorg") != null) {
                originalName = dynamicObject.getString("adminorg.name");
            }
            String displayLanguage = this.multiNameMap.get(key);
            String adminMultiNameKey = OrgBatchBillCheckHelper.generateMultiNameComboKey(parentBoId, key, orgName);
            String ownMultiNameKey = OrgBatchBillCheckHelper.generateMultiNameComboKey(parentOrgId, key, orgName);
            CalibratorBean bean = new CalibratorBean("OrgBatchNameCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u201c%3$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%3$s\u201d\u540d\u79f0\u201c%4$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchNameCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : orgName, parentOrgName, displayLanguage, orgName});
            List nameDys = this.adminOrgMap.getOrDefault(adminMultiNameKey, new ArrayList());
            AdminNameCheckParam adminNameCheckParam = this.isExistsAdminName(dynamicObject, nameDys);
            if (adminNameCheckParam.isExists()) {
                result.add(new CalibratorBean("OrgBatchNameCheckServiceImpl_4", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u5728\u201c%3$s\u201d\u671f\u95f4,\u201c%4$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%5$s\u201d\u540d\u79f0\u201c%6$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchNameCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : orgName, OrgBatchBillCheckHelper.getTimeSpan(adminNameCheckParam.getStartTime(), adminNameCheckParam.getEndTime()), parentOrgName, displayLanguage, orgName}));
            }
            if (this.ownRepeatComboKeySet.contains(ownMultiNameKey)) {
                result.add(bean);
            }
            if (this.billComboKeyMap.containsKey(billMultiNameKey = OrgBatchBillCheckHelper.generateMultiNameComboKey(parentOrgId, key, orgName))) {
                result.add(new CalibratorBean("OrgBatchNameCheckServiceImpl_2", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u5728\u9014\u5355\u636e\u201c%3$s\u201d\u4e2d\u201c%4$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%5$s\u201d\u540d\u79f0\u201c%6$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchNameCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : orgName, this.billComboKeyMap.get(billMultiNameKey), parentOrgName, displayLanguage, orgName}));
            }
            if (!this.patternUtil.validName4Config(orgName)) continue;
            result.add(new CalibratorBean("OrgBatchNameCheckServiceImpl_3", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u201c%3$s\u201d\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08%4$s\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchNameCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : orgName, displayLanguage, this.nameSeparatorTipsUtil.getAllSeparator()}));
        }
    }

    private Map<String, List<DynamicObject>> queryAdminOrgMap(Set<Long> parentBoIdSet, Set<Long> boIdSet) {
        QFilter parentFilter = new QFilter("parentorg", "in", parentBoIdSet);
        parentFilter.and(new QFilter("boid", "not in", boIdSet));
        parentFilter.and(new QFilter("enable", "=", (Object)"1"));
        parentFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject[] adminOrgArr = adminHelper.query("id,name,parentorg,bsed,bsled", new QFilter[]{parentFilter});
        HashMap keyDysMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy : adminOrgArr) {
            long parentOrgId = dy.getLong("parentorg.id");
            OrmLocaleValue nameOrm = (OrmLocaleValue)dy.get("name");
            for (String ormKey : nameOrm.keySet()) {
                String multiNameKey = OrgBatchBillCheckHelper.generateMultiNameComboKey(parentOrgId, ormKey, nameOrm.get((Object)ormKey));
                List dyList = keyDysMap.getOrDefault(multiNameKey, new ArrayList());
                dyList.add(dy);
                keyDysMap.put(multiNameKey, dyList);
            }
        }
        return keyDysMap;
    }

    public DynamicObject[] queryBillOrgArr(Set<Long> parentOrgIdSet) {
        HRBaseServiceHelper billHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        QFilter auditFilter = new QFilter("billstatus", "in", Arrays.asList("B", "D"));
        DynamicObjectCollection billColl = billHelper.queryOriginalCollection("id,billno", new QFilter[]{auditFilter});
        List billIdList = billColl.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        this.billIdToBillNo = billColl.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("billno")));
        HRBaseServiceHelper entryHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter entryFilter = new QFilter("billid", "in", billIdList);
        entryFilter.and(new QFilter("parentorg", "in", parentOrgIdSet));
        return entryHelper.query("id,billid,adminorg,parentorg,name", new QFilter[]{entryFilter});
    }

    private AdminNameCheckParam isExistsAdminName(DynamicObject dynamicObject, List<DynamicObject> nameDys) {
        Date checkDate = this.cacheModel.getEffectDate();
        long changeType = dynamicObject.getLong("changetype.id");
        if (changeType == OrgBatchChgBillConstants.CHANGE_TYPE_ADD) {
            checkDate = dynamicObject.getDate("establishmentdate");
        }
        for (DynamicObject dy : nameDys) {
            boolean isExists = OrgBatchBillCheckHelper.isExistsHisInterval(checkDate, dy);
            if (!isExists) continue;
            return new AdminNameCheckParam(checkDate, dy.getDate("bsled"), true);
        }
        return new AdminNameCheckParam(null, null, false);
    }

    private void initParam() {
        this.multiNameMap = OrgBatchBillCheckHelper.assembleMultiName();
        List<OrgBatchCheckDto> ownEnableOrgList = this.cacheModel.getOwnEnableOrgList();
        int ownEnableSize = ownEnableOrgList.size();
        HashSet parentBoIdSet = Sets.newHashSetWithExpectedSize((int)ownEnableSize);
        HashSet parentOrgIdSet = Sets.newHashSetWithExpectedSize((int)ownEnableSize);
        HashSet boIdSet = Sets.newHashSetWithExpectedSize((int)ownEnableSize);
        HashSet orgIdSet = Sets.newHashSetWithExpectedSize((int)ownEnableSize);
        ArrayList ownComboKeyList = Lists.newArrayListWithCapacity((int)ownEnableSize);
        for (OrgBatchCheckDto dto : ownEnableOrgList) {
            String multiNameKey;
            parentBoIdSet.add(dto.getParentOrgBoId());
            parentOrgIdSet.add(dto.getParentOrgId());
            boIdSet.add(dto.getOrgBoId());
            orgIdSet.add(dto.getOrgId());
            Object orgNameObj = dto.getOrgNameObj();
            if (orgNameObj instanceof OrmLocaleValue) {
                OrmLocaleValue nameOrm = (OrmLocaleValue)orgNameObj;
                for (Map.Entry entry : nameOrm.entrySet()) {
                    multiNameKey = OrgBatchBillCheckHelper.generateMultiNameComboKey(dto.getParentOrgId(), (String)entry.getKey(), (String)entry.getValue());
                    ownComboKeyList.add(multiNameKey);
                }
                continue;
            }
            if (!(orgNameObj instanceof Map)) continue;
            LinkedHashMap nameMap = (LinkedHashMap)orgNameObj;
            for (Map.Entry entry : nameMap.entrySet()) {
                multiNameKey = OrgBatchBillCheckHelper.generateMultiNameComboKey(dto.getParentOrgId(), (String)entry.getKey(), (String)entry.getValue());
                ownComboKeyList.add(multiNameKey);
            }
        }
        this.adminOrgMap = this.queryAdminOrgMap(parentBoIdSet, boIdSet);
        ownComboKeyList.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((k, v) -> {
            if (v > 1L) {
                this.ownRepeatComboKeySet.add((String)k);
            }
        });
        DynamicObject[] billOrgArr = this.queryBillOrgArr(parentOrgIdSet);
        Arrays.stream(billOrgArr).filter(dy -> !this.cacheModel.getCurrentBillId().equals(dy.getLong("billId"))).filter(dy -> !orgIdSet.contains(dy.getLong("adminorg.id"))).forEach(dy -> {
            Set<String> comboKeys = OrgBatchBillCheckHelper.assembleMultiNameComboKey(dy);
            comboKeys.forEach(key -> this.billComboKeyMap.put((String)key, this.billIdToBillNo.get(dy.getLong("billid"))));
        });
    }

    private static class AdminNameCheckParam {
        private Date startTime;
        private Date endTime;
        private boolean isExists;

        public AdminNameCheckParam(Date startTime, Date endTime, boolean isExists) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.isExists = isExists;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public boolean isExists() {
            return this.isExists;
        }

        public void setExists(boolean exists) {
            this.isExists = exists;
        }
    }
}

